"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizers = exports.IamAuthorizer = exports.NoneAuthorizer = exports.CustomAuthorizer = exports.CustomAuthorizerType = exports.CognitoAuthorizer = exports.Authorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const constants_1 = require("../prepare-spec-event-handler/constants");
/**
 * An authorizer for authorizing API requests
 */
class Authorizer {
    constructor(props) {
        this.authorizerId = props.authorizerId;
        this.authorizationType = props.authorizationType;
        this.authorizationScopes = props.authorizationScopes;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Authorizer[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizer", version: "0.19.36" };
exports.Authorizer = Authorizer;
/**
 * An authorizer that uses Cognito identity or access tokens.
 */
class CognitoAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.COGNITO,
            authorizationScopes: props.authorizationScopes,
        });
        this.userPools = props.userPools;
    }
    /**
     * Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ
     * on a per-operation basis
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     * @param authorizationScopes the scopes to apply
     */
    withScopes(...authorizationScopes) {
        return new CognitoAuthorizer({
            authorizerId: this.authorizerId,
            userPools: this.userPools,
            authorizationScopes,
        });
    }
}
_b = JSII_RTTI_SYMBOL_1;
CognitoAuthorizer[_b] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer", version: "0.19.36" };
exports.CognitoAuthorizer = CognitoAuthorizer;
/**
 * The type of custom authorizer
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
 */
var CustomAuthorizerType;
(function (CustomAuthorizerType) {
    /**
     * A custom authorizer that uses a Lambda function.
     */
    CustomAuthorizerType["TOKEN"] = "token";
    /**
     * An authorizer that uses a Lambda function using incoming request parameters.
     */
    CustomAuthorizerType["REQUEST"] = "request";
})(CustomAuthorizerType = exports.CustomAuthorizerType || (exports.CustomAuthorizerType = {}));
// The default time to cache the custom authorizer result
const DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS = 300;
/**
 * An authorizer that uses a lambda function to authorize requests
 */
class CustomAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.CUSTOM,
        });
        this.function = props.function;
        this.type = props.type ?? CustomAuthorizerType.TOKEN;
        this.identitySource =
            props.identitySource ?? "method.request.header.Authorization";
        this.authorizerResultTtlInSeconds =
            props.authorizerResultTtlInSeconds ??
                DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS;
    }
}
_c = JSII_RTTI_SYMBOL_1;
CustomAuthorizer[_c] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer", version: "0.19.36" };
exports.CustomAuthorizer = CustomAuthorizer;
/**
 * No authorizer
 */
class NoneAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: constants_1.DefaultAuthorizerIds.NONE,
            authorizationType: aws_apigateway_1.AuthorizationType.NONE,
        });
    }
}
_d = JSII_RTTI_SYMBOL_1;
NoneAuthorizer[_d] = { fqn: "@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer", version: "0.19.36" };
exports.NoneAuthorizer = NoneAuthorizer;
/**
 * An IAM authorizer
 */
class IamAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: constants_1.DefaultAuthorizerIds.IAM,
            authorizationType: aws_apigateway_1.AuthorizationType.IAM,
        });
    }
}
_e = JSII_RTTI_SYMBOL_1;
IamAuthorizer[_e] = { fqn: "@aws-prototyping-sdk/open-api-gateway.IamAuthorizer", version: "0.19.36" };
exports.IamAuthorizer = IamAuthorizer;
/**
 * Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct
 */
class Authorizers {
    /**
     * An IAM authorizer which uses AWS signature version 4 to authorize requests
     */
    static iam() {
        return new IamAuthorizer();
    }
    /**
     * No authorizer
     */
    static none() {
        return new NoneAuthorizer();
    }
    /**
     * A Cognito User Pools authorizer
     */
    static cognito(props) {
        return new CognitoAuthorizer(props);
    }
    /**
     * A custom authorizer
     */
    static custom(props) {
        return new CustomAuthorizer(props);
    }
}
_f = JSII_RTTI_SYMBOL_1;
Authorizers[_f] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizers", version: "0.19.36" };
exports.Authorizers = Authorizers;
//# sourceMappingURL=data:application/json;base64,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