# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### OpenApiGatewayRestApi <a name="OpenApiGatewayRestApi" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi"></a>

A construct for creating an api gateway rest api based on the definition in the OpenAPI spec.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer"></a>

```typescript
import { OpenApiGatewayRestApi } from '@aws-prototyping-sdk/open-api-gateway'

new OpenApiGatewayRestApi(scope: Construct, id: string, props: OpenApiGatewayRestApiProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps">OpenApiGatewayRestApiProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps">OpenApiGatewayRestApiProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct"></a>

```typescript
import { OpenApiGatewayRestApi } from '@aws-prototyping-sdk/open-api-gateway'

OpenApiGatewayRestApi.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.api">api</a></code> | <code>aws-cdk-lib.aws_apigateway.SpecRestApi</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.ipSet">ipSet</a></code> | <code>aws-cdk-lib.aws_wafv2.CfnIPSet</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAcl">webAcl</a></code> | <code>aws-cdk-lib.aws_wafv2.CfnWebACL</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAclAssociation">webAclAssociation</a></code> | <code>aws-cdk-lib.aws_wafv2.CfnWebACLAssociation</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.api"></a>

```typescript
public readonly api: SpecRestApi;
```

- *Type:* aws-cdk-lib.aws_apigateway.SpecRestApi

---

##### `ipSet`<sup>Optional</sup> <a name="ipSet" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.ipSet"></a>

```typescript
public readonly ipSet: CfnIPSet;
```

- *Type:* aws-cdk-lib.aws_wafv2.CfnIPSet

---

##### `webAcl`<sup>Optional</sup> <a name="webAcl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAcl"></a>

```typescript
public readonly webAcl: CfnWebACL;
```

- *Type:* aws-cdk-lib.aws_wafv2.CfnWebACL

---

##### `webAclAssociation`<sup>Optional</sup> <a name="webAclAssociation" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAclAssociation"></a>

```typescript
public readonly webAclAssociation: CfnWebACLAssociation;
```

- *Type:* aws-cdk-lib.aws_wafv2.CfnWebACLAssociation

---


## Structs <a name="Structs" id="Structs"></a>

### ApiGatewayIntegration <a name="ApiGatewayIntegration" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration"></a>

Represents an api gateway integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.Initializer"></a>

```typescript
import { ApiGatewayIntegration } from '@aws-prototyping-sdk/open-api-gateway'

const apiGatewayIntegration: ApiGatewayIntegration = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheKeyParameters">cacheKeyParameters</a></code> | <code>string[]</code> | A list of request parameters whose values are to be cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheNamespace">cacheNamespace</a></code> | <code>string</code> | An API-specific tag group of related cached parameters. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionId">connectionId</a></code> | <code>string</code> | The ID of a VpcLink for the private integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionType">connectionType</a></code> | <code>string</code> | The integration connection type. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.contentHandling">contentHandling</a></code> | <code>string</code> | Request payload encoding conversion types. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.credentials">credentials</a></code> | <code>string</code> | For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.httpMethod">httpMethod</a></code> | <code>string</code> | The HTTP method used in the integration request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.passthroughBehavior">passthroughBehavior</a></code> | <code>string</code> | Specifies how a request payload of unmapped content type is passed through the integration request without modification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestParameters">requestParameters</a></code> | <code>{[ key: string ]: string}</code> | Specifies mappings from method request parameters to integration request parameters. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestTemplates">requestTemplates</a></code> | <code>{[ key: string ]: string}</code> | Mapping templates for a request payload of specified MIME types. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.responses">responses</a></code> | <code>{[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse">ApiGatewayIntegrationResponse</a>}</code> | Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.timeoutInMillis">timeoutInMillis</a></code> | <code>number</code> | Custom timeout between 50 and 29,000 milliseconds. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.tlsConfig">tlsConfig</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig">ApiGatewayIntegrationTlsConfig</a></code> | Specifies the TLS configuration for an integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.type">type</a></code> | <code>string</code> | The type of integration with the specified backend. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.uri">uri</a></code> | <code>string</code> | The endpoint URI of the backend. |

---

##### `cacheKeyParameters`<sup>Optional</sup> <a name="cacheKeyParameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheKeyParameters"></a>

```typescript
public readonly cacheKeyParameters: string[];
```

- *Type:* string[]

A list of request parameters whose values are to be cached.

---

##### `cacheNamespace`<sup>Optional</sup> <a name="cacheNamespace" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheNamespace"></a>

```typescript
public readonly cacheNamespace: string;
```

- *Type:* string

An API-specific tag group of related cached parameters.

---

##### `connectionId`<sup>Optional</sup> <a name="connectionId" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionId"></a>

```typescript
public readonly connectionId: string;
```

- *Type:* string

The ID of a VpcLink for the private integration.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html](https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html)

---

##### `connectionType`<sup>Optional</sup> <a name="connectionType" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionType"></a>

```typescript
public readonly connectionType: string;
```

- *Type:* string

The integration connection type.

The valid value is "VPC_LINK" for private integration or "INTERNET", otherwise.

---

##### `contentHandling`<sup>Optional</sup> <a name="contentHandling" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.contentHandling"></a>

```typescript
public readonly contentHandling: string;
```

- *Type:* string

Request payload encoding conversion types.

Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
base64-decoded blob or passing through a binary payload natively without modification.

---

##### `credentials`<sup>Optional</sup> <a name="credentials" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.credentials"></a>

```typescript
public readonly credentials: string;
```

- *Type:* string

For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role.

If unspecified, credentials default
to resource-based permissions that must be added manually to allow the API to access the resource. For more
information, see Granting Permissions Using a Resource Policy.

Note: When using IAM credentials, make sure that AWS STS Regional endpoints are enabled for the Region where this
API is deployed for best performance.

---

##### `httpMethod`<sup>Optional</sup> <a name="httpMethod" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.httpMethod"></a>

```typescript
public readonly httpMethod: string;
```

- *Type:* string

The HTTP method used in the integration request.

For Lambda function invocations, the value must be POST.

---

##### `passthroughBehavior`<sup>Optional</sup> <a name="passthroughBehavior" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.passthroughBehavior"></a>

```typescript
public readonly passthroughBehavior: string;
```

- *Type:* string

Specifies how a request payload of unmapped content type is passed through the integration request without modification.

Supported values are when_no_templates, when_no_match, and never.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior)

---

##### `requestParameters`<sup>Optional</sup> <a name="requestParameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestParameters"></a>

```typescript
public readonly requestParameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Specifies mappings from method request parameters to integration request parameters.

Supported request parameters
are querystring, path, header, and body.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html)

---

##### `requestTemplates`<sup>Optional</sup> <a name="requestTemplates" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestTemplates"></a>

```typescript
public readonly requestTemplates: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Mapping templates for a request payload of specified MIME types.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html)

---

##### `responses`<sup>Optional</sup> <a name="responses" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.responses"></a>

```typescript
public readonly responses: {[ key: string ]: ApiGatewayIntegrationResponse};
```

- *Type:* {[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse">ApiGatewayIntegrationResponse</a>}

Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html)

---

##### `timeoutInMillis`<sup>Optional</sup> <a name="timeoutInMillis" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.timeoutInMillis"></a>

```typescript
public readonly timeoutInMillis: number;
```

- *Type:* number

Custom timeout between 50 and 29,000 milliseconds.

The default value is 29,000 milliseconds or 29 seconds.

---

##### `tlsConfig`<sup>Optional</sup> <a name="tlsConfig" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.tlsConfig"></a>

```typescript
public readonly tlsConfig: ApiGatewayIntegrationTlsConfig;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig">ApiGatewayIntegrationTlsConfig</a>

Specifies the TLS configuration for an integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.type"></a>

```typescript
public readonly type: string;
```

- *Type:* string

The type of integration with the specified backend.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type)

---

##### `uri`<sup>Optional</sup> <a name="uri" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.uri"></a>

```typescript
public readonly uri: string;
```

- *Type:* string

The endpoint URI of the backend.

For integrations of the aws type, this is an ARN value.
For the HTTP integration, this is the URL of the HTTP endpoint including the https or http scheme.

---

### ApiGatewayIntegrationResponse <a name="ApiGatewayIntegrationResponse" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse"></a>

API Gateway integration response.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.Initializer"></a>

```typescript
import { ApiGatewayIntegrationResponse } from '@aws-prototyping-sdk/open-api-gateway'

const apiGatewayIntegrationResponse: ApiGatewayIntegrationResponse = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseParameters">responseParameters</a></code> | <code>{[ key: string ]: string}</code> | Specifies parameter mappings for the response. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseTemplates">responseTemplates</a></code> | <code>{[ key: string ]: string}</code> | Specifies MIME type-specific mapping templates for the response’s payload. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.statusCode">statusCode</a></code> | <code>string</code> | HTTP status code for the method response. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.contentHandling">contentHandling</a></code> | <code>string</code> | Response payload encoding conversion types. |

---

##### `responseParameters`<sup>Required</sup> <a name="responseParameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseParameters"></a>

```typescript
public readonly responseParameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Specifies parameter mappings for the response.

---

##### `responseTemplates`<sup>Required</sup> <a name="responseTemplates" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseTemplates"></a>

```typescript
public readonly responseTemplates: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Specifies MIME type-specific mapping templates for the response’s payload.

---

##### `statusCode`<sup>Required</sup> <a name="statusCode" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.statusCode"></a>

```typescript
public readonly statusCode: string;
```

- *Type:* string

HTTP status code for the method response.

---

##### `contentHandling`<sup>Optional</sup> <a name="contentHandling" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.contentHandling"></a>

```typescript
public readonly contentHandling: string;
```

- *Type:* string

Response payload encoding conversion types.

Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
base64-decoded blob or passing through a binary payload natively without modification.

---

### ApiGatewayIntegrationTlsConfig <a name="ApiGatewayIntegrationTlsConfig" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig"></a>

Specifies the TLS configuration for an integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.Initializer"></a>

```typescript
import { ApiGatewayIntegrationTlsConfig } from '@aws-prototyping-sdk/open-api-gateway'

const apiGatewayIntegrationTlsConfig: ApiGatewayIntegrationTlsConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.property.insecureSkipVerification">insecureSkipVerification</a></code> | <code>boolean</code> | Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority. |

---

##### `insecureSkipVerification`<sup>Optional</sup> <a name="insecureSkipVerification" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.property.insecureSkipVerification"></a>

```typescript
public readonly insecureSkipVerification: boolean;
```

- *Type:* boolean

Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority.

This isn’t recommended, but it enables you to use certificates that are
signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still
performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and
presence of a root certificate authority. Supported only for HTTP and HTTP_PROXY integrations.

---

### AuthorizerProps <a name="AuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps"></a>

Properties for an authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.Initializer"></a>

```typescript
import { AuthorizerProps } from '@aws-prototyping-sdk/open-api-gateway'

const authorizerProps: AuthorizerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationType">authorizationType</a></code> | <code>aws-cdk-lib.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizerId">authorizerId</a></code> | <code>string</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationType"></a>

```typescript
public readonly authorizationType: AuthorizationType;
```

- *Type:* aws-cdk-lib.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]

Scopes for the authorizer, if any.

---

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.Initializer"></a>

```typescript
import { CidrAllowList } from '@aws-prototyping-sdk/open-api-gateway'

const cidrAllowList: CidrAllowList = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrRanges">cidrRanges</a></code> | <code>string[]</code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrType">cidrType</a></code> | <code>string</code> | Type of CIDR range. |

---

##### `cidrRanges`<sup>Required</sup> <a name="cidrRanges" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrRanges"></a>

```typescript
public readonly cidrRanges: string[];
```

- *Type:* string[]

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidrType`<sup>Required</sup> <a name="cidrType" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrType"></a>

```typescript
public readonly cidrType: string;
```

- *Type:* string

Type of CIDR range.

---

### CognitoAuthorizerProps <a name="CognitoAuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps"></a>

Properties used to configure a cognito authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.Initializer"></a>

```typescript
import { CognitoAuthorizerProps } from '@aws-prototyping-sdk/open-api-gateway'

const cognitoAuthorizerProps: CognitoAuthorizerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizerId">authorizerId</a></code> | <code>string</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.userPools">userPools</a></code> | <code>aws-cdk-lib.aws_cognito.IUserPool[]</code> | The Cognito user pools associated with this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | A list of authorization scopes configured on the method. |

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

Unique identifier for this authorizer.

---

##### `userPools`<sup>Required</sup> <a name="userPools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.userPools"></a>

```typescript
public readonly userPools: IUserPool[];
```

- *Type:* aws-cdk-lib.aws_cognito.IUserPool[]

The Cognito user pools associated with this authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]
- *Default:* []

A list of authorization scopes configured on the method.

When used as the default authorizer, these scopes will be
applied to all methods without an authorizer at the integration level.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

---

### CommonApiProjectOptions <a name="CommonApiProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.Initializer"></a>

```typescript
import { CommonApiProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const commonApiProjectOptions: CommonApiProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

### CustomAuthorizerProps <a name="CustomAuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps"></a>

Properties used to configure a custom authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.Initializer"></a>

```typescript
import { CustomAuthorizerProps } from '@aws-prototyping-sdk/open-api-gateway'

const customAuthorizerProps: CustomAuthorizerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerId">authorizerId</a></code> | <code>string</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.function">function</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerResultTtlInSeconds">authorizerResultTtlInSeconds</a></code> | <code>number</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.identitySource">identitySource</a></code> | <code>string</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

Unique identifier for this authorizer.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.function"></a>

```typescript
public readonly function: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

The lambda function used to authorize requests.

---

##### `authorizerResultTtlInSeconds`<sup>Optional</sup> <a name="authorizerResultTtlInSeconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerResultTtlInSeconds"></a>

```typescript
public readonly authorizerResultTtlInSeconds: number;
```

- *Type:* number
- *Default:* 300

The number of seconds during which the authorizer result is cached.

---

##### `identitySource`<sup>Optional</sup> <a name="identitySource" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.identitySource"></a>

```typescript
public readonly identitySource: string;
```

- *Type:* string
- *Default:* "method.request.header.Authorization"

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.type"></a>

```typescript
public readonly type: CustomAuthorizerType;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>
- *Default:* CustomAuthorizerType.TOKEN

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---

### IntegrationGrantProps <a name="IntegrationGrantProps" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps"></a>

Properties for granting the API access to invoke the operation.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.Initializer"></a>

```typescript
import { IntegrationGrantProps } from '@aws-prototyping-sdk/open-api-gateway'

const integrationGrantProps: IntegrationGrantProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.method">method</a></code> | <code>string</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.path">path</a></code> | <code>string</code> | The path of this operation in the api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.api">api</a></code> | <code>aws-cdk-lib.aws_apigateway.SpecRestApi</code> | The api to grant permissions for. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.operationId">operationId</a></code> | <code>string</code> | The ID of the operation for which permissions are being granted. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which permission resources can be created. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.method"></a>

```typescript
public readonly method: string;
```

- *Type:* string

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

The path of this operation in the api.

---

##### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.api"></a>

```typescript
public readonly api: SpecRestApi;
```

- *Type:* aws-cdk-lib.aws_apigateway.SpecRestApi

The api to grant permissions for.

---

##### `operationId`<sup>Required</sup> <a name="operationId" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.operationId"></a>

```typescript
public readonly operationId: string;
```

- *Type:* string

The ID of the operation for which permissions are being granted.

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.scope"></a>

```typescript
public readonly scope: Construct;
```

- *Type:* constructs.Construct

The scope in which permission resources can be created.

---

### IntegrationRenderProps <a name="IntegrationRenderProps" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps"></a>

Properties for rendering an integration into an API Gateway OpenAPI extension.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.Initializer"></a>

```typescript
import { IntegrationRenderProps } from '@aws-prototyping-sdk/open-api-gateway'

const integrationRenderProps: IntegrationRenderProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.method">method</a></code> | <code>string</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.path">path</a></code> | <code>string</code> | The path of this operation in the api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.operationId">operationId</a></code> | <code>string</code> | The ID of the operation being rendered. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which the integration is being rendered. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.method"></a>

```typescript
public readonly method: string;
```

- *Type:* string

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

The path of this operation in the api.

---

##### `operationId`<sup>Required</sup> <a name="operationId" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.operationId"></a>

```typescript
public readonly operationId: string;
```

- *Type:* string

The ID of the operation being rendered.

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.scope"></a>

```typescript
public readonly scope: Construct;
```

- *Type:* constructs.Construct

The scope in which the integration is being rendered.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.Initializer"></a>

```typescript
import { ManagedRule } from '@aws-prototyping-sdk/open-api-gateway'

const managedRule: ManagedRule = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.name">name</a></code> | <code>string</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.vendor">vendor</a></code> | <code>string</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.vendor"></a>

```typescript
public readonly vendor: string;
```

- *Type:* string

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### MethodAndPath <a name="MethodAndPath" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath"></a>

Structure to contain an API operation's method and path.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.Initializer"></a>

```typescript
import { MethodAndPath } from '@aws-prototyping-sdk/open-api-gateway'

const methodAndPath: MethodAndPath = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.method">method</a></code> | <code>string</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.path">path</a></code> | <code>string</code> | The path of this operation in the api. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.method"></a>

```typescript
public readonly method: string;
```

- *Type:* string

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

The path of this operation in the api.

---

### OpenApiGatewayJavaProjectOptions <a name="OpenApiGatewayJavaProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions"></a>

Configuration for the OpenApiGatewayJavaProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.Initializer"></a>

```typescript
import { OpenApiGatewayJavaProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const openApiGatewayJavaProjectOptions: OpenApiGatewayJavaProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.artifactId">artifactId</a></code> | <code>string</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.groupId">groupId</a></code> | <code>string</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.version">version</a></code> | <code>string</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.description">description</a></code> | <code>string</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packaging">packaging</a></code> | <code>string</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.url">url</a></code> | <code>string</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.compileOptions">compileOptions</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.distdir">distdir</a></code> | <code>string</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junit">junit</a></code> | <code>boolean</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junitOptions">junitOptions</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packagingOptions">packagingOptions</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJava">projenrcJava</a></code> | <code>boolean</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.testDeps">testDeps</a></code> | <code>string[]</code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sample">sample</a></code> | <code>boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sampleJavaPackage">sampleJavaPackage</a></code> | <code>string</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.specFile">specFile</a></code> | <code>string</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.artifactId"></a>

```typescript
public readonly artifactId: string;
```

- *Type:* string
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.groupId"></a>

```typescript
public readonly groupId: string;
```

- *Type:* string
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packaging"></a>

```typescript
public readonly packaging: string;
```

- *Type:* string
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.url"></a>

```typescript
public readonly url: string;
```

- *Type:* string
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.compileOptions"></a>

```typescript
public readonly compileOptions: MavenCompileOptions;
```

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.distdir"></a>

```typescript
public readonly distdir: string;
```

- *Type:* string
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junit"></a>

```typescript
public readonly junit: boolean;
```

- *Type:* boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junitOptions"></a>

```typescript
public readonly junitOptions: JunitOptions;
```

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packagingOptions"></a>

```typescript
public readonly packagingOptions: MavenPackagingOptions;
```

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJava"></a>

```typescript
public readonly projenrcJava: boolean;
```

- *Type:* boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJavaOptions"></a>

```typescript
public readonly projenrcJavaOptions: ProjenrcOptions;
```

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.testDeps"></a>

```typescript
public readonly testDeps: string[];
```

- *Type:* string[]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sample"></a>

```typescript
public readonly sample: boolean;
```

- *Type:* boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sampleJavaPackage"></a>

```typescript
public readonly sampleJavaPackage: string;
```

- *Type:* string
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.specFile"></a>

```typescript
public readonly specFile: string;
```

- *Type:* string
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayProjectOptions <a name="OpenApiGatewayProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions"></a>

Options common to all open api gateway projects.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.Initializer"></a>

```typescript
import { OpenApiGatewayProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const openApiGatewayProjectOptions: OpenApiGatewayProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.specFile">specFile</a></code> | <code>string</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.specFile"></a>

```typescript
public readonly specFile: string;
```

- *Type:* string
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayPythonProjectOptions <a name="OpenApiGatewayPythonProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions"></a>

Configuration for the OpenApiGatewayPythonProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.Initializer"></a>

```typescript
import { OpenApiGatewayPythonProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const openApiGatewayPythonProjectOptions: OpenApiGatewayPythonProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.version">version</a></code> | <code>string</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.classifiers">classifiers</a></code> | <code>string[]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.description">description</a></code> | <code>string</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.license">license</a></code> | <code>string</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetryOptions">poetryOptions</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setupConfig">setupConfig</a></code> | <code>{[ key: string ]: any}</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.moduleName">moduleName</a></code> | <code>string</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pip">pip</a></code> | <code>boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetry">poetry</a></code> | <code>boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPython">projenrcPython</a></code> | <code>boolean</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytest">pytest</a></code> | <code>boolean</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytestOptions">pytestOptions</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonExec">pythonExec</a></code> | <code>string</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.sample">sample</a></code> | <code>boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setuptools">setuptools</a></code> | <code>boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venv">venv</a></code> | <code>boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venvOptions">venvOptions</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.specFile">specFile</a></code> | <code>string</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.classifiers"></a>

```typescript
public readonly classifiers: string[];
```

- *Type:* string[]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetryOptions"></a>

```typescript
public readonly poetryOptions: PoetryPyprojectOptionsWithoutDeps;
```

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setupConfig"></a>

```typescript
public readonly setupConfig: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.moduleName"></a>

```typescript
public readonly moduleName: string;
```

- *Type:* string
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pip"></a>

```typescript
public readonly pip: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetry"></a>

```typescript
public readonly poetry: boolean;
```

- *Type:* boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPython"></a>

```typescript
public readonly projenrcPython: boolean;
```

- *Type:* boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPythonOptions"></a>

```typescript
public readonly projenrcPythonOptions: ProjenrcOptions;
```

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcTsOptions;
```

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytest"></a>

```typescript
public readonly pytest: boolean;
```

- *Type:* boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytestOptions"></a>

```typescript
public readonly pytestOptions: PytestOptions;
```

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `pythonExec`<sup>Optional</sup> <a name="pythonExec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonExec"></a>

```typescript
public readonly pythonExec: string;
```

- *Type:* string
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.sample"></a>

```typescript
public readonly sample: boolean;
```

- *Type:* boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setuptools"></a>

```typescript
public readonly setuptools: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venv"></a>

```typescript
public readonly venv: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venvOptions"></a>

```typescript
public readonly venvOptions: VenvOptions;
```

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.specFile"></a>

```typescript
public readonly specFile: string;
```

- *Type:* string
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayRestApiProps <a name="OpenApiGatewayRestApiProps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps"></a>

Configuration for the OpenApiGatewayRestApi construct.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.Initializer"></a>

```typescript
import { OpenApiGatewayRestApiProps } from '@aws-prototyping-sdk/open-api-gateway'

const openApiGatewayRestApiProps: OpenApiGatewayRestApiProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.cloudWatchRole">cloudWatchRole</a></code> | <code>boolean</code> | Automatically configure an AWS CloudWatch role for API Gateway. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deploy">deploy</a></code> | <code>boolean</code> | Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deployOptions">deployOptions</a></code> | <code>aws-cdk-lib.aws_apigateway.StageOptions</code> | Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.description">description</a></code> | <code>string</code> | A description of the RestApi construct. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.disableExecuteApiEndpoint">disableExecuteApiEndpoint</a></code> | <code>boolean</code> | Specifies whether clients can invoke the API using the default execute-api endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.domainName">domainName</a></code> | <code>aws-cdk-lib.aws_apigateway.DomainNameOptions</code> | Configure a custom domain name and map it to this API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointExportName">endpointExportName</a></code> | <code>string</code> | Export name for the CfnOutput containing the API endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointTypes">endpointTypes</a></code> | <code>aws-cdk-lib.aws_apigateway.EndpointType[]</code> | A list of the endpoint types of the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.failOnWarnings">failOnWarnings</a></code> | <code>boolean</code> | Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.parameters">parameters</a></code> | <code>{[ key: string ]: string}</code> | Custom header parameters for the request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_iam.PolicyDocument</code> | A policy document that contains the permissions for this RestApi. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.restApiName">restApiName</a></code> | <code>string</code> | A name for the API Gateway RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.retainDeployments">retainDeployments</a></code> | <code>boolean</code> | Retains old deployment resources when the API changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.integrations">integrations</a></code> | <code>{[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>}</code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.operationLookup">operationLookup</a></code> | <code>{[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>}</code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.corsOptions">corsOptions</a></code> | <code>aws-cdk-lib.aws_apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.defaultAuthorizer">defaultAuthorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.spec">spec</a></code> | <code>any</code> | The parsed OpenAPI specification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.specPath">specPath</a></code> | <code>string</code> | Path to the JSON open api spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.webAclOptions">webAclOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a></code> | Options for the AWS WAF v2 WebACL associated with the api. |

---

##### `cloudWatchRole`<sup>Optional</sup> <a name="cloudWatchRole" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.cloudWatchRole"></a>

```typescript
public readonly cloudWatchRole: boolean;
```

- *Type:* boolean
- *Default:* false if `@aws-cdk/aws-apigateway:disableCloudWatchRole` is enabled, true otherwise

Automatically configure an AWS CloudWatch role for API Gateway.

---

##### `deploy`<sup>Optional</sup> <a name="deploy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deploy"></a>

```typescript
public readonly deploy: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

Since API Gateway deployments are immutable, When this option is enabled
(by default), an AWS::ApiGateway::Deployment resource will automatically
created with a logical ID that hashes the API model (methods, resources
and options). This means that when the model changes, the logical ID of
this CloudFormation resource will change, and a new deployment will be
created.

If this is set, `latestDeployment` will refer to the `Deployment` object
and `deploymentStage` will refer to a `Stage` that points to this
deployment. To customize the stage options, use the `deployOptions`
property.

A CloudFormation Output will also be defined with the root URL endpoint
of this REST API.

---

##### `deployOptions`<sup>Optional</sup> <a name="deployOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deployOptions"></a>

```typescript
public readonly deployOptions: StageOptions;
```

- *Type:* aws-cdk-lib.aws_apigateway.StageOptions
- *Default:* Based on defaults of `StageOptions`.

Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.

If `deploy` is disabled,
this value cannot be set.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string
- *Default:* 'Automatically created by the RestApi construct'

A description of the RestApi construct.

---

##### `disableExecuteApiEndpoint`<sup>Optional</sup> <a name="disableExecuteApiEndpoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.disableExecuteApiEndpoint"></a>

```typescript
public readonly disableExecuteApiEndpoint: boolean;
```

- *Type:* boolean
- *Default:* false

Specifies whether clients can invoke the API using the default execute-api endpoint.

To require that clients use a custom domain name to invoke the
API, disable the default endpoint.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html)

---

##### `domainName`<sup>Optional</sup> <a name="domainName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.domainName"></a>

```typescript
public readonly domainName: DomainNameOptions;
```

- *Type:* aws-cdk-lib.aws_apigateway.DomainNameOptions
- *Default:* no domain name is defined, use `addDomainName` or directly define a `DomainName`.

Configure a custom domain name and map it to this API.

---

##### `endpointExportName`<sup>Optional</sup> <a name="endpointExportName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointExportName"></a>

```typescript
public readonly endpointExportName: string;
```

- *Type:* string
- *Default:* when no export name is given, output will be created without export

Export name for the CfnOutput containing the API endpoint.

---

##### `endpointTypes`<sup>Optional</sup> <a name="endpointTypes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointTypes"></a>

```typescript
public readonly endpointTypes: EndpointType[];
```

- *Type:* aws-cdk-lib.aws_apigateway.EndpointType[]
- *Default:* EndpointType.EDGE

A list of the endpoint types of the API.

Use this property when creating
an API.

---

##### `failOnWarnings`<sup>Optional</sup> <a name="failOnWarnings" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.failOnWarnings"></a>

```typescript
public readonly failOnWarnings: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.parameters"></a>

```typescript
public readonly parameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* No parameters.

Custom header parameters for the request.

> [https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html](https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html)

---

##### `policy`<sup>Optional</sup> <a name="policy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.policy"></a>

```typescript
public readonly policy: PolicyDocument;
```

- *Type:* aws-cdk-lib.aws_iam.PolicyDocument
- *Default:* No policy.

A policy document that contains the permissions for this RestApi.

---

##### `restApiName`<sup>Optional</sup> <a name="restApiName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.restApiName"></a>

```typescript
public readonly restApiName: string;
```

- *Type:* string
- *Default:* ID of the RestApi construct.

A name for the API Gateway RestApi resource.

---

##### `retainDeployments`<sup>Optional</sup> <a name="retainDeployments" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.retainDeployments"></a>

```typescript
public readonly retainDeployments: boolean;
```

- *Type:* boolean
- *Default:* false

Retains old deployment resources when the API changes.

This allows
manually reverting stages to point to old deployments via the AWS
Console.

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.integrations"></a>

```typescript
public readonly integrations: {[ key: string ]: OpenApiIntegration};
```

- *Type:* {[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>}

A mapping of API operation to its integration.

---

##### `operationLookup`<sup>Required</sup> <a name="operationLookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.operationLookup"></a>

```typescript
public readonly operationLookup: {[ key: string ]: MethodAndPath};
```

- *Type:* {[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>}

Details about each operation.

---

##### `corsOptions`<sup>Optional</sup> <a name="corsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.corsOptions"></a>

```typescript
public readonly corsOptions: CorsOptions;
```

- *Type:* aws-cdk-lib.aws_apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `defaultAuthorizer`<sup>Optional</sup> <a name="defaultAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.defaultAuthorizer"></a>

```typescript
public readonly defaultAuthorizer: Authorizer;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

##### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.spec"></a>

```typescript
public readonly spec: any;
```

- *Type:* any

The parsed OpenAPI specification.

---

##### `specPath`<sup>Required</sup> <a name="specPath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.specPath"></a>

```typescript
public readonly specPath: string;
```

- *Type:* string

Path to the JSON open api spec.

---

##### `webAclOptions`<sup>Optional</sup> <a name="webAclOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.webAclOptions"></a>

```typescript
public readonly webAclOptions: OpenApiGatewayWebAclOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a>

Options for the AWS WAF v2 WebACL associated with the api.

By default, a Web ACL with the AWS default managed
rule set will be associated with the API. These options may disable or override the defaults.

---

### OpenApiGatewayTsProjectOptions <a name="OpenApiGatewayTsProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions"></a>

Configuration for the OpenApiGatewayTsProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.Initializer"></a>

```typescript
import { OpenApiGatewayTsProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const openApiGatewayTsProjectOptions: OpenApiGatewayTsProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>boolean</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorUrl">authorUrl</a></code> | <code>string</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bin">bin</a></code> | <code>{[ key: string ]: string}</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>string</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>string</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>string[]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.description">description</a></code> | <code>string</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>string</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.keywords">keywords</a></code> | <code>string[]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.license">license</a></code> | <code>string</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.licensed">licensed</a></code> | <code>boolean</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmAccess">npmAccess</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>string</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>string</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>string</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDeps">peerDeps</a></code> | <code>string[]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>string</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repository">repository</a></code> | <code>string</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>string</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>projen.javascript.ScopedPackagesOptions[]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scripts">scripts</a></code> | <code>{[ key: string ]: string}</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stability">stability</a></code> | <code>string</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>string</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.majorVersion">majorVersion</a></code> | <code>number</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>number</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>string</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prerelease">prerelease</a></code> | <code>string</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishTasks">publishTasks</a></code> | <code>boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>{[ key: string ]: projen.release.BranchOptions}</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>string</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>string</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>string</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>string</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>{[ key: string ]: any}</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>string</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>string[]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>string</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCov">codeCov</a></code> | <code>boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>string</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>string</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>string</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabot">dependabot</a></code> | <code>boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitignore">gitignore</a></code> | <code>string[]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jest">jest</a></code> | <code>boolean</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jestOptions">jestOptions</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignore">npmignore</a></code> | <code>string[]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.package">package</a></code> | <code>boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettier">prettier</a></code> | <code>boolean</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenVersion">projenVersion</a></code> | <code>string</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>boolean</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>string[]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.release">release</a></code> | <code>boolean</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>string</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowPackageCache">workflowPackageCache</a></code> | <code>boolean</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docgen">docgen</a></code> | <code>boolean</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>string</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslint">eslint</a></code> | <code>boolean</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.libdir">libdir</a></code> | <code>string</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.sampleCode">sampleCode</a></code> | <code>boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.srcdir">srcdir</a></code> | <code>string</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.testdir">testdir</a></code> | <code>string</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>string</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>string</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.specFile">specFile</a></code> | <code>string</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.allowLibraryDependencies"></a>

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorOrganization"></a>

```typescript
public readonly authorOrganization: boolean;
```

- *Type:* boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorUrl"></a>

```typescript
public readonly authorUrl: string;
```

- *Type:* string

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoDetectBin"></a>

```typescript
public readonly autoDetectBin: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bin"></a>

```typescript
public readonly bin: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsEmail"></a>

```typescript
public readonly bugsEmail: string;
```

- *Type:* string

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsUrl"></a>

```typescript
public readonly bugsUrl: string;
```

- *Type:* string

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundledDeps"></a>

```typescript
public readonly bundledDeps: string[];
```

- *Type:* string[]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeArtifactOptions"></a>

```typescript
public readonly codeArtifactOptions: CodeArtifactOptions;
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypoint"></a>

```typescript
public readonly entrypoint: string;
```

- *Type:* string
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.keywords"></a>

```typescript
public readonly keywords: string[];
```

- *Type:* string[]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.licensed"></a>

```typescript
public readonly licensed: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.maxNodeVersion"></a>

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minNodeVersion"></a>

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmAccess"></a>

```typescript
public readonly npmAccess: NpmAccess;
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```typescript
public readonly npmRegistry: string;
```

- *Type:* string

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistryUrl"></a>

```typescript
public readonly npmRegistryUrl: string;
```

- *Type:* string
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmTokenSecret"></a>

```typescript
public readonly npmTokenSecret: string;
```

- *Type:* string
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageManager"></a>

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDependencyOptions"></a>

```typescript
public readonly peerDependencyOptions: PeerDependencyOptions;
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDeps"></a>

```typescript
public readonly peerDeps: string[];
```

- *Type:* string[]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pnpmVersion"></a>

```typescript
public readonly pnpmVersion: string;
```

- *Type:* string
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repository"></a>

```typescript
public readonly repository: string;
```

- *Type:* string

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repositoryDirectory"></a>

```typescript
public readonly repositoryDirectory: string;
```

- *Type:* string

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scopedPackagesOptions"></a>

```typescript
public readonly scopedPackagesOptions: ScopedPackagesOptions[];
```

- *Type:* projen.javascript.ScopedPackagesOptions[]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```typescript
public readonly scripts: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stability"></a>

```typescript
public readonly stability: string;
```

- *Type:* string

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jsiiReleaseVersion"></a>

```typescript
public readonly jsiiReleaseVersion: string;
```

- *Type:* string
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.majorVersion"></a>

```typescript
public readonly majorVersion: number;
```

- *Type:* number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minMajorVersion"></a>

```typescript
public readonly minMajorVersion: number;
```

- *Type:* number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmDistTag"></a>

```typescript
public readonly npmDistTag: string;
```

- *Type:* string
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.postBuildSteps"></a>

```typescript
public readonly postBuildSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prerelease"></a>

```typescript
public readonly prerelease: string;
```

- *Type:* string
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishDryRun"></a>

```typescript
public readonly publishDryRun: boolean;
```

- *Type:* boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishTasks"></a>

```typescript
public readonly publishTasks: boolean;
```

- *Type:* boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseBranches"></a>

```typescript
public readonly releaseBranches: {[ key: string ]: BranchOptions};
```

- *Type:* {[ key: string ]: projen.release.BranchOptions}
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```typescript
public readonly releaseEveryCommit: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssue"></a>

```typescript
public readonly releaseFailureIssue: boolean;
```

- *Type:* boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssueLabel"></a>

```typescript
public readonly releaseFailureIssueLabel: string;
```

- *Type:* string
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```typescript
public readonly releaseSchedule: string;
```

- *Type:* string
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTagPrefix"></a>

```typescript
public readonly releaseTagPrefix: string;
```

- *Type:* string
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTrigger"></a>

```typescript
public readonly releaseTrigger: ReleaseTrigger;
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowName"></a>

```typescript
public readonly releaseWorkflowName: string;
```

- *Type:* string
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```typescript
public readonly releaseWorkflowSetupSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.versionrcOptions"></a>

```typescript
public readonly versionrcOptions: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowContainerImage"></a>

```typescript
public readonly workflowContainerImage: string;
```

- *Type:* string
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowRunsOn"></a>

```typescript
public readonly workflowRunsOn: string[];
```

- *Type:* string[]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.defaultReleaseBranch"></a>

```typescript
public readonly defaultReleaseBranch: string;
```

- *Type:* string
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.artifactsDirectory"></a>

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveUpgrades"></a>

```typescript
public readonly autoApproveUpgrades: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflow"></a>

```typescript
public readonly buildWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflowTriggers"></a>

```typescript
public readonly buildWorkflowTriggers: Triggers;
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundlerOptions"></a>

```typescript
public readonly bundlerOptions: BundlerOptions;
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCov"></a>

```typescript
public readonly codeCov: boolean;
```

- *Type:* boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCovTokenSecret"></a>

```typescript
public readonly codeCovTokenSecret: string;
```

- *Type:* string
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightOwner"></a>

```typescript
public readonly copyrightOwner: string;
```

- *Type:* string
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightPeriod"></a>

```typescript
public readonly copyrightPeriod: string;
```

- *Type:* string
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabot"></a>

```typescript
public readonly dependabot: boolean;
```

- *Type:* boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabotOptions"></a>

```typescript
public readonly dependabotOptions: DependabotOptions;
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgrade"></a>

```typescript
public readonly depsUpgrade: boolean;
```

- *Type:* boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgradeOptions"></a>

```typescript
public readonly depsUpgradeOptions: UpgradeDependenciesOptions;
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitignore"></a>

```typescript
public readonly gitignore: string[];
```

- *Type:* string[]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jest"></a>

```typescript
public readonly jest: boolean;
```

- *Type:* boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jestOptions"></a>

```typescript
public readonly jestOptions: JestOptions;
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mutableBuild"></a>

```typescript
public readonly mutableBuild: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```typescript
public readonly npmignore: string[];
```

- *Type:* string[]

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignoreEnabled"></a>

```typescript
public readonly npmignoreEnabled: boolean;
```

- *Type:* boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmIgnoreOptions"></a>

```typescript
public readonly npmIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.package"></a>

```typescript
public readonly package: boolean;
```

- *Type:* boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettier"></a>

```typescript
public readonly prettier: boolean;
```

- *Type:* boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettierOptions"></a>

```typescript
public readonly prettierOptions: PrettierOptions;
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenDevDependency"></a>

```typescript
public readonly projenDevDependency: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenVersion"></a>

```typescript
public readonly projenVersion: string;
```

- *Type:* string
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplate"></a>

```typescript
public readonly pullRequestTemplate: boolean;
```

- *Type:* boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplateContents"></a>

```typescript
public readonly pullRequestTemplateContents: string[];
```

- *Type:* string[]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.release"></a>

```typescript
public readonly release: boolean;
```

- *Type:* boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseToNpm"></a>

```typescript
public readonly releaseToNpm: boolean;
```

- *Type:* boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```typescript
public readonly releaseWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowBootstrapSteps"></a>

```typescript
public readonly workflowBootstrapSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowGitIdentity"></a>

```typescript
public readonly workflowGitIdentity: GitIdentity;
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowNodeVersion"></a>

```typescript
public readonly workflowNodeVersion: string;
```

- *Type:* string
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflowPackageCache`<sup>Optional</sup> <a name="workflowPackageCache" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowPackageCache"></a>

```typescript
public readonly workflowPackageCache: boolean;
```

- *Type:* boolean
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfig"></a>

```typescript
public readonly disableTsconfig: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfigDev"></a>

```typescript
public readonly disableTsconfigDev: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docgen"></a>

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docsDirectory"></a>

```typescript
public readonly docsDirectory: string;
```

- *Type:* string
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypointTypes"></a>

```typescript
public readonly entrypointTypes: string;
```

- *Type:* string
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslint"></a>

```typescript
public readonly eslint: boolean;
```

- *Type:* boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslintOptions"></a>

```typescript
public readonly eslintOptions: EslintOptions;
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.libdir"></a>

```typescript
public readonly libdir: string;
```

- *Type:* string
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcOptions;
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.sampleCode"></a>

```typescript
public readonly sampleCode: boolean;
```

- *Type:* boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.srcdir"></a>

```typescript
public readonly srcdir: string;
```

- *Type:* string
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfig"></a>

```typescript
public readonly tsconfig: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDev"></a>

```typescript
public readonly tsconfigDev: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDevFile"></a>

```typescript
public readonly tsconfigDevFile: string;
```

- *Type:* string
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptVersion"></a>

```typescript
public readonly typescriptVersion: string;
```

- *Type:* string
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.specFile"></a>

```typescript
public readonly specFile: string;
```

- *Type:* string
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayWebAclOptions <a name="OpenApiGatewayWebAclOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions"></a>

Configuration for the Web ACL associated with the API.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.Initializer"></a>

```typescript
import { OpenApiGatewayWebAclOptions } from '@aws-prototyping-sdk/open-api-gateway'

const openApiGatewayWebAclOptions: OpenApiGatewayWebAclOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.cidrAllowList">cidrAllowList</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.disable">disable</a></code> | <code>boolean</code> | If set to true, no WebACL will be associated with the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.managedRules">managedRules</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule">ManagedRule</a>[]</code> | List of managed rules to apply to the web acl. |

---

##### `cidrAllowList`<sup>Optional</sup> <a name="cidrAllowList" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.cidrAllowList"></a>

```typescript
public readonly cidrAllowList: CidrAllowList;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `disable`<sup>Optional</sup> <a name="disable" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.disable"></a>

```typescript
public readonly disable: boolean;
```

- *Type:* boolean
- *Default:* false

If set to true, no WebACL will be associated with the API.

You can also use this option if you would like to create
your own WebACL and associate it yourself.

---

##### `managedRules`<sup>Optional</sup> <a name="managedRules" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.managedRules"></a>

```typescript
public readonly managedRules: ManagedRule[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule">ManagedRule</a>[]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### OpenApiIntegration <a name="OpenApiIntegration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration"></a>

Defines an integration for an individual API operation.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.Initializer"></a>

```typescript
import { OpenApiIntegration } from '@aws-prototyping-sdk/open-api-gateway'

const openApiIntegration: OpenApiIntegration = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.integration">integration</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration">Integration</a></code> | The lambda function to service the api operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.authorizer">authorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The authorizer to use for this api operation (overrides the default). |

---

##### `integration`<sup>Required</sup> <a name="integration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.integration"></a>

```typescript
public readonly integration: Integration;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Integration">Integration</a>

The lambda function to service the api operation.

---

##### `authorizer`<sup>Optional</sup> <a name="authorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.authorizer"></a>

```typescript
public readonly authorizer: Authorizer;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The authorizer to use for this api operation (overrides the default).

---

### OpenApiOptions <a name="OpenApiOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions"></a>

Options required alongside an Open API specification to create API Gateway resources.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.Initializer"></a>

```typescript
import { OpenApiOptions } from '@aws-prototyping-sdk/open-api-gateway'

const openApiOptions: OpenApiOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.integrations">integrations</a></code> | <code>{[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>}</code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.operationLookup">operationLookup</a></code> | <code>{[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>}</code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.corsOptions">corsOptions</a></code> | <code>aws-cdk-lib.aws_apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.defaultAuthorizer">defaultAuthorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.integrations"></a>

```typescript
public readonly integrations: {[ key: string ]: OpenApiIntegration};
```

- *Type:* {[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>}

A mapping of API operation to its integration.

---

##### `operationLookup`<sup>Required</sup> <a name="operationLookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.operationLookup"></a>

```typescript
public readonly operationLookup: {[ key: string ]: MethodAndPath};
```

- *Type:* {[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>}

Details about each operation.

---

##### `corsOptions`<sup>Optional</sup> <a name="corsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.corsOptions"></a>

```typescript
public readonly corsOptions: CorsOptions;
```

- *Type:* aws-cdk-lib.aws_apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `defaultAuthorizer`<sup>Optional</sup> <a name="defaultAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.defaultAuthorizer"></a>

```typescript
public readonly defaultAuthorizer: Authorizer;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

### SmithyApiGatewayJavaProjectOptions <a name="SmithyApiGatewayJavaProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions"></a>

Configuration for the SmithyApiGatewayJavaProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.Initializer"></a>

```typescript
import { SmithyApiGatewayJavaProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const smithyApiGatewayJavaProjectOptions: SmithyApiGatewayJavaProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.artifactId">artifactId</a></code> | <code>string</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.groupId">groupId</a></code> | <code>string</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.version">version</a></code> | <code>string</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.description">description</a></code> | <code>string</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packaging">packaging</a></code> | <code>string</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.url">url</a></code> | <code>string</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.compileOptions">compileOptions</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.distdir">distdir</a></code> | <code>string</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junit">junit</a></code> | <code>boolean</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junitOptions">junitOptions</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packagingOptions">packagingOptions</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJava">projenrcJava</a></code> | <code>boolean</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.testDeps">testDeps</a></code> | <code>string[]</code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sample">sample</a></code> | <code>boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sampleJavaPackage">sampleJavaPackage</a></code> | <code>string</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.modelDir">modelDir</a></code> | <code>string</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.artifactId"></a>

```typescript
public readonly artifactId: string;
```

- *Type:* string
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.groupId"></a>

```typescript
public readonly groupId: string;
```

- *Type:* string
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packaging"></a>

```typescript
public readonly packaging: string;
```

- *Type:* string
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.url"></a>

```typescript
public readonly url: string;
```

- *Type:* string
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.compileOptions"></a>

```typescript
public readonly compileOptions: MavenCompileOptions;
```

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.distdir"></a>

```typescript
public readonly distdir: string;
```

- *Type:* string
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junit"></a>

```typescript
public readonly junit: boolean;
```

- *Type:* boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junitOptions"></a>

```typescript
public readonly junitOptions: JunitOptions;
```

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packagingOptions"></a>

```typescript
public readonly packagingOptions: MavenPackagingOptions;
```

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJava"></a>

```typescript
public readonly projenrcJava: boolean;
```

- *Type:* boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJavaOptions"></a>

```typescript
public readonly projenrcJavaOptions: ProjenrcOptions;
```

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.testDeps"></a>

```typescript
public readonly testDeps: string[];
```

- *Type:* string[]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sample"></a>

```typescript
public readonly sample: boolean;
```

- *Type:* boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sampleJavaPackage"></a>

```typescript
public readonly sampleJavaPackage: string;
```

- *Type:* string
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.serviceName"></a>

```typescript
public readonly serviceName: SmithyServiceName;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreGradleWrapper"></a>

```typescript
public readonly ignoreGradleWrapper: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreSmithyBuildOutput"></a>

```typescript
public readonly ignoreSmithyBuildOutput: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.modelDir"></a>

```typescript
public readonly modelDir: string;
```

- *Type:* string
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.smithyBuildOptions"></a>

```typescript
public readonly smithyBuildOptions: SmithyBuildOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayProjectOptions <a name="SmithyApiGatewayProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions"></a>

Options common to all smithy api gateway projects.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.Initializer"></a>

```typescript
import { SmithyApiGatewayProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const smithyApiGatewayProjectOptions: SmithyApiGatewayProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.modelDir">modelDir</a></code> | <code>string</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.serviceName"></a>

```typescript
public readonly serviceName: SmithyServiceName;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreGradleWrapper"></a>

```typescript
public readonly ignoreGradleWrapper: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreSmithyBuildOutput"></a>

```typescript
public readonly ignoreSmithyBuildOutput: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.modelDir"></a>

```typescript
public readonly modelDir: string;
```

- *Type:* string
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.smithyBuildOptions"></a>

```typescript
public readonly smithyBuildOptions: SmithyBuildOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayPythonProjectOptions <a name="SmithyApiGatewayPythonProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions"></a>

Configuration for the SmithyApiGatewayPythonProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.Initializer"></a>

```typescript
import { SmithyApiGatewayPythonProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const smithyApiGatewayPythonProjectOptions: SmithyApiGatewayPythonProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.version">version</a></code> | <code>string</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.classifiers">classifiers</a></code> | <code>string[]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.description">description</a></code> | <code>string</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.license">license</a></code> | <code>string</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetryOptions">poetryOptions</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setupConfig">setupConfig</a></code> | <code>{[ key: string ]: any}</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.moduleName">moduleName</a></code> | <code>string</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pip">pip</a></code> | <code>boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetry">poetry</a></code> | <code>boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPython">projenrcPython</a></code> | <code>boolean</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytest">pytest</a></code> | <code>boolean</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytestOptions">pytestOptions</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonExec">pythonExec</a></code> | <code>string</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.sample">sample</a></code> | <code>boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setuptools">setuptools</a></code> | <code>boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venv">venv</a></code> | <code>boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venvOptions">venvOptions</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.modelDir">modelDir</a></code> | <code>string</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.classifiers"></a>

```typescript
public readonly classifiers: string[];
```

- *Type:* string[]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetryOptions"></a>

```typescript
public readonly poetryOptions: PoetryPyprojectOptionsWithoutDeps;
```

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setupConfig"></a>

```typescript
public readonly setupConfig: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.moduleName"></a>

```typescript
public readonly moduleName: string;
```

- *Type:* string
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pip"></a>

```typescript
public readonly pip: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetry"></a>

```typescript
public readonly poetry: boolean;
```

- *Type:* boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPython"></a>

```typescript
public readonly projenrcPython: boolean;
```

- *Type:* boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPythonOptions"></a>

```typescript
public readonly projenrcPythonOptions: ProjenrcOptions;
```

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcTsOptions;
```

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytest"></a>

```typescript
public readonly pytest: boolean;
```

- *Type:* boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytestOptions"></a>

```typescript
public readonly pytestOptions: PytestOptions;
```

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `pythonExec`<sup>Optional</sup> <a name="pythonExec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonExec"></a>

```typescript
public readonly pythonExec: string;
```

- *Type:* string
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.sample"></a>

```typescript
public readonly sample: boolean;
```

- *Type:* boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setuptools"></a>

```typescript
public readonly setuptools: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venv"></a>

```typescript
public readonly venv: boolean;
```

- *Type:* boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venvOptions"></a>

```typescript
public readonly venvOptions: VenvOptions;
```

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.serviceName"></a>

```typescript
public readonly serviceName: SmithyServiceName;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreGradleWrapper"></a>

```typescript
public readonly ignoreGradleWrapper: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreSmithyBuildOutput"></a>

```typescript
public readonly ignoreSmithyBuildOutput: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.modelDir"></a>

```typescript
public readonly modelDir: string;
```

- *Type:* string
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.smithyBuildOptions"></a>

```typescript
public readonly smithyBuildOptions: SmithyBuildOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayTsProjectOptions <a name="SmithyApiGatewayTsProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions"></a>

Configuration for the SmithyApiGatewayTsProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.Initializer"></a>

```typescript
import { SmithyApiGatewayTsProjectOptions } from '@aws-prototyping-sdk/open-api-gateway'

const smithyApiGatewayTsProjectOptions: SmithyApiGatewayTsProjectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.name">name</a></code> | <code>string</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitOptions">gitOptions</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.outdir">outdir</a></code> | <code>string</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCommand">projenCommand</a></code> | <code>string</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMerge">autoMerge</a></code> | <code>boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clobber">clobber</a></code> | <code>boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devContainer">devContainer</a></code> | <code>boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.github">github</a></code> | <code>boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.githubOptions">githubOptions</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitpod">gitpod</a></code> | <code>boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergify">mergify</a></code> | <code>boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>string</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stale">stale</a></code> | <code>boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.staleOptions">staleOptions</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.vscode">vscode</a></code> | <code>boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorEmail">authorEmail</a></code> | <code>string</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorName">authorName</a></code> | <code>string</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>boolean</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorUrl">authorUrl</a></code> | <code>string</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bin">bin</a></code> | <code>{[ key: string ]: string}</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>string</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>string</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>string[]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.deps">deps</a></code> | <code>string[]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.description">description</a></code> | <code>string</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devDeps">devDeps</a></code> | <code>string[]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>string</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.homepage">homepage</a></code> | <code>string</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.keywords">keywords</a></code> | <code>string[]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.license">license</a></code> | <code>string</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.licensed">licensed</a></code> | <code>boolean</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmAccess">npmAccess</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>string</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>string</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>string</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageName">packageName</a></code> | <code>string</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDeps">peerDeps</a></code> | <code>string[]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>string</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repository">repository</a></code> | <code>string</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>string</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>projen.javascript.ScopedPackagesOptions[]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scripts">scripts</a></code> | <code>{[ key: string ]: string}</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stability">stability</a></code> | <code>string</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>string</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.majorVersion">majorVersion</a></code> | <code>number</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>number</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>string</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prerelease">prerelease</a></code> | <code>string</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishTasks">publishTasks</a></code> | <code>boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>{[ key: string ]: projen.release.BranchOptions}</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>string</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>string</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>string</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>string</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>{[ key: string ]: any}</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>string</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>string[]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>string</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCov">codeCov</a></code> | <code>boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>string</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>string</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>string</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabot">dependabot</a></code> | <code>boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitignore">gitignore</a></code> | <code>string[]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jest">jest</a></code> | <code>boolean</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jestOptions">jestOptions</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignore">npmignore</a></code> | <code>string[]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.package">package</a></code> | <code>boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettier">prettier</a></code> | <code>boolean</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenVersion">projenVersion</a></code> | <code>string</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>boolean</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>string[]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.release">release</a></code> | <code>boolean</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>projen.github.workflows.JobStep[]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>string</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowPackageCache">workflowPackageCache</a></code> | <code>boolean</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docgen">docgen</a></code> | <code>boolean</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>string</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslint">eslint</a></code> | <code>boolean</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.libdir">libdir</a></code> | <code>string</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.sampleCode">sampleCode</a></code> | <code>boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.srcdir">srcdir</a></code> | <code>string</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.testdir">testdir</a></code> | <code>string</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>string</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>string</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>string</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.modelDir">modelDir</a></code> | <code>string</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.commitGenerated"></a>

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitIgnoreOptions"></a>

```typescript
public readonly gitIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitOptions"></a>

```typescript
public readonly gitOptions: GitOptions;
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.logging"></a>

```typescript
public readonly logging: LoggerOptions;
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parent"></a>

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCommand"></a>

```typescript
public readonly projenCommand: string;
```

- *Type:* string
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJson"></a>

```typescript
public readonly projenrcJson: boolean;
```

- *Type:* boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsonOptions"></a>

```typescript
public readonly projenrcJsonOptions: ProjenrcJsonOptions;
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebot"></a>

```typescript
public readonly renovatebot: boolean;
```

- *Type:* boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebotOptions"></a>

```typescript
public readonly renovatebotOptions: RenovatebotOptions;
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveOptions"></a>

```typescript
public readonly autoApproveOptions: AutoApproveOptions;
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMerge"></a>

```typescript
public readonly autoMerge: boolean;
```

- *Type:* boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMergeOptions"></a>

```typescript
public readonly autoMergeOptions: AutoMergeOptions;
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clobber"></a>

```typescript
public readonly clobber: boolean;
```

- *Type:* boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devContainer"></a>

```typescript
public readonly devContainer: boolean;
```

- *Type:* boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.github"></a>

```typescript
public readonly github: boolean;
```

- *Type:* boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.githubOptions"></a>

```typescript
public readonly githubOptions: GitHubOptions;
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitpod"></a>

```typescript
public readonly gitpod: boolean;
```

- *Type:* boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```typescript
public readonly mergify: boolean;
```

- *Type:* boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```typescript
public readonly mergifyOptions: MergifyOptions;
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCredentials"></a>

```typescript
public readonly projenCredentials: GithubCredentials;
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```typescript
public readonly projenTokenSecret: string;
```

- *Type:* string
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.readme"></a>

```typescript
public readonly readme: SampleReadmeProps;
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```typescript
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stale"></a>

```typescript
public readonly stale: boolean;
```

- *Type:* boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.staleOptions"></a>

```typescript
public readonly staleOptions: StaleOptions;
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.vscode"></a>

```typescript
public readonly vscode: boolean;
```

- *Type:* boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.allowLibraryDependencies"></a>

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorEmail"></a>

```typescript
public readonly authorEmail: string;
```

- *Type:* string

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorName"></a>

```typescript
public readonly authorName: string;
```

- *Type:* string

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorOrganization"></a>

```typescript
public readonly authorOrganization: boolean;
```

- *Type:* boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorUrl"></a>

```typescript
public readonly authorUrl: string;
```

- *Type:* string

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoDetectBin"></a>

```typescript
public readonly autoDetectBin: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bin"></a>

```typescript
public readonly bin: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsEmail"></a>

```typescript
public readonly bugsEmail: string;
```

- *Type:* string

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsUrl"></a>

```typescript
public readonly bugsUrl: string;
```

- *Type:* string

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundledDeps"></a>

```typescript
public readonly bundledDeps: string[];
```

- *Type:* string[]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeArtifactOptions"></a>

```typescript
public readonly codeArtifactOptions: CodeArtifactOptions;
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.deps"></a>

```typescript
public readonly deps: string[];
```

- *Type:* string[]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devDeps"></a>

```typescript
public readonly devDeps: string[];
```

- *Type:* string[]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```typescript
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypoint"></a>

```typescript
public readonly entrypoint: string;
```

- *Type:* string
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.homepage"></a>

```typescript
public readonly homepage: string;
```

- *Type:* string

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.keywords"></a>

```typescript
public readonly keywords: string[];
```

- *Type:* string[]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.license"></a>

```typescript
public readonly license: string;
```

- *Type:* string
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.licensed"></a>

```typescript
public readonly licensed: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.maxNodeVersion"></a>

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minNodeVersion"></a>

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmAccess"></a>

```typescript
public readonly npmAccess: NpmAccess;
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```typescript
public readonly npmRegistry: string;
```

- *Type:* string

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistryUrl"></a>

```typescript
public readonly npmRegistryUrl: string;
```

- *Type:* string
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmTokenSecret"></a>

```typescript
public readonly npmTokenSecret: string;
```

- *Type:* string
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageManager"></a>

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageName"></a>

```typescript
public readonly packageName: string;
```

- *Type:* string
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDependencyOptions"></a>

```typescript
public readonly peerDependencyOptions: PeerDependencyOptions;
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDeps"></a>

```typescript
public readonly peerDeps: string[];
```

- *Type:* string[]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pnpmVersion"></a>

```typescript
public readonly pnpmVersion: string;
```

- *Type:* string
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repository"></a>

```typescript
public readonly repository: string;
```

- *Type:* string

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repositoryDirectory"></a>

```typescript
public readonly repositoryDirectory: string;
```

- *Type:* string

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scopedPackagesOptions"></a>

```typescript
public readonly scopedPackagesOptions: ScopedPackagesOptions[];
```

- *Type:* projen.javascript.ScopedPackagesOptions[]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```typescript
public readonly scripts: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stability"></a>

```typescript
public readonly stability: string;
```

- *Type:* string

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jsiiReleaseVersion"></a>

```typescript
public readonly jsiiReleaseVersion: string;
```

- *Type:* string
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.majorVersion"></a>

```typescript
public readonly majorVersion: number;
```

- *Type:* number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minMajorVersion"></a>

```typescript
public readonly minMajorVersion: number;
```

- *Type:* number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmDistTag"></a>

```typescript
public readonly npmDistTag: string;
```

- *Type:* string
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.postBuildSteps"></a>

```typescript
public readonly postBuildSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prerelease"></a>

```typescript
public readonly prerelease: string;
```

- *Type:* string
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishDryRun"></a>

```typescript
public readonly publishDryRun: boolean;
```

- *Type:* boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishTasks"></a>

```typescript
public readonly publishTasks: boolean;
```

- *Type:* boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseBranches"></a>

```typescript
public readonly releaseBranches: {[ key: string ]: BranchOptions};
```

- *Type:* {[ key: string ]: projen.release.BranchOptions}
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```typescript
public readonly releaseEveryCommit: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssue"></a>

```typescript
public readonly releaseFailureIssue: boolean;
```

- *Type:* boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssueLabel"></a>

```typescript
public readonly releaseFailureIssueLabel: string;
```

- *Type:* string
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```typescript
public readonly releaseSchedule: string;
```

- *Type:* string
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTagPrefix"></a>

```typescript
public readonly releaseTagPrefix: string;
```

- *Type:* string
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTrigger"></a>

```typescript
public readonly releaseTrigger: ReleaseTrigger;
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowName"></a>

```typescript
public readonly releaseWorkflowName: string;
```

- *Type:* string
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```typescript
public readonly releaseWorkflowSetupSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.versionrcOptions"></a>

```typescript
public readonly versionrcOptions: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowContainerImage"></a>

```typescript
public readonly workflowContainerImage: string;
```

- *Type:* string
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowRunsOn"></a>

```typescript
public readonly workflowRunsOn: string[];
```

- *Type:* string[]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.defaultReleaseBranch"></a>

```typescript
public readonly defaultReleaseBranch: string;
```

- *Type:* string
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.artifactsDirectory"></a>

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveUpgrades"></a>

```typescript
public readonly autoApproveUpgrades: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflow"></a>

```typescript
public readonly buildWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflowTriggers"></a>

```typescript
public readonly buildWorkflowTriggers: Triggers;
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundlerOptions"></a>

```typescript
public readonly bundlerOptions: BundlerOptions;
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCov"></a>

```typescript
public readonly codeCov: boolean;
```

- *Type:* boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCovTokenSecret"></a>

```typescript
public readonly codeCovTokenSecret: string;
```

- *Type:* string
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightOwner"></a>

```typescript
public readonly copyrightOwner: string;
```

- *Type:* string
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightPeriod"></a>

```typescript
public readonly copyrightPeriod: string;
```

- *Type:* string
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabot"></a>

```typescript
public readonly dependabot: boolean;
```

- *Type:* boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabotOptions"></a>

```typescript
public readonly dependabotOptions: DependabotOptions;
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgrade"></a>

```typescript
public readonly depsUpgrade: boolean;
```

- *Type:* boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgradeOptions"></a>

```typescript
public readonly depsUpgradeOptions: UpgradeDependenciesOptions;
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitignore"></a>

```typescript
public readonly gitignore: string[];
```

- *Type:* string[]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jest"></a>

```typescript
public readonly jest: boolean;
```

- *Type:* boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jestOptions"></a>

```typescript
public readonly jestOptions: JestOptions;
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mutableBuild"></a>

```typescript
public readonly mutableBuild: boolean;
```

- *Type:* boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```typescript
public readonly npmignore: string[];
```

- *Type:* string[]

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignoreEnabled"></a>

```typescript
public readonly npmignoreEnabled: boolean;
```

- *Type:* boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmIgnoreOptions"></a>

```typescript
public readonly npmIgnoreOptions: IgnoreFileOptions;
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.package"></a>

```typescript
public readonly package: boolean;
```

- *Type:* boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettier"></a>

```typescript
public readonly prettier: boolean;
```

- *Type:* boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettierOptions"></a>

```typescript
public readonly prettierOptions: PrettierOptions;
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenDevDependency"></a>

```typescript
public readonly projenDevDependency: boolean;
```

- *Type:* boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJs"></a>

```typescript
public readonly projenrcJs: boolean;
```

- *Type:* boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsOptions"></a>

```typescript
public readonly projenrcJsOptions: ProjenrcOptions;
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenVersion"></a>

```typescript
public readonly projenVersion: string;
```

- *Type:* string
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplate"></a>

```typescript
public readonly pullRequestTemplate: boolean;
```

- *Type:* boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplateContents"></a>

```typescript
public readonly pullRequestTemplateContents: string[];
```

- *Type:* string[]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.release"></a>

```typescript
public readonly release: boolean;
```

- *Type:* boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseToNpm"></a>

```typescript
public readonly releaseToNpm: boolean;
```

- *Type:* boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```typescript
public readonly releaseWorkflow: boolean;
```

- *Type:* boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowBootstrapSteps"></a>

```typescript
public readonly workflowBootstrapSteps: JobStep[];
```

- *Type:* projen.github.workflows.JobStep[]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowGitIdentity"></a>

```typescript
public readonly workflowGitIdentity: GitIdentity;
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowNodeVersion"></a>

```typescript
public readonly workflowNodeVersion: string;
```

- *Type:* string
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflowPackageCache`<sup>Optional</sup> <a name="workflowPackageCache" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowPackageCache"></a>

```typescript
public readonly workflowPackageCache: boolean;
```

- *Type:* boolean
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfig"></a>

```typescript
public readonly disableTsconfig: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfigDev"></a>

```typescript
public readonly disableTsconfigDev: boolean;
```

- *Type:* boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docgen"></a>

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docsDirectory"></a>

```typescript
public readonly docsDirectory: string;
```

- *Type:* string
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypointTypes"></a>

```typescript
public readonly entrypointTypes: string;
```

- *Type:* string
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslint"></a>

```typescript
public readonly eslint: boolean;
```

- *Type:* boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslintOptions"></a>

```typescript
public readonly eslintOptions: EslintOptions;
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.libdir"></a>

```typescript
public readonly libdir: string;
```

- *Type:* string
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTs"></a>

```typescript
public readonly projenrcTs: boolean;
```

- *Type:* boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTsOptions"></a>

```typescript
public readonly projenrcTsOptions: ProjenrcOptions;
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.sampleCode"></a>

```typescript
public readonly sampleCode: boolean;
```

- *Type:* boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.srcdir"></a>

```typescript
public readonly srcdir: string;
```

- *Type:* string
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.testdir"></a>

```typescript
public readonly testdir: string;
```

- *Type:* string
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfig"></a>

```typescript
public readonly tsconfig: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDev"></a>

```typescript
public readonly tsconfigDev: TypescriptConfigOptions;
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDevFile"></a>

```typescript
public readonly tsconfigDevFile: string;
```

- *Type:* string
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptVersion"></a>

```typescript
public readonly typescriptVersion: string;
```

- *Type:* string
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clientLanguages"></a>

```typescript
public readonly clientLanguages: ClientLanguage[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>[]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.apiSrcDir"></a>

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.documentationFormats"></a>

```typescript
public readonly documentationFormats: DocumentationFormat[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>[]

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs"></a>

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.generatedCodeDir"></a>

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.javaClientOptions"></a>

```typescript
public readonly javaClientOptions: JavaProjectOptions;
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parsedSpecFileName"></a>

```typescript
public readonly parsedSpecFileName: string;
```

- *Type:* string
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pythonClientOptions"></a>

```typescript
public readonly pythonClientOptions: PythonProjectOptions;
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptClientOptions"></a>

```typescript
public readonly typescriptClientOptions: TypeScriptProjectOptions;
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.serviceName"></a>

```typescript
public readonly serviceName: SmithyServiceName;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreGradleWrapper"></a>

```typescript
public readonly ignoreGradleWrapper: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreSmithyBuildOutput"></a>

```typescript
public readonly ignoreSmithyBuildOutput: boolean;
```

- *Type:* boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.modelDir"></a>

```typescript
public readonly modelDir: string;
```

- *Type:* string
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.smithyBuildOptions"></a>

```typescript
public readonly smithyBuildOptions: SmithyBuildOptions;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyBuildOptions <a name="SmithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions"></a>

Options for the smithy build files.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.Initializer"></a>

```typescript
import { SmithyBuildOptions } from '@aws-prototyping-sdk/open-api-gateway'

const smithyBuildOptions: SmithyBuildOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.imports">imports</a></code> | <code>string[]</code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.plugins">plugins</a></code> | <code>{[ key: string ]: {[ key: string ]: any}}</code> | Plugins keyed by plugin id. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.ignoreMissingPlugins">ignoreMissingPlugins</a></code> | <code>boolean</code> | If a plugin can't be found, Smithy will by default fail the build. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.maven">maven</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration">SmithyMavenConfiguration</a></code> | Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.projections">projections</a></code> | <code>{[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection">SmithyProjection</a>}</code> | Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.imports"></a>

```typescript
public readonly imports: string[];
```

- *Type:* string[]

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.plugins"></a>

```typescript
public readonly plugins: {[ key: string ]: {[ key: string ]: any}};
```

- *Type:* {[ key: string ]: {[ key: string ]: any}}

Plugins keyed by plugin id.

---

##### `ignoreMissingPlugins`<sup>Optional</sup> <a name="ignoreMissingPlugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.ignoreMissingPlugins"></a>

```typescript
public readonly ignoreMissingPlugins: boolean;
```

- *Type:* boolean
- *Default:* no ignoreMissingPlugins set in the smithy-build.json file

If a plugin can't be found, Smithy will by default fail the build.

This setting can be set to true to allow the build to progress
even if a plugin can't be found on the classpath.

---

##### `maven`<sup>Optional</sup> <a name="maven" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.maven"></a>

```typescript
public readonly maven: SmithyMavenConfiguration;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration">SmithyMavenConfiguration</a>
- *Default:* the default configuration required for Smithy to OpenAPI conversion

Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files.

---

##### `projections`<sup>Optional</sup> <a name="projections" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.projections"></a>

```typescript
public readonly projections: {[ key: string ]: SmithyProjection};
```

- *Type:* {[ key: string ]: <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection">SmithyProjection</a>}
- *Default:* no projections

Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections.

---

### SmithyCommon <a name="SmithyCommon" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon"></a>

Properties common to smithy plugins and the root smithy build.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.Initializer"></a>

```typescript
import { SmithyCommon } from '@aws-prototyping-sdk/open-api-gateway'

const smithyCommon: SmithyCommon = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.imports">imports</a></code> | <code>string[]</code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.plugins">plugins</a></code> | <code>{[ key: string ]: {[ key: string ]: any}}</code> | Plugins keyed by plugin id. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.imports"></a>

```typescript
public readonly imports: string[];
```

- *Type:* string[]

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.plugins"></a>

```typescript
public readonly plugins: {[ key: string ]: {[ key: string ]: any}};
```

- *Type:* {[ key: string ]: {[ key: string ]: any}}

Plugins keyed by plugin id.

---

### SmithyMavenConfiguration <a name="SmithyMavenConfiguration" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration"></a>

Configuration for smithy maven dependencies.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.Initializer"></a>

```typescript
import { SmithyMavenConfiguration } from '@aws-prototyping-sdk/open-api-gateway'

const smithyMavenConfiguration: SmithyMavenConfiguration = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.dependencies">dependencies</a></code> | <code>string[]</code> | The dependencies used in the build.gradle and smithy-build.json files eg. software.amazon.smithy:smithy-validation-model:1.27.2 The following required dependencies are always added: - software.amazon.smithy:smithy-cli:1.27.2 - software.amazon.smithy:smithy-model:1.27.2 - software.amazon.smithy:smithy-openapi:1.27.2 - software.amazon.smithy:smithy-aws-traits:1.27.2 You can however override the version of these dependencies if required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.repositoryUrls">repositoryUrls</a></code> | <code>string[]</code> | The repository urls used in the build.gradle and smithy-build.json files. |

---

##### `dependencies`<sup>Optional</sup> <a name="dependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.dependencies"></a>

```typescript
public readonly dependencies: string[];
```

- *Type:* string[]

The dependencies used in the build.gradle and smithy-build.json files eg. software.amazon.smithy:smithy-validation-model:1.27.2 The following required dependencies are always added: - software.amazon.smithy:smithy-cli:1.27.2 - software.amazon.smithy:smithy-model:1.27.2 - software.amazon.smithy:smithy-openapi:1.27.2 - software.amazon.smithy:smithy-aws-traits:1.27.2 You can however override the version of these dependencies if required.

---

##### `repositoryUrls`<sup>Optional</sup> <a name="repositoryUrls" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.repositoryUrls"></a>

```typescript
public readonly repositoryUrls: string[];
```

- *Type:* string[]
- *Default:* maven central and maven local

The repository urls used in the build.gradle and smithy-build.json files.

---

### SmithyProjection <a name="SmithyProjection" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection"></a>

A smithy build projection.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.Initializer"></a>

```typescript
import { SmithyProjection } from '@aws-prototyping-sdk/open-api-gateway'

const smithyProjection: SmithyProjection = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.imports">imports</a></code> | <code>string[]</code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.plugins">plugins</a></code> | <code>{[ key: string ]: {[ key: string ]: any}}</code> | Plugins keyed by plugin id. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.abstract">abstract</a></code> | <code>boolean</code> | Whether or not the projection is abstract. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.transforms">transforms</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform">SmithyTransform</a>[]</code> | Transforms to apply to the projection. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.imports"></a>

```typescript
public readonly imports: string[];
```

- *Type:* string[]

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.plugins"></a>

```typescript
public readonly plugins: {[ key: string ]: {[ key: string ]: any}};
```

- *Type:* {[ key: string ]: {[ key: string ]: any}}

Plugins keyed by plugin id.

---

##### `abstract`<sup>Optional</sup> <a name="abstract" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.abstract"></a>

```typescript
public readonly abstract: boolean;
```

- *Type:* boolean

Whether or not the projection is abstract.

---

##### `transforms`<sup>Optional</sup> <a name="transforms" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.transforms"></a>

```typescript
public readonly transforms: SmithyTransform[];
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform">SmithyTransform</a>[]

Transforms to apply to the projection.

---

### SmithyServiceName <a name="SmithyServiceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName"></a>

Represents a fully qualified name of a Smithy service.

> [https://awslabs.github.io/smithy/2.0/spec/service-types.html](https://awslabs.github.io/smithy/2.0/spec/service-types.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.Initializer"></a>

```typescript
import { SmithyServiceName } from '@aws-prototyping-sdk/open-api-gateway'

const smithyServiceName: SmithyServiceName = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.namespace">namespace</a></code> | <code>string</code> | The service namespace. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.serviceName">serviceName</a></code> | <code>string</code> | The service name. |

---

##### `namespace`<sup>Required</sup> <a name="namespace" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* string

The service namespace.

Nested namespaces are separated by '.', for example com.company

> [https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id](https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id)

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.serviceName"></a>

```typescript
public readonly serviceName: string;
```

- *Type:* string

The service name.

Should be PascalCase, for example HelloService

> [https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id](https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id)

---

### SmithyTransform <a name="SmithyTransform" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform"></a>

A smithy build transform.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.Initializer"></a>

```typescript
import { SmithyTransform } from '@aws-prototyping-sdk/open-api-gateway'

const smithyTransform: SmithyTransform = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.args">args</a></code> | <code>{[ key: string ]: any}</code> | Arguments for the transform. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.name">name</a></code> | <code>string</code> | Name of the transform. |

---

##### `args`<sup>Required</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.args"></a>

```typescript
public readonly args: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

Arguments for the transform.

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

Name of the transform.

---

## Classes <a name="Classes" id="Classes"></a>

### Authorizer <a name="Authorizer" id="@aws-prototyping-sdk/open-api-gateway.Authorizer"></a>

An authorizer for authorizing API requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer"></a>

```typescript
import { Authorizer } from '@aws-prototyping-sdk/open-api-gateway'

new Authorizer(props: AuthorizerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps">AuthorizerProps</a></code> | *No description.* |

---

##### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps">AuthorizerProps</a>

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationType">authorizationType</a></code> | <code>aws-cdk-lib.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizerId">authorizerId</a></code> | <code>string</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationType"></a>

```typescript
public readonly authorizationType: AuthorizationType;
```

- *Type:* aws-cdk-lib.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]

Scopes for the authorizer, if any.

---


### Authorizers <a name="Authorizers" id="@aws-prototyping-sdk/open-api-gateway.Authorizers"></a>

Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.Initializer"></a>

```typescript
import { Authorizers } from '@aws-prototyping-sdk/open-api-gateway'

new Authorizers()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito">cognito</a></code> | A Cognito User Pools authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.custom">custom</a></code> | A custom authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.iam">iam</a></code> | An IAM authorizer which uses AWS signature version 4 to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.none">none</a></code> | No authorizer. |

---

##### `cognito` <a name="cognito" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito"></a>

```typescript
import { Authorizers } from '@aws-prototyping-sdk/open-api-gateway'

Authorizers.cognito(props: CognitoAuthorizerProps)
```

A Cognito User Pools authorizer.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps">CognitoAuthorizerProps</a>

---

##### `custom` <a name="custom" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom"></a>

```typescript
import { Authorizers } from '@aws-prototyping-sdk/open-api-gateway'

Authorizers.custom(props: CustomAuthorizerProps)
```

A custom authorizer.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps">CustomAuthorizerProps</a>

---

##### `iam` <a name="iam" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.iam"></a>

```typescript
import { Authorizers } from '@aws-prototyping-sdk/open-api-gateway'

Authorizers.iam()
```

An IAM authorizer which uses AWS signature version 4 to authorize requests.

##### `none` <a name="none" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.none"></a>

```typescript
import { Authorizers } from '@aws-prototyping-sdk/open-api-gateway'

Authorizers.none()
```

No authorizer.



### CognitoAuthorizer <a name="CognitoAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer"></a>

An authorizer that uses Cognito identity or access tokens.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer"></a>

```typescript
import { CognitoAuthorizer } from '@aws-prototyping-sdk/open-api-gateway'

new CognitoAuthorizer(props: CognitoAuthorizerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps">CognitoAuthorizerProps</a></code> | *No description.* |

---

##### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps">CognitoAuthorizerProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes">withScopes</a></code> | Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis. |

---

##### `withScopes` <a name="withScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes"></a>

```typescript
public withScopes(authorizationScopes: string): CognitoAuthorizer
```

Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

###### `authorizationScopes`<sup>Required</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes.parameter.authorizationScopes"></a>

- *Type:* string

the scopes to apply.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationType">authorizationType</a></code> | <code>aws-cdk-lib.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizerId">authorizerId</a></code> | <code>string</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | Scopes for the authorizer, if any. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.userPools">userPools</a></code> | <code>aws-cdk-lib.aws_cognito.IUserPool[]</code> | The Cognito user pools associated with this authorizer. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationType"></a>

```typescript
public readonly authorizationType: AuthorizationType;
```

- *Type:* aws-cdk-lib.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]

Scopes for the authorizer, if any.

---

##### `userPools`<sup>Required</sup> <a name="userPools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.userPools"></a>

```typescript
public readonly userPools: IUserPool[];
```

- *Type:* aws-cdk-lib.aws_cognito.IUserPool[]

The Cognito user pools associated with this authorizer.

---


### CustomAuthorizer <a name="CustomAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer"></a>

An authorizer that uses a lambda function to authorize requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer"></a>

```typescript
import { CustomAuthorizer } from '@aws-prototyping-sdk/open-api-gateway'

new CustomAuthorizer(props: CustomAuthorizerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps">CustomAuthorizerProps</a></code> | *No description.* |

---

##### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps">CustomAuthorizerProps</a>

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationType">authorizationType</a></code> | <code>aws-cdk-lib.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerId">authorizerId</a></code> | <code>string</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | Scopes for the authorizer, if any. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerResultTtlInSeconds">authorizerResultTtlInSeconds</a></code> | <code>number</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.function">function</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.identitySource">identitySource</a></code> | <code>string</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationType"></a>

```typescript
public readonly authorizationType: AuthorizationType;
```

- *Type:* aws-cdk-lib.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]

Scopes for the authorizer, if any.

---

##### `authorizerResultTtlInSeconds`<sup>Required</sup> <a name="authorizerResultTtlInSeconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerResultTtlInSeconds"></a>

```typescript
public readonly authorizerResultTtlInSeconds: number;
```

- *Type:* number

The number of seconds during which the authorizer result is cached.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.function"></a>

```typescript
public readonly function: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

The lambda function used to authorize requests.

---

##### `identitySource`<sup>Required</sup> <a name="identitySource" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.identitySource"></a>

```typescript
public readonly identitySource: string;
```

- *Type:* string

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Required</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.type"></a>

```typescript
public readonly type: CustomAuthorizerType;
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---


### IamAuthorizer <a name="IamAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer"></a>

An IAM authorizer.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.Initializer"></a>

```typescript
import { IamAuthorizer } from '@aws-prototyping-sdk/open-api-gateway'

new IamAuthorizer()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationType">authorizationType</a></code> | <code>aws-cdk-lib.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizerId">authorizerId</a></code> | <code>string</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationType"></a>

```typescript
public readonly authorizationType: AuthorizationType;
```

- *Type:* aws-cdk-lib.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]

Scopes for the authorizer, if any.

---


### Integration <a name="Integration" id="@aws-prototyping-sdk/open-api-gateway.Integration"></a>

An integration for an API operation.

You can extend this to implement your own integration if you like.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Integration.Initializer"></a>

```typescript
import { Integration } from '@aws-prototyping-sdk/open-api-gateway'

new Integration()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration.grant">grant</a></code> | Grant permissions for the API to invoke the integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration.render">render</a></code> | Render the integration into an API Gateway OpenAPI extension. |

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant"></a>

```typescript
public grant(_props: IntegrationGrantProps): void
```

Grant permissions for the API to invoke the integration.

###### `_props`<sup>Required</sup> <a name="_props" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter._props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps">IntegrationGrantProps</a>

---

##### `render` <a name="render" id="@aws-prototyping-sdk/open-api-gateway.Integration.render"></a>

```typescript
public render(props: IntegrationRenderProps): ApiGatewayIntegration
```

Render the integration into an API Gateway OpenAPI extension.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Integration.render.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps">IntegrationRenderProps</a>

---




### Integrations <a name="Integrations" id="@aws-prototyping-sdk/open-api-gateway.Integrations"></a>

A collection of integrations to connect API operations with a backend to service requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Integrations.Initializer"></a>

```typescript
import { Integrations } from '@aws-prototyping-sdk/open-api-gateway'

new Integrations()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integrations.lambda">lambda</a></code> | An integration that invokes a lambda function to service the request. |

---

##### `lambda` <a name="lambda" id="@aws-prototyping-sdk/open-api-gateway.Integrations.lambda"></a>

```typescript
import { Integrations } from '@aws-prototyping-sdk/open-api-gateway'

Integrations.lambda(lambdaFunction: IFunction)
```

An integration that invokes a lambda function to service the request.

###### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="@aws-prototyping-sdk/open-api-gateway.Integrations.lambda.parameter.lambdaFunction"></a>

- *Type:* aws-cdk-lib.aws_lambda.IFunction

the function to invoke.

---



### LambdaIntegration <a name="LambdaIntegration" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration"></a>

A lambda integration.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer"></a>

```typescript
import { LambdaIntegration } from '@aws-prototyping-sdk/open-api-gateway'

new LambdaIntegration(lambdaFunction: IFunction)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer.parameter.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant">grant</a></code> | Grant API Gateway permissions to invoke the lambda. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render">render</a></code> | Render the lambda integration as a snippet of OpenAPI. |

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant"></a>

```typescript
public grant(__0: IntegrationGrantProps): void
```

Grant API Gateway permissions to invoke the lambda.

###### `__0`<sup>Required</sup> <a name="__0" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.__0"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps">IntegrationGrantProps</a>

---

##### `render` <a name="render" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render"></a>

```typescript
public render(props: IntegrationRenderProps): ApiGatewayIntegration
```

Render the lambda integration as a snippet of OpenAPI.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps">IntegrationRenderProps</a>

---




### NoneAuthorizer <a name="NoneAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer"></a>

No authorizer.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.Initializer"></a>

```typescript
import { NoneAuthorizer } from '@aws-prototyping-sdk/open-api-gateway'

new NoneAuthorizer()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationType">authorizationType</a></code> | <code>aws-cdk-lib.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizerId">authorizerId</a></code> | <code>string</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>string[]</code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationType"></a>

```typescript
public readonly authorizationType: AuthorizationType;
```

- *Type:* aws-cdk-lib.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizerId"></a>

```typescript
public readonly authorizerId: string;
```

- *Type:* string

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationScopes"></a>

```typescript
public readonly authorizationScopes: string[];
```

- *Type:* string[]

Scopes for the authorizer, if any.

---


### OpenApiGatewayJavaProject <a name="OpenApiGatewayJavaProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject"></a>

Synthesizes a Java Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer"></a>

```typescript
import { OpenApiGatewayJavaProject } from '@aws-prototyping-sdk/open-api-gateway'

new OpenApiGatewayJavaProject(projectOptions: OpenApiGatewayJavaProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projectOptions">projectOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions">OpenApiGatewayJavaProjectOptions</a></code> | *No description.* |

---

##### `projectOptions`<sup>Required</sup> <a name="projectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projectOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions">OpenApiGatewayJavaProjectOptions</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin">addPlugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency">addTestDependency</a></code> | Adds a test dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(_pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* string

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency"></a>

```typescript
public addDependency(spec: string): void
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency.parameter.spec"></a>

- *Type:* string

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`addPlugin`~~ <a name="addPlugin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin"></a>

```typescript
public addPlugin(spec: string, options?: PluginOptions): Dependency
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.spec"></a>

- *Type:* string

dependency spec (`group/artifact@version`).

---

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.options"></a>

- *Type:* projen.java.PluginOptions

plugin options.

---

##### ~~`addTestDependency`~~ <a name="addTestDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency"></a>

```typescript
public addTestDependency(spec: string): void
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* string

Format `<groupId>/<artifactId>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.subprojects">subprojects</a></code> | <code>projen.Project[]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compile">compile</a></code> | <code>projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.distdir">distdir</a></code> | <code>string</code> | Maven artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packaging">packaging</a></code> | <code>projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.pom">pom</a></code> | <code>projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.junit">junit</a></code> | <code>projen.java.Junit</code> | JUnit component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenrc">projenrc</a></code> | <code>projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedClients">generatedClients</a></code> | <code>{[ key: string ]: projen.Project}</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedJavaClient">generatedJavaClient</a></code> | <code>projen.java.JavaProject</code> | A reference to the generated java client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specDir">specDir</a></code> | <code>string</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specFileName">specFileName</a></code> | <code>string</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly subprojects: Project[];
```

- *Type:* projen.Project[]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`compile`~~<sup>Required</sup> <a name="compile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compile"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compile: MavenCompile;
```

- *Type:* projen.java.MavenCompile

Compile component.

---

##### ~~`distdir`~~<sup>Required</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.distdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly distdir: string;
```

- *Type:* string

Maven artifact output directory.

---

##### ~~`packaging`~~<sup>Required</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packaging"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packaging: MavenPackaging;
```

- *Type:* projen.java.MavenPackaging

Packaging component.

---

##### ~~`pom`~~<sup>Required</sup> <a name="pom" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.pom"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly pom: Pom;
```

- *Type:* projen.java.Pom

API for managing `pom.xml`.

---

##### ~~`junit`~~<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.junit"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly junit: Junit;
```

- *Type:* projen.java.Junit

JUnit component.

---

##### ~~`projenrc`~~<sup>Optional</sup> <a name="projenrc" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenrc: Projenrc;
```

- *Type:* projen.java.Projenrc

Projenrc component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

This will also be used
as the package for the api project.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedClients: {[ key: string ]: Project};
```

- *Type:* {[ key: string ]: projen.Project}

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedJavaClient`~~<sup>Required</sup> <a name="generatedJavaClient" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedJavaClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedJavaClient: JavaProject;
```

- *Type:* projen.java.JavaProject

A reference to the generated java client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specDir: string;
```

- *Type:* string

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specFileName: string;
```

- *Type:* string

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### OpenApiGatewayPythonProject <a name="OpenApiGatewayPythonProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject"></a>

Synthesizes a Python Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer"></a>

```typescript
import { OpenApiGatewayPythonProject } from '@aws-prototyping-sdk/open-api-gateway'

new OpenApiGatewayPythonProject(projectOptions: OpenApiGatewayPythonProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projectOptions">projectOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions">OpenApiGatewayPythonProjectOptions</a></code> | *No description.* |

---

##### `projectOptions`<sup>Required</sup> <a name="projectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projectOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions">OpenApiGatewayPythonProjectOptions</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency">addDevDependency</a></code> | Adds a dev dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(_pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* string

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency"></a>

```typescript
public addDependency(spec: string): void
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency.parameter.spec"></a>

- *Type:* string

Format `<module>@<semver>`.

---

##### ~~`addDevDependency`~~ <a name="addDevDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency"></a>

```typescript
public addDevDependency(spec: string): void
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency.parameter.spec"></a>

- *Type:* string

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.subprojects">subprojects</a></code> | <code>projen.Project[]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.depsManager">depsManager</a></code> | <code>projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.envManager">envManager</a></code> | <code>projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.moduleName">moduleName</a></code> | <code>string</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.version">version</a></code> | <code>string</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packagingManager">packagingManager</a></code> | <code>projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.pytest">pytest</a></code> | <code>projen.python.Pytest</code> | Pytest component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedClients">generatedClients</a></code> | <code>{[ key: string ]: projen.Project}</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedPythonClient">generatedPythonClient</a></code> | <code>projen.python.PythonProject</code> | A reference to the generated python client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specDir">specDir</a></code> | <code>string</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specFileName">specFileName</a></code> | <code>string</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly subprojects: Project[];
```

- *Type:* projen.Project[]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`depsManager`~~<sup>Required</sup> <a name="depsManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.depsManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly depsManager: IPythonDeps;
```

- *Type:* projen.python.IPythonDeps

API for managing dependencies.

---

##### ~~`envManager`~~<sup>Required</sup> <a name="envManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.envManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly envManager: IPythonEnv;
```

- *Type:* projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### ~~`moduleName`~~<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.moduleName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly moduleName: string;
```

- *Type:* string

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### ~~`version`~~<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.version"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly version: string;
```

- *Type:* string

Version of the package for distribution (should follow semver).

---

##### ~~`packagingManager`~~<sup>Optional</sup> <a name="packagingManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packagingManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packagingManager: IPythonPackaging;
```

- *Type:* projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### ~~`pytest`~~<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.pytest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly pytest: Pytest;
```

- *Type:* projen.python.Pytest

Pytest component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedClients: {[ key: string ]: Project};
```

- *Type:* {[ key: string ]: projen.Project}

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedPythonClient`~~<sup>Required</sup> <a name="generatedPythonClient" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedPythonClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedPythonClient: PythonProject;
```

- *Type:* projen.python.PythonProject

A reference to the generated python client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specDir: string;
```

- *Type:* string

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specFileName: string;
```

- *Type:* string

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### OpenApiGatewayTsProject <a name="OpenApiGatewayTsProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject"></a>

Synthesizes a Typescript Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer"></a>

```typescript
import { OpenApiGatewayTsProject } from '@aws-prototyping-sdk/open-api-gateway'

new OpenApiGatewayTsProject(projectOptions: OpenApiGatewayTsProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projectOptions">projectOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions">OpenApiGatewayTsProjectOptions</a></code> | *No description.* |

---

##### `projectOptions`<sup>Required</sup> <a name="projectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projectOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions">OpenApiGatewayTsProjectOptions</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* string

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addBins`~~ <a name="addBins" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins"></a>

```typescript
public addBins(bins: {[ key: string ]: string}): void
```

###### `bins`<sup>Required</sup> <a name="bins" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins.parameter.bins"></a>

- *Type:* {[ key: string ]: string}

---

##### ~~`addBundledDeps`~~ <a name="addBundledDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps"></a>

```typescript
public addBundledDeps(deps: string): void
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand"></a>

```typescript
public addCompileCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* string

---

##### ~~`addDeps`~~ <a name="addDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps"></a>

```typescript
public addDeps(deps: string): void
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addDevDeps`~~ <a name="addDevDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps"></a>

```typescript
public addDevDeps(deps: string): void
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addFields`~~ <a name="addFields" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields"></a>

```typescript
public addFields(fields: {[ key: string ]: any}): void
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields.parameter.fields"></a>

- *Type:* {[ key: string ]: any}

The fields to set.

---

##### ~~`addKeywords`~~ <a name="addKeywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords"></a>

```typescript
public addKeywords(keywords: string): void
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords.parameter.keywords"></a>

- *Type:* string

The keywords to add.

---

##### ~~`addPeerDeps`~~ <a name="addPeerDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps"></a>

```typescript
public addPeerDeps(deps: string): void
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addScripts`~~ <a name="addScripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts"></a>

```typescript
public addScripts(scripts: {[ key: string ]: string}): void
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts.parameter.scripts"></a>

- *Type:* {[ key: string ]: string}

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand"></a>

```typescript
public addTestCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand.parameter.commands"></a>

- *Type:* string

---

##### ~~`hasScript`~~ <a name="hasScript" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript"></a>

```typescript
public hasScript(name: string): boolean
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### ~~`removeScript`~~ <a name="removeScript" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript"></a>

```typescript
public removeScript(name: string): void
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### ~~`renderWorkflowSetup`~~ <a name="renderWorkflowSetup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup"></a>

```typescript
public renderWorkflowSetup(options?: RenderWorkflowSetupOptions): JobStep[]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### ~~`setScript`~~ <a name="setScript" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript"></a>

```typescript
public setScript(name: string, command: string): void
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript.parameter.name"></a>

- *Type:* string

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript.parameter.command"></a>

- *Type:* string

The command to execute.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.subprojects">subprojects</a></code> | <code>projen.Project[]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | The build output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>string</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.entrypoint">entrypoint</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.manifest">manifest</a></code> | <code>any</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.runScriptCommand">runScriptCommand</a></code> | <code>string</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoMerge">autoMerge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflow">buildWorkflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>string</code> | The job ID of the build workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Maximum node version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum node.js version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.libdir">libdir</a></code> | <code>string</code> | The directory in which compiled .js files reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.srcdir">srcdir</a></code> | <code>string</code> | The directory in which the .ts sources reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testdir">testdir</a></code> | <code>string</code> | The directory in which tests reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.watchTask">watchTask</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docgen">docgen</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedClients">generatedClients</a></code> | <code>{[ key: string ]: projen.Project}</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedTypescriptClient">generatedTypescriptClient</a></code> | <code>projen.typescript.TypeScriptProject</code> | A reference to the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specDir">specDir</a></code> | <code>string</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specFileName">specFileName</a></code> | <code>string</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.pnpmWorkspace">pnpmWorkspace</a></code> | <code>projen.YamlFile</code> | Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly subprojects: Project[];
```

- *Type:* projen.Project[]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean

---

##### ~~`artifactsDirectory`~~<sup>Required</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### ~~`artifactsJavascriptDirectory`~~<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsJavascriptDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly artifactsJavascriptDirectory: string;
```

- *Type:* string

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### ~~`bundler`~~<sup>Required</sup> <a name="bundler" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.bundler"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly bundler: Bundler;
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```typescript
public readonly entrypoint: string;
```

- *Type:* string

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```typescript
public readonly manifest: any;
```

- *Type:* any

---

##### ~~`npmrc`~~<sup>Required</sup> <a name="npmrc" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly npmrc: NpmConfig;
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### ~~`package`~~<sup>Required</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.package"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly package: NodePackage;
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### ~~`runScriptCommand`~~<sup>Required</sup> <a name="runScriptCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.runScriptCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly runScriptCommand: string;
```

- *Type:* string

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### ~~`autoMerge`~~<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoMerge"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoMerge: AutoMerge;
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### ~~`buildWorkflow`~~<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildWorkflow: BuildWorkflow;
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### ~~`buildWorkflowJobId`~~<sup>Optional</sup> <a name="buildWorkflowJobId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflowJobId"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildWorkflowJobId: string;
```

- *Type:* string

The job ID of the build workflow.

---

##### ~~`jest`~~<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.jest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly jest: Jest;
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### ~~`maxNodeVersion`~~<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.maxNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string

Maximum node version required by this package.

---

##### ~~`minNodeVersion`~~<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.minNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string

Minimum node.js version required by this package.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly npmignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### ~~`prettier`~~<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.prettier"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly prettier: Prettier;
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```typescript
public readonly publisher: Publisher;
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### ~~`release`~~<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.release"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly release: Release;
```

- *Type:* projen.release.Release

Release management.

---

##### ~~`upgradeWorkflow`~~<sup>Optional</sup> <a name="upgradeWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.upgradeWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly upgradeWorkflow: UpgradeDependencies;
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### ~~`docsDirectory`~~<sup>Required</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly docsDirectory: string;
```

- *Type:* string

---

##### ~~`libdir`~~<sup>Required</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.libdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly libdir: string;
```

- *Type:* string

The directory in which compiled .js files reside.

---

##### ~~`srcdir`~~<sup>Required</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.srcdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly srcdir: string;
```

- *Type:* string

The directory in which the .ts sources reside.

---

##### ~~`testdir`~~<sup>Required</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testdir: string;
```

- *Type:* string

The directory in which tests reside.

---

##### ~~`tsconfigDev`~~<sup>Required</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigDev"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tsconfigDev: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### ~~`watchTask`~~<sup>Required</sup> <a name="watchTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.watchTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly watchTask: Task;
```

- *Type:* projen.Task

The "watch" task.

---

##### ~~`docgen`~~<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docgen"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean

---

##### ~~`eslint`~~<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.eslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly eslint: Eslint;
```

- *Type:* projen.javascript.Eslint

---

##### ~~`tsconfig`~~<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfig"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tsconfig: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### ~~`tsconfigEslint`~~<sup>Optional</sup> <a name="tsconfigEslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigEslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tsconfigEslint: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Required</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean

Force to generate code and docs even if there were no changes in spec.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedClients: {[ key: string ]: Project};
```

- *Type:* {[ key: string ]: projen.Project}

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedTypescriptClient`~~<sup>Required</sup> <a name="generatedTypescriptClient" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedTypescriptClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedTypescriptClient: TypeScriptProject;
```

- *Type:* projen.typescript.TypeScriptProject

A reference to the generated typescript client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specDir: string;
```

- *Type:* string

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specFileName: string;
```

- *Type:* string

The name of the spec file.

---

##### ~~`pnpmWorkspace`~~<sup>Optional</sup> <a name="pnpmWorkspace" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.pnpmWorkspace"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly pnpmWorkspace: YamlFile;
```

- *Type:* projen.YamlFile

Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayJavaProject <a name="SmithyApiGatewayJavaProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject"></a>

Synthesizes a Java Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer"></a>

```typescript
import { SmithyApiGatewayJavaProject } from '@aws-prototyping-sdk/open-api-gateway'

new SmithyApiGatewayJavaProject(options: SmithyApiGatewayJavaProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.options">options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions">SmithyApiGatewayJavaProjectOptions</a></code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.options"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions">SmithyApiGatewayJavaProjectOptions</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin">addPlugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency">addTestDependency</a></code> | Adds a test dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(_pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* string

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency"></a>

```typescript
public addDependency(spec: string): void
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency.parameter.spec"></a>

- *Type:* string

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`addPlugin`~~ <a name="addPlugin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin"></a>

```typescript
public addPlugin(spec: string, options?: PluginOptions): Dependency
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.spec"></a>

- *Type:* string

dependency spec (`group/artifact@version`).

---

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.options"></a>

- *Type:* projen.java.PluginOptions

plugin options.

---

##### ~~`addTestDependency`~~ <a name="addTestDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency"></a>

```typescript
public addTestDependency(spec: string): void
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* string

Format `<groupId>/<artifactId>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.subprojects">subprojects</a></code> | <code>projen.Project[]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compile">compile</a></code> | <code>projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.distdir">distdir</a></code> | <code>string</code> | Maven artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packaging">packaging</a></code> | <code>projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.pom">pom</a></code> | <code>projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.junit">junit</a></code> | <code>projen.java.Junit</code> | JUnit component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenrc">projenrc</a></code> | <code>projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedClients">generatedClients</a></code> | <code>{[ key: string ]: projen.Project}</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedJavaClient">generatedJavaClient</a></code> | <code>projen.java.JavaProject</code> | A reference to the generated java client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specDir">specDir</a></code> | <code>string</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specFileName">specFileName</a></code> | <code>string</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly subprojects: Project[];
```

- *Type:* projen.Project[]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`compile`~~<sup>Required</sup> <a name="compile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compile"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compile: MavenCompile;
```

- *Type:* projen.java.MavenCompile

Compile component.

---

##### ~~`distdir`~~<sup>Required</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.distdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly distdir: string;
```

- *Type:* string

Maven artifact output directory.

---

##### ~~`packaging`~~<sup>Required</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packaging"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packaging: MavenPackaging;
```

- *Type:* projen.java.MavenPackaging

Packaging component.

---

##### ~~`pom`~~<sup>Required</sup> <a name="pom" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.pom"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly pom: Pom;
```

- *Type:* projen.java.Pom

API for managing `pom.xml`.

---

##### ~~`junit`~~<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.junit"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly junit: Junit;
```

- *Type:* projen.java.Junit

JUnit component.

---

##### ~~`projenrc`~~<sup>Optional</sup> <a name="projenrc" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenrc: Projenrc;
```

- *Type:* projen.java.Projenrc

Projenrc component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

This will also be used
as the package for the api project.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedClients: {[ key: string ]: Project};
```

- *Type:* {[ key: string ]: projen.Project}

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedJavaClient`~~<sup>Required</sup> <a name="generatedJavaClient" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedJavaClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedJavaClient: JavaProject;
```

- *Type:* projen.java.JavaProject

A reference to the generated java client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specDir: string;
```

- *Type:* string

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specFileName: string;
```

- *Type:* string

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayPythonProject <a name="SmithyApiGatewayPythonProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject"></a>

Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer"></a>

```typescript
import { SmithyApiGatewayPythonProject } from '@aws-prototyping-sdk/open-api-gateway'

new SmithyApiGatewayPythonProject(options: SmithyApiGatewayPythonProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.options">options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions">SmithyApiGatewayPythonProjectOptions</a></code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.options"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions">SmithyApiGatewayPythonProjectOptions</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency">addDevDependency</a></code> | Adds a dev dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(_pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* string

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency"></a>

```typescript
public addDependency(spec: string): void
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency.parameter.spec"></a>

- *Type:* string

Format `<module>@<semver>`.

---

##### ~~`addDevDependency`~~ <a name="addDevDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency"></a>

```typescript
public addDevDependency(spec: string): void
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency.parameter.spec"></a>

- *Type:* string

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.subprojects">subprojects</a></code> | <code>projen.Project[]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.depsManager">depsManager</a></code> | <code>projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.envManager">envManager</a></code> | <code>projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.moduleName">moduleName</a></code> | <code>string</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.version">version</a></code> | <code>string</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packagingManager">packagingManager</a></code> | <code>projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.pytest">pytest</a></code> | <code>projen.python.Pytest</code> | Pytest component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedClients">generatedClients</a></code> | <code>{[ key: string ]: projen.Project}</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedPythonClient">generatedPythonClient</a></code> | <code>projen.python.PythonProject</code> | A reference to the generated python client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specDir">specDir</a></code> | <code>string</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specFileName">specFileName</a></code> | <code>string</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly subprojects: Project[];
```

- *Type:* projen.Project[]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`depsManager`~~<sup>Required</sup> <a name="depsManager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.depsManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly depsManager: IPythonDeps;
```

- *Type:* projen.python.IPythonDeps

API for managing dependencies.

---

##### ~~`envManager`~~<sup>Required</sup> <a name="envManager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.envManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly envManager: IPythonEnv;
```

- *Type:* projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### ~~`moduleName`~~<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.moduleName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly moduleName: string;
```

- *Type:* string

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### ~~`version`~~<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.version"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly version: string;
```

- *Type:* string

Version of the package for distribution (should follow semver).

---

##### ~~`packagingManager`~~<sup>Optional</sup> <a name="packagingManager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packagingManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packagingManager: IPythonPackaging;
```

- *Type:* projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### ~~`pytest`~~<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.pytest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly pytest: Pytest;
```

- *Type:* projen.python.Pytest

Pytest component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedClients: {[ key: string ]: Project};
```

- *Type:* {[ key: string ]: projen.Project}

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedPythonClient`~~<sup>Required</sup> <a name="generatedPythonClient" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedPythonClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedPythonClient: PythonProject;
```

- *Type:* projen.python.PythonProject

A reference to the generated python client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specDir: string;
```

- *Type:* string

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specFileName: string;
```

- *Type:* string

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayTsProject <a name="SmithyApiGatewayTsProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject"></a>

Synthesizes a Typescript Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer"></a>

```typescript
import { SmithyApiGatewayTsProject } from '@aws-prototyping-sdk/open-api-gateway'

new SmithyApiGatewayTsProject(options: SmithyApiGatewayTsProjectOptions)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.options">options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions">SmithyApiGatewayTsProjectOptions</a></code> | *No description.* |

---

##### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.options"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions">SmithyApiGatewayTsProjectOptions</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addExcludeFromCleanup"></a>

```typescript
public addExcludeFromCleanup(globs: string): void
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* string

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addGitIgnore"></a>

```typescript
public addGitIgnore(pattern: string): void
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* string

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addPackageIgnore"></a>

```typescript
public addPackageIgnore(pattern: string): void
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* string

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTask"></a>

```typescript
public addTask(name: string, props?: TaskOptions): Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTask.parameter.name"></a>

- *Type:* string

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTask.parameter.props"></a>

- *Type:* projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTip"></a>

```typescript
public addTip(message: string): void
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTip.parameter.message"></a>

- *Type:* string

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.annotateGenerated"></a>

```typescript
public annotateGenerated(glob: string): void
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* string

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.postSynthesize"></a>

```typescript
public postSynthesize(): void
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.preSynthesize"></a>

```typescript
public preSynthesize(): void
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.removeTask"></a>

```typescript
public removeTask(name: string): Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.removeTask.parameter.name"></a>

- *Type:* string

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.runTaskCommand"></a>

```typescript
public runTaskCommand(task: Task): string
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.synth"></a>

```typescript
public synth(): void
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindFile"></a>

```typescript
public tryFindFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindJsonFile"></a>

```typescript
public tryFindJsonFile(filePath: string): JsonFile
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindObjectFile"></a>

```typescript
public tryFindObjectFile(filePath: string): ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* string

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryRemoveFile"></a>

```typescript
public tryRemoveFile(filePath: string): FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* string

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addBins`~~ <a name="addBins" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addBins"></a>

```typescript
public addBins(bins: {[ key: string ]: string}): void
```

###### `bins`<sup>Required</sup> <a name="bins" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addBins.parameter.bins"></a>

- *Type:* {[ key: string ]: string}

---

##### ~~`addBundledDeps`~~ <a name="addBundledDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addBundledDeps"></a>

```typescript
public addBundledDeps(deps: string): void
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addCompileCommand"></a>

```typescript
public addCompileCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* string

---

##### ~~`addDeps`~~ <a name="addDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addDeps"></a>

```typescript
public addDeps(deps: string): void
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addDevDeps`~~ <a name="addDevDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addDevDeps"></a>

```typescript
public addDevDeps(deps: string): void
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addDevDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addFields`~~ <a name="addFields" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addFields"></a>

```typescript
public addFields(fields: {[ key: string ]: any}): void
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addFields.parameter.fields"></a>

- *Type:* {[ key: string ]: any}

The fields to set.

---

##### ~~`addKeywords`~~ <a name="addKeywords" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addKeywords"></a>

```typescript
public addKeywords(keywords: string): void
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addKeywords.parameter.keywords"></a>

- *Type:* string

The keywords to add.

---

##### ~~`addPeerDeps`~~ <a name="addPeerDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addPeerDeps"></a>

```typescript
public addPeerDeps(deps: string): void
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* string

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addScripts`~~ <a name="addScripts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addScripts"></a>

```typescript
public addScripts(scripts: {[ key: string ]: string}): void
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addScripts.parameter.scripts"></a>

- *Type:* {[ key: string ]: string}

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTestCommand"></a>

```typescript
public addTestCommand(commands: string): void
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.addTestCommand.parameter.commands"></a>

- *Type:* string

---

##### ~~`hasScript`~~ <a name="hasScript" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.hasScript"></a>

```typescript
public hasScript(name: string): boolean
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.hasScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### ~~`removeScript`~~ <a name="removeScript" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.removeScript"></a>

```typescript
public removeScript(name: string): void
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.removeScript.parameter.name"></a>

- *Type:* string

The name of the script.

---

##### ~~`renderWorkflowSetup`~~ <a name="renderWorkflowSetup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.renderWorkflowSetup"></a>

```typescript
public renderWorkflowSetup(options?: RenderWorkflowSetupOptions): JobStep[]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### ~~`setScript`~~ <a name="setScript" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.setScript"></a>

```typescript
public setScript(name: string, command: string): void
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.setScript.parameter.name"></a>

- *Type:* string

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.setScript.parameter.command"></a>

- *Type:* string

The command to execute.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.buildTask">buildTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.commitGenerated">commitGenerated</a></code> | <code>boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.compileTask">compileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.components">components</a></code> | <code>projen.Component[]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.ejected">ejected</a></code> | <code>boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.files">files</a></code> | <code>projen.FileBase[]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.name">name</a></code> | <code>string</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.outdir">outdir</a></code> | <code>string</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.packageTask">packageTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.postCompileTask">postCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.preCompileTask">preCompileTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.projectBuild">projectBuild</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.projenCommand">projenCommand</a></code> | <code>string</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.subprojects">subprojects</a></code> | <code>projen.Project[]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.testTask">testTask</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.defaultTask">defaultTask</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.initProject">initProject</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.projectType">projectType</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.autoApprove">autoApprove</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.devContainer">devContainer</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>string</code> | The build output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>string</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.entrypoint">entrypoint</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.manifest">manifest</a></code> | <code>any</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.packageManager">packageManager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.runScriptCommand">runScriptCommand</a></code> | <code>string</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.autoMerge">autoMerge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.buildWorkflow">buildWorkflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>string</code> | The job ID of the build workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>string</code> | Maximum node version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.minNodeVersion">minNodeVersion</a></code> | <code>string</code> | Minimum node.js version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.docsDirectory">docsDirectory</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.libdir">libdir</a></code> | <code>string</code> | The directory in which compiled .js files reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.srcdir">srcdir</a></code> | <code>string</code> | The directory in which the .ts sources reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.testdir">testdir</a></code> | <code>string</code> | The directory in which tests reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tsconfigDev">tsconfigDev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.watchTask">watchTask</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.docgen">docgen</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.apiSrcDir">apiSrcDir</a></code> | <code>string</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.generatedClients">generatedClients</a></code> | <code>{[ key: string ]: projen.Project}</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>string</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.generatedTypescriptClient">generatedTypescriptClient</a></code> | <code>projen.typescript.TypeScriptProject</code> | A reference to the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.specDir">specDir</a></code> | <code>string</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.specFileName">specFileName</a></code> | <code>string</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.pnpmWorkspace">pnpmWorkspace</a></code> | <code>projen.YamlFile</code> | Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildTask: Task;
```

- *Type:* projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly commitGenerated: boolean;
```

- *Type:* boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly compileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly components: Component[];
```

- *Type:* projen.Component[]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly deps: Dependencies;
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly ejected: boolean;
```

- *Type:* boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly files: FileBase[];
```

- *Type:* projen.FileBase[]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitattributes: GitAttributesFile;
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly logger: Logger;
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly name: string;
```

- *Type:* string

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly outdir: string;
```

- *Type:* string

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly packageTask: Task;
```

- *Type:* projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly postCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly preCompileTask: Task;
```

- *Type:* projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectBuild: ProjectBuild;
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projenCommand: string;
```

- *Type:* string

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly root: Project;
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly subprojects: Project[];
```

- *Type:* projen.Project[]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tasks: Tasks;
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testTask: Task;
```

- *Type:* projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly defaultTask: Task;
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly initProject: InitProject;
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly parent: Project;
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly projectType: ProjectType;
```

- *Type:* projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoApprove: AutoApprove;
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly devContainer: DevContainer;
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly github: GitHub;
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly gitpod: Gitpod;
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly vscode: VsCode;
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```typescript
public readonly allowLibraryDependencies: boolean;
```

- *Type:* boolean

---

##### ~~`artifactsDirectory`~~<sup>Required</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.artifactsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly artifactsDirectory: string;
```

- *Type:* string

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### ~~`artifactsJavascriptDirectory`~~<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.artifactsJavascriptDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly artifactsJavascriptDirectory: string;
```

- *Type:* string

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### ~~`bundler`~~<sup>Required</sup> <a name="bundler" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.bundler"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly bundler: Bundler;
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```typescript
public readonly entrypoint: string;
```

- *Type:* string

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```typescript
public readonly manifest: any;
```

- *Type:* any

---

##### ~~`npmrc`~~<sup>Required</sup> <a name="npmrc" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.npmrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly npmrc: NpmConfig;
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### ~~`package`~~<sup>Required</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.package"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly package: NodePackage;
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```typescript
public readonly packageManager: NodePackageManager;
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### ~~`runScriptCommand`~~<sup>Required</sup> <a name="runScriptCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.runScriptCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly runScriptCommand: string;
```

- *Type:* string

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### ~~`autoMerge`~~<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.autoMerge"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly autoMerge: AutoMerge;
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### ~~`buildWorkflow`~~<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.buildWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildWorkflow: BuildWorkflow;
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### ~~`buildWorkflowJobId`~~<sup>Optional</sup> <a name="buildWorkflowJobId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.buildWorkflowJobId"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly buildWorkflowJobId: string;
```

- *Type:* string

The job ID of the build workflow.

---

##### ~~`jest`~~<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.jest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly jest: Jest;
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### ~~`maxNodeVersion`~~<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.maxNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly maxNodeVersion: string;
```

- *Type:* string

Maximum node version required by this package.

---

##### ~~`minNodeVersion`~~<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.minNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly minNodeVersion: string;
```

- *Type:* string

Minimum node.js version required by this package.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.npmignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly npmignore: IgnoreFile;
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### ~~`prettier`~~<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.prettier"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly prettier: Prettier;
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```typescript
public readonly publisher: Publisher;
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### ~~`release`~~<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.release"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly release: Release;
```

- *Type:* projen.release.Release

Release management.

---

##### ~~`upgradeWorkflow`~~<sup>Optional</sup> <a name="upgradeWorkflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.upgradeWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly upgradeWorkflow: UpgradeDependencies;
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### ~~`docsDirectory`~~<sup>Required</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.docsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly docsDirectory: string;
```

- *Type:* string

---

##### ~~`libdir`~~<sup>Required</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.libdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly libdir: string;
```

- *Type:* string

The directory in which compiled .js files reside.

---

##### ~~`srcdir`~~<sup>Required</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.srcdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly srcdir: string;
```

- *Type:* string

The directory in which the .ts sources reside.

---

##### ~~`testdir`~~<sup>Required</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.testdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly testdir: string;
```

- *Type:* string

The directory in which tests reside.

---

##### ~~`tsconfigDev`~~<sup>Required</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tsconfigDev"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tsconfigDev: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### ~~`watchTask`~~<sup>Required</sup> <a name="watchTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.watchTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly watchTask: Task;
```

- *Type:* projen.Task

The "watch" task.

---

##### ~~`docgen`~~<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.docgen"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly docgen: boolean;
```

- *Type:* boolean

---

##### ~~`eslint`~~<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.eslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly eslint: Eslint;
```

- *Type:* projen.javascript.Eslint

---

##### ~~`tsconfig`~~<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tsconfig"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tsconfig: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### ~~`tsconfigEslint`~~<sup>Optional</sup> <a name="tsconfigEslint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.tsconfigEslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly tsconfigEslint: TypescriptConfig;
```

- *Type:* projen.javascript.TypescriptConfig

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly apiSrcDir: string;
```

- *Type:* string

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Required</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly forceGenerateCodeAndDocs: boolean;
```

- *Type:* boolean

Force to generate code and docs even if there were no changes in spec.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedClients: {[ key: string ]: Project};
```

- *Type:* {[ key: string ]: projen.Project}

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedCodeDir: string;
```

- *Type:* string

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedTypescriptClient`~~<sup>Required</sup> <a name="generatedTypescriptClient" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.generatedTypescriptClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly generatedTypescriptClient: TypeScriptProject;
```

- *Type:* projen.typescript.TypeScriptProject

A reference to the generated typescript client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specDir: string;
```

- *Type:* string

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly specFileName: string;
```

- *Type:* string

The name of the spec file.

---

##### ~~`pnpmWorkspace`~~<sup>Optional</sup> <a name="pnpmWorkspace" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.pnpmWorkspace"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly pnpmWorkspace: YamlFile;
```

- *Type:* projen.YamlFile

Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>string</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```typescript
public readonly DEFAULT_TASK: string;
```

- *Type:* string

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---


## Enums <a name="Enums" id="Enums"></a>

### ClientLanguage <a name="ClientLanguage" id="@aws-prototyping-sdk/open-api-gateway.ClientLanguage"></a>

Supported languages for client generation.

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage.TYPESCRIPT">TYPESCRIPT</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage.PYTHON">PYTHON</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage.JAVA">JAVA</a></code> | *No description.* |

---

##### `TYPESCRIPT` <a name="TYPESCRIPT" id="@aws-prototyping-sdk/open-api-gateway.ClientLanguage.TYPESCRIPT"></a>

---


##### `PYTHON` <a name="PYTHON" id="@aws-prototyping-sdk/open-api-gateway.ClientLanguage.PYTHON"></a>

---


##### `JAVA` <a name="JAVA" id="@aws-prototyping-sdk/open-api-gateway.ClientLanguage.JAVA"></a>

---


### CustomAuthorizerType <a name="CustomAuthorizerType" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType"></a>

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType.TOKEN">TOKEN</a></code> | A custom authorizer that uses a Lambda function. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType.REQUEST">REQUEST</a></code> | An authorizer that uses a Lambda function using incoming request parameters. |

---

##### `TOKEN` <a name="TOKEN" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType.TOKEN"></a>

A custom authorizer that uses a Lambda function.

---


##### `REQUEST` <a name="REQUEST" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType.REQUEST"></a>

An authorizer that uses a Lambda function using incoming request parameters.

---


### DocumentationFormat <a name="DocumentationFormat" id="@aws-prototyping-sdk/open-api-gateway.DocumentationFormat"></a>

Formats for documentation generation.

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.HTML_REDOC">HTML_REDOC</a></code> | HTML Documentation generated by redoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.HTML2">HTML2</a></code> | OpenAPI Generator 'html2' documentation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.MARKDOWN">MARKDOWN</a></code> | OpenAPI Generator 'markdown' documentation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.PLANTUML">PLANTUML</a></code> | OpenAPI Generator 'plantuml' documentation. |

---

##### `HTML_REDOC` <a name="HTML_REDOC" id="@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.HTML_REDOC"></a>

HTML Documentation generated by redoc.

> [https://github.com/Redocly/redoc](https://github.com/Redocly/redoc)

---


##### `HTML2` <a name="HTML2" id="@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.HTML2"></a>

OpenAPI Generator 'html2' documentation.

> [https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md](https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md)

---


##### `MARKDOWN` <a name="MARKDOWN" id="@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.MARKDOWN"></a>

OpenAPI Generator 'markdown' documentation.

> [https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md](https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md)

---


##### `PLANTUML` <a name="PLANTUML" id="@aws-prototyping-sdk/open-api-gateway.DocumentationFormat.PLANTUML"></a>

OpenAPI Generator 'plantuml' documentation.

> [https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md](https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md)

---

