# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### OpenApiGatewayRestApi <a name="OpenApiGatewayRestApi" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi"></a>

A construct for creating an api gateway rest api based on the definition in the OpenAPI spec.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayRestApi(
  scope: Construct,
  id: str,
  cloud_watch_role: bool = None,
  deploy: bool = None,
  deploy_options: StageOptions = None,
  description: str = None,
  disable_execute_api_endpoint: bool = None,
  domain_name: DomainNameOptions = None,
  endpoint_export_name: str = None,
  endpoint_types: typing.List[EndpointType] = None,
  fail_on_warnings: bool = None,
  parameters: typing.Mapping[str] = None,
  policy: PolicyDocument = None,
  rest_api_name: str = None,
  retain_deployments: bool = None,
  integrations: typing.Mapping[OpenApiIntegration],
  operation_lookup: typing.Mapping[MethodAndPath],
  cors_options: CorsOptions = None,
  default_authorizer: Authorizer = None,
  spec: typing.Any,
  spec_path: str,
  web_acl_options: OpenApiGatewayWebAclOptions = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.cloudWatchRole">cloud_watch_role</a></code> | <code>bool</code> | Automatically configure an AWS CloudWatch role for API Gateway. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deploy">deploy</a></code> | <code>bool</code> | Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deployOptions">deploy_options</a></code> | <code>aws_cdk.aws_apigateway.StageOptions</code> | Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.description">description</a></code> | <code>str</code> | A description of the RestApi construct. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.disableExecuteApiEndpoint">disable_execute_api_endpoint</a></code> | <code>bool</code> | Specifies whether clients can invoke the API using the default execute-api endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.domainName">domain_name</a></code> | <code>aws_cdk.aws_apigateway.DomainNameOptions</code> | Configure a custom domain name and map it to this API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointExportName">endpoint_export_name</a></code> | <code>str</code> | Export name for the CfnOutput containing the API endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointTypes">endpoint_types</a></code> | <code>typing.List[aws_cdk.aws_apigateway.EndpointType]</code> | A list of the endpoint types of the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.failOnWarnings">fail_on_warnings</a></code> | <code>bool</code> | Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.parameters">parameters</a></code> | <code>typing.Mapping[str]</code> | Custom header parameters for the request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.policy">policy</a></code> | <code>aws_cdk.aws_iam.PolicyDocument</code> | A policy document that contains the permissions for this RestApi. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.restApiName">rest_api_name</a></code> | <code>str</code> | A name for the API Gateway RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.retainDeployments">retain_deployments</a></code> | <code>bool</code> | Retains old deployment resources when the API changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.integrations">integrations</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>]</code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.operationLookup">operation_lookup</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>]</code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.corsOptions">cors_options</a></code> | <code>aws_cdk.aws_apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.defaultAuthorizer">default_authorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.spec">spec</a></code> | <code>typing.Any</code> | The parsed OpenAPI specification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.specPath">spec_path</a></code> | <code>str</code> | Path to the JSON open api spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.webAclOptions">web_acl_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a></code> | Options for the AWS WAF v2 WebACL associated with the api. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.id"></a>

- *Type:* str

---

##### `cloud_watch_role`<sup>Optional</sup> <a name="cloud_watch_role" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.cloudWatchRole"></a>

- *Type:* bool
- *Default:* false if `@aws-cdk/aws-apigateway:disableCloudWatchRole` is enabled, true otherwise

Automatically configure an AWS CloudWatch role for API Gateway.

---

##### `deploy`<sup>Optional</sup> <a name="deploy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deploy"></a>

- *Type:* bool
- *Default:* true

Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

Since API Gateway deployments are immutable, When this option is enabled
(by default), an AWS::ApiGateway::Deployment resource will automatically
created with a logical ID that hashes the API model (methods, resources
and options). This means that when the model changes, the logical ID of
this CloudFormation resource will change, and a new deployment will be
created.

If this is set, `latestDeployment` will refer to the `Deployment` object
and `deploymentStage` will refer to a `Stage` that points to this
deployment. To customize the stage options, use the `deployOptions`
property.

A CloudFormation Output will also be defined with the root URL endpoint
of this REST API.

---

##### `deploy_options`<sup>Optional</sup> <a name="deploy_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deployOptions"></a>

- *Type:* aws_cdk.aws_apigateway.StageOptions
- *Default:* Based on defaults of `StageOptions`.

Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.

If `deploy` is disabled,
this value cannot be set.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.description"></a>

- *Type:* str
- *Default:* 'Automatically created by the RestApi construct'

A description of the RestApi construct.

---

##### `disable_execute_api_endpoint`<sup>Optional</sup> <a name="disable_execute_api_endpoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.disableExecuteApiEndpoint"></a>

- *Type:* bool
- *Default:* false

Specifies whether clients can invoke the API using the default execute-api endpoint.

To require that clients use a custom domain name to invoke the
API, disable the default endpoint.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html)

---

##### `domain_name`<sup>Optional</sup> <a name="domain_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.domainName"></a>

- *Type:* aws_cdk.aws_apigateway.DomainNameOptions
- *Default:* no domain name is defined, use `addDomainName` or directly define a `DomainName`.

Configure a custom domain name and map it to this API.

---

##### `endpoint_export_name`<sup>Optional</sup> <a name="endpoint_export_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointExportName"></a>

- *Type:* str
- *Default:* when no export name is given, output will be created without export

Export name for the CfnOutput containing the API endpoint.

---

##### `endpoint_types`<sup>Optional</sup> <a name="endpoint_types" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointTypes"></a>

- *Type:* typing.List[aws_cdk.aws_apigateway.EndpointType]
- *Default:* EndpointType.EDGE

A list of the endpoint types of the API.

Use this property when creating
an API.

---

##### `fail_on_warnings`<sup>Optional</sup> <a name="fail_on_warnings" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.failOnWarnings"></a>

- *Type:* bool
- *Default:* false

Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.parameters"></a>

- *Type:* typing.Mapping[str]
- *Default:* No parameters.

Custom header parameters for the request.

> [https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html](https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html)

---

##### `policy`<sup>Optional</sup> <a name="policy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.policy"></a>

- *Type:* aws_cdk.aws_iam.PolicyDocument
- *Default:* No policy.

A policy document that contains the permissions for this RestApi.

---

##### `rest_api_name`<sup>Optional</sup> <a name="rest_api_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.restApiName"></a>

- *Type:* str
- *Default:* ID of the RestApi construct.

A name for the API Gateway RestApi resource.

---

##### `retain_deployments`<sup>Optional</sup> <a name="retain_deployments" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.retainDeployments"></a>

- *Type:* bool
- *Default:* false

Retains old deployment resources when the API changes.

This allows
manually reverting stages to point to old deployments via the AWS
Console.

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.integrations"></a>

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>]

A mapping of API operation to its integration.

---

##### `operation_lookup`<sup>Required</sup> <a name="operation_lookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.operationLookup"></a>

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>]

Details about each operation.

---

##### `cors_options`<sup>Optional</sup> <a name="cors_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.corsOptions"></a>

- *Type:* aws_cdk.aws_apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `default_authorizer`<sup>Optional</sup> <a name="default_authorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.defaultAuthorizer"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

##### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.spec"></a>

- *Type:* typing.Any

The parsed OpenAPI specification.

---

##### `spec_path`<sup>Required</sup> <a name="spec_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.specPath"></a>

- *Type:* str

Path to the JSON open api spec.

---

##### `web_acl_options`<sup>Optional</sup> <a name="web_acl_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.webAclOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a>

Options for the AWS WAF v2 WebACL associated with the api.

By default, a Web ACL with the AWS default managed
rule set will be associated with the API. These options may disable or override the defaults.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayRestApi.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.api">api</a></code> | <code>aws_cdk.aws_apigateway.SpecRestApi</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.ipSet">ip_set</a></code> | <code>aws_cdk.aws_wafv2.CfnIPSet</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAcl">web_acl</a></code> | <code>aws_cdk.aws_wafv2.CfnWebACL</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAclAssociation">web_acl_association</a></code> | <code>aws_cdk.aws_wafv2.CfnWebACLAssociation</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.api"></a>

```python
api: SpecRestApi
```

- *Type:* aws_cdk.aws_apigateway.SpecRestApi

---

##### `ip_set`<sup>Optional</sup> <a name="ip_set" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.ipSet"></a>

```python
ip_set: CfnIPSet
```

- *Type:* aws_cdk.aws_wafv2.CfnIPSet

---

##### `web_acl`<sup>Optional</sup> <a name="web_acl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAcl"></a>

```python
web_acl: CfnWebACL
```

- *Type:* aws_cdk.aws_wafv2.CfnWebACL

---

##### `web_acl_association`<sup>Optional</sup> <a name="web_acl_association" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAclAssociation"></a>

```python
web_acl_association: CfnWebACLAssociation
```

- *Type:* aws_cdk.aws_wafv2.CfnWebACLAssociation

---


## Structs <a name="Structs" id="Structs"></a>

### ApiGatewayIntegration <a name="ApiGatewayIntegration" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration"></a>

Represents an api gateway integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.ApiGatewayIntegration(
  cache_key_parameters: typing.List[str] = None,
  cache_namespace: str = None,
  connection_id: str = None,
  connection_type: str = None,
  content_handling: str = None,
  credentials: str = None,
  http_method: str = None,
  passthrough_behavior: str = None,
  request_parameters: typing.Mapping[str] = None,
  request_templates: typing.Mapping[str] = None,
  responses: typing.Mapping[ApiGatewayIntegrationResponse] = None,
  timeout_in_millis: typing.Union[int, float] = None,
  tls_config: ApiGatewayIntegrationTlsConfig = None,
  type: str = None,
  uri: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheKeyParameters">cache_key_parameters</a></code> | <code>typing.List[str]</code> | A list of request parameters whose values are to be cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheNamespace">cache_namespace</a></code> | <code>str</code> | An API-specific tag group of related cached parameters. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionId">connection_id</a></code> | <code>str</code> | The ID of a VpcLink for the private integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionType">connection_type</a></code> | <code>str</code> | The integration connection type. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.contentHandling">content_handling</a></code> | <code>str</code> | Request payload encoding conversion types. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.credentials">credentials</a></code> | <code>str</code> | For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.httpMethod">http_method</a></code> | <code>str</code> | The HTTP method used in the integration request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.passthroughBehavior">passthrough_behavior</a></code> | <code>str</code> | Specifies how a request payload of unmapped content type is passed through the integration request without modification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestParameters">request_parameters</a></code> | <code>typing.Mapping[str]</code> | Specifies mappings from method request parameters to integration request parameters. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestTemplates">request_templates</a></code> | <code>typing.Mapping[str]</code> | Mapping templates for a request payload of specified MIME types. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.responses">responses</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse">ApiGatewayIntegrationResponse</a>]</code> | Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.timeoutInMillis">timeout_in_millis</a></code> | <code>typing.Union[int, float]</code> | Custom timeout between 50 and 29,000 milliseconds. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.tlsConfig">tls_config</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig">ApiGatewayIntegrationTlsConfig</a></code> | Specifies the TLS configuration for an integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.type">type</a></code> | <code>str</code> | The type of integration with the specified backend. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.uri">uri</a></code> | <code>str</code> | The endpoint URI of the backend. |

---

##### `cache_key_parameters`<sup>Optional</sup> <a name="cache_key_parameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheKeyParameters"></a>

```python
cache_key_parameters: typing.List[str]
```

- *Type:* typing.List[str]

A list of request parameters whose values are to be cached.

---

##### `cache_namespace`<sup>Optional</sup> <a name="cache_namespace" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheNamespace"></a>

```python
cache_namespace: str
```

- *Type:* str

An API-specific tag group of related cached parameters.

---

##### `connection_id`<sup>Optional</sup> <a name="connection_id" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionId"></a>

```python
connection_id: str
```

- *Type:* str

The ID of a VpcLink for the private integration.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html](https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html)

---

##### `connection_type`<sup>Optional</sup> <a name="connection_type" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionType"></a>

```python
connection_type: str
```

- *Type:* str

The integration connection type.

The valid value is "VPC_LINK" for private integration or "INTERNET", otherwise.

---

##### `content_handling`<sup>Optional</sup> <a name="content_handling" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.contentHandling"></a>

```python
content_handling: str
```

- *Type:* str

Request payload encoding conversion types.

Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
base64-decoded blob or passing through a binary payload natively without modification.

---

##### `credentials`<sup>Optional</sup> <a name="credentials" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.credentials"></a>

```python
credentials: str
```

- *Type:* str

For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role.

If unspecified, credentials default
to resource-based permissions that must be added manually to allow the API to access the resource. For more
information, see Granting Permissions Using a Resource Policy.

Note: When using IAM credentials, make sure that AWS STS Regional endpoints are enabled for the Region where this
API is deployed for best performance.

---

##### `http_method`<sup>Optional</sup> <a name="http_method" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.httpMethod"></a>

```python
http_method: str
```

- *Type:* str

The HTTP method used in the integration request.

For Lambda function invocations, the value must be POST.

---

##### `passthrough_behavior`<sup>Optional</sup> <a name="passthrough_behavior" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.passthroughBehavior"></a>

```python
passthrough_behavior: str
```

- *Type:* str

Specifies how a request payload of unmapped content type is passed through the integration request without modification.

Supported values are when_no_templates, when_no_match, and never.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior)

---

##### `request_parameters`<sup>Optional</sup> <a name="request_parameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestParameters"></a>

```python
request_parameters: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Specifies mappings from method request parameters to integration request parameters.

Supported request parameters
are querystring, path, header, and body.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html)

---

##### `request_templates`<sup>Optional</sup> <a name="request_templates" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestTemplates"></a>

```python
request_templates: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Mapping templates for a request payload of specified MIME types.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html)

---

##### `responses`<sup>Optional</sup> <a name="responses" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.responses"></a>

```python
responses: typing.Mapping[ApiGatewayIntegrationResponse]
```

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse">ApiGatewayIntegrationResponse</a>]

Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html)

---

##### `timeout_in_millis`<sup>Optional</sup> <a name="timeout_in_millis" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.timeoutInMillis"></a>

```python
timeout_in_millis: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Custom timeout between 50 and 29,000 milliseconds.

The default value is 29,000 milliseconds or 29 seconds.

---

##### `tls_config`<sup>Optional</sup> <a name="tls_config" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.tlsConfig"></a>

```python
tls_config: ApiGatewayIntegrationTlsConfig
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig">ApiGatewayIntegrationTlsConfig</a>

Specifies the TLS configuration for an integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.type"></a>

```python
type: str
```

- *Type:* str

The type of integration with the specified backend.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type)

---

##### `uri`<sup>Optional</sup> <a name="uri" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.uri"></a>

```python
uri: str
```

- *Type:* str

The endpoint URI of the backend.

For integrations of the aws type, this is an ARN value.
For the HTTP integration, this is the URL of the HTTP endpoint including the https or http scheme.

---

### ApiGatewayIntegrationResponse <a name="ApiGatewayIntegrationResponse" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse"></a>

API Gateway integration response.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.ApiGatewayIntegrationResponse(
  response_parameters: typing.Mapping[str],
  response_templates: typing.Mapping[str],
  status_code: str,
  content_handling: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseParameters">response_parameters</a></code> | <code>typing.Mapping[str]</code> | Specifies parameter mappings for the response. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseTemplates">response_templates</a></code> | <code>typing.Mapping[str]</code> | Specifies MIME type-specific mapping templates for the response’s payload. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.statusCode">status_code</a></code> | <code>str</code> | HTTP status code for the method response. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.contentHandling">content_handling</a></code> | <code>str</code> | Response payload encoding conversion types. |

---

##### `response_parameters`<sup>Required</sup> <a name="response_parameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseParameters"></a>

```python
response_parameters: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Specifies parameter mappings for the response.

---

##### `response_templates`<sup>Required</sup> <a name="response_templates" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseTemplates"></a>

```python
response_templates: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Specifies MIME type-specific mapping templates for the response’s payload.

---

##### `status_code`<sup>Required</sup> <a name="status_code" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.statusCode"></a>

```python
status_code: str
```

- *Type:* str

HTTP status code for the method response.

---

##### `content_handling`<sup>Optional</sup> <a name="content_handling" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.contentHandling"></a>

```python
content_handling: str
```

- *Type:* str

Response payload encoding conversion types.

Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
base64-decoded blob or passing through a binary payload natively without modification.

---

### ApiGatewayIntegrationTlsConfig <a name="ApiGatewayIntegrationTlsConfig" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig"></a>

Specifies the TLS configuration for an integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.ApiGatewayIntegrationTlsConfig(
  insecure_skip_verification: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.property.insecureSkipVerification">insecure_skip_verification</a></code> | <code>bool</code> | Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority. |

---

##### `insecure_skip_verification`<sup>Optional</sup> <a name="insecure_skip_verification" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.property.insecureSkipVerification"></a>

```python
insecure_skip_verification: bool
```

- *Type:* bool

Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority.

This isn’t recommended, but it enables you to use certificates that are
signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still
performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and
presence of a root certificate authority. Supported only for HTTP and HTTP_PROXY integrations.

---

### AuthorizerProps <a name="AuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps"></a>

Properties for an authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.AuthorizerProps(
  authorization_type: AuthorizationType,
  authorizer_id: str,
  authorization_scopes: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationType"></a>

```python
authorization_type: AuthorizationType
```

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.CidrAllowList(
  cidr_ranges: typing.List[str],
  cidr_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrRanges">cidr_ranges</a></code> | <code>typing.List[str]</code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrType">cidr_type</a></code> | <code>str</code> | Type of CIDR range. |

---

##### `cidr_ranges`<sup>Required</sup> <a name="cidr_ranges" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrRanges"></a>

```python
cidr_ranges: typing.List[str]
```

- *Type:* typing.List[str]

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidr_type`<sup>Required</sup> <a name="cidr_type" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrType"></a>

```python
cidr_type: str
```

- *Type:* str

Type of CIDR range.

---

### CognitoAuthorizerProps <a name="CognitoAuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps"></a>

Properties used to configure a cognito authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.CognitoAuthorizerProps(
  authorizer_id: str,
  user_pools: typing.List[IUserPool],
  authorization_scopes: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizerId">authorizer_id</a></code> | <code>str</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.userPools">user_pools</a></code> | <code>typing.List[aws_cdk.aws_cognito.IUserPool]</code> | The Cognito user pools associated with this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | A list of authorization scopes configured on the method. |

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

Unique identifier for this authorizer.

---

##### `user_pools`<sup>Required</sup> <a name="user_pools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.userPools"></a>

```python
user_pools: typing.List[IUserPool]
```

- *Type:* typing.List[aws_cdk.aws_cognito.IUserPool]

The Cognito user pools associated with this authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

A list of authorization scopes configured on the method.

When used as the default authorizer, these scopes will be
applied to all methods without an authorizer at the integration level.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

---

### CommonApiProjectOptions <a name="CommonApiProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.CommonApiProjectOptions(
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

### CustomAuthorizerProps <a name="CustomAuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps"></a>

Properties used to configure a custom authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.CustomAuthorizerProps(
  authorizer_id: str,
  function: IFunction,
  authorizer_result_ttl_in_seconds: typing.Union[int, float] = None,
  identity_source: str = None,
  type: CustomAuthorizerType = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerId">authorizer_id</a></code> | <code>str</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.function">function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerResultTtlInSeconds">authorizer_result_ttl_in_seconds</a></code> | <code>typing.Union[int, float]</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.identitySource">identity_source</a></code> | <code>str</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

Unique identifier for this authorizer.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.function"></a>

```python
function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

The lambda function used to authorize requests.

---

##### `authorizer_result_ttl_in_seconds`<sup>Optional</sup> <a name="authorizer_result_ttl_in_seconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerResultTtlInSeconds"></a>

```python
authorizer_result_ttl_in_seconds: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 300

The number of seconds during which the authorizer result is cached.

---

##### `identity_source`<sup>Optional</sup> <a name="identity_source" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.identitySource"></a>

```python
identity_source: str
```

- *Type:* str
- *Default:* "method.request.header.Authorization"

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.type"></a>

```python
type: CustomAuthorizerType
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>
- *Default:* CustomAuthorizerType.TOKEN

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---

### IntegrationGrantProps <a name="IntegrationGrantProps" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps"></a>

Properties for granting the API access to invoke the operation.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.IntegrationGrantProps(
  method: str,
  path: str,
  api: SpecRestApi,
  operation_id: str,
  scope: Construct
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.method">method</a></code> | <code>str</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.path">path</a></code> | <code>str</code> | The path of this operation in the api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.api">api</a></code> | <code>aws_cdk.aws_apigateway.SpecRestApi</code> | The api to grant permissions for. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.operationId">operation_id</a></code> | <code>str</code> | The ID of the operation for which permissions are being granted. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which permission resources can be created. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.method"></a>

```python
method: str
```

- *Type:* str

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.path"></a>

```python
path: str
```

- *Type:* str

The path of this operation in the api.

---

##### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.api"></a>

```python
api: SpecRestApi
```

- *Type:* aws_cdk.aws_apigateway.SpecRestApi

The api to grant permissions for.

---

##### `operation_id`<sup>Required</sup> <a name="operation_id" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.operationId"></a>

```python
operation_id: str
```

- *Type:* str

The ID of the operation for which permissions are being granted.

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.scope"></a>

```python
scope: Construct
```

- *Type:* constructs.Construct

The scope in which permission resources can be created.

---

### IntegrationRenderProps <a name="IntegrationRenderProps" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps"></a>

Properties for rendering an integration into an API Gateway OpenAPI extension.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.IntegrationRenderProps(
  method: str,
  path: str,
  operation_id: str,
  scope: Construct
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.method">method</a></code> | <code>str</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.path">path</a></code> | <code>str</code> | The path of this operation in the api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.operationId">operation_id</a></code> | <code>str</code> | The ID of the operation being rendered. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which the integration is being rendered. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.method"></a>

```python
method: str
```

- *Type:* str

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.path"></a>

```python
path: str
```

- *Type:* str

The path of this operation in the api.

---

##### `operation_id`<sup>Required</sup> <a name="operation_id" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.operationId"></a>

```python
operation_id: str
```

- *Type:* str

The ID of the operation being rendered.

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.scope"></a>

```python
scope: Construct
```

- *Type:* constructs.Construct

The scope in which the integration is being rendered.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.ManagedRule(
  name: str,
  vendor: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.name">name</a></code> | <code>str</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.vendor">vendor</a></code> | <code>str</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.name"></a>

```python
name: str
```

- *Type:* str

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.vendor"></a>

```python
vendor: str
```

- *Type:* str

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### MethodAndPath <a name="MethodAndPath" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath"></a>

Structure to contain an API operation's method and path.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.MethodAndPath(
  method: str,
  path: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.method">method</a></code> | <code>str</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.path">path</a></code> | <code>str</code> | The path of this operation in the api. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.method"></a>

```python
method: str
```

- *Type:* str

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.path"></a>

```python
path: str
```

- *Type:* str

The path of this operation in the api.

---

### OpenApiGatewayJavaProjectOptions <a name="OpenApiGatewayJavaProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions"></a>

Configuration for the OpenApiGatewayJavaProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayJavaProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  artifact_id: str,
  group_id: str,
  version: str,
  description: str = None,
  packaging: str = None,
  url: str = None,
  compile_options: MavenCompileOptions = None,
  deps: typing.List[str] = None,
  distdir: str = None,
  junit: bool = None,
  junit_options: JunitOptions = None,
  packaging_options: MavenPackagingOptions = None,
  projenrc_java: bool = None,
  projenrc_java_options: ProjenrcOptions = None,
  test_deps: typing.List[str] = None,
  sample: bool = None,
  sample_java_package: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.artifactId">artifact_id</a></code> | <code>str</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.groupId">group_id</a></code> | <code>str</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.version">version</a></code> | <code>str</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.description">description</a></code> | <code>str</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packaging">packaging</a></code> | <code>str</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.url">url</a></code> | <code>str</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.compileOptions">compile_options</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.distdir">distdir</a></code> | <code>str</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junit">junit</a></code> | <code>bool</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junitOptions">junit_options</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packagingOptions">packaging_options</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJava">projenrc_java</a></code> | <code>bool</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJavaOptions">projenrc_java_options</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.testDeps">test_deps</a></code> | <code>typing.List[str]</code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sampleJavaPackage">sample_java_package</a></code> | <code>str</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.artifactId"></a>

```python
artifact_id: str
```

- *Type:* str
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `group_id`<sup>Required</sup> <a name="group_id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.groupId"></a>

```python
group_id: str
```

- *Type:* str
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.version"></a>

```python
version: str
```

- *Type:* str
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packaging"></a>

```python
packaging: str
```

- *Type:* str
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.url"></a>

```python
url: str
```

- *Type:* str
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compile_options`<sup>Optional</sup> <a name="compile_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.compileOptions"></a>

```python
compile_options: MavenCompileOptions
```

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.distdir"></a>

```python
distdir: str
```

- *Type:* str
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junit"></a>

```python
junit: bool
```

- *Type:* bool
- *Default:* true

Include junit tests.

---

##### `junit_options`<sup>Optional</sup> <a name="junit_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junitOptions"></a>

```python
junit_options: JunitOptions
```

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packaging_options`<sup>Optional</sup> <a name="packaging_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packagingOptions"></a>

```python
packaging_options: MavenPackagingOptions
```

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrc_java`<sup>Optional</sup> <a name="projenrc_java" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJava"></a>

```python
projenrc_java: bool
```

- *Type:* bool
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrc_java_options`<sup>Optional</sup> <a name="projenrc_java_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJavaOptions"></a>

```python
projenrc_java_options: ProjenrcOptions
```

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `test_deps`<sup>Optional</sup> <a name="test_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.testDeps"></a>

```python
test_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sample"></a>

```python
sample: bool
```

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sample_java_package`<sup>Optional</sup> <a name="sample_java_package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sampleJavaPackage"></a>

```python
sample_java_package: str
```

- *Type:* str
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.specFile"></a>

```python
spec_file: str
```

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayProjectOptions <a name="OpenApiGatewayProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions"></a>

Options common to all open api gateway projects.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayProjectOptions(
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.specFile"></a>

```python
spec_file: str
```

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayPythonProjectOptions <a name="OpenApiGatewayPythonProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions"></a>

Configuration for the OpenApiGatewayPythonProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayPythonProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  author_email: str,
  author_name: str,
  version: str,
  classifiers: typing.List[str] = None,
  description: str = None,
  homepage: str = None,
  license: str = None,
  package_name: str = None,
  poetry_options: PoetryPyprojectOptionsWithoutDeps = None,
  setup_config: typing.Mapping[typing.Any] = None,
  module_name: str,
  deps: typing.List[str] = None,
  dev_deps: typing.List[str] = None,
  pip: bool = None,
  poetry: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projenrc_python: bool = None,
  projenrc_python_options: ProjenrcOptions = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcTsOptions = None,
  pytest: bool = None,
  pytest_options: PytestOptions = None,
  python_exec: str = None,
  sample: bool = None,
  setuptools: bool = None,
  venv: bool = None,
  venv_options: VenvOptions = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.version">version</a></code> | <code>str</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.classifiers">classifiers</a></code> | <code>typing.List[str]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.description">description</a></code> | <code>str</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.license">license</a></code> | <code>str</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetryOptions">poetry_options</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setupConfig">setup_config</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.moduleName">module_name</a></code> | <code>str</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pip">pip</a></code> | <code>bool</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetry">poetry</a></code> | <code>bool</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPython">projenrc_python</a></code> | <code>bool</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPythonOptions">projenrc_python_options</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytest">pytest</a></code> | <code>bool</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytestOptions">pytest_options</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonExec">python_exec</a></code> | <code>str</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setuptools">setuptools</a></code> | <code>bool</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venv">venv</a></code> | <code>bool</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venvOptions">venv_options</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `author_email`<sup>Required</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `author_name`<sup>Required</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.version"></a>

```python
version: str
```

- *Type:* str
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.classifiers"></a>

```python
classifiers: typing.List[str]
```

- *Type:* typing.List[str]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str

License of this package as an SPDX identifier.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str

Package name.

---

##### `poetry_options`<sup>Optional</sup> <a name="poetry_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetryOptions"></a>

```python
poetry_options: PoetryPyprojectOptionsWithoutDeps
```

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setup_config`<sup>Optional</sup> <a name="setup_config" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setupConfig"></a>

```python
setup_config: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

Additional fields to pass in the setup() function if using setuptools.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.moduleName"></a>

```python
module_name: str
```

- *Type:* str
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pip"></a>

```python
pip: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetry"></a>

```python
poetry: bool
```

- *Type:* bool
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrc_python`<sup>Optional</sup> <a name="projenrc_python" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPython"></a>

```python
projenrc_python: bool
```

- *Type:* bool
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrc_python_options`<sup>Optional</sup> <a name="projenrc_python_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPythonOptions"></a>

```python
projenrc_python_options: ProjenrcOptions
```

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcTsOptions
```

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytest"></a>

```python
pytest: bool
```

- *Type:* bool
- *Default:* true

Include pytest tests.

---

##### `pytest_options`<sup>Optional</sup> <a name="pytest_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytestOptions"></a>

```python
pytest_options: PytestOptions
```

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `python_exec`<sup>Optional</sup> <a name="python_exec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonExec"></a>

```python
python_exec: str
```

- *Type:* str
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.sample"></a>

```python
sample: bool
```

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setuptools"></a>

```python
setuptools: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venv"></a>

```python
venv: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venv_options`<sup>Optional</sup> <a name="venv_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venvOptions"></a>

```python
venv_options: VenvOptions
```

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.specFile"></a>

```python
spec_file: str
```

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayRestApiProps <a name="OpenApiGatewayRestApiProps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps"></a>

Configuration for the OpenApiGatewayRestApi construct.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayRestApiProps(
  cloud_watch_role: bool = None,
  deploy: bool = None,
  deploy_options: StageOptions = None,
  description: str = None,
  disable_execute_api_endpoint: bool = None,
  domain_name: DomainNameOptions = None,
  endpoint_export_name: str = None,
  endpoint_types: typing.List[EndpointType] = None,
  fail_on_warnings: bool = None,
  parameters: typing.Mapping[str] = None,
  policy: PolicyDocument = None,
  rest_api_name: str = None,
  retain_deployments: bool = None,
  integrations: typing.Mapping[OpenApiIntegration],
  operation_lookup: typing.Mapping[MethodAndPath],
  cors_options: CorsOptions = None,
  default_authorizer: Authorizer = None,
  spec: typing.Any,
  spec_path: str,
  web_acl_options: OpenApiGatewayWebAclOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.cloudWatchRole">cloud_watch_role</a></code> | <code>bool</code> | Automatically configure an AWS CloudWatch role for API Gateway. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deploy">deploy</a></code> | <code>bool</code> | Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deployOptions">deploy_options</a></code> | <code>aws_cdk.aws_apigateway.StageOptions</code> | Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.description">description</a></code> | <code>str</code> | A description of the RestApi construct. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.disableExecuteApiEndpoint">disable_execute_api_endpoint</a></code> | <code>bool</code> | Specifies whether clients can invoke the API using the default execute-api endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.domainName">domain_name</a></code> | <code>aws_cdk.aws_apigateway.DomainNameOptions</code> | Configure a custom domain name and map it to this API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointExportName">endpoint_export_name</a></code> | <code>str</code> | Export name for the CfnOutput containing the API endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointTypes">endpoint_types</a></code> | <code>typing.List[aws_cdk.aws_apigateway.EndpointType]</code> | A list of the endpoint types of the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.failOnWarnings">fail_on_warnings</a></code> | <code>bool</code> | Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.parameters">parameters</a></code> | <code>typing.Mapping[str]</code> | Custom header parameters for the request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.policy">policy</a></code> | <code>aws_cdk.aws_iam.PolicyDocument</code> | A policy document that contains the permissions for this RestApi. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.restApiName">rest_api_name</a></code> | <code>str</code> | A name for the API Gateway RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.retainDeployments">retain_deployments</a></code> | <code>bool</code> | Retains old deployment resources when the API changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.integrations">integrations</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>]</code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.operationLookup">operation_lookup</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>]</code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.corsOptions">cors_options</a></code> | <code>aws_cdk.aws_apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.defaultAuthorizer">default_authorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.spec">spec</a></code> | <code>typing.Any</code> | The parsed OpenAPI specification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.specPath">spec_path</a></code> | <code>str</code> | Path to the JSON open api spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.webAclOptions">web_acl_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a></code> | Options for the AWS WAF v2 WebACL associated with the api. |

---

##### `cloud_watch_role`<sup>Optional</sup> <a name="cloud_watch_role" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.cloudWatchRole"></a>

```python
cloud_watch_role: bool
```

- *Type:* bool
- *Default:* false if `@aws-cdk/aws-apigateway:disableCloudWatchRole` is enabled, true otherwise

Automatically configure an AWS CloudWatch role for API Gateway.

---

##### `deploy`<sup>Optional</sup> <a name="deploy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deploy"></a>

```python
deploy: bool
```

- *Type:* bool
- *Default:* true

Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

Since API Gateway deployments are immutable, When this option is enabled
(by default), an AWS::ApiGateway::Deployment resource will automatically
created with a logical ID that hashes the API model (methods, resources
and options). This means that when the model changes, the logical ID of
this CloudFormation resource will change, and a new deployment will be
created.

If this is set, `latestDeployment` will refer to the `Deployment` object
and `deploymentStage` will refer to a `Stage` that points to this
deployment. To customize the stage options, use the `deployOptions`
property.

A CloudFormation Output will also be defined with the root URL endpoint
of this REST API.

---

##### `deploy_options`<sup>Optional</sup> <a name="deploy_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deployOptions"></a>

```python
deploy_options: StageOptions
```

- *Type:* aws_cdk.aws_apigateway.StageOptions
- *Default:* Based on defaults of `StageOptions`.

Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.

If `deploy` is disabled,
this value cannot be set.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.description"></a>

```python
description: str
```

- *Type:* str
- *Default:* 'Automatically created by the RestApi construct'

A description of the RestApi construct.

---

##### `disable_execute_api_endpoint`<sup>Optional</sup> <a name="disable_execute_api_endpoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.disableExecuteApiEndpoint"></a>

```python
disable_execute_api_endpoint: bool
```

- *Type:* bool
- *Default:* false

Specifies whether clients can invoke the API using the default execute-api endpoint.

To require that clients use a custom domain name to invoke the
API, disable the default endpoint.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html)

---

##### `domain_name`<sup>Optional</sup> <a name="domain_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.domainName"></a>

```python
domain_name: DomainNameOptions
```

- *Type:* aws_cdk.aws_apigateway.DomainNameOptions
- *Default:* no domain name is defined, use `addDomainName` or directly define a `DomainName`.

Configure a custom domain name and map it to this API.

---

##### `endpoint_export_name`<sup>Optional</sup> <a name="endpoint_export_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointExportName"></a>

```python
endpoint_export_name: str
```

- *Type:* str
- *Default:* when no export name is given, output will be created without export

Export name for the CfnOutput containing the API endpoint.

---

##### `endpoint_types`<sup>Optional</sup> <a name="endpoint_types" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointTypes"></a>

```python
endpoint_types: typing.List[EndpointType]
```

- *Type:* typing.List[aws_cdk.aws_apigateway.EndpointType]
- *Default:* EndpointType.EDGE

A list of the endpoint types of the API.

Use this property when creating
an API.

---

##### `fail_on_warnings`<sup>Optional</sup> <a name="fail_on_warnings" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.failOnWarnings"></a>

```python
fail_on_warnings: bool
```

- *Type:* bool
- *Default:* false

Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.parameters"></a>

```python
parameters: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* No parameters.

Custom header parameters for the request.

> [https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html](https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html)

---

##### `policy`<sup>Optional</sup> <a name="policy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.policy"></a>

```python
policy: PolicyDocument
```

- *Type:* aws_cdk.aws_iam.PolicyDocument
- *Default:* No policy.

A policy document that contains the permissions for this RestApi.

---

##### `rest_api_name`<sup>Optional</sup> <a name="rest_api_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.restApiName"></a>

```python
rest_api_name: str
```

- *Type:* str
- *Default:* ID of the RestApi construct.

A name for the API Gateway RestApi resource.

---

##### `retain_deployments`<sup>Optional</sup> <a name="retain_deployments" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.retainDeployments"></a>

```python
retain_deployments: bool
```

- *Type:* bool
- *Default:* false

Retains old deployment resources when the API changes.

This allows
manually reverting stages to point to old deployments via the AWS
Console.

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.integrations"></a>

```python
integrations: typing.Mapping[OpenApiIntegration]
```

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>]

A mapping of API operation to its integration.

---

##### `operation_lookup`<sup>Required</sup> <a name="operation_lookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.operationLookup"></a>

```python
operation_lookup: typing.Mapping[MethodAndPath]
```

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>]

Details about each operation.

---

##### `cors_options`<sup>Optional</sup> <a name="cors_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.corsOptions"></a>

```python
cors_options: CorsOptions
```

- *Type:* aws_cdk.aws_apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `default_authorizer`<sup>Optional</sup> <a name="default_authorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.defaultAuthorizer"></a>

```python
default_authorizer: Authorizer
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

##### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.spec"></a>

```python
spec: typing.Any
```

- *Type:* typing.Any

The parsed OpenAPI specification.

---

##### `spec_path`<sup>Required</sup> <a name="spec_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.specPath"></a>

```python
spec_path: str
```

- *Type:* str

Path to the JSON open api spec.

---

##### `web_acl_options`<sup>Optional</sup> <a name="web_acl_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.webAclOptions"></a>

```python
web_acl_options: OpenApiGatewayWebAclOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a>

Options for the AWS WAF v2 WebACL associated with the api.

By default, a Web ACL with the AWS default managed
rule set will be associated with the API. These options may disable or override the defaults.

---

### OpenApiGatewayTsProjectOptions <a name="OpenApiGatewayTsProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions"></a>

Configuration for the OpenApiGatewayTsProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayTsProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  workflow_package_cache: bool = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowPackageCache">workflow_package_cache</a></code> | <code>bool</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.allowLibraryDependencies"></a>

```python
allow_library_dependencies: bool
```

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorOrganization"></a>

```python
author_organization: bool
```

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorUrl"></a>

```python
author_url: str
```

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoDetectBin"></a>

```python
auto_detect_bin: bool
```

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bin"></a>

```python
bin: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsEmail"></a>

```python
bugs_email: str
```

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsUrl"></a>

```python
bugs_url: str
```

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundledDeps"></a>

```python
bundled_deps: typing.List[str]
```

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeArtifactOptions"></a>

```python
code_artifact_options: CodeArtifactOptions
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypoint"></a>

```python
entrypoint: str
```

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.keywords"></a>

```python
keywords: typing.List[str]
```

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.licensed"></a>

```python
licensed: bool
```

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmAccess"></a>

```python
npm_access: NpmAccess
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```python
npm_registry: str
```

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistryUrl"></a>

```python
npm_registry_url: str
```

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmTokenSecret"></a>

```python
npm_token_secret: str
```

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageManager"></a>

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDependencyOptions"></a>

```python
peer_dependency_options: PeerDependencyOptions
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDeps"></a>

```python
peer_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pnpmVersion"></a>

```python
pnpm_version: str
```

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repository"></a>

```python
repository: str
```

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repositoryDirectory"></a>

```python
repository_directory: str
```

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scopedPackagesOptions"></a>

```python
scoped_packages_options: typing.List[ScopedPackagesOptions]
```

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```python
scripts: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stability"></a>

```python
stability: str
```

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jsiiReleaseVersion"></a>

```python
jsii_release_version: str
```

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.majorVersion"></a>

```python
major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minMajorVersion"></a>

```python
min_major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmDistTag"></a>

```python
npm_dist_tag: str
```

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.postBuildSteps"></a>

```python
post_build_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prerelease"></a>

```python
prerelease: str
```

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishDryRun"></a>

```python
publish_dry_run: bool
```

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishTasks"></a>

```python
publish_tasks: bool
```

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseBranches"></a>

```python
release_branches: typing.Mapping[BranchOptions]
```

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```python
release_every_commit: bool
```

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssue"></a>

```python
release_failure_issue: bool
```

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssueLabel"></a>

```python
release_failure_issue_label: str
```

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```python
release_schedule: str
```

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTagPrefix"></a>

```python
release_tag_prefix: str
```

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTrigger"></a>

```python
release_trigger: ReleaseTrigger
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowName"></a>

```python
release_workflow_name: str
```

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```python
release_workflow_setup_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.versionrcOptions"></a>

```python
versionrc_options: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowContainerImage"></a>

```python
workflow_container_image: str
```

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowRunsOn"></a>

```python
workflow_runs_on: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.defaultReleaseBranch"></a>

```python
default_release_branch: str
```

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveUpgrades"></a>

```python
auto_approve_upgrades: bool
```

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflow"></a>

```python
build_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflowTriggers"></a>

```python
build_workflow_triggers: Triggers
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundlerOptions"></a>

```python
bundler_options: BundlerOptions
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCov"></a>

```python
code_cov: bool
```

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCovTokenSecret"></a>

```python
code_cov_token_secret: str
```

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightOwner"></a>

```python
copyright_owner: str
```

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightPeriod"></a>

```python
copyright_period: str
```

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabot"></a>

```python
dependabot: bool
```

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabotOptions"></a>

```python
dependabot_options: DependabotOptions
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgrade"></a>

```python
deps_upgrade: bool
```

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgradeOptions"></a>

```python
deps_upgrade_options: UpgradeDependenciesOptions
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitignore"></a>

```python
gitignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jest"></a>

```python
jest: bool
```

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jestOptions"></a>

```python
jest_options: JestOptions
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mutableBuild"></a>

```python
mutable_build: bool
```

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```python
npmignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignoreEnabled"></a>

```python
npmignore_enabled: bool
```

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmIgnoreOptions"></a>

```python
npm_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.package"></a>

```python
package: bool
```

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettier"></a>

```python
prettier: bool
```

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettierOptions"></a>

```python
prettier_options: PrettierOptions
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenDevDependency"></a>

```python
projen_dev_dependency: bool
```

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenVersion"></a>

```python
projen_version: str
```

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplate"></a>

```python
pull_request_template: bool
```

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplateContents"></a>

```python
pull_request_template_contents: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.release"></a>

```python
release: bool
```

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseToNpm"></a>

```python
release_to_npm: bool
```

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```python
release_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowBootstrapSteps"></a>

```python
workflow_bootstrap_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowGitIdentity"></a>

```python
workflow_git_identity: GitIdentity
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowNodeVersion"></a>

```python
workflow_node_version: str
```

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflow_package_cache`<sup>Optional</sup> <a name="workflow_package_cache" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowPackageCache"></a>

```python
workflow_package_cache: bool
```

- *Type:* bool
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfig"></a>

```python
disable_tsconfig: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfigDev"></a>

```python
disable_tsconfig_dev: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypointTypes"></a>

```python
entrypoint_types: str
```

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslint"></a>

```python
eslint: bool
```

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslintOptions"></a>

```python
eslint_options: EslintOptions
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.libdir"></a>

```python
libdir: str
```

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcOptions
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.sampleCode"></a>

```python
sample_code: bool
```

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.testdir"></a>

```python
testdir: str
```

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfig"></a>

```python
tsconfig: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDevFile"></a>

```python
tsconfig_dev_file: str
```

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptVersion"></a>

```python
typescript_version: str
```

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.specFile"></a>

```python
spec_file: str
```

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayWebAclOptions <a name="OpenApiGatewayWebAclOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions"></a>

Configuration for the Web ACL associated with the API.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayWebAclOptions(
  cidr_allow_list: CidrAllowList = None,
  disable: bool = None,
  managed_rules: typing.List[ManagedRule] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.cidrAllowList">cidr_allow_list</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.disable">disable</a></code> | <code>bool</code> | If set to true, no WebACL will be associated with the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.managedRules">managed_rules</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule">ManagedRule</a>]</code> | List of managed rules to apply to the web acl. |

---

##### `cidr_allow_list`<sup>Optional</sup> <a name="cidr_allow_list" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.cidrAllowList"></a>

```python
cidr_allow_list: CidrAllowList
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `disable`<sup>Optional</sup> <a name="disable" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.disable"></a>

```python
disable: bool
```

- *Type:* bool
- *Default:* false

If set to true, no WebACL will be associated with the API.

You can also use this option if you would like to create
your own WebACL and associate it yourself.

---

##### `managed_rules`<sup>Optional</sup> <a name="managed_rules" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.managedRules"></a>

```python
managed_rules: typing.List[ManagedRule]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule">ManagedRule</a>]
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### OpenApiIntegration <a name="OpenApiIntegration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration"></a>

Defines an integration for an individual API operation.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiIntegration(
  integration: Integration,
  authorizer: Authorizer = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.integration">integration</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration">Integration</a></code> | The lambda function to service the api operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.authorizer">authorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The authorizer to use for this api operation (overrides the default). |

---

##### `integration`<sup>Required</sup> <a name="integration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.integration"></a>

```python
integration: Integration
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Integration">Integration</a>

The lambda function to service the api operation.

---

##### `authorizer`<sup>Optional</sup> <a name="authorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.authorizer"></a>

```python
authorizer: Authorizer
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The authorizer to use for this api operation (overrides the default).

---

### OpenApiOptions <a name="OpenApiOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions"></a>

Options required alongside an Open API specification to create API Gateway resources.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiOptions(
  integrations: typing.Mapping[OpenApiIntegration],
  operation_lookup: typing.Mapping[MethodAndPath],
  cors_options: CorsOptions = None,
  default_authorizer: Authorizer = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.integrations">integrations</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>]</code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.operationLookup">operation_lookup</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>]</code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.corsOptions">cors_options</a></code> | <code>aws_cdk.aws_apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.defaultAuthorizer">default_authorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.integrations"></a>

```python
integrations: typing.Mapping[OpenApiIntegration]
```

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>]

A mapping of API operation to its integration.

---

##### `operation_lookup`<sup>Required</sup> <a name="operation_lookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.operationLookup"></a>

```python
operation_lookup: typing.Mapping[MethodAndPath]
```

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>]

Details about each operation.

---

##### `cors_options`<sup>Optional</sup> <a name="cors_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.corsOptions"></a>

```python
cors_options: CorsOptions
```

- *Type:* aws_cdk.aws_apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `default_authorizer`<sup>Optional</sup> <a name="default_authorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.defaultAuthorizer"></a>

```python
default_authorizer: Authorizer
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

### SmithyApiGatewayJavaProjectOptions <a name="SmithyApiGatewayJavaProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions"></a>

Configuration for the SmithyApiGatewayJavaProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayJavaProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  artifact_id: str,
  group_id: str,
  version: str,
  description: str = None,
  packaging: str = None,
  url: str = None,
  compile_options: MavenCompileOptions = None,
  deps: typing.List[str] = None,
  distdir: str = None,
  junit: bool = None,
  junit_options: JunitOptions = None,
  packaging_options: MavenPackagingOptions = None,
  projenrc_java: bool = None,
  projenrc_java_options: ProjenrcOptions = None,
  test_deps: typing.List[str] = None,
  sample: bool = None,
  sample_java_package: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.artifactId">artifact_id</a></code> | <code>str</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.groupId">group_id</a></code> | <code>str</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.version">version</a></code> | <code>str</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.description">description</a></code> | <code>str</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packaging">packaging</a></code> | <code>str</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.url">url</a></code> | <code>str</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.compileOptions">compile_options</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.distdir">distdir</a></code> | <code>str</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junit">junit</a></code> | <code>bool</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junitOptions">junit_options</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packagingOptions">packaging_options</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJava">projenrc_java</a></code> | <code>bool</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJavaOptions">projenrc_java_options</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.testDeps">test_deps</a></code> | <code>typing.List[str]</code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sampleJavaPackage">sample_java_package</a></code> | <code>str</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.serviceName">service_name</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreGradleWrapper">ignore_gradle_wrapper</a></code> | <code>bool</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreSmithyBuildOutput">ignore_smithy_build_output</a></code> | <code>bool</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.modelDir">model_dir</a></code> | <code>str</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.smithyBuildOptions">smithy_build_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.artifactId"></a>

```python
artifact_id: str
```

- *Type:* str
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `group_id`<sup>Required</sup> <a name="group_id" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.groupId"></a>

```python
group_id: str
```

- *Type:* str
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.version"></a>

```python
version: str
```

- *Type:* str
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packaging"></a>

```python
packaging: str
```

- *Type:* str
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.url"></a>

```python
url: str
```

- *Type:* str
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compile_options`<sup>Optional</sup> <a name="compile_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.compileOptions"></a>

```python
compile_options: MavenCompileOptions
```

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.distdir"></a>

```python
distdir: str
```

- *Type:* str
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junit"></a>

```python
junit: bool
```

- *Type:* bool
- *Default:* true

Include junit tests.

---

##### `junit_options`<sup>Optional</sup> <a name="junit_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junitOptions"></a>

```python
junit_options: JunitOptions
```

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packaging_options`<sup>Optional</sup> <a name="packaging_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packagingOptions"></a>

```python
packaging_options: MavenPackagingOptions
```

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrc_java`<sup>Optional</sup> <a name="projenrc_java" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJava"></a>

```python
projenrc_java: bool
```

- *Type:* bool
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrc_java_options`<sup>Optional</sup> <a name="projenrc_java_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJavaOptions"></a>

```python
projenrc_java_options: ProjenrcOptions
```

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `test_deps`<sup>Optional</sup> <a name="test_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.testDeps"></a>

```python
test_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sample"></a>

```python
sample: bool
```

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sample_java_package`<sup>Optional</sup> <a name="sample_java_package" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sampleJavaPackage"></a>

```python
sample_java_package: str
```

- *Type:* str
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.serviceName"></a>

```python
service_name: SmithyServiceName
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignore_gradle_wrapper`<sup>Optional</sup> <a name="ignore_gradle_wrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreGradleWrapper"></a>

```python
ignore_gradle_wrapper: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignore_smithy_build_output`<sup>Optional</sup> <a name="ignore_smithy_build_output" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreSmithyBuildOutput"></a>

```python
ignore_smithy_build_output: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `model_dir`<sup>Optional</sup> <a name="model_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.modelDir"></a>

```python
model_dir: str
```

- *Type:* str
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithy_build_options`<sup>Optional</sup> <a name="smithy_build_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.smithyBuildOptions"></a>

```python
smithy_build_options: SmithyBuildOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayProjectOptions <a name="SmithyApiGatewayProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions"></a>

Options common to all smithy api gateway projects.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayProjectOptions(
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.serviceName">service_name</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreGradleWrapper">ignore_gradle_wrapper</a></code> | <code>bool</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreSmithyBuildOutput">ignore_smithy_build_output</a></code> | <code>bool</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.modelDir">model_dir</a></code> | <code>str</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.smithyBuildOptions">smithy_build_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.serviceName"></a>

```python
service_name: SmithyServiceName
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignore_gradle_wrapper`<sup>Optional</sup> <a name="ignore_gradle_wrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreGradleWrapper"></a>

```python
ignore_gradle_wrapper: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignore_smithy_build_output`<sup>Optional</sup> <a name="ignore_smithy_build_output" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreSmithyBuildOutput"></a>

```python
ignore_smithy_build_output: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `model_dir`<sup>Optional</sup> <a name="model_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.modelDir"></a>

```python
model_dir: str
```

- *Type:* str
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithy_build_options`<sup>Optional</sup> <a name="smithy_build_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.smithyBuildOptions"></a>

```python
smithy_build_options: SmithyBuildOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayPythonProjectOptions <a name="SmithyApiGatewayPythonProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions"></a>

Configuration for the SmithyApiGatewayPythonProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayPythonProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  author_email: str,
  author_name: str,
  version: str,
  classifiers: typing.List[str] = None,
  description: str = None,
  homepage: str = None,
  license: str = None,
  package_name: str = None,
  poetry_options: PoetryPyprojectOptionsWithoutDeps = None,
  setup_config: typing.Mapping[typing.Any] = None,
  module_name: str,
  deps: typing.List[str] = None,
  dev_deps: typing.List[str] = None,
  pip: bool = None,
  poetry: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projenrc_python: bool = None,
  projenrc_python_options: ProjenrcOptions = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcTsOptions = None,
  pytest: bool = None,
  pytest_options: PytestOptions = None,
  python_exec: str = None,
  sample: bool = None,
  setuptools: bool = None,
  venv: bool = None,
  venv_options: VenvOptions = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.version">version</a></code> | <code>str</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.classifiers">classifiers</a></code> | <code>typing.List[str]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.description">description</a></code> | <code>str</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.license">license</a></code> | <code>str</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetryOptions">poetry_options</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setupConfig">setup_config</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.moduleName">module_name</a></code> | <code>str</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pip">pip</a></code> | <code>bool</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetry">poetry</a></code> | <code>bool</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPython">projenrc_python</a></code> | <code>bool</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPythonOptions">projenrc_python_options</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytest">pytest</a></code> | <code>bool</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytestOptions">pytest_options</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonExec">python_exec</a></code> | <code>str</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setuptools">setuptools</a></code> | <code>bool</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venv">venv</a></code> | <code>bool</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venvOptions">venv_options</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.serviceName">service_name</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreGradleWrapper">ignore_gradle_wrapper</a></code> | <code>bool</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreSmithyBuildOutput">ignore_smithy_build_output</a></code> | <code>bool</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.modelDir">model_dir</a></code> | <code>str</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.smithyBuildOptions">smithy_build_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `author_email`<sup>Required</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `author_name`<sup>Required</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.version"></a>

```python
version: str
```

- *Type:* str
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.classifiers"></a>

```python
classifiers: typing.List[str]
```

- *Type:* typing.List[str]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str

License of this package as an SPDX identifier.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str

Package name.

---

##### `poetry_options`<sup>Optional</sup> <a name="poetry_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetryOptions"></a>

```python
poetry_options: PoetryPyprojectOptionsWithoutDeps
```

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setup_config`<sup>Optional</sup> <a name="setup_config" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setupConfig"></a>

```python
setup_config: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

Additional fields to pass in the setup() function if using setuptools.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.moduleName"></a>

```python
module_name: str
```

- *Type:* str
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pip"></a>

```python
pip: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetry"></a>

```python
poetry: bool
```

- *Type:* bool
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrc_python`<sup>Optional</sup> <a name="projenrc_python" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPython"></a>

```python
projenrc_python: bool
```

- *Type:* bool
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrc_python_options`<sup>Optional</sup> <a name="projenrc_python_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPythonOptions"></a>

```python
projenrc_python_options: ProjenrcOptions
```

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcTsOptions
```

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytest"></a>

```python
pytest: bool
```

- *Type:* bool
- *Default:* true

Include pytest tests.

---

##### `pytest_options`<sup>Optional</sup> <a name="pytest_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytestOptions"></a>

```python
pytest_options: PytestOptions
```

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `python_exec`<sup>Optional</sup> <a name="python_exec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonExec"></a>

```python
python_exec: str
```

- *Type:* str
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.sample"></a>

```python
sample: bool
```

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setuptools"></a>

```python
setuptools: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venv"></a>

```python
venv: bool
```

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venv_options`<sup>Optional</sup> <a name="venv_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venvOptions"></a>

```python
venv_options: VenvOptions
```

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.serviceName"></a>

```python
service_name: SmithyServiceName
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignore_gradle_wrapper`<sup>Optional</sup> <a name="ignore_gradle_wrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreGradleWrapper"></a>

```python
ignore_gradle_wrapper: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignore_smithy_build_output`<sup>Optional</sup> <a name="ignore_smithy_build_output" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreSmithyBuildOutput"></a>

```python
ignore_smithy_build_output: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `model_dir`<sup>Optional</sup> <a name="model_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.modelDir"></a>

```python
model_dir: str
```

- *Type:* str
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithy_build_options`<sup>Optional</sup> <a name="smithy_build_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.smithyBuildOptions"></a>

```python
smithy_build_options: SmithyBuildOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayTsProjectOptions <a name="SmithyApiGatewayTsProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions"></a>

Configuration for the SmithyApiGatewayTsProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayTsProjectOptions(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  workflow_package_cache: bool = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowPackageCache">workflow_package_cache</a></code> | <code>bool</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.serviceName">service_name</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreGradleWrapper">ignore_gradle_wrapper</a></code> | <code>bool</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreSmithyBuildOutput">ignore_smithy_build_output</a></code> | <code>bool</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.modelDir">model_dir</a></code> | <code>str</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.smithyBuildOptions">smithy_build_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.name"></a>

```python
name: str
```

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.commitGenerated"></a>

```python
commit_generated: bool
```

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitIgnoreOptions"></a>

```python
git_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitOptions"></a>

```python
git_options: GitOptions
```

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.logging"></a>

```python
logging: LoggerOptions
```

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parent"></a>

```python
parent: Project
```

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCommand"></a>

```python
projen_command: str
```

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJson"></a>

```python
projenrc_json: bool
```

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsonOptions"></a>

```python
projenrc_json_options: ProjenrcJsonOptions
```

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebot"></a>

```python
renovatebot: bool
```

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebotOptions"></a>

```python
renovatebot_options: RenovatebotOptions
```

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveOptions"></a>

```python
auto_approve_options: AutoApproveOptions
```

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMerge"></a>

```python
auto_merge: bool
```

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMergeOptions"></a>

```python
auto_merge_options: AutoMergeOptions
```

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clobber"></a>

```python
clobber: bool
```

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devContainer"></a>

```python
dev_container: bool
```

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.github"></a>

```python
github: bool
```

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.githubOptions"></a>

```python
github_options: GitHubOptions
```

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitpod"></a>

```python
gitpod: bool
```

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```python
mergify: bool
```

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```python
mergify_options: MergifyOptions
```

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCredentials"></a>

```python
projen_credentials: GithubCredentials
```

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```python
projen_token_secret: str
```

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.readme"></a>

```python
readme: SampleReadmeProps
```

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stale"></a>

```python
stale: bool
```

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.staleOptions"></a>

```python
stale_options: StaleOptions
```

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.vscode"></a>

```python
vscode: bool
```

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.allowLibraryDependencies"></a>

```python
allow_library_dependencies: bool
```

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorEmail"></a>

```python
author_email: str
```

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorName"></a>

```python
author_name: str
```

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorOrganization"></a>

```python
author_organization: bool
```

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorUrl"></a>

```python
author_url: str
```

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoDetectBin"></a>

```python
auto_detect_bin: bool
```

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bin"></a>

```python
bin: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsEmail"></a>

```python
bugs_email: str
```

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsUrl"></a>

```python
bugs_url: str
```

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundledDeps"></a>

```python
bundled_deps: typing.List[str]
```

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeArtifactOptions"></a>

```python
code_artifact_options: CodeArtifactOptions
```

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.deps"></a>

```python
deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.description"></a>

```python
description: str
```

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devDeps"></a>

```python
dev_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypoint"></a>

```python
entrypoint: str
```

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.homepage"></a>

```python
homepage: str
```

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.keywords"></a>

```python
keywords: typing.List[str]
```

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.license"></a>

```python
license: str
```

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.licensed"></a>

```python
licensed: bool
```

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.maxNodeVersion"></a>

```python
max_node_version: str
```

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minNodeVersion"></a>

```python
min_node_version: str
```

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmAccess"></a>

```python
npm_access: NpmAccess
```

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```python
npm_registry: str
```

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistryUrl"></a>

```python
npm_registry_url: str
```

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmTokenSecret"></a>

```python
npm_token_secret: str
```

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageManager"></a>

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageName"></a>

```python
package_name: str
```

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDependencyOptions"></a>

```python
peer_dependency_options: PeerDependencyOptions
```

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDeps"></a>

```python
peer_deps: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pnpmVersion"></a>

```python
pnpm_version: str
```

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repository"></a>

```python
repository: str
```

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repositoryDirectory"></a>

```python
repository_directory: str
```

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scopedPackagesOptions"></a>

```python
scoped_packages_options: typing.List[ScopedPackagesOptions]
```

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```python
scripts: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stability"></a>

```python
stability: str
```

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jsiiReleaseVersion"></a>

```python
jsii_release_version: str
```

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.majorVersion"></a>

```python
major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minMajorVersion"></a>

```python
min_major_version: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmDistTag"></a>

```python
npm_dist_tag: str
```

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.postBuildSteps"></a>

```python
post_build_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prerelease"></a>

```python
prerelease: str
```

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishDryRun"></a>

```python
publish_dry_run: bool
```

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishTasks"></a>

```python
publish_tasks: bool
```

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseBranches"></a>

```python
release_branches: typing.Mapping[BranchOptions]
```

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```python
release_every_commit: bool
```

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssue"></a>

```python
release_failure_issue: bool
```

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssueLabel"></a>

```python
release_failure_issue_label: str
```

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```python
release_schedule: str
```

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTagPrefix"></a>

```python
release_tag_prefix: str
```

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTrigger"></a>

```python
release_trigger: ReleaseTrigger
```

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowName"></a>

```python
release_workflow_name: str
```

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```python
release_workflow_setup_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.versionrcOptions"></a>

```python
versionrc_options: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowContainerImage"></a>

```python
workflow_container_image: str
```

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowRunsOn"></a>

```python
workflow_runs_on: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.defaultReleaseBranch"></a>

```python
default_release_branch: str
```

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.artifactsDirectory"></a>

```python
artifacts_directory: str
```

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveUpgrades"></a>

```python
auto_approve_upgrades: bool
```

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflow"></a>

```python
build_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflowTriggers"></a>

```python
build_workflow_triggers: Triggers
```

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundlerOptions"></a>

```python
bundler_options: BundlerOptions
```

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCov"></a>

```python
code_cov: bool
```

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCovTokenSecret"></a>

```python
code_cov_token_secret: str
```

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightOwner"></a>

```python
copyright_owner: str
```

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightPeriod"></a>

```python
copyright_period: str
```

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabot"></a>

```python
dependabot: bool
```

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabotOptions"></a>

```python
dependabot_options: DependabotOptions
```

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgrade"></a>

```python
deps_upgrade: bool
```

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgradeOptions"></a>

```python
deps_upgrade_options: UpgradeDependenciesOptions
```

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitignore"></a>

```python
gitignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jest"></a>

```python
jest: bool
```

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jestOptions"></a>

```python
jest_options: JestOptions
```

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mutableBuild"></a>

```python
mutable_build: bool
```

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```python
npmignore: typing.List[str]
```

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignoreEnabled"></a>

```python
npmignore_enabled: bool
```

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmIgnoreOptions"></a>

```python
npm_ignore_options: IgnoreFileOptions
```

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.package"></a>

```python
package: bool
```

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettier"></a>

```python
prettier: bool
```

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettierOptions"></a>

```python
prettier_options: PrettierOptions
```

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenDevDependency"></a>

```python
projen_dev_dependency: bool
```

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJs"></a>

```python
projenrc_js: bool
```

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsOptions"></a>

```python
projenrc_js_options: ProjenrcOptions
```

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenVersion"></a>

```python
projen_version: str
```

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplate"></a>

```python
pull_request_template: bool
```

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplateContents"></a>

```python
pull_request_template_contents: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.release"></a>

```python
release: bool
```

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseToNpm"></a>

```python
release_to_npm: bool
```

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```python
release_workflow: bool
```

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowBootstrapSteps"></a>

```python
workflow_bootstrap_steps: typing.List[JobStep]
```

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowGitIdentity"></a>

```python
workflow_git_identity: GitIdentity
```

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowNodeVersion"></a>

```python
workflow_node_version: str
```

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflow_package_cache`<sup>Optional</sup> <a name="workflow_package_cache" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowPackageCache"></a>

```python
workflow_package_cache: bool
```

- *Type:* bool
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfig"></a>

```python
disable_tsconfig: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfigDev"></a>

```python
disable_tsconfig_dev: bool
```

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docgen"></a>

```python
docgen: bool
```

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docsDirectory"></a>

```python
docs_directory: str
```

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypointTypes"></a>

```python
entrypoint_types: str
```

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslint"></a>

```python
eslint: bool
```

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslintOptions"></a>

```python
eslint_options: EslintOptions
```

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.libdir"></a>

```python
libdir: str
```

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTs"></a>

```python
projenrc_ts: bool
```

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTsOptions"></a>

```python
projenrc_ts_options: ProjenrcOptions
```

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.sampleCode"></a>

```python
sample_code: bool
```

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.srcdir"></a>

```python
srcdir: str
```

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.testdir"></a>

```python
testdir: str
```

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfig"></a>

```python
tsconfig: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDev"></a>

```python
tsconfig_dev: TypescriptConfigOptions
```

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDevFile"></a>

```python
tsconfig_dev_file: str
```

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptVersion"></a>

```python
typescript_version: str
```

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clientLanguages"></a>

```python
client_languages: typing.List[ClientLanguage]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.apiSrcDir"></a>

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.documentationFormats"></a>

```python
documentation_formats: typing.List[DocumentationFormat]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs"></a>

```python
force_generate_code_and_docs: bool
```

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.generatedCodeDir"></a>

```python
generated_code_dir: str
```

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.javaClientOptions"></a>

```python
java_client_options: JavaProjectOptions
```

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parsedSpecFileName"></a>

```python
parsed_spec_file_name: str
```

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pythonClientOptions"></a>

```python
python_client_options: PythonProjectOptions
```

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptClientOptions"></a>

```python
typescript_client_options: TypeScriptProjectOptions
```

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.serviceName"></a>

```python
service_name: SmithyServiceName
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignore_gradle_wrapper`<sup>Optional</sup> <a name="ignore_gradle_wrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreGradleWrapper"></a>

```python
ignore_gradle_wrapper: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignore_smithy_build_output`<sup>Optional</sup> <a name="ignore_smithy_build_output" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreSmithyBuildOutput"></a>

```python
ignore_smithy_build_output: bool
```

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `model_dir`<sup>Optional</sup> <a name="model_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.modelDir"></a>

```python
model_dir: str
```

- *Type:* str
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithy_build_options`<sup>Optional</sup> <a name="smithy_build_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.smithyBuildOptions"></a>

```python
smithy_build_options: SmithyBuildOptions
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyBuildOptions <a name="SmithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions"></a>

Options for the smithy build files.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyBuildOptions(
  imports: typing.List[str] = None,
  plugins: typing.Mapping[typing.Mapping[typing.Any]] = None,
  ignore_missing_plugins: bool = None,
  maven: SmithyMavenConfiguration = None,
  projections: typing.Mapping[SmithyProjection] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.imports">imports</a></code> | <code>typing.List[str]</code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.plugins">plugins</a></code> | <code>typing.Mapping[typing.Mapping[typing.Any]]</code> | Plugins keyed by plugin id. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.ignoreMissingPlugins">ignore_missing_plugins</a></code> | <code>bool</code> | If a plugin can't be found, Smithy will by default fail the build. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.maven">maven</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration">SmithyMavenConfiguration</a></code> | Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.projections">projections</a></code> | <code>typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection">SmithyProjection</a>]</code> | Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.imports"></a>

```python
imports: typing.List[str]
```

- *Type:* typing.List[str]

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.plugins"></a>

```python
plugins: typing.Mapping[typing.Mapping[typing.Any]]
```

- *Type:* typing.Mapping[typing.Mapping[typing.Any]]

Plugins keyed by plugin id.

---

##### `ignore_missing_plugins`<sup>Optional</sup> <a name="ignore_missing_plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.ignoreMissingPlugins"></a>

```python
ignore_missing_plugins: bool
```

- *Type:* bool
- *Default:* no ignoreMissingPlugins set in the smithy-build.json file

If a plugin can't be found, Smithy will by default fail the build.

This setting can be set to true to allow the build to progress
even if a plugin can't be found on the classpath.

---

##### `maven`<sup>Optional</sup> <a name="maven" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.maven"></a>

```python
maven: SmithyMavenConfiguration
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration">SmithyMavenConfiguration</a>
- *Default:* the default configuration required for Smithy to OpenAPI conversion

Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files.

---

##### `projections`<sup>Optional</sup> <a name="projections" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.projections"></a>

```python
projections: typing.Mapping[SmithyProjection]
```

- *Type:* typing.Mapping[<a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection">SmithyProjection</a>]
- *Default:* no projections

Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections.

---

### SmithyCommon <a name="SmithyCommon" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon"></a>

Properties common to smithy plugins and the root smithy build.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyCommon(
  imports: typing.List[str] = None,
  plugins: typing.Mapping[typing.Mapping[typing.Any]] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.imports">imports</a></code> | <code>typing.List[str]</code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.plugins">plugins</a></code> | <code>typing.Mapping[typing.Mapping[typing.Any]]</code> | Plugins keyed by plugin id. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.imports"></a>

```python
imports: typing.List[str]
```

- *Type:* typing.List[str]

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.plugins"></a>

```python
plugins: typing.Mapping[typing.Mapping[typing.Any]]
```

- *Type:* typing.Mapping[typing.Mapping[typing.Any]]

Plugins keyed by plugin id.

---

### SmithyMavenConfiguration <a name="SmithyMavenConfiguration" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration"></a>

Configuration for smithy maven dependencies.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyMavenConfiguration(
  dependencies: typing.List[str] = None,
  repository_urls: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.dependencies">dependencies</a></code> | <code>typing.List[str]</code> | The dependencies used in the build.gradle and smithy-build.json files eg. software.amazon.smithy:smithy-validation-model:1.27.2 The following required dependencies are always added: - software.amazon.smithy:smithy-cli:1.27.2 - software.amazon.smithy:smithy-model:1.27.2 - software.amazon.smithy:smithy-openapi:1.27.2 - software.amazon.smithy:smithy-aws-traits:1.27.2 You can however override the version of these dependencies if required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.repositoryUrls">repository_urls</a></code> | <code>typing.List[str]</code> | The repository urls used in the build.gradle and smithy-build.json files. |

---

##### `dependencies`<sup>Optional</sup> <a name="dependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.dependencies"></a>

```python
dependencies: typing.List[str]
```

- *Type:* typing.List[str]

The dependencies used in the build.gradle and smithy-build.json files eg. software.amazon.smithy:smithy-validation-model:1.27.2 The following required dependencies are always added: - software.amazon.smithy:smithy-cli:1.27.2 - software.amazon.smithy:smithy-model:1.27.2 - software.amazon.smithy:smithy-openapi:1.27.2 - software.amazon.smithy:smithy-aws-traits:1.27.2 You can however override the version of these dependencies if required.

---

##### `repository_urls`<sup>Optional</sup> <a name="repository_urls" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.repositoryUrls"></a>

```python
repository_urls: typing.List[str]
```

- *Type:* typing.List[str]
- *Default:* maven central and maven local

The repository urls used in the build.gradle and smithy-build.json files.

---

### SmithyProjection <a name="SmithyProjection" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection"></a>

A smithy build projection.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyProjection(
  imports: typing.List[str] = None,
  plugins: typing.Mapping[typing.Mapping[typing.Any]] = None,
  abstract: bool = None,
  transforms: typing.List[SmithyTransform] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.imports">imports</a></code> | <code>typing.List[str]</code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.plugins">plugins</a></code> | <code>typing.Mapping[typing.Mapping[typing.Any]]</code> | Plugins keyed by plugin id. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.abstract">abstract</a></code> | <code>bool</code> | Whether or not the projection is abstract. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.transforms">transforms</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform">SmithyTransform</a>]</code> | Transforms to apply to the projection. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.imports"></a>

```python
imports: typing.List[str]
```

- *Type:* typing.List[str]

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.plugins"></a>

```python
plugins: typing.Mapping[typing.Mapping[typing.Any]]
```

- *Type:* typing.Mapping[typing.Mapping[typing.Any]]

Plugins keyed by plugin id.

---

##### `abstract`<sup>Optional</sup> <a name="abstract" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.abstract"></a>

```python
abstract: bool
```

- *Type:* bool

Whether or not the projection is abstract.

---

##### `transforms`<sup>Optional</sup> <a name="transforms" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.transforms"></a>

```python
transforms: typing.List[SmithyTransform]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform">SmithyTransform</a>]

Transforms to apply to the projection.

---

### SmithyServiceName <a name="SmithyServiceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName"></a>

Represents a fully qualified name of a Smithy service.

> [https://awslabs.github.io/smithy/2.0/spec/service-types.html](https://awslabs.github.io/smithy/2.0/spec/service-types.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyServiceName(
  namespace: str,
  service_name: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.namespace">namespace</a></code> | <code>str</code> | The service namespace. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.serviceName">service_name</a></code> | <code>str</code> | The service name. |

---

##### `namespace`<sup>Required</sup> <a name="namespace" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.namespace"></a>

```python
namespace: str
```

- *Type:* str

The service namespace.

Nested namespaces are separated by '.', for example com.company

> [https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id](https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id)

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.serviceName"></a>

```python
service_name: str
```

- *Type:* str

The service name.

Should be PascalCase, for example HelloService

> [https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id](https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id)

---

### SmithyTransform <a name="SmithyTransform" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform"></a>

A smithy build transform.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyTransform(
  args: typing.Mapping[typing.Any],
  name: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.args">args</a></code> | <code>typing.Mapping[typing.Any]</code> | Arguments for the transform. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.name">name</a></code> | <code>str</code> | Name of the transform. |

---

##### `args`<sup>Required</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.args"></a>

```python
args: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

Arguments for the transform.

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.name"></a>

```python
name: str
```

- *Type:* str

Name of the transform.

---

## Classes <a name="Classes" id="Classes"></a>

### Authorizer <a name="Authorizer" id="@aws-prototyping-sdk/open-api-gateway.Authorizer"></a>

An authorizer for authorizing API requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Authorizer(
  authorization_type: AuthorizationType,
  authorizer_id: str,
  authorization_scopes: typing.List[str] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationType"></a>

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizerId"></a>

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationScopes"></a>

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationType"></a>

```python
authorization_type: AuthorizationType
```

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---


### Authorizers <a name="Authorizers" id="@aws-prototyping-sdk/open-api-gateway.Authorizers"></a>

Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Authorizers()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito">cognito</a></code> | A Cognito User Pools authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.custom">custom</a></code> | A custom authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.iam">iam</a></code> | An IAM authorizer which uses AWS signature version 4 to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.none">none</a></code> | No authorizer. |

---

##### `cognito` <a name="cognito" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Authorizers.cognito(
  authorizer_id: str,
  user_pools: typing.List[IUserPool],
  authorization_scopes: typing.List[str] = None
)
```

A Cognito User Pools authorizer.

###### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito.parameter.authorizerId"></a>

- *Type:* str

Unique identifier for this authorizer.

---

###### `user_pools`<sup>Required</sup> <a name="user_pools" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito.parameter.userPools"></a>

- *Type:* typing.List[aws_cdk.aws_cognito.IUserPool]

The Cognito user pools associated with this authorizer.

---

###### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito.parameter.authorizationScopes"></a>

- *Type:* typing.List[str]
- *Default:* []

A list of authorization scopes configured on the method.

When used as the default authorizer, these scopes will be
applied to all methods without an authorizer at the integration level.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

---

##### `custom` <a name="custom" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Authorizers.custom(
  authorizer_id: str,
  function: IFunction,
  authorizer_result_ttl_in_seconds: typing.Union[int, float] = None,
  identity_source: str = None,
  type: CustomAuthorizerType = None
)
```

A custom authorizer.

###### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.authorizerId"></a>

- *Type:* str

Unique identifier for this authorizer.

---

###### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.function"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

The lambda function used to authorize requests.

---

###### `authorizer_result_ttl_in_seconds`<sup>Optional</sup> <a name="authorizer_result_ttl_in_seconds" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.authorizerResultTtlInSeconds"></a>

- *Type:* typing.Union[int, float]
- *Default:* 300

The number of seconds during which the authorizer result is cached.

---

###### `identity_source`<sup>Optional</sup> <a name="identity_source" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.identitySource"></a>

- *Type:* str
- *Default:* "method.request.header.Authorization"

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

###### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.type"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>
- *Default:* CustomAuthorizerType.TOKEN

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---

##### `iam` <a name="iam" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.iam"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Authorizers.iam()
```

An IAM authorizer which uses AWS signature version 4 to authorize requests.

##### `none` <a name="none" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.none"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Authorizers.none()
```

No authorizer.



### CognitoAuthorizer <a name="CognitoAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer"></a>

An authorizer that uses Cognito identity or access tokens.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.CognitoAuthorizer(
  authorizer_id: str,
  user_pools: typing.List[IUserPool],
  authorization_scopes: typing.List[str] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizerId">authorizer_id</a></code> | <code>str</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.userPools">user_pools</a></code> | <code>typing.List[aws_cdk.aws_cognito.IUserPool]</code> | The Cognito user pools associated with this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | A list of authorization scopes configured on the method. |

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizerId"></a>

- *Type:* str

Unique identifier for this authorizer.

---

##### `user_pools`<sup>Required</sup> <a name="user_pools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.userPools"></a>

- *Type:* typing.List[aws_cdk.aws_cognito.IUserPool]

The Cognito user pools associated with this authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizationScopes"></a>

- *Type:* typing.List[str]
- *Default:* []

A list of authorization scopes configured on the method.

When used as the default authorizer, these scopes will be
applied to all methods without an authorizer at the integration level.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes">with_scopes</a></code> | Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis. |

---

##### `with_scopes` <a name="with_scopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes"></a>

```python
def with_scopes(
  authorization_scopes: str
) -> CognitoAuthorizer
```

Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

###### `authorization_scopes`<sup>Required</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes.parameter.authorizationScopes"></a>

- *Type:* str

the scopes to apply.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.userPools">user_pools</a></code> | <code>typing.List[aws_cdk.aws_cognito.IUserPool]</code> | The Cognito user pools associated with this authorizer. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationType"></a>

```python
authorization_type: AuthorizationType
```

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---

##### `user_pools`<sup>Required</sup> <a name="user_pools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.userPools"></a>

```python
user_pools: typing.List[IUserPool]
```

- *Type:* typing.List[aws_cdk.aws_cognito.IUserPool]

The Cognito user pools associated with this authorizer.

---


### CustomAuthorizer <a name="CustomAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer"></a>

An authorizer that uses a lambda function to authorize requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.CustomAuthorizer(
  authorizer_id: str,
  function: IFunction,
  authorizer_result_ttl_in_seconds: typing.Union[int, float] = None,
  identity_source: str = None,
  type: CustomAuthorizerType = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerId">authorizer_id</a></code> | <code>str</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.function">function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerResultTtlInSeconds">authorizer_result_ttl_in_seconds</a></code> | <code>typing.Union[int, float]</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.identitySource">identity_source</a></code> | <code>str</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerId"></a>

- *Type:* str

Unique identifier for this authorizer.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.function"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

The lambda function used to authorize requests.

---

##### `authorizer_result_ttl_in_seconds`<sup>Optional</sup> <a name="authorizer_result_ttl_in_seconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerResultTtlInSeconds"></a>

- *Type:* typing.Union[int, float]
- *Default:* 300

The number of seconds during which the authorizer result is cached.

---

##### `identity_source`<sup>Optional</sup> <a name="identity_source" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.identitySource"></a>

- *Type:* str
- *Default:* "method.request.header.Authorization"

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.type"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>
- *Default:* CustomAuthorizerType.TOKEN

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerResultTtlInSeconds">authorizer_result_ttl_in_seconds</a></code> | <code>typing.Union[int, float]</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.function">function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.identitySource">identity_source</a></code> | <code>str</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationType"></a>

```python
authorization_type: AuthorizationType
```

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---

##### `authorizer_result_ttl_in_seconds`<sup>Required</sup> <a name="authorizer_result_ttl_in_seconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerResultTtlInSeconds"></a>

```python
authorizer_result_ttl_in_seconds: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of seconds during which the authorizer result is cached.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.function"></a>

```python
function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

The lambda function used to authorize requests.

---

##### `identity_source`<sup>Required</sup> <a name="identity_source" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.identitySource"></a>

```python
identity_source: str
```

- *Type:* str

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Required</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.type"></a>

```python
type: CustomAuthorizerType
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---


### IamAuthorizer <a name="IamAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer"></a>

An IAM authorizer.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.IamAuthorizer()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationType"></a>

```python
authorization_type: AuthorizationType
```

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---


### Integration <a name="Integration" id="@aws-prototyping-sdk/open-api-gateway.Integration"></a>

An integration for an API operation.

You can extend this to implement your own integration if you like.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Integration.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Integration()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration.grant">grant</a></code> | Grant permissions for the API to invoke the integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration.render">render</a></code> | Render the integration into an API Gateway OpenAPI extension. |

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant"></a>

```python
def grant(
  method: str,
  path: str,
  api: SpecRestApi,
  operation_id: str,
  scope: Construct
) -> None
```

Grant permissions for the API to invoke the integration.

###### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter.method"></a>

- *Type:* str

The http method of this operation.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter.path"></a>

- *Type:* str

The path of this operation in the api.

---

###### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter.api"></a>

- *Type:* aws_cdk.aws_apigateway.SpecRestApi

The api to grant permissions for.

---

###### `operation_id`<sup>Required</sup> <a name="operation_id" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter.operationId"></a>

- *Type:* str

The ID of the operation for which permissions are being granted.

---

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which permission resources can be created.

---

##### `render` <a name="render" id="@aws-prototyping-sdk/open-api-gateway.Integration.render"></a>

```python
def render(
  method: str,
  path: str,
  operation_id: str,
  scope: Construct
) -> ApiGatewayIntegration
```

Render the integration into an API Gateway OpenAPI extension.

###### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.Integration.render.parameter.method"></a>

- *Type:* str

The http method of this operation.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.Integration.render.parameter.path"></a>

- *Type:* str

The path of this operation in the api.

---

###### `operation_id`<sup>Required</sup> <a name="operation_id" id="@aws-prototyping-sdk/open-api-gateway.Integration.render.parameter.operationId"></a>

- *Type:* str

The ID of the operation being rendered.

---

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.Integration.render.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which the integration is being rendered.

---




### Integrations <a name="Integrations" id="@aws-prototyping-sdk/open-api-gateway.Integrations"></a>

A collection of integrations to connect API operations with a backend to service requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Integrations.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Integrations()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integrations.lambda">lambda</a></code> | An integration that invokes a lambda function to service the request. |

---

##### `lambda` <a name="lambda" id="@aws-prototyping-sdk/open-api-gateway.Integrations.lambda"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.Integrations.lambda(
  lambda_function: IFunction
)
```

An integration that invokes a lambda function to service the request.

###### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="@aws-prototyping-sdk/open-api-gateway.Integrations.lambda.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

the function to invoke.

---



### LambdaIntegration <a name="LambdaIntegration" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration"></a>

A lambda integration.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.LambdaIntegration(
  lambda_function: IFunction
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant">grant</a></code> | Grant API Gateway permissions to invoke the lambda. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render">render</a></code> | Render the lambda integration as a snippet of OpenAPI. |

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant"></a>

```python
def grant(
  method: str,
  path: str,
  api: SpecRestApi,
  operation_id: str,
  scope: Construct
) -> None
```

Grant API Gateway permissions to invoke the lambda.

###### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.method"></a>

- *Type:* str

The http method of this operation.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.path"></a>

- *Type:* str

The path of this operation in the api.

---

###### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.api"></a>

- *Type:* aws_cdk.aws_apigateway.SpecRestApi

The api to grant permissions for.

---

###### `operation_id`<sup>Required</sup> <a name="operation_id" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.operationId"></a>

- *Type:* str

The ID of the operation for which permissions are being granted.

---

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which permission resources can be created.

---

##### `render` <a name="render" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render"></a>

```python
def render(
  method: str,
  path: str,
  operation_id: str,
  scope: Construct
) -> ApiGatewayIntegration
```

Render the lambda integration as a snippet of OpenAPI.

###### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render.parameter.method"></a>

- *Type:* str

The http method of this operation.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render.parameter.path"></a>

- *Type:* str

The path of this operation in the api.

---

###### `operation_id`<sup>Required</sup> <a name="operation_id" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render.parameter.operationId"></a>

- *Type:* str

The ID of the operation being rendered.

---

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which the integration is being rendered.

---




### NoneAuthorizer <a name="NoneAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer"></a>

No authorizer.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.NoneAuthorizer()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationType">authorization_type</a></code> | <code>aws_cdk.aws_apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizerId">authorizer_id</a></code> | <code>str</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationScopes">authorization_scopes</a></code> | <code>typing.List[str]</code> | Scopes for the authorizer, if any. |

---

##### `authorization_type`<sup>Required</sup> <a name="authorization_type" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationType"></a>

```python
authorization_type: AuthorizationType
```

- *Type:* aws_cdk.aws_apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizer_id`<sup>Required</sup> <a name="authorizer_id" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizerId"></a>

```python
authorizer_id: str
```

- *Type:* str

The unique identifier for the authorizer.

---

##### `authorization_scopes`<sup>Optional</sup> <a name="authorization_scopes" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationScopes"></a>

```python
authorization_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes for the authorizer, if any.

---


### OpenApiGatewayJavaProject <a name="OpenApiGatewayJavaProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject"></a>

Synthesizes a Java Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayJavaProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  artifact_id: str,
  group_id: str,
  version: str,
  description: str = None,
  packaging: str = None,
  url: str = None,
  compile_options: MavenCompileOptions = None,
  deps: typing.List[str] = None,
  distdir: str = None,
  junit: bool = None,
  junit_options: JunitOptions = None,
  packaging_options: MavenPackagingOptions = None,
  projenrc_java: bool = None,
  projenrc_java_options: ProjenrcOptions = None,
  test_deps: typing.List[str] = None,
  sample: bool = None,
  sample_java_package: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.artifactId">artifact_id</a></code> | <code>str</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.groupId">group_id</a></code> | <code>str</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.version">version</a></code> | <code>str</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.description">description</a></code> | <code>str</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packaging">packaging</a></code> | <code>str</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.url">url</a></code> | <code>str</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.compileOptions">compile_options</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.distdir">distdir</a></code> | <code>str</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junit">junit</a></code> | <code>bool</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junitOptions">junit_options</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packagingOptions">packaging_options</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJava">projenrc_java</a></code> | <code>bool</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions">projenrc_java_options</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.testDeps">test_deps</a></code> | <code>typing.List[str]</code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage">sample_java_package</a></code> | <code>str</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.artifactId"></a>

- *Type:* str
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `group_id`<sup>Required</sup> <a name="group_id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.groupId"></a>

- *Type:* str
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.version"></a>

- *Type:* str
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.description"></a>

- *Type:* str
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packaging"></a>

- *Type:* str
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.url"></a>

- *Type:* str
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compile_options`<sup>Optional</sup> <a name="compile_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.compileOptions"></a>

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.distdir"></a>

- *Type:* str
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junit"></a>

- *Type:* bool
- *Default:* true

Include junit tests.

---

##### `junit_options`<sup>Optional</sup> <a name="junit_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junitOptions"></a>

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packaging_options`<sup>Optional</sup> <a name="packaging_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packagingOptions"></a>

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrc_java`<sup>Optional</sup> <a name="projenrc_java" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJava"></a>

- *Type:* bool
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrc_java_options`<sup>Optional</sup> <a name="projenrc_java_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions"></a>

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `test_deps`<sup>Optional</sup> <a name="test_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.testDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sample"></a>

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sample_java_package`<sup>Optional</sup> <a name="sample_java_package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage"></a>

- *Type:* str
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clientLanguages"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.documentationFormats"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.specFile"></a>

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency">add_dependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin">add_plugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency">add_test_dependency</a></code> | Adds a test dependency. |

---

##### ~~`add_exclude_from_cleanup`~~ <a name="add_exclude_from_cleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### ~~`add_git_ignore`~~ <a name="add_git_ignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### ~~`add_package_ignore`~~ <a name="add_package_ignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  _pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* str

The glob pattern to exclude.

---

##### ~~`add_task`~~ <a name="add_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### ~~`annotate_generated`~~ <a name="annotate_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### ~~`post_synthesize`~~ <a name="post_synthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`pre_synthesize`~~ <a name="pre_synthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### ~~`remove_task`~~ <a name="remove_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### ~~`run_task_command`~~ <a name="run_task_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`try_find_file`~~ <a name="try_find_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_find_object_file`~~ <a name="try_find_object_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_remove_file`~~ <a name="try_remove_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`add_dependency`~~ <a name="add_dependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency"></a>

```python
def add_dependency(
  spec: str
) -> None
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency.parameter.spec"></a>

- *Type:* str

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`add_plugin`~~ <a name="add_plugin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin"></a>

```python
def add_plugin(
  spec: str,
  configuration: typing.Mapping[typing.Any] = None,
  dependencies: typing.List[str] = None,
  executions: typing.List[PluginExecution] = None
) -> Dependency
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.spec"></a>

- *Type:* str

dependency spec (`group/artifact@version`).

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.configuration"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* {}

Plugin key/value configuration.

---

###### `dependencies`<sup>Optional</sup> <a name="dependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.dependencies"></a>

- *Type:* typing.List[str]
- *Default:* []

You could configure the dependencies for the plugin.

Dependencies are in `<groupId>/<artifactId>@<semver>` format.

---

###### `executions`<sup>Optional</sup> <a name="executions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.executions"></a>

- *Type:* typing.List[projen.java.PluginExecution]
- *Default:* []

Plugin executions.

---

##### ~~`add_test_dependency`~~ <a name="add_test_dependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency"></a>

```python
def add_test_dependency(
  spec: str
) -> None
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* str

Format `<groupId>/<artifactId>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.subprojects">subprojects</a></code> | <code>typing.List[projen.Project]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compile">compile</a></code> | <code>projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.distdir">distdir</a></code> | <code>str</code> | Maven artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packaging">packaging</a></code> | <code>projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.pom">pom</a></code> | <code>projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.junit">junit</a></code> | <code>projen.java.Junit</code> | JUnit component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenrc">projenrc</a></code> | <code>projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedClients">generated_clients</a></code> | <code>typing.Mapping[projen.Project]</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedJavaClient">generated_java_client</a></code> | <code>projen.java.JavaProject</code> | A reference to the generated java client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specDir">spec_dir</a></code> | <code>str</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specFileName">spec_file_name</a></code> | <code>str</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`build_task`~~<sup>Required</sup> <a name="build_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_task: Task
```

- *Type:* projen.Task

---

##### ~~`commit_generated`~~<sup>Required</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### ~~`compile_task`~~<sup>Required</sup> <a name="compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
name: str
```

- *Type:* str

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### ~~`package_task`~~<sup>Required</sup> <a name="package_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
package_task: Task
```

- *Type:* projen.Task

---

##### ~~`post_compile_task`~~<sup>Required</sup> <a name="post_compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`pre_compile_task`~~<sup>Required</sup> <a name="pre_compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`project_build`~~<sup>Required</sup> <a name="project_build" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projen_command`~~<sup>Required</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
subprojects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`test_task`~~<sup>Required</sup> <a name="test_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
test_task: Task
```

- *Type:* projen.Task

---

##### ~~`default_task`~~<sup>Optional</sup> <a name="default_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`init_project`~~<sup>Optional</sup> <a name="init_project" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`project_type`~~<sup>Required</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### ~~`auto_approve`~~<sup>Optional</sup> <a name="auto_approve" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`dev_container`~~<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`compile`~~<sup>Required</sup> <a name="compile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compile"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile: MavenCompile
```

- *Type:* projen.java.MavenCompile

Compile component.

---

##### ~~`distdir`~~<sup>Required</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.distdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
distdir: str
```

- *Type:* str

Maven artifact output directory.

---

##### ~~`packaging`~~<sup>Required</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packaging"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
packaging: MavenPackaging
```

- *Type:* projen.java.MavenPackaging

Packaging component.

---

##### ~~`pom`~~<sup>Required</sup> <a name="pom" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.pom"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pom: Pom
```

- *Type:* projen.java.Pom

API for managing `pom.xml`.

---

##### ~~`junit`~~<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.junit"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
junit: Junit
```

- *Type:* projen.java.Junit

JUnit component.

---

##### ~~`projenrc`~~<sup>Optional</sup> <a name="projenrc" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projenrc: Projenrc
```

- *Type:* projen.java.Projenrc

Projenrc component.

---

##### ~~`api_src_dir`~~<sup>Required</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

This will also be used
as the package for the api project.

---

##### ~~`generated_clients`~~<sup>Required</sup> <a name="generated_clients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_clients: typing.Mapping[Project]
```

- *Type:* typing.Mapping[projen.Project]

References to the client projects that were generated, keyed by language.

---

##### ~~`generated_code_dir`~~<sup>Required</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_code_dir: str
```

- *Type:* str

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generated_java_client`~~<sup>Required</sup> <a name="generated_java_client" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedJavaClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_java_client: JavaProject
```

- *Type:* projen.java.JavaProject

A reference to the generated java client.

---

##### ~~`spec_dir`~~<sup>Required</sup> <a name="spec_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_dir: str
```

- *Type:* str

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`spec_file_name`~~<sup>Required</sup> <a name="spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_file_name: str
```

- *Type:* str

The name of the spec file.

---

##### ~~`force_generate_code_and_docs`~~<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
force_generate_code_and_docs: bool
```

- *Type:* bool

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### OpenApiGatewayPythonProject <a name="OpenApiGatewayPythonProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject"></a>

Synthesizes a Python Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayPythonProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  author_email: str,
  author_name: str,
  version: str,
  classifiers: typing.List[str] = None,
  description: str = None,
  homepage: str = None,
  license: str = None,
  package_name: str = None,
  poetry_options: PoetryPyprojectOptionsWithoutDeps = None,
  setup_config: typing.Mapping[typing.Any] = None,
  module_name: str,
  deps: typing.List[str] = None,
  dev_deps: typing.List[str] = None,
  pip: bool = None,
  poetry: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projenrc_python: bool = None,
  projenrc_python_options: ProjenrcOptions = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcTsOptions = None,
  pytest: bool = None,
  pytest_options: PytestOptions = None,
  python_exec: str = None,
  sample: bool = None,
  setuptools: bool = None,
  venv: bool = None,
  venv_options: VenvOptions = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.version">version</a></code> | <code>str</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.classifiers">classifiers</a></code> | <code>typing.List[str]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.description">description</a></code> | <code>str</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetryOptions">poetry_options</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setupConfig">setup_config</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.moduleName">module_name</a></code> | <code>str</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pip">pip</a></code> | <code>bool</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetry">poetry</a></code> | <code>bool</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPython">projenrc_python</a></code> | <code>bool</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions">projenrc_python_options</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytest">pytest</a></code> | <code>bool</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytestOptions">pytest_options</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonExec">python_exec</a></code> | <code>str</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setuptools">setuptools</a></code> | <code>bool</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venv">venv</a></code> | <code>bool</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venvOptions">venv_options</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `author_email`<sup>Required</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorEmail"></a>

- *Type:* str
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `author_name`<sup>Required</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorName"></a>

- *Type:* str
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.version"></a>

- *Type:* str
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.classifiers"></a>

- *Type:* typing.List[str]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.description"></a>

- *Type:* str

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.homepage"></a>

- *Type:* str

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.license"></a>

- *Type:* str

License of this package as an SPDX identifier.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.packageName"></a>

- *Type:* str

Package name.

---

##### `poetry_options`<sup>Optional</sup> <a name="poetry_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetryOptions"></a>

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setup_config`<sup>Optional</sup> <a name="setup_config" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setupConfig"></a>

- *Type:* typing.Mapping[typing.Any]

Additional fields to pass in the setup() function if using setuptools.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.moduleName"></a>

- *Type:* str
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pip"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetry"></a>

- *Type:* bool
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrc_python`<sup>Optional</sup> <a name="projenrc_python" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPython"></a>

- *Type:* bool
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrc_python_options`<sup>Optional</sup> <a name="projenrc_python_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions"></a>

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytest"></a>

- *Type:* bool
- *Default:* true

Include pytest tests.

---

##### `pytest_options`<sup>Optional</sup> <a name="pytest_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytestOptions"></a>

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `python_exec`<sup>Optional</sup> <a name="python_exec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonExec"></a>

- *Type:* str
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.sample"></a>

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setuptools"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venv"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venv_options`<sup>Optional</sup> <a name="venv_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venvOptions"></a>

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clientLanguages"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.documentationFormats"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.specFile"></a>

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency">add_dependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency">add_dev_dependency</a></code> | Adds a dev dependency. |

---

##### ~~`add_exclude_from_cleanup`~~ <a name="add_exclude_from_cleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### ~~`add_git_ignore`~~ <a name="add_git_ignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### ~~`add_package_ignore`~~ <a name="add_package_ignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  _pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* str

The glob pattern to exclude.

---

##### ~~`add_task`~~ <a name="add_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### ~~`annotate_generated`~~ <a name="annotate_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### ~~`post_synthesize`~~ <a name="post_synthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`pre_synthesize`~~ <a name="pre_synthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### ~~`remove_task`~~ <a name="remove_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### ~~`run_task_command`~~ <a name="run_task_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`try_find_file`~~ <a name="try_find_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_find_object_file`~~ <a name="try_find_object_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_remove_file`~~ <a name="try_remove_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`add_dependency`~~ <a name="add_dependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency"></a>

```python
def add_dependency(
  spec: str
) -> None
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency.parameter.spec"></a>

- *Type:* str

Format `<module>@<semver>`.

---

##### ~~`add_dev_dependency`~~ <a name="add_dev_dependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency"></a>

```python
def add_dev_dependency(
  spec: str
) -> None
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency.parameter.spec"></a>

- *Type:* str

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.subprojects">subprojects</a></code> | <code>typing.List[projen.Project]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.depsManager">deps_manager</a></code> | <code>projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.envManager">env_manager</a></code> | <code>projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.moduleName">module_name</a></code> | <code>str</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.version">version</a></code> | <code>str</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packagingManager">packaging_manager</a></code> | <code>projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.pytest">pytest</a></code> | <code>projen.python.Pytest</code> | Pytest component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedClients">generated_clients</a></code> | <code>typing.Mapping[projen.Project]</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedPythonClient">generated_python_client</a></code> | <code>projen.python.PythonProject</code> | A reference to the generated python client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specDir">spec_dir</a></code> | <code>str</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specFileName">spec_file_name</a></code> | <code>str</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`build_task`~~<sup>Required</sup> <a name="build_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_task: Task
```

- *Type:* projen.Task

---

##### ~~`commit_generated`~~<sup>Required</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### ~~`compile_task`~~<sup>Required</sup> <a name="compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
name: str
```

- *Type:* str

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### ~~`package_task`~~<sup>Required</sup> <a name="package_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
package_task: Task
```

- *Type:* projen.Task

---

##### ~~`post_compile_task`~~<sup>Required</sup> <a name="post_compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`pre_compile_task`~~<sup>Required</sup> <a name="pre_compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`project_build`~~<sup>Required</sup> <a name="project_build" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projen_command`~~<sup>Required</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
subprojects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`test_task`~~<sup>Required</sup> <a name="test_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
test_task: Task
```

- *Type:* projen.Task

---

##### ~~`default_task`~~<sup>Optional</sup> <a name="default_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`init_project`~~<sup>Optional</sup> <a name="init_project" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`project_type`~~<sup>Required</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### ~~`auto_approve`~~<sup>Optional</sup> <a name="auto_approve" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`dev_container`~~<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`deps_manager`~~<sup>Required</sup> <a name="deps_manager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.depsManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps_manager: IPythonDeps
```

- *Type:* projen.python.IPythonDeps

API for managing dependencies.

---

##### ~~`env_manager`~~<sup>Required</sup> <a name="env_manager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.envManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
env_manager: IPythonEnv
```

- *Type:* projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### ~~`module_name`~~<sup>Required</sup> <a name="module_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.moduleName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
module_name: str
```

- *Type:* str

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### ~~`version`~~<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.version"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
version: str
```

- *Type:* str

Version of the package for distribution (should follow semver).

---

##### ~~`packaging_manager`~~<sup>Optional</sup> <a name="packaging_manager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packagingManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
packaging_manager: IPythonPackaging
```

- *Type:* projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### ~~`pytest`~~<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.pytest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pytest: Pytest
```

- *Type:* projen.python.Pytest

Pytest component.

---

##### ~~`api_src_dir`~~<sup>Required</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`generated_clients`~~<sup>Required</sup> <a name="generated_clients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_clients: typing.Mapping[Project]
```

- *Type:* typing.Mapping[projen.Project]

References to the client projects that were generated, keyed by language.

---

##### ~~`generated_code_dir`~~<sup>Required</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_code_dir: str
```

- *Type:* str

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generated_python_client`~~<sup>Required</sup> <a name="generated_python_client" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedPythonClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_python_client: PythonProject
```

- *Type:* projen.python.PythonProject

A reference to the generated python client.

---

##### ~~`spec_dir`~~<sup>Required</sup> <a name="spec_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_dir: str
```

- *Type:* str

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`spec_file_name`~~<sup>Required</sup> <a name="spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_file_name: str
```

- *Type:* str

The name of the spec file.

---

##### ~~`force_generate_code_and_docs`~~<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
force_generate_code_and_docs: bool
```

- *Type:* bool

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### OpenApiGatewayTsProject <a name="OpenApiGatewayTsProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject"></a>

Synthesizes a Typescript Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.OpenApiGatewayTsProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  workflow_package_cache: bool = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  spec_file: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repositoryDirectory">repository_directory</a></code> | <code>str</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scopedPackagesOptions">scoped_packages_options</a></code> | <code>typing.List[projen.javascript.ScopedPackagesOptions]</code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scripts">scripts</a></code> | <code>typing.Mapping[str]</code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stability">stability</a></code> | <code>str</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jsiiReleaseVersion">jsii_release_version</a></code> | <code>str</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.majorVersion">major_version</a></code> | <code>typing.Union[int, float]</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minMajorVersion">min_major_version</a></code> | <code>typing.Union[int, float]</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmDistTag">npm_dist_tag</a></code> | <code>str</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.postBuildSteps">post_build_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>str</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishDryRun">publish_dry_run</a></code> | <code>bool</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishTasks">publish_tasks</a></code> | <code>bool</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseBranches">release_branches</a></code> | <code>typing.Mapping[projen.release.BranchOptions]</code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseEveryCommit">release_every_commit</a></code> | <code>bool</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssue">release_failure_issue</a></code> | <code>bool</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssueLabel">release_failure_issue_label</a></code> | <code>str</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseSchedule">release_schedule</a></code> | <code>str</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTagPrefix">release_tag_prefix</a></code> | <code>str</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTrigger">release_trigger</a></code> | <code>projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowName">release_workflow_name</a></code> | <code>str</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowSetupSteps">release_workflow_setup_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.versionrcOptions">versionrc_options</a></code> | <code>typing.Mapping[typing.Any]</code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowContainerImage">workflow_container_image</a></code> | <code>str</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowRunsOn">workflow_runs_on</a></code> | <code>typing.List[str]</code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.defaultReleaseBranch">default_release_branch</a></code> | <code>str</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveUpgrades">auto_approve_upgrades</a></code> | <code>bool</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflow">build_workflow</a></code> | <code>bool</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflowTriggers">build_workflow_triggers</a></code> | <code>projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundlerOptions">bundler_options</a></code> | <code>projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCov">code_cov</a></code> | <code>bool</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCovTokenSecret">code_cov_token_secret</a></code> | <code>str</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightOwner">copyright_owner</a></code> | <code>str</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightPeriod">copyright_period</a></code> | <code>str</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>bool</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabotOptions">dependabot_options</a></code> | <code>projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgrade">deps_upgrade</a></code> | <code>bool</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgradeOptions">deps_upgrade_options</a></code> | <code>projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>typing.List[str]</code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jest">jest</a></code> | <code>bool</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jestOptions">jest_options</a></code> | <code>projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mutableBuild">mutable_build</a></code> | <code>bool</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>typing.List[str]</code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignoreEnabled">npmignore_enabled</a></code> | <code>bool</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmIgnoreOptions">npm_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.package">package</a></code> | <code>bool</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettier">prettier</a></code> | <code>bool</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettierOptions">prettier_options</a></code> | <code>projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenDevDependency">projen_dev_dependency</a></code> | <code>bool</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenVersion">projen_version</a></code> | <code>str</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplate">pull_request_template</a></code> | <code>bool</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplateContents">pull_request_template_contents</a></code> | <code>typing.List[str]</code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.release">release</a></code> | <code>bool</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseToNpm">release_to_npm</a></code> | <code>bool</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflow">release_workflow</a></code> | <code>bool</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowBootstrapSteps">workflow_bootstrap_steps</a></code> | <code>typing.List[projen.github.workflows.JobStep]</code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowGitIdentity">workflow_git_identity</a></code> | <code>projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowNodeVersion">workflow_node_version</a></code> | <code>str</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowPackageCache">workflow_package_cache</a></code> | <code>bool</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfig">disable_tsconfig</a></code> | <code>bool</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfigDev">disable_tsconfig_dev</a></code> | <code>bool</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docgen">docgen</a></code> | <code>bool</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docsDirectory">docs_directory</a></code> | <code>str</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypointTypes">entrypoint_types</a></code> | <code>str</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslint">eslint</a></code> | <code>bool</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslintOptions">eslint_options</a></code> | <code>projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.libdir">libdir</a></code> | <code>str</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.sampleCode">sample_code</a></code> | <code>bool</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>str</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.testdir">testdir</a></code> | <code>str</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDevFile">tsconfig_dev_file</a></code> | <code>str</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptVersion">typescript_version</a></code> | <code>str</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.specFile">spec_file</a></code> | <code>str</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allow_library_dependencies`<sup>Optional</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* bool
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `author_email`<sup>Optional</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorEmail"></a>

- *Type:* str

Author's e-mail.

---

##### `author_name`<sup>Optional</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorName"></a>

- *Type:* str

Author's name.

---

##### `author_organization`<sup>Optional</sup> <a name="author_organization" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorOrganization"></a>

- *Type:* bool

Is the author an organization.

---

##### `author_url`<sup>Optional</sup> <a name="author_url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorUrl"></a>

- *Type:* str

Author's URL / Website.

---

##### `auto_detect_bin`<sup>Optional</sup> <a name="auto_detect_bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* bool
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bin"></a>

- *Type:* typing.Mapping[str]

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugs_email`<sup>Optional</sup> <a name="bugs_email" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsEmail"></a>

- *Type:* str

The email address to which issues should be reported.

---

##### `bugs_url`<sup>Optional</sup> <a name="bugs_url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsUrl"></a>

- *Type:* str

The url to your project's issue tracker.

---

##### `bundled_deps`<sup>Optional</sup> <a name="bundled_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundledDeps"></a>

- *Type:* typing.List[str]

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `code_artifact_options`<sup>Optional</sup> <a name="code_artifact_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.description"></a>

- *Type:* str

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```python
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypoint"></a>

- *Type:* str
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.homepage"></a>

- *Type:* str

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.keywords"></a>

- *Type:* typing.List[str]

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.license"></a>

- *Type:* str
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.licensed"></a>

- *Type:* bool
- *Default:* true

Indicates if a license should be added.

---

##### `max_node_version`<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* str
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `min_node_version`<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* str
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npm_access`<sup>Optional</sup> <a name="npm_access" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmAccess"></a>

- *Type:* projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npm_registry`~~<sup>Optional</sup> <a name="npm_registry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* str

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npm_registry_url`<sup>Optional</sup> <a name="npm_registry_url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* str
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npm_token_secret`<sup>Optional</sup> <a name="npm_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* str
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `package_manager`<sup>Optional</sup> <a name="package_manager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageManager"></a>

- *Type:* projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageName"></a>

- *Type:* str
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peer_dependency_options`<sup>Optional</sup> <a name="peer_dependency_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peer_deps`<sup>Optional</sup> <a name="peer_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpm_version`<sup>Optional</sup> <a name="pnpm_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* str
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repository"></a>

- *Type:* str

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repository_directory`<sup>Optional</sup> <a name="repository_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* str

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scoped_packages_options`<sup>Optional</sup> <a name="scoped_packages_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* typing.List[projen.javascript.ScopedPackagesOptions]
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* typing.Mapping[str]
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stability"></a>

- *Type:* str

Package's Stability.

---

##### `jsii_release_version`<sup>Optional</sup> <a name="jsii_release_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* str
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `major_version`<sup>Optional</sup> <a name="major_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.majorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `min_major_version`<sup>Optional</sup> <a name="min_major_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* typing.Union[int, float]
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npm_dist_tag`<sup>Optional</sup> <a name="npm_dist_tag" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmDistTag"></a>

- *Type:* str
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `post_build_steps`<sup>Optional</sup> <a name="post_build_steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prerelease"></a>

- *Type:* str
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publish_dry_run`<sup>Optional</sup> <a name="publish_dry_run" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishDryRun"></a>

- *Type:* bool
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publish_tasks`<sup>Optional</sup> <a name="publish_tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishTasks"></a>

- *Type:* bool
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `release_branches`<sup>Optional</sup> <a name="release_branches" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseBranches"></a>

- *Type:* typing.Mapping[projen.release.BranchOptions]
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`release_every_commit`~~<sup>Optional</sup> <a name="release_every_commit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* bool
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `release_failure_issue`<sup>Optional</sup> <a name="release_failure_issue" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* bool
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `release_failure_issue_label`<sup>Optional</sup> <a name="release_failure_issue_label" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* str
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`release_schedule`~~<sup>Optional</sup> <a name="release_schedule" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* str
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `release_tag_prefix`<sup>Optional</sup> <a name="release_tag_prefix" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* str
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `release_trigger`<sup>Optional</sup> <a name="release_trigger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `release_workflow_name`<sup>Optional</sup> <a name="release_workflow_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* str
- *Default:* "Release"

The name of the default release workflow.

---

##### `release_workflow_setup_steps`<sup>Optional</sup> <a name="release_workflow_setup_steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrc_options`<sup>Optional</sup> <a name="versionrc_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflow_container_image`<sup>Optional</sup> <a name="workflow_container_image" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* str
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflow_runs_on`<sup>Optional</sup> <a name="workflow_runs_on" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* typing.List[str]
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `default_release_branch`<sup>Required</sup> <a name="default_release_branch" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* str
- *Default:* "main"

The name of the main release branch.

---

##### `artifacts_directory`<sup>Optional</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* str
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `auto_approve_upgrades`<sup>Optional</sup> <a name="auto_approve_upgrades" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* bool
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `build_workflow`<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* bool
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `build_workflow_triggers`<sup>Optional</sup> <a name="build_workflow_triggers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundler_options`<sup>Optional</sup> <a name="bundler_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `code_cov`<sup>Optional</sup> <a name="code_cov" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCov"></a>

- *Type:* bool
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `code_cov_token_secret`<sup>Optional</sup> <a name="code_cov_token_secret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* str
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyright_owner`<sup>Optional</sup> <a name="copyright_owner" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* str
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyright_period`<sup>Optional</sup> <a name="copyright_period" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* str
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabot"></a>

- *Type:* bool
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabot_options`<sup>Optional</sup> <a name="dependabot_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `deps_upgrade`<sup>Optional</sup> <a name="deps_upgrade" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* bool
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `deps_upgrade_options`<sup>Optional</sup> <a name="deps_upgrade_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitignore"></a>

- *Type:* typing.List[str]

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jest"></a>

- *Type:* bool
- *Default:* true

Setup jest unit tests.

---

##### `jest_options`<sup>Optional</sup> <a name="jest_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jestOptions"></a>

- *Type:* projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutable_build`<sup>Optional</sup> <a name="mutable_build" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mutableBuild"></a>

- *Type:* bool
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* typing.List[str]

Additional entries to .npmignore.

---

##### `npmignore_enabled`<sup>Optional</sup> <a name="npmignore_enabled" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* bool
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npm_ignore_options`<sup>Optional</sup> <a name="npm_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.package"></a>

- *Type:* bool
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettier"></a>

- *Type:* bool
- *Default:* false

Setup prettier.

---

##### `prettier_options`<sup>Optional</sup> <a name="prettier_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettierOptions"></a>

- *Type:* projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projen_dev_dependency`<sup>Optional</sup> <a name="projen_dev_dependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* bool
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projen_version`<sup>Optional</sup> <a name="projen_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenVersion"></a>

- *Type:* str
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pull_request_template`<sup>Optional</sup> <a name="pull_request_template" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* bool
- *Default:* true

Include a GitHub pull request template.

---

##### `pull_request_template_contents`<sup>Optional</sup> <a name="pull_request_template_contents" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* typing.List[str]
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.release"></a>

- *Type:* bool
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `release_to_npm`<sup>Optional</sup> <a name="release_to_npm" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* bool
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`release_workflow`~~<sup>Optional</sup> <a name="release_workflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* bool
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflow_bootstrap_steps`<sup>Optional</sup> <a name="workflow_bootstrap_steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* typing.List[projen.github.workflows.JobStep]
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflow_git_identity`<sup>Optional</sup> <a name="workflow_git_identity" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflow_node_version`<sup>Optional</sup> <a name="workflow_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* str
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflow_package_cache`<sup>Optional</sup> <a name="workflow_package_cache" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowPackageCache"></a>

- *Type:* bool
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disable_tsconfig`<sup>Optional</sup> <a name="disable_tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disable_tsconfig_dev`<sup>Optional</sup> <a name="disable_tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* bool
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docgen"></a>

- *Type:* bool
- *Default:* false

Docgen by Typedoc.

---

##### `docs_directory`<sup>Optional</sup> <a name="docs_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docsDirectory"></a>

- *Type:* str
- *Default:* "docs"

Docs directory.

---

##### `entrypoint_types`<sup>Optional</sup> <a name="entrypoint_types" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* str
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslint"></a>

- *Type:* bool
- *Default:* true

Setup eslint.

---

##### `eslint_options`<sup>Optional</sup> <a name="eslint_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslintOptions"></a>

- *Type:* projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.libdir"></a>

- *Type:* str
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sample_code`<sup>Optional</sup> <a name="sample_code" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.sampleCode"></a>

- *Type:* bool
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.srcdir"></a>

- *Type:* str
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.testdir"></a>

- *Type:* str
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfig"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfig_dev`<sup>Optional</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfig_dev_file`<sup>Optional</sup> <a name="tsconfig_dev_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* str
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescript_version`<sup>Optional</sup> <a name="typescript_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* str
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clientLanguages"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.documentationFormats"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `spec_file`<sup>Optional</sup> <a name="spec_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.specFile"></a>

- *Type:* str
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins">add_bins</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps">add_bundled_deps</a></code> | Defines bundled dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand">add_compile_command</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps">add_deps</a></code> | Defines normal dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps">add_dev_deps</a></code> | Defines development/test dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields">add_fields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords">add_keywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps">add_peer_deps</a></code> | Defines peer dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts">add_scripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand">add_test_command</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript">has_script</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript">remove_script</a></code> | Removes the npm script (always successful). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup">render_workflow_setup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript">set_script</a></code> | Replaces the contents of an npm package.json script. |

---

##### ~~`add_exclude_from_cleanup`~~ <a name="add_exclude_from_cleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### ~~`add_git_ignore`~~ <a name="add_git_ignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### ~~`add_package_ignore`~~ <a name="add_package_ignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* str

---

##### ~~`add_task`~~ <a name="add_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### ~~`annotate_generated`~~ <a name="annotate_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### ~~`post_synthesize`~~ <a name="post_synthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`pre_synthesize`~~ <a name="pre_synthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### ~~`remove_task`~~ <a name="remove_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### ~~`run_task_command`~~ <a name="run_task_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`try_find_file`~~ <a name="try_find_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_find_object_file`~~ <a name="try_find_object_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_remove_file`~~ <a name="try_remove_file" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`add_bins`~~ <a name="add_bins" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins"></a>

```python
def add_bins(
  bins: typing.Mapping[str]
) -> None
```

###### `bins`<sup>Required</sup> <a name="bins" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins.parameter.bins"></a>

- *Type:* typing.Mapping[str]

---

##### ~~`add_bundled_deps`~~ <a name="add_bundled_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps"></a>

```python
def add_bundled_deps(
  deps: str
) -> None
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_compile_command`~~ <a name="add_compile_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand"></a>

```python
def add_compile_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* str

---

##### ~~`add_deps`~~ <a name="add_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps"></a>

```python
def add_deps(
  deps: str
) -> None
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_dev_deps`~~ <a name="add_dev_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps"></a>

```python
def add_dev_deps(
  deps: str
) -> None
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_fields`~~ <a name="add_fields" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields"></a>

```python
def add_fields(
  fields: typing.Mapping[typing.Any]
) -> None
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields.parameter.fields"></a>

- *Type:* typing.Mapping[typing.Any]

The fields to set.

---

##### ~~`add_keywords`~~ <a name="add_keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords"></a>

```python
def add_keywords(
  keywords: str
) -> None
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords.parameter.keywords"></a>

- *Type:* str

The keywords to add.

---

##### ~~`add_peer_deps`~~ <a name="add_peer_deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps"></a>

```python
def add_peer_deps(
  deps: str
) -> None
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* str

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`add_scripts`~~ <a name="add_scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts"></a>

```python
def add_scripts(
  scripts: typing.Mapping[str]
) -> None
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts.parameter.scripts"></a>

- *Type:* typing.Mapping[str]

The scripts to set.

---

##### ~~`add_test_command`~~ <a name="add_test_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand"></a>

```python
def add_test_command(
  commands: str
) -> None
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand.parameter.commands"></a>

- *Type:* str

---

##### ~~`has_script`~~ <a name="has_script" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript"></a>

```python
def has_script(
  name: str
) -> bool
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### ~~`remove_script`~~ <a name="remove_script" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript"></a>

```python
def remove_script(
  name: str
) -> None
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript.parameter.name"></a>

- *Type:* str

The name of the script.

---

##### ~~`render_workflow_setup`~~ <a name="render_workflow_setup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup"></a>

```python
def render_workflow_setup(
  mutable: bool = None
) -> typing.List[JobStep]
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `mutable`<sup>Optional</sup> <a name="mutable" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup.parameter.mutable"></a>

- *Type:* bool
- *Default:* false

Should the pacakge lockfile be updated?

---

##### ~~`set_script`~~ <a name="set_script" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript"></a>

```python
def set_script(
  name: str,
  command: str
) -> None
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript.parameter.name"></a>

- *Type:* str

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript.parameter.command"></a>

- *Type:* str

The command to execute.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.subprojects">subprojects</a></code> | <code>typing.List[projen.Project]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsDirectory">artifacts_directory</a></code> | <code>str</code> | The build output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsJavascriptDirectory">artifacts_javascript_directory</a></code> | <code>str</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.bundler">bundler</a></code> | <code>projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.entrypoint">entrypoint</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.manifest">manifest</a></code> | <code>typing.Any</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmrc">npmrc</a></code> | <code>projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.package">package</a></code> | <code>projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.runScriptCommand">run_script_command</a></code> | <code>str</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoMerge">auto_merge</a></code> | <code>projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflow">build_workflow</a></code> | <code>projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflowJobId">build_workflow_job_id</a></code> | <code>str</code> | The job ID of the build workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.jest">jest</a></code> | <code>projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Maximum node version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum node.js version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmignore">npmignore</a></code> | <code>projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.prettier">prettier</a></code> | <code>projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.publisher">publisher</a></code> | <code>projen.release.Publisher</code> | Package publisher. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.release">release</a></code> | <code>projen.release.Release</code> | Release management. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.upgradeWorkflow">upgrade_workflow</a></code> | <code>projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docsDirectory">docs_directory</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.libdir">libdir</a></code> | <code>str</code> | The directory in which compiled .js files reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.srcdir">srcdir</a></code> | <code>str</code> | The directory in which the .ts sources reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testdir">testdir</a></code> | <code>str</code> | The directory in which tests reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigDev">tsconfig_dev</a></code> | <code>projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.watchTask">watch_task</a></code> | <code>projen.Task</code> | The "watch" task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docgen">docgen</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.eslint">eslint</a></code> | <code>projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfig">tsconfig</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigEslint">tsconfig_eslint</a></code> | <code>projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedClients">generated_clients</a></code> | <code>typing.Mapping[projen.Project]</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedTypescriptClient">generated_typescript_client</a></code> | <code>projen.typescript.TypeScriptProject</code> | A reference to the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specDir">spec_dir</a></code> | <code>str</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specFileName">spec_file_name</a></code> | <code>str</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.pnpmWorkspace">pnpm_workspace</a></code> | <code>projen.YamlFile</code> | Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM. |

---

##### ~~`build_task`~~<sup>Required</sup> <a name="build_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_task: Task
```

- *Type:* projen.Task

---

##### ~~`commit_generated`~~<sup>Required</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### ~~`compile_task`~~<sup>Required</sup> <a name="compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
name: str
```

- *Type:* str

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### ~~`package_task`~~<sup>Required</sup> <a name="package_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
package_task: Task
```

- *Type:* projen.Task

---

##### ~~`post_compile_task`~~<sup>Required</sup> <a name="post_compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`pre_compile_task`~~<sup>Required</sup> <a name="pre_compile_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`project_build`~~<sup>Required</sup> <a name="project_build" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projen_command`~~<sup>Required</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
subprojects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`test_task`~~<sup>Required</sup> <a name="test_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
test_task: Task
```

- *Type:* projen.Task

---

##### ~~`default_task`~~<sup>Optional</sup> <a name="default_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`init_project`~~<sup>Optional</sup> <a name="init_project" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`project_type`~~<sup>Required</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### ~~`auto_approve`~~<sup>Optional</sup> <a name="auto_approve" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`dev_container`~~<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allow_library_dependencies`~~<sup>Required</sup> <a name="allow_library_dependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```python
allow_library_dependencies: bool
```

- *Type:* bool

---

##### ~~`artifacts_directory`~~<sup>Required</sup> <a name="artifacts_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
artifacts_directory: str
```

- *Type:* str

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### ~~`artifacts_javascript_directory`~~<sup>Required</sup> <a name="artifacts_javascript_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsJavascriptDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
artifacts_javascript_directory: str
```

- *Type:* str

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### ~~`bundler`~~<sup>Required</sup> <a name="bundler" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.bundler"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
bundler: Bundler
```

- *Type:* projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```python
entrypoint: str
```

- *Type:* str

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```python
manifest: typing.Any
```

- *Type:* typing.Any

---

##### ~~`npmrc`~~<sup>Required</sup> <a name="npmrc" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
npmrc: NpmConfig
```

- *Type:* projen.javascript.NpmConfig

The .npmrc file.

---

##### ~~`package`~~<sup>Required</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.package"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
package: NodePackage
```

- *Type:* projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`package_manager`~~<sup>Required</sup> <a name="package_manager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```python
package_manager: NodePackageManager
```

- *Type:* projen.javascript.NodePackageManager

The package manager to use.

---

##### ~~`run_script_command`~~<sup>Required</sup> <a name="run_script_command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.runScriptCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
run_script_command: str
```

- *Type:* str

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### ~~`auto_merge`~~<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoMerge"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
auto_merge: AutoMerge
```

- *Type:* projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### ~~`build_workflow`~~<sup>Optional</sup> <a name="build_workflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_workflow: BuildWorkflow
```

- *Type:* projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### ~~`build_workflow_job_id`~~<sup>Optional</sup> <a name="build_workflow_job_id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflowJobId"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_workflow_job_id: str
```

- *Type:* str

The job ID of the build workflow.

---

##### ~~`jest`~~<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.jest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
jest: Jest
```

- *Type:* projen.javascript.Jest

The Jest configuration (if enabled).

---

##### ~~`max_node_version`~~<sup>Optional</sup> <a name="max_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.maxNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
max_node_version: str
```

- *Type:* str

Maximum node version required by this package.

---

##### ~~`min_node_version`~~<sup>Optional</sup> <a name="min_node_version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.minNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
min_node_version: str
```

- *Type:* str

Minimum node.js version required by this package.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
npmignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

The .npmignore file.

---

##### ~~`prettier`~~<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.prettier"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
prettier: Prettier
```

- *Type:* projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```python
publisher: Publisher
```

- *Type:* projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### ~~`release`~~<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.release"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
release: Release
```

- *Type:* projen.release.Release

Release management.

---

##### ~~`upgrade_workflow`~~<sup>Optional</sup> <a name="upgrade_workflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.upgradeWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
upgrade_workflow: UpgradeDependencies
```

- *Type:* projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### ~~`docs_directory`~~<sup>Required</sup> <a name="docs_directory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
docs_directory: str
```

- *Type:* str

---

##### ~~`libdir`~~<sup>Required</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.libdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
libdir: str
```

- *Type:* str

The directory in which compiled .js files reside.

---

##### ~~`srcdir`~~<sup>Required</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.srcdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
srcdir: str
```

- *Type:* str

The directory in which the .ts sources reside.

---

##### ~~`testdir`~~<sup>Required</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
testdir: str
```

- *Type:* str

The directory in which tests reside.

---

##### ~~`tsconfig_dev`~~<sup>Required</sup> <a name="tsconfig_dev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigDev"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tsconfig_dev: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### ~~`watch_task`~~<sup>Required</sup> <a name="watch_task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.watchTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
watch_task: Task
```

- *Type:* projen.Task

The "watch" task.

---

##### ~~`docgen`~~<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docgen"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
docgen: bool
```

- *Type:* bool

---

##### ~~`eslint`~~<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.eslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
eslint: Eslint
```

- *Type:* projen.javascript.Eslint

---

##### ~~`tsconfig`~~<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfig"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tsconfig: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### ~~`tsconfig_eslint`~~<sup>Optional</sup> <a name="tsconfig_eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigEslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tsconfig_eslint: TypescriptConfig
```

- *Type:* projen.javascript.TypescriptConfig

---

##### ~~`api_src_dir`~~<sup>Required</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`force_generate_code_and_docs`~~<sup>Required</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
force_generate_code_and_docs: bool
```

- *Type:* bool

Force to generate code and docs even if there were no changes in spec.

---

##### ~~`generated_clients`~~<sup>Required</sup> <a name="generated_clients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_clients: typing.Mapping[Project]
```

- *Type:* typing.Mapping[projen.Project]

References to the client projects that were generated, keyed by language.

---

##### ~~`generated_code_dir`~~<sup>Required</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_code_dir: str
```

- *Type:* str

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generated_typescript_client`~~<sup>Required</sup> <a name="generated_typescript_client" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedTypescriptClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_typescript_client: TypeScriptProject
```

- *Type:* projen.typescript.TypeScriptProject

A reference to the generated typescript client.

---

##### ~~`spec_dir`~~<sup>Required</sup> <a name="spec_dir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_dir: str
```

- *Type:* str

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`spec_file_name`~~<sup>Required</sup> <a name="spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_file_name: str
```

- *Type:* str

The name of the spec file.

---

##### ~~`pnpm_workspace`~~<sup>Optional</sup> <a name="pnpm_workspace" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.pnpmWorkspace"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pnpm_workspace: YamlFile
```

- *Type:* projen.YamlFile

Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayJavaProject <a name="SmithyApiGatewayJavaProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject"></a>

Synthesizes a Java Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayJavaProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  artifact_id: str,
  group_id: str,
  version: str,
  description: str = None,
  packaging: str = None,
  url: str = None,
  compile_options: MavenCompileOptions = None,
  deps: typing.List[str] = None,
  distdir: str = None,
  junit: bool = None,
  junit_options: JunitOptions = None,
  packaging_options: MavenPackagingOptions = None,
  projenrc_java: bool = None,
  projenrc_java_options: ProjenrcOptions = None,
  test_deps: typing.List[str] = None,
  sample: bool = None,
  sample_java_package: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.artifactId">artifact_id</a></code> | <code>str</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.groupId">group_id</a></code> | <code>str</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.version">version</a></code> | <code>str</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.description">description</a></code> | <code>str</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packaging">packaging</a></code> | <code>str</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.url">url</a></code> | <code>str</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.compileOptions">compile_options</a></code> | <code>projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.distdir">distdir</a></code> | <code>str</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junit">junit</a></code> | <code>bool</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junitOptions">junit_options</a></code> | <code>projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packagingOptions">packaging_options</a></code> | <code>projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJava">projenrc_java</a></code> | <code>bool</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions">projenrc_java_options</a></code> | <code>projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.testDeps">test_deps</a></code> | <code>typing.List[str]</code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage">sample_java_package</a></code> | <code>str</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.serviceName">service_name</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreGradleWrapper">ignore_gradle_wrapper</a></code> | <code>bool</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreSmithyBuildOutput">ignore_smithy_build_output</a></code> | <code>bool</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.modelDir">model_dir</a></code> | <code>str</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.smithyBuildOptions">smithy_build_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.artifactId"></a>

- *Type:* str
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `group_id`<sup>Required</sup> <a name="group_id" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.groupId"></a>

- *Type:* str
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.version"></a>

- *Type:* str
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.description"></a>

- *Type:* str
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packaging"></a>

- *Type:* str
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.url"></a>

- *Type:* str
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compile_options`<sup>Optional</sup> <a name="compile_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.compileOptions"></a>

- *Type:* projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.distdir"></a>

- *Type:* str
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junit"></a>

- *Type:* bool
- *Default:* true

Include junit tests.

---

##### `junit_options`<sup>Optional</sup> <a name="junit_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junitOptions"></a>

- *Type:* projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packaging_options`<sup>Optional</sup> <a name="packaging_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packagingOptions"></a>

- *Type:* projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrc_java`<sup>Optional</sup> <a name="projenrc_java" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJava"></a>

- *Type:* bool
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrc_java_options`<sup>Optional</sup> <a name="projenrc_java_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions"></a>

- *Type:* projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `test_deps`<sup>Optional</sup> <a name="test_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.testDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sample"></a>

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sample_java_package`<sup>Optional</sup> <a name="sample_java_package" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage"></a>

- *Type:* str
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clientLanguages"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.documentationFormats"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.serviceName"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignore_gradle_wrapper`<sup>Optional</sup> <a name="ignore_gradle_wrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreGradleWrapper"></a>

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignore_smithy_build_output`<sup>Optional</sup> <a name="ignore_smithy_build_output" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreSmithyBuildOutput"></a>

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `model_dir`<sup>Optional</sup> <a name="model_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.modelDir"></a>

- *Type:* str
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithy_build_options`<sup>Optional</sup> <a name="smithy_build_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.smithyBuildOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency">add_dependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin">add_plugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency">add_test_dependency</a></code> | Adds a test dependency. |

---

##### ~~`add_exclude_from_cleanup`~~ <a name="add_exclude_from_cleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### ~~`add_git_ignore`~~ <a name="add_git_ignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### ~~`add_package_ignore`~~ <a name="add_package_ignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  _pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* str

The glob pattern to exclude.

---

##### ~~`add_task`~~ <a name="add_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### ~~`annotate_generated`~~ <a name="annotate_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### ~~`post_synthesize`~~ <a name="post_synthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`pre_synthesize`~~ <a name="pre_synthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### ~~`remove_task`~~ <a name="remove_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### ~~`run_task_command`~~ <a name="run_task_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`try_find_file`~~ <a name="try_find_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_find_object_file`~~ <a name="try_find_object_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_remove_file`~~ <a name="try_remove_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`add_dependency`~~ <a name="add_dependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency"></a>

```python
def add_dependency(
  spec: str
) -> None
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency.parameter.spec"></a>

- *Type:* str

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`add_plugin`~~ <a name="add_plugin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin"></a>

```python
def add_plugin(
  spec: str,
  configuration: typing.Mapping[typing.Any] = None,
  dependencies: typing.List[str] = None,
  executions: typing.List[PluginExecution] = None
) -> Dependency
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.spec"></a>

- *Type:* str

dependency spec (`group/artifact@version`).

---

###### `configuration`<sup>Optional</sup> <a name="configuration" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.configuration"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* {}

Plugin key/value configuration.

---

###### `dependencies`<sup>Optional</sup> <a name="dependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.dependencies"></a>

- *Type:* typing.List[str]
- *Default:* []

You could configure the dependencies for the plugin.

Dependencies are in `<groupId>/<artifactId>@<semver>` format.

---

###### `executions`<sup>Optional</sup> <a name="executions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.executions"></a>

- *Type:* typing.List[projen.java.PluginExecution]
- *Default:* []

Plugin executions.

---

##### ~~`add_test_dependency`~~ <a name="add_test_dependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency"></a>

```python
def add_test_dependency(
  spec: str
) -> None
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* str

Format `<groupId>/<artifactId>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.subprojects">subprojects</a></code> | <code>typing.List[projen.Project]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compile">compile</a></code> | <code>projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.distdir">distdir</a></code> | <code>str</code> | Maven artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packaging">packaging</a></code> | <code>projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.pom">pom</a></code> | <code>projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.junit">junit</a></code> | <code>projen.java.Junit</code> | JUnit component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenrc">projenrc</a></code> | <code>projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedClients">generated_clients</a></code> | <code>typing.Mapping[projen.Project]</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedJavaClient">generated_java_client</a></code> | <code>projen.java.JavaProject</code> | A reference to the generated java client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specDir">spec_dir</a></code> | <code>str</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specFileName">spec_file_name</a></code> | <code>str</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`build_task`~~<sup>Required</sup> <a name="build_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_task: Task
```

- *Type:* projen.Task

---

##### ~~`commit_generated`~~<sup>Required</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### ~~`compile_task`~~<sup>Required</sup> <a name="compile_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
name: str
```

- *Type:* str

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### ~~`package_task`~~<sup>Required</sup> <a name="package_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
package_task: Task
```

- *Type:* projen.Task

---

##### ~~`post_compile_task`~~<sup>Required</sup> <a name="post_compile_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`pre_compile_task`~~<sup>Required</sup> <a name="pre_compile_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`project_build`~~<sup>Required</sup> <a name="project_build" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projen_command`~~<sup>Required</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
subprojects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`test_task`~~<sup>Required</sup> <a name="test_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
test_task: Task
```

- *Type:* projen.Task

---

##### ~~`default_task`~~<sup>Optional</sup> <a name="default_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`init_project`~~<sup>Optional</sup> <a name="init_project" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`project_type`~~<sup>Required</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### ~~`auto_approve`~~<sup>Optional</sup> <a name="auto_approve" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`dev_container`~~<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`compile`~~<sup>Required</sup> <a name="compile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compile"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile: MavenCompile
```

- *Type:* projen.java.MavenCompile

Compile component.

---

##### ~~`distdir`~~<sup>Required</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.distdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
distdir: str
```

- *Type:* str

Maven artifact output directory.

---

##### ~~`packaging`~~<sup>Required</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packaging"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
packaging: MavenPackaging
```

- *Type:* projen.java.MavenPackaging

Packaging component.

---

##### ~~`pom`~~<sup>Required</sup> <a name="pom" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.pom"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pom: Pom
```

- *Type:* projen.java.Pom

API for managing `pom.xml`.

---

##### ~~`junit`~~<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.junit"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
junit: Junit
```

- *Type:* projen.java.Junit

JUnit component.

---

##### ~~`projenrc`~~<sup>Optional</sup> <a name="projenrc" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projenrc: Projenrc
```

- *Type:* projen.java.Projenrc

Projenrc component.

---

##### ~~`api_src_dir`~~<sup>Required</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

This will also be used
as the package for the api project.

---

##### ~~`generated_clients`~~<sup>Required</sup> <a name="generated_clients" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_clients: typing.Mapping[Project]
```

- *Type:* typing.Mapping[projen.Project]

References to the client projects that were generated, keyed by language.

---

##### ~~`generated_code_dir`~~<sup>Required</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_code_dir: str
```

- *Type:* str

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generated_java_client`~~<sup>Required</sup> <a name="generated_java_client" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedJavaClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_java_client: JavaProject
```

- *Type:* projen.java.JavaProject

A reference to the generated java client.

---

##### ~~`spec_dir`~~<sup>Required</sup> <a name="spec_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_dir: str
```

- *Type:* str

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`spec_file_name`~~<sup>Required</sup> <a name="spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_file_name: str
```

- *Type:* str

The name of the spec file.

---

##### ~~`force_generate_code_and_docs`~~<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
force_generate_code_and_docs: bool
```

- *Type:* bool

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayPythonProject <a name="SmithyApiGatewayPythonProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject"></a>

Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayPythonProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  author_email: str,
  author_name: str,
  version: str,
  classifiers: typing.List[str] = None,
  description: str = None,
  homepage: str = None,
  license: str = None,
  package_name: str = None,
  poetry_options: PoetryPyprojectOptionsWithoutDeps = None,
  setup_config: typing.Mapping[typing.Any] = None,
  module_name: str,
  deps: typing.List[str] = None,
  dev_deps: typing.List[str] = None,
  pip: bool = None,
  poetry: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projenrc_python: bool = None,
  projenrc_python_options: ProjenrcOptions = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcTsOptions = None,
  pytest: bool = None,
  pytest_options: PytestOptions = None,
  python_exec: str = None,
  sample: bool = None,
  setuptools: bool = None,
  venv: bool = None,
  venv_options: VenvOptions = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.version">version</a></code> | <code>str</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.classifiers">classifiers</a></code> | <code>typing.List[str]</code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.description">description</a></code> | <code>str</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetryOptions">poetry_options</a></code> | <code>projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setupConfig">setup_config</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.moduleName">module_name</a></code> | <code>str</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pip">pip</a></code> | <code>bool</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetry">poetry</a></code> | <code>bool</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJs">projenrc_js</a></code> | <code>bool</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions">projenrc_js_options</a></code> | <code>projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPython">projenrc_python</a></code> | <code>bool</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions">projenrc_python_options</a></code> | <code>projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTs">projenrc_ts</a></code> | <code>bool</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions">projenrc_ts_options</a></code> | <code>projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytest">pytest</a></code> | <code>bool</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytestOptions">pytest_options</a></code> | <code>projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonExec">python_exec</a></code> | <code>str</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.sample">sample</a></code> | <code>bool</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setuptools">setuptools</a></code> | <code>bool</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venv">venv</a></code> | <code>bool</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venvOptions">venv_options</a></code> | <code>projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clientLanguages">client_languages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]</code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.documentationFormats">documentation_formats</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]</code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.javaClientOptions">java_client_options</a></code> | <code>projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName">parsed_spec_file_name</a></code> | <code>str</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonClientOptions">python_client_options</a></code> | <code>projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions">typescript_client_options</a></code> | <code>projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.serviceName">service_name</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreGradleWrapper">ignore_gradle_wrapper</a></code> | <code>bool</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreSmithyBuildOutput">ignore_smithy_build_output</a></code> | <code>bool</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.modelDir">model_dir</a></code> | <code>str</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.smithyBuildOptions">smithy_build_options</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.name"></a>

- *Type:* str
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commit_generated`<sup>Optional</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.commitGenerated"></a>

- *Type:* bool
- *Default:* true

Whether to commit the managed files by default.

---

##### `git_ignore_options`<sup>Optional</sup> <a name="git_ignore_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `git_options`<sup>Optional</sup> <a name="git_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitOptions"></a>

- *Type:* projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.logging"></a>

- *Type:* projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parent"></a>

- *Type:* projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projen_command`<sup>Optional</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCommand"></a>

- *Type:* str
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrc_json`<sup>Optional</sup> <a name="projenrc_json" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJson"></a>

- *Type:* bool
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrc_json_options`<sup>Optional</sup> <a name="projenrc_json_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebot"></a>

- *Type:* bool
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebot_options`<sup>Optional</sup> <a name="renovatebot_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `auto_approve_options`<sup>Optional</sup> <a name="auto_approve_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `auto_merge`<sup>Optional</sup> <a name="auto_merge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMerge"></a>

- *Type:* bool
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `auto_merge_options`<sup>Optional</sup> <a name="auto_merge_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clobber"></a>

- *Type:* bool
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `dev_container`<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devContainer"></a>

- *Type:* bool
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.github"></a>

- *Type:* bool
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `github_options`<sup>Optional</sup> <a name="github_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.githubOptions"></a>

- *Type:* projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitpod"></a>

- *Type:* bool
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* bool
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergify_options`~~<sup>Optional</sup> <a name="mergify_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`project_type`~~<sup>Optional</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projen_credentials`<sup>Optional</sup> <a name="projen_credentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCredentials"></a>

- *Type:* projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projen_token_secret`~~<sup>Optional</sup> <a name="projen_token_secret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* str
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.readme"></a>

- *Type:* projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```python
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.stale"></a>

- *Type:* bool
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `stale_options`<sup>Optional</sup> <a name="stale_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.staleOptions"></a>

- *Type:* projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.vscode"></a>

- *Type:* bool
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `author_email`<sup>Required</sup> <a name="author_email" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorEmail"></a>

- *Type:* str
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `author_name`<sup>Required</sup> <a name="author_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorName"></a>

- *Type:* str
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.version"></a>

- *Type:* str
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.classifiers"></a>

- *Type:* typing.List[str]

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.description"></a>

- *Type:* str

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.homepage"></a>

- *Type:* str

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.license"></a>

- *Type:* str

License of this package as an SPDX identifier.

---

##### `package_name`<sup>Optional</sup> <a name="package_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.packageName"></a>

- *Type:* str

Package name.

---

##### `poetry_options`<sup>Optional</sup> <a name="poetry_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetryOptions"></a>

- *Type:* projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setup_config`<sup>Optional</sup> <a name="setup_config" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setupConfig"></a>

- *Type:* typing.Mapping[typing.Any]

Additional fields to pass in the setup() function if using setuptools.

---

##### `module_name`<sup>Required</sup> <a name="module_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.moduleName"></a>

- *Type:* str
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.deps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `dev_deps`<sup>Optional</sup> <a name="dev_deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devDeps"></a>

- *Type:* typing.List[str]
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pip"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetry"></a>

- *Type:* bool
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrc_js`<sup>Optional</sup> <a name="projenrc_js" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJs"></a>

- *Type:* bool
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrc_js_options`<sup>Optional</sup> <a name="projenrc_js_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrc_python`<sup>Optional</sup> <a name="projenrc_python" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPython"></a>

- *Type:* bool
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrc_python_options`<sup>Optional</sup> <a name="projenrc_python_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions"></a>

- *Type:* projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrc_ts`<sup>Optional</sup> <a name="projenrc_ts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTs"></a>

- *Type:* bool
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrc_ts_options`<sup>Optional</sup> <a name="projenrc_ts_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytest"></a>

- *Type:* bool
- *Default:* true

Include pytest tests.

---

##### `pytest_options`<sup>Optional</sup> <a name="pytest_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytestOptions"></a>

- *Type:* projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `python_exec`<sup>Optional</sup> <a name="python_exec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonExec"></a>

- *Type:* str
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.sample"></a>

- *Type:* bool
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setuptools"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venv"></a>

- *Type:* bool
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venv_options`<sup>Optional</sup> <a name="venv_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venvOptions"></a>

- *Type:* projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `client_languages`<sup>Required</sup> <a name="client_languages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clientLanguages"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>]

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `api_src_dir`<sup>Optional</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentation_formats`<sup>Optional</sup> <a name="documentation_formats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.documentationFormats"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>]

Formats to generate documentation in.

---

##### `force_generate_code_and_docs`<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* bool
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generated_code_dir`<sup>Optional</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* str
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `java_client_options`<sup>Optional</sup> <a name="java_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsed_spec_file_name`<sup>Optional</sup> <a name="parsed_spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* str
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `python_client_options`<sup>Optional</sup> <a name="python_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescript_client_options`<sup>Optional</sup> <a name="typescript_client_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.serviceName"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignore_gradle_wrapper`<sup>Optional</sup> <a name="ignore_gradle_wrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreGradleWrapper"></a>

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignore_smithy_build_output`<sup>Optional</sup> <a name="ignore_smithy_build_output" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreSmithyBuildOutput"></a>

- *Type:* bool
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `model_dir`<sup>Optional</sup> <a name="model_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.modelDir"></a>

- *Type:* str
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithy_build_options`<sup>Optional</sup> <a name="smithy_build_options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.smithyBuildOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup">add_exclude_from_cleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore">add_git_ignore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore">add_package_ignore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask">add_task</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip">add_tip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated">annotate_generated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.postSynthesize">post_synthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.preSynthesize">pre_synthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask">remove_task</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand">run_task_command</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile">try_find_file</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile">try_find_json_file</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile">try_find_object_file</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile">try_remove_file</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency">add_dependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency">add_dev_dependency</a></code> | Adds a dev dependency. |

---

##### ~~`add_exclude_from_cleanup`~~ <a name="add_exclude_from_cleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup"></a>

```python
def add_exclude_from_cleanup(
  globs: str
) -> None
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* str

The glob patterns to match.

---

##### ~~`add_git_ignore`~~ <a name="add_git_ignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore"></a>

```python
def add_git_ignore(
  pattern: str
) -> None
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore.parameter.pattern"></a>

- *Type:* str

The glob pattern to ignore.

---

##### ~~`add_package_ignore`~~ <a name="add_package_ignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore"></a>

```python
def add_package_ignore(
  _pattern: str
) -> None
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* str

The glob pattern to exclude.

---

##### ~~`add_task`~~ <a name="add_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask"></a>

```python
def add_task(
  name: str,
  condition: str = None,
  cwd: str = None,
  description: str = None,
  env: typing.Mapping[str] = None,
  required_env: typing.List[str] = None,
  args: typing.List[str] = None,
  exec: str = None,
  receive_args: bool = None,
  steps: typing.List[TaskStep] = None
) -> Task
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.name"></a>

- *Type:* str

The task name to add.

---

###### `condition`<sup>Optional</sup> <a name="condition" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.condition"></a>

- *Type:* str

A shell command which determines if the this task should be executed.

If
the program exits with a zero exit code, steps will be executed. A non-zero
code means that task will be skipped.

---

###### `cwd`<sup>Optional</sup> <a name="cwd" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.cwd"></a>

- *Type:* str
- *Default:* process.cwd()

The working directory for all steps in this task (unless overridden by the step).

---

###### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.description"></a>

- *Type:* str
- *Default:* the task name

The description of this build command.

---

###### `env`<sup>Optional</sup> <a name="env" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.env"></a>

- *Type:* typing.Mapping[str]
- *Default:* {}

Defines environment variables for the execution of this task.

Values in this map will be evaluated in a shell, so you can do stuff like `$(echo "foo")`.

---

###### `required_env`<sup>Optional</sup> <a name="required_env" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.requiredEnv"></a>

- *Type:* typing.List[str]

A set of environment variables that must be defined in order to execute this task.

Task execution will fail if one of these is not defined.

---

###### `args`<sup>Optional</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.args"></a>

- *Type:* typing.List[str]
- *Default:* no arguments are passed to the step

Should the provided `exec` shell command receive fixed args.

> [{@link TaskStepOptions.args }]({@link TaskStepOptions.args })

---

###### `exec`<sup>Optional</sup> <a name="exec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.exec"></a>

- *Type:* str
- *Default:* add steps using `task.exec(command)` or `task.spawn(subtask)`

Shell command to execute as the first command of the task.

---

###### `receive_args`<sup>Optional</sup> <a name="receive_args" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.receiveArgs"></a>

- *Type:* bool
- *Default:* false

Should the provided `exec` shell command receive args passed to the task.

> [{@link TaskStepOptions.receiveArgs }]({@link TaskStepOptions.receiveArgs })

---

###### `steps`<sup>Optional</sup> <a name="steps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.steps"></a>

- *Type:* typing.List[projen.TaskStep]

List of task steps to run.

---

##### ~~`add_tip`~~ <a name="add_tip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip"></a>

```python
def add_tip(
  message: str
) -> None
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip.parameter.message"></a>

- *Type:* str

The message.

---

##### ~~`annotate_generated`~~ <a name="annotate_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated"></a>

```python
def annotate_generated(
  glob: str
) -> None
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated.parameter.glob"></a>

- *Type:* str

the glob pattern to match (could be a file path).

---

##### ~~`post_synthesize`~~ <a name="post_synthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.postSynthesize"></a>

```python
def post_synthesize() -> None
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`pre_synthesize`~~ <a name="pre_synthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.preSynthesize"></a>

```python
def pre_synthesize() -> None
```

Called before all components are synthesized.

##### ~~`remove_task`~~ <a name="remove_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask"></a>

```python
def remove_task(
  name: str
) -> Task
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask.parameter.name"></a>

- *Type:* str

The name of the task to remove.

---

##### ~~`run_task_command`~~ <a name="run_task_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand"></a>

```python
def run_task_command(
  task: Task
) -> str
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand.parameter.task"></a>

- *Type:* projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.synth"></a>

```python
def synth() -> None
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`try_find_file`~~ <a name="try_find_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile"></a>

```python
def try_find_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`try_find_json_file`~~ <a name="try_find_json_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile"></a>

```python
def try_find_json_file(
  file_path: str
) -> JsonFile
```

Finds a json file by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_find_object_file`~~ <a name="try_find_object_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile"></a>

```python
def try_find_object_file(
  file_path: str
) -> ObjectFile
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* str

The file path.

---

##### ~~`try_remove_file`~~ <a name="try_remove_file" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile"></a>

```python
def try_remove_file(
  file_path: str
) -> FileBase
```

Finds a file at the specified relative path within this project and removes it.

###### `file_path`<sup>Required</sup> <a name="file_path" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* str

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`add_dependency`~~ <a name="add_dependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency"></a>

```python
def add_dependency(
  spec: str
) -> None
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency.parameter.spec"></a>

- *Type:* str

Format `<module>@<semver>`.

---

##### ~~`add_dev_dependency`~~ <a name="add_dev_dependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency"></a>

```python
def add_dev_dependency(
  spec: str
) -> None
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency.parameter.spec"></a>

- *Type:* str

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.buildTask">build_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.compileTask">compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.components">components</a></code> | <code>typing.List[projen.Component]</code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.deps">deps</a></code> | <code>projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.ejected">ejected</a></code> | <code>bool</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.files">files</a></code> | <code>typing.List[projen.FileBase]</code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitattributes">gitattributes</a></code> | <code>projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitignore">gitignore</a></code> | <code>projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.logger">logger</a></code> | <code>projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.name">name</a></code> | <code>str</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.outdir">outdir</a></code> | <code>str</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packageTask">package_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.postCompileTask">post_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.preCompileTask">pre_compile_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectBuild">project_build</a></code> | <code>projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projenCommand">projen_command</a></code> | <code>str</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.root">root</a></code> | <code>projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.subprojects">subprojects</a></code> | <code>typing.List[projen.Project]</code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.tasks">tasks</a></code> | <code>projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.testTask">test_task</a></code> | <code>projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.defaultTask">default_task</a></code> | <code>projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.initProject">init_project</a></code> | <code>projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.parent">parent</a></code> | <code>projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectType">project_type</a></code> | <code>projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.autoApprove">auto_approve</a></code> | <code>projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.devContainer">dev_container</a></code> | <code>projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.github">github</a></code> | <code>projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitpod">gitpod</a></code> | <code>projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.vscode">vscode</a></code> | <code>projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.depsManager">deps_manager</a></code> | <code>projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.envManager">env_manager</a></code> | <code>projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.moduleName">module_name</a></code> | <code>str</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.version">version</a></code> | <code>str</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packagingManager">packaging_manager</a></code> | <code>projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.pytest">pytest</a></code> | <code>projen.python.Pytest</code> | Pytest component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.apiSrcDir">api_src_dir</a></code> | <code>str</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedClients">generated_clients</a></code> | <code>typing.Mapping[projen.Project]</code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedCodeDir">generated_code_dir</a></code> | <code>str</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedPythonClient">generated_python_client</a></code> | <code>projen.python.PythonProject</code> | A reference to the generated python client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specDir">spec_dir</a></code> | <code>str</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specFileName">spec_file_name</a></code> | <code>str</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.forceGenerateCodeAndDocs">force_generate_code_and_docs</a></code> | <code>bool</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`build_task`~~<sup>Required</sup> <a name="build_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
build_task: Task
```

- *Type:* projen.Task

---

##### ~~`commit_generated`~~<sup>Required</sup> <a name="commit_generated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
commit_generated: bool
```

- *Type:* bool

Whether to commit the managed files by default.

---

##### ~~`compile_task`~~<sup>Required</sup> <a name="compile_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
components: typing.List[Component]
```

- *Type:* typing.List[projen.Component]

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps: Dependencies
```

- *Type:* projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
ejected: bool
```

- *Type:* bool

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
files: typing.List[FileBase]
```

- *Type:* typing.List[projen.FileBase]

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitattributes: GitAttributesFile
```

- *Type:* projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitignore: IgnoreFile
```

- *Type:* projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
logger: Logger
```

- *Type:* projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
name: str
```

- *Type:* str

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
outdir: str
```

- *Type:* str

Absolute output directory of this project.

---

##### ~~`package_task`~~<sup>Required</sup> <a name="package_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
package_task: Task
```

- *Type:* projen.Task

---

##### ~~`post_compile_task`~~<sup>Required</sup> <a name="post_compile_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
post_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`pre_compile_task`~~<sup>Required</sup> <a name="pre_compile_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pre_compile_task: Task
```

- *Type:* projen.Task

---

##### ~~`project_build`~~<sup>Required</sup> <a name="project_build" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_build: ProjectBuild
```

- *Type:* projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projen_command`~~<sup>Required</sup> <a name="projen_command" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
projen_command: str
```

- *Type:* str

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
root: Project
```

- *Type:* projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
subprojects: typing.List[Project]
```

- *Type:* typing.List[projen.Project]

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
tasks: Tasks
```

- *Type:* projen.Tasks

Project tasks.

---

##### ~~`test_task`~~<sup>Required</sup> <a name="test_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
test_task: Task
```

- *Type:* projen.Task

---

##### ~~`default_task`~~<sup>Optional</sup> <a name="default_task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
default_task: Task
```

- *Type:* projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`init_project`~~<sup>Optional</sup> <a name="init_project" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
init_project: InitProject
```

- *Type:* projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
parent: Project
```

- *Type:* projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`project_type`~~<sup>Required</sup> <a name="project_type" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
project_type: ProjectType
```

- *Type:* projen.ProjectType

---

##### ~~`auto_approve`~~<sup>Optional</sup> <a name="auto_approve" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
auto_approve: AutoApprove
```

- *Type:* projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`dev_container`~~<sup>Optional</sup> <a name="dev_container" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
dev_container: DevContainer
```

- *Type:* projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
github: GitHub
```

- *Type:* projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
gitpod: Gitpod
```

- *Type:* projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
vscode: VsCode
```

- *Type:* projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`deps_manager`~~<sup>Required</sup> <a name="deps_manager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.depsManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
deps_manager: IPythonDeps
```

- *Type:* projen.python.IPythonDeps

API for managing dependencies.

---

##### ~~`env_manager`~~<sup>Required</sup> <a name="env_manager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.envManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
env_manager: IPythonEnv
```

- *Type:* projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### ~~`module_name`~~<sup>Required</sup> <a name="module_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.moduleName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
module_name: str
```

- *Type:* str

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### ~~`version`~~<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.version"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
version: str
```

- *Type:* str

Version of the package for distribution (should follow semver).

---

##### ~~`packaging_manager`~~<sup>Optional</sup> <a name="packaging_manager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packagingManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
packaging_manager: IPythonPackaging
```

- *Type:* projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### ~~`pytest`~~<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.pytest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
pytest: Pytest
```

- *Type:* projen.python.Pytest

Pytest component.

---

##### ~~`api_src_dir`~~<sup>Required</sup> <a name="api_src_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
api_src_dir: str
```

- *Type:* str

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`generated_clients`~~<sup>Required</sup> <a name="generated_clients" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_clients: typing.Mapping[Project]
```

- *Type:* typing.Mapping[projen.Project]

References to the client projects that were generated, keyed by language.

---

##### ~~`generated_code_dir`~~<sup>Required</sup> <a name="generated_code_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_code_dir: str
```

- *Type:* str

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generated_python_client`~~<sup>Required</sup> <a name="generated_python_client" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedPythonClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
generated_python_client: PythonProject
```

- *Type:* projen.python.PythonProject

A reference to the generated python client.

---

##### ~~`spec_dir`~~<sup>Required</sup> <a name="spec_dir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_dir: str
```

- *Type:* str

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`spec_file_name`~~<sup>Required</sup> <a name="spec_file_name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
spec_file_name: str
```

- *Type:* str

The name of the spec file.

---

##### ~~`force_generate_code_and_docs`~~<sup>Optional</sup> <a name="force_generate_code_and_docs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
force_generate_code_and_docs: bool
```

- *Type:* bool

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>str</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```python
DEFAULT_TASK: str
```

- *Type:* str

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayTsProject <a name="SmithyApiGatewayTsProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject"></a>

Synthesizes a Typescript Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer"></a>

```python
import aws_prototyping_sdk.open_api_gateway

aws_prototyping_sdk.open_api_gateway.SmithyApiGatewayTsProject(
  name: str,
  commit_generated: bool = None,
  git_ignore_options: IgnoreFileOptions = None,
  git_options: GitOptions = None,
  logging: LoggerOptions = None,
  outdir: str = None,
  parent: Project = None,
  projen_command: str = None,
  projenrc_json: bool = None,
  projenrc_json_options: ProjenrcJsonOptions = None,
  renovatebot: bool = None,
  renovatebot_options: RenovatebotOptions = None,
  auto_approve_options: AutoApproveOptions = None,
  auto_merge: bool = None,
  auto_merge_options: AutoMergeOptions = None,
  clobber: bool = None,
  dev_container: bool = None,
  github: bool = None,
  github_options: GitHubOptions = None,
  gitpod: bool = None,
  mergify: bool = None,
  mergify_options: MergifyOptions = None,
  project_type: ProjectType = None,
  projen_credentials: GithubCredentials = None,
  projen_token_secret: str = None,
  readme: SampleReadmeProps = None,
  stale: bool = None,
  stale_options: StaleOptions = None,
  vscode: bool = None,
  allow_library_dependencies: bool = None,
  author_email: str = None,
  author_name: str = None,
  author_organization: bool = None,
  author_url: str = None,
  auto_detect_bin: bool = None,
  bin: typing.Mapping[str] = None,
  bugs_email: str = None,
  bugs_url: str = None,
  bundled_deps: typing.List[str] = None,
  code_artifact_options: CodeArtifactOptions = None,
  deps: typing.List[str] = None,
  description: str = None,
  dev_deps: typing.List[str] = None,
  entrypoint: str = None,
  homepage: str = None,
  keywords: typing.List[str] = None,
  license: str = None,
  licensed: bool = None,
  max_node_version: str = None,
  min_node_version: str = None,
  npm_access: NpmAccess = None,
  npm_registry: str = None,
  npm_registry_url: str = None,
  npm_token_secret: str = None,
  package_manager: NodePackageManager = None,
  package_name: str = None,
  peer_dependency_options: PeerDependencyOptions = None,
  peer_deps: typing.List[str] = None,
  pnpm_version: str = None,
  repository: str = None,
  repository_directory: str = None,
  scoped_packages_options: typing.List[ScopedPackagesOptions] = None,
  scripts: typing.Mapping[str] = None,
  stability: str = None,
  jsii_release_version: str = None,
  major_version: typing.Union[int, float] = None,
  min_major_version: typing.Union[int, float] = None,
  npm_dist_tag: str = None,
  post_build_steps: typing.List[JobStep] = None,
  prerelease: str = None,
  publish_dry_run: bool = None,
  publish_tasks: bool = None,
  release_branches: typing.Mapping[BranchOptions] = None,
  release_every_commit: bool = None,
  release_failure_issue: bool = None,
  release_failure_issue_label: str = None,
  release_schedule: str = None,
  release_tag_prefix: str = None,
  release_trigger: ReleaseTrigger = None,
  release_workflow_name: str = None,
  release_workflow_setup_steps: typing.List[JobStep] = None,
  versionrc_options: typing.Mapping[typing.Any] = None,
  workflow_container_image: str = None,
  workflow_runs_on: typing.List[str] = None,
  default_release_branch: str,
  artifacts_directory: str = None,
  auto_approve_upgrades: bool = None,
  build_workflow: bool = None,
  build_workflow_triggers: Triggers = None,
  bundler_options: BundlerOptions = None,
  code_cov: bool = None,
  code_cov_token_secret: str = None,
  copyright_owner: str = None,
  copyright_period: str = None,
  dependabot: bool = None,
  dependabot_options: DependabotOptions = None,
  deps_upgrade: bool = None,
  deps_upgrade_options: UpgradeDependenciesOptions = None,
  gitignore: typing.List[str] = None,
  jest: bool = None,
  jest_options: JestOptions = None,
  mutable_build: bool = None,
  npmignore: typing.List[str] = None,
  npmignore_enabled: bool = None,
  npm_ignore_options: IgnoreFileOptions = None,
  package: bool = None,
  prettier: bool = None,
  prettier_options: PrettierOptions = None,
  projen_dev_dependency: bool = None,
  projenrc_js: bool = None,
  projenrc_js_options: ProjenrcOptions = None,
  projen_version: str = None,
  pull_request_template: bool = None,
  pull_request_template_contents: typing.List[str] = None,
  release: bool = None,
  release_to_npm: bool = None,
  release_workflow: bool = None,
  workflow_bootstrap_steps: typing.List[JobStep] = None,
  workflow_git_identity: GitIdentity = None,
  workflow_node_version: str = None,
  workflow_package_cache: bool = None,
  disable_tsconfig: bool = None,
  disable_tsconfig_dev: bool = None,
  docgen: bool = None,
  docs_directory: str = None,
  entrypoint_types: str = None,
  eslint: bool = None,
  eslint_options: EslintOptions = None,
  libdir: str = None,
  projenrc_ts: bool = None,
  projenrc_ts_options: ProjenrcOptions = None,
  sample_code: bool = None,
  srcdir: str = None,
  testdir: str = None,
  tsconfig: TypescriptConfigOptions = None,
  tsconfig_dev: TypescriptConfigOptions = None,
  tsconfig_dev_file: str = None,
  typescript_version: str = None,
  client_languages: typing.List[ClientLanguage],
  api_src_dir: str = None,
  documentation_formats: typing.List[DocumentationFormat] = None,
  force_generate_code_and_docs: bool = None,
  generated_code_dir: str = None,
  java_client_options: JavaProjectOptions = None,
  parsed_spec_file_name: str = None,
  python_client_options: PythonProjectOptions = None,
  typescript_client_options: TypeScriptProjectOptions = None,
  service_name: SmithyServiceName,
  ignore_gradle_wrapper: bool = None,
  ignore_smithy_build_output: bool = None,
  model_dir: str = None,
  smithy_build_options: SmithyBuildOptions = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.name">name</a></code> | <code>str</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.commitGenerated">commit_generated</a></code> | <code>bool</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.gitIgnoreOptions">git_ignore_options</a></code> | <code>projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.gitOptions">git_options</a></code> | <code>projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.logging">logging</a></code> | <code>projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.parent">parent</a></code> | <code>projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.projenCommand">projen_command</a></code> | <code>str</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.projenrcJson">projenrc_json</a></code> | <code>bool</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.projenrcJsonOptions">projenrc_json_options</a></code> | <code>projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>bool</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.renovatebotOptions">renovatebot_options</a></code> | <code>projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.autoApproveOptions">auto_approve_options</a></code> | <code>projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.autoMerge">auto_merge</a></code> | <code>bool</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.autoMergeOptions">auto_merge_options</a></code> | <code>projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.clobber">clobber</a></code> | <code>bool</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.devContainer">dev_container</a></code> | <code>bool</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.github">github</a></code> | <code>bool</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.githubOptions">github_options</a></code> | <code>projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>bool</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.mergify">mergify</a></code> | <code>bool</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.mergifyOptions">mergify_options</a></code> | <code>projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.projectType">project_type</a></code> | <code>projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.projenCredentials">projen_credentials</a></code> | <code>projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.projenTokenSecret">projen_token_secret</a></code> | <code>str</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.readme">readme</a></code> | <code>projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.stale">stale</a></code> | <code>bool</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.staleOptions">stale_options</a></code> | <code>projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.vscode">vscode</a></code> | <code>bool</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.allowLibraryDependencies">allow_library_dependencies</a></code> | <code>bool</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.authorEmail">author_email</a></code> | <code>str</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.authorName">author_name</a></code> | <code>str</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.authorOrganization">author_organization</a></code> | <code>bool</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.authorUrl">author_url</a></code> | <code>str</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.autoDetectBin">auto_detect_bin</a></code> | <code>bool</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.bin">bin</a></code> | <code>typing.Mapping[str]</code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.bugsEmail">bugs_email</a></code> | <code>str</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.bugsUrl">bugs_url</a></code> | <code>str</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.bundledDeps">bundled_deps</a></code> | <code>typing.List[str]</code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.codeArtifactOptions">code_artifact_options</a></code> | <code>projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.deps">deps</a></code> | <code>typing.List[str]</code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.description">description</a></code> | <code>str</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.devDeps">dev_deps</a></code> | <code>typing.List[str]</code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>str</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.homepage">homepage</a></code> | <code>str</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.keywords">keywords</a></code> | <code>typing.List[str]</code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.license">license</a></code> | <code>str</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.licensed">licensed</a></code> | <code>bool</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.maxNodeVersion">max_node_version</a></code> | <code>str</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.minNodeVersion">min_node_version</a></code> | <code>str</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.npmAccess">npm_access</a></code> | <code>projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.npmRegistry">npm_registry</a></code> | <code>str</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.npmRegistryUrl">npm_registry_url</a></code> | <code>str</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.npmTokenSecret">npm_token_secret</a></code> | <code>str</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.packageManager">package_manager</a></code> | <code>projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.packageName">package_name</a></code> | <code>str</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.peerDependencyOptions">peer_dependency_options</a></code> | <code>projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.peerDeps">peer_deps</a></code> | <code>typing.List[str]</code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.pnpmVersion">pnpm_version</a></code> | <code>str</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The reposi