# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### OpenApiGatewayRestApi <a name="OpenApiGatewayRestApi" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi"></a>

A construct for creating an api gateway rest api based on the definition in the OpenAPI spec.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayRestApi;

OpenApiGatewayRestApi.Builder.create(Construct scope, java.lang.String id)
//  .cloudWatchRole(java.lang.Boolean)
//  .deploy(java.lang.Boolean)
//  .deployOptions(StageOptions)
//  .description(java.lang.String)
//  .disableExecuteApiEndpoint(java.lang.Boolean)
//  .domainName(DomainNameOptions)
//  .endpointExportName(java.lang.String)
//  .endpointTypes(java.util.List<EndpointType>)
//  .failOnWarnings(java.lang.Boolean)
//  .parameters(java.util.Map<java.lang.String, java.lang.String>)
//  .policy(PolicyDocument)
//  .restApiName(java.lang.String)
//  .retainDeployments(java.lang.Boolean)
    .integrations(java.util.Map<java.lang.String, OpenApiIntegration>)
    .operationLookup(java.util.Map<java.lang.String, MethodAndPath>)
//  .corsOptions(CorsOptions)
//  .defaultAuthorizer(Authorizer)
    .spec(java.lang.Object)
    .specPath(java.lang.String)
//  .webAclOptions(OpenApiGatewayWebAclOptions)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.cloudWatchRole">cloudWatchRole</a></code> | <code>java.lang.Boolean</code> | Automatically configure an AWS CloudWatch role for API Gateway. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deploy">deploy</a></code> | <code>java.lang.Boolean</code> | Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deployOptions">deployOptions</a></code> | <code>software.amazon.awscdk.services.apigateway.StageOptions</code> | Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | A description of the RestApi construct. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.disableExecuteApiEndpoint">disableExecuteApiEndpoint</a></code> | <code>java.lang.Boolean</code> | Specifies whether clients can invoke the API using the default execute-api endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.domainName">domainName</a></code> | <code>software.amazon.awscdk.services.apigateway.DomainNameOptions</code> | Configure a custom domain name and map it to this API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointExportName">endpointExportName</a></code> | <code>java.lang.String</code> | Export name for the CfnOutput containing the API endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointTypes">endpointTypes</a></code> | <code>java.util.List<software.amazon.awscdk.services.apigateway.EndpointType></code> | A list of the endpoint types of the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.failOnWarnings">failOnWarnings</a></code> | <code>java.lang.Boolean</code> | Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.parameters">parameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Custom header parameters for the request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.policy">policy</a></code> | <code>software.amazon.awscdk.services.iam.PolicyDocument</code> | A policy document that contains the permissions for this RestApi. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.restApiName">restApiName</a></code> | <code>java.lang.String</code> | A name for the API Gateway RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.retainDeployments">retainDeployments</a></code> | <code>java.lang.Boolean</code> | Retains old deployment resources when the API changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.integrations">integrations</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>></code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.operationLookup">operationLookup</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>></code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.corsOptions">corsOptions</a></code> | <code>software.amazon.awscdk.services.apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.defaultAuthorizer">defaultAuthorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.spec">spec</a></code> | <code>java.lang.Object</code> | The parsed OpenAPI specification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.specPath">specPath</a></code> | <code>java.lang.String</code> | Path to the JSON open api spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.webAclOptions">webAclOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a></code> | Options for the AWS WAF v2 WebACL associated with the api. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.id"></a>

- *Type:* java.lang.String

---

##### `cloudWatchRole`<sup>Optional</sup> <a name="cloudWatchRole" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.cloudWatchRole"></a>

- *Type:* java.lang.Boolean
- *Default:* false if `@aws-cdk/aws-apigateway:disableCloudWatchRole` is enabled, true otherwise

Automatically configure an AWS CloudWatch role for API Gateway.

---

##### `deploy`<sup>Optional</sup> <a name="deploy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deploy"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

Since API Gateway deployments are immutable, When this option is enabled
(by default), an AWS::ApiGateway::Deployment resource will automatically
created with a logical ID that hashes the API model (methods, resources
and options). This means that when the model changes, the logical ID of
this CloudFormation resource will change, and a new deployment will be
created.

If this is set, `latestDeployment` will refer to the `Deployment` object
and `deploymentStage` will refer to a `Stage` that points to this
deployment. To customize the stage options, use the `deployOptions`
property.

A CloudFormation Output will also be defined with the root URL endpoint
of this REST API.

---

##### `deployOptions`<sup>Optional</sup> <a name="deployOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.deployOptions"></a>

- *Type:* software.amazon.awscdk.services.apigateway.StageOptions
- *Default:* Based on defaults of `StageOptions`.

Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.

If `deploy` is disabled,
this value cannot be set.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.description"></a>

- *Type:* java.lang.String
- *Default:* 'Automatically created by the RestApi construct'

A description of the RestApi construct.

---

##### `disableExecuteApiEndpoint`<sup>Optional</sup> <a name="disableExecuteApiEndpoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.disableExecuteApiEndpoint"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Specifies whether clients can invoke the API using the default execute-api endpoint.

To require that clients use a custom domain name to invoke the
API, disable the default endpoint.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html)

---

##### `domainName`<sup>Optional</sup> <a name="domainName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.domainName"></a>

- *Type:* software.amazon.awscdk.services.apigateway.DomainNameOptions
- *Default:* no domain name is defined, use `addDomainName` or directly define a `DomainName`.

Configure a custom domain name and map it to this API.

---

##### `endpointExportName`<sup>Optional</sup> <a name="endpointExportName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointExportName"></a>

- *Type:* java.lang.String
- *Default:* when no export name is given, output will be created without export

Export name for the CfnOutput containing the API endpoint.

---

##### `endpointTypes`<sup>Optional</sup> <a name="endpointTypes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.endpointTypes"></a>

- *Type:* java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>
- *Default:* EndpointType.EDGE

A list of the endpoint types of the API.

Use this property when creating
an API.

---

##### `failOnWarnings`<sup>Optional</sup> <a name="failOnWarnings" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.failOnWarnings"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.parameters"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* No parameters.

Custom header parameters for the request.

> [https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html](https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html)

---

##### `policy`<sup>Optional</sup> <a name="policy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.policy"></a>

- *Type:* software.amazon.awscdk.services.iam.PolicyDocument
- *Default:* No policy.

A policy document that contains the permissions for this RestApi.

---

##### `restApiName`<sup>Optional</sup> <a name="restApiName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.restApiName"></a>

- *Type:* java.lang.String
- *Default:* ID of the RestApi construct.

A name for the API Gateway RestApi resource.

---

##### `retainDeployments`<sup>Optional</sup> <a name="retainDeployments" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.retainDeployments"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Retains old deployment resources when the API changes.

This allows
manually reverting stages to point to old deployments via the AWS
Console.

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.integrations"></a>

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>>

A mapping of API operation to its integration.

---

##### `operationLookup`<sup>Required</sup> <a name="operationLookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.operationLookup"></a>

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>>

Details about each operation.

---

##### `corsOptions`<sup>Optional</sup> <a name="corsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.corsOptions"></a>

- *Type:* software.amazon.awscdk.services.apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `defaultAuthorizer`<sup>Optional</sup> <a name="defaultAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.defaultAuthorizer"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

##### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.spec"></a>

- *Type:* java.lang.Object

The parsed OpenAPI specification.

---

##### `specPath`<sup>Required</sup> <a name="specPath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.specPath"></a>

- *Type:* java.lang.String

Path to the JSON open api spec.

---

##### `webAclOptions`<sup>Optional</sup> <a name="webAclOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.Initializer.parameter.webAclOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a>

Options for the AWS WAF v2 WebACL associated with the api.

By default, a Web ACL with the AWS default managed
rule set will be associated with the API. These options may disable or override the defaults.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayRestApi;

OpenApiGatewayRestApi.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.api">api</a></code> | <code>software.amazon.awscdk.services.apigateway.SpecRestApi</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.ipSet">ipSet</a></code> | <code>software.amazon.awscdk.services.wafv2.CfnIPSet</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAcl">webAcl</a></code> | <code>software.amazon.awscdk.services.wafv2.CfnWebACL</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAclAssociation">webAclAssociation</a></code> | <code>software.amazon.awscdk.services.wafv2.CfnWebACLAssociation</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.api"></a>

```java
public SpecRestApi getApi();
```

- *Type:* software.amazon.awscdk.services.apigateway.SpecRestApi

---

##### `ipSet`<sup>Optional</sup> <a name="ipSet" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.ipSet"></a>

```java
public CfnIPSet getIpSet();
```

- *Type:* software.amazon.awscdk.services.wafv2.CfnIPSet

---

##### `webAcl`<sup>Optional</sup> <a name="webAcl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAcl"></a>

```java
public CfnWebACL getWebAcl();
```

- *Type:* software.amazon.awscdk.services.wafv2.CfnWebACL

---

##### `webAclAssociation`<sup>Optional</sup> <a name="webAclAssociation" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApi.property.webAclAssociation"></a>

```java
public CfnWebACLAssociation getWebAclAssociation();
```

- *Type:* software.amazon.awscdk.services.wafv2.CfnWebACLAssociation

---


## Structs <a name="Structs" id="Structs"></a>

### ApiGatewayIntegration <a name="ApiGatewayIntegration" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration"></a>

Represents an api gateway integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegration;

ApiGatewayIntegration.builder()
//  .cacheKeyParameters(java.util.List<java.lang.String>)
//  .cacheNamespace(java.lang.String)
//  .connectionId(java.lang.String)
//  .connectionType(java.lang.String)
//  .contentHandling(java.lang.String)
//  .credentials(java.lang.String)
//  .httpMethod(java.lang.String)
//  .passthroughBehavior(java.lang.String)
//  .requestParameters(java.util.Map<java.lang.String, java.lang.String>)
//  .requestTemplates(java.util.Map<java.lang.String, java.lang.String>)
//  .responses(java.util.Map<java.lang.String, ApiGatewayIntegrationResponse>)
//  .timeoutInMillis(java.lang.Number)
//  .tlsConfig(ApiGatewayIntegrationTlsConfig)
//  .type(java.lang.String)
//  .uri(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheKeyParameters">cacheKeyParameters</a></code> | <code>java.util.List<java.lang.String></code> | A list of request parameters whose values are to be cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheNamespace">cacheNamespace</a></code> | <code>java.lang.String</code> | An API-specific tag group of related cached parameters. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionId">connectionId</a></code> | <code>java.lang.String</code> | The ID of a VpcLink for the private integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionType">connectionType</a></code> | <code>java.lang.String</code> | The integration connection type. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.contentHandling">contentHandling</a></code> | <code>java.lang.String</code> | Request payload encoding conversion types. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.credentials">credentials</a></code> | <code>java.lang.String</code> | For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.httpMethod">httpMethod</a></code> | <code>java.lang.String</code> | The HTTP method used in the integration request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.passthroughBehavior">passthroughBehavior</a></code> | <code>java.lang.String</code> | Specifies how a request payload of unmapped content type is passed through the integration request without modification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestParameters">requestParameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Specifies mappings from method request parameters to integration request parameters. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestTemplates">requestTemplates</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Mapping templates for a request payload of specified MIME types. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.responses">responses</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse">ApiGatewayIntegrationResponse</a>></code> | Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.timeoutInMillis">timeoutInMillis</a></code> | <code>java.lang.Number</code> | Custom timeout between 50 and 29,000 milliseconds. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.tlsConfig">tlsConfig</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig">ApiGatewayIntegrationTlsConfig</a></code> | Specifies the TLS configuration for an integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.type">type</a></code> | <code>java.lang.String</code> | The type of integration with the specified backend. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.uri">uri</a></code> | <code>java.lang.String</code> | The endpoint URI of the backend. |

---

##### `cacheKeyParameters`<sup>Optional</sup> <a name="cacheKeyParameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheKeyParameters"></a>

```java
public java.util.List<java.lang.String> getCacheKeyParameters();
```

- *Type:* java.util.List<java.lang.String>

A list of request parameters whose values are to be cached.

---

##### `cacheNamespace`<sup>Optional</sup> <a name="cacheNamespace" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.cacheNamespace"></a>

```java
public java.lang.String getCacheNamespace();
```

- *Type:* java.lang.String

An API-specific tag group of related cached parameters.

---

##### `connectionId`<sup>Optional</sup> <a name="connectionId" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionId"></a>

```java
public java.lang.String getConnectionId();
```

- *Type:* java.lang.String

The ID of a VpcLink for the private integration.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html](https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html)

---

##### `connectionType`<sup>Optional</sup> <a name="connectionType" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.connectionType"></a>

```java
public java.lang.String getConnectionType();
```

- *Type:* java.lang.String

The integration connection type.

The valid value is "VPC_LINK" for private integration or "INTERNET", otherwise.

---

##### `contentHandling`<sup>Optional</sup> <a name="contentHandling" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.contentHandling"></a>

```java
public java.lang.String getContentHandling();
```

- *Type:* java.lang.String

Request payload encoding conversion types.

Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
base64-decoded blob or passing through a binary payload natively without modification.

---

##### `credentials`<sup>Optional</sup> <a name="credentials" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.credentials"></a>

```java
public java.lang.String getCredentials();
```

- *Type:* java.lang.String

For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role.

If unspecified, credentials default
to resource-based permissions that must be added manually to allow the API to access the resource. For more
information, see Granting Permissions Using a Resource Policy.

Note: When using IAM credentials, make sure that AWS STS Regional endpoints are enabled for the Region where this
API is deployed for best performance.

---

##### `httpMethod`<sup>Optional</sup> <a name="httpMethod" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.httpMethod"></a>

```java
public java.lang.String getHttpMethod();
```

- *Type:* java.lang.String

The HTTP method used in the integration request.

For Lambda function invocations, the value must be POST.

---

##### `passthroughBehavior`<sup>Optional</sup> <a name="passthroughBehavior" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.passthroughBehavior"></a>

```java
public java.lang.String getPassthroughBehavior();
```

- *Type:* java.lang.String

Specifies how a request payload of unmapped content type is passed through the integration request without modification.

Supported values are when_no_templates, when_no_match, and never.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior)

---

##### `requestParameters`<sup>Optional</sup> <a name="requestParameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestParameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getRequestParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Specifies mappings from method request parameters to integration request parameters.

Supported request parameters
are querystring, path, header, and body.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html)

---

##### `requestTemplates`<sup>Optional</sup> <a name="requestTemplates" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.requestTemplates"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getRequestTemplates();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Mapping templates for a request payload of specified MIME types.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html)

---

##### `responses`<sup>Optional</sup> <a name="responses" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.responses"></a>

```java
public java.util.Map<java.lang.String, ApiGatewayIntegrationResponse> getResponses();
```

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse">ApiGatewayIntegrationResponse</a>>

Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html)

---

##### `timeoutInMillis`<sup>Optional</sup> <a name="timeoutInMillis" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.timeoutInMillis"></a>

```java
public java.lang.Number getTimeoutInMillis();
```

- *Type:* java.lang.Number

Custom timeout between 50 and 29,000 milliseconds.

The default value is 29,000 milliseconds or 29 seconds.

---

##### `tlsConfig`<sup>Optional</sup> <a name="tlsConfig" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.tlsConfig"></a>

```java
public ApiGatewayIntegrationTlsConfig getTlsConfig();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig">ApiGatewayIntegrationTlsConfig</a>

Specifies the TLS configuration for an integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.type"></a>

```java
public java.lang.String getType();
```

- *Type:* java.lang.String

The type of integration with the specified backend.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type)

---

##### `uri`<sup>Optional</sup> <a name="uri" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration.property.uri"></a>

```java
public java.lang.String getUri();
```

- *Type:* java.lang.String

The endpoint URI of the backend.

For integrations of the aws type, this is an ARN value.
For the HTTP integration, this is the URL of the HTTP endpoint including the https or http scheme.

---

### ApiGatewayIntegrationResponse <a name="ApiGatewayIntegrationResponse" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse"></a>

API Gateway integration response.

> [https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html](https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse;

ApiGatewayIntegrationResponse.builder()
    .responseParameters(java.util.Map<java.lang.String, java.lang.String>)
    .responseTemplates(java.util.Map<java.lang.String, java.lang.String>)
    .statusCode(java.lang.String)
//  .contentHandling(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseParameters">responseParameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Specifies parameter mappings for the response. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseTemplates">responseTemplates</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Specifies MIME type-specific mapping templates for the response’s payload. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.statusCode">statusCode</a></code> | <code>java.lang.String</code> | HTTP status code for the method response. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.contentHandling">contentHandling</a></code> | <code>java.lang.String</code> | Response payload encoding conversion types. |

---

##### `responseParameters`<sup>Required</sup> <a name="responseParameters" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseParameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResponseParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Specifies parameter mappings for the response.

---

##### `responseTemplates`<sup>Required</sup> <a name="responseTemplates" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.responseTemplates"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResponseTemplates();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Specifies MIME type-specific mapping templates for the response’s payload.

---

##### `statusCode`<sup>Required</sup> <a name="statusCode" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.statusCode"></a>

```java
public java.lang.String getStatusCode();
```

- *Type:* java.lang.String

HTTP status code for the method response.

---

##### `contentHandling`<sup>Optional</sup> <a name="contentHandling" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationResponse.property.contentHandling"></a>

```java
public java.lang.String getContentHandling();
```

- *Type:* java.lang.String

Response payload encoding conversion types.

Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
base64-decoded blob or passing through a binary payload natively without modification.

---

### ApiGatewayIntegrationTlsConfig <a name="ApiGatewayIntegrationTlsConfig" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig"></a>

Specifies the TLS configuration for an integration.

> [https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig;

ApiGatewayIntegrationTlsConfig.builder()
//  .insecureSkipVerification(java.lang.Boolean)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.property.insecureSkipVerification">insecureSkipVerification</a></code> | <code>java.lang.Boolean</code> | Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority. |

---

##### `insecureSkipVerification`<sup>Optional</sup> <a name="insecureSkipVerification" id="@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegrationTlsConfig.property.insecureSkipVerification"></a>

```java
public java.lang.Boolean getInsecureSkipVerification();
```

- *Type:* java.lang.Boolean

Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority.

This isn’t recommended, but it enables you to use certificates that are
signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still
performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and
presence of a root certificate authority. Supported only for HTTP and HTTP_PROXY integrations.

---

### AuthorizerProps <a name="AuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps"></a>

Properties for an authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.AuthorizerProps;

AuthorizerProps.builder()
    .authorizationType(AuthorizationType)
    .authorizerId(java.lang.String)
//  .authorizationScopes(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationType"></a>

```java
public AuthorizationType getAuthorizationType();
```

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.AuthorizerProps.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---

### CidrAllowList <a name="CidrAllowList" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList"></a>

Representation of a CIDR range.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.CidrAllowList;

CidrAllowList.builder()
    .cidrRanges(java.util.List<java.lang.String>)
    .cidrType(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrRanges">cidrRanges</a></code> | <code>java.util.List<java.lang.String></code> | Specify an IPv4 address by using CIDR notation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrType">cidrType</a></code> | <code>java.lang.String</code> | Type of CIDR range. |

---

##### `cidrRanges`<sup>Required</sup> <a name="cidrRanges" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrRanges"></a>

```java
public java.util.List<java.lang.String> getCidrRanges();
```

- *Type:* java.util.List<java.lang.String>

Specify an IPv4 address by using CIDR notation.

For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .

For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .

Specify an IPv6 address by using CIDR notation. For example:
To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .

---

##### `cidrType`<sup>Required</sup> <a name="cidrType" id="@aws-prototyping-sdk/open-api-gateway.CidrAllowList.property.cidrType"></a>

```java
public java.lang.String getCidrType();
```

- *Type:* java.lang.String

Type of CIDR range.

---

### CognitoAuthorizerProps <a name="CognitoAuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps"></a>

Properties used to configure a cognito authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.CognitoAuthorizerProps;

CognitoAuthorizerProps.builder()
    .authorizerId(java.lang.String)
    .userPools(java.util.List<IUserPool>)
//  .authorizationScopes(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.userPools">userPools</a></code> | <code>java.util.List<software.amazon.awscdk.services.cognito.IUserPool></code> | The Cognito user pools associated with this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | A list of authorization scopes configured on the method. |

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

Unique identifier for this authorizer.

---

##### `userPools`<sup>Required</sup> <a name="userPools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.userPools"></a>

```java
public java.util.List<IUserPool> getUserPools();
```

- *Type:* java.util.List<software.amazon.awscdk.services.cognito.IUserPool>

The Cognito user pools associated with this authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

A list of authorization scopes configured on the method.

When used as the default authorizer, these scopes will be
applied to all methods without an authorizer at the integration level.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

---

### CommonApiProjectOptions <a name="CommonApiProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.CommonApiProjectOptions;

CommonApiProjectOptions.builder()
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.CommonApiProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

### CustomAuthorizerProps <a name="CustomAuthorizerProps" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps"></a>

Properties used to configure a custom authorizer.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.CustomAuthorizerProps;

CustomAuthorizerProps.builder()
    .authorizerId(java.lang.String)
    .function(IFunction)
//  .authorizerResultTtlInSeconds(java.lang.Number)
//  .identitySource(java.lang.String)
//  .type(CustomAuthorizerType)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.function">function</a></code> | <code>software.amazon.awscdk.services.lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerResultTtlInSeconds">authorizerResultTtlInSeconds</a></code> | <code>java.lang.Number</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.identitySource">identitySource</a></code> | <code>java.lang.String</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

Unique identifier for this authorizer.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.function"></a>

```java
public IFunction getFunction();
```

- *Type:* software.amazon.awscdk.services.lambda.IFunction

The lambda function used to authorize requests.

---

##### `authorizerResultTtlInSeconds`<sup>Optional</sup> <a name="authorizerResultTtlInSeconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.authorizerResultTtlInSeconds"></a>

```java
public java.lang.Number getAuthorizerResultTtlInSeconds();
```

- *Type:* java.lang.Number
- *Default:* 300

The number of seconds during which the authorizer result is cached.

---

##### `identitySource`<sup>Optional</sup> <a name="identitySource" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.identitySource"></a>

```java
public java.lang.String getIdentitySource();
```

- *Type:* java.lang.String
- *Default:* "method.request.header.Authorization"

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps.property.type"></a>

```java
public CustomAuthorizerType getType();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>
- *Default:* CustomAuthorizerType.TOKEN

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---

### IntegrationGrantProps <a name="IntegrationGrantProps" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps"></a>

Properties for granting the API access to invoke the operation.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.IntegrationGrantProps;

IntegrationGrantProps.builder()
    .method(java.lang.String)
    .path(java.lang.String)
    .api(SpecRestApi)
    .operationId(java.lang.String)
    .scope(Construct)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.method">method</a></code> | <code>java.lang.String</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.path">path</a></code> | <code>java.lang.String</code> | The path of this operation in the api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.api">api</a></code> | <code>software.amazon.awscdk.services.apigateway.SpecRestApi</code> | The api to grant permissions for. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.operationId">operationId</a></code> | <code>java.lang.String</code> | The ID of the operation for which permissions are being granted. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.scope">scope</a></code> | <code>software.constructs.Construct</code> | The scope in which permission resources can be created. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.method"></a>

```java
public java.lang.String getMethod();
```

- *Type:* java.lang.String

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.path"></a>

```java
public java.lang.String getPath();
```

- *Type:* java.lang.String

The path of this operation in the api.

---

##### `api`<sup>Required</sup> <a name="api" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.api"></a>

```java
public SpecRestApi getApi();
```

- *Type:* software.amazon.awscdk.services.apigateway.SpecRestApi

The api to grant permissions for.

---

##### `operationId`<sup>Required</sup> <a name="operationId" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.operationId"></a>

```java
public java.lang.String getOperationId();
```

- *Type:* java.lang.String

The ID of the operation for which permissions are being granted.

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps.property.scope"></a>

```java
public Construct getScope();
```

- *Type:* software.constructs.Construct

The scope in which permission resources can be created.

---

### IntegrationRenderProps <a name="IntegrationRenderProps" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps"></a>

Properties for rendering an integration into an API Gateway OpenAPI extension.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.IntegrationRenderProps;

IntegrationRenderProps.builder()
    .method(java.lang.String)
    .path(java.lang.String)
    .operationId(java.lang.String)
    .scope(Construct)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.method">method</a></code> | <code>java.lang.String</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.path">path</a></code> | <code>java.lang.String</code> | The path of this operation in the api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.operationId">operationId</a></code> | <code>java.lang.String</code> | The ID of the operation being rendered. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.scope">scope</a></code> | <code>software.constructs.Construct</code> | The scope in which the integration is being rendered. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.method"></a>

```java
public java.lang.String getMethod();
```

- *Type:* java.lang.String

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.path"></a>

```java
public java.lang.String getPath();
```

- *Type:* java.lang.String

The path of this operation in the api.

---

##### `operationId`<sup>Required</sup> <a name="operationId" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.operationId"></a>

```java
public java.lang.String getOperationId();
```

- *Type:* java.lang.String

The ID of the operation being rendered.

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps.property.scope"></a>

```java
public Construct getScope();
```

- *Type:* software.constructs.Construct

The scope in which the integration is being rendered.

---

### ManagedRule <a name="ManagedRule" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.ManagedRule;

ManagedRule.builder()
    .name(java.lang.String)
    .vendor(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.name">name</a></code> | <code>java.lang.String</code> | The name of the managed rule group. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.vendor">vendor</a></code> | <code>java.lang.String</code> | The name of the managed rule group vendor. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

The name of the managed rule group.

You use this, along with the vendor name, to identify the rule group.

---

##### `vendor`<sup>Required</sup> <a name="vendor" id="@aws-prototyping-sdk/open-api-gateway.ManagedRule.property.vendor"></a>

```java
public java.lang.String getVendor();
```

- *Type:* java.lang.String

The name of the managed rule group vendor.

You use this, along with the rule group name, to identify the rule group.

---

### MethodAndPath <a name="MethodAndPath" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath"></a>

Structure to contain an API operation's method and path.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.MethodAndPath;

MethodAndPath.builder()
    .method(java.lang.String)
    .path(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.method">method</a></code> | <code>java.lang.String</code> | The http method of this operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.path">path</a></code> | <code>java.lang.String</code> | The path of this operation in the api. |

---

##### `method`<sup>Required</sup> <a name="method" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.method"></a>

```java
public java.lang.String getMethod();
```

- *Type:* java.lang.String

The http method of this operation.

---

##### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/open-api-gateway.MethodAndPath.property.path"></a>

```java
public java.lang.String getPath();
```

- *Type:* java.lang.String

The path of this operation in the api.

---

### OpenApiGatewayJavaProjectOptions <a name="OpenApiGatewayJavaProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions"></a>

Configuration for the OpenApiGatewayJavaProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayJavaProjectOptions;

OpenApiGatewayJavaProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .artifactId(java.lang.String)
    .groupId(java.lang.String)
    .version(java.lang.String)
//  .description(java.lang.String)
//  .packaging(java.lang.String)
//  .url(java.lang.String)
//  .compileOptions(MavenCompileOptions)
//  .deps(java.util.List<java.lang.String>)
//  .distdir(java.lang.String)
//  .junit(java.lang.Boolean)
//  .junitOptions(JunitOptions)
//  .packagingOptions(MavenPackagingOptions)
//  .projenrcJava(java.lang.Boolean)
//  .projenrcJavaOptions(ProjenrcOptions)
//  .testDeps(java.util.List<java.lang.String>)
//  .sample(java.lang.Boolean)
//  .sampleJavaPackage(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.artifactId">artifactId</a></code> | <code>java.lang.String</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.groupId">groupId</a></code> | <code>java.lang.String</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.version">version</a></code> | <code>java.lang.String</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packaging">packaging</a></code> | <code>java.lang.String</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.url">url</a></code> | <code>java.lang.String</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.compileOptions">compileOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.distdir">distdir</a></code> | <code>java.lang.String</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junit">junit</a></code> | <code>java.lang.Boolean</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junitOptions">junitOptions</a></code> | <code>io.github.cdklabs.projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packagingOptions">packagingOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJava">projenrcJava</a></code> | <code>java.lang.Boolean</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>io.github.cdklabs.projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.testDeps">testDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sampleJavaPackage">sampleJavaPackage</a></code> | <code>java.lang.String</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.artifactId"></a>

```java
public java.lang.String getArtifactId();
```

- *Type:* java.lang.String
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.groupId"></a>

```java
public java.lang.String getGroupId();
```

- *Type:* java.lang.String
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packaging"></a>

```java
public java.lang.String getPackaging();
```

- *Type:* java.lang.String
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.compileOptions"></a>

```java
public MavenCompileOptions getCompileOptions();
```

- *Type:* io.github.cdklabs.projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.distdir"></a>

```java
public java.lang.String getDistdir();
```

- *Type:* java.lang.String
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junit"></a>

```java
public java.lang.Boolean getJunit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.junitOptions"></a>

```java
public JunitOptions getJunitOptions();
```

- *Type:* io.github.cdklabs.projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.packagingOptions"></a>

```java
public MavenPackagingOptions getPackagingOptions();
```

- *Type:* io.github.cdklabs.projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJava"></a>

```java
public java.lang.Boolean getProjenrcJava();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.projenrcJavaOptions"></a>

```java
public ProjenrcOptions getProjenrcJavaOptions();
```

- *Type:* io.github.cdklabs.projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.testDeps"></a>

```java
public java.util.List<java.lang.String> getTestDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sample"></a>

```java
public java.lang.Boolean getSample();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.sampleJavaPackage"></a>

```java
public java.lang.String getSampleJavaPackage();
```

- *Type:* java.lang.String
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProjectOptions.property.specFile"></a>

```java
public java.lang.String getSpecFile();
```

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayProjectOptions <a name="OpenApiGatewayProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions"></a>

Options common to all open api gateway projects.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayProjectOptions;

OpenApiGatewayProjectOptions.builder()
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayProjectOptions.property.specFile"></a>

```java
public java.lang.String getSpecFile();
```

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayPythonProjectOptions <a name="OpenApiGatewayPythonProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions"></a>

Configuration for the OpenApiGatewayPythonProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayPythonProjectOptions;

OpenApiGatewayPythonProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .authorEmail(java.lang.String)
    .authorName(java.lang.String)
    .version(java.lang.String)
//  .classifiers(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .homepage(java.lang.String)
//  .license(java.lang.String)
//  .packageName(java.lang.String)
//  .poetryOptions(PoetryPyprojectOptionsWithoutDeps)
//  .setupConfig(java.util.Map<java.lang.String, java.lang.Object>)
    .moduleName(java.lang.String)
//  .deps(java.util.List<java.lang.String>)
//  .devDeps(java.util.List<java.lang.String>)
//  .pip(java.lang.Boolean)
//  .poetry(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenrcPython(java.lang.Boolean)
//  .projenrcPythonOptions(ProjenrcOptions)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcTsOptions)
//  .pytest(java.lang.Boolean)
//  .pytestOptions(PytestOptions)
//  .pythonExec(java.lang.String)
//  .sample(java.lang.Boolean)
//  .setuptools(java.lang.Boolean)
//  .venv(java.lang.Boolean)
//  .venvOptions(VenvOptions)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.version">version</a></code> | <code>java.lang.String</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.classifiers">classifiers</a></code> | <code>java.util.List<java.lang.String></code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetryOptions">poetryOptions</a></code> | <code>io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setupConfig">setupConfig</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pip">pip</a></code> | <code>java.lang.Boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetry">poetry</a></code> | <code>java.lang.Boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPython">projenrcPython</a></code> | <code>java.lang.Boolean</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>io.github.cdklabs.projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytest">pytest</a></code> | <code>java.lang.Boolean</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytestOptions">pytestOptions</a></code> | <code>io.github.cdklabs.projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonExec">pythonExec</a></code> | <code>java.lang.String</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setuptools">setuptools</a></code> | <code>java.lang.Boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venv">venv</a></code> | <code>java.lang.Boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venvOptions">venvOptions</a></code> | <code>io.github.cdklabs.projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.classifiers"></a>

```java
public java.util.List<java.lang.String> getClassifiers();
```

- *Type:* java.util.List<java.lang.String>

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetryOptions"></a>

```java
public PoetryPyprojectOptionsWithoutDeps getPoetryOptions();
```

- *Type:* io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setupConfig"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getSetupConfig();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.moduleName"></a>

```java
public java.lang.String getModuleName();
```

- *Type:* java.lang.String
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pip"></a>

```java
public java.lang.Boolean getPip();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.poetry"></a>

```java
public java.lang.Boolean getPoetry();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPython"></a>

```java
public java.lang.Boolean getProjenrcPython();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcPythonOptions"></a>

```java
public ProjenrcOptions getProjenrcPythonOptions();
```

- *Type:* io.github.cdklabs.projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcTsOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytest"></a>

```java
public java.lang.Boolean getPytest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pytestOptions"></a>

```java
public PytestOptions getPytestOptions();
```

- *Type:* io.github.cdklabs.projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `pythonExec`<sup>Optional</sup> <a name="pythonExec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonExec"></a>

```java
public java.lang.String getPythonExec();
```

- *Type:* java.lang.String
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.sample"></a>

```java
public java.lang.Boolean getSample();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.setuptools"></a>

```java
public java.lang.Boolean getSetuptools();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venv"></a>

```java
public java.lang.Boolean getVenv();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.venvOptions"></a>

```java
public VenvOptions getVenvOptions();
```

- *Type:* io.github.cdklabs.projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProjectOptions.property.specFile"></a>

```java
public java.lang.String getSpecFile();
```

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayRestApiProps <a name="OpenApiGatewayRestApiProps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps"></a>

Configuration for the OpenApiGatewayRestApi construct.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayRestApiProps;

OpenApiGatewayRestApiProps.builder()
//  .cloudWatchRole(java.lang.Boolean)
//  .deploy(java.lang.Boolean)
//  .deployOptions(StageOptions)
//  .description(java.lang.String)
//  .disableExecuteApiEndpoint(java.lang.Boolean)
//  .domainName(DomainNameOptions)
//  .endpointExportName(java.lang.String)
//  .endpointTypes(java.util.List<EndpointType>)
//  .failOnWarnings(java.lang.Boolean)
//  .parameters(java.util.Map<java.lang.String, java.lang.String>)
//  .policy(PolicyDocument)
//  .restApiName(java.lang.String)
//  .retainDeployments(java.lang.Boolean)
    .integrations(java.util.Map<java.lang.String, OpenApiIntegration>)
    .operationLookup(java.util.Map<java.lang.String, MethodAndPath>)
//  .corsOptions(CorsOptions)
//  .defaultAuthorizer(Authorizer)
    .spec(java.lang.Object)
    .specPath(java.lang.String)
//  .webAclOptions(OpenApiGatewayWebAclOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.cloudWatchRole">cloudWatchRole</a></code> | <code>java.lang.Boolean</code> | Automatically configure an AWS CloudWatch role for API Gateway. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deploy">deploy</a></code> | <code>java.lang.Boolean</code> | Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deployOptions">deployOptions</a></code> | <code>software.amazon.awscdk.services.apigateway.StageOptions</code> | Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.description">description</a></code> | <code>java.lang.String</code> | A description of the RestApi construct. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.disableExecuteApiEndpoint">disableExecuteApiEndpoint</a></code> | <code>java.lang.Boolean</code> | Specifies whether clients can invoke the API using the default execute-api endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.domainName">domainName</a></code> | <code>software.amazon.awscdk.services.apigateway.DomainNameOptions</code> | Configure a custom domain name and map it to this API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointExportName">endpointExportName</a></code> | <code>java.lang.String</code> | Export name for the CfnOutput containing the API endpoint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointTypes">endpointTypes</a></code> | <code>java.util.List<software.amazon.awscdk.services.apigateway.EndpointType></code> | A list of the endpoint types of the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.failOnWarnings">failOnWarnings</a></code> | <code>java.lang.Boolean</code> | Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.parameters">parameters</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Custom header parameters for the request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.policy">policy</a></code> | <code>software.amazon.awscdk.services.iam.PolicyDocument</code> | A policy document that contains the permissions for this RestApi. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.restApiName">restApiName</a></code> | <code>java.lang.String</code> | A name for the API Gateway RestApi resource. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.retainDeployments">retainDeployments</a></code> | <code>java.lang.Boolean</code> | Retains old deployment resources when the API changes. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.integrations">integrations</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>></code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.operationLookup">operationLookup</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>></code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.corsOptions">corsOptions</a></code> | <code>software.amazon.awscdk.services.apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.defaultAuthorizer">defaultAuthorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.spec">spec</a></code> | <code>java.lang.Object</code> | The parsed OpenAPI specification. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.specPath">specPath</a></code> | <code>java.lang.String</code> | Path to the JSON open api spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.webAclOptions">webAclOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a></code> | Options for the AWS WAF v2 WebACL associated with the api. |

---

##### `cloudWatchRole`<sup>Optional</sup> <a name="cloudWatchRole" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.cloudWatchRole"></a>

```java
public java.lang.Boolean getCloudWatchRole();
```

- *Type:* java.lang.Boolean
- *Default:* false if `@aws-cdk/aws-apigateway:disableCloudWatchRole` is enabled, true otherwise

Automatically configure an AWS CloudWatch role for API Gateway.

---

##### `deploy`<sup>Optional</sup> <a name="deploy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deploy"></a>

```java
public java.lang.Boolean getDeploy();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.

Since API Gateway deployments are immutable, When this option is enabled
(by default), an AWS::ApiGateway::Deployment resource will automatically
created with a logical ID that hashes the API model (methods, resources
and options). This means that when the model changes, the logical ID of
this CloudFormation resource will change, and a new deployment will be
created.

If this is set, `latestDeployment` will refer to the `Deployment` object
and `deploymentStage` will refer to a `Stage` that points to this
deployment. To customize the stage options, use the `deployOptions`
property.

A CloudFormation Output will also be defined with the root URL endpoint
of this REST API.

---

##### `deployOptions`<sup>Optional</sup> <a name="deployOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.deployOptions"></a>

```java
public StageOptions getDeployOptions();
```

- *Type:* software.amazon.awscdk.services.apigateway.StageOptions
- *Default:* Based on defaults of `StageOptions`.

Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.

If `deploy` is disabled,
this value cannot be set.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String
- *Default:* 'Automatically created by the RestApi construct'

A description of the RestApi construct.

---

##### `disableExecuteApiEndpoint`<sup>Optional</sup> <a name="disableExecuteApiEndpoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.disableExecuteApiEndpoint"></a>

```java
public java.lang.Boolean getDisableExecuteApiEndpoint();
```

- *Type:* java.lang.Boolean
- *Default:* false

Specifies whether clients can invoke the API using the default execute-api endpoint.

To require that clients use a custom domain name to invoke the
API, disable the default endpoint.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html)

---

##### `domainName`<sup>Optional</sup> <a name="domainName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.domainName"></a>

```java
public DomainNameOptions getDomainName();
```

- *Type:* software.amazon.awscdk.services.apigateway.DomainNameOptions
- *Default:* no domain name is defined, use `addDomainName` or directly define a `DomainName`.

Configure a custom domain name and map it to this API.

---

##### `endpointExportName`<sup>Optional</sup> <a name="endpointExportName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointExportName"></a>

```java
public java.lang.String getEndpointExportName();
```

- *Type:* java.lang.String
- *Default:* when no export name is given, output will be created without export

Export name for the CfnOutput containing the API endpoint.

---

##### `endpointTypes`<sup>Optional</sup> <a name="endpointTypes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.endpointTypes"></a>

```java
public java.util.List<EndpointType> getEndpointTypes();
```

- *Type:* java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>
- *Default:* EndpointType.EDGE

A list of the endpoint types of the API.

Use this property when creating
an API.

---

##### `failOnWarnings`<sup>Optional</sup> <a name="failOnWarnings" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.failOnWarnings"></a>

```java
public java.lang.Boolean getFailOnWarnings();
```

- *Type:* java.lang.Boolean
- *Default:* false

Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.parameters"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getParameters();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* No parameters.

Custom header parameters for the request.

> [https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html](https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html)

---

##### `policy`<sup>Optional</sup> <a name="policy" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.policy"></a>

```java
public PolicyDocument getPolicy();
```

- *Type:* software.amazon.awscdk.services.iam.PolicyDocument
- *Default:* No policy.

A policy document that contains the permissions for this RestApi.

---

##### `restApiName`<sup>Optional</sup> <a name="restApiName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.restApiName"></a>

```java
public java.lang.String getRestApiName();
```

- *Type:* java.lang.String
- *Default:* ID of the RestApi construct.

A name for the API Gateway RestApi resource.

---

##### `retainDeployments`<sup>Optional</sup> <a name="retainDeployments" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.retainDeployments"></a>

```java
public java.lang.Boolean getRetainDeployments();
```

- *Type:* java.lang.Boolean
- *Default:* false

Retains old deployment resources when the API changes.

This allows
manually reverting stages to point to old deployments via the AWS
Console.

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.integrations"></a>

```java
public java.util.Map<java.lang.String, OpenApiIntegration> getIntegrations();
```

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>>

A mapping of API operation to its integration.

---

##### `operationLookup`<sup>Required</sup> <a name="operationLookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.operationLookup"></a>

```java
public java.util.Map<java.lang.String, MethodAndPath> getOperationLookup();
```

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>>

Details about each operation.

---

##### `corsOptions`<sup>Optional</sup> <a name="corsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.corsOptions"></a>

```java
public CorsOptions getCorsOptions();
```

- *Type:* software.amazon.awscdk.services.apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `defaultAuthorizer`<sup>Optional</sup> <a name="defaultAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.defaultAuthorizer"></a>

```java
public Authorizer getDefaultAuthorizer();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

##### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.spec"></a>

```java
public java.lang.Object getSpec();
```

- *Type:* java.lang.Object

The parsed OpenAPI specification.

---

##### `specPath`<sup>Required</sup> <a name="specPath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.specPath"></a>

```java
public java.lang.String getSpecPath();
```

- *Type:* java.lang.String

Path to the JSON open api spec.

---

##### `webAclOptions`<sup>Optional</sup> <a name="webAclOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayRestApiProps.property.webAclOptions"></a>

```java
public OpenApiGatewayWebAclOptions getWebAclOptions();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions">OpenApiGatewayWebAclOptions</a>

Options for the AWS WAF v2 WebACL associated with the api.

By default, a Web ACL with the AWS default managed
rule set will be associated with the API. These options may disable or override the defaults.

---

### OpenApiGatewayTsProjectOptions <a name="OpenApiGatewayTsProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions"></a>

Configuration for the OpenApiGatewayTsProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayTsProjectOptions;

OpenApiGatewayTsProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .workflowPackageCache(java.lang.Boolean)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowPackageCache">workflowPackageCache</a></code> | <code>java.lang.Boolean</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.allowLibraryDependencies"></a>

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorOrganization"></a>

```java
public java.lang.Boolean getAuthorOrganization();
```

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.authorUrl"></a>

```java
public java.lang.String getAuthorUrl();
```

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoDetectBin"></a>

```java
public java.lang.Boolean getAutoDetectBin();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bin"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getBin();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsEmail"></a>

```java
public java.lang.String getBugsEmail();
```

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bugsUrl"></a>

```java
public java.lang.String getBugsUrl();
```

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundledDeps"></a>

```java
public java.util.List<java.lang.String> getBundledDeps();
```

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeArtifactOptions"></a>

```java
public CodeArtifactOptions getCodeArtifactOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypoint"></a>

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.keywords"></a>

```java
public java.util.List<java.lang.String> getKeywords();
```

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.licensed"></a>

```java
public java.lang.Boolean getLicensed();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.maxNodeVersion"></a>

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minNodeVersion"></a>

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmAccess"></a>

```java
public NpmAccess getNpmAccess();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```java
public java.lang.String getNpmRegistry();
```

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmRegistryUrl"></a>

```java
public java.lang.String getNpmRegistryUrl();
```

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmTokenSecret"></a>

```java
public java.lang.String getNpmTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageManager"></a>

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDependencyOptions"></a>

```java
public PeerDependencyOptions getPeerDependencyOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.peerDeps"></a>

```java
public java.util.List<java.lang.String> getPeerDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pnpmVersion"></a>

```java
public java.lang.String getPnpmVersion();
```

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repository"></a>

```java
public java.lang.String getRepository();
```

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.repositoryDirectory"></a>

```java
public java.lang.String getRepositoryDirectory();
```

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scopedPackagesOptions"></a>

```java
public java.util.List<ScopedPackagesOptions> getScopedPackagesOptions();
```

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```java
public java.util.Map<java.lang.String, java.lang.String> getScripts();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.stability"></a>

```java
public java.lang.String getStability();
```

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jsiiReleaseVersion"></a>

```java
public java.lang.String getJsiiReleaseVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.majorVersion"></a>

```java
public java.lang.Number getMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.minMajorVersion"></a>

```java
public java.lang.Number getMinMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmDistTag"></a>

```java
public java.lang.String getNpmDistTag();
```

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.postBuildSteps"></a>

```java
public java.util.List<JobStep> getPostBuildSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prerelease"></a>

```java
public java.lang.String getPrerelease();
```

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishDryRun"></a>

```java
public java.lang.Boolean getPublishDryRun();
```

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.publishTasks"></a>

```java
public java.lang.Boolean getPublishTasks();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseBranches"></a>

```java
public java.util.Map<java.lang.String, BranchOptions> getReleaseBranches();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```java
public java.lang.Boolean getReleaseEveryCommit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssue"></a>

```java
public java.lang.Boolean getReleaseFailureIssue();
```

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseFailureIssueLabel"></a>

```java
public java.lang.String getReleaseFailureIssueLabel();
```

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```java
public java.lang.String getReleaseSchedule();
```

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTagPrefix"></a>

```java
public java.lang.String getReleaseTagPrefix();
```

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseTrigger"></a>

```java
public ReleaseTrigger getReleaseTrigger();
```

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowName"></a>

```java
public java.lang.String getReleaseWorkflowName();
```

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```java
public java.util.List<JobStep> getReleaseWorkflowSetupSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.versionrcOptions"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getVersionrcOptions();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowContainerImage"></a>

```java
public java.lang.String getWorkflowContainerImage();
```

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowRunsOn"></a>

```java
public java.util.List<java.lang.String> getWorkflowRunsOn();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.defaultReleaseBranch"></a>

```java
public java.lang.String getDefaultReleaseBranch();
```

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.artifactsDirectory"></a>

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.autoApproveUpgrades"></a>

```java
public java.lang.Boolean getAutoApproveUpgrades();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflow"></a>

```java
public java.lang.Boolean getBuildWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.buildWorkflowTriggers"></a>

```java
public Triggers getBuildWorkflowTriggers();
```

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.bundlerOptions"></a>

```java
public BundlerOptions getBundlerOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCov"></a>

```java
public java.lang.Boolean getCodeCov();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.codeCovTokenSecret"></a>

```java
public java.lang.String getCodeCovTokenSecret();
```

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightOwner"></a>

```java
public java.lang.String getCopyrightOwner();
```

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.copyrightPeriod"></a>

```java
public java.lang.String getCopyrightPeriod();
```

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabot"></a>

```java
public java.lang.Boolean getDependabot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.dependabotOptions"></a>

```java
public DependabotOptions getDependabotOptions();
```

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgrade"></a>

```java
public java.lang.Boolean getDepsUpgrade();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.depsUpgradeOptions"></a>

```java
public UpgradeDependenciesOptions getDepsUpgradeOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.gitignore"></a>

```java
public java.util.List<java.lang.String> getGitignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jest"></a>

```java
public java.lang.Boolean getJest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.jestOptions"></a>

```java
public JestOptions getJestOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.mutableBuild"></a>

```java
public java.lang.Boolean getMutableBuild();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```java
public java.util.List<java.lang.String> getNpmignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmignoreEnabled"></a>

```java
public java.lang.Boolean getNpmignoreEnabled();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.npmIgnoreOptions"></a>

```java
public IgnoreFileOptions getNpmIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.package"></a>

```java
public java.lang.Boolean getPackage();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettier"></a>

```java
public java.lang.Boolean getPrettier();
```

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.prettierOptions"></a>

```java
public PrettierOptions getPrettierOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenDevDependency"></a>

```java
public java.lang.Boolean getProjenDevDependency();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenVersion"></a>

```java
public java.lang.String getProjenVersion();
```

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplate"></a>

```java
public java.lang.Boolean getPullRequestTemplate();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pullRequestTemplateContents"></a>

```java
public java.util.List<java.lang.String> getPullRequestTemplateContents();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.release"></a>

```java
public java.lang.Boolean getRelease();
```

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseToNpm"></a>

```java
public java.lang.Boolean getReleaseToNpm();
```

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```java
public java.lang.Boolean getReleaseWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowBootstrapSteps"></a>

```java
public java.util.List<JobStep> getWorkflowBootstrapSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowGitIdentity"></a>

```java
public GitIdentity getWorkflowGitIdentity();
```

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowNodeVersion"></a>

```java
public java.lang.String getWorkflowNodeVersion();
```

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflowPackageCache`<sup>Optional</sup> <a name="workflowPackageCache" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.workflowPackageCache"></a>

```java
public java.lang.Boolean getWorkflowPackageCache();
```

- *Type:* java.lang.Boolean
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfig"></a>

```java
public java.lang.Boolean getDisableTsconfig();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.disableTsconfigDev"></a>

```java
public java.lang.Boolean getDisableTsconfigDev();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docgen"></a>

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.docsDirectory"></a>

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.entrypointTypes"></a>

```java
public java.lang.String getEntrypointTypes();
```

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslint"></a>

```java
public java.lang.Boolean getEslint();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.eslintOptions"></a>

```java
public EslintOptions getEslintOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.libdir"></a>

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.sampleCode"></a>

```java
public java.lang.Boolean getSampleCode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.srcdir"></a>

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfig"></a>

```java
public TypescriptConfigOptions getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDev"></a>

```java
public TypescriptConfigOptions getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.tsconfigDevFile"></a>

```java
public java.lang.String getTsconfigDevFile();
```

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptVersion"></a>

```java
public java.lang.String getTypescriptVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProjectOptions.property.specFile"></a>

```java
public java.lang.String getSpecFile();
```

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

### OpenApiGatewayWebAclOptions <a name="OpenApiGatewayWebAclOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions"></a>

Configuration for the Web ACL associated with the API.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayWebAclOptions;

OpenApiGatewayWebAclOptions.builder()
//  .cidrAllowList(CidrAllowList)
//  .disable(java.lang.Boolean)
//  .managedRules(java.util.List<ManagedRule>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.cidrAllowList">cidrAllowList</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList">CidrAllowList</a></code> | List of cidr ranges to allow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.disable">disable</a></code> | <code>java.lang.Boolean</code> | If set to true, no WebACL will be associated with the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.managedRules">managedRules</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule">ManagedRule</a>></code> | List of managed rules to apply to the web acl. |

---

##### `cidrAllowList`<sup>Optional</sup> <a name="cidrAllowList" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.cidrAllowList"></a>

```java
public CidrAllowList getCidrAllowList();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CidrAllowList">CidrAllowList</a>
- *Default:* undefined

List of cidr ranges to allow.

---

##### `disable`<sup>Optional</sup> <a name="disable" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.disable"></a>

```java
public java.lang.Boolean getDisable();
```

- *Type:* java.lang.Boolean
- *Default:* false

If set to true, no WebACL will be associated with the API.

You can also use this option if you would like to create
your own WebACL and associate it yourself.

---

##### `managedRules`<sup>Optional</sup> <a name="managedRules" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayWebAclOptions.property.managedRules"></a>

```java
public java.util.List<ManagedRule> getManagedRules();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ManagedRule">ManagedRule</a>>
- *Default:* [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]

List of managed rules to apply to the web acl.

---

### OpenApiIntegration <a name="OpenApiIntegration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration"></a>

Defines an integration for an individual API operation.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiIntegration;

OpenApiIntegration.builder()
    .integration(Integration)
//  .authorizer(Authorizer)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.integration">integration</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration">Integration</a></code> | The lambda function to service the api operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.authorizer">authorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The authorizer to use for this api operation (overrides the default). |

---

##### `integration`<sup>Required</sup> <a name="integration" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.integration"></a>

```java
public Integration getIntegration();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Integration">Integration</a>

The lambda function to service the api operation.

---

##### `authorizer`<sup>Optional</sup> <a name="authorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration.property.authorizer"></a>

```java
public Authorizer getAuthorizer();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The authorizer to use for this api operation (overrides the default).

---

### OpenApiOptions <a name="OpenApiOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions"></a>

Options required alongside an Open API specification to create API Gateway resources.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiOptions;

OpenApiOptions.builder()
    .integrations(java.util.Map<java.lang.String, OpenApiIntegration>)
    .operationLookup(java.util.Map<java.lang.String, MethodAndPath>)
//  .corsOptions(CorsOptions)
//  .defaultAuthorizer(Authorizer)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.integrations">integrations</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>></code> | A mapping of API operation to its integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.operationLookup">operationLookup</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>></code> | Details about each operation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.corsOptions">corsOptions</a></code> | <code>software.amazon.awscdk.services.apigateway.CorsOptions</code> | Cross Origin Resource Sharing options for the API. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.defaultAuthorizer">defaultAuthorizer</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a></code> | The default authorizer to use for your api. |

---

##### `integrations`<sup>Required</sup> <a name="integrations" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.integrations"></a>

```java
public java.util.Map<java.lang.String, OpenApiIntegration> getIntegrations();
```

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiIntegration">OpenApiIntegration</a>>

A mapping of API operation to its integration.

---

##### `operationLookup`<sup>Required</sup> <a name="operationLookup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.operationLookup"></a>

```java
public java.util.Map<java.lang.String, MethodAndPath> getOperationLookup();
```

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.MethodAndPath">MethodAndPath</a>>

Details about each operation.

---

##### `corsOptions`<sup>Optional</sup> <a name="corsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.corsOptions"></a>

```java
public CorsOptions getCorsOptions();
```

- *Type:* software.amazon.awscdk.services.apigateway.CorsOptions

Cross Origin Resource Sharing options for the API.

---

##### `defaultAuthorizer`<sup>Optional</sup> <a name="defaultAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiOptions.property.defaultAuthorizer"></a>

```java
public Authorizer getDefaultAuthorizer();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer">Authorizer</a>

The default authorizer to use for your api.

When omitted, no default authorizer is used.
Authorizers specified at the integration level will override this for that operation.

---

### SmithyApiGatewayJavaProjectOptions <a name="SmithyApiGatewayJavaProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions"></a>

Configuration for the SmithyApiGatewayJavaProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyApiGatewayJavaProjectOptions;

SmithyApiGatewayJavaProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .artifactId(java.lang.String)
    .groupId(java.lang.String)
    .version(java.lang.String)
//  .description(java.lang.String)
//  .packaging(java.lang.String)
//  .url(java.lang.String)
//  .compileOptions(MavenCompileOptions)
//  .deps(java.util.List<java.lang.String>)
//  .distdir(java.lang.String)
//  .junit(java.lang.Boolean)
//  .junitOptions(JunitOptions)
//  .packagingOptions(MavenPackagingOptions)
//  .projenrcJava(java.lang.Boolean)
//  .projenrcJavaOptions(ProjenrcOptions)
//  .testDeps(java.util.List<java.lang.String>)
//  .sample(java.lang.Boolean)
//  .sampleJavaPackage(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .serviceName(SmithyServiceName)
//  .ignoreGradleWrapper(java.lang.Boolean)
//  .ignoreSmithyBuildOutput(java.lang.Boolean)
//  .modelDir(java.lang.String)
//  .smithyBuildOptions(SmithyBuildOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.artifactId">artifactId</a></code> | <code>java.lang.String</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.groupId">groupId</a></code> | <code>java.lang.String</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.version">version</a></code> | <code>java.lang.String</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packaging">packaging</a></code> | <code>java.lang.String</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.url">url</a></code> | <code>java.lang.String</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.compileOptions">compileOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.distdir">distdir</a></code> | <code>java.lang.String</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junit">junit</a></code> | <code>java.lang.Boolean</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junitOptions">junitOptions</a></code> | <code>io.github.cdklabs.projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packagingOptions">packagingOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJava">projenrcJava</a></code> | <code>java.lang.Boolean</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>io.github.cdklabs.projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.testDeps">testDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sampleJavaPackage">sampleJavaPackage</a></code> | <code>java.lang.String</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.modelDir">modelDir</a></code> | <code>java.lang.String</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.artifactId"></a>

```java
public java.lang.String getArtifactId();
```

- *Type:* java.lang.String
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.groupId"></a>

```java
public java.lang.String getGroupId();
```

- *Type:* java.lang.String
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packaging"></a>

```java
public java.lang.String getPackaging();
```

- *Type:* java.lang.String
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* java.lang.String
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.compileOptions"></a>

```java
public MavenCompileOptions getCompileOptions();
```

- *Type:* io.github.cdklabs.projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.distdir"></a>

```java
public java.lang.String getDistdir();
```

- *Type:* java.lang.String
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junit"></a>

```java
public java.lang.Boolean getJunit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.junitOptions"></a>

```java
public JunitOptions getJunitOptions();
```

- *Type:* io.github.cdklabs.projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.packagingOptions"></a>

```java
public MavenPackagingOptions getPackagingOptions();
```

- *Type:* io.github.cdklabs.projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJava"></a>

```java
public java.lang.Boolean getProjenrcJava();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.projenrcJavaOptions"></a>

```java
public ProjenrcOptions getProjenrcJavaOptions();
```

- *Type:* io.github.cdklabs.projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.testDeps"></a>

```java
public java.util.List<java.lang.String> getTestDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sample"></a>

```java
public java.lang.Boolean getSample();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.sampleJavaPackage"></a>

```java
public java.lang.String getSampleJavaPackage();
```

- *Type:* java.lang.String
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.serviceName"></a>

```java
public SmithyServiceName getServiceName();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreGradleWrapper"></a>

```java
public java.lang.Boolean getIgnoreGradleWrapper();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.ignoreSmithyBuildOutput"></a>

```java
public java.lang.Boolean getIgnoreSmithyBuildOutput();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.modelDir"></a>

```java
public java.lang.String getModelDir();
```

- *Type:* java.lang.String
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProjectOptions.property.smithyBuildOptions"></a>

```java
public SmithyBuildOptions getSmithyBuildOptions();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayProjectOptions <a name="SmithyApiGatewayProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions"></a>

Options common to all smithy api gateway projects.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyApiGatewayProjectOptions;

SmithyApiGatewayProjectOptions.builder()
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .serviceName(SmithyServiceName)
//  .ignoreGradleWrapper(java.lang.Boolean)
//  .ignoreSmithyBuildOutput(java.lang.Boolean)
//  .modelDir(java.lang.String)
//  .smithyBuildOptions(SmithyBuildOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.modelDir">modelDir</a></code> | <code>java.lang.String</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.serviceName"></a>

```java
public SmithyServiceName getServiceName();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreGradleWrapper"></a>

```java
public java.lang.Boolean getIgnoreGradleWrapper();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.ignoreSmithyBuildOutput"></a>

```java
public java.lang.Boolean getIgnoreSmithyBuildOutput();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.modelDir"></a>

```java
public java.lang.String getModelDir();
```

- *Type:* java.lang.String
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayProjectOptions.property.smithyBuildOptions"></a>

```java
public SmithyBuildOptions getSmithyBuildOptions();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayPythonProjectOptions <a name="SmithyApiGatewayPythonProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions"></a>

Configuration for the SmithyApiGatewayPythonProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyApiGatewayPythonProjectOptions;

SmithyApiGatewayPythonProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .authorEmail(java.lang.String)
    .authorName(java.lang.String)
    .version(java.lang.String)
//  .classifiers(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .homepage(java.lang.String)
//  .license(java.lang.String)
//  .packageName(java.lang.String)
//  .poetryOptions(PoetryPyprojectOptionsWithoutDeps)
//  .setupConfig(java.util.Map<java.lang.String, java.lang.Object>)
    .moduleName(java.lang.String)
//  .deps(java.util.List<java.lang.String>)
//  .devDeps(java.util.List<java.lang.String>)
//  .pip(java.lang.Boolean)
//  .poetry(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenrcPython(java.lang.Boolean)
//  .projenrcPythonOptions(ProjenrcOptions)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcTsOptions)
//  .pytest(java.lang.Boolean)
//  .pytestOptions(PytestOptions)
//  .pythonExec(java.lang.String)
//  .sample(java.lang.Boolean)
//  .setuptools(java.lang.Boolean)
//  .venv(java.lang.Boolean)
//  .venvOptions(VenvOptions)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .serviceName(SmithyServiceName)
//  .ignoreGradleWrapper(java.lang.Boolean)
//  .ignoreSmithyBuildOutput(java.lang.Boolean)
//  .modelDir(java.lang.String)
//  .smithyBuildOptions(SmithyBuildOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.version">version</a></code> | <code>java.lang.String</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.classifiers">classifiers</a></code> | <code>java.util.List<java.lang.String></code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetryOptions">poetryOptions</a></code> | <code>io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setupConfig">setupConfig</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pip">pip</a></code> | <code>java.lang.Boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetry">poetry</a></code> | <code>java.lang.Boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPython">projenrcPython</a></code> | <code>java.lang.Boolean</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>io.github.cdklabs.projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytest">pytest</a></code> | <code>java.lang.Boolean</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytestOptions">pytestOptions</a></code> | <code>io.github.cdklabs.projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonExec">pythonExec</a></code> | <code>java.lang.String</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setuptools">setuptools</a></code> | <code>java.lang.Boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venv">venv</a></code> | <code>java.lang.Boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venvOptions">venvOptions</a></code> | <code>io.github.cdklabs.projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.modelDir">modelDir</a></code> | <code>java.lang.String</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.classifiers"></a>

```java
public java.util.List<java.lang.String> getClassifiers();
```

- *Type:* java.util.List<java.lang.String>

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetryOptions"></a>

```java
public PoetryPyprojectOptionsWithoutDeps getPoetryOptions();
```

- *Type:* io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setupConfig"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getSetupConfig();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.moduleName"></a>

```java
public java.lang.String getModuleName();
```

- *Type:* java.lang.String
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pip"></a>

```java
public java.lang.Boolean getPip();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.poetry"></a>

```java
public java.lang.Boolean getPoetry();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPython"></a>

```java
public java.lang.Boolean getProjenrcPython();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcPythonOptions"></a>

```java
public ProjenrcOptions getProjenrcPythonOptions();
```

- *Type:* io.github.cdklabs.projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcTsOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytest"></a>

```java
public java.lang.Boolean getPytest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pytestOptions"></a>

```java
public PytestOptions getPytestOptions();
```

- *Type:* io.github.cdklabs.projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `pythonExec`<sup>Optional</sup> <a name="pythonExec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonExec"></a>

```java
public java.lang.String getPythonExec();
```

- *Type:* java.lang.String
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.sample"></a>

```java
public java.lang.Boolean getSample();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.setuptools"></a>

```java
public java.lang.Boolean getSetuptools();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venv"></a>

```java
public java.lang.Boolean getVenv();
```

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.venvOptions"></a>

```java
public VenvOptions getVenvOptions();
```

- *Type:* io.github.cdklabs.projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.serviceName"></a>

```java
public SmithyServiceName getServiceName();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreGradleWrapper"></a>

```java
public java.lang.Boolean getIgnoreGradleWrapper();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.ignoreSmithyBuildOutput"></a>

```java
public java.lang.Boolean getIgnoreSmithyBuildOutput();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.modelDir"></a>

```java
public java.lang.String getModelDir();
```

- *Type:* java.lang.String
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProjectOptions.property.smithyBuildOptions"></a>

```java
public SmithyBuildOptions getSmithyBuildOptions();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyApiGatewayTsProjectOptions <a name="SmithyApiGatewayTsProjectOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions"></a>

Configuration for the SmithyApiGatewayTsProject.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyApiGatewayTsProjectOptions;

SmithyApiGatewayTsProjectOptions.builder()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .workflowPackageCache(java.lang.Boolean)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .serviceName(SmithyServiceName)
//  .ignoreGradleWrapper(java.lang.Boolean)
//  .ignoreSmithyBuildOutput(java.lang.Boolean)
//  .modelDir(java.lang.String)
//  .smithyBuildOptions(SmithyBuildOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowPackageCache">workflowPackageCache</a></code> | <code>java.lang.Boolean</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.modelDir">modelDir</a></code> | <code>java.lang.String</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.commitGenerated"></a>

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitIgnoreOptions"></a>

```java
public IgnoreFileOptions getGitIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitOptions"></a>

```java
public GitOptions getGitOptions();
```

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.logging"></a>

```java
public LoggerOptions getLogging();
```

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parent"></a>

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCommand"></a>

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJson"></a>

```java
public java.lang.Boolean getProjenrcJson();
```

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsonOptions"></a>

```java
public ProjenrcJsonOptions getProjenrcJsonOptions();
```

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebot"></a>

```java
public java.lang.Boolean getRenovatebot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.renovatebotOptions"></a>

```java
public RenovatebotOptions getRenovatebotOptions();
```

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveOptions"></a>

```java
public AutoApproveOptions getAutoApproveOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMerge"></a>

```java
public java.lang.Boolean getAutoMerge();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoMergeOptions"></a>

```java
public AutoMergeOptions getAutoMergeOptions();
```

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clobber"></a>

```java
public java.lang.Boolean getClobber();
```

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devContainer"></a>

```java
public java.lang.Boolean getDevContainer();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.github"></a>

```java
public java.lang.Boolean getGithub();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.githubOptions"></a>

```java
public GitHubOptions getGithubOptions();
```

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitpod"></a>

```java
public java.lang.Boolean getGitpod();
```

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

```java
public java.lang.Boolean getMergify();
```

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

```java
public MergifyOptions getMergifyOptions();
```

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projectType"></a>

- *Deprecated:* no longer supported at the base project level

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenCredentials"></a>

```java
public GithubCredentials getProjenCredentials();
```

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

```java
public java.lang.String getProjenTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.readme"></a>

```java
public SampleReadmeProps getReadme();
```

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stale"></a>

```java
public java.lang.Boolean getStale();
```

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.staleOptions"></a>

```java
public StaleOptions getStaleOptions();
```

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.vscode"></a>

```java
public java.lang.Boolean getVscode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.allowLibraryDependencies"></a>

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorEmail"></a>

```java
public java.lang.String getAuthorEmail();
```

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorName"></a>

```java
public java.lang.String getAuthorName();
```

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorOrganization"></a>

```java
public java.lang.Boolean getAuthorOrganization();
```

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.authorUrl"></a>

```java
public java.lang.String getAuthorUrl();
```

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoDetectBin"></a>

```java
public java.lang.Boolean getAutoDetectBin();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bin"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getBin();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsEmail"></a>

```java
public java.lang.String getBugsEmail();
```

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bugsUrl"></a>

```java
public java.lang.String getBugsUrl();
```

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundledDeps"></a>

```java
public java.util.List<java.lang.String> getBundledDeps();
```

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeArtifactOptions"></a>

```java
public CodeArtifactOptions getCodeArtifactOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.deps"></a>

```java
public java.util.List<java.lang.String> getDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.devDeps"></a>

```java
public java.util.List<java.lang.String> getDevDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypoint"></a>

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.homepage"></a>

```java
public java.lang.String getHomepage();
```

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.keywords"></a>

```java
public java.util.List<java.lang.String> getKeywords();
```

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.license"></a>

```java
public java.lang.String getLicense();
```

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.licensed"></a>

```java
public java.lang.Boolean getLicensed();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.maxNodeVersion"></a>

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minNodeVersion"></a>

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmAccess"></a>

```java
public NpmAccess getNpmAccess();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

```java
public java.lang.String getNpmRegistry();
```

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmRegistryUrl"></a>

```java
public java.lang.String getNpmRegistryUrl();
```

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmTokenSecret"></a>

```java
public java.lang.String getNpmTokenSecret();
```

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageManager"></a>

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.packageName"></a>

```java
public java.lang.String getPackageName();
```

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDependencyOptions"></a>

```java
public PeerDependencyOptions getPeerDependencyOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.peerDeps"></a>

```java
public java.util.List<java.lang.String> getPeerDeps();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pnpmVersion"></a>

```java
public java.lang.String getPnpmVersion();
```

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repository"></a>

```java
public java.lang.String getRepository();
```

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.repositoryDirectory"></a>

```java
public java.lang.String getRepositoryDirectory();
```

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scopedPackagesOptions"></a>

```java
public java.util.List<ScopedPackagesOptions> getScopedPackagesOptions();
```

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

```java
public java.util.Map<java.lang.String, java.lang.String> getScripts();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.stability"></a>

```java
public java.lang.String getStability();
```

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jsiiReleaseVersion"></a>

```java
public java.lang.String getJsiiReleaseVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.majorVersion"></a>

```java
public java.lang.Number getMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.minMajorVersion"></a>

```java
public java.lang.Number getMinMajorVersion();
```

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmDistTag"></a>

```java
public java.lang.String getNpmDistTag();
```

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.postBuildSteps"></a>

```java
public java.util.List<JobStep> getPostBuildSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prerelease"></a>

```java
public java.lang.String getPrerelease();
```

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishDryRun"></a>

```java
public java.lang.Boolean getPublishDryRun();
```

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.publishTasks"></a>

```java
public java.lang.Boolean getPublishTasks();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseBranches"></a>

```java
public java.util.Map<java.lang.String, BranchOptions> getReleaseBranches();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

```java
public java.lang.Boolean getReleaseEveryCommit();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssue"></a>

```java
public java.lang.Boolean getReleaseFailureIssue();
```

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseFailureIssueLabel"></a>

```java
public java.lang.String getReleaseFailureIssueLabel();
```

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

```java
public java.lang.String getReleaseSchedule();
```

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTagPrefix"></a>

```java
public java.lang.String getReleaseTagPrefix();
```

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseTrigger"></a>

```java
public ReleaseTrigger getReleaseTrigger();
```

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowName"></a>

```java
public java.lang.String getReleaseWorkflowName();
```

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflowSetupSteps"></a>

```java
public java.util.List<JobStep> getReleaseWorkflowSetupSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.versionrcOptions"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getVersionrcOptions();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowContainerImage"></a>

```java
public java.lang.String getWorkflowContainerImage();
```

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowRunsOn"></a>

```java
public java.util.List<java.lang.String> getWorkflowRunsOn();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.defaultReleaseBranch"></a>

```java
public java.lang.String getDefaultReleaseBranch();
```

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.artifactsDirectory"></a>

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.autoApproveUpgrades"></a>

```java
public java.lang.Boolean getAutoApproveUpgrades();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflow"></a>

```java
public java.lang.Boolean getBuildWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.buildWorkflowTriggers"></a>

```java
public Triggers getBuildWorkflowTriggers();
```

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.bundlerOptions"></a>

```java
public BundlerOptions getBundlerOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCov"></a>

```java
public java.lang.Boolean getCodeCov();
```

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.codeCovTokenSecret"></a>

```java
public java.lang.String getCodeCovTokenSecret();
```

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightOwner"></a>

```java
public java.lang.String getCopyrightOwner();
```

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.copyrightPeriod"></a>

```java
public java.lang.String getCopyrightPeriod();
```

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabot"></a>

```java
public java.lang.Boolean getDependabot();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.dependabotOptions"></a>

```java
public DependabotOptions getDependabotOptions();
```

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgrade"></a>

```java
public java.lang.Boolean getDepsUpgrade();
```

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.depsUpgradeOptions"></a>

```java
public UpgradeDependenciesOptions getDepsUpgradeOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.gitignore"></a>

```java
public java.util.List<java.lang.String> getGitignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jest"></a>

```java
public java.lang.Boolean getJest();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.jestOptions"></a>

```java
public JestOptions getJestOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.mutableBuild"></a>

```java
public java.lang.Boolean getMutableBuild();
```

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

```java
public java.util.List<java.lang.String> getNpmignore();
```

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmignoreEnabled"></a>

```java
public java.lang.Boolean getNpmignoreEnabled();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.npmIgnoreOptions"></a>

```java
public IgnoreFileOptions getNpmIgnoreOptions();
```

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.package"></a>

```java
public java.lang.Boolean getPackage();
```

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettier"></a>

```java
public java.lang.Boolean getPrettier();
```

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.prettierOptions"></a>

```java
public PrettierOptions getPrettierOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenDevDependency"></a>

```java
public java.lang.Boolean getProjenDevDependency();
```

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJs"></a>

```java
public java.lang.Boolean getProjenrcJs();
```

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcJsOptions"></a>

```java
public ProjenrcOptions getProjenrcJsOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenVersion"></a>

```java
public java.lang.String getProjenVersion();
```

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplate"></a>

```java
public java.lang.Boolean getPullRequestTemplate();
```

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pullRequestTemplateContents"></a>

```java
public java.util.List<java.lang.String> getPullRequestTemplateContents();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.release"></a>

```java
public java.lang.Boolean getRelease();
```

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseToNpm"></a>

```java
public java.lang.Boolean getReleaseToNpm();
```

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.releaseWorkflow"></a>

- *Deprecated:* see `release`.

```java
public java.lang.Boolean getReleaseWorkflow();
```

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowBootstrapSteps"></a>

```java
public java.util.List<JobStep> getWorkflowBootstrapSteps();
```

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowGitIdentity"></a>

```java
public GitIdentity getWorkflowGitIdentity();
```

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowNodeVersion"></a>

```java
public java.lang.String getWorkflowNodeVersion();
```

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflowPackageCache`<sup>Optional</sup> <a name="workflowPackageCache" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.workflowPackageCache"></a>

```java
public java.lang.Boolean getWorkflowPackageCache();
```

- *Type:* java.lang.Boolean
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfig"></a>

```java
public java.lang.Boolean getDisableTsconfig();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.disableTsconfigDev"></a>

```java
public java.lang.Boolean getDisableTsconfigDev();
```

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docgen"></a>

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.docsDirectory"></a>

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.entrypointTypes"></a>

```java
public java.lang.String getEntrypointTypes();
```

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslint"></a>

```java
public java.lang.Boolean getEslint();
```

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.eslintOptions"></a>

```java
public EslintOptions getEslintOptions();
```

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.libdir"></a>

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTs"></a>

```java
public java.lang.Boolean getProjenrcTs();
```

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.projenrcTsOptions"></a>

```java
public ProjenrcOptions getProjenrcTsOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.sampleCode"></a>

```java
public java.lang.Boolean getSampleCode();
```

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.srcdir"></a>

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.testdir"></a>

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfig"></a>

```java
public TypescriptConfigOptions getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDev"></a>

```java
public TypescriptConfigOptions getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.tsconfigDevFile"></a>

```java
public java.lang.String getTsconfigDevFile();
```

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptVersion"></a>

```java
public java.lang.String getTypescriptVersion();
```

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.clientLanguages"></a>

```java
public java.util.List<ClientLanguage> getClientLanguages();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.apiSrcDir"></a>

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.documentationFormats"></a>

```java
public java.util.List<DocumentationFormat> getDocumentationFormats();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.forceGenerateCodeAndDocs"></a>

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.generatedCodeDir"></a>

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.javaClientOptions"></a>

```java
public JavaProjectOptions getJavaClientOptions();
```

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.parsedSpecFileName"></a>

```java
public java.lang.String getParsedSpecFileName();
```

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.pythonClientOptions"></a>

```java
public PythonProjectOptions getPythonClientOptions();
```

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.typescriptClientOptions"></a>

```java
public TypeScriptProjectOptions getTypescriptClientOptions();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.serviceName"></a>

```java
public SmithyServiceName getServiceName();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreGradleWrapper"></a>

```java
public java.lang.Boolean getIgnoreGradleWrapper();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.ignoreSmithyBuildOutput"></a>

```java
public java.lang.Boolean getIgnoreSmithyBuildOutput();
```

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.modelDir"></a>

```java
public java.lang.String getModelDir();
```

- *Type:* java.lang.String
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProjectOptions.property.smithyBuildOptions"></a>

```java
public SmithyBuildOptions getSmithyBuildOptions();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

### SmithyBuildOptions <a name="SmithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions"></a>

Options for the smithy build files.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyBuildOptions;

SmithyBuildOptions.builder()
//  .imports(java.util.List<java.lang.String>)
//  .plugins(java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)
//  .ignoreMissingPlugins(java.lang.Boolean)
//  .maven(SmithyMavenConfiguration)
//  .projections(java.util.Map<java.lang.String, SmithyProjection>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.imports">imports</a></code> | <code>java.util.List<java.lang.String></code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.plugins">plugins</a></code> | <code>java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>></code> | Plugins keyed by plugin id. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.ignoreMissingPlugins">ignoreMissingPlugins</a></code> | <code>java.lang.Boolean</code> | If a plugin can't be found, Smithy will by default fail the build. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.maven">maven</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration">SmithyMavenConfiguration</a></code> | Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.projections">projections</a></code> | <code>java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection">SmithyProjection</a>></code> | Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.imports"></a>

```java
public java.util.List<java.lang.String> getImports();
```

- *Type:* java.util.List<java.lang.String>

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.plugins"></a>

```java
public java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getPlugins();
```

- *Type:* java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>

Plugins keyed by plugin id.

---

##### `ignoreMissingPlugins`<sup>Optional</sup> <a name="ignoreMissingPlugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.ignoreMissingPlugins"></a>

```java
public java.lang.Boolean getIgnoreMissingPlugins();
```

- *Type:* java.lang.Boolean
- *Default:* no ignoreMissingPlugins set in the smithy-build.json file

If a plugin can't be found, Smithy will by default fail the build.

This setting can be set to true to allow the build to progress
even if a plugin can't be found on the classpath.

---

##### `maven`<sup>Optional</sup> <a name="maven" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.maven"></a>

```java
public SmithyMavenConfiguration getMaven();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration">SmithyMavenConfiguration</a>
- *Default:* the default configuration required for Smithy to OpenAPI conversion

Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files.

---

##### `projections`<sup>Optional</sup> <a name="projections" id="@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions.property.projections"></a>

```java
public java.util.Map<java.lang.String, SmithyProjection> getProjections();
```

- *Type:* java.util.Map<java.lang.String, <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection">SmithyProjection</a>>
- *Default:* no projections

Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections.

---

### SmithyCommon <a name="SmithyCommon" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon"></a>

Properties common to smithy plugins and the root smithy build.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyCommon;

SmithyCommon.builder()
//  .imports(java.util.List<java.lang.String>)
//  .plugins(java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.imports">imports</a></code> | <code>java.util.List<java.lang.String></code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.plugins">plugins</a></code> | <code>java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>></code> | Plugins keyed by plugin id. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.imports"></a>

```java
public java.util.List<java.lang.String> getImports();
```

- *Type:* java.util.List<java.lang.String>

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyCommon.property.plugins"></a>

```java
public java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getPlugins();
```

- *Type:* java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>

Plugins keyed by plugin id.

---

### SmithyMavenConfiguration <a name="SmithyMavenConfiguration" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration"></a>

Configuration for smithy maven dependencies.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyMavenConfiguration;

SmithyMavenConfiguration.builder()
//  .dependencies(java.util.List<java.lang.String>)
//  .repositoryUrls(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.dependencies">dependencies</a></code> | <code>java.util.List<java.lang.String></code> | The dependencies used in the build.gradle and smithy-build.json files eg. software.amazon.smithy:smithy-validation-model:1.27.2 The following required dependencies are always added: - software.amazon.smithy:smithy-cli:1.27.2 - software.amazon.smithy:smithy-model:1.27.2 - software.amazon.smithy:smithy-openapi:1.27.2 - software.amazon.smithy:smithy-aws-traits:1.27.2 You can however override the version of these dependencies if required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.repositoryUrls">repositoryUrls</a></code> | <code>java.util.List<java.lang.String></code> | The repository urls used in the build.gradle and smithy-build.json files. |

---

##### `dependencies`<sup>Optional</sup> <a name="dependencies" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.dependencies"></a>

```java
public java.util.List<java.lang.String> getDependencies();
```

- *Type:* java.util.List<java.lang.String>

The dependencies used in the build.gradle and smithy-build.json files eg. software.amazon.smithy:smithy-validation-model:1.27.2 The following required dependencies are always added: - software.amazon.smithy:smithy-cli:1.27.2 - software.amazon.smithy:smithy-model:1.27.2 - software.amazon.smithy:smithy-openapi:1.27.2 - software.amazon.smithy:smithy-aws-traits:1.27.2 You can however override the version of these dependencies if required.

---

##### `repositoryUrls`<sup>Optional</sup> <a name="repositoryUrls" id="@aws-prototyping-sdk/open-api-gateway.SmithyMavenConfiguration.property.repositoryUrls"></a>

```java
public java.util.List<java.lang.String> getRepositoryUrls();
```

- *Type:* java.util.List<java.lang.String>
- *Default:* maven central and maven local

The repository urls used in the build.gradle and smithy-build.json files.

---

### SmithyProjection <a name="SmithyProjection" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection"></a>

A smithy build projection.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyProjection;

SmithyProjection.builder()
//  .imports(java.util.List<java.lang.String>)
//  .plugins(java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)
//  .abstract(java.lang.Boolean)
//  .transforms(java.util.List<SmithyTransform>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.imports">imports</a></code> | <code>java.util.List<java.lang.String></code> | List of imports. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.plugins">plugins</a></code> | <code>java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>></code> | Plugins keyed by plugin id. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.abstract">abstract</a></code> | <code>java.lang.Boolean</code> | Whether or not the projection is abstract. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.transforms">transforms</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform">SmithyTransform</a>></code> | Transforms to apply to the projection. |

---

##### `imports`<sup>Optional</sup> <a name="imports" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.imports"></a>

```java
public java.util.List<java.lang.String> getImports();
```

- *Type:* java.util.List<java.lang.String>

List of imports.

---

##### `plugins`<sup>Optional</sup> <a name="plugins" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.plugins"></a>

```java
public java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getPlugins();
```

- *Type:* java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>

Plugins keyed by plugin id.

---

##### `abstract`<sup>Optional</sup> <a name="abstract" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.abstract"></a>

```java
public java.lang.Boolean getAbstract();
```

- *Type:* java.lang.Boolean

Whether or not the projection is abstract.

---

##### `transforms`<sup>Optional</sup> <a name="transforms" id="@aws-prototyping-sdk/open-api-gateway.SmithyProjection.property.transforms"></a>

```java
public java.util.List<SmithyTransform> getTransforms();
```

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform">SmithyTransform</a>>

Transforms to apply to the projection.

---

### SmithyServiceName <a name="SmithyServiceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName"></a>

Represents a fully qualified name of a Smithy service.

> [https://awslabs.github.io/smithy/2.0/spec/service-types.html](https://awslabs.github.io/smithy/2.0/spec/service-types.html)

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyServiceName;

SmithyServiceName.builder()
    .namespace(java.lang.String)
    .serviceName(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.namespace">namespace</a></code> | <code>java.lang.String</code> | The service namespace. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.serviceName">serviceName</a></code> | <code>java.lang.String</code> | The service name. |

---

##### `namespace`<sup>Required</sup> <a name="namespace" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.namespace"></a>

```java
public java.lang.String getNamespace();
```

- *Type:* java.lang.String

The service namespace.

Nested namespaces are separated by '.', for example com.company

> [https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id](https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id)

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyServiceName.property.serviceName"></a>

```java
public java.lang.String getServiceName();
```

- *Type:* java.lang.String

The service name.

Should be PascalCase, for example HelloService

> [https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id](https://awslabs.github.io/smithy/2.0/spec/model.html#shape-id)

---

### SmithyTransform <a name="SmithyTransform" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform"></a>

A smithy build transform.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyTransform;

SmithyTransform.builder()
    .args(java.util.Map<java.lang.String, java.lang.Object>)
    .name(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.args">args</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Arguments for the transform. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.name">name</a></code> | <code>java.lang.String</code> | Name of the transform. |

---

##### `args`<sup>Required</sup> <a name="args" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.args"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getArgs();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Arguments for the transform.

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyTransform.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Name of the transform.

---

## Classes <a name="Classes" id="Classes"></a>

### Authorizer <a name="Authorizer" id="@aws-prototyping-sdk/open-api-gateway.Authorizer"></a>

An authorizer for authorizing API requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Authorizer;

Authorizer.Builder.create()
    .authorizationType(AuthorizationType)
    .authorizerId(java.lang.String)
//  .authorizationScopes(java.util.List<java.lang.String>)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationType"></a>

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizerId"></a>

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.Initializer.parameter.authorizationScopes"></a>

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationType"></a>

```java
public AuthorizationType getAuthorizationType();
```

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.Authorizer.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---


### Authorizers <a name="Authorizers" id="@aws-prototyping-sdk/open-api-gateway.Authorizers"></a>

Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Authorizers;

new Authorizers();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito">cognito</a></code> | A Cognito User Pools authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.custom">custom</a></code> | A custom authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.iam">iam</a></code> | An IAM authorizer which uses AWS signature version 4 to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Authorizers.none">none</a></code> | No authorizer. |

---

##### `cognito` <a name="cognito" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Authorizers;

Authorizers.cognito(CognitoAuthorizerProps props)
```

A Cognito User Pools authorizer.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.cognito.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizerProps">CognitoAuthorizerProps</a>

---

##### `custom` <a name="custom" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Authorizers;

Authorizers.custom(CustomAuthorizerProps props)
```

A custom authorizer.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.custom.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerProps">CustomAuthorizerProps</a>

---

##### `iam` <a name="iam" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.iam"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Authorizers;

Authorizers.iam()
```

An IAM authorizer which uses AWS signature version 4 to authorize requests.

##### `none` <a name="none" id="@aws-prototyping-sdk/open-api-gateway.Authorizers.none"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Authorizers;

Authorizers.none()
```

No authorizer.



### CognitoAuthorizer <a name="CognitoAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer"></a>

An authorizer that uses Cognito identity or access tokens.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.CognitoAuthorizer;

CognitoAuthorizer.Builder.create()
    .authorizerId(java.lang.String)
    .userPools(java.util.List<IUserPool>)
//  .authorizationScopes(java.util.List<java.lang.String>)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.userPools">userPools</a></code> | <code>java.util.List<software.amazon.awscdk.services.cognito.IUserPool></code> | The Cognito user pools associated with this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | A list of authorization scopes configured on the method. |

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizerId"></a>

- *Type:* java.lang.String

Unique identifier for this authorizer.

---

##### `userPools`<sup>Required</sup> <a name="userPools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.userPools"></a>

- *Type:* java.util.List<software.amazon.awscdk.services.cognito.IUserPool>

The Cognito user pools associated with this authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.Initializer.parameter.authorizationScopes"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

A list of authorization scopes configured on the method.

When used as the default authorizer, these scopes will be
applied to all methods without an authorizer at the integration level.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes">withScopes</a></code> | Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis. |

---

##### `withScopes` <a name="withScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes"></a>

```java
public CognitoAuthorizer withScopes(java.lang.String authorizationScopes)
```

Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes)

###### `authorizationScopes`<sup>Required</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.withScopes.parameter.authorizationScopes"></a>

- *Type:* java.lang.String

the scopes to apply.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.userPools">userPools</a></code> | <code>java.util.List<software.amazon.awscdk.services.cognito.IUserPool></code> | The Cognito user pools associated with this authorizer. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationType"></a>

```java
public AuthorizationType getAuthorizationType();
```

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---

##### `userPools`<sup>Required</sup> <a name="userPools" id="@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer.property.userPools"></a>

```java
public java.util.List<IUserPool> getUserPools();
```

- *Type:* java.util.List<software.amazon.awscdk.services.cognito.IUserPool>

The Cognito user pools associated with this authorizer.

---


### CustomAuthorizer <a name="CustomAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer"></a>

An authorizer that uses a lambda function to authorize requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.CustomAuthorizer;

CustomAuthorizer.Builder.create()
    .authorizerId(java.lang.String)
    .function(IFunction)
//  .authorizerResultTtlInSeconds(java.lang.Number)
//  .identitySource(java.lang.String)
//  .type(CustomAuthorizerType)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | Unique identifier for this authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.function">function</a></code> | <code>software.amazon.awscdk.services.lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerResultTtlInSeconds">authorizerResultTtlInSeconds</a></code> | <code>java.lang.Number</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.identitySource">identitySource</a></code> | <code>java.lang.String</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerId"></a>

- *Type:* java.lang.String

Unique identifier for this authorizer.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.function"></a>

- *Type:* software.amazon.awscdk.services.lambda.IFunction

The lambda function used to authorize requests.

---

##### `authorizerResultTtlInSeconds`<sup>Optional</sup> <a name="authorizerResultTtlInSeconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.authorizerResultTtlInSeconds"></a>

- *Type:* java.lang.Number
- *Default:* 300

The number of seconds during which the authorizer result is cached.

---

##### `identitySource`<sup>Optional</sup> <a name="identitySource" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.identitySource"></a>

- *Type:* java.lang.String
- *Default:* "method.request.header.Authorization"

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Optional</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.Initializer.parameter.type"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>
- *Default:* CustomAuthorizerType.TOKEN

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerResultTtlInSeconds">authorizerResultTtlInSeconds</a></code> | <code>java.lang.Number</code> | The number of seconds during which the authorizer result is cached. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.function">function</a></code> | <code>software.amazon.awscdk.services.lambda.IFunction</code> | The lambda function used to authorize requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.identitySource">identitySource</a></code> | <code>java.lang.String</code> | The source of the identity in an incoming request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.type">type</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a></code> | The type of custom authorizer. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationType"></a>

```java
public AuthorizationType getAuthorizationType();
```

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---

##### `authorizerResultTtlInSeconds`<sup>Required</sup> <a name="authorizerResultTtlInSeconds" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.authorizerResultTtlInSeconds"></a>

```java
public java.lang.Number getAuthorizerResultTtlInSeconds();
```

- *Type:* java.lang.Number

The number of seconds during which the authorizer result is cached.

---

##### `function`<sup>Required</sup> <a name="function" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.function"></a>

```java
public IFunction getFunction();
```

- *Type:* software.amazon.awscdk.services.lambda.IFunction

The lambda function used to authorize requests.

---

##### `identitySource`<sup>Required</sup> <a name="identitySource" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.identitySource"></a>

```java
public java.lang.String getIdentitySource();
```

- *Type:* java.lang.String

The source of the identity in an incoming request.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-identitysource)

---

##### `type`<sup>Required</sup> <a name="type" id="@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer.property.type"></a>

```java
public CustomAuthorizerType getType();
```

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.CustomAuthorizerType">CustomAuthorizerType</a>

The type of custom authorizer.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type)

---


### IamAuthorizer <a name="IamAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer"></a>

An IAM authorizer.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.IamAuthorizer;

new IamAuthorizer();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationType"></a>

```java
public AuthorizationType getAuthorizationType();
```

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.IamAuthorizer.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---


### Integration <a name="Integration" id="@aws-prototyping-sdk/open-api-gateway.Integration"></a>

An integration for an API operation.

You can extend this to implement your own integration if you like.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Integration.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Integration;

new Integration();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration.grant">grant</a></code> | Grant permissions for the API to invoke the integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integration.render">render</a></code> | Render the integration into an API Gateway OpenAPI extension. |

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant"></a>

```java
public void grant(IntegrationGrantProps _props)
```

Grant permissions for the API to invoke the integration.

###### `_props`<sup>Required</sup> <a name="_props" id="@aws-prototyping-sdk/open-api-gateway.Integration.grant.parameter._props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps">IntegrationGrantProps</a>

---

##### `render` <a name="render" id="@aws-prototyping-sdk/open-api-gateway.Integration.render"></a>

```java
public ApiGatewayIntegration render(IntegrationRenderProps props)
```

Render the integration into an API Gateway OpenAPI extension.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.Integration.render.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps">IntegrationRenderProps</a>

---




### Integrations <a name="Integrations" id="@aws-prototyping-sdk/open-api-gateway.Integrations"></a>

A collection of integrations to connect API operations with a backend to service requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.Integrations.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Integrations;

new Integrations();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.Integrations.lambda">lambda</a></code> | An integration that invokes a lambda function to service the request. |

---

##### `lambda` <a name="lambda" id="@aws-prototyping-sdk/open-api-gateway.Integrations.lambda"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.Integrations;

Integrations.lambda(IFunction lambdaFunction)
```

An integration that invokes a lambda function to service the request.

###### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="@aws-prototyping-sdk/open-api-gateway.Integrations.lambda.parameter.lambdaFunction"></a>

- *Type:* software.amazon.awscdk.services.lambda.IFunction

the function to invoke.

---



### LambdaIntegration <a name="LambdaIntegration" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration"></a>

A lambda integration.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.LambdaIntegration;

new LambdaIntegration(IFunction lambdaFunction);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer.parameter.lambdaFunction">lambdaFunction</a></code> | <code>software.amazon.awscdk.services.lambda.IFunction</code> | *No description.* |

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.Initializer.parameter.lambdaFunction"></a>

- *Type:* software.amazon.awscdk.services.lambda.IFunction

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant">grant</a></code> | Grant API Gateway permissions to invoke the lambda. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render">render</a></code> | Render the lambda integration as a snippet of OpenAPI. |

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant"></a>

```java
public void grant(IntegrationGrantProps __0)
```

Grant API Gateway permissions to invoke the lambda.

###### `__0`<sup>Required</sup> <a name="__0" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.grant.parameter.__0"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationGrantProps">IntegrationGrantProps</a>

---

##### `render` <a name="render" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render"></a>

```java
public ApiGatewayIntegration render(IntegrationRenderProps props)
```

Render the lambda integration as a snippet of OpenAPI.

###### `props`<sup>Required</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.LambdaIntegration.render.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.IntegrationRenderProps">IntegrationRenderProps</a>

---




### NoneAuthorizer <a name="NoneAuthorizer" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer"></a>

No authorizer.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.NoneAuthorizer;

new NoneAuthorizer();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---



#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationType">authorizationType</a></code> | <code>software.amazon.awscdk.services.apigateway.AuthorizationType</code> | The type of the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizerId">authorizerId</a></code> | <code>java.lang.String</code> | The unique identifier for the authorizer. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationScopes">authorizationScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes for the authorizer, if any. |

---

##### `authorizationType`<sup>Required</sup> <a name="authorizationType" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationType"></a>

```java
public AuthorizationType getAuthorizationType();
```

- *Type:* software.amazon.awscdk.services.apigateway.AuthorizationType

The type of the authorizer.

---

##### `authorizerId`<sup>Required</sup> <a name="authorizerId" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizerId"></a>

```java
public java.lang.String getAuthorizerId();
```

- *Type:* java.lang.String

The unique identifier for the authorizer.

---

##### `authorizationScopes`<sup>Optional</sup> <a name="authorizationScopes" id="@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer.property.authorizationScopes"></a>

```java
public java.util.List<java.lang.String> getAuthorizationScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes for the authorizer, if any.

---


### OpenApiGatewayJavaProject <a name="OpenApiGatewayJavaProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject"></a>

Synthesizes a Java Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayJavaProject;

OpenApiGatewayJavaProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .artifactId(java.lang.String)
    .groupId(java.lang.String)
    .version(java.lang.String)
//  .description(java.lang.String)
//  .packaging(java.lang.String)
//  .url(java.lang.String)
//  .compileOptions(MavenCompileOptions)
//  .deps(java.util.List<java.lang.String>)
//  .distdir(java.lang.String)
//  .junit(java.lang.Boolean)
//  .junitOptions(JunitOptions)
//  .packagingOptions(MavenPackagingOptions)
//  .projenrcJava(java.lang.Boolean)
//  .projenrcJavaOptions(ProjenrcOptions)
//  .testDeps(java.util.List<java.lang.String>)
//  .sample(java.lang.Boolean)
//  .sampleJavaPackage(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.artifactId">artifactId</a></code> | <code>java.lang.String</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.groupId">groupId</a></code> | <code>java.lang.String</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.version">version</a></code> | <code>java.lang.String</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packaging">packaging</a></code> | <code>java.lang.String</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.url">url</a></code> | <code>java.lang.String</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.compileOptions">compileOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.distdir">distdir</a></code> | <code>java.lang.String</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junit">junit</a></code> | <code>java.lang.Boolean</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junitOptions">junitOptions</a></code> | <code>io.github.cdklabs.projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packagingOptions">packagingOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJava">projenrcJava</a></code> | <code>java.lang.Boolean</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>io.github.cdklabs.projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.testDeps">testDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage">sampleJavaPackage</a></code> | <code>java.lang.String</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.artifactId"></a>

- *Type:* java.lang.String
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.groupId"></a>

- *Type:* java.lang.String
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.version"></a>

- *Type:* java.lang.String
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packaging"></a>

- *Type:* java.lang.String
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.url"></a>

- *Type:* java.lang.String
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.compileOptions"></a>

- *Type:* io.github.cdklabs.projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.distdir"></a>

- *Type:* java.lang.String
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junit"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.junitOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.packagingOptions"></a>

- *Type:* io.github.cdklabs.projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJava"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions"></a>

- *Type:* io.github.cdklabs.projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.testDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sample"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage"></a>

- *Type:* java.lang.String
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.clientLanguages"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.documentationFormats"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.Initializer.parameter.specFile"></a>

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin">addPlugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency">addTestDependency</a></code> | Adds a test dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String _pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* java.lang.String

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency"></a>

```java
public void addDependency(java.lang.String spec)
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`addPlugin`~~ <a name="addPlugin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin"></a>

```java
public Dependency addPlugin(java.lang.String spec)
public Dependency addPlugin(java.lang.String spec, PluginOptions options)
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.spec"></a>

- *Type:* java.lang.String

dependency spec (`group/artifact@version`).

---

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addPlugin.parameter.options"></a>

- *Type:* io.github.cdklabs.projen.java.PluginOptions

plugin options.

---

##### ~~`addTestDependency`~~ <a name="addTestDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency"></a>

```java
public void addTestDependency(java.lang.String spec)
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<groupId>/<artifactId>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.subprojects">subprojects</a></code> | <code>java.util.List<io.github.cdklabs.projen.Project></code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compile">compile</a></code> | <code>io.github.cdklabs.projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.distdir">distdir</a></code> | <code>java.lang.String</code> | Maven artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packaging">packaging</a></code> | <code>io.github.cdklabs.projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.pom">pom</a></code> | <code>io.github.cdklabs.projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.junit">junit</a></code> | <code>io.github.cdklabs.projen.java.Junit</code> | JUnit component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenrc">projenrc</a></code> | <code>io.github.cdklabs.projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedClients">generatedClients</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.Project></code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedJavaClient">generatedJavaClient</a></code> | <code>io.github.cdklabs.projen.java.JavaProject</code> | A reference to the generated java client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specDir">specDir</a></code> | <code>java.lang.String</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specFileName">specFileName</a></code> | <code>java.lang.String</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Project> getSubprojects();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Project>

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`compile`~~<sup>Required</sup> <a name="compile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.compile"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public MavenCompile getCompile();
```

- *Type:* io.github.cdklabs.projen.java.MavenCompile

Compile component.

---

##### ~~`distdir`~~<sup>Required</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.distdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDistdir();
```

- *Type:* java.lang.String

Maven artifact output directory.

---

##### ~~`packaging`~~<sup>Required</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.packaging"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public MavenPackaging getPackaging();
```

- *Type:* io.github.cdklabs.projen.java.MavenPackaging

Packaging component.

---

##### ~~`pom`~~<sup>Required</sup> <a name="pom" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.pom"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Pom getPom();
```

- *Type:* io.github.cdklabs.projen.java.Pom

API for managing `pom.xml`.

---

##### ~~`junit`~~<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.junit"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Junit getJunit();
```

- *Type:* io.github.cdklabs.projen.java.Junit

JUnit component.

---

##### ~~`projenrc`~~<sup>Optional</sup> <a name="projenrc" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.projenrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Projenrc getProjenrc();
```

- *Type:* io.github.cdklabs.projen.java.Projenrc

Projenrc component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

This will also be used
as the package for the api project.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.Map<java.lang.String, Project> getGeneratedClients();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.Project>

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedJavaClient`~~<sup>Required</sup> <a name="generatedJavaClient" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.generatedJavaClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public JavaProject getGeneratedJavaClient();
```

- *Type:* io.github.cdklabs.projen.java.JavaProject

A reference to the generated java client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecDir();
```

- *Type:* java.lang.String

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecFileName();
```

- *Type:* java.lang.String

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayJavaProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### OpenApiGatewayPythonProject <a name="OpenApiGatewayPythonProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject"></a>

Synthesizes a Python Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayPythonProject;

OpenApiGatewayPythonProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .authorEmail(java.lang.String)
    .authorName(java.lang.String)
    .version(java.lang.String)
//  .classifiers(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .homepage(java.lang.String)
//  .license(java.lang.String)
//  .packageName(java.lang.String)
//  .poetryOptions(PoetryPyprojectOptionsWithoutDeps)
//  .setupConfig(java.util.Map<java.lang.String, java.lang.Object>)
    .moduleName(java.lang.String)
//  .deps(java.util.List<java.lang.String>)
//  .devDeps(java.util.List<java.lang.String>)
//  .pip(java.lang.Boolean)
//  .poetry(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenrcPython(java.lang.Boolean)
//  .projenrcPythonOptions(ProjenrcOptions)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcTsOptions)
//  .pytest(java.lang.Boolean)
//  .pytestOptions(PytestOptions)
//  .pythonExec(java.lang.String)
//  .sample(java.lang.Boolean)
//  .setuptools(java.lang.Boolean)
//  .venv(java.lang.Boolean)
//  .venvOptions(VenvOptions)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.version">version</a></code> | <code>java.lang.String</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.classifiers">classifiers</a></code> | <code>java.util.List<java.lang.String></code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.homepage">homepage</a></code> | <code>java.lang.String</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.license">license</a></code> | <code>java.lang.String</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.packageName">packageName</a></code> | <code>java.lang.String</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetryOptions">poetryOptions</a></code> | <code>io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setupConfig">setupConfig</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pip">pip</a></code> | <code>java.lang.Boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetry">poetry</a></code> | <code>java.lang.Boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPython">projenrcPython</a></code> | <code>java.lang.Boolean</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>io.github.cdklabs.projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytest">pytest</a></code> | <code>java.lang.Boolean</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytestOptions">pytestOptions</a></code> | <code>io.github.cdklabs.projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonExec">pythonExec</a></code> | <code>java.lang.String</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setuptools">setuptools</a></code> | <code>java.lang.Boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venv">venv</a></code> | <code>java.lang.Boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venvOptions">venvOptions</a></code> | <code>io.github.cdklabs.projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorEmail"></a>

- *Type:* java.lang.String
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.authorName"></a>

- *Type:* java.lang.String
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.version"></a>

- *Type:* java.lang.String
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.classifiers"></a>

- *Type:* java.util.List<java.lang.String>

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.homepage"></a>

- *Type:* java.lang.String

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.license"></a>

- *Type:* java.lang.String

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.packageName"></a>

- *Type:* java.lang.String

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetryOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setupConfig"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.moduleName"></a>

- *Type:* java.lang.String
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.devDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pip"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.poetry"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPython"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions"></a>

- *Type:* io.github.cdklabs.projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytest"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pytestOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `pythonExec`<sup>Optional</sup> <a name="pythonExec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonExec"></a>

- *Type:* java.lang.String
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.sample"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.setuptools"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venv"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.venvOptions"></a>

- *Type:* io.github.cdklabs.projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.clientLanguages"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.documentationFormats"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.Initializer.parameter.specFile"></a>

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency">addDevDependency</a></code> | Adds a dev dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String _pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* java.lang.String

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency"></a>

```java
public void addDependency(java.lang.String spec)
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<module>@<semver>`.

---

##### ~~`addDevDependency`~~ <a name="addDevDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency"></a>

```java
public void addDevDependency(java.lang.String spec)
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.addDevDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.subprojects">subprojects</a></code> | <code>java.util.List<io.github.cdklabs.projen.Project></code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.depsManager">depsManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.envManager">envManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.version">version</a></code> | <code>java.lang.String</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packagingManager">packagingManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.pytest">pytest</a></code> | <code>io.github.cdklabs.projen.python.Pytest</code> | Pytest component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedClients">generatedClients</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.Project></code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedPythonClient">generatedPythonClient</a></code> | <code>io.github.cdklabs.projen.python.PythonProject</code> | A reference to the generated python client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specDir">specDir</a></code> | <code>java.lang.String</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specFileName">specFileName</a></code> | <code>java.lang.String</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Project> getSubprojects();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Project>

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`depsManager`~~<sup>Required</sup> <a name="depsManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.depsManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IPythonDeps getDepsManager();
```

- *Type:* io.github.cdklabs.projen.python.IPythonDeps

API for managing dependencies.

---

##### ~~`envManager`~~<sup>Required</sup> <a name="envManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.envManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IPythonEnv getEnvManager();
```

- *Type:* io.github.cdklabs.projen.python.IPythonEnv

API for mangaging the Python runtime environment.

---

##### ~~`moduleName`~~<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.moduleName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getModuleName();
```

- *Type:* java.lang.String

Python module name (the project name, with any hyphens or periods replaced with underscores).

---

##### ~~`version`~~<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.version"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String

Version of the package for distribution (should follow semver).

---

##### ~~`packagingManager`~~<sup>Optional</sup> <a name="packagingManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.packagingManager"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IPythonPackaging getPackagingManager();
```

- *Type:* io.github.cdklabs.projen.python.IPythonPackaging

API for managing packaging the project as a library.

Only applies when the `projectType` is LIB.

---

##### ~~`pytest`~~<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.pytest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Pytest getPytest();
```

- *Type:* io.github.cdklabs.projen.python.Pytest

Pytest component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.Map<java.lang.String, Project> getGeneratedClients();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.Project>

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedPythonClient`~~<sup>Required</sup> <a name="generatedPythonClient" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.generatedPythonClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public PythonProject getGeneratedPythonClient();
```

- *Type:* io.github.cdklabs.projen.python.PythonProject

A reference to the generated python client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecDir();
```

- *Type:* java.lang.String

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecFileName();
```

- *Type:* java.lang.String

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayPythonProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### OpenApiGatewayTsProject <a name="OpenApiGatewayTsProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject"></a>

Synthesizes a Typescript Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.OpenApiGatewayTsProject;

OpenApiGatewayTsProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
//  .allowLibraryDependencies(java.lang.Boolean)
//  .authorEmail(java.lang.String)
//  .authorName(java.lang.String)
//  .authorOrganization(java.lang.Boolean)
//  .authorUrl(java.lang.String)
//  .autoDetectBin(java.lang.Boolean)
//  .bin(java.util.Map<java.lang.String, java.lang.String>)
//  .bugsEmail(java.lang.String)
//  .bugsUrl(java.lang.String)
//  .bundledDeps(java.util.List<java.lang.String>)
//  .codeArtifactOptions(CodeArtifactOptions)
//  .deps(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .devDeps(java.util.List<java.lang.String>)
//  .entrypoint(java.lang.String)
//  .homepage(java.lang.String)
//  .keywords(java.util.List<java.lang.String>)
//  .license(java.lang.String)
//  .licensed(java.lang.Boolean)
//  .maxNodeVersion(java.lang.String)
//  .minNodeVersion(java.lang.String)
//  .npmAccess(NpmAccess)
//  .npmRegistry(java.lang.String)
//  .npmRegistryUrl(java.lang.String)
//  .npmTokenSecret(java.lang.String)
//  .packageManager(NodePackageManager)
//  .packageName(java.lang.String)
//  .peerDependencyOptions(PeerDependencyOptions)
//  .peerDeps(java.util.List<java.lang.String>)
//  .pnpmVersion(java.lang.String)
//  .repository(java.lang.String)
//  .repositoryDirectory(java.lang.String)
//  .scopedPackagesOptions(java.util.List<ScopedPackagesOptions>)
//  .scripts(java.util.Map<java.lang.String, java.lang.String>)
//  .stability(java.lang.String)
//  .jsiiReleaseVersion(java.lang.String)
//  .majorVersion(java.lang.Number)
//  .minMajorVersion(java.lang.Number)
//  .npmDistTag(java.lang.String)
//  .postBuildSteps(java.util.List<JobStep>)
//  .prerelease(java.lang.String)
//  .publishDryRun(java.lang.Boolean)
//  .publishTasks(java.lang.Boolean)
//  .releaseBranches(java.util.Map<java.lang.String, BranchOptions>)
//  .releaseEveryCommit(java.lang.Boolean)
//  .releaseFailureIssue(java.lang.Boolean)
//  .releaseFailureIssueLabel(java.lang.String)
//  .releaseSchedule(java.lang.String)
//  .releaseTagPrefix(java.lang.String)
//  .releaseTrigger(ReleaseTrigger)
//  .releaseWorkflowName(java.lang.String)
//  .releaseWorkflowSetupSteps(java.util.List<JobStep>)
//  .versionrcOptions(java.util.Map<java.lang.String, java.lang.Object>)
//  .workflowContainerImage(java.lang.String)
//  .workflowRunsOn(java.util.List<java.lang.String>)
    .defaultReleaseBranch(java.lang.String)
//  .artifactsDirectory(java.lang.String)
//  .autoApproveUpgrades(java.lang.Boolean)
//  .buildWorkflow(java.lang.Boolean)
//  .buildWorkflowTriggers(Triggers)
//  .bundlerOptions(BundlerOptions)
//  .codeCov(java.lang.Boolean)
//  .codeCovTokenSecret(java.lang.String)
//  .copyrightOwner(java.lang.String)
//  .copyrightPeriod(java.lang.String)
//  .dependabot(java.lang.Boolean)
//  .dependabotOptions(DependabotOptions)
//  .depsUpgrade(java.lang.Boolean)
//  .depsUpgradeOptions(UpgradeDependenciesOptions)
//  .gitignore(java.util.List<java.lang.String>)
//  .jest(java.lang.Boolean)
//  .jestOptions(JestOptions)
//  .mutableBuild(java.lang.Boolean)
//  .npmignore(java.util.List<java.lang.String>)
//  .npmignoreEnabled(java.lang.Boolean)
//  .npmIgnoreOptions(IgnoreFileOptions)
//  .package(java.lang.Boolean)
//  .prettier(java.lang.Boolean)
//  .prettierOptions(PrettierOptions)
//  .projenDevDependency(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenVersion(java.lang.String)
//  .pullRequestTemplate(java.lang.Boolean)
//  .pullRequestTemplateContents(java.util.List<java.lang.String>)
//  .release(java.lang.Boolean)
//  .releaseToNpm(java.lang.Boolean)
//  .releaseWorkflow(java.lang.Boolean)
//  .workflowBootstrapSteps(java.util.List<JobStep>)
//  .workflowGitIdentity(GitIdentity)
//  .workflowNodeVersion(java.lang.String)
//  .workflowPackageCache(java.lang.Boolean)
//  .disableTsconfig(java.lang.Boolean)
//  .disableTsconfigDev(java.lang.Boolean)
//  .docgen(java.lang.Boolean)
//  .docsDirectory(java.lang.String)
//  .entrypointTypes(java.lang.String)
//  .eslint(java.lang.Boolean)
//  .eslintOptions(EslintOptions)
//  .libdir(java.lang.String)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcOptions)
//  .sampleCode(java.lang.Boolean)
//  .srcdir(java.lang.String)
//  .testdir(java.lang.String)
//  .tsconfig(TypescriptConfigOptions)
//  .tsconfigDev(TypescriptConfigOptions)
//  .tsconfigDevFile(java.lang.String)
//  .typescriptVersion(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
//  .specFile(java.lang.String)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | Allow the project to include `peerDependencies` and `bundledDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorOrganization">authorOrganization</a></code> | <code>java.lang.Boolean</code> | Is the author an organization. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorUrl">authorUrl</a></code> | <code>java.lang.String</code> | Author's URL / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoDetectBin">autoDetectBin</a></code> | <code>java.lang.Boolean</code> | Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bin">bin</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | Binary programs vended with your module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsEmail">bugsEmail</a></code> | <code>java.lang.String</code> | The email address to which issues should be reported. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsUrl">bugsUrl</a></code> | <code>java.lang.String</code> | The url to your project's issue tracker. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundledDeps">bundledDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dependencies to bundle into this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeArtifactOptions">codeArtifactOptions</a></code> | <code>io.github.cdklabs.projen.javascript.CodeArtifactOptions</code> | Options for npm packages using AWS CodeArtifact. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | Runtime dependencies of this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | The description is just a string that helps people understand the purpose of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | Build dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | Module entrypoint (`main` in `package.json`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.homepage">homepage</a></code> | <code>java.lang.String</code> | Package's Homepage / Website. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.keywords">keywords</a></code> | <code>java.util.List<java.lang.String></code> | Keywords to include in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.license">license</a></code> | <code>java.lang.String</code> | License's SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.licensed">licensed</a></code> | <code>java.lang.Boolean</code> | Indicates if a license should be added. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version to require via `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum Node.js version to require via package.json `engines` (inclusive). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmAccess">npmAccess</a></code> | <code>io.github.cdklabs.projen.javascript.NpmAccess</code> | Access level of the npm package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistry">npmRegistry</a></code> | <code>java.lang.String</code> | The host name of the npm registry to publish to. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistryUrl">npmRegistryUrl</a></code> | <code>java.lang.String</code> | The base URL of the npm package registry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmTokenSecret">npmTokenSecret</a></code> | <code>java.lang.String</code> | GitHub secret which contains the NPM token to use when publishing packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The Node Package Manager used to execute scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageName">packageName</a></code> | <code>java.lang.String</code> | The "name" in package.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDependencyOptions">peerDependencyOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PeerDependencyOptions</code> | Options for `peerDeps`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDeps">peerDeps</a></code> | <code>java.util.List<java.lang.String></code> | Peer dependencies for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pnpmVersion">pnpmVersion</a></code> | <code>java.lang.String</code> | The version of PNPM to use if using PNPM as a package manager. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repository">repository</a></code> | <code>java.lang.String</code> | The repository is the location where the actual code for your package lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repositoryDirectory">repositoryDirectory</a></code> | <code>java.lang.String</code> | If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scopedPackagesOptions">scopedPackagesOptions</a></code> | <code>java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions></code> | Options for privately hosted scoped packages. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scripts">scripts</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | npm scripts to include. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stability">stability</a></code> | <code>java.lang.String</code> | Package's Stability. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jsiiReleaseVersion">jsiiReleaseVersion</a></code> | <code>java.lang.String</code> | Version requirement of `publib` which is used to publish modules to npm. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.majorVersion">majorVersion</a></code> | <code>java.lang.Number</code> | Major version to release from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minMajorVersion">minMajorVersion</a></code> | <code>java.lang.Number</code> | Minimal Major version to release. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmDistTag">npmDistTag</a></code> | <code>java.lang.String</code> | The npmDistTag to use when publishing from the default branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.postBuildSteps">postBuildSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Steps to execute after build as part of the release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prerelease">prerelease</a></code> | <code>java.lang.String</code> | Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre"). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishDryRun">publishDryRun</a></code> | <code>java.lang.Boolean</code> | Instead of actually publishing to package managers, just print the publishing command. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishTasks">publishTasks</a></code> | <code>java.lang.Boolean</code> | Define publishing tasks that can be executed manually as well as workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseBranches">releaseBranches</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions></code> | Defines additional release branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseEveryCommit">releaseEveryCommit</a></code> | <code>java.lang.Boolean</code> | Automatically release new versions every commit to one of branches in `releaseBranches`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssue">releaseFailureIssue</a></code> | <code>java.lang.Boolean</code> | Create a github issue on every failed publishing task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssueLabel">releaseFailureIssueLabel</a></code> | <code>java.lang.String</code> | The label to apply to issues indicating publish failures. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseSchedule">releaseSchedule</a></code> | <code>java.lang.String</code> | CRON schedule to trigger new releases. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTagPrefix">releaseTagPrefix</a></code> | <code>java.lang.String</code> | Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTrigger">releaseTrigger</a></code> | <code>io.github.cdklabs.projen.release.ReleaseTrigger</code> | The release trigger to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowName">releaseWorkflowName</a></code> | <code>java.lang.String</code> | The name of the default release workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowSetupSteps">releaseWorkflowSetupSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | A set of workflow steps to execute in order to setup the workflow container. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.versionrcOptions">versionrcOptions</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Custom configuration used when creating changelog with standard-version package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowContainerImage">workflowContainerImage</a></code> | <code>java.lang.String</code> | Container image to use for GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowRunsOn">workflowRunsOn</a></code> | <code>java.util.List<java.lang.String></code> | Github Runner selection labels. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.defaultReleaseBranch">defaultReleaseBranch</a></code> | <code>java.lang.String</code> | The name of the main release branch. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | A directory which will contain build artifacts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveUpgrades">autoApproveUpgrades</a></code> | <code>java.lang.Boolean</code> | Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflow">buildWorkflow</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow for building PRs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflowTriggers">buildWorkflowTriggers</a></code> | <code>io.github.cdklabs.projen.github.workflows.Triggers</code> | Build workflow triggers. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundlerOptions">bundlerOptions</a></code> | <code>io.github.cdklabs.projen.javascript.BundlerOptions</code> | Options for `Bundler`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCov">codeCov</a></code> | <code>java.lang.Boolean</code> | Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCovTokenSecret">codeCovTokenSecret</a></code> | <code>java.lang.String</code> | Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightOwner">copyrightOwner</a></code> | <code>java.lang.String</code> | License copyright owner. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightPeriod">copyrightPeriod</a></code> | <code>java.lang.String</code> | The copyright years to put in the LICENSE file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabot">dependabot</a></code> | <code>java.lang.Boolean</code> | Use dependabot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabotOptions">dependabotOptions</a></code> | <code>io.github.cdklabs.projen.github.DependabotOptions</code> | Options for dependabot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgrade">depsUpgrade</a></code> | <code>java.lang.Boolean</code> | Use github workflows to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgradeOptions">depsUpgradeOptions</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions</code> | Options for `UpgradeDependencies`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitignore">gitignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jest">jest</a></code> | <code>java.lang.Boolean</code> | Setup jest unit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jestOptions">jestOptions</a></code> | <code>io.github.cdklabs.projen.javascript.JestOptions</code> | Jest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mutableBuild">mutableBuild</a></code> | <code>java.lang.Boolean</code> | Automatically update files modified during builds to pull-request branches. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignore">npmignore</a></code> | <code>java.util.List<java.lang.String></code> | Additional entries to .npmignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignoreEnabled">npmignoreEnabled</a></code> | <code>java.lang.Boolean</code> | Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmIgnoreOptions">npmIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.package">package</a></code> | <code>java.lang.Boolean</code> | Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettier">prettier</a></code> | <code>java.lang.Boolean</code> | Setup prettier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettierOptions">prettierOptions</a></code> | <code>io.github.cdklabs.projen.javascript.PrettierOptions</code> | Prettier options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenDevDependency">projenDevDependency</a></code> | <code>java.lang.Boolean</code> | Indicates of "projen" should be installed as a devDependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options for .projenrc.js. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenVersion">projenVersion</a></code> | <code>java.lang.String</code> | Version of projen to install. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplate">pullRequestTemplate</a></code> | <code>java.lang.Boolean</code> | Include a GitHub pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplateContents">pullRequestTemplateContents</a></code> | <code>java.util.List<java.lang.String></code> | The contents of the pull request template. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.release">release</a></code> | <code>java.lang.Boolean</code> | Add release management to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseToNpm">releaseToNpm</a></code> | <code>java.lang.Boolean</code> | Automatically release to npm when new versions are introduced. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflow">releaseWorkflow</a></code> | <code>java.lang.Boolean</code> | DEPRECATED: renamed to `release`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowBootstrapSteps">workflowBootstrapSteps</a></code> | <code>java.util.List<io.github.cdklabs.projen.github.workflows.JobStep></code> | Workflow steps to use in order to bootstrap this repo. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowGitIdentity">workflowGitIdentity</a></code> | <code>io.github.cdklabs.projen.github.GitIdentity</code> | The git identity to use in workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowNodeVersion">workflowNodeVersion</a></code> | <code>java.lang.String</code> | The node version to use in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowPackageCache">workflowPackageCache</a></code> | <code>java.lang.Boolean</code> | Enable Node.js package cache in GitHub workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfig">disableTsconfig</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfigDev">disableTsconfigDev</a></code> | <code>java.lang.Boolean</code> | Do not generate a `tsconfig.dev.json` file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | Docgen by Typedoc. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | Docs directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypointTypes">entrypointTypes</a></code> | <code>java.lang.String</code> | The .d.ts file that includes the type declarations for this module. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslint">eslint</a></code> | <code>java.lang.Boolean</code> | Setup eslint. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslintOptions">eslintOptions</a></code> | <code>io.github.cdklabs.projen.javascript.EslintOptions</code> | Eslint options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.libdir">libdir</a></code> | <code>java.lang.String</code> | Typescript  artifacts output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use TypeScript for your projenrc file (`.projenrc.ts`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcOptions</code> | Options for .projenrc.ts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.sampleCode">sampleCode</a></code> | <code>java.lang.Boolean</code> | Generate one-time sample in `src/` and `test/` if there are no files there. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.srcdir">srcdir</a></code> | <code>java.lang.String</code> | Typescript sources directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.testdir">testdir</a></code> | <code>java.lang.String</code> | Jest tests directory. Tests files should be named `xxx.test.ts`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom TSConfig. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfigOptions</code> | Custom tsconfig options for the development tsconfig.json file (used for testing). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDevFile">tsconfigDevFile</a></code> | <code>java.lang.String</code> | The name of the development tsconfig.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptVersion">typescriptVersion</a></code> | <code>java.lang.String</code> | TypeScript version to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.specFile">specFile</a></code> | <code>java.lang.String</code> | The path to the OpenAPI specification file, relative to the project source directory (srcdir). |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `allowLibraryDependencies`<sup>Optional</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.allowLibraryDependencies"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Allow the project to include `peerDependencies` and `bundledDependencies`.

This is normally only allowed for libraries. For apps, there's no meaning
for specifying these.

---

##### `authorEmail`<sup>Optional</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorEmail"></a>

- *Type:* java.lang.String

Author's e-mail.

---

##### `authorName`<sup>Optional</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorName"></a>

- *Type:* java.lang.String

Author's name.

---

##### `authorOrganization`<sup>Optional</sup> <a name="authorOrganization" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorOrganization"></a>

- *Type:* java.lang.Boolean

Is the author an organization.

---

##### `authorUrl`<sup>Optional</sup> <a name="authorUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.authorUrl"></a>

- *Type:* java.lang.String

Author's URL / Website.

---

##### `autoDetectBin`<sup>Optional</sup> <a name="autoDetectBin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoDetectBin"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically add all executables under the `bin` directory to your `package.json` file under the `bin` section.

---

##### `bin`<sup>Optional</sup> <a name="bin" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bin"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

Binary programs vended with your module.

You can use this option to add/customize how binaries are represented in
your `package.json`, but unless `autoDetectBin` is `false`, every
executable file under `bin` will automatically be added to this section.

---

##### `bugsEmail`<sup>Optional</sup> <a name="bugsEmail" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsEmail"></a>

- *Type:* java.lang.String

The email address to which issues should be reported.

---

##### `bugsUrl`<sup>Optional</sup> <a name="bugsUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bugsUrl"></a>

- *Type:* java.lang.String

The url to your project's issue tracker.

---

##### `bundledDeps`<sup>Optional</sup> <a name="bundledDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundledDeps"></a>

- *Type:* java.util.List<java.lang.String>

List of dependencies to bundle into this module.

These modules will be
added both to the `dependencies` section and `bundledDependencies` section of
your `package.json`.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

##### `codeArtifactOptions`<sup>Optional</sup> <a name="codeArtifactOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeArtifactOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.CodeArtifactOptions
- *Default:* undefined

Options for npm packages using AWS CodeArtifact.

This is required if publishing packages to, or installing scoped packages from AWS CodeArtifact

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Runtime dependencies of this module.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'express', 'lodash', 'foo@^2' ]
```


##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String

The description is just a string that helps people understand the purpose of the package.

It can be used when searching for packages in a package manager as well.
See https://classic.yarnpkg.com/en/docs/package-json/#toc-description

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.devDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Build dependencies for this module.

These dependencies will only be
available in your build environment but will not be fetched when this
module is consumed.

The recommendation is to only specify the module name here (e.g.
`express`). This will behave similar to `yarn add` or `npm install` in the
sense that it will add the module as a dependency to your `package.json`
file with the latest version (`^`). You can specify semver requirements in
the same syntax passed to `npm i` or `yarn add` (e.g. `express@^2`) and
this will be what you `package.json` will eventually include.

---

*Example*

```java
[ 'typescript', '@types/express' ]
```


##### `entrypoint`<sup>Optional</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypoint"></a>

- *Type:* java.lang.String
- *Default:* "lib/index.js"

Module entrypoint (`main` in `package.json`).

Set to an empty string to not include `main` in your package.json

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.homepage"></a>

- *Type:* java.lang.String

Package's Homepage / Website.

---

##### `keywords`<sup>Optional</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.keywords"></a>

- *Type:* java.util.List<java.lang.String>

Keywords to include in `package.json`.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.license"></a>

- *Type:* java.lang.String
- *Default:* "Apache-2.0"

License's SPDX identifier.

See https://github.com/projen/projen/tree/main/license-text for a list of supported licenses.
Use the `licensed` option if you want to no license to be specified.

---

##### `licensed`<sup>Optional</sup> <a name="licensed" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.licensed"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates if a license should be added.

---

##### `maxNodeVersion`<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.maxNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* no max

Minimum node.js version to require via `engines` (inclusive).

---

##### `minNodeVersion`<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* no "engines" specified

Minimum Node.js version to require via package.json `engines` (inclusive).

---

##### `npmAccess`<sup>Optional</sup> <a name="npmAccess" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmAccess"></a>

- *Type:* io.github.cdklabs.projen.javascript.NpmAccess
- *Default:* for scoped packages (e.g. `foo@bar`), the default is `NpmAccess.RESTRICTED`, for non-scoped packages, the default is `NpmAccess.PUBLIC`.

Access level of the npm package.

---

##### ~~`npmRegistry`~~<sup>Optional</sup> <a name="npmRegistry" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistry"></a>

- *Deprecated:* use `npmRegistryUrl` instead

- *Type:* java.lang.String

The host name of the npm registry to publish to.

Cannot be set together with `npmRegistryUrl`.

---

##### `npmRegistryUrl`<sup>Optional</sup> <a name="npmRegistryUrl" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmRegistryUrl"></a>

- *Type:* java.lang.String
- *Default:* "https://registry.npmjs.org"

The base URL of the npm package registry.

Must be a URL (e.g. start with "https://" or "http://")

---

##### `npmTokenSecret`<sup>Optional</sup> <a name="npmTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmTokenSecret"></a>

- *Type:* java.lang.String
- *Default:* "NPM_TOKEN"

GitHub secret which contains the NPM token to use when publishing packages.

---

##### `packageManager`<sup>Optional</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageManager"></a>

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager
- *Default:* NodePackageManager.YARN

The Node Package Manager used to execute scripts.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.packageName"></a>

- *Type:* java.lang.String
- *Default:* defaults to project name

The "name" in package.json.

---

##### `peerDependencyOptions`<sup>Optional</sup> <a name="peerDependencyOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDependencyOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.PeerDependencyOptions

Options for `peerDeps`.

---

##### `peerDeps`<sup>Optional</sup> <a name="peerDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.peerDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

Peer dependencies for this module.

Dependencies listed here are required to
be installed (and satisfied) by the _consumer_ of this library. Using peer
dependencies allows you to ensure that only a single module of a certain
library exists in the `node_modules` tree of your consumers.

Note that prior to npm@7, peer dependencies are _not_ automatically
installed, which means that adding peer dependencies to a library will be a
breaking change for your customers.

Unless `peerDependencyOptions.pinnedDevDependency` is disabled (it is
enabled by default), projen will automatically add a dev dependency with a
pinned version for each peer dependency. This will ensure that you build &
test your module against the lowest peer version required.

---

##### `pnpmVersion`<sup>Optional</sup> <a name="pnpmVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pnpmVersion"></a>

- *Type:* java.lang.String
- *Default:* "7"

The version of PNPM to use if using PNPM as a package manager.

---

##### `repository`<sup>Optional</sup> <a name="repository" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repository"></a>

- *Type:* java.lang.String

The repository is the location where the actual code for your package lives.

See https://classic.yarnpkg.com/en/docs/package-json/#toc-repository

---

##### `repositoryDirectory`<sup>Optional</sup> <a name="repositoryDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.repositoryDirectory"></a>

- *Type:* java.lang.String

If the package.json for your package is not in the root directory (for example if it is part of a monorepo), you can specify the directory in which it lives.

---

##### `scopedPackagesOptions`<sup>Optional</sup> <a name="scopedPackagesOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scopedPackagesOptions"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.javascript.ScopedPackagesOptions>
- *Default:* fetch all scoped packages from the public npm registry

Options for privately hosted scoped packages.

---

##### ~~`scripts`~~<sup>Optional</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.scripts"></a>

- *Deprecated:* use `project.addTask()` or `package.setScript()`

- *Type:* java.util.Map<java.lang.String, java.lang.String>
- *Default:* {}

npm scripts to include.

If a script has the same name as a standard script,
the standard script will be overwritten.
Also adds the script as a task.

---

##### `stability`<sup>Optional</sup> <a name="stability" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.stability"></a>

- *Type:* java.lang.String

Package's Stability.

---

##### `jsiiReleaseVersion`<sup>Optional</sup> <a name="jsiiReleaseVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jsiiReleaseVersion"></a>

- *Type:* java.lang.String
- *Default:* "latest"

Version requirement of `publib` which is used to publish modules to npm.

---

##### `majorVersion`<sup>Optional</sup> <a name="majorVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.majorVersion"></a>

- *Type:* java.lang.Number
- *Default:* Major version is not enforced.

Major version to release from the default branch.

If this is specified, we bump the latest version of this major version line.
If not specified, we bump the global latest version.

---

##### `minMajorVersion`<sup>Optional</sup> <a name="minMajorVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.minMajorVersion"></a>

- *Type:* java.lang.Number
- *Default:* No minimum version is being enforced

Minimal Major version to release.

This can be useful to set to 1, as breaking changes before the 1.x major
release are not incrementing the major version number.

Can not be set together with `majorVersion`.

---

##### `npmDistTag`<sup>Optional</sup> <a name="npmDistTag" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmDistTag"></a>

- *Type:* java.lang.String
- *Default:* "latest"

The npmDistTag to use when publishing from the default branch.

To set the npm dist-tag for release branches, set the `npmDistTag` property
for each branch.

---

##### `postBuildSteps`<sup>Optional</sup> <a name="postBuildSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.postBuildSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* []

Steps to execute after build as part of the release workflow.

---

##### `prerelease`<sup>Optional</sup> <a name="prerelease" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prerelease"></a>

- *Type:* java.lang.String
- *Default:* normal semantic versions

Bump versions from the default branch as pre-releases (e.g. "beta", "alpha", "pre").

---

##### `publishDryRun`<sup>Optional</sup> <a name="publishDryRun" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishDryRun"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Instead of actually publishing to package managers, just print the publishing command.

---

##### `publishTasks`<sup>Optional</sup> <a name="publishTasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.publishTasks"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Define publishing tasks that can be executed manually as well as workflows.

Normally, publishing only happens within automated workflows. Enable this
in order to create a publishing task for each publishing activity.

---

##### `releaseBranches`<sup>Optional</sup> <a name="releaseBranches" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseBranches"></a>

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.release.BranchOptions>
- *Default:* no additional branches are used for release. you can use `addBranch()` to add additional branches.

Defines additional release branches.

A workflow will be created for each
release branch which will publish releases from commits in this branch.
Each release branch _must_ be assigned a major version number which is used
to enforce that versions published from that branch always use that major
version. If multiple branches are used, the `majorVersion` field must also
be provided for the default branch.

---

##### ~~`releaseEveryCommit`~~<sup>Optional</sup> <a name="releaseEveryCommit" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseEveryCommit"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.continuous()` instead

- *Type:* java.lang.Boolean
- *Default:* true

Automatically release new versions every commit to one of branches in `releaseBranches`.

---

##### `releaseFailureIssue`<sup>Optional</sup> <a name="releaseFailureIssue" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssue"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Create a github issue on every failed publishing task.

---

##### `releaseFailureIssueLabel`<sup>Optional</sup> <a name="releaseFailureIssueLabel" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseFailureIssueLabel"></a>

- *Type:* java.lang.String
- *Default:* "failed-release"

The label to apply to issues indicating publish failures.

Only applies if `releaseFailureIssue` is true.

---

##### ~~`releaseSchedule`~~<sup>Optional</sup> <a name="releaseSchedule" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseSchedule"></a>

- *Deprecated:* Use `releaseTrigger: ReleaseTrigger.scheduled()` instead

- *Type:* java.lang.String
- *Default:* no scheduled releases

CRON schedule to trigger new releases.

---

##### `releaseTagPrefix`<sup>Optional</sup> <a name="releaseTagPrefix" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTagPrefix"></a>

- *Type:* java.lang.String
- *Default:* "v"

Automatically add the given prefix to release tags. Useful if you are releasing on multiple branches with overlapping version numbers.

Note: this prefix is used to detect the latest tagged version
when bumping, so if you change this on a project with an existing version
history, you may need to manually tag your latest release
with the new prefix.

---

##### `releaseTrigger`<sup>Optional</sup> <a name="releaseTrigger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseTrigger"></a>

- *Type:* io.github.cdklabs.projen.release.ReleaseTrigger
- *Default:* Continuous releases (`ReleaseTrigger.continuous()`)

The release trigger to use.

---

##### `releaseWorkflowName`<sup>Optional</sup> <a name="releaseWorkflowName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowName"></a>

- *Type:* java.lang.String
- *Default:* "Release"

The name of the default release workflow.

---

##### `releaseWorkflowSetupSteps`<sup>Optional</sup> <a name="releaseWorkflowSetupSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflowSetupSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>

A set of workflow steps to execute in order to setup the workflow container.

---

##### `versionrcOptions`<sup>Optional</sup> <a name="versionrcOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.versionrcOptions"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>
- *Default:* standard configuration applicable for GitHub repositories

Custom configuration used when creating changelog with standard-version package.

Given values either append to default configuration or overwrite values in it.

---

##### `workflowContainerImage`<sup>Optional</sup> <a name="workflowContainerImage" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowContainerImage"></a>

- *Type:* java.lang.String
- *Default:* default image

Container image to use for GitHub workflows.

---

##### `workflowRunsOn`<sup>Optional</sup> <a name="workflowRunsOn" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowRunsOn"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* ["ubuntu-latest"]

Github Runner selection labels.

---

##### `defaultReleaseBranch`<sup>Required</sup> <a name="defaultReleaseBranch" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.defaultReleaseBranch"></a>

- *Type:* java.lang.String
- *Default:* "main"

The name of the main release branch.

---

##### `artifactsDirectory`<sup>Optional</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.artifactsDirectory"></a>

- *Type:* java.lang.String
- *Default:* "dist"

A directory which will contain build artifacts.

---

##### `autoApproveUpgrades`<sup>Optional</sup> <a name="autoApproveUpgrades" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.autoApproveUpgrades"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).

Throw if set to true but `autoApproveOptions` are not defined.

---

##### `buildWorkflow`<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflow"></a>

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

Define a GitHub workflow for building PRs.

---

##### `buildWorkflowTriggers`<sup>Optional</sup> <a name="buildWorkflowTriggers" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.buildWorkflowTriggers"></a>

- *Type:* io.github.cdklabs.projen.github.workflows.Triggers
- *Default:* "{ pullRequest: {}, workflowDispatch: {} }"

Build workflow triggers.

---

##### `bundlerOptions`<sup>Optional</sup> <a name="bundlerOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.bundlerOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.BundlerOptions

Options for `Bundler`.

---

##### `codeCov`<sup>Optional</sup> <a name="codeCov" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCov"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v3 A secret is required for private repos. Configured with `@codeCovTokenSecret`.

---

##### `codeCovTokenSecret`<sup>Optional</sup> <a name="codeCovTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.codeCovTokenSecret"></a>

- *Type:* java.lang.String
- *Default:* if this option is not specified, only public repositories are supported

Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.

---

##### `copyrightOwner`<sup>Optional</sup> <a name="copyrightOwner" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightOwner"></a>

- *Type:* java.lang.String
- *Default:* defaults to the value of authorName or "" if `authorName` is undefined.

License copyright owner.

---

##### `copyrightPeriod`<sup>Optional</sup> <a name="copyrightPeriod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.copyrightPeriod"></a>

- *Type:* java.lang.String
- *Default:* current year

The copyright years to put in the LICENSE file.

---

##### `dependabot`<sup>Optional</sup> <a name="dependabot" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use dependabot to handle dependency upgrades.

Cannot be used in conjunction with `depsUpgrade`.

---

##### `dependabotOptions`<sup>Optional</sup> <a name="dependabotOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.dependabotOptions"></a>

- *Type:* io.github.cdklabs.projen.github.DependabotOptions
- *Default:* default options

Options for dependabot.

---

##### `depsUpgrade`<sup>Optional</sup> <a name="depsUpgrade" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgrade"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use github workflows to handle dependency upgrades.

Cannot be used in conjunction with `dependabot`.

---

##### `depsUpgradeOptions`<sup>Optional</sup> <a name="depsUpgradeOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.depsUpgradeOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependenciesOptions
- *Default:* default options

Options for `UpgradeDependencies`.

---

##### `gitignore`<sup>Optional</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.gitignore"></a>

- *Type:* java.util.List<java.lang.String>

Additional entries to .gitignore.

---

##### `jest`<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jest"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Setup jest unit tests.

---

##### `jestOptions`<sup>Optional</sup> <a name="jestOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.jestOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.JestOptions
- *Default:* default options

Jest options.

---

##### `mutableBuild`<sup>Optional</sup> <a name="mutableBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.mutableBuild"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Automatically update files modified during builds to pull-request branches.

This means
that any files synthesized by projen or e.g. test snapshots will always be up-to-date
before a PR is merged.

Implies that PR builds do not have anti-tamper checks.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignore"></a>

- *Deprecated:* - use `project.addPackageIgnore`

- *Type:* java.util.List<java.lang.String>

Additional entries to .npmignore.

---

##### `npmignoreEnabled`<sup>Optional</sup> <a name="npmignoreEnabled" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmignoreEnabled"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.

---

##### `npmIgnoreOptions`<sup>Optional</sup> <a name="npmIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.npmIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .npmignore file.

---

##### `package`<sup>Optional</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.package"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Defines a `package` task that will produce an npm tarball under the artifacts directory (e.g. `dist`).

---

##### `prettier`<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettier"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Setup prettier.

---

##### `prettierOptions`<sup>Optional</sup> <a name="prettierOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.prettierOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.PrettierOptions
- *Default:* default options

Prettier options.

---

##### `projenDevDependency`<sup>Optional</sup> <a name="projenDevDependency" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenDevDependency"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Indicates of "projen" should be installed as a devDependency.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJs"></a>

- *Type:* java.lang.Boolean
- *Default:* true if projenrcJson is false

Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options for .projenrc.js.

---

##### `projenVersion`<sup>Optional</sup> <a name="projenVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenVersion"></a>

- *Type:* java.lang.String
- *Default:* Defaults to the latest version.

Version of projen to install.

---

##### `pullRequestTemplate`<sup>Optional</sup> <a name="pullRequestTemplate" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplate"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include a GitHub pull request template.

---

##### `pullRequestTemplateContents`<sup>Optional</sup> <a name="pullRequestTemplateContents" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pullRequestTemplateContents"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* default content

The contents of the pull request template.

---

##### `release`<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.release"></a>

- *Type:* java.lang.Boolean
- *Default:* true (false for subprojects)

Add release management to this project.

---

##### `releaseToNpm`<sup>Optional</sup> <a name="releaseToNpm" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseToNpm"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Automatically release to npm when new versions are introduced.

---

##### ~~`releaseWorkflow`~~<sup>Optional</sup> <a name="releaseWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.releaseWorkflow"></a>

- *Deprecated:* see `release`.

- *Type:* java.lang.Boolean
- *Default:* true if not a subproject

DEPRECATED: renamed to `release`.

---

##### `workflowBootstrapSteps`<sup>Optional</sup> <a name="workflowBootstrapSteps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowBootstrapSteps"></a>

- *Type:* java.util.List<io.github.cdklabs.projen.github.workflows.JobStep>
- *Default:* "yarn install --frozen-lockfile && yarn projen"

Workflow steps to use in order to bootstrap this repo.

---

##### `workflowGitIdentity`<sup>Optional</sup> <a name="workflowGitIdentity" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowGitIdentity"></a>

- *Type:* io.github.cdklabs.projen.github.GitIdentity
- *Default:* GitHub Actions

The git identity to use in workflows.

---

##### `workflowNodeVersion`<sup>Optional</sup> <a name="workflowNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowNodeVersion"></a>

- *Type:* java.lang.String
- *Default:* same as `minNodeVersion`

The node version to use in GitHub workflows.

---

##### `workflowPackageCache`<sup>Optional</sup> <a name="workflowPackageCache" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.workflowPackageCache"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Enable Node.js package cache in GitHub workflows.

---

##### `disableTsconfig`<sup>Optional</sup> <a name="disableTsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfig"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).

---

##### `disableTsconfigDev`<sup>Optional</sup> <a name="disableTsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.disableTsconfigDev"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Do not generate a `tsconfig.dev.json` file.

---

##### `docgen`<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docgen"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Docgen by Typedoc.

---

##### `docsDirectory`<sup>Optional</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.docsDirectory"></a>

- *Type:* java.lang.String
- *Default:* "docs"

Docs directory.

---

##### `entrypointTypes`<sup>Optional</sup> <a name="entrypointTypes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.entrypointTypes"></a>

- *Type:* java.lang.String
- *Default:* .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)

The .d.ts file that includes the type declarations for this module.

---

##### `eslint`<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslint"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Setup eslint.

---

##### `eslintOptions`<sup>Optional</sup> <a name="eslintOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.eslintOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.EslintOptions
- *Default:* opinionated default options

Eslint options.

---

##### `libdir`<sup>Optional</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.libdir"></a>

- *Type:* java.lang.String
- *Default:* "lib"

Typescript  artifacts output directory.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use TypeScript for your projenrc file (`.projenrc.ts`).

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcOptions

Options for .projenrc.ts.

---

##### `sampleCode`<sup>Optional</sup> <a name="sampleCode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.sampleCode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Generate one-time sample in `src/` and `test/` if there are no files there.

---

##### `srcdir`<sup>Optional</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.srcdir"></a>

- *Type:* java.lang.String
- *Default:* "src"

Typescript sources directory.

---

##### `testdir`<sup>Optional</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.testdir"></a>

- *Type:* java.lang.String
- *Default:* "test"

Jest tests directory. Tests files should be named `xxx.test.ts`.

If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
then tests are going to be compiled into `lib/` and executed as javascript.
If the test directory is outside of `src`, then we configure jest to
compile the code in-memory.

---

##### `tsconfig`<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfig"></a>

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* default options

Custom TSConfig.

---

##### `tsconfigDev`<sup>Optional</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDev"></a>

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfigOptions
- *Default:* use the production tsconfig options

Custom tsconfig options for the development tsconfig.json file (used for testing).

---

##### `tsconfigDevFile`<sup>Optional</sup> <a name="tsconfigDevFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.tsconfigDevFile"></a>

- *Type:* java.lang.String
- *Default:* "tsconfig.dev.json"

The name of the development tsconfig.json file.

---

##### `typescriptVersion`<sup>Optional</sup> <a name="typescriptVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptVersion"></a>

- *Type:* java.lang.String
- *Default:* "latest"

TypeScript version to use.

NOTE: Typescript is not semantically versioned and should remain on the
same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.clientLanguages"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.documentationFormats"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `specFile`<sup>Optional</sup> <a name="specFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.Initializer.parameter.specFile"></a>

- *Type:* java.lang.String
- *Default:* "spec/spec.yaml"

The path to the OpenAPI specification file, relative to the project source directory (srcdir).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins">addBins</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps">addBundledDeps</a></code> | Defines bundled dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand">addCompileCommand</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps">addDeps</a></code> | Defines normal dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps">addDevDeps</a></code> | Defines development/test dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields">addFields</a></code> | Directly set fields in `package.json`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords">addKeywords</a></code> | Adds keywords to package.json (deduplicated). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps">addPeerDeps</a></code> | Defines peer dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts">addScripts</a></code> | Replaces the contents of multiple npm package.json scripts. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand">addTestCommand</a></code> | DEPRECATED. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript">hasScript</a></code> | Indicates if a script by the name name is defined. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript">removeScript</a></code> | Removes the npm script (always successful). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup">renderWorkflowSetup</a></code> | Returns the set of workflow steps which should be executed to bootstrap a workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript">setScript</a></code> | Replaces the contents of an npm package.json script. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPackageIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

This will
typically be `npx projen TASK`.

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addBins`~~ <a name="addBins" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins"></a>

```java
public void addBins(java.util.Map<java.lang.String, java.lang.String> bins)
```

###### `bins`<sup>Required</sup> <a name="bins" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBins.parameter.bins"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### ~~`addBundledDeps`~~ <a name="addBundledDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps"></a>

```java
public void addBundledDeps(java.lang.String deps)
```

Defines bundled dependencies.

Bundled dependencies will be added as normal dependencies as well as to the
`bundledDependencies` section of your `package.json`.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addBundledDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addCompileCommand`~~ <a name="addCompileCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand"></a>

```java
public void addCompileCommand(java.lang.String commands)
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addCompileCommand.parameter.commands"></a>

- *Type:* java.lang.String

---

##### ~~`addDeps`~~ <a name="addDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps"></a>

```java
public void addDeps(java.lang.String deps)
```

Defines normal dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addDevDeps`~~ <a name="addDevDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps"></a>

```java
public void addDevDeps(java.lang.String deps)
```

Defines development/test dependencies.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addDevDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addFields`~~ <a name="addFields" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields"></a>

```java
public void addFields(java.util.Map<java.lang.String, java.lang.Object> fields)
```

Directly set fields in `package.json`.

###### `fields`<sup>Required</sup> <a name="fields" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addFields.parameter.fields"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

The fields to set.

---

##### ~~`addKeywords`~~ <a name="addKeywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords"></a>

```java
public void addKeywords(java.lang.String keywords)
```

Adds keywords to package.json (deduplicated).

###### `keywords`<sup>Required</sup> <a name="keywords" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addKeywords.parameter.keywords"></a>

- *Type:* java.lang.String

The keywords to add.

---

##### ~~`addPeerDeps`~~ <a name="addPeerDeps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps"></a>

```java
public void addPeerDeps(java.lang.String deps)
```

Defines peer dependencies.

When adding peer dependencies, a devDependency will also be added on the
pinned version of the declared peer. This will ensure that you are testing
your code against the minimum version required from your consumers.

###### `deps`<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addPeerDeps.parameter.deps"></a>

- *Type:* java.lang.String

Names modules to install.

By default, the the dependency will
be installed in the next `npx projen` run and the version will be recorded
in your `package.json` file. You can upgrade manually or using `yarn
add/upgrade`. If you wish to specify a version range use this syntax:
`module@^7`.

---

##### ~~`addScripts`~~ <a name="addScripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts"></a>

```java
public void addScripts(java.util.Map<java.lang.String, java.lang.String> scripts)
```

Replaces the contents of multiple npm package.json scripts.

###### `scripts`<sup>Required</sup> <a name="scripts" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addScripts.parameter.scripts"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The scripts to set.

---

##### ~~`addTestCommand`~~ <a name="addTestCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand"></a>

```java
public void addTestCommand(java.lang.String commands)
```

DEPRECATED.

###### `commands`<sup>Required</sup> <a name="commands" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.addTestCommand.parameter.commands"></a>

- *Type:* java.lang.String

---

##### ~~`hasScript`~~ <a name="hasScript" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript"></a>

```java
public java.lang.Boolean hasScript(java.lang.String name)
```

Indicates if a script by the name name is defined.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.hasScript.parameter.name"></a>

- *Type:* java.lang.String

The name of the script.

---

##### ~~`removeScript`~~ <a name="removeScript" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript"></a>

```java
public void removeScript(java.lang.String name)
```

Removes the npm script (always successful).

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.removeScript.parameter.name"></a>

- *Type:* java.lang.String

The name of the script.

---

##### ~~`renderWorkflowSetup`~~ <a name="renderWorkflowSetup" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup"></a>

```java
public java.util.List<JobStep> renderWorkflowSetup()
public java.util.List<JobStep> renderWorkflowSetup(RenderWorkflowSetupOptions options)
```

Returns the set of workflow steps which should be executed to bootstrap a workflow.

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.renderWorkflowSetup.parameter.options"></a>

- *Type:* io.github.cdklabs.projen.javascript.RenderWorkflowSetupOptions

Options.

---

##### ~~`setScript`~~ <a name="setScript" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript"></a>

```java
public void setScript(java.lang.String name, java.lang.String command)
```

Replaces the contents of an npm package.json script.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript.parameter.name"></a>

- *Type:* java.lang.String

The script name.

---

###### `command`<sup>Required</sup> <a name="command" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.setScript.parameter.command"></a>

- *Type:* java.lang.String

The command to execute.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.subprojects">subprojects</a></code> | <code>java.util.List<io.github.cdklabs.projen.Project></code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.allowLibraryDependencies">allowLibraryDependencies</a></code> | <code>java.lang.Boolean</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsDirectory">artifactsDirectory</a></code> | <code>java.lang.String</code> | The build output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsJavascriptDirectory">artifactsJavascriptDirectory</a></code> | <code>java.lang.String</code> | The location of the npm tarball after build (`${artifactsDirectory}/js`). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.bundler">bundler</a></code> | <code>io.github.cdklabs.projen.javascript.Bundler</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.entrypoint">entrypoint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.manifest">manifest</a></code> | <code>java.lang.Object</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmrc">npmrc</a></code> | <code>io.github.cdklabs.projen.javascript.NpmConfig</code> | The .npmrc file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.package">package</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackage</code> | API for managing the node package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageManager">packageManager</a></code> | <code>io.github.cdklabs.projen.javascript.NodePackageManager</code> | The package manager to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.runScriptCommand">runScriptCommand</a></code> | <code>java.lang.String</code> | The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoMerge">autoMerge</a></code> | <code>io.github.cdklabs.projen.github.AutoMerge</code> | Component that sets up mergify for merging approved pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflow">buildWorkflow</a></code> | <code>io.github.cdklabs.projen.build.BuildWorkflow</code> | The PR build GitHub workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflowJobId">buildWorkflowJobId</a></code> | <code>java.lang.String</code> | The job ID of the build workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.jest">jest</a></code> | <code>io.github.cdklabs.projen.javascript.Jest</code> | The Jest configuration (if enabled). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.maxNodeVersion">maxNodeVersion</a></code> | <code>java.lang.String</code> | Maximum node version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.minNodeVersion">minNodeVersion</a></code> | <code>java.lang.String</code> | Minimum node.js version required by this package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmignore">npmignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | The .npmignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.prettier">prettier</a></code> | <code>io.github.cdklabs.projen.javascript.Prettier</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.publisher">publisher</a></code> | <code>io.github.cdklabs.projen.release.Publisher</code> | Package publisher. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.release">release</a></code> | <code>io.github.cdklabs.projen.release.Release</code> | Release management. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.upgradeWorkflow">upgradeWorkflow</a></code> | <code>io.github.cdklabs.projen.javascript.UpgradeDependencies</code> | The upgrade workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docsDirectory">docsDirectory</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.libdir">libdir</a></code> | <code>java.lang.String</code> | The directory in which compiled .js files reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.srcdir">srcdir</a></code> | <code>java.lang.String</code> | The directory in which the .ts sources reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testdir">testdir</a></code> | <code>java.lang.String</code> | The directory in which tests reside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigDev">tsconfigDev</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | A typescript configuration file which covers all files (sources, tests, projen). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.watchTask">watchTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | The "watch" task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docgen">docgen</a></code> | <code>java.lang.Boolean</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.eslint">eslint</a></code> | <code>io.github.cdklabs.projen.javascript.Eslint</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfig">tsconfig</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigEslint">tsconfigEslint</a></code> | <code>io.github.cdklabs.projen.javascript.TypescriptConfig</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedClients">generatedClients</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.Project></code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedTypescriptClient">generatedTypescriptClient</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProject</code> | A reference to the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specDir">specDir</a></code> | <code>java.lang.String</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specFileName">specFileName</a></code> | <code>java.lang.String</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.pnpmWorkspace">pnpmWorkspace</a></code> | <code>io.github.cdklabs.projen.YamlFile</code> | Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Project> getSubprojects();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Project>

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`allowLibraryDependencies`~~<sup>Required</sup> <a name="allowLibraryDependencies" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.allowLibraryDependencies"></a>

- *Deprecated:* use `package.allowLibraryDependencies`

```java
public java.lang.Boolean getAllowLibraryDependencies();
```

- *Type:* java.lang.Boolean

---

##### ~~`artifactsDirectory`~~<sup>Required</sup> <a name="artifactsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getArtifactsDirectory();
```

- *Type:* java.lang.String

The build output directory.

An npm tarball will be created under the `js`
subdirectory. For example, if this is set to `dist` (the default), the npm
tarball will be placed under `dist/js/boom-boom-1.2.3.tg`.

---

##### ~~`artifactsJavascriptDirectory`~~<sup>Required</sup> <a name="artifactsJavascriptDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.artifactsJavascriptDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getArtifactsJavascriptDirectory();
```

- *Type:* java.lang.String

The location of the npm tarball after build (`${artifactsDirectory}/js`).

---

##### ~~`bundler`~~<sup>Required</sup> <a name="bundler" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.bundler"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Bundler getBundler();
```

- *Type:* io.github.cdklabs.projen.javascript.Bundler

---

##### ~~`entrypoint`~~<sup>Required</sup> <a name="entrypoint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.entrypoint"></a>

- *Deprecated:* use `package.entrypoint`

```java
public java.lang.String getEntrypoint();
```

- *Type:* java.lang.String

---

##### ~~`manifest`~~<sup>Required</sup> <a name="manifest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.manifest"></a>

- *Deprecated:* use `package.addField(x, y)`

```java
public java.lang.Object getManifest();
```

- *Type:* java.lang.Object

---

##### ~~`npmrc`~~<sup>Required</sup> <a name="npmrc" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public NpmConfig getNpmrc();
```

- *Type:* io.github.cdklabs.projen.javascript.NpmConfig

The .npmrc file.

---

##### ~~`package`~~<sup>Required</sup> <a name="package" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.package"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public NodePackage getPackage();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackage

API for managing the node package.

---

##### ~~`packageManager`~~<sup>Required</sup> <a name="packageManager" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.packageManager"></a>

- *Deprecated:* use `package.packageManager`

```java
public NodePackageManager getPackageManager();
```

- *Type:* io.github.cdklabs.projen.javascript.NodePackageManager

The package manager to use.

---

##### ~~`runScriptCommand`~~<sup>Required</sup> <a name="runScriptCommand" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.runScriptCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getRunScriptCommand();
```

- *Type:* java.lang.String

The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).

---

##### ~~`autoMerge`~~<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.autoMerge"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public AutoMerge getAutoMerge();
```

- *Type:* io.github.cdklabs.projen.github.AutoMerge

Component that sets up mergify for merging approved pull requests.

---

##### ~~`buildWorkflow`~~<sup>Optional</sup> <a name="buildWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public BuildWorkflow getBuildWorkflow();
```

- *Type:* io.github.cdklabs.projen.build.BuildWorkflow

The PR build GitHub workflow.

`undefined` if `buildWorkflow` is disabled.

---

##### ~~`buildWorkflowJobId`~~<sup>Optional</sup> <a name="buildWorkflowJobId" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.buildWorkflowJobId"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getBuildWorkflowJobId();
```

- *Type:* java.lang.String

The job ID of the build workflow.

---

##### ~~`jest`~~<sup>Optional</sup> <a name="jest" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.jest"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Jest getJest();
```

- *Type:* io.github.cdklabs.projen.javascript.Jest

The Jest configuration (if enabled).

---

##### ~~`maxNodeVersion`~~<sup>Optional</sup> <a name="maxNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.maxNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getMaxNodeVersion();
```

- *Type:* java.lang.String

Maximum node version required by this package.

---

##### ~~`minNodeVersion`~~<sup>Optional</sup> <a name="minNodeVersion" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.minNodeVersion"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getMinNodeVersion();
```

- *Type:* java.lang.String

Minimum node.js version required by this package.

---

##### ~~`npmignore`~~<sup>Optional</sup> <a name="npmignore" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.npmignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IgnoreFile getNpmignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

The .npmignore file.

---

##### ~~`prettier`~~<sup>Optional</sup> <a name="prettier" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.prettier"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Prettier getPrettier();
```

- *Type:* io.github.cdklabs.projen.javascript.Prettier

---

##### ~~`publisher`~~<sup>Optional</sup> <a name="publisher" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.publisher"></a>

- *Deprecated:* use `release.publisher`.

```java
public Publisher getPublisher();
```

- *Type:* io.github.cdklabs.projen.release.Publisher

Package publisher.

This will be `undefined` if the project does not have a
release workflow.

---

##### ~~`release`~~<sup>Optional</sup> <a name="release" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.release"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Release getRelease();
```

- *Type:* io.github.cdklabs.projen.release.Release

Release management.

---

##### ~~`upgradeWorkflow`~~<sup>Optional</sup> <a name="upgradeWorkflow" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.upgradeWorkflow"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public UpgradeDependencies getUpgradeWorkflow();
```

- *Type:* io.github.cdklabs.projen.javascript.UpgradeDependencies

The upgrade workflow.

---

##### ~~`docsDirectory`~~<sup>Required</sup> <a name="docsDirectory" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docsDirectory"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDocsDirectory();
```

- *Type:* java.lang.String

---

##### ~~`libdir`~~<sup>Required</sup> <a name="libdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.libdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getLibdir();
```

- *Type:* java.lang.String

The directory in which compiled .js files reside.

---

##### ~~`srcdir`~~<sup>Required</sup> <a name="srcdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.srcdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSrcdir();
```

- *Type:* java.lang.String

The directory in which the .ts sources reside.

---

##### ~~`testdir`~~<sup>Required</sup> <a name="testdir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.testdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getTestdir();
```

- *Type:* java.lang.String

The directory in which tests reside.

---

##### ~~`tsconfigDev`~~<sup>Required</sup> <a name="tsconfigDev" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigDev"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public TypescriptConfig getTsconfigDev();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

A typescript configuration file which covers all files (sources, tests, projen).

---

##### ~~`watchTask`~~<sup>Required</sup> <a name="watchTask" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.watchTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getWatchTask();
```

- *Type:* io.github.cdklabs.projen.Task

The "watch" task.

---

##### ~~`docgen`~~<sup>Optional</sup> <a name="docgen" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.docgen"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getDocgen();
```

- *Type:* java.lang.Boolean

---

##### ~~`eslint`~~<sup>Optional</sup> <a name="eslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.eslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Eslint getEslint();
```

- *Type:* io.github.cdklabs.projen.javascript.Eslint

---

##### ~~`tsconfig`~~<sup>Optional</sup> <a name="tsconfig" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfig"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public TypescriptConfig getTsconfig();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

---

##### ~~`tsconfigEslint`~~<sup>Optional</sup> <a name="tsconfigEslint" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.tsconfigEslint"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public TypescriptConfig getTsconfigEslint();
```

- *Type:* io.github.cdklabs.projen.javascript.TypescriptConfig

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Required</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean

Force to generate code and docs even if there were no changes in spec.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.Map<java.lang.String, Project> getGeneratedClients();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.Project>

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedTypescriptClient`~~<sup>Required</sup> <a name="generatedTypescriptClient" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.generatedTypescriptClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public TypeScriptProject getGeneratedTypescriptClient();
```

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProject

A reference to the generated typescript client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecDir();
```

- *Type:* java.lang.String

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecFileName();
```

- *Type:* java.lang.String

The name of the spec file.

---

##### ~~`pnpmWorkspace`~~<sup>Optional</sup> <a name="pnpmWorkspace" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.pnpmWorkspace"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public YamlFile getPnpmWorkspace();
```

- *Type:* io.github.cdklabs.projen.YamlFile

Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated typescript client when this project is used in a monorepo, and the package manager is PNPM.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayTsProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayJavaProject <a name="SmithyApiGatewayJavaProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject"></a>

Synthesizes a Java Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyApiGatewayJavaProject;

SmithyApiGatewayJavaProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .artifactId(java.lang.String)
    .groupId(java.lang.String)
    .version(java.lang.String)
//  .description(java.lang.String)
//  .packaging(java.lang.String)
//  .url(java.lang.String)
//  .compileOptions(MavenCompileOptions)
//  .deps(java.util.List<java.lang.String>)
//  .distdir(java.lang.String)
//  .junit(java.lang.Boolean)
//  .junitOptions(JunitOptions)
//  .packagingOptions(MavenPackagingOptions)
//  .projenrcJava(java.lang.Boolean)
//  .projenrcJavaOptions(ProjenrcOptions)
//  .testDeps(java.util.List<java.lang.String>)
//  .sample(java.lang.Boolean)
//  .sampleJavaPackage(java.lang.String)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .serviceName(SmithyServiceName)
//  .ignoreGradleWrapper(java.lang.Boolean)
//  .ignoreSmithyBuildOutput(java.lang.Boolean)
//  .modelDir(java.lang.String)
//  .smithyBuildOptions(SmithyBuildOptions)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.artifactId">artifactId</a></code> | <code>java.lang.String</code> | The artifactId is generally the name that the project is known by. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.groupId">groupId</a></code> | <code>java.lang.String</code> | This is generally unique amongst an organization or a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.version">version</a></code> | <code>java.lang.String</code> | This is the last piece of the naming puzzle. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | Description of a project is always good. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packaging">packaging</a></code> | <code>java.lang.String</code> | Project packaging format. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.url">url</a></code> | <code>java.lang.String</code> | The URL, like the name, is not required. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.compileOptions">compileOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenCompileOptions</code> | Compile options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.distdir">distdir</a></code> | <code>java.lang.String</code> | Final artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junit">junit</a></code> | <code>java.lang.Boolean</code> | Include junit tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junitOptions">junitOptions</a></code> | <code>io.github.cdklabs.projen.java.JunitOptions</code> | junit options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packagingOptions">packagingOptions</a></code> | <code>io.github.cdklabs.projen.java.MavenPackagingOptions</code> | Packaging options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJava">projenrcJava</a></code> | <code>java.lang.Boolean</code> | Use projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions">projenrcJavaOptions</a></code> | <code>io.github.cdklabs.projen.java.ProjenrcOptions</code> | Options related to projenrc in java. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.testDeps">testDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of test dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage">sampleJavaPackage</a></code> | <code>java.lang.String</code> | The java package to use for the code sample. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.modelDir">modelDir</a></code> | <code>java.lang.String</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.artifactId"></a>

- *Type:* java.lang.String
- *Default:* "my-app"

The artifactId is generally the name that the project is known by.

Although
the groupId is important, people within the group will rarely mention the
groupId in discussion (they are often all be the same ID, such as the
MojoHaus project groupId: org.codehaus.mojo). It, along with the groupId,
creates a key that separates this project from every other project in the
world (at least, it should :) ). Along with the groupId, the artifactId
fully defines the artifact's living quarters within the repository. In the
case of the above project, my-project lives in
$M2_REPO/org/codehaus/mojo/my-project.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.groupId"></a>

- *Type:* java.lang.String
- *Default:* "org.acme"

This is generally unique amongst an organization or a project.

For example,
all core Maven artifacts do (well, should) live under the groupId
org.apache.maven. Group ID's do not necessarily use the dot notation, for
example, the junit project. Note that the dot-notated groupId does not have
to correspond to the package structure that the project contains. It is,
however, a good practice to follow. When stored within a repository, the
group acts much like the Java packaging structure does in an operating
system. The dots are replaced by OS specific directory separators (such as
'/' in Unix) which becomes a relative directory structure from the base
repository. In the example given, the org.codehaus.mojo group lives within
the directory $M2_REPO/org/codehaus/mojo.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.version"></a>

- *Type:* java.lang.String
- *Default:* "0.1.0"

This is the last piece of the naming puzzle.

groupId:artifactId denotes a
single project but they cannot delineate which incarnation of that project
we are talking about. Do we want the junit:junit of 2018 (version 4.12), or
of 2007 (version 3.8.2)? In short: code changes, those changes should be
versioned, and this element keeps those versions in line. It is also used
within an artifact's repository to separate versions from each other.
my-project version 1.0 files live in the directory structure
$M2_REPO/org/codehaus/mojo/my-project/1.0.

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String
- *Default:* undefined

Description of a project is always good.

Although this should not replace
formal documentation, a quick comment to any readers of the POM is always
helpful.

---

##### `packaging`<sup>Optional</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packaging"></a>

- *Type:* java.lang.String
- *Default:* "jar"

Project packaging format.

---

##### `url`<sup>Optional</sup> <a name="url" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.url"></a>

- *Type:* java.lang.String
- *Default:* undefined

The URL, like the name, is not required.

This is a nice gesture for
projects users, however, so that they know where the project lives.

---

##### `compileOptions`<sup>Optional</sup> <a name="compileOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.compileOptions"></a>

- *Type:* io.github.cdklabs.projen.java.MavenCompileOptions
- *Default:* defaults

Compile options.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `distdir`<sup>Optional</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.distdir"></a>

- *Type:* java.lang.String
- *Default:* "dist/java"

Final artifact output directory.

---

##### `junit`<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junit"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include junit tests.

---

##### `junitOptions`<sup>Optional</sup> <a name="junitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.junitOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JunitOptions
- *Default:* defaults

junit options.

---

##### `packagingOptions`<sup>Optional</sup> <a name="packagingOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.packagingOptions"></a>

- *Type:* io.github.cdklabs.projen.java.MavenPackagingOptions
- *Default:* defaults

Packaging options.

---

##### `projenrcJava`<sup>Optional</sup> <a name="projenrcJava" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJava"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in java.

This will install `projen` as a java dependency and will add a `synth` task which
will compile & execute `main()` from `src/main/java/projenrc.java`.

---

##### `projenrcJavaOptions`<sup>Optional</sup> <a name="projenrcJavaOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.projenrcJavaOptions"></a>

- *Type:* io.github.cdklabs.projen.java.ProjenrcOptions
- *Default:* default options

Options related to projenrc in java.

---

##### `testDeps`<sup>Optional</sup> <a name="testDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.testDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of test dependencies for this project.

Dependencies use the format: `<groupId>/<artifactId>@<semver>`

Additional dependencies can be added via `project.addTestDependency()`.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sample"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `sampleJavaPackage`<sup>Optional</sup> <a name="sampleJavaPackage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.sampleJavaPackage"></a>

- *Type:* java.lang.String
- *Default:* "org.acme"

The java package to use for the code sample.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.clientLanguages"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.documentationFormats"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.serviceName"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreGradleWrapper"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.ignoreSmithyBuildOutput"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.modelDir"></a>

- *Type:* java.lang.String
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.Initializer.parameter.smithyBuildOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin">addPlugin</a></code> | Adds a build plugin to the pom. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency">addTestDependency</a></code> | Adds a test dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String _pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* java.lang.String

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency"></a>

```java
public void addDependency(java.lang.String spec)
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<groupId>/<artifactId>@<semver>`.

---

##### ~~`addPlugin`~~ <a name="addPlugin" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin"></a>

```java
public Dependency addPlugin(java.lang.String spec)
public Dependency addPlugin(java.lang.String spec, PluginOptions options)
```

Adds a build plugin to the pom.

The plug in is also added as a BUILD dep to the project.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.spec"></a>

- *Type:* java.lang.String

dependency spec (`group/artifact@version`).

---

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addPlugin.parameter.options"></a>

- *Type:* io.github.cdklabs.projen.java.PluginOptions

plugin options.

---

##### ~~`addTestDependency`~~ <a name="addTestDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency"></a>

```java
public void addTestDependency(java.lang.String spec)
```

Adds a test dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.addTestDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<groupId>/<artifactId>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.subprojects">subprojects</a></code> | <code>java.util.List<io.github.cdklabs.projen.Project></code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compile">compile</a></code> | <code>io.github.cdklabs.projen.java.MavenCompile</code> | Compile component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.distdir">distdir</a></code> | <code>java.lang.String</code> | Maven artifact output directory. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packaging">packaging</a></code> | <code>io.github.cdklabs.projen.java.MavenPackaging</code> | Packaging component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.pom">pom</a></code> | <code>io.github.cdklabs.projen.java.Pom</code> | API for managing `pom.xml`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.junit">junit</a></code> | <code>io.github.cdklabs.projen.java.Junit</code> | JUnit component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenrc">projenrc</a></code> | <code>io.github.cdklabs.projen.java.Projenrc</code> | Projenrc component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedClients">generatedClients</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.Project></code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedJavaClient">generatedJavaClient</a></code> | <code>io.github.cdklabs.projen.java.JavaProject</code> | A reference to the generated java client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specDir">specDir</a></code> | <code>java.lang.String</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specFileName">specFileName</a></code> | <code>java.lang.String</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getCommitGenerated();
```

- *Type:* java.lang.Boolean

Whether to commit the managed files by default.

---

##### ~~`compileTask`~~<sup>Required</sup> <a name="compileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`components`~~<sup>Required</sup> <a name="components" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.components"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Component> getComponents();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Component>

Returns all the components within this project.

---

##### ~~`deps`~~<sup>Required</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.deps"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Dependencies getDeps();
```

- *Type:* io.github.cdklabs.projen.Dependencies

Project dependencies.

---

##### ~~`ejected`~~<sup>Required</sup> <a name="ejected" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.ejected"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getEjected();
```

- *Type:* java.lang.Boolean

Whether or not the project is being ejected.

---

##### ~~`files`~~<sup>Required</sup> <a name="files" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.files"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<FileBase> getFiles();
```

- *Type:* java.util.List<io.github.cdklabs.projen.FileBase>

All files in this project.

---

##### ~~`gitattributes`~~<sup>Required</sup> <a name="gitattributes" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitattributes"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitAttributesFile getGitattributes();
```

- *Type:* io.github.cdklabs.projen.GitAttributesFile

The .gitattributes file for this repository.

---

##### ~~`gitignore`~~<sup>Required</sup> <a name="gitignore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitignore"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public IgnoreFile getGitignore();
```

- *Type:* io.github.cdklabs.projen.IgnoreFile

.gitignore.

---

##### ~~`logger`~~<sup>Required</sup> <a name="logger" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.logger"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Logger getLogger();
```

- *Type:* io.github.cdklabs.projen.Logger

Logging utilities.

---

##### ~~`name`~~<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.name"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

Project name.

---

##### ~~`outdir`~~<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.outdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getOutdir();
```

- *Type:* java.lang.String

Absolute output directory of this project.

---

##### ~~`packageTask`~~<sup>Required</sup> <a name="packageTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packageTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPackageTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`postCompileTask`~~<sup>Required</sup> <a name="postCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.postCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPostCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`preCompileTask`~~<sup>Required</sup> <a name="preCompileTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.preCompileTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getPreCompileTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`projectBuild`~~<sup>Required</sup> <a name="projectBuild" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectBuild"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectBuild getProjectBuild();
```

- *Type:* io.github.cdklabs.projen.ProjectBuild

Manages the build process of the project.

---

##### ~~`projenCommand`~~<sup>Required</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenCommand"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getProjenCommand();
```

- *Type:* java.lang.String

The command to use in order to run the projen CLI.

---

##### ~~`root`~~<sup>Required</sup> <a name="root" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.root"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getRoot();
```

- *Type:* io.github.cdklabs.projen.Project

The root project.

---

##### ~~`subprojects`~~<sup>Required</sup> <a name="subprojects" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.subprojects"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.List<Project> getSubprojects();
```

- *Type:* java.util.List<io.github.cdklabs.projen.Project>

Returns all the subprojects within this project.

---

##### ~~`tasks`~~<sup>Required</sup> <a name="tasks" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.tasks"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Tasks getTasks();
```

- *Type:* io.github.cdklabs.projen.Tasks

Project tasks.

---

##### ~~`testTask`~~<sup>Required</sup> <a name="testTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.testTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getTestTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`defaultTask`~~<sup>Optional</sup> <a name="defaultTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.defaultTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getDefaultTask();
```

- *Type:* io.github.cdklabs.projen.Task

This is the "default" task, the one that executes "projen".

Undefined if
the project is being ejected.

---

##### ~~`initProject`~~<sup>Optional</sup> <a name="initProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.initProject"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public InitProject getInitProject();
```

- *Type:* io.github.cdklabs.projen.InitProject

The options used when this project is bootstrapped via `projen new`.

It
includes the original set of options passed to the CLI and also the JSII
FQN of the project type.

---

##### ~~`parent`~~<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.parent"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Project getParent();
```

- *Type:* io.github.cdklabs.projen.Project

A parent project.

If undefined, this is the root project.

---

##### ~~`projectType`~~<sup>Required</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projectType"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public ProjectType getProjectType();
```

- *Type:* io.github.cdklabs.projen.ProjectType

---

##### ~~`autoApprove`~~<sup>Optional</sup> <a name="autoApprove" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.autoApprove"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public AutoApprove getAutoApprove();
```

- *Type:* io.github.cdklabs.projen.github.AutoApprove

Auto approve set up for this project.

---

##### ~~`devContainer`~~<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.devContainer"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public DevContainer getDevContainer();
```

- *Type:* io.github.cdklabs.projen.vscode.DevContainer

Access for .devcontainer.json (used for GitHub Codespaces).

This will be `undefined` if devContainer boolean is false

---

##### ~~`github`~~<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.github"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public GitHub getGithub();
```

- *Type:* io.github.cdklabs.projen.github.GitHub

Access all github components.

This will be `undefined` for subprojects.

---

##### ~~`gitpod`~~<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.gitpod"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Gitpod getGitpod();
```

- *Type:* io.github.cdklabs.projen.Gitpod

Access for Gitpod.

This will be `undefined` if gitpod boolean is false

---

##### ~~`vscode`~~<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.vscode"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public VsCode getVscode();
```

- *Type:* io.github.cdklabs.projen.vscode.VsCode

Access all VSCode components.

This will be `undefined` for subprojects.

---

##### ~~`compile`~~<sup>Required</sup> <a name="compile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.compile"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public MavenCompile getCompile();
```

- *Type:* io.github.cdklabs.projen.java.MavenCompile

Compile component.

---

##### ~~`distdir`~~<sup>Required</sup> <a name="distdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.distdir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDistdir();
```

- *Type:* java.lang.String

Maven artifact output directory.

---

##### ~~`packaging`~~<sup>Required</sup> <a name="packaging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.packaging"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public MavenPackaging getPackaging();
```

- *Type:* io.github.cdklabs.projen.java.MavenPackaging

Packaging component.

---

##### ~~`pom`~~<sup>Required</sup> <a name="pom" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.pom"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Pom getPom();
```

- *Type:* io.github.cdklabs.projen.java.Pom

API for managing `pom.xml`.

---

##### ~~`junit`~~<sup>Optional</sup> <a name="junit" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.junit"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Junit getJunit();
```

- *Type:* io.github.cdklabs.projen.java.Junit

JUnit component.

---

##### ~~`projenrc`~~<sup>Optional</sup> <a name="projenrc" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.projenrc"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Projenrc getProjenrc();
```

- *Type:* io.github.cdklabs.projen.java.Projenrc

Projenrc component.

---

##### ~~`apiSrcDir`~~<sup>Required</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.apiSrcDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getApiSrcDir();
```

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

This will also be used
as the package for the api project.

---

##### ~~`generatedClients`~~<sup>Required</sup> <a name="generatedClients" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedClients"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.util.Map<java.lang.String, Project> getGeneratedClients();
```

- *Type:* java.util.Map<java.lang.String, io.github.cdklabs.projen.Project>

References to the client projects that were generated, keyed by language.

---

##### ~~`generatedCodeDir`~~<sup>Required</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedCodeDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getGeneratedCodeDir();
```

- *Type:* java.lang.String

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### ~~`generatedJavaClient`~~<sup>Required</sup> <a name="generatedJavaClient" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.generatedJavaClient"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public JavaProject getGeneratedJavaClient();
```

- *Type:* io.github.cdklabs.projen.java.JavaProject

A reference to the generated java client.

---

##### ~~`specDir`~~<sup>Required</sup> <a name="specDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specDir"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecDir();
```

- *Type:* java.lang.String

The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir.

---

##### ~~`specFileName`~~<sup>Required</sup> <a name="specFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.specFileName"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getSpecFileName();
```

- *Type:* java.lang.String

The name of the spec file.

---

##### ~~`forceGenerateCodeAndDocs`~~<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.forceGenerateCodeAndDocs"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.Boolean getForceGenerateCodeAndDocs();
```

- *Type:* java.lang.Boolean

Force to generate code and docs even if there were no changes in spec.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.DEFAULT_TASK">DEFAULT_TASK</a></code> | <code>java.lang.String</code> | The name of the default task (the task executed when `projen` is run without arguments). |

---

##### ~~`DEFAULT_TASK`~~<sup>Required</sup> <a name="DEFAULT_TASK" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject.property.DEFAULT_TASK"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public java.lang.String getDefaultTask();
```

- *Type:* java.lang.String

The name of the default task (the task executed when `projen` is run without arguments).

Normally
this task should synthesize the project files.

---

### SmithyApiGatewayPythonProject <a name="SmithyApiGatewayPythonProject" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject"></a>

Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer"></a>

```java
import software.aws.awsprototypingsdk.openapigateway.SmithyApiGatewayPythonProject;

SmithyApiGatewayPythonProject.Builder.create()
    .name(java.lang.String)
//  .commitGenerated(java.lang.Boolean)
//  .gitIgnoreOptions(IgnoreFileOptions)
//  .gitOptions(GitOptions)
//  .logging(LoggerOptions)
//  .outdir(java.lang.String)
//  .parent(Project)
//  .projenCommand(java.lang.String)
//  .projenrcJson(java.lang.Boolean)
//  .projenrcJsonOptions(ProjenrcJsonOptions)
//  .renovatebot(java.lang.Boolean)
//  .renovatebotOptions(RenovatebotOptions)
//  .autoApproveOptions(AutoApproveOptions)
//  .autoMerge(java.lang.Boolean)
//  .autoMergeOptions(AutoMergeOptions)
//  .clobber(java.lang.Boolean)
//  .devContainer(java.lang.Boolean)
//  .github(java.lang.Boolean)
//  .githubOptions(GitHubOptions)
//  .gitpod(java.lang.Boolean)
//  .mergify(java.lang.Boolean)
//  .mergifyOptions(MergifyOptions)
//  .projectType(ProjectType)
//  .projenCredentials(GithubCredentials)
//  .projenTokenSecret(java.lang.String)
//  .readme(SampleReadmeProps)
//  .stale(java.lang.Boolean)
//  .staleOptions(StaleOptions)
//  .vscode(java.lang.Boolean)
    .authorEmail(java.lang.String)
    .authorName(java.lang.String)
    .version(java.lang.String)
//  .classifiers(java.util.List<java.lang.String>)
//  .description(java.lang.String)
//  .homepage(java.lang.String)
//  .license(java.lang.String)
//  .packageName(java.lang.String)
//  .poetryOptions(PoetryPyprojectOptionsWithoutDeps)
//  .setupConfig(java.util.Map<java.lang.String, java.lang.Object>)
    .moduleName(java.lang.String)
//  .deps(java.util.List<java.lang.String>)
//  .devDeps(java.util.List<java.lang.String>)
//  .pip(java.lang.Boolean)
//  .poetry(java.lang.Boolean)
//  .projenrcJs(java.lang.Boolean)
//  .projenrcJsOptions(ProjenrcOptions)
//  .projenrcPython(java.lang.Boolean)
//  .projenrcPythonOptions(ProjenrcOptions)
//  .projenrcTs(java.lang.Boolean)
//  .projenrcTsOptions(ProjenrcTsOptions)
//  .pytest(java.lang.Boolean)
//  .pytestOptions(PytestOptions)
//  .pythonExec(java.lang.String)
//  .sample(java.lang.Boolean)
//  .setuptools(java.lang.Boolean)
//  .venv(java.lang.Boolean)
//  .venvOptions(VenvOptions)
    .clientLanguages(java.util.List<ClientLanguage>)
//  .apiSrcDir(java.lang.String)
//  .documentationFormats(java.util.List<DocumentationFormat>)
//  .forceGenerateCodeAndDocs(java.lang.Boolean)
//  .generatedCodeDir(java.lang.String)
//  .javaClientOptions(JavaProjectOptions)
//  .parsedSpecFileName(java.lang.String)
//  .pythonClientOptions(PythonProjectOptions)
//  .typescriptClientOptions(TypeScriptProjectOptions)
    .serviceName(SmithyServiceName)
//  .ignoreGradleWrapper(java.lang.Boolean)
//  .ignoreSmithyBuildOutput(java.lang.Boolean)
//  .modelDir(java.lang.String)
//  .smithyBuildOptions(SmithyBuildOptions)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | This is the name of your project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions">gitIgnoreOptions</a></code> | <code>io.github.cdklabs.projen.IgnoreFileOptions</code> | Configuration options for .gitignore file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitOptions">gitOptions</a></code> | <code>io.github.cdklabs.projen.GitOptions</code> | Configuration options for git. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.logging">logging</a></code> | <code>io.github.cdklabs.projen.LoggerOptions</code> | Configure logging options such as verbosity. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.outdir">outdir</a></code> | <code>java.lang.String</code> | The root directory of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | The parent project, if this project is part of a bigger project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The shell command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJson">projenrcJson</a></code> | <code>java.lang.Boolean</code> | Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions">projenrcJsonOptions</a></code> | <code>io.github.cdklabs.projen.ProjenrcJsonOptions</code> | Options for .projenrc.json. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebot">renovatebot</a></code> | <code>java.lang.Boolean</code> | Use renovatebot to handle dependency upgrades. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebotOptions">renovatebotOptions</a></code> | <code>io.github.cdklabs.projen.RenovatebotOptions</code> | Options for renovatebot. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoApproveOptions">autoApproveOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoApproveOptions</code> | Enable and configure the 'auto approve' workflow. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMerge">autoMerge</a></code> | <code>java.lang.Boolean</code> | Enable automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMergeOptions">autoMergeOptions</a></code> | <code>io.github.cdklabs.projen.github.AutoMergeOptions</code> | Configure options for automatic merging on GitHub. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clobber">clobber</a></code> | <code>java.lang.Boolean</code> | Add a `clobber` task which resets the repo to origin. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devContainer">devContainer</a></code> | <code>java.lang.Boolean</code> | Add a VSCode development environment (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.github">github</a></code> | <code>java.lang.Boolean</code> | Enable GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.githubOptions">githubOptions</a></code> | <code>io.github.cdklabs.projen.github.GitHubOptions</code> | Options for GitHub integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitpod">gitpod</a></code> | <code>java.lang.Boolean</code> | Add a Gitpod development environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergify">mergify</a></code> | <code>java.lang.Boolean</code> | Whether mergify should be enabled on this repository or not. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergifyOptions">mergifyOptions</a></code> | <code>io.github.cdklabs.projen.github.MergifyOptions</code> | Options for mergify. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | Which type of project this is (library/app). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCredentials">projenCredentials</a></code> | <code>io.github.cdklabs.projen.github.GithubCredentials</code> | Choose a method of providing GitHub API access for projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenTokenSecret">projenTokenSecret</a></code> | <code>java.lang.String</code> | The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.readme">readme</a></code> | <code>io.github.cdklabs.projen.SampleReadmeProps</code> | The README setup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.stale">stale</a></code> | <code>java.lang.Boolean</code> | Auto-close of stale issues and pull request. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.staleOptions">staleOptions</a></code> | <code>io.github.cdklabs.projen.github.StaleOptions</code> | Auto-close stale issues and pull requests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.vscode">vscode</a></code> | <code>java.lang.Boolean</code> | Enable VSCode integration. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorEmail">authorEmail</a></code> | <code>java.lang.String</code> | Author's e-mail. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorName">authorName</a></code> | <code>java.lang.String</code> | Author's name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.version">version</a></code> | <code>java.lang.String</code> | Version of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.classifiers">classifiers</a></code> | <code>java.util.List<java.lang.String></code> | A list of PyPI trove classifiers that describe the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | A short description of the package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.homepage">homepage</a></code> | <code>java.lang.String</code> | A URL to the website of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.license">license</a></code> | <code>java.lang.String</code> | License of this package as an SPDX identifier. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.packageName">packageName</a></code> | <code>java.lang.String</code> | Package name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetryOptions">poetryOptions</a></code> | <code>io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps</code> | Additional options to set for poetry if using poetry. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setupConfig">setupConfig</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | Additional fields to pass in the setup() function if using setuptools. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Name of the python package as used in imports and filenames. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.deps">deps</a></code> | <code>java.util.List<java.lang.String></code> | List of runtime dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devDeps">devDeps</a></code> | <code>java.util.List<java.lang.String></code> | List of dev dependencies for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pip">pip</a></code> | <code>java.lang.Boolean</code> | Use pip with a requirements.txt file to track project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetry">poetry</a></code> | <code>java.lang.Boolean</code> | Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJs">projenrcJs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in javascript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions">projenrcJsOptions</a></code> | <code>io.github.cdklabs.projen.javascript.ProjenrcOptions</code> | Options related to projenrc in JavaScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPython">projenrcPython</a></code> | <code>java.lang.Boolean</code> | Use projenrc in Python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions">projenrcPythonOptions</a></code> | <code>io.github.cdklabs.projen.python.ProjenrcOptions</code> | Options related to projenrc in python. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTs">projenrcTs</a></code> | <code>java.lang.Boolean</code> | Use projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions">projenrcTsOptions</a></code> | <code>io.github.cdklabs.projen.typescript.ProjenrcTsOptions</code> | Options related to projenrc in TypeScript. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytest">pytest</a></code> | <code>java.lang.Boolean</code> | Include pytest tests. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytestOptions">pytestOptions</a></code> | <code>io.github.cdklabs.projen.python.PytestOptions</code> | pytest options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonExec">pythonExec</a></code> | <code>java.lang.String</code> | Path to the python executable to use. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.sample">sample</a></code> | <code>java.lang.Boolean</code> | Include sample code and test if the relevant directories don't exist. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setuptools">setuptools</a></code> | <code>java.lang.Boolean</code> | Use setuptools with a setup.py script for packaging and publishing. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venv">venv</a></code> | <code>java.lang.Boolean</code> | Use venv to manage a virtual environment for installing dependencies inside. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venvOptions">venvOptions</a></code> | <code>io.github.cdklabs.projen.python.VenvOptions</code> | Venv options. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clientLanguages">clientLanguages</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>></code> | The list of languages for which clients will be generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.documentationFormats">documentationFormats</a></code> | <code>java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>></code> | Formats to generate documentation in. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.javaClientOptions">javaClientOptions</a></code> | <code>io.github.cdklabs.projen.java.JavaProjectOptions</code> | Options for the generated java client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName">parsedSpecFileName</a></code> | <code>java.lang.String</code> | The name of the output parsed OpenAPI specification file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonClientOptions">pythonClientOptions</a></code> | <code>io.github.cdklabs.projen.python.PythonProjectOptions</code> | Options for the generated python client (if specified in clientLanguages). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions">typescriptClientOptions</a></code> | <code>io.github.cdklabs.projen.typescript.TypeScriptProjectOptions</code> | Options for the generated typescript client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.serviceName">serviceName</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a></code> | The name of the Smithy service from your model which will be targeted for deployment and client generation. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreGradleWrapper">ignoreGradleWrapper</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your gradle wrapper. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreSmithyBuildOutput">ignoreSmithyBuildOutput</a></code> | <code>java.lang.Boolean</code> | Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.modelDir">modelDir</a></code> | <code>java.lang.String</code> | The path to the Smithy model directory, relative to the project source directory (srcdir). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.smithyBuildOptions">smithyBuildOptions</a></code> | <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a></code> | Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like. |

---

##### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.name"></a>

- *Type:* java.lang.String
- *Default:* $BASEDIR

This is the name of your project.

---

##### `commitGenerated`<sup>Optional</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.commitGenerated"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Whether to commit the managed files by default.

---

##### `gitIgnoreOptions`<sup>Optional</sup> <a name="gitIgnoreOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitIgnoreOptions"></a>

- *Type:* io.github.cdklabs.projen.IgnoreFileOptions

Configuration options for .gitignore file.

---

##### `gitOptions`<sup>Optional</sup> <a name="gitOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitOptions"></a>

- *Type:* io.github.cdklabs.projen.GitOptions

Configuration options for git.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.logging"></a>

- *Type:* io.github.cdklabs.projen.LoggerOptions
- *Default:* {}

Configure logging options such as verbosity.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.outdir"></a>

- *Type:* java.lang.String
- *Default:* "."

The root directory of the project.

Relative to this directory, all files are synthesized.

If this project has a parent, this directory is relative to the parent
directory and it cannot be the same as the parent or any of it's other
sub-projects.

---

##### `parent`<sup>Optional</sup> <a name="parent" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parent"></a>

- *Type:* io.github.cdklabs.projen.Project

The parent project, if this project is part of a bigger project.

---

##### `projenCommand`<sup>Optional</sup> <a name="projenCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCommand"></a>

- *Type:* java.lang.String
- *Default:* "npx projen"

The shell command to use in order to run the projen CLI.

Can be used to customize in special environments.

---

##### `projenrcJson`<sup>Optional</sup> <a name="projenrcJson" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJson"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Generate (once) .projenrc.json (in JSON). Set to `false` in order to disable .projenrc.json generation.

---

##### `projenrcJsonOptions`<sup>Optional</sup> <a name="projenrcJsonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsonOptions"></a>

- *Type:* io.github.cdklabs.projen.ProjenrcJsonOptions
- *Default:* default options

Options for .projenrc.json.

---

##### `renovatebot`<sup>Optional</sup> <a name="renovatebot" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebot"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use renovatebot to handle dependency upgrades.

---

##### `renovatebotOptions`<sup>Optional</sup> <a name="renovatebotOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.renovatebotOptions"></a>

- *Type:* io.github.cdklabs.projen.RenovatebotOptions
- *Default:* default options

Options for renovatebot.

---

##### `autoApproveOptions`<sup>Optional</sup> <a name="autoApproveOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoApproveOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoApproveOptions
- *Default:* auto approve is disabled

Enable and configure the 'auto approve' workflow.

---

##### `autoMerge`<sup>Optional</sup> <a name="autoMerge" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMerge"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable automatic merging on GitHub.

Has no effect if `github.mergify`
is set to false.

---

##### `autoMergeOptions`<sup>Optional</sup> <a name="autoMergeOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.autoMergeOptions"></a>

- *Type:* io.github.cdklabs.projen.github.AutoMergeOptions
- *Default:* see defaults in `AutoMergeOptions`

Configure options for automatic merging on GitHub.

Has no effect if
`github.mergify` or `autoMerge` is set to false.

---

##### `clobber`<sup>Optional</sup> <a name="clobber" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clobber"></a>

- *Type:* java.lang.Boolean
- *Default:* true, but false for subprojects

Add a `clobber` task which resets the repo to origin.

---

##### `devContainer`<sup>Optional</sup> <a name="devContainer" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devContainer"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a VSCode development environment (used for GitHub Codespaces).

---

##### `github`<sup>Optional</sup> <a name="github" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.github"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable GitHub integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `githubOptions`<sup>Optional</sup> <a name="githubOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.githubOptions"></a>

- *Type:* io.github.cdklabs.projen.github.GitHubOptions
- *Default:* see GitHubOptions

Options for GitHub integration.

---

##### `gitpod`<sup>Optional</sup> <a name="gitpod" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.gitpod"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Add a Gitpod development environment.

---

##### ~~`mergify`~~<sup>Optional</sup> <a name="mergify" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergify"></a>

- *Deprecated:* use `githubOptions.mergify` instead

- *Type:* java.lang.Boolean
- *Default:* true

Whether mergify should be enabled on this repository or not.

---

##### ~~`mergifyOptions`~~<sup>Optional</sup> <a name="mergifyOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.mergifyOptions"></a>

- *Deprecated:* use `githubOptions.mergifyOptions` instead

- *Type:* io.github.cdklabs.projen.github.MergifyOptions
- *Default:* default options

Options for mergify.

---

##### ~~`projectType`~~<sup>Optional</sup> <a name="projectType" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projectType"></a>

- *Deprecated:* no longer supported at the base project level

- *Type:* io.github.cdklabs.projen.ProjectType
- *Default:* ProjectType.UNKNOWN

Which type of project this is (library/app).

---

##### `projenCredentials`<sup>Optional</sup> <a name="projenCredentials" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenCredentials"></a>

- *Type:* io.github.cdklabs.projen.github.GithubCredentials
- *Default:* use a personal access token named PROJEN_GITHUB_TOKEN

Choose a method of providing GitHub API access for projen workflows.

---

##### ~~`projenTokenSecret`~~<sup>Optional</sup> <a name="projenTokenSecret" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenTokenSecret"></a>

- *Deprecated:* use `projenCredentials`

- *Type:* java.lang.String
- *Default:* "PROJEN_GITHUB_TOKEN"

The name of a secret which includes a GitHub Personal Access Token to be used by projen workflows.

This token needs to have the `repo`, `workflows`
and `packages` scope.

---

##### `readme`<sup>Optional</sup> <a name="readme" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.readme"></a>

- *Type:* io.github.cdklabs.projen.SampleReadmeProps
- *Default:* { filename: 'README.md', contents: '# replace this' }

The README setup.

---

*Example*

```java
"{ filename: 'readme.md', contents: '# title' }"
```


##### `stale`<sup>Optional</sup> <a name="stale" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.stale"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Auto-close of stale issues and pull request.

See `staleOptions` for options.

---

##### `staleOptions`<sup>Optional</sup> <a name="staleOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.staleOptions"></a>

- *Type:* io.github.cdklabs.projen.github.StaleOptions
- *Default:* see defaults in `StaleOptions`

Auto-close stale issues and pull requests.

To disable set `stale` to `false`.

---

##### `vscode`<sup>Optional</sup> <a name="vscode" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.vscode"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Enable VSCode integration.

Enabled by default for root projects. Disabled for non-root projects.

---

##### `authorEmail`<sup>Required</sup> <a name="authorEmail" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorEmail"></a>

- *Type:* java.lang.String
- *Default:* $GIT_USER_EMAIL

Author's e-mail.

---

##### `authorName`<sup>Required</sup> <a name="authorName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.authorName"></a>

- *Type:* java.lang.String
- *Default:* $GIT_USER_NAME

Author's name.

---

##### `version`<sup>Required</sup> <a name="version" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.version"></a>

- *Type:* java.lang.String
- *Default:* "0.1.0"

Version of the package.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.classifiers"></a>

- *Type:* java.util.List<java.lang.String>

A list of PyPI trove classifiers that describe the project.

> [https://pypi.org/classifiers/](https://pypi.org/classifiers/)

---

##### `description`<sup>Optional</sup> <a name="description" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.description"></a>

- *Type:* java.lang.String

A short description of the package.

---

##### `homepage`<sup>Optional</sup> <a name="homepage" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.homepage"></a>

- *Type:* java.lang.String

A URL to the website of the project.

---

##### `license`<sup>Optional</sup> <a name="license" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.license"></a>

- *Type:* java.lang.String

License of this package as an SPDX identifier.

---

##### `packageName`<sup>Optional</sup> <a name="packageName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.packageName"></a>

- *Type:* java.lang.String

Package name.

---

##### `poetryOptions`<sup>Optional</sup> <a name="poetryOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetryOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PoetryPyprojectOptionsWithoutDeps

Additional options to set for poetry if using poetry.

---

##### `setupConfig`<sup>Optional</sup> <a name="setupConfig" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setupConfig"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

Additional fields to pass in the setup() function if using setuptools.

---

##### `moduleName`<sup>Required</sup> <a name="moduleName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.moduleName"></a>

- *Type:* java.lang.String
- *Default:* $PYTHON_MODULE_NAME

Name of the python package as used in imports and filenames.

Must only consist of alphanumeric characters and underscores.

---

##### `deps`<sup>Optional</sup> <a name="deps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.deps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of runtime dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDependency()`.

---

##### `devDeps`<sup>Optional</sup> <a name="devDeps" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.devDeps"></a>

- *Type:* java.util.List<java.lang.String>
- *Default:* []

List of dev dependencies for this project.

Dependencies use the format: `<module>@<semver>`

Additional dependencies can be added via `project.addDevDependency()`.

---

##### `pip`<sup>Optional</sup> <a name="pip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pip"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use pip with a requirements.txt file to track project dependencies.

---

##### `poetry`<sup>Optional</sup> <a name="poetry" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.poetry"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use poetry to manage your project dependencies, virtual environment, and (optional) packaging/publishing.

This feature is incompatible with pip, setuptools, or venv.
If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.

---

##### `projenrcJs`<sup>Optional</sup> <a name="projenrcJs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in javascript.

This will install `projen` as a JavaScript dependency and add a `synth`
task which will run `.projenrc.js`.

---

##### `projenrcJsOptions`<sup>Optional</sup> <a name="projenrcJsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcJsOptions"></a>

- *Type:* io.github.cdklabs.projen.javascript.ProjenrcOptions
- *Default:* default options

Options related to projenrc in JavaScript.

---

##### `projenrcPython`<sup>Optional</sup> <a name="projenrcPython" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPython"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Use projenrc in Python.

This will install `projen` as a Python dependency and add a `synth`
task which will run `.projenrc.py`.

---

##### `projenrcPythonOptions`<sup>Optional</sup> <a name="projenrcPythonOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcPythonOptions"></a>

- *Type:* io.github.cdklabs.projen.python.ProjenrcOptions
- *Default:* default options

Options related to projenrc in python.

---

##### `projenrcTs`<sup>Optional</sup> <a name="projenrcTs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTs"></a>

- *Type:* java.lang.Boolean
- *Default:* false

Use projenrc in TypeScript.

This will create a tsconfig file (default: `tsconfig.projen.json`)
and use `ts-node` in the default task to parse the project source files.

---

##### `projenrcTsOptions`<sup>Optional</sup> <a name="projenrcTsOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.projenrcTsOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.ProjenrcTsOptions
- *Default:* default options

Options related to projenrc in TypeScript.

---

##### `pytest`<sup>Optional</sup> <a name="pytest" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytest"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include pytest tests.

---

##### `pytestOptions`<sup>Optional</sup> <a name="pytestOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pytestOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PytestOptions
- *Default:* defaults

pytest options.

---

##### `pythonExec`<sup>Optional</sup> <a name="pythonExec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonExec"></a>

- *Type:* java.lang.String
- *Default:* "python"

Path to the python executable to use.

---

##### `sample`<sup>Optional</sup> <a name="sample" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.sample"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Include sample code and test if the relevant directories don't exist.

---

##### `setuptools`<sup>Optional</sup> <a name="setuptools" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.setuptools"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use setuptools with a setup.py script for packaging and publishing.

---

##### `venv`<sup>Optional</sup> <a name="venv" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venv"></a>

- *Type:* java.lang.Boolean
- *Default:* true, unless poetry is true, then false

Use venv to manage a virtual environment for installing dependencies inside.

---

##### `venvOptions`<sup>Optional</sup> <a name="venvOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.venvOptions"></a>

- *Type:* io.github.cdklabs.projen.python.VenvOptions
- *Default:* defaults

Venv options.

---

##### `clientLanguages`<sup>Required</sup> <a name="clientLanguages" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.clientLanguages"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.ClientLanguage">ClientLanguage</a>>

The list of languages for which clients will be generated.

A typescript client will always be generated.

---

##### `apiSrcDir`<sup>Optional</sup> <a name="apiSrcDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.apiSrcDir"></a>

- *Type:* java.lang.String

The directory in which the api generated code will reside, relative to the project srcdir.

---

##### `documentationFormats`<sup>Optional</sup> <a name="documentationFormats" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.documentationFormats"></a>

- *Type:* java.util.List<<a href="#@aws-prototyping-sdk/open-api-gateway.DocumentationFormat">DocumentationFormat</a>>

Formats to generate documentation in.

---

##### `forceGenerateCodeAndDocs`<sup>Optional</sup> <a name="forceGenerateCodeAndDocs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.forceGenerateCodeAndDocs"></a>

- *Type:* java.lang.Boolean
- *Default:* "false"

Force to generate code and docs even if there were no changes in spec.

---

##### `generatedCodeDir`<sup>Optional</sup> <a name="generatedCodeDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.generatedCodeDir"></a>

- *Type:* java.lang.String
- *Default:* "generated"

The directory in which generated client code will be generated, relative to the outdir of this project.

---

##### `javaClientOptions`<sup>Optional</sup> <a name="javaClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.javaClientOptions"></a>

- *Type:* io.github.cdklabs.projen.java.JavaProjectOptions

Options for the generated java client (if specified in clientLanguages).

These override the default inferred options.

---

##### `parsedSpecFileName`<sup>Optional</sup> <a name="parsedSpecFileName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.parsedSpecFileName"></a>

- *Type:* java.lang.String
- *Default:* ".parsed-spec.json"

The name of the output parsed OpenAPI specification file.

Must end with .json.

---

##### `pythonClientOptions`<sup>Optional</sup> <a name="pythonClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.pythonClientOptions"></a>

- *Type:* io.github.cdklabs.projen.python.PythonProjectOptions

Options for the generated python client (if specified in clientLanguages).

These override the default inferred options.

---

##### `typescriptClientOptions`<sup>Optional</sup> <a name="typescriptClientOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.typescriptClientOptions"></a>

- *Type:* io.github.cdklabs.projen.typescript.TypeScriptProjectOptions

Options for the generated typescript client.

These override the default inferred options.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.serviceName"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyServiceName">SmithyServiceName</a>
- *Default:* "example.hello#Hello"

The name of the Smithy service from your model which will be targeted for deployment and client generation.

On initial project synthesis this service name will be written to the sample "hello world" model. If you change
this value after initial synthesis you will need to manually update your Smithy models to match, unless you delete
the "model" directory. Likewise, if you change the namespace or service name in your Smithy models you will need to
update this value to ensure your service can be found.

---

##### `ignoreGradleWrapper`<sup>Optional</sup> <a name="ignoreGradleWrapper" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreGradleWrapper"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your gradle wrapper.

Do so if you would like to use a different version
of gradle to the one provided by default

---

##### `ignoreSmithyBuildOutput`<sup>Optional</sup> <a name="ignoreSmithyBuildOutput" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.ignoreSmithyBuildOutput"></a>

- *Type:* java.lang.Boolean
- *Default:* true

Set to false if you would like to check in your smithy build output or have more fine-grained control over what is checked in, eg if you add other projections to the smithy-build.json file.

---

##### `modelDir`<sup>Optional</sup> <a name="modelDir" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.modelDir"></a>

- *Type:* java.lang.String
- *Default:* "model"

The path to the Smithy model directory, relative to the project source directory (srcdir).

---

##### `smithyBuildOptions`<sup>Optional</sup> <a name="smithyBuildOptions" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.Initializer.parameter.smithyBuildOptions"></a>

- *Type:* <a href="#@aws-prototyping-sdk/open-api-gateway.SmithyBuildOptions">SmithyBuildOptions</a>

Any additional properties you'd like to add your smithy-build.json. The smithy-build.json will automatically include the "openapi" plugin, but you can add extra configuration for that via this option if you like.

> [https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings](https://awslabs.github.io/smithy/2.0/guides/converting-to-openapi.html#openapi-configuration-settings)

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup">addExcludeFromCleanup</a></code> | Exclude the matching files from pre-synth cleanup. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore">addGitIgnore</a></code> | Adds a .gitignore pattern. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore">addPackageIgnore</a></code> | Exclude these files from the bundled package. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask">addTask</a></code> | Adds a new task to this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip">addTip</a></code> | Prints a "tip" message during synthesis. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated">annotateGenerated</a></code> | Marks the provided file(s) as being generated. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.postSynthesize">postSynthesize</a></code> | Called after all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.preSynthesize">preSynthesize</a></code> | Called before all components are synthesized. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask">removeTask</a></code> | Removes a task from a project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand">runTaskCommand</a></code> | Returns the shell command to execute in order to run a task. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.synth">synth</a></code> | Synthesize all project files into `outdir`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile">tryFindFile</a></code> | Finds a file at the specified relative path within this project and all its subprojects. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile">tryFindJsonFile</a></code> | Finds a json file by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile">tryFindObjectFile</a></code> | Finds an object file (like JsonFile, YamlFile, etc.) by name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile">tryRemoveFile</a></code> | Finds a file at the specified relative path within this project and removes it. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency">addDependency</a></code> | Adds a runtime dependency. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency">addDevDependency</a></code> | Adds a dev dependency. |

---

##### ~~`addExcludeFromCleanup`~~ <a name="addExcludeFromCleanup" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup"></a>

```java
public void addExcludeFromCleanup(java.lang.String globs)
```

Exclude the matching files from pre-synth cleanup.

Can be used when, for example, some
source files include the projen marker and we don't want them to be erased during synth.

###### `globs`<sup>Required</sup> <a name="globs" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addExcludeFromCleanup.parameter.globs"></a>

- *Type:* java.lang.String

The glob patterns to match.

---

##### ~~`addGitIgnore`~~ <a name="addGitIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore"></a>

```java
public void addGitIgnore(java.lang.String pattern)
```

Adds a .gitignore pattern.

###### `pattern`<sup>Required</sup> <a name="pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addGitIgnore.parameter.pattern"></a>

- *Type:* java.lang.String

The glob pattern to ignore.

---

##### ~~`addPackageIgnore`~~ <a name="addPackageIgnore" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore"></a>

```java
public void addPackageIgnore(java.lang.String _pattern)
```

Exclude these files from the bundled package.

Implemented by project types based on the
packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.

###### `_pattern`<sup>Required</sup> <a name="_pattern" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addPackageIgnore.parameter._pattern"></a>

- *Type:* java.lang.String

The glob pattern to exclude.

---

##### ~~`addTask`~~ <a name="addTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask"></a>

```java
public Task addTask(java.lang.String name)
public Task addTask(java.lang.String name, TaskOptions props)
```

Adds a new task to this project.

This will fail if the project already has
a task with this name.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.name"></a>

- *Type:* java.lang.String

The task name to add.

---

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTask.parameter.props"></a>

- *Type:* io.github.cdklabs.projen.TaskOptions

Task properties.

---

##### ~~`addTip`~~ <a name="addTip" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip"></a>

```java
public void addTip(java.lang.String message)
```

Prints a "tip" message during synthesis.

###### `message`<sup>Required</sup> <a name="message" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addTip.parameter.message"></a>

- *Type:* java.lang.String

The message.

---

##### ~~`annotateGenerated`~~ <a name="annotateGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated"></a>

```java
public void annotateGenerated(java.lang.String glob)
```

Marks the provided file(s) as being generated.

This is achieved using the
github-linguist attributes. Generated files do not count against the
repository statistics and language breakdown.

> [https://github.com/github/linguist/blob/master/docs/overrides.md](https://github.com/github/linguist/blob/master/docs/overrides.md)

###### `glob`<sup>Required</sup> <a name="glob" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.annotateGenerated.parameter.glob"></a>

- *Type:* java.lang.String

the glob pattern to match (could be a file path).

---

##### ~~`postSynthesize`~~ <a name="postSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.postSynthesize"></a>

```java
public void postSynthesize()
```

Called after all components are synthesized.

Order is *not* guaranteed.

##### ~~`preSynthesize`~~ <a name="preSynthesize" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.preSynthesize"></a>

```java
public void preSynthesize()
```

Called before all components are synthesized.

##### ~~`removeTask`~~ <a name="removeTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask"></a>

```java
public Task removeTask(java.lang.String name)
```

Removes a task from a project.

###### `name`<sup>Required</sup> <a name="name" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.removeTask.parameter.name"></a>

- *Type:* java.lang.String

The name of the task to remove.

---

##### ~~`runTaskCommand`~~ <a name="runTaskCommand" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand"></a>

```java
public java.lang.String runTaskCommand(Task task)
```

Returns the shell command to execute in order to run a task.

By default, this is `npx projen@<version> <task>`

###### `task`<sup>Required</sup> <a name="task" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.runTaskCommand.parameter.task"></a>

- *Type:* io.github.cdklabs.projen.Task

The task for which the command is required.

---

##### ~~`synth`~~ <a name="synth" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.synth"></a>

```java
public void synth()
```

Synthesize all project files into `outdir`.

1. Call "this.preSynthesize()"
2. Delete all generated files
3. Synthesize all sub-projects
4. Synthesize all components of this project
5. Call "postSynthesize()" for all components of this project
6. Call "this.postSynthesize()"

##### ~~`tryFindFile`~~ <a name="tryFindFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile"></a>

```java
public FileBase tryFindFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and all its subprojects.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be resolved
from the root of _this_ project.

---

##### ~~`tryFindJsonFile`~~ <a name="tryFindJsonFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile"></a>

```java
public JsonFile tryFindJsonFile(java.lang.String filePath)
```

Finds a json file by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindJsonFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryFindObjectFile`~~ <a name="tryFindObjectFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile"></a>

```java
public ObjectFile tryFindObjectFile(java.lang.String filePath)
```

Finds an object file (like JsonFile, YamlFile, etc.) by name.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryFindObjectFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

---

##### ~~`tryRemoveFile`~~ <a name="tryRemoveFile" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile"></a>

```java
public FileBase tryRemoveFile(java.lang.String filePath)
```

Finds a file at the specified relative path within this project and removes it.

###### `filePath`<sup>Required</sup> <a name="filePath" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.tryRemoveFile.parameter.filePath"></a>

- *Type:* java.lang.String

The file path.

If this path is relative, it will be
resolved from the root of _this_ project.

---

##### ~~`addDependency`~~ <a name="addDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency"></a>

```java
public void addDependency(java.lang.String spec)
```

Adds a runtime dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<module>@<semver>`.

---

##### ~~`addDevDependency`~~ <a name="addDevDependency" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency"></a>

```java
public void addDevDependency(java.lang.String spec)
```

Adds a dev dependency.

###### `spec`<sup>Required</sup> <a name="spec" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.addDevDependency.parameter.spec"></a>

- *Type:* java.lang.String

Format `<module>@<semver>`.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.buildTask">buildTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.commitGenerated">commitGenerated</a></code> | <code>java.lang.Boolean</code> | Whether to commit the managed files by default. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.compileTask">compileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.components">components</a></code> | <code>java.util.List<io.github.cdklabs.projen.Component></code> | Returns all the components within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.deps">deps</a></code> | <code>io.github.cdklabs.projen.Dependencies</code> | Project dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.ejected">ejected</a></code> | <code>java.lang.Boolean</code> | Whether or not the project is being ejected. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.files">files</a></code> | <code>java.util.List<io.github.cdklabs.projen.FileBase></code> | All files in this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitattributes">gitattributes</a></code> | <code>io.github.cdklabs.projen.GitAttributesFile</code> | The .gitattributes file for this repository. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitignore">gitignore</a></code> | <code>io.github.cdklabs.projen.IgnoreFile</code> | .gitignore. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.logger">logger</a></code> | <code>io.github.cdklabs.projen.Logger</code> | Logging utilities. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.name">name</a></code> | <code>java.lang.String</code> | Project name. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.outdir">outdir</a></code> | <code>java.lang.String</code> | Absolute output directory of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packageTask">packageTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.postCompileTask">postCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.preCompileTask">preCompileTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectBuild">projectBuild</a></code> | <code>io.github.cdklabs.projen.ProjectBuild</code> | Manages the build process of the project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projenCommand">projenCommand</a></code> | <code>java.lang.String</code> | The command to use in order to run the projen CLI. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.root">root</a></code> | <code>io.github.cdklabs.projen.Project</code> | The root project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.subprojects">subprojects</a></code> | <code>java.util.List<io.github.cdklabs.projen.Project></code> | Returns all the subprojects within this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.tasks">tasks</a></code> | <code>io.github.cdklabs.projen.Tasks</code> | Project tasks. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.testTask">testTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.defaultTask">defaultTask</a></code> | <code>io.github.cdklabs.projen.Task</code> | This is the "default" task, the one that executes "projen". |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.initProject">initProject</a></code> | <code>io.github.cdklabs.projen.InitProject</code> | The options used when this project is bootstrapped via `projen new`. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.parent">parent</a></code> | <code>io.github.cdklabs.projen.Project</code> | A parent project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.projectType">projectType</a></code> | <code>io.github.cdklabs.projen.ProjectType</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.autoApprove">autoApprove</a></code> | <code>io.github.cdklabs.projen.github.AutoApprove</code> | Auto approve set up for this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.devContainer">devContainer</a></code> | <code>io.github.cdklabs.projen.vscode.DevContainer</code> | Access for .devcontainer.json (used for GitHub Codespaces). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.github">github</a></code> | <code>io.github.cdklabs.projen.github.GitHub</code> | Access all github components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.gitpod">gitpod</a></code> | <code>io.github.cdklabs.projen.Gitpod</code> | Access for Gitpod. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.vscode">vscode</a></code> | <code>io.github.cdklabs.projen.vscode.VsCode</code> | Access all VSCode components. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.depsManager">depsManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonDeps</code> | API for managing dependencies. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.envManager">envManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonEnv</code> | API for mangaging the Python runtime environment. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.moduleName">moduleName</a></code> | <code>java.lang.String</code> | Python module name (the project name, with any hyphens or periods replaced with underscores). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.version">version</a></code> | <code>java.lang.String</code> | Version of the package for distribution (should follow semver). |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.packagingManager">packagingManager</a></code> | <code>io.github.cdklabs.projen.python.IPythonPackaging</code> | API for managing packaging the project as a library. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.pytest">pytest</a></code> | <code>io.github.cdklabs.projen.python.Pytest</code> | Pytest component. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.apiSrcDir">apiSrcDir</a></code> | <code>java.lang.String</code> | The directory in which the api generated code will reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedClients">generatedClients</a></code> | <code>java.util.Map<java.lang.String, io.github.cdklabs.projen.Project></code> | References to the client projects that were generated, keyed by language. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedCodeDir">generatedCodeDir</a></code> | <code>java.lang.String</code> | The directory in which generated client code will be generated, relative to the outdir of this project. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.generatedPythonClient">generatedPythonClient</a></code> | <code>io.github.cdklabs.projen.python.PythonProject</code> | A reference to the generated python client. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specDir">specDir</a></code> | <code>java.lang.String</code> | The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.specFileName">specFileName</a></code> | <code>java.lang.String</code> | The name of the spec file. |
| <code><a href="#@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.forceGenerateCodeAndDocs">forceGenerateCodeAndDocs</a></code> | <code>java.lang.Boolean</code> | Force to generate code and docs even if there were no changes in spec. |

---

##### ~~`buildTask`~~<sup>Required</sup> <a name="buildTask" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.buildTask"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public Task getBuildTask();
```

- *Type:* io.github.cdklabs.projen.Task

---

##### ~~`commitGenerated`~~<sup>Required</sup> <a name="commitGenerated" id="@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject.property.commitGenerated"></a>

- *Deprecated:* Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.

```java
public jav