# coding: utf-8

"""
    NetBox API

    API to access NetBox  # noqa: E501

    OpenAPI spec version: 2.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Provider(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'name': 'str',
        'slug': 'str',
        'asn': 'int',
        'account': 'str',
        'portal_url': 'str',
        'noc_contact': 'str',
        'admin_contact': 'str',
        'comments': 'str',
        'tags': 'list[str]',
        'custom_fields': 'object',
        'created': 'date',
        'last_updated': 'datetime',
        'circuit_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'slug': 'slug',
        'asn': 'asn',
        'account': 'account',
        'portal_url': 'portal_url',
        'noc_contact': 'noc_contact',
        'admin_contact': 'admin_contact',
        'comments': 'comments',
        'tags': 'tags',
        'custom_fields': 'custom_fields',
        'created': 'created',
        'last_updated': 'last_updated',
        'circuit_count': 'circuit_count'
    }

    def __init__(self, id=None, name=None, slug=None, asn=None, account=None, portal_url=None, noc_contact=None, admin_contact=None, comments=None, tags=None, custom_fields=None, created=None, last_updated=None, circuit_count=None):  # noqa: E501
        """Provider - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._slug = None
        self._asn = None
        self._account = None
        self._portal_url = None
        self._noc_contact = None
        self._admin_contact = None
        self._comments = None
        self._tags = None
        self._custom_fields = None
        self._created = None
        self._last_updated = None
        self._circuit_count = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        self.slug = slug
        if asn is not None:
            self.asn = asn
        if account is not None:
            self.account = account
        if portal_url is not None:
            self.portal_url = portal_url
        if noc_contact is not None:
            self.noc_contact = noc_contact
        if admin_contact is not None:
            self.admin_contact = admin_contact
        if comments is not None:
            self.comments = comments
        if tags is not None:
            self.tags = tags
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if created is not None:
            self.created = created
        if last_updated is not None:
            self.last_updated = last_updated
        if circuit_count is not None:
            self.circuit_count = circuit_count

    @property
    def id(self):
        """Gets the id of this Provider.  # noqa: E501


        :return: The id of this Provider.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Provider.


        :param id: The id of this Provider.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Provider.  # noqa: E501


        :return: The name of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Provider.


        :param name: The name of this Provider.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 50:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `50`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def slug(self):
        """Gets the slug of this Provider.  # noqa: E501


        :return: The slug of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this Provider.


        :param slug: The slug of this Provider.  # noqa: E501
        :type: str
        """
        if slug is None:
            raise ValueError("Invalid value for `slug`, must not be `None`")  # noqa: E501
        if slug is not None and len(slug) > 50:
            raise ValueError("Invalid value for `slug`, length must be less than or equal to `50`")  # noqa: E501
        if slug is not None and len(slug) < 1:
            raise ValueError("Invalid value for `slug`, length must be greater than or equal to `1`")  # noqa: E501
        if slug is not None and not re.search(r'^[-a-zA-Z0-9_]+$', slug):  # noqa: E501
            raise ValueError(r"Invalid value for `slug`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug = slug

    @property
    def asn(self):
        """Gets the asn of this Provider.  # noqa: E501

        32-bit autonomous system number  # noqa: E501

        :return: The asn of this Provider.  # noqa: E501
        :rtype: int
        """
        return self._asn

    @asn.setter
    def asn(self, asn):
        """Sets the asn of this Provider.

        32-bit autonomous system number  # noqa: E501

        :param asn: The asn of this Provider.  # noqa: E501
        :type: int
        """
        if asn is not None and asn > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `asn`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if asn is not None and asn < 1:  # noqa: E501
            raise ValueError("Invalid value for `asn`, must be a value greater than or equal to `1`")  # noqa: E501

        self._asn = asn

    @property
    def account(self):
        """Gets the account of this Provider.  # noqa: E501


        :return: The account of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this Provider.


        :param account: The account of this Provider.  # noqa: E501
        :type: str
        """
        if account is not None and len(account) > 30:
            raise ValueError("Invalid value for `account`, length must be less than or equal to `30`")  # noqa: E501

        self._account = account

    @property
    def portal_url(self):
        """Gets the portal_url of this Provider.  # noqa: E501


        :return: The portal_url of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._portal_url

    @portal_url.setter
    def portal_url(self, portal_url):
        """Sets the portal_url of this Provider.


        :param portal_url: The portal_url of this Provider.  # noqa: E501
        :type: str
        """
        if portal_url is not None and len(portal_url) > 200:
            raise ValueError("Invalid value for `portal_url`, length must be less than or equal to `200`")  # noqa: E501

        self._portal_url = portal_url

    @property
    def noc_contact(self):
        """Gets the noc_contact of this Provider.  # noqa: E501


        :return: The noc_contact of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._noc_contact

    @noc_contact.setter
    def noc_contact(self, noc_contact):
        """Sets the noc_contact of this Provider.


        :param noc_contact: The noc_contact of this Provider.  # noqa: E501
        :type: str
        """

        self._noc_contact = noc_contact

    @property
    def admin_contact(self):
        """Gets the admin_contact of this Provider.  # noqa: E501


        :return: The admin_contact of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._admin_contact

    @admin_contact.setter
    def admin_contact(self, admin_contact):
        """Sets the admin_contact of this Provider.


        :param admin_contact: The admin_contact of this Provider.  # noqa: E501
        :type: str
        """

        self._admin_contact = admin_contact

    @property
    def comments(self):
        """Gets the comments of this Provider.  # noqa: E501


        :return: The comments of this Provider.  # noqa: E501
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """Sets the comments of this Provider.


        :param comments: The comments of this Provider.  # noqa: E501
        :type: str
        """

        self._comments = comments

    @property
    def tags(self):
        """Gets the tags of this Provider.  # noqa: E501


        :return: The tags of this Provider.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Provider.


        :param tags: The tags of this Provider.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def custom_fields(self):
        """Gets the custom_fields of this Provider.  # noqa: E501


        :return: The custom_fields of this Provider.  # noqa: E501
        :rtype: object
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this Provider.


        :param custom_fields: The custom_fields of this Provider.  # noqa: E501
        :type: object
        """

        self._custom_fields = custom_fields

    @property
    def created(self):
        """Gets the created of this Provider.  # noqa: E501


        :return: The created of this Provider.  # noqa: E501
        :rtype: date
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Provider.


        :param created: The created of this Provider.  # noqa: E501
        :type: date
        """

        self._created = created

    @property
    def last_updated(self):
        """Gets the last_updated of this Provider.  # noqa: E501


        :return: The last_updated of this Provider.  # noqa: E501
        :rtype: datetime
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this Provider.


        :param last_updated: The last_updated of this Provider.  # noqa: E501
        :type: datetime
        """

        self._last_updated = last_updated

    @property
    def circuit_count(self):
        """Gets the circuit_count of this Provider.  # noqa: E501


        :return: The circuit_count of this Provider.  # noqa: E501
        :rtype: int
        """
        return self._circuit_count

    @circuit_count.setter
    def circuit_count(self, circuit_count):
        """Sets the circuit_count of this Provider.


        :param circuit_count: The circuit_count of this Provider.  # noqa: E501
        :type: int
        """

        self._circuit_count = circuit_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Provider, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Provider):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
