# coding: utf-8

"""
    NetBox API

    API to access NetBox  # noqa: E501

    OpenAPI spec version: 2.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DeviceType(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'manufacturer': 'NestedManufacturer',
        'model': 'str',
        'slug': 'str',
        'display_name': 'str',
        'part_number': 'str',
        'u_height': 'int',
        'is_full_depth': 'bool',
        'subdevice_role': 'SubdeviceRole',
        'front_image': 'str',
        'rear_image': 'str',
        'comments': 'str',
        'tags': 'list[str]',
        'custom_fields': 'object',
        'created': 'date',
        'last_updated': 'datetime',
        'device_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'manufacturer': 'manufacturer',
        'model': 'model',
        'slug': 'slug',
        'display_name': 'display_name',
        'part_number': 'part_number',
        'u_height': 'u_height',
        'is_full_depth': 'is_full_depth',
        'subdevice_role': 'subdevice_role',
        'front_image': 'front_image',
        'rear_image': 'rear_image',
        'comments': 'comments',
        'tags': 'tags',
        'custom_fields': 'custom_fields',
        'created': 'created',
        'last_updated': 'last_updated',
        'device_count': 'device_count'
    }

    def __init__(self, id=None, manufacturer=None, model=None, slug=None, display_name=None, part_number=None, u_height=None, is_full_depth=None, subdevice_role=None, front_image=None, rear_image=None, comments=None, tags=None, custom_fields=None, created=None, last_updated=None, device_count=None):  # noqa: E501
        """DeviceType - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._manufacturer = None
        self._model = None
        self._slug = None
        self._display_name = None
        self._part_number = None
        self._u_height = None
        self._is_full_depth = None
        self._subdevice_role = None
        self._front_image = None
        self._rear_image = None
        self._comments = None
        self._tags = None
        self._custom_fields = None
        self._created = None
        self._last_updated = None
        self._device_count = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.manufacturer = manufacturer
        self.model = model
        self.slug = slug
        if display_name is not None:
            self.display_name = display_name
        if part_number is not None:
            self.part_number = part_number
        if u_height is not None:
            self.u_height = u_height
        if is_full_depth is not None:
            self.is_full_depth = is_full_depth
        if subdevice_role is not None:
            self.subdevice_role = subdevice_role
        if front_image is not None:
            self.front_image = front_image
        if rear_image is not None:
            self.rear_image = rear_image
        if comments is not None:
            self.comments = comments
        if tags is not None:
            self.tags = tags
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if created is not None:
            self.created = created
        if last_updated is not None:
            self.last_updated = last_updated
        if device_count is not None:
            self.device_count = device_count

    @property
    def id(self):
        """Gets the id of this DeviceType.  # noqa: E501


        :return: The id of this DeviceType.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeviceType.


        :param id: The id of this DeviceType.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def manufacturer(self):
        """Gets the manufacturer of this DeviceType.  # noqa: E501


        :return: The manufacturer of this DeviceType.  # noqa: E501
        :rtype: NestedManufacturer
        """
        return self._manufacturer

    @manufacturer.setter
    def manufacturer(self, manufacturer):
        """Sets the manufacturer of this DeviceType.


        :param manufacturer: The manufacturer of this DeviceType.  # noqa: E501
        :type: NestedManufacturer
        """
        if manufacturer is None:
            raise ValueError("Invalid value for `manufacturer`, must not be `None`")  # noqa: E501

        self._manufacturer = manufacturer

    @property
    def model(self):
        """Gets the model of this DeviceType.  # noqa: E501


        :return: The model of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this DeviceType.


        :param model: The model of this DeviceType.  # noqa: E501
        :type: str
        """
        if model is None:
            raise ValueError("Invalid value for `model`, must not be `None`")  # noqa: E501
        if model is not None and len(model) > 50:
            raise ValueError("Invalid value for `model`, length must be less than or equal to `50`")  # noqa: E501
        if model is not None and len(model) < 1:
            raise ValueError("Invalid value for `model`, length must be greater than or equal to `1`")  # noqa: E501

        self._model = model

    @property
    def slug(self):
        """Gets the slug of this DeviceType.  # noqa: E501


        :return: The slug of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this DeviceType.


        :param slug: The slug of this DeviceType.  # noqa: E501
        :type: str
        """
        if slug is None:
            raise ValueError("Invalid value for `slug`, must not be `None`")  # noqa: E501
        if slug is not None and len(slug) > 50:
            raise ValueError("Invalid value for `slug`, length must be less than or equal to `50`")  # noqa: E501
        if slug is not None and len(slug) < 1:
            raise ValueError("Invalid value for `slug`, length must be greater than or equal to `1`")  # noqa: E501
        if slug is not None and not re.search(r'^[-a-zA-Z0-9_]+$', slug):  # noqa: E501
            raise ValueError(r"Invalid value for `slug`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug = slug

    @property
    def display_name(self):
        """Gets the display_name of this DeviceType.  # noqa: E501


        :return: The display_name of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this DeviceType.


        :param display_name: The display_name of this DeviceType.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def part_number(self):
        """Gets the part_number of this DeviceType.  # noqa: E501

        Discrete part number (optional)  # noqa: E501

        :return: The part_number of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._part_number

    @part_number.setter
    def part_number(self, part_number):
        """Sets the part_number of this DeviceType.

        Discrete part number (optional)  # noqa: E501

        :param part_number: The part_number of this DeviceType.  # noqa: E501
        :type: str
        """
        if part_number is not None and len(part_number) > 50:
            raise ValueError("Invalid value for `part_number`, length must be less than or equal to `50`")  # noqa: E501

        self._part_number = part_number

    @property
    def u_height(self):
        """Gets the u_height of this DeviceType.  # noqa: E501


        :return: The u_height of this DeviceType.  # noqa: E501
        :rtype: int
        """
        return self._u_height

    @u_height.setter
    def u_height(self, u_height):
        """Sets the u_height of this DeviceType.


        :param u_height: The u_height of this DeviceType.  # noqa: E501
        :type: int
        """
        if u_height is not None and u_height > 32767:  # noqa: E501
            raise ValueError("Invalid value for `u_height`, must be a value less than or equal to `32767`")  # noqa: E501
        if u_height is not None and u_height < 0:  # noqa: E501
            raise ValueError("Invalid value for `u_height`, must be a value greater than or equal to `0`")  # noqa: E501

        self._u_height = u_height

    @property
    def is_full_depth(self):
        """Gets the is_full_depth of this DeviceType.  # noqa: E501

        Device consumes both front and rear rack faces  # noqa: E501

        :return: The is_full_depth of this DeviceType.  # noqa: E501
        :rtype: bool
        """
        return self._is_full_depth

    @is_full_depth.setter
    def is_full_depth(self, is_full_depth):
        """Sets the is_full_depth of this DeviceType.

        Device consumes both front and rear rack faces  # noqa: E501

        :param is_full_depth: The is_full_depth of this DeviceType.  # noqa: E501
        :type: bool
        """

        self._is_full_depth = is_full_depth

    @property
    def subdevice_role(self):
        """Gets the subdevice_role of this DeviceType.  # noqa: E501


        :return: The subdevice_role of this DeviceType.  # noqa: E501
        :rtype: SubdeviceRole
        """
        return self._subdevice_role

    @subdevice_role.setter
    def subdevice_role(self, subdevice_role):
        """Sets the subdevice_role of this DeviceType.


        :param subdevice_role: The subdevice_role of this DeviceType.  # noqa: E501
        :type: SubdeviceRole
        """

        self._subdevice_role = subdevice_role

    @property
    def front_image(self):
        """Gets the front_image of this DeviceType.  # noqa: E501


        :return: The front_image of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._front_image

    @front_image.setter
    def front_image(self, front_image):
        """Sets the front_image of this DeviceType.


        :param front_image: The front_image of this DeviceType.  # noqa: E501
        :type: str
        """

        self._front_image = front_image

    @property
    def rear_image(self):
        """Gets the rear_image of this DeviceType.  # noqa: E501


        :return: The rear_image of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._rear_image

    @rear_image.setter
    def rear_image(self, rear_image):
        """Sets the rear_image of this DeviceType.


        :param rear_image: The rear_image of this DeviceType.  # noqa: E501
        :type: str
        """

        self._rear_image = rear_image

    @property
    def comments(self):
        """Gets the comments of this DeviceType.  # noqa: E501


        :return: The comments of this DeviceType.  # noqa: E501
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """Sets the comments of this DeviceType.


        :param comments: The comments of this DeviceType.  # noqa: E501
        :type: str
        """

        self._comments = comments

    @property
    def tags(self):
        """Gets the tags of this DeviceType.  # noqa: E501


        :return: The tags of this DeviceType.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this DeviceType.


        :param tags: The tags of this DeviceType.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def custom_fields(self):
        """Gets the custom_fields of this DeviceType.  # noqa: E501


        :return: The custom_fields of this DeviceType.  # noqa: E501
        :rtype: object
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this DeviceType.


        :param custom_fields: The custom_fields of this DeviceType.  # noqa: E501
        :type: object
        """

        self._custom_fields = custom_fields

    @property
    def created(self):
        """Gets the created of this DeviceType.  # noqa: E501


        :return: The created of this DeviceType.  # noqa: E501
        :rtype: date
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this DeviceType.


        :param created: The created of this DeviceType.  # noqa: E501
        :type: date
        """

        self._created = created

    @property
    def last_updated(self):
        """Gets the last_updated of this DeviceType.  # noqa: E501


        :return: The last_updated of this DeviceType.  # noqa: E501
        :rtype: datetime
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this DeviceType.


        :param last_updated: The last_updated of this DeviceType.  # noqa: E501
        :type: datetime
        """

        self._last_updated = last_updated

    @property
    def device_count(self):
        """Gets the device_count of this DeviceType.  # noqa: E501


        :return: The device_count of this DeviceType.  # noqa: E501
        :rtype: int
        """
        return self._device_count

    @device_count.setter
    def device_count(self, device_count):
        """Sets the device_count of this DeviceType.


        :param device_count: The device_count of this DeviceType.  # noqa: E501
        :type: int
        """

        self._device_count = device_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceType, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
