# netbox-client
API to access NetBox

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.8
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/nrfta/python-netbox-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/nrfta/python-netbox-client.git`)

Then import the package:
```python
import netbox_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import netbox_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import netbox_client
from netbox_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: Bearer
configuration = netbox_client.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = netbox_client.CircuitsApi(netbox_client.ApiClient(configuration))
data = netbox_client.WritableCircuitTermination() # WritableCircuitTermination | 

try:
    api_response = api_instance.circuits_circuit_terminations_create(data)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CircuitsApi->circuits_circuit_terminations_create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://netbox/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CircuitsApi* | [**circuits_circuit_terminations_create**](docs/CircuitsApi.md#circuits_circuit_terminations_create) | **POST** /circuits/circuit-terminations/ | 
*CircuitsApi* | [**circuits_circuit_terminations_delete**](docs/CircuitsApi.md#circuits_circuit_terminations_delete) | **DELETE** /circuits/circuit-terminations/{id}/ | 
*CircuitsApi* | [**circuits_circuit_terminations_list**](docs/CircuitsApi.md#circuits_circuit_terminations_list) | **GET** /circuits/circuit-terminations/ | 
*CircuitsApi* | [**circuits_circuit_terminations_partial_update**](docs/CircuitsApi.md#circuits_circuit_terminations_partial_update) | **PATCH** /circuits/circuit-terminations/{id}/ | 
*CircuitsApi* | [**circuits_circuit_terminations_read**](docs/CircuitsApi.md#circuits_circuit_terminations_read) | **GET** /circuits/circuit-terminations/{id}/ | 
*CircuitsApi* | [**circuits_circuit_terminations_update**](docs/CircuitsApi.md#circuits_circuit_terminations_update) | **PUT** /circuits/circuit-terminations/{id}/ | 
*CircuitsApi* | [**circuits_circuit_types_create**](docs/CircuitsApi.md#circuits_circuit_types_create) | **POST** /circuits/circuit-types/ | 
*CircuitsApi* | [**circuits_circuit_types_delete**](docs/CircuitsApi.md#circuits_circuit_types_delete) | **DELETE** /circuits/circuit-types/{id}/ | 
*CircuitsApi* | [**circuits_circuit_types_list**](docs/CircuitsApi.md#circuits_circuit_types_list) | **GET** /circuits/circuit-types/ | 
*CircuitsApi* | [**circuits_circuit_types_partial_update**](docs/CircuitsApi.md#circuits_circuit_types_partial_update) | **PATCH** /circuits/circuit-types/{id}/ | 
*CircuitsApi* | [**circuits_circuit_types_read**](docs/CircuitsApi.md#circuits_circuit_types_read) | **GET** /circuits/circuit-types/{id}/ | 
*CircuitsApi* | [**circuits_circuit_types_update**](docs/CircuitsApi.md#circuits_circuit_types_update) | **PUT** /circuits/circuit-types/{id}/ | 
*CircuitsApi* | [**circuits_circuits_create**](docs/CircuitsApi.md#circuits_circuits_create) | **POST** /circuits/circuits/ | 
*CircuitsApi* | [**circuits_circuits_delete**](docs/CircuitsApi.md#circuits_circuits_delete) | **DELETE** /circuits/circuits/{id}/ | 
*CircuitsApi* | [**circuits_circuits_list**](docs/CircuitsApi.md#circuits_circuits_list) | **GET** /circuits/circuits/ | 
*CircuitsApi* | [**circuits_circuits_partial_update**](docs/CircuitsApi.md#circuits_circuits_partial_update) | **PATCH** /circuits/circuits/{id}/ | 
*CircuitsApi* | [**circuits_circuits_read**](docs/CircuitsApi.md#circuits_circuits_read) | **GET** /circuits/circuits/{id}/ | 
*CircuitsApi* | [**circuits_circuits_update**](docs/CircuitsApi.md#circuits_circuits_update) | **PUT** /circuits/circuits/{id}/ | 
*CircuitsApi* | [**circuits_providers_create**](docs/CircuitsApi.md#circuits_providers_create) | **POST** /circuits/providers/ | 
*CircuitsApi* | [**circuits_providers_delete**](docs/CircuitsApi.md#circuits_providers_delete) | **DELETE** /circuits/providers/{id}/ | 
*CircuitsApi* | [**circuits_providers_graphs**](docs/CircuitsApi.md#circuits_providers_graphs) | **GET** /circuits/providers/{id}/graphs/ | 
*CircuitsApi* | [**circuits_providers_list**](docs/CircuitsApi.md#circuits_providers_list) | **GET** /circuits/providers/ | 
*CircuitsApi* | [**circuits_providers_partial_update**](docs/CircuitsApi.md#circuits_providers_partial_update) | **PATCH** /circuits/providers/{id}/ | 
*CircuitsApi* | [**circuits_providers_read**](docs/CircuitsApi.md#circuits_providers_read) | **GET** /circuits/providers/{id}/ | 
*CircuitsApi* | [**circuits_providers_update**](docs/CircuitsApi.md#circuits_providers_update) | **PUT** /circuits/providers/{id}/ | 
*DcimApi* | [**dcim_cables_create**](docs/DcimApi.md#dcim_cables_create) | **POST** /dcim/cables/ | 
*DcimApi* | [**dcim_cables_delete**](docs/DcimApi.md#dcim_cables_delete) | **DELETE** /dcim/cables/{id}/ | 
*DcimApi* | [**dcim_cables_list**](docs/DcimApi.md#dcim_cables_list) | **GET** /dcim/cables/ | 
*DcimApi* | [**dcim_cables_partial_update**](docs/DcimApi.md#dcim_cables_partial_update) | **PATCH** /dcim/cables/{id}/ | 
*DcimApi* | [**dcim_cables_read**](docs/DcimApi.md#dcim_cables_read) | **GET** /dcim/cables/{id}/ | 
*DcimApi* | [**dcim_cables_update**](docs/DcimApi.md#dcim_cables_update) | **PUT** /dcim/cables/{id}/ | 
*DcimApi* | [**dcim_connected_device_list**](docs/DcimApi.md#dcim_connected_device_list) | **GET** /dcim/connected-device/ | 
*DcimApi* | [**dcim_console_connections_list**](docs/DcimApi.md#dcim_console_connections_list) | **GET** /dcim/console-connections/ | 
*DcimApi* | [**dcim_console_port_templates_create**](docs/DcimApi.md#dcim_console_port_templates_create) | **POST** /dcim/console-port-templates/ | 
*DcimApi* | [**dcim_console_port_templates_delete**](docs/DcimApi.md#dcim_console_port_templates_delete) | **DELETE** /dcim/console-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_port_templates_list**](docs/DcimApi.md#dcim_console_port_templates_list) | **GET** /dcim/console-port-templates/ | 
*DcimApi* | [**dcim_console_port_templates_partial_update**](docs/DcimApi.md#dcim_console_port_templates_partial_update) | **PATCH** /dcim/console-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_port_templates_read**](docs/DcimApi.md#dcim_console_port_templates_read) | **GET** /dcim/console-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_port_templates_update**](docs/DcimApi.md#dcim_console_port_templates_update) | **PUT** /dcim/console-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_ports_create**](docs/DcimApi.md#dcim_console_ports_create) | **POST** /dcim/console-ports/ | 
*DcimApi* | [**dcim_console_ports_delete**](docs/DcimApi.md#dcim_console_ports_delete) | **DELETE** /dcim/console-ports/{id}/ | 
*DcimApi* | [**dcim_console_ports_list**](docs/DcimApi.md#dcim_console_ports_list) | **GET** /dcim/console-ports/ | 
*DcimApi* | [**dcim_console_ports_partial_update**](docs/DcimApi.md#dcim_console_ports_partial_update) | **PATCH** /dcim/console-ports/{id}/ | 
*DcimApi* | [**dcim_console_ports_read**](docs/DcimApi.md#dcim_console_ports_read) | **GET** /dcim/console-ports/{id}/ | 
*DcimApi* | [**dcim_console_ports_trace**](docs/DcimApi.md#dcim_console_ports_trace) | **GET** /dcim/console-ports/{id}/trace/ | 
*DcimApi* | [**dcim_console_ports_update**](docs/DcimApi.md#dcim_console_ports_update) | **PUT** /dcim/console-ports/{id}/ | 
*DcimApi* | [**dcim_console_server_port_templates_create**](docs/DcimApi.md#dcim_console_server_port_templates_create) | **POST** /dcim/console-server-port-templates/ | 
*DcimApi* | [**dcim_console_server_port_templates_delete**](docs/DcimApi.md#dcim_console_server_port_templates_delete) | **DELETE** /dcim/console-server-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_server_port_templates_list**](docs/DcimApi.md#dcim_console_server_port_templates_list) | **GET** /dcim/console-server-port-templates/ | 
*DcimApi* | [**dcim_console_server_port_templates_partial_update**](docs/DcimApi.md#dcim_console_server_port_templates_partial_update) | **PATCH** /dcim/console-server-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_server_port_templates_read**](docs/DcimApi.md#dcim_console_server_port_templates_read) | **GET** /dcim/console-server-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_server_port_templates_update**](docs/DcimApi.md#dcim_console_server_port_templates_update) | **PUT** /dcim/console-server-port-templates/{id}/ | 
*DcimApi* | [**dcim_console_server_ports_create**](docs/DcimApi.md#dcim_console_server_ports_create) | **POST** /dcim/console-server-ports/ | 
*DcimApi* | [**dcim_console_server_ports_delete**](docs/DcimApi.md#dcim_console_server_ports_delete) | **DELETE** /dcim/console-server-ports/{id}/ | 
*DcimApi* | [**dcim_console_server_ports_list**](docs/DcimApi.md#dcim_console_server_ports_list) | **GET** /dcim/console-server-ports/ | 
*DcimApi* | [**dcim_console_server_ports_partial_update**](docs/DcimApi.md#dcim_console_server_ports_partial_update) | **PATCH** /dcim/console-server-ports/{id}/ | 
*DcimApi* | [**dcim_console_server_ports_read**](docs/DcimApi.md#dcim_console_server_ports_read) | **GET** /dcim/console-server-ports/{id}/ | 
*DcimApi* | [**dcim_console_server_ports_trace**](docs/DcimApi.md#dcim_console_server_ports_trace) | **GET** /dcim/console-server-ports/{id}/trace/ | 
*DcimApi* | [**dcim_console_server_ports_update**](docs/DcimApi.md#dcim_console_server_ports_update) | **PUT** /dcim/console-server-ports/{id}/ | 
*DcimApi* | [**dcim_device_bay_templates_create**](docs/DcimApi.md#dcim_device_bay_templates_create) | **POST** /dcim/device-bay-templates/ | 
*DcimApi* | [**dcim_device_bay_templates_delete**](docs/DcimApi.md#dcim_device_bay_templates_delete) | **DELETE** /dcim/device-bay-templates/{id}/ | 
*DcimApi* | [**dcim_device_bay_templates_list**](docs/DcimApi.md#dcim_device_bay_templates_list) | **GET** /dcim/device-bay-templates/ | 
*DcimApi* | [**dcim_device_bay_templates_partial_update**](docs/DcimApi.md#dcim_device_bay_templates_partial_update) | **PATCH** /dcim/device-bay-templates/{id}/ | 
*DcimApi* | [**dcim_device_bay_templates_read**](docs/DcimApi.md#dcim_device_bay_templates_read) | **GET** /dcim/device-bay-templates/{id}/ | 
*DcimApi* | [**dcim_device_bay_templates_update**](docs/DcimApi.md#dcim_device_bay_templates_update) | **PUT** /dcim/device-bay-templates/{id}/ | 
*DcimApi* | [**dcim_device_bays_create**](docs/DcimApi.md#dcim_device_bays_create) | **POST** /dcim/device-bays/ | 
*DcimApi* | [**dcim_device_bays_delete**](docs/DcimApi.md#dcim_device_bays_delete) | **DELETE** /dcim/device-bays/{id}/ | 
*DcimApi* | [**dcim_device_bays_list**](docs/DcimApi.md#dcim_device_bays_list) | **GET** /dcim/device-bays/ | 
*DcimApi* | [**dcim_device_bays_partial_update**](docs/DcimApi.md#dcim_device_bays_partial_update) | **PATCH** /dcim/device-bays/{id}/ | 
*DcimApi* | [**dcim_device_bays_read**](docs/DcimApi.md#dcim_device_bays_read) | **GET** /dcim/device-bays/{id}/ | 
*DcimApi* | [**dcim_device_bays_update**](docs/DcimApi.md#dcim_device_bays_update) | **PUT** /dcim/device-bays/{id}/ | 
*DcimApi* | [**dcim_device_roles_create**](docs/DcimApi.md#dcim_device_roles_create) | **POST** /dcim/device-roles/ | 
*DcimApi* | [**dcim_device_roles_delete**](docs/DcimApi.md#dcim_device_roles_delete) | **DELETE** /dcim/device-roles/{id}/ | 
*DcimApi* | [**dcim_device_roles_list**](docs/DcimApi.md#dcim_device_roles_list) | **GET** /dcim/device-roles/ | 
*DcimApi* | [**dcim_device_roles_partial_update**](docs/DcimApi.md#dcim_device_roles_partial_update) | **PATCH** /dcim/device-roles/{id}/ | 
*DcimApi* | [**dcim_device_roles_read**](docs/DcimApi.md#dcim_device_roles_read) | **GET** /dcim/device-roles/{id}/ | 
*DcimApi* | [**dcim_device_roles_update**](docs/DcimApi.md#dcim_device_roles_update) | **PUT** /dcim/device-roles/{id}/ | 
*DcimApi* | [**dcim_device_types_create**](docs/DcimApi.md#dcim_device_types_create) | **POST** /dcim/device-types/ | 
*DcimApi* | [**dcim_device_types_delete**](docs/DcimApi.md#dcim_device_types_delete) | **DELETE** /dcim/device-types/{id}/ | 
*DcimApi* | [**dcim_device_types_list**](docs/DcimApi.md#dcim_device_types_list) | **GET** /dcim/device-types/ | 
*DcimApi* | [**dcim_device_types_partial_update**](docs/DcimApi.md#dcim_device_types_partial_update) | **PATCH** /dcim/device-types/{id}/ | 
*DcimApi* | [**dcim_device_types_read**](docs/DcimApi.md#dcim_device_types_read) | **GET** /dcim/device-types/{id}/ | 
*DcimApi* | [**dcim_device_types_update**](docs/DcimApi.md#dcim_device_types_update) | **PUT** /dcim/device-types/{id}/ | 
*DcimApi* | [**dcim_devices_create**](docs/DcimApi.md#dcim_devices_create) | **POST** /dcim/devices/ | 
*DcimApi* | [**dcim_devices_delete**](docs/DcimApi.md#dcim_devices_delete) | **DELETE** /dcim/devices/{id}/ | 
*DcimApi* | [**dcim_devices_graphs**](docs/DcimApi.md#dcim_devices_graphs) | **GET** /dcim/devices/{id}/graphs/ | 
*DcimApi* | [**dcim_devices_list**](docs/DcimApi.md#dcim_devices_list) | **GET** /dcim/devices/ | 
*DcimApi* | [**dcim_devices_napalm**](docs/DcimApi.md#dcim_devices_napalm) | **GET** /dcim/devices/{id}/napalm/ | 
*DcimApi* | [**dcim_devices_partial_update**](docs/DcimApi.md#dcim_devices_partial_update) | **PATCH** /dcim/devices/{id}/ | 
*DcimApi* | [**dcim_devices_read**](docs/DcimApi.md#dcim_devices_read) | **GET** /dcim/devices/{id}/ | 
*DcimApi* | [**dcim_devices_update**](docs/DcimApi.md#dcim_devices_update) | **PUT** /dcim/devices/{id}/ | 
*DcimApi* | [**dcim_front_port_templates_create**](docs/DcimApi.md#dcim_front_port_templates_create) | **POST** /dcim/front-port-templates/ | 
*DcimApi* | [**dcim_front_port_templates_delete**](docs/DcimApi.md#dcim_front_port_templates_delete) | **DELETE** /dcim/front-port-templates/{id}/ | 
*DcimApi* | [**dcim_front_port_templates_list**](docs/DcimApi.md#dcim_front_port_templates_list) | **GET** /dcim/front-port-templates/ | 
*DcimApi* | [**dcim_front_port_templates_partial_update**](docs/DcimApi.md#dcim_front_port_templates_partial_update) | **PATCH** /dcim/front-port-templates/{id}/ | 
*DcimApi* | [**dcim_front_port_templates_read**](docs/DcimApi.md#dcim_front_port_templates_read) | **GET** /dcim/front-port-templates/{id}/ | 
*DcimApi* | [**dcim_front_port_templates_update**](docs/DcimApi.md#dcim_front_port_templates_update) | **PUT** /dcim/front-port-templates/{id}/ | 
*DcimApi* | [**dcim_front_ports_create**](docs/DcimApi.md#dcim_front_ports_create) | **POST** /dcim/front-ports/ | 
*DcimApi* | [**dcim_front_ports_delete**](docs/DcimApi.md#dcim_front_ports_delete) | **DELETE** /dcim/front-ports/{id}/ | 
*DcimApi* | [**dcim_front_ports_list**](docs/DcimApi.md#dcim_front_ports_list) | **GET** /dcim/front-ports/ | 
*DcimApi* | [**dcim_front_ports_partial_update**](docs/DcimApi.md#dcim_front_ports_partial_update) | **PATCH** /dcim/front-ports/{id}/ | 
*DcimApi* | [**dcim_front_ports_read**](docs/DcimApi.md#dcim_front_ports_read) | **GET** /dcim/front-ports/{id}/ | 
*DcimApi* | [**dcim_front_ports_update**](docs/DcimApi.md#dcim_front_ports_update) | **PUT** /dcim/front-ports/{id}/ | 
*DcimApi* | [**dcim_interface_connections_list**](docs/DcimApi.md#dcim_interface_connections_list) | **GET** /dcim/interface-connections/ | 
*DcimApi* | [**dcim_interface_templates_create**](docs/DcimApi.md#dcim_interface_templates_create) | **POST** /dcim/interface-templates/ | 
*DcimApi* | [**dcim_interface_templates_delete**](docs/DcimApi.md#dcim_interface_templates_delete) | **DELETE** /dcim/interface-templates/{id}/ | 
*DcimApi* | [**dcim_interface_templates_list**](docs/DcimApi.md#dcim_interface_templates_list) | **GET** /dcim/interface-templates/ | 
*DcimApi* | [**dcim_interface_templates_partial_update**](docs/DcimApi.md#dcim_interface_templates_partial_update) | **PATCH** /dcim/interface-templates/{id}/ | 
*DcimApi* | [**dcim_interface_templates_read**](docs/DcimApi.md#dcim_interface_templates_read) | **GET** /dcim/interface-templates/{id}/ | 
*DcimApi* | [**dcim_interface_templates_update**](docs/DcimApi.md#dcim_interface_templates_update) | **PUT** /dcim/interface-templates/{id}/ | 
*DcimApi* | [**dcim_interfaces_create**](docs/DcimApi.md#dcim_interfaces_create) | **POST** /dcim/interfaces/ | 
*DcimApi* | [**dcim_interfaces_delete**](docs/DcimApi.md#dcim_interfaces_delete) | **DELETE** /dcim/interfaces/{id}/ | 
*DcimApi* | [**dcim_interfaces_graphs**](docs/DcimApi.md#dcim_interfaces_graphs) | **GET** /dcim/interfaces/{id}/graphs/ | 
*DcimApi* | [**dcim_interfaces_list**](docs/DcimApi.md#dcim_interfaces_list) | **GET** /dcim/interfaces/ | 
*DcimApi* | [**dcim_interfaces_partial_update**](docs/DcimApi.md#dcim_interfaces_partial_update) | **PATCH** /dcim/interfaces/{id}/ | 
*DcimApi* | [**dcim_interfaces_read**](docs/DcimApi.md#dcim_interfaces_read) | **GET** /dcim/interfaces/{id}/ | 
*DcimApi* | [**dcim_interfaces_trace**](docs/DcimApi.md#dcim_interfaces_trace) | **GET** /dcim/interfaces/{id}/trace/ | 
*DcimApi* | [**dcim_interfaces_update**](docs/DcimApi.md#dcim_interfaces_update) | **PUT** /dcim/interfaces/{id}/ | 
*DcimApi* | [**dcim_inventory_items_create**](docs/DcimApi.md#dcim_inventory_items_create) | **POST** /dcim/inventory-items/ | 
*DcimApi* | [**dcim_inventory_items_delete**](docs/DcimApi.md#dcim_inventory_items_delete) | **DELETE** /dcim/inventory-items/{id}/ | 
*DcimApi* | [**dcim_inventory_items_list**](docs/DcimApi.md#dcim_inventory_items_list) | **GET** /dcim/inventory-items/ | 
*DcimApi* | [**dcim_inventory_items_partial_update**](docs/DcimApi.md#dcim_inventory_items_partial_update) | **PATCH** /dcim/inventory-items/{id}/ | 
*DcimApi* | [**dcim_inventory_items_read**](docs/DcimApi.md#dcim_inventory_items_read) | **GET** /dcim/inventory-items/{id}/ | 
*DcimApi* | [**dcim_inventory_items_update**](docs/DcimApi.md#dcim_inventory_items_update) | **PUT** /dcim/inventory-items/{id}/ | 
*DcimApi* | [**dcim_manufacturers_create**](docs/DcimApi.md#dcim_manufacturers_create) | **POST** /dcim/manufacturers/ | 
*DcimApi* | [**dcim_manufacturers_delete**](docs/DcimApi.md#dcim_manufacturers_delete) | **DELETE** /dcim/manufacturers/{id}/ | 
*DcimApi* | [**dcim_manufacturers_list**](docs/DcimApi.md#dcim_manufacturers_list) | **GET** /dcim/manufacturers/ | 
*DcimApi* | [**dcim_manufacturers_partial_update**](docs/DcimApi.md#dcim_manufacturers_partial_update) | **PATCH** /dcim/manufacturers/{id}/ | 
*DcimApi* | [**dcim_manufacturers_read**](docs/DcimApi.md#dcim_manufacturers_read) | **GET** /dcim/manufacturers/{id}/ | 
*DcimApi* | [**dcim_manufacturers_update**](docs/DcimApi.md#dcim_manufacturers_update) | **PUT** /dcim/manufacturers/{id}/ | 
*DcimApi* | [**dcim_platforms_create**](docs/DcimApi.md#dcim_platforms_create) | **POST** /dcim/platforms/ | 
*DcimApi* | [**dcim_platforms_delete**](docs/DcimApi.md#dcim_platforms_delete) | **DELETE** /dcim/platforms/{id}/ | 
*DcimApi* | [**dcim_platforms_list**](docs/DcimApi.md#dcim_platforms_list) | **GET** /dcim/platforms/ | 
*DcimApi* | [**dcim_platforms_partial_update**](docs/DcimApi.md#dcim_platforms_partial_update) | **PATCH** /dcim/platforms/{id}/ | 
*DcimApi* | [**dcim_platforms_read**](docs/DcimApi.md#dcim_platforms_read) | **GET** /dcim/platforms/{id}/ | 
*DcimApi* | [**dcim_platforms_update**](docs/DcimApi.md#dcim_platforms_update) | **PUT** /dcim/platforms/{id}/ | 
*DcimApi* | [**dcim_power_connections_list**](docs/DcimApi.md#dcim_power_connections_list) | **GET** /dcim/power-connections/ | 
*DcimApi* | [**dcim_power_feeds_create**](docs/DcimApi.md#dcim_power_feeds_create) | **POST** /dcim/power-feeds/ | 
*DcimApi* | [**dcim_power_feeds_delete**](docs/DcimApi.md#dcim_power_feeds_delete) | **DELETE** /dcim/power-feeds/{id}/ | 
*DcimApi* | [**dcim_power_feeds_list**](docs/DcimApi.md#dcim_power_feeds_list) | **GET** /dcim/power-feeds/ | 
*DcimApi* | [**dcim_power_feeds_partial_update**](docs/DcimApi.md#dcim_power_feeds_partial_update) | **PATCH** /dcim/power-feeds/{id}/ | 
*DcimApi* | [**dcim_power_feeds_read**](docs/DcimApi.md#dcim_power_feeds_read) | **GET** /dcim/power-feeds/{id}/ | 
*DcimApi* | [**dcim_power_feeds_update**](docs/DcimApi.md#dcim_power_feeds_update) | **PUT** /dcim/power-feeds/{id}/ | 
*DcimApi* | [**dcim_power_outlet_templates_create**](docs/DcimApi.md#dcim_power_outlet_templates_create) | **POST** /dcim/power-outlet-templates/ | 
*DcimApi* | [**dcim_power_outlet_templates_delete**](docs/DcimApi.md#dcim_power_outlet_templates_delete) | **DELETE** /dcim/power-outlet-templates/{id}/ | 
*DcimApi* | [**dcim_power_outlet_templates_list**](docs/DcimApi.md#dcim_power_outlet_templates_list) | **GET** /dcim/power-outlet-templates/ | 
*DcimApi* | [**dcim_power_outlet_templates_partial_update**](docs/DcimApi.md#dcim_power_outlet_templates_partial_update) | **PATCH** /dcim/power-outlet-templates/{id}/ | 
*DcimApi* | [**dcim_power_outlet_templates_read**](docs/DcimApi.md#dcim_power_outlet_templates_read) | **GET** /dcim/power-outlet-templates/{id}/ | 
*DcimApi* | [**dcim_power_outlet_templates_update**](docs/DcimApi.md#dcim_power_outlet_templates_update) | **PUT** /dcim/power-outlet-templates/{id}/ | 
*DcimApi* | [**dcim_power_outlets_create**](docs/DcimApi.md#dcim_power_outlets_create) | **POST** /dcim/power-outlets/ | 
*DcimApi* | [**dcim_power_outlets_delete**](docs/DcimApi.md#dcim_power_outlets_delete) | **DELETE** /dcim/power-outlets/{id}/ | 
*DcimApi* | [**dcim_power_outlets_list**](docs/DcimApi.md#dcim_power_outlets_list) | **GET** /dcim/power-outlets/ | 
*DcimApi* | [**dcim_power_outlets_partial_update**](docs/DcimApi.md#dcim_power_outlets_partial_update) | **PATCH** /dcim/power-outlets/{id}/ | 
*DcimApi* | [**dcim_power_outlets_read**](docs/DcimApi.md#dcim_power_outlets_read) | **GET** /dcim/power-outlets/{id}/ | 
*DcimApi* | [**dcim_power_outlets_trace**](docs/DcimApi.md#dcim_power_outlets_trace) | **GET** /dcim/power-outlets/{id}/trace/ | 
*DcimApi* | [**dcim_power_outlets_update**](docs/DcimApi.md#dcim_power_outlets_update) | **PUT** /dcim/power-outlets/{id}/ | 
*DcimApi* | [**dcim_power_panels_create**](docs/DcimApi.md#dcim_power_panels_create) | **POST** /dcim/power-panels/ | 
*DcimApi* | [**dcim_power_panels_delete**](docs/DcimApi.md#dcim_power_panels_delete) | **DELETE** /dcim/power-panels/{id}/ | 
*DcimApi* | [**dcim_power_panels_list**](docs/DcimApi.md#dcim_power_panels_list) | **GET** /dcim/power-panels/ | 
*DcimApi* | [**dcim_power_panels_partial_update**](docs/DcimApi.md#dcim_power_panels_partial_update) | **PATCH** /dcim/power-panels/{id}/ | 
*DcimApi* | [**dcim_power_panels_read**](docs/DcimApi.md#dcim_power_panels_read) | **GET** /dcim/power-panels/{id}/ | 
*DcimApi* | [**dcim_power_panels_update**](docs/DcimApi.md#dcim_power_panels_update) | **PUT** /dcim/power-panels/{id}/ | 
*DcimApi* | [**dcim_power_port_templates_create**](docs/DcimApi.md#dcim_power_port_templates_create) | **POST** /dcim/power-port-templates/ | 
*DcimApi* | [**dcim_power_port_templates_delete**](docs/DcimApi.md#dcim_power_port_templates_delete) | **DELETE** /dcim/power-port-templates/{id}/ | 
*DcimApi* | [**dcim_power_port_templates_list**](docs/DcimApi.md#dcim_power_port_templates_list) | **GET** /dcim/power-port-templates/ | 
*DcimApi* | [**dcim_power_port_templates_partial_update**](docs/DcimApi.md#dcim_power_port_templates_partial_update) | **PATCH** /dcim/power-port-templates/{id}/ | 
*DcimApi* | [**dcim_power_port_templates_read**](docs/DcimApi.md#dcim_power_port_templates_read) | **GET** /dcim/power-port-templates/{id}/ | 
*DcimApi* | [**dcim_power_port_templates_update**](docs/DcimApi.md#dcim_power_port_templates_update) | **PUT** /dcim/power-port-templates/{id}/ | 
*DcimApi* | [**dcim_power_ports_create**](docs/DcimApi.md#dcim_power_ports_create) | **POST** /dcim/power-ports/ | 
*DcimApi* | [**dcim_power_ports_delete**](docs/DcimApi.md#dcim_power_ports_delete) | **DELETE** /dcim/power-ports/{id}/ | 
*DcimApi* | [**dcim_power_ports_list**](docs/DcimApi.md#dcim_power_ports_list) | **GET** /dcim/power-ports/ | 
*DcimApi* | [**dcim_power_ports_partial_update**](docs/DcimApi.md#dcim_power_ports_partial_update) | **PATCH** /dcim/power-ports/{id}/ | 
*DcimApi* | [**dcim_power_ports_read**](docs/DcimApi.md#dcim_power_ports_read) | **GET** /dcim/power-ports/{id}/ | 
*DcimApi* | [**dcim_power_ports_trace**](docs/DcimApi.md#dcim_power_ports_trace) | **GET** /dcim/power-ports/{id}/trace/ | 
*DcimApi* | [**dcim_power_ports_update**](docs/DcimApi.md#dcim_power_ports_update) | **PUT** /dcim/power-ports/{id}/ | 
*DcimApi* | [**dcim_rack_groups_create**](docs/DcimApi.md#dcim_rack_groups_create) | **POST** /dcim/rack-groups/ | 
*DcimApi* | [**dcim_rack_groups_delete**](docs/DcimApi.md#dcim_rack_groups_delete) | **DELETE** /dcim/rack-groups/{id}/ | 
*DcimApi* | [**dcim_rack_groups_list**](docs/DcimApi.md#dcim_rack_groups_list) | **GET** /dcim/rack-groups/ | 
*DcimApi* | [**dcim_rack_groups_partial_update**](docs/DcimApi.md#dcim_rack_groups_partial_update) | **PATCH** /dcim/rack-groups/{id}/ | 
*DcimApi* | [**dcim_rack_groups_read**](docs/DcimApi.md#dcim_rack_groups_read) | **GET** /dcim/rack-groups/{id}/ | 
*DcimApi* | [**dcim_rack_groups_update**](docs/DcimApi.md#dcim_rack_groups_update) | **PUT** /dcim/rack-groups/{id}/ | 
*DcimApi* | [**dcim_rack_reservations_create**](docs/DcimApi.md#dcim_rack_reservations_create) | **POST** /dcim/rack-reservations/ | 
*DcimApi* | [**dcim_rack_reservations_delete**](docs/DcimApi.md#dcim_rack_reservations_delete) | **DELETE** /dcim/rack-reservations/{id}/ | 
*DcimApi* | [**dcim_rack_reservations_list**](docs/DcimApi.md#dcim_rack_reservations_list) | **GET** /dcim/rack-reservations/ | 
*DcimApi* | [**dcim_rack_reservations_partial_update**](docs/DcimApi.md#dcim_rack_reservations_partial_update) | **PATCH** /dcim/rack-reservations/{id}/ | 
*DcimApi* | [**dcim_rack_reservations_read**](docs/DcimApi.md#dcim_rack_reservations_read) | **GET** /dcim/rack-reservations/{id}/ | 
*DcimApi* | [**dcim_rack_reservations_update**](docs/DcimApi.md#dcim_rack_reservations_update) | **PUT** /dcim/rack-reservations/{id}/ | 
*DcimApi* | [**dcim_rack_roles_create**](docs/DcimApi.md#dcim_rack_roles_create) | **POST** /dcim/rack-roles/ | 
*DcimApi* | [**dcim_rack_roles_delete**](docs/DcimApi.md#dcim_rack_roles_delete) | **DELETE** /dcim/rack-roles/{id}/ | 
*DcimApi* | [**dcim_rack_roles_list**](docs/DcimApi.md#dcim_rack_roles_list) | **GET** /dcim/rack-roles/ | 
*DcimApi* | [**dcim_rack_roles_partial_update**](docs/DcimApi.md#dcim_rack_roles_partial_update) | **PATCH** /dcim/rack-roles/{id}/ | 
*DcimApi* | [**dcim_rack_roles_read**](docs/DcimApi.md#dcim_rack_roles_read) | **GET** /dcim/rack-roles/{id}/ | 
*DcimApi* | [**dcim_rack_roles_update**](docs/DcimApi.md#dcim_rack_roles_update) | **PUT** /dcim/rack-roles/{id}/ | 
*DcimApi* | [**dcim_racks_create**](docs/DcimApi.md#dcim_racks_create) | **POST** /dcim/racks/ | 
*DcimApi* | [**dcim_racks_delete**](docs/DcimApi.md#dcim_racks_delete) | **DELETE** /dcim/racks/{id}/ | 
*DcimApi* | [**dcim_racks_elevation**](docs/DcimApi.md#dcim_racks_elevation) | **GET** /dcim/racks/{id}/elevation/ | 
*DcimApi* | [**dcim_racks_list**](docs/DcimApi.md#dcim_racks_list) | **GET** /dcim/racks/ | 
*DcimApi* | [**dcim_racks_partial_update**](docs/DcimApi.md#dcim_racks_partial_update) | **PATCH** /dcim/racks/{id}/ | 
*DcimApi* | [**dcim_racks_read**](docs/DcimApi.md#dcim_racks_read) | **GET** /dcim/racks/{id}/ | 
*DcimApi* | [**dcim_racks_update**](docs/DcimApi.md#dcim_racks_update) | **PUT** /dcim/racks/{id}/ | 
*DcimApi* | [**dcim_rear_port_templates_create**](docs/DcimApi.md#dcim_rear_port_templates_create) | **POST** /dcim/rear-port-templates/ | 
*DcimApi* | [**dcim_rear_port_templates_delete**](docs/DcimApi.md#dcim_rear_port_templates_delete) | **DELETE** /dcim/rear-port-templates/{id}/ | 
*DcimApi* | [**dcim_rear_port_templates_list**](docs/DcimApi.md#dcim_rear_port_templates_list) | **GET** /dcim/rear-port-templates/ | 
*DcimApi* | [**dcim_rear_port_templates_partial_update**](docs/DcimApi.md#dcim_rear_port_templates_partial_update) | **PATCH** /dcim/rear-port-templates/{id}/ | 
*DcimApi* | [**dcim_rear_port_templates_read**](docs/DcimApi.md#dcim_rear_port_templates_read) | **GET** /dcim/rear-port-templates/{id}/ | 
*DcimApi* | [**dcim_rear_port_templates_update**](docs/DcimApi.md#dcim_rear_port_templates_update) | **PUT** /dcim/rear-port-templates/{id}/ | 
*DcimApi* | [**dcim_rear_ports_create**](docs/DcimApi.md#dcim_rear_ports_create) | **POST** /dcim/rear-ports/ | 
*DcimApi* | [**dcim_rear_ports_delete**](docs/DcimApi.md#dcim_rear_ports_delete) | **DELETE** /dcim/rear-ports/{id}/ | 
*DcimApi* | [**dcim_rear_ports_list**](docs/DcimApi.md#dcim_rear_ports_list) | **GET** /dcim/rear-ports/ | 
*DcimApi* | [**dcim_rear_ports_partial_update**](docs/DcimApi.md#dcim_rear_ports_partial_update) | **PATCH** /dcim/rear-ports/{id}/ | 
*DcimApi* | [**dcim_rear_ports_read**](docs/DcimApi.md#dcim_rear_ports_read) | **GET** /dcim/rear-ports/{id}/ | 
*DcimApi* | [**dcim_rear_ports_update**](docs/DcimApi.md#dcim_rear_ports_update) | **PUT** /dcim/rear-ports/{id}/ | 
*DcimApi* | [**dcim_regions_create**](docs/DcimApi.md#dcim_regions_create) | **POST** /dcim/regions/ | 
*DcimApi* | [**dcim_regions_delete**](docs/DcimApi.md#dcim_regions_delete) | **DELETE** /dcim/regions/{id}/ | 
*DcimApi* | [**dcim_regions_list**](docs/DcimApi.md#dcim_regions_list) | **GET** /dcim/regions/ | 
*DcimApi* | [**dcim_regions_partial_update**](docs/DcimApi.md#dcim_regions_partial_update) | **PATCH** /dcim/regions/{id}/ | 
*DcimApi* | [**dcim_regions_read**](docs/DcimApi.md#dcim_regions_read) | **GET** /dcim/regions/{id}/ | 
*DcimApi* | [**dcim_regions_update**](docs/DcimApi.md#dcim_regions_update) | **PUT** /dcim/regions/{id}/ | 
*DcimApi* | [**dcim_sites_create**](docs/DcimApi.md#dcim_sites_create) | **POST** /dcim/sites/ | 
*DcimApi* | [**dcim_sites_delete**](docs/DcimApi.md#dcim_sites_delete) | **DELETE** /dcim/sites/{id}/ | 
*DcimApi* | [**dcim_sites_graphs**](docs/DcimApi.md#dcim_sites_graphs) | **GET** /dcim/sites/{id}/graphs/ | 
*DcimApi* | [**dcim_sites_list**](docs/DcimApi.md#dcim_sites_list) | **GET** /dcim/sites/ | 
*DcimApi* | [**dcim_sites_partial_update**](docs/DcimApi.md#dcim_sites_partial_update) | **PATCH** /dcim/sites/{id}/ | 
*DcimApi* | [**dcim_sites_read**](docs/DcimApi.md#dcim_sites_read) | **GET** /dcim/sites/{id}/ | 
*DcimApi* | [**dcim_sites_update**](docs/DcimApi.md#dcim_sites_update) | **PUT** /dcim/sites/{id}/ | 
*DcimApi* | [**dcim_virtual_chassis_create**](docs/DcimApi.md#dcim_virtual_chassis_create) | **POST** /dcim/virtual-chassis/ | 
*DcimApi* | [**dcim_virtual_chassis_delete**](docs/DcimApi.md#dcim_virtual_chassis_delete) | **DELETE** /dcim/virtual-chassis/{id}/ | 
*DcimApi* | [**dcim_virtual_chassis_list**](docs/DcimApi.md#dcim_virtual_chassis_list) | **GET** /dcim/virtual-chassis/ | 
*DcimApi* | [**dcim_virtual_chassis_partial_update**](docs/DcimApi.md#dcim_virtual_chassis_partial_update) | **PATCH** /dcim/virtual-chassis/{id}/ | 
*DcimApi* | [**dcim_virtual_chassis_read**](docs/DcimApi.md#dcim_virtual_chassis_read) | **GET** /dcim/virtual-chassis/{id}/ | 
*DcimApi* | [**dcim_virtual_chassis_update**](docs/DcimApi.md#dcim_virtual_chassis_update) | **PUT** /dcim/virtual-chassis/{id}/ | 
*ExtrasApi* | [**extras_config_contexts_create**](docs/ExtrasApi.md#extras_config_contexts_create) | **POST** /extras/config-contexts/ | 
*ExtrasApi* | [**extras_config_contexts_delete**](docs/ExtrasApi.md#extras_config_contexts_delete) | **DELETE** /extras/config-contexts/{id}/ | 
*ExtrasApi* | [**extras_config_contexts_list**](docs/ExtrasApi.md#extras_config_contexts_list) | **GET** /extras/config-contexts/ | 
*ExtrasApi* | [**extras_config_contexts_partial_update**](docs/ExtrasApi.md#extras_config_contexts_partial_update) | **PATCH** /extras/config-contexts/{id}/ | 
*ExtrasApi* | [**extras_config_contexts_read**](docs/ExtrasApi.md#extras_config_contexts_read) | **GET** /extras/config-contexts/{id}/ | 
*ExtrasApi* | [**extras_config_contexts_update**](docs/ExtrasApi.md#extras_config_contexts_update) | **PUT** /extras/config-contexts/{id}/ | 
*ExtrasApi* | [**extras_custom_field_choices_list**](docs/ExtrasApi.md#extras_custom_field_choices_list) | **GET** /extras/_custom_field_choices/ | 
*ExtrasApi* | [**extras_custom_field_choices_read**](docs/ExtrasApi.md#extras_custom_field_choices_read) | **GET** /extras/_custom_field_choices/{id}/ | 
*ExtrasApi* | [**extras_export_templates_create**](docs/ExtrasApi.md#extras_export_templates_create) | **POST** /extras/export-templates/ | 
*ExtrasApi* | [**extras_export_templates_delete**](docs/ExtrasApi.md#extras_export_templates_delete) | **DELETE** /extras/export-templates/{id}/ | 
*ExtrasApi* | [**extras_export_templates_list**](docs/ExtrasApi.md#extras_export_templates_list) | **GET** /extras/export-templates/ | 
*ExtrasApi* | [**extras_export_templates_partial_update**](docs/ExtrasApi.md#extras_export_templates_partial_update) | **PATCH** /extras/export-templates/{id}/ | 
*ExtrasApi* | [**extras_export_templates_read**](docs/ExtrasApi.md#extras_export_templates_read) | **GET** /extras/export-templates/{id}/ | 
*ExtrasApi* | [**extras_export_templates_update**](docs/ExtrasApi.md#extras_export_templates_update) | **PUT** /extras/export-templates/{id}/ | 
*ExtrasApi* | [**extras_graphs_create**](docs/ExtrasApi.md#extras_graphs_create) | **POST** /extras/graphs/ | 
*ExtrasApi* | [**extras_graphs_delete**](docs/ExtrasApi.md#extras_graphs_delete) | **DELETE** /extras/graphs/{id}/ | 
*ExtrasApi* | [**extras_graphs_list**](docs/ExtrasApi.md#extras_graphs_list) | **GET** /extras/graphs/ | 
*ExtrasApi* | [**extras_graphs_partial_update**](docs/ExtrasApi.md#extras_graphs_partial_update) | **PATCH** /extras/graphs/{id}/ | 
*ExtrasApi* | [**extras_graphs_read**](docs/ExtrasApi.md#extras_graphs_read) | **GET** /extras/graphs/{id}/ | 
*ExtrasApi* | [**extras_graphs_update**](docs/ExtrasApi.md#extras_graphs_update) | **PUT** /extras/graphs/{id}/ | 
*ExtrasApi* | [**extras_image_attachments_create**](docs/ExtrasApi.md#extras_image_attachments_create) | **POST** /extras/image-attachments/ | 
*ExtrasApi* | [**extras_image_attachments_delete**](docs/ExtrasApi.md#extras_image_attachments_delete) | **DELETE** /extras/image-attachments/{id}/ | 
*ExtrasApi* | [**extras_image_attachments_list**](docs/ExtrasApi.md#extras_image_attachments_list) | **GET** /extras/image-attachments/ | 
*ExtrasApi* | [**extras_image_attachments_partial_update**](docs/ExtrasApi.md#extras_image_attachments_partial_update) | **PATCH** /extras/image-attachments/{id}/ | 
*ExtrasApi* | [**extras_image_attachments_read**](docs/ExtrasApi.md#extras_image_attachments_read) | **GET** /extras/image-attachments/{id}/ | 
*ExtrasApi* | [**extras_image_attachments_update**](docs/ExtrasApi.md#extras_image_attachments_update) | **PUT** /extras/image-attachments/{id}/ | 
*ExtrasApi* | [**extras_object_changes_list**](docs/ExtrasApi.md#extras_object_changes_list) | **GET** /extras/object-changes/ | 
*ExtrasApi* | [**extras_object_changes_read**](docs/ExtrasApi.md#extras_object_changes_read) | **GET** /extras/object-changes/{id}/ | 
*ExtrasApi* | [**extras_reports_list**](docs/ExtrasApi.md#extras_reports_list) | **GET** /extras/reports/ | 
*ExtrasApi* | [**extras_reports_read**](docs/ExtrasApi.md#extras_reports_read) | **GET** /extras/reports/{id}/ | 
*ExtrasApi* | [**extras_reports_run**](docs/ExtrasApi.md#extras_reports_run) | **POST** /extras/reports/{id}/run/ | 
*ExtrasApi* | [**extras_scripts_list**](docs/ExtrasApi.md#extras_scripts_list) | **GET** /extras/scripts/ | 
*ExtrasApi* | [**extras_scripts_read**](docs/ExtrasApi.md#extras_scripts_read) | **GET** /extras/scripts/{id}/ | 
*ExtrasApi* | [**extras_tags_create**](docs/ExtrasApi.md#extras_tags_create) | **POST** /extras/tags/ | 
*ExtrasApi* | [**extras_tags_delete**](docs/ExtrasApi.md#extras_tags_delete) | **DELETE** /extras/tags/{id}/ | 
*ExtrasApi* | [**extras_tags_list**](docs/ExtrasApi.md#extras_tags_list) | **GET** /extras/tags/ | 
*ExtrasApi* | [**extras_tags_partial_update**](docs/ExtrasApi.md#extras_tags_partial_update) | **PATCH** /extras/tags/{id}/ | 
*ExtrasApi* | [**extras_tags_read**](docs/ExtrasApi.md#extras_tags_read) | **GET** /extras/tags/{id}/ | 
*ExtrasApi* | [**extras_tags_update**](docs/ExtrasApi.md#extras_tags_update) | **PUT** /extras/tags/{id}/ | 
*IpamApi* | [**ipam_aggregates_create**](docs/IpamApi.md#ipam_aggregates_create) | **POST** /ipam/aggregates/ | 
*IpamApi* | [**ipam_aggregates_delete**](docs/IpamApi.md#ipam_aggregates_delete) | **DELETE** /ipam/aggregates/{id}/ | 
*IpamApi* | [**ipam_aggregates_list**](docs/IpamApi.md#ipam_aggregates_list) | **GET** /ipam/aggregates/ | 
*IpamApi* | [**ipam_aggregates_partial_update**](docs/IpamApi.md#ipam_aggregates_partial_update) | **PATCH** /ipam/aggregates/{id}/ | 
*IpamApi* | [**ipam_aggregates_read**](docs/IpamApi.md#ipam_aggregates_read) | **GET** /ipam/aggregates/{id}/ | 
*IpamApi* | [**ipam_aggregates_update**](docs/IpamApi.md#ipam_aggregates_update) | **PUT** /ipam/aggregates/{id}/ | 
*IpamApi* | [**ipam_ip_addresses_create**](docs/IpamApi.md#ipam_ip_addresses_create) | **POST** /ipam/ip-addresses/ | 
*IpamApi* | [**ipam_ip_addresses_delete**](docs/IpamApi.md#ipam_ip_addresses_delete) | **DELETE** /ipam/ip-addresses/{id}/ | 
*IpamApi* | [**ipam_ip_addresses_list**](docs/IpamApi.md#ipam_ip_addresses_list) | **GET** /ipam/ip-addresses/ | 
*IpamApi* | [**ipam_ip_addresses_partial_update**](docs/IpamApi.md#ipam_ip_addresses_partial_update) | **PATCH** /ipam/ip-addresses/{id}/ | 
*IpamApi* | [**ipam_ip_addresses_read**](docs/IpamApi.md#ipam_ip_addresses_read) | **GET** /ipam/ip-addresses/{id}/ | 
*IpamApi* | [**ipam_ip_addresses_update**](docs/IpamApi.md#ipam_ip_addresses_update) | **PUT** /ipam/ip-addresses/{id}/ | 
*IpamApi* | [**ipam_prefixes_available_ips_create**](docs/IpamApi.md#ipam_prefixes_available_ips_create) | **POST** /ipam/prefixes/{id}/available-ips/ | 
*IpamApi* | [**ipam_prefixes_available_ips_read**](docs/IpamApi.md#ipam_prefixes_available_ips_read) | **GET** /ipam/prefixes/{id}/available-ips/ | 
*IpamApi* | [**ipam_prefixes_available_prefixes_create**](docs/IpamApi.md#ipam_prefixes_available_prefixes_create) | **POST** /ipam/prefixes/{id}/available-prefixes/ | A convenience method for returning available child prefixes within a parent.
*IpamApi* | [**ipam_prefixes_available_prefixes_read**](docs/IpamApi.md#ipam_prefixes_available_prefixes_read) | **GET** /ipam/prefixes/{id}/available-prefixes/ | A convenience method for returning available child prefixes within a parent.
*IpamApi* | [**ipam_prefixes_create**](docs/IpamApi.md#ipam_prefixes_create) | **POST** /ipam/prefixes/ | 
*IpamApi* | [**ipam_prefixes_delete**](docs/IpamApi.md#ipam_prefixes_delete) | **DELETE** /ipam/prefixes/{id}/ | 
*IpamApi* | [**ipam_prefixes_list**](docs/IpamApi.md#ipam_prefixes_list) | **GET** /ipam/prefixes/ | 
*IpamApi* | [**ipam_prefixes_partial_update**](docs/IpamApi.md#ipam_prefixes_partial_update) | **PATCH** /ipam/prefixes/{id}/ | 
*IpamApi* | [**ipam_prefixes_read**](docs/IpamApi.md#ipam_prefixes_read) | **GET** /ipam/prefixes/{id}/ | 
*IpamApi* | [**ipam_prefixes_update**](docs/IpamApi.md#ipam_prefixes_update) | **PUT** /ipam/prefixes/{id}/ | 
*IpamApi* | [**ipam_rirs_create**](docs/IpamApi.md#ipam_rirs_create) | **POST** /ipam/rirs/ | 
*IpamApi* | [**ipam_rirs_delete**](docs/IpamApi.md#ipam_rirs_delete) | **DELETE** /ipam/rirs/{id}/ | 
*IpamApi* | [**ipam_rirs_list**](docs/IpamApi.md#ipam_rirs_list) | **GET** /ipam/rirs/ | 
*IpamApi* | [**ipam_rirs_partial_update**](docs/IpamApi.md#ipam_rirs_partial_update) | **PATCH** /ipam/rirs/{id}/ | 
*IpamApi* | [**ipam_rirs_read**](docs/IpamApi.md#ipam_rirs_read) | **GET** /ipam/rirs/{id}/ | 
*IpamApi* | [**ipam_rirs_update**](docs/IpamApi.md#ipam_rirs_update) | **PUT** /ipam/rirs/{id}/ | 
*IpamApi* | [**ipam_roles_create**](docs/IpamApi.md#ipam_roles_create) | **POST** /ipam/roles/ | 
*IpamApi* | [**ipam_roles_delete**](docs/IpamApi.md#ipam_roles_delete) | **DELETE** /ipam/roles/{id}/ | 
*IpamApi* | [**ipam_roles_list**](docs/IpamApi.md#ipam_roles_list) | **GET** /ipam/roles/ | 
*IpamApi* | [**ipam_roles_partial_update**](docs/IpamApi.md#ipam_roles_partial_update) | **PATCH** /ipam/roles/{id}/ | 
*IpamApi* | [**ipam_roles_read**](docs/IpamApi.md#ipam_roles_read) | **GET** /ipam/roles/{id}/ | 
*IpamApi* | [**ipam_roles_update**](docs/IpamApi.md#ipam_roles_update) | **PUT** /ipam/roles/{id}/ | 
*IpamApi* | [**ipam_services_create**](docs/IpamApi.md#ipam_services_create) | **POST** /ipam/services/ | 
*IpamApi* | [**ipam_services_delete**](docs/IpamApi.md#ipam_services_delete) | **DELETE** /ipam/services/{id}/ | 
*IpamApi* | [**ipam_services_list**](docs/IpamApi.md#ipam_services_list) | **GET** /ipam/services/ | 
*IpamApi* | [**ipam_services_partial_update**](docs/IpamApi.md#ipam_services_partial_update) | **PATCH** /ipam/services/{id}/ | 
*IpamApi* | [**ipam_services_read**](docs/IpamApi.md#ipam_services_read) | **GET** /ipam/services/{id}/ | 
*IpamApi* | [**ipam_services_update**](docs/IpamApi.md#ipam_services_update) | **PUT** /ipam/services/{id}/ | 
*IpamApi* | [**ipam_vlan_groups_create**](docs/IpamApi.md#ipam_vlan_groups_create) | **POST** /ipam/vlan-groups/ | 
*IpamApi* | [**ipam_vlan_groups_delete**](docs/IpamApi.md#ipam_vlan_groups_delete) | **DELETE** /ipam/vlan-groups/{id}/ | 
*IpamApi* | [**ipam_vlan_groups_list**](docs/IpamApi.md#ipam_vlan_groups_list) | **GET** /ipam/vlan-groups/ | 
*IpamApi* | [**ipam_vlan_groups_partial_update**](docs/IpamApi.md#ipam_vlan_groups_partial_update) | **PATCH** /ipam/vlan-groups/{id}/ | 
*IpamApi* | [**ipam_vlan_groups_read**](docs/IpamApi.md#ipam_vlan_groups_read) | **GET** /ipam/vlan-groups/{id}/ | 
*IpamApi* | [**ipam_vlan_groups_update**](docs/IpamApi.md#ipam_vlan_groups_update) | **PUT** /ipam/vlan-groups/{id}/ | 
*IpamApi* | [**ipam_vlans_create**](docs/IpamApi.md#ipam_vlans_create) | **POST** /ipam/vlans/ | 
*IpamApi* | [**ipam_vlans_delete**](docs/IpamApi.md#ipam_vlans_delete) | **DELETE** /ipam/vlans/{id}/ | 
*IpamApi* | [**ipam_vlans_list**](docs/IpamApi.md#ipam_vlans_list) | **GET** /ipam/vlans/ | 
*IpamApi* | [**ipam_vlans_partial_update**](docs/IpamApi.md#ipam_vlans_partial_update) | **PATCH** /ipam/vlans/{id}/ | 
*IpamApi* | [**ipam_vlans_read**](docs/IpamApi.md#ipam_vlans_read) | **GET** /ipam/vlans/{id}/ | 
*IpamApi* | [**ipam_vlans_update**](docs/IpamApi.md#ipam_vlans_update) | **PUT** /ipam/vlans/{id}/ | 
*IpamApi* | [**ipam_vrfs_create**](docs/IpamApi.md#ipam_vrfs_create) | **POST** /ipam/vrfs/ | 
*IpamApi* | [**ipam_vrfs_delete**](docs/IpamApi.md#ipam_vrfs_delete) | **DELETE** /ipam/vrfs/{id}/ | 
*IpamApi* | [**ipam_vrfs_list**](docs/IpamApi.md#ipam_vrfs_list) | **GET** /ipam/vrfs/ | 
*IpamApi* | [**ipam_vrfs_partial_update**](docs/IpamApi.md#ipam_vrfs_partial_update) | **PATCH** /ipam/vrfs/{id}/ | 
*IpamApi* | [**ipam_vrfs_read**](docs/IpamApi.md#ipam_vrfs_read) | **GET** /ipam/vrfs/{id}/ | 
*IpamApi* | [**ipam_vrfs_update**](docs/IpamApi.md#ipam_vrfs_update) | **PUT** /ipam/vrfs/{id}/ | 
*SecretsApi* | [**secrets_generate_rsa_key_pair_list**](docs/SecretsApi.md#secrets_generate_rsa_key_pair_list) | **GET** /secrets/generate-rsa-key-pair/ | This endpoint can be used to generate a new RSA key pair. The keys are returned in PEM format.
*SecretsApi* | [**secrets_get_session_key_create**](docs/SecretsApi.md#secrets_get_session_key_create) | **POST** /secrets/get-session-key/ | 
*SecretsApi* | [**secrets_secret_roles_create**](docs/SecretsApi.md#secrets_secret_roles_create) | **POST** /secrets/secret-roles/ | 
*SecretsApi* | [**secrets_secret_roles_delete**](docs/SecretsApi.md#secrets_secret_roles_delete) | **DELETE** /secrets/secret-roles/{id}/ | 
*SecretsApi* | [**secrets_secret_roles_list**](docs/SecretsApi.md#secrets_secret_roles_list) | **GET** /secrets/secret-roles/ | 
*SecretsApi* | [**secrets_secret_roles_partial_update**](docs/SecretsApi.md#secrets_secret_roles_partial_update) | **PATCH** /secrets/secret-roles/{id}/ | 
*SecretsApi* | [**secrets_secret_roles_read**](docs/SecretsApi.md#secrets_secret_roles_read) | **GET** /secrets/secret-roles/{id}/ | 
*SecretsApi* | [**secrets_secret_roles_update**](docs/SecretsApi.md#secrets_secret_roles_update) | **PUT** /secrets/secret-roles/{id}/ | 
*SecretsApi* | [**secrets_secrets_create**](docs/SecretsApi.md#secrets_secrets_create) | **POST** /secrets/secrets/ | 
*SecretsApi* | [**secrets_secrets_delete**](docs/SecretsApi.md#secrets_secrets_delete) | **DELETE** /secrets/secrets/{id}/ | 
*SecretsApi* | [**secrets_secrets_list**](docs/SecretsApi.md#secrets_secrets_list) | **GET** /secrets/secrets/ | 
*SecretsApi* | [**secrets_secrets_partial_update**](docs/SecretsApi.md#secrets_secrets_partial_update) | **PATCH** /secrets/secrets/{id}/ | 
*SecretsApi* | [**secrets_secrets_read**](docs/SecretsApi.md#secrets_secrets_read) | **GET** /secrets/secrets/{id}/ | 
*SecretsApi* | [**secrets_secrets_update**](docs/SecretsApi.md#secrets_secrets_update) | **PUT** /secrets/secrets/{id}/ | 
*TenancyApi* | [**tenancy_tenant_groups_create**](docs/TenancyApi.md#tenancy_tenant_groups_create) | **POST** /tenancy/tenant-groups/ | 
*TenancyApi* | [**tenancy_tenant_groups_delete**](docs/TenancyApi.md#tenancy_tenant_groups_delete) | **DELETE** /tenancy/tenant-groups/{id}/ | 
*TenancyApi* | [**tenancy_tenant_groups_list**](docs/TenancyApi.md#tenancy_tenant_groups_list) | **GET** /tenancy/tenant-groups/ | 
*TenancyApi* | [**tenancy_tenant_groups_partial_update**](docs/TenancyApi.md#tenancy_tenant_groups_partial_update) | **PATCH** /tenancy/tenant-groups/{id}/ | 
*TenancyApi* | [**tenancy_tenant_groups_read**](docs/TenancyApi.md#tenancy_tenant_groups_read) | **GET** /tenancy/tenant-groups/{id}/ | 
*TenancyApi* | [**tenancy_tenant_groups_update**](docs/TenancyApi.md#tenancy_tenant_groups_update) | **PUT** /tenancy/tenant-groups/{id}/ | 
*TenancyApi* | [**tenancy_tenants_create**](docs/TenancyApi.md#tenancy_tenants_create) | **POST** /tenancy/tenants/ | 
*TenancyApi* | [**tenancy_tenants_delete**](docs/TenancyApi.md#tenancy_tenants_delete) | **DELETE** /tenancy/tenants/{id}/ | 
*TenancyApi* | [**tenancy_tenants_list**](docs/TenancyApi.md#tenancy_tenants_list) | **GET** /tenancy/tenants/ | 
*TenancyApi* | [**tenancy_tenants_partial_update**](docs/TenancyApi.md#tenancy_tenants_partial_update) | **PATCH** /tenancy/tenants/{id}/ | 
*TenancyApi* | [**tenancy_tenants_read**](docs/TenancyApi.md#tenancy_tenants_read) | **GET** /tenancy/tenants/{id}/ | 
*TenancyApi* | [**tenancy_tenants_update**](docs/TenancyApi.md#tenancy_tenants_update) | **PUT** /tenancy/tenants/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_groups_create**](docs/VirtualizationApi.md#virtualization_cluster_groups_create) | **POST** /virtualization/cluster-groups/ | 
*VirtualizationApi* | [**virtualization_cluster_groups_delete**](docs/VirtualizationApi.md#virtualization_cluster_groups_delete) | **DELETE** /virtualization/cluster-groups/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_groups_list**](docs/VirtualizationApi.md#virtualization_cluster_groups_list) | **GET** /virtualization/cluster-groups/ | 
*VirtualizationApi* | [**virtualization_cluster_groups_partial_update**](docs/VirtualizationApi.md#virtualization_cluster_groups_partial_update) | **PATCH** /virtualization/cluster-groups/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_groups_read**](docs/VirtualizationApi.md#virtualization_cluster_groups_read) | **GET** /virtualization/cluster-groups/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_groups_update**](docs/VirtualizationApi.md#virtualization_cluster_groups_update) | **PUT** /virtualization/cluster-groups/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_types_create**](docs/VirtualizationApi.md#virtualization_cluster_types_create) | **POST** /virtualization/cluster-types/ | 
*VirtualizationApi* | [**virtualization_cluster_types_delete**](docs/VirtualizationApi.md#virtualization_cluster_types_delete) | **DELETE** /virtualization/cluster-types/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_types_list**](docs/VirtualizationApi.md#virtualization_cluster_types_list) | **GET** /virtualization/cluster-types/ | 
*VirtualizationApi* | [**virtualization_cluster_types_partial_update**](docs/VirtualizationApi.md#virtualization_cluster_types_partial_update) | **PATCH** /virtualization/cluster-types/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_types_read**](docs/VirtualizationApi.md#virtualization_cluster_types_read) | **GET** /virtualization/cluster-types/{id}/ | 
*VirtualizationApi* | [**virtualization_cluster_types_update**](docs/VirtualizationApi.md#virtualization_cluster_types_update) | **PUT** /virtualization/cluster-types/{id}/ | 
*VirtualizationApi* | [**virtualization_clusters_create**](docs/VirtualizationApi.md#virtualization_clusters_create) | **POST** /virtualization/clusters/ | 
*VirtualizationApi* | [**virtualization_clusters_delete**](docs/VirtualizationApi.md#virtualization_clusters_delete) | **DELETE** /virtualization/clusters/{id}/ | 
*VirtualizationApi* | [**virtualization_clusters_list**](docs/VirtualizationApi.md#virtualization_clusters_list) | **GET** /virtualization/clusters/ | 
*VirtualizationApi* | [**virtualization_clusters_partial_update**](docs/VirtualizationApi.md#virtualization_clusters_partial_update) | **PATCH** /virtualization/clusters/{id}/ | 
*VirtualizationApi* | [**virtualization_clusters_read**](docs/VirtualizationApi.md#virtualization_clusters_read) | **GET** /virtualization/clusters/{id}/ | 
*VirtualizationApi* | [**virtualization_clusters_update**](docs/VirtualizationApi.md#virtualization_clusters_update) | **PUT** /virtualization/clusters/{id}/ | 
*VirtualizationApi* | [**virtualization_interfaces_create**](docs/VirtualizationApi.md#virtualization_interfaces_create) | **POST** /virtualization/interfaces/ | 
*VirtualizationApi* | [**virtualization_interfaces_delete**](docs/VirtualizationApi.md#virtualization_interfaces_delete) | **DELETE** /virtualization/interfaces/{id}/ | 
*VirtualizationApi* | [**virtualization_interfaces_list**](docs/VirtualizationApi.md#virtualization_interfaces_list) | **GET** /virtualization/interfaces/ | 
*VirtualizationApi* | [**virtualization_interfaces_partial_update**](docs/VirtualizationApi.md#virtualization_interfaces_partial_update) | **PATCH** /virtualization/interfaces/{id}/ | 
*VirtualizationApi* | [**virtualization_interfaces_read**](docs/VirtualizationApi.md#virtualization_interfaces_read) | **GET** /virtualization/interfaces/{id}/ | 
*VirtualizationApi* | [**virtualization_interfaces_update**](docs/VirtualizationApi.md#virtualization_interfaces_update) | **PUT** /virtualization/interfaces/{id}/ | 
*VirtualizationApi* | [**virtualization_virtual_machines_create**](docs/VirtualizationApi.md#virtualization_virtual_machines_create) | **POST** /virtualization/virtual-machines/ | 
*VirtualizationApi* | [**virtualization_virtual_machines_delete**](docs/VirtualizationApi.md#virtualization_virtual_machines_delete) | **DELETE** /virtualization/virtual-machines/{id}/ | 
*VirtualizationApi* | [**virtualization_virtual_machines_list**](docs/VirtualizationApi.md#virtualization_virtual_machines_list) | **GET** /virtualization/virtual-machines/ | 
*VirtualizationApi* | [**virtualization_virtual_machines_partial_update**](docs/VirtualizationApi.md#virtualization_virtual_machines_partial_update) | **PATCH** /virtualization/virtual-machines/{id}/ | 
*VirtualizationApi* | [**virtualization_virtual_machines_read**](docs/VirtualizationApi.md#virtualization_virtual_machines_read) | **GET** /virtualization/virtual-machines/{id}/ | 
*VirtualizationApi* | [**virtualization_virtual_machines_update**](docs/VirtualizationApi.md#virtualization_virtual_machines_update) | **PUT** /virtualization/virtual-machines/{id}/ | 


## Documentation For Models

 - [Action](docs/Action.md)
 - [Aggregate](docs/Aggregate.md)
 - [AvailableIP](docs/AvailableIP.md)
 - [AvailablePrefix](docs/AvailablePrefix.md)
 - [Cable](docs/Cable.md)
 - [Circuit](docs/Circuit.md)
 - [CircuitCircuitTermination](docs/CircuitCircuitTermination.md)
 - [CircuitTermination](docs/CircuitTermination.md)
 - [CircuitType](docs/CircuitType.md)
 - [Cluster](docs/Cluster.md)
 - [ClusterGroup](docs/ClusterGroup.md)
 - [ClusterType](docs/ClusterType.md)
 - [ConfigContext](docs/ConfigContext.md)
 - [ConnectionStatus](docs/ConnectionStatus.md)
 - [ConsolePort](docs/ConsolePort.md)
 - [ConsolePortTemplate](docs/ConsolePortTemplate.md)
 - [ConsoleServerPort](docs/ConsoleServerPort.md)
 - [ConsoleServerPortTemplate](docs/ConsoleServerPortTemplate.md)
 - [Device](docs/Device.md)
 - [DeviceBay](docs/DeviceBay.md)
 - [DeviceBayTemplate](docs/DeviceBayTemplate.md)
 - [DeviceInterface](docs/DeviceInterface.md)
 - [DeviceNAPALM](docs/DeviceNAPALM.md)
 - [DeviceRole](docs/DeviceRole.md)
 - [DeviceType](docs/DeviceType.md)
 - [DeviceWithConfigContext](docs/DeviceWithConfigContext.md)
 - [ExportTemplate](docs/ExportTemplate.md)
 - [Face](docs/Face.md)
 - [Family](docs/Family.md)
 - [FeedLeg](docs/FeedLeg.md)
 - [FrontPort](docs/FrontPort.md)
 - [FrontPortRearPort](docs/FrontPortRearPort.md)
 - [FrontPortTemplate](docs/FrontPortTemplate.md)
 - [Graph](docs/Graph.md)
 - [IPAddress](docs/IPAddress.md)
 - [IPAddressInterface](docs/IPAddressInterface.md)
 - [ImageAttachment](docs/ImageAttachment.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse20017](docs/InlineResponse20017.md)
 - [InlineResponse20018](docs/InlineResponse20018.md)
 - [InlineResponse20019](docs/InlineResponse20019.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse20020](docs/InlineResponse20020.md)
 - [InlineResponse20021](docs/InlineResponse20021.md)
 - [InlineResponse20022](docs/InlineResponse20022.md)
 - [InlineResponse20023](docs/InlineResponse20023.md)
 - [InlineResponse20024](docs/InlineResponse20024.md)
 - [InlineResponse20025](docs/InlineResponse20025.md)
 - [InlineResponse20026](docs/InlineResponse20026.md)
 - [InlineResponse20027](docs/InlineResponse20027.md)
 - [InlineResponse20028](docs/InlineResponse20028.md)
 - [InlineResponse20029](docs/InlineResponse20029.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse20030](docs/InlineResponse20030.md)
 - [InlineResponse20031](docs/InlineResponse20031.md)
 - [InlineResponse20032](docs/InlineResponse20032.md)
 - [InlineResponse20033](docs/InlineResponse20033.md)
 - [InlineResponse20034](docs/InlineResponse20034.md)
 - [InlineResponse20035](docs/InlineResponse20035.md)
 - [InlineResponse20036](docs/InlineResponse20036.md)
 - [InlineResponse20037](docs/InlineResponse20037.md)
 - [InlineResponse20038](docs/InlineResponse20038.md)
 - [InlineResponse20039](docs/InlineResponse20039.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse20040](docs/InlineResponse20040.md)
 - [InlineResponse20041](docs/InlineResponse20041.md)
 - [InlineResponse20042](docs/InlineResponse20042.md)
 - [InlineResponse20043](docs/InlineResponse20043.md)
 - [InlineResponse20044](docs/InlineResponse20044.md)
 - [InlineResponse20045](docs/InlineResponse20045.md)
 - [InlineResponse20046](docs/InlineResponse20046.md)
 - [InlineResponse20047](docs/InlineResponse20047.md)
 - [InlineResponse20048](docs/InlineResponse20048.md)
 - [InlineResponse20049](docs/InlineResponse20049.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse20050](docs/InlineResponse20050.md)
 - [InlineResponse20051](docs/InlineResponse20051.md)
 - [InlineResponse20052](docs/InlineResponse20052.md)
 - [InlineResponse20053](docs/InlineResponse20053.md)
 - [InlineResponse20054](docs/InlineResponse20054.md)
 - [InlineResponse20055](docs/InlineResponse20055.md)
 - [InlineResponse20056](docs/InlineResponse20056.md)
 - [InlineResponse20057](docs/InlineResponse20057.md)
 - [InlineResponse20058](docs/InlineResponse20058.md)
 - [InlineResponse20059](docs/InlineResponse20059.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse20060](docs/InlineResponse20060.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InterfaceConnection](docs/InterfaceConnection.md)
 - [InterfaceTemplate](docs/InterfaceTemplate.md)
 - [InventoryItem](docs/InventoryItem.md)
 - [LengthUnit](docs/LengthUnit.md)
 - [Manufacturer](docs/Manufacturer.md)
 - [Mode](docs/Mode.md)
 - [NestedCable](docs/NestedCable.md)
 - [NestedCircuit](docs/NestedCircuit.md)
 - [NestedCircuitType](docs/NestedCircuitType.md)
 - [NestedCluster](docs/NestedCluster.md)
 - [NestedClusterGroup](docs/NestedClusterGroup.md)
 - [NestedClusterType](docs/NestedClusterType.md)
 - [NestedDevice](docs/NestedDevice.md)
 - [NestedDeviceRole](docs/NestedDeviceRole.md)
 - [NestedDeviceType](docs/NestedDeviceType.md)
 - [NestedIPAddress](docs/NestedIPAddress.md)
 - [NestedInterface](docs/NestedInterface.md)
 - [NestedManufacturer](docs/NestedManufacturer.md)
 - [NestedPlatform](docs/NestedPlatform.md)
 - [NestedPowerPanel](docs/NestedPowerPanel.md)
 - [NestedPowerPort](docs/NestedPowerPort.md)
 - [NestedPowerPortTemplate](docs/NestedPowerPortTemplate.md)
 - [NestedProvider](docs/NestedProvider.md)
 - [NestedRIR](docs/NestedRIR.md)
 - [NestedRack](docs/NestedRack.md)
 - [NestedRackGroup](docs/NestedRackGroup.md)
 - [NestedRackRole](docs/NestedRackRole.md)
 - [NestedRearPortTemplate](docs/NestedRearPortTemplate.md)
 - [NestedRegion](docs/NestedRegion.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedSecretRole](docs/NestedSecretRole.md)
 - [NestedSite](docs/NestedSite.md)
 - [NestedTenant](docs/NestedTenant.md)
 - [NestedTenantGroup](docs/NestedTenantGroup.md)
 - [NestedUser](docs/NestedUser.md)
 - [NestedVLAN](docs/NestedVLAN.md)
 - [NestedVLANGroup](docs/NestedVLANGroup.md)
 - [NestedVRF](docs/NestedVRF.md)
 - [NestedVirtualChassis](docs/NestedVirtualChassis.md)
 - [NestedVirtualMachine](docs/NestedVirtualMachine.md)
 - [ObjectChange](docs/ObjectChange.md)
 - [OuterUnit](docs/OuterUnit.md)
 - [Phase](docs/Phase.md)
 - [Platform](docs/Platform.md)
 - [PowerFeed](docs/PowerFeed.md)
 - [PowerOutlet](docs/PowerOutlet.md)
 - [PowerOutletTemplate](docs/PowerOutletTemplate.md)
 - [PowerPanel](docs/PowerPanel.md)
 - [PowerPort](docs/PowerPort.md)
 - [PowerPortTemplate](docs/PowerPortTemplate.md)
 - [Prefix](docs/Prefix.md)
 - [Protocol](docs/Protocol.md)
 - [Provider](docs/Provider.md)
 - [RIR](docs/RIR.md)
 - [Rack](docs/Rack.md)
 - [RackGroup](docs/RackGroup.md)
 - [RackReservation](docs/RackReservation.md)
 - [RackRole](docs/RackRole.md)
 - [RackUnit](docs/RackUnit.md)
 - [RearPort](docs/RearPort.md)
 - [RearPortTemplate](docs/RearPortTemplate.md)
 - [Region](docs/Region.md)
 - [Role](docs/Role.md)
 - [Role1](docs/Role1.md)
 - [Secret](docs/Secret.md)
 - [SecretRole](docs/SecretRole.md)
 - [Service](docs/Service.md)
 - [Site](docs/Site.md)
 - [Status](docs/Status.md)
 - [Status1](docs/Status1.md)
 - [Status2](docs/Status2.md)
 - [Status3](docs/Status3.md)
 - [Status4](docs/Status4.md)
 - [Status5](docs/Status5.md)
 - [Status6](docs/Status6.md)
 - [Status7](docs/Status7.md)
 - [Status8](docs/Status8.md)
 - [Status9](docs/Status9.md)
 - [SubdeviceRole](docs/SubdeviceRole.md)
 - [Supply](docs/Supply.md)
 - [Tag](docs/Tag.md)
 - [TemplateLanguage](docs/TemplateLanguage.md)
 - [Tenant](docs/Tenant.md)
 - [TenantGroup](docs/TenantGroup.md)
 - [Type](docs/Type.md)
 - [Type1](docs/Type1.md)
 - [Type2](docs/Type2.md)
 - [Type3](docs/Type3.md)
 - [Type4](docs/Type4.md)
 - [Type5](docs/Type5.md)
 - [Type6](docs/Type6.md)
 - [Type7](docs/Type7.md)
 - [VLAN](docs/VLAN.md)
 - [VLANGroup](docs/VLANGroup.md)
 - [VRF](docs/VRF.md)
 - [VirtualChassis](docs/VirtualChassis.md)
 - [VirtualMachineInterface](docs/VirtualMachineInterface.md)
 - [VirtualMachineWithConfigContext](docs/VirtualMachineWithConfigContext.md)
 - [Width](docs/Width.md)
 - [WritableAggregate](docs/WritableAggregate.md)
 - [WritableCable](docs/WritableCable.md)
 - [WritableCircuit](docs/WritableCircuit.md)
 - [WritableCircuitTermination](docs/WritableCircuitTermination.md)
 - [WritableCluster](docs/WritableCluster.md)
 - [WritableConfigContext](docs/WritableConfigContext.md)
 - [WritableConsolePort](docs/WritableConsolePort.md)
 - [WritableConsolePortTemplate](docs/WritableConsolePortTemplate.md)
 - [WritableConsoleServerPort](docs/WritableConsoleServerPort.md)
 - [WritableConsoleServerPortTemplate](docs/WritableConsoleServerPortTemplate.md)
 - [WritableDeviceBay](docs/WritableDeviceBay.md)
 - [WritableDeviceBayTemplate](docs/WritableDeviceBayTemplate.md)
 - [WritableDeviceInterface](docs/WritableDeviceInterface.md)
 - [WritableDeviceType](docs/WritableDeviceType.md)
 - [WritableDeviceWithConfigContext](docs/WritableDeviceWithConfigContext.md)
 - [WritableExportTemplate](docs/WritableExportTemplate.md)
 - [WritableFrontPort](docs/WritableFrontPort.md)
 - [WritableFrontPortTemplate](docs/WritableFrontPortTemplate.md)
 - [WritableIPAddress](docs/WritableIPAddress.md)
 - [WritableInterfaceTemplate](docs/WritableInterfaceTemplate.md)
 - [WritableInventoryItem](docs/WritableInventoryItem.md)
 - [WritablePlatform](docs/WritablePlatform.md)
 - [WritablePowerFeed](docs/WritablePowerFeed.md)
 - [WritablePowerOutlet](docs/WritablePowerOutlet.md)
 - [WritablePowerOutletTemplate](docs/WritablePowerOutletTemplate.md)
 - [WritablePowerPanel](docs/WritablePowerPanel.md)
 - [WritablePowerPort](docs/WritablePowerPort.md)
 - [WritablePowerPortTemplate](docs/WritablePowerPortTemplate.md)
 - [WritablePrefix](docs/WritablePrefix.md)
 - [WritableRack](docs/WritableRack.md)
 - [WritableRackGroup](docs/WritableRackGroup.md)
 - [WritableRackReservation](docs/WritableRackReservation.md)
 - [WritableRearPort](docs/WritableRearPort.md)
 - [WritableRearPortTemplate](docs/WritableRearPortTemplate.md)
 - [WritableRegion](docs/WritableRegion.md)
 - [WritableSecret](docs/WritableSecret.md)
 - [WritableService](docs/WritableService.md)
 - [WritableSite](docs/WritableSite.md)
 - [WritableTenant](docs/WritableTenant.md)
 - [WritableTenantGroup](docs/WritableTenantGroup.md)
 - [WritableVLAN](docs/WritableVLAN.md)
 - [WritableVLANGroup](docs/WritableVLANGroup.md)
 - [WritableVRF](docs/WritableVRF.md)
 - [WritableVirtualChassis](docs/WritableVirtualChassis.md)
 - [WritableVirtualMachineInterface](docs/WritableVirtualMachineInterface.md)
 - [WritableVirtualMachineWithConfigContext](docs/WritableVirtualMachineWithConfigContext.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author



