import sys
import warnings

import pkg_resources

from .abi import (  # noqa: F401
    # event_abi_to_log_topic,
    event_signature_to_log_topic,
    function_abi_to_4byte_selector,
    function_signature_to_4byte_selector,
    # topic_decode,
)
from .address import (  # noqa: F401
    is_address,
    is_binary_address,
    is_canonical_address,
    is_checksum_address,
    is_checksum_formatted_address,
    is_hex_address,
    is_normalized_address,
    is_same_address,
    to_canonical_address,
    to_checksum_address,
    to_normalized_address,
)
from .applicators import (  # noqa: F401
    apply_formatter_at_index,
    apply_formatter_if,
    apply_formatter_to_array,
    apply_formatters_to_dict,
    apply_formatters_to_sequence,
    apply_key_map,
    apply_one_of_formatters,
    combine_argument_formatters,
)
from .conversions import (  # noqa: F401
    hexstr_if_str,
    text_if_str,
    to_bytes,
    to_hex,
    to_int,
    to_text,
)
from .crypto import keccak  # noqa: F401
from .currency import denoms, from_wei, to_wei  # noqa: F401
from .decorators import combomethod, replace_exceptions  # noqa: F401
from .encoding import big_endian_to_int, int_to_big_endian  # noqa: F401
from .exceptions import ValidationError  # noqa: F401
from .functional import (  # noqa: F401
    apply_to_return_value,
    flatten_return,
    reversed_return,
    sort_return,
    to_dict,
    to_list,
    to_ordered_dict,
    to_set,
    to_tuple,
)
from .hexadecimal import (  # noqa: F401
    add_0x_prefix,
    decode_hex,
    encode_hex,
    is_0x_prefixed,
    is_hex,
    is_hexstr,
    remove_0x_prefix,
)
from .humanize import (  # noqa: F401
    humanize_bytes,
    humanize_hash,
    humanize_integer_sequence,
    humanize_ipfs_uri,
    humanize_seconds,
)
from .logging import (  # noqa: F401
    DEBUG2_LEVEL_NUM,
    ExtendedDebugLogger,
    HasExtendedDebugLogger,
    HasExtendedDebugLoggerMeta,
    HasLogger,
    HasLoggerMeta,
    get_extended_debug_logger,
    get_logger,
    setup_DEBUG2_logging,
)
from .module_loading import import_string  # noqa: F401
from .numeric import clamp  # noqa: F401
from .types import (  # noqa: F401
    is_boolean,
    is_bytes,
    is_dict,
    is_integer,
    is_list,
    is_list_like,
    is_null,
    is_number,
    is_string,
    is_text,
    is_tuple,
)

if sys.version_info.major < 3:
    warnings.simplefilter("always", DeprecationWarning)
    warnings.warn(
        DeprecationWarning(
            "The `eth-utils` library has dropped support for Python 2. Upgrade to Python 3."
        )
    )
    warnings.resetwarnings()


# __version__ = pkg_resources.get_distribution("eth-utils").version
