"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontendWebAppDeployStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_cloudfront_origin_bucket_1 = require("@gammarer/aws-secure-cloudfront-origin-bucket");
const aws_secure_frontend_web_app_cloudfront_distribution_1 = require("@gammarer/aws-secure-frontend-web-app-cloudfront-distribution");
const cdk = require("aws-cdk-lib");
const acm = require("aws-cdk-lib/aws-certificatemanager");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const route53 = require("aws-cdk-lib/aws-route53");
const alias = require("aws-cdk-lib/aws-route53-targets");
const s3 = require("aws-cdk-lib/aws-s3");
const s3deploy = require("aws-cdk-lib/aws-s3-deployment");
class FrontendWebAppDeployStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // 👇Create CloudFront Origin Access Identity.
        const oai = new cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        // 👇Create Secure Cloud Front Origin Bucket
        const originBucket = new aws_secure_cloudfront_origin_bucket_1.SecureCloudFrontOriginBucket(this, 'SecureCloudFrontOriginBucket', {
            bucketName: props.originBucketName,
            cloudFrontOriginAccessIdentityS3CanonicalUserId: oai.cloudFrontOriginAccessIdentityS3CanonicalUserId,
        });
        // 👇Get Hosted Zone.
        const hostedZone = route53.HostedZone.fromHostedZoneAttributes(this, 'HostedZone', {
            hostedZoneId: props.hostedZoneId,
            zoneName: props.domainName,
        });
        // 👇Create Certificate with DNS validate.
        const certificate = new acm.Certificate(this, 'Certificate', {
            domainName: props.domainName,
            validation: acm.CertificateValidation.fromDns(hostedZone),
        });
        // 👇Secure Frontend Web App CloudFront Distribution.
        const distribution = new aws_secure_frontend_web_app_cloudfront_distribution_1.SecureFrontendWebAppCloudFrontDistribution(this, 'SecureFrontendWebAppCloudFrontDistribution', {
            comment: 'frontend web app distribution.',
            accessLogBucket: s3.Bucket.fromBucketArn(this, 'LogBucket', props.logBucketArn),
            certificate: certificate,
            domainName: props.domainName,
            originAccessIdentity: oai,
            originBucket: originBucket,
        });
        // 👇Route 53 DNS (Alias)
        new route53.ARecord(this, 'DNSARecord', {
            zone: hostedZone,
            recordName: props.domainName,
            target: route53.RecordTarget.fromAlias(new alias.CloudFrontTarget(distribution)),
            ttl: cdk.Duration.seconds(300),
        });
        // 👇Deploy to Bucket with CloudFront Cache invalidate
        new s3deploy.BucketDeployment(this, 'DeployWithInvalidation', {
            sources: [s3deploy.Source.asset(props.deploySourceAssetPath)],
            destinationBucket: originBucket,
            prune: true,
            distribution,
            distributionPaths: ['/*'],
        });
    }
}
exports.FrontendWebAppDeployStack = FrontendWebAppDeployStack;
_a = JSII_RTTI_SYMBOL_1;
FrontendWebAppDeployStack[_a] = { fqn: "@gammarer/aws-frontend-web-app-deploy-stack.FrontendWebAppDeployStack", version: "1.1.7" };
//# sourceMappingURL=data:application/json;base64,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