# incqueryserver-api-python-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.18.0rc1
- Package version: 0.18.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import iqs_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import iqs_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import iqs_client
from iqs_client.rest import ApiException
from pprint import pprint

configuration = iqs_client.Configuration()
# Configure HTTP basic authorization: basicAuth
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# Defining host is optional and default to http://localhost/api
configuration.host = "http://localhost/api"
# Enter a context with an instance of the API client
with iqs_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = iqs_client.AcquisitionApi(api_client)
    linked_data_acquisition_request_multipart = iqs_client.LinkedDataAcquisitionRequestMultipart() # LinkedDataAcquisitionRequestMultipart | Upload a linked data file. 

    try:
        # Acquire a linked data document as a model compartment.
        api_response = api_instance.acquire_linked_data(linked_data_acquisition_request_multipart)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AcquisitionApi->acquire_linked_data: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AcquisitionApi* | [**acquire_linked_data**](docs/AcquisitionApi.md#acquire_linked_data) | **POST** /demo.acquireLinkedData | Acquire a linked data document as a model compartment.
*AcquisitionApi* | [**close_acquisition**](docs/AcquisitionApi.md#close_acquisition) | **POST** /acquisition.close | End the acquistion of a compartment, either by finalizing or discarding
*AcquisitionApi* | [**start_acquisition**](docs/AcquisitionApi.md#start_acquisition) | **POST** /acquisition.start | Start the acquistion of a compartment
*AcquisitionApi* | [**upload_acquisition_chunk**](docs/AcquisitionApi.md#upload_acquisition_chunk) | **POST** /acquisition.uploadChunk | Uploads a chunk of content as part of an open acquisition
*AnalysisApi* | [**delete_model_analysis_configuration**](docs/AnalysisApi.md#delete_model_analysis_configuration) | **POST** /analysis.delete | Delete analysis configuration
*AnalysisApi* | [**list_model_analysis_configurations**](docs/AnalysisApi.md#list_model_analysis_configurations) | **GET** /analysis.list | List of registered analysis configurations
*AnalysisApi* | [**model_analysis_configuration_details**](docs/AnalysisApi.md#model_analysis_configuration_details) | **GET** /analysis.details | Retrieve the details of the given analysis configuration
*AnalysisApi* | [**register_model_analysis_configuration**](docs/AnalysisApi.md#register_model_analysis_configuration) | **POST** /analysis.register | Register new analysis configuration
*AnalysisApi* | [**run_model_analysis**](docs/AnalysisApi.md#run_model_analysis) | **POST** /analysis.run | Execute model analysis on given model compartment
*AsyncApi* | [**async_index_model_compartment**](docs/AsyncApi.md#async_index_model_compartment) | **POST** /async.indexModelCompartment | Store modelCompartment in selected indexes asynchronously.
*DemoApi* | [**acquire_linked_data**](docs/DemoApi.md#acquire_linked_data) | **POST** /demo.acquireLinkedData | Acquire a linked data document as a model compartment.
*DemoApi* | [**delete_model_compartment_from_index**](docs/DemoApi.md#delete_model_compartment_from_index) | **POST** /demo.deleteModelCompartment | Delete modelCompartment from selected indexes.
*DemoApi* | [**get_compartment_index_status**](docs/DemoApi.md#get_compartment_index_status) | **POST** /demo.compartmentIndexStatus | Tells which indices the compartment is loaded in.
*DemoApi* | [**get_repository_structure**](docs/DemoApi.md#get_repository_structure) | **GET** /demo.completeStructure | Get repository structure separated by repository types
*DemoApi* | [**list_indexed_model_compartments**](docs/DemoApi.md#list_indexed_model_compartments) | **GET** /demo.indexStatus | List model compartment stored by the index
*DemoApi* | [**list_persisted_model_compartments_with_path**](docs/DemoApi.md#list_persisted_model_compartments_with_path) | **GET** /demo.listModelCompartmentsWithPath | List model compartments with path stored by persistent index.
*DemoApi* | [**repository_structure_compartment_details**](docs/DemoApi.md#repository_structure_compartment_details) | **POST** /demo.compartmentDetails | Returns detailed information about the given model compartment.
*DemoApi* | [**update_model_compartment_index**](docs/DemoApi.md#update_model_compartment_index) | **POST** /demo.indexCompartment | Store modelCompartment in selected indexes.
*DemoApi* | [**update_repository_structure**](docs/DemoApi.md#update_repository_structure) | **POST** /demo.updateStructure | Update complete repository structure
*ImpactAnalysisApi* | [**list_compartments_with_dependent_elements**](docs/ImpactAnalysisApi.md#list_compartments_with_dependent_elements) | **POST** /impact-analysis.listCompartments | Calculates the impact of given Elements, listing model compartments with elements referring to each
*ImpactAnalysisApi* | [**list_dependencies**](docs/ImpactAnalysisApi.md#list_dependencies) | **POST** /impact-analysis.listDependencies | Calculates the impact of given Elements, listing elements referring to each
*ImpactAnalysisApi* | [**list_revisions_with_dependencies**](docs/ImpactAnalysisApi.md#list_revisions_with_dependencies) | **POST** /impact-analysis.listRevisionsWithDependencies | Calculates the impact of given Elements, listing revisions with elements referring to each
*ImpactAnalysisApi* | [**register_md_object_i_ds**](docs/ImpactAnalysisApi.md#register_md_object_i_ds) | **POST** /impact-analysis.register | Registers a list of Elements that should have their dependency information preloaded
*ImpactAnalysisApi* | [**run_impact_analysis_query**](docs/ImpactAnalysisApi.md#run_impact_analysis_query) | **POST** /impact-analysis.run | Calculates the impact of given Elements, listing elements from any model compartment referring to each
*ImpactAnalysisApi* | [**unregister_md_object_i_ds**](docs/ImpactAnalysisApi.md#unregister_md_object_i_ds) | **POST** /impact-analysis.unregister | Unregisters a list of Elements that were previously registered
*InMemoryIndexApi* | [**delete_all_inmemory_model_compartments**](docs/InMemoryIndexApi.md#delete_all_inmemory_model_compartments) | **POST** /inmemory-index.deleteAllModelCompartments | Delete all loaded model compartments from the in-memory index
*InMemoryIndexApi* | [**delete_all_inmemory_revisions**](docs/InMemoryIndexApi.md#delete_all_inmemory_revisions) | **POST** /inmemory-index.deleteAllRevisions | Delete all loaded revisions from the in-memory index
*InMemoryIndexApi* | [**delete_inmemory_model_compartment**](docs/InMemoryIndexApi.md#delete_inmemory_model_compartment) | **POST** /inmemory-index.deleteModelCompartment | Delete loaded model compartment from in-memory index.
*InMemoryIndexApi* | [**delete_inmemory_revision**](docs/InMemoryIndexApi.md#delete_inmemory_revision) | **POST** /inmemory-index.deleteRevision | Delete loaded revision from in-memory index
*InMemoryIndexApi* | [**list_inmemory_model_compartments**](docs/InMemoryIndexApi.md#list_inmemory_model_compartments) | **GET** /inmemory-index.listModelCompartments | List model compartment loaded into in-memory index
*InMemoryIndexApi* | [**list_inmemory_revisions**](docs/InMemoryIndexApi.md#list_inmemory_revisions) | **GET** /inmemory-index.list | List revisions loaded into in-memory index
*InMemoryIndexApi* | [**load_model_compartment**](docs/InMemoryIndexApi.md#load_model_compartment) | **POST** /inmemory-index.loadModelCompartment | Load model compartment from persistent index into in-memory index.
*InMemoryIndexApi* | [**load_revision**](docs/InMemoryIndexApi.md#load_revision) | **POST** /inmemory-index.loadRevision | Load revision from persistent index into in-memory index
*IntegrationApi* | [**aws_neptune_load_model_compartment**](docs/IntegrationApi.md#aws_neptune_load_model_compartment) | **POST** /amazon-neptune-integration.loadModelCompartment | Load model compartment into Amazon Neptune
*IntegrationApi* | [**aws_neptune_load_revision**](docs/IntegrationApi.md#aws_neptune_load_revision) | **POST** /amazon-neptune-integration.loadRevision | Load revision into Amazon Neptune
*IntegrationApi* | [**elastic_search_load_model_compartment**](docs/IntegrationApi.md#elastic_search_load_model_compartment) | **POST** /elastic-search-integration.loadModelCompartment | Load persisted model compartment into Elasticsearch index
*IntegrationApi* | [**elastic_search_load_revision**](docs/IntegrationApi.md#elastic_search_load_revision) | **POST** /elastic-search-integration.loadRevision | Load persisted revision into Elasticsearch index
*MmsRepositoryApi* | [**get_mms_repository_info**](docs/MmsRepositoryApi.md#get_mms_repository_info) | **GET** /mms-repository.info | Get repository structure (orgs, projects, refs, commits)
*MmsRepositoryApi* | [**get_repository_compartment_details**](docs/MmsRepositoryApi.md#get_repository_compartment_details) | **POST** /mms-repository.details | Retrieve detailed repository structure information for an MMS commit.
*MmsRepositoryApi* | [**update_mms_repository**](docs/MmsRepositoryApi.md#update_mms_repository) | **POST** /mms-repository.update | Update repository structure from MMS
*PersistentIndexApi* | [**delete_all_persisted_model_compartments**](docs/PersistentIndexApi.md#delete_all_persisted_model_compartments) | **POST** /persistent-index.deleteAllModelCompartments | Delete all model compartments from persistent index
*PersistentIndexApi* | [**delete_all_persisted_revisions**](docs/PersistentIndexApi.md#delete_all_persisted_revisions) | **POST** /persistent-index.deleteAllRevisions | Delete all revisions from persistent index
*PersistentIndexApi* | [**delete_model_compartment**](docs/PersistentIndexApi.md#delete_model_compartment) | **POST** /persistent-index.deleteModelCompartment | Delete model compartment from persistent index
*PersistentIndexApi* | [**delete_persisted_revision**](docs/PersistentIndexApi.md#delete_persisted_revision) | **POST** /persistent-index.deleteRevision | Delete revision from persistent index
*PersistentIndexApi* | [**delete_transformed_model_compartment**](docs/PersistentIndexApi.md#delete_transformed_model_compartment) | **POST** /persistent-index.deleteTransformedModelCompartment | Delete transformed model compartment.
*PersistentIndexApi* | [**delete_transformed_revision**](docs/PersistentIndexApi.md#delete_transformed_revision) | **POST** /persistent-index.deleteTransformedRevision | Delete transformed revision.
*PersistentIndexApi* | [**download_transformed_model_compartment**](docs/PersistentIndexApi.md#download_transformed_model_compartment) | **POST** /persistent-index.downloadTransformedModelCompartment | Download transformed model compartment.
*PersistentIndexApi* | [**download_transformed_revision**](docs/PersistentIndexApi.md#download_transformed_revision) | **POST** /persistent-index.downloadTransformedRevision | Download transformed revision.
*PersistentIndexApi* | [**get_persisted_model_compartment_details**](docs/PersistentIndexApi.md#get_persisted_model_compartment_details) | **POST** /persistent-index.modelCompartmentDetails | Retrieve detailed information for a persisted model compartment.
*PersistentIndexApi* | [**get_persisted_revision_details**](docs/PersistentIndexApi.md#get_persisted_revision_details) | **POST** /persistent-index.details | Retrieve detailed information for a persisted revision
*PersistentIndexApi* | [**get_persistent_index_info**](docs/PersistentIndexApi.md#get_persistent_index_info) | **GET** /persistent-index.info | Retrieve overall information on the persistent index
*PersistentIndexApi* | [**index_model_compartment**](docs/PersistentIndexApi.md#index_model_compartment) | **POST** /persistent-index.indexModelCompartment | Index model compartment from model repository and store in peristent index.
*PersistentIndexApi* | [**index_model_compartment_delta**](docs/PersistentIndexApi.md#index_model_compartment_delta) | **POST** /persistent-index.indexModelCompartmentDelta | Index model compartment delta and store in persistent index
*PersistentIndexApi* | [**index_revision**](docs/PersistentIndexApi.md#index_revision) | **POST** /persistent-index.indexRevision | Index revision from TWC and store in persistent index
*PersistentIndexApi* | [**index_revision_delta**](docs/PersistentIndexApi.md#index_revision_delta) | **POST** /persistent-index.indexRevisionDelta | Index revision delta from TWC and store in persistent index
*PersistentIndexApi* | [**list_persisted_model_compartments**](docs/PersistentIndexApi.md#list_persisted_model_compartments) | **GET** /persistent-index.listModelCompartments | List model compartments stored by persistent index.
*PersistentIndexApi* | [**list_persisted_revisions**](docs/PersistentIndexApi.md#list_persisted_revisions) | **GET** /persistent-index.list | List revisions stored by the persistent index
*PersistentIndexApi* | [**normalize_delta_based_compartment**](docs/PersistentIndexApi.md#normalize_delta_based_compartment) | **POST** /persistent-index.normalizeDeltaBasedCompartment | Normalize compartment that uses delta headers in persistent index
*PersistentIndexApi* | [**normalize_delta_based_revision**](docs/PersistentIndexApi.md#normalize_delta_based_revision) | **POST** /persistent-index.normalizeDeltaBasedRevision | Normalize revision that uses delta headers in persistent index
*PersistentIndexApi* | [**transform_model_compartment**](docs/PersistentIndexApi.md#transform_model_compartment) | **POST** /persistent-index.transformModelCompartment | Transform persisted model compartment to given model representation format.
*PersistentIndexApi* | [**transform_revision**](docs/PersistentIndexApi.md#transform_revision) | **POST** /persistent-index.transformRevision | Transform persisted revision to given format.
*QueriesApi* | [**get_query_details**](docs/QueriesApi.md#get_query_details) | **GET** /queries.details | Retrieve detailed information for a query specification
*QueriesApi* | [**list_queries**](docs/QueriesApi.md#list_queries) | **GET** /queries.list | List registered query specifications
*QueriesApi* | [**register_queries**](docs/QueriesApi.md#register_queries) | **POST** /queries.register | Register query definitions
*QueriesApi* | [**register_queries_from_model**](docs/QueriesApi.md#register_queries_from_model) | **POST** /queries.registerFromModel | Registers query definitions contained in models uploaded to TWC
*QueriesApi* | [**register_queries_from_model_compartment**](docs/QueriesApi.md#register_queries_from_model_compartment) | **POST** /queries.registerFromModelCompartment | Registers query definitions contained in model compartments.
*QueriesApi* | [**register_queries_plain_text**](docs/QueriesApi.md#register_queries_plain_text) | **POST** /queries.registerPlainText | Register query definitions in plain text format
*QueriesApi* | [**unregister_all_queries**](docs/QueriesApi.md#unregister_all_queries) | **POST** /queries.unregisterAll | Unregister all queries
*QueryExecutionApi* | [**execute_query**](docs/QueryExecutionApi.md#execute_query) | **POST** /query-execution.executeQuery | Execute query on loaded revision
*QueryExecutionApi* | [**execute_query_on_model_compartment**](docs/QueryExecutionApi.md#execute_query_on_model_compartment) | **POST** /generic-query-execution.executeQuery | Execute query on loaded model compartment
*QueryExecutionApi* | [**get_standing_query_results**](docs/QueryExecutionApi.md#get_standing_query_results) | **POST** /query-execution.getStandingQueryResults | Retrieve query results for prepared standing query
*QueryExecutionApi* | [**get_standing_query_results_on_model_compartment**](docs/QueryExecutionApi.md#get_standing_query_results_on_model_compartment) | **POST** /generic-query-execution.getStandingQueryResults | Retrieve query results for prepared standing query
*QueryExecutionApi* | [**prepare_search_based_queries**](docs/QueryExecutionApi.md#prepare_search_based_queries) | **POST** /query-execution.prepareSearchBasedQueries | Prepare search-based query on loaded revision
*QueryExecutionApi* | [**prepare_search_based_queries_on_model_compartment**](docs/QueryExecutionApi.md#prepare_search_based_queries_on_model_compartment) | **POST** /generic-query-execution.prepareSearchBasedQueries | Prepare search-based query on loaded model compartment
*QueryExecutionApi* | [**prepare_standing_queries**](docs/QueryExecutionApi.md#prepare_standing_queries) | **POST** /query-execution.prepareStandingQueries | Prepare standing query on loaded revision
*QueryExecutionApi* | [**prepare_standing_queries_on_model_compartment**](docs/QueryExecutionApi.md#prepare_standing_queries_on_model_compartment) | **POST** /generic-query-execution.prepareStandingQueries | Prepare standing query on loaded model compartment
*RepositoryApi* | [**get_repository_info**](docs/RepositoryApi.md#get_repository_info) | **GET** /repository.info | Get repository structure (workspaces, resources, branches, revisions)
*RepositoryApi* | [**get_repository_revision_details**](docs/RepositoryApi.md#get_repository_revision_details) | **POST** /repository.details | Retrieve detailed repository structure information for a revision
*RepositoryApi* | [**update_repository**](docs/RepositoryApi.md#update_repository) | **POST** /repository.update | Update repository structure from TWC
*ServerManagementApi* | [**get_server_info**](docs/ServerManagementApi.md#get_server_info) | **GET** /server.info | Retrieve information related to the server, including configuration details and available features
*ServerManagementApi* | [**get_server_status**](docs/ServerManagementApi.md#get_server_status) | **GET** /server.status | Retrieve status of the IncQuery Server
*ServerManagementApi* | [**get_server_tasks**](docs/ServerManagementApi.md#get_server_tasks) | **GET** /server.tasks | Retrieve the list of tasks running currently on the server
*ServerManagementApi* | [**list_compartment_operation_states**](docs/ServerManagementApi.md#list_compartment_operation_states) | **POST** /server.operations | Retrieve the operation states currently running on a specific compartment
*ValidationApi* | [**validate_model_compartment**](docs/ValidationApi.md#validate_model_compartment) | **POST** /validation.validateModelCompartment | Validate rules that are defined by queries contained by loaded compartment
*ValidationApi* | [**validate_revision**](docs/ValidationApi.md#validate_revision) | **POST** /validation.validateRevision | Validate rules that are defined by queries contained by loaded revision


## Documentation For Models

 - [AnalysisConfiguration](docs/AnalysisConfiguration.md)
 - [AnalysisConfigurationDetails](docs/AnalysisConfigurationDetails.md)
 - [AnalysisConfigurationIdentifier](docs/AnalysisConfigurationIdentifier.md)
 - [AnalysisConfigurationList](docs/AnalysisConfigurationList.md)
 - [AnalysisExecutionRequest](docs/AnalysisExecutionRequest.md)
 - [AnalysisResult](docs/AnalysisResult.md)
 - [AnalysisResults](docs/AnalysisResults.md)
 - [AnalysisRule](docs/AnalysisRule.md)
 - [AnalysisRuleDetails](docs/AnalysisRuleDetails.md)
 - [AnalysisRuleResult](docs/AnalysisRuleResult.md)
 - [AnalysisRuleResultMatch](docs/AnalysisRuleResultMatch.md)
 - [AnalysisUserErrorResponse](docs/AnalysisUserErrorResponse.md)
 - [Argument](docs/Argument.md)
 - [AsyncIndexMessage](docs/AsyncIndexMessage.md)
 - [AttributeSlot](docs/AttributeSlot.md)
 - [AttributeStoreEntry](docs/AttributeStoreEntry.md)
 - [Branch](docs/Branch.md)
 - [BranchWithDependentElements](docs/BranchWithDependentElements.md)
 - [CloseAcquisitionRequest](docs/CloseAcquisitionRequest.md)
 - [CloseAcquisitionResponse](docs/CloseAcquisitionResponse.md)
 - [CompartmentOperationProgress](docs/CompartmentOperationProgress.md)
 - [CompartmentOperationState](docs/CompartmentOperationState.md)
 - [CompartmentOperationStateDetails](docs/CompartmentOperationStateDetails.md)
 - [CompartmentOperationStatesResponse](docs/CompartmentOperationStatesResponse.md)
 - [CompartmentWithPath](docs/CompartmentWithPath.md)
 - [CompartmentsWithPathResponse](docs/CompartmentsWithPathResponse.md)
 - [DependentElementDescriptor](docs/DependentElementDescriptor.md)
 - [DependentElementDetails](docs/DependentElementDetails.md)
 - [DependentElementInCompartmentDescriptor](docs/DependentElementInCompartmentDescriptor.md)
 - [DependentElementInRevision](docs/DependentElementInRevision.md)
 - [DependentElementWithLink](docs/DependentElementWithLink.md)
 - [DuplicatedElements](docs/DuplicatedElements.md)
 - [EAttributeDescriptor](docs/EAttributeDescriptor.md)
 - [EClassifierDescriptor](docs/EClassifierDescriptor.md)
 - [EReferenceDescriptor](docs/EReferenceDescriptor.md)
 - [ElementDescriptor](docs/ElementDescriptor.md)
 - [ElementIDList](docs/ElementIDList.md)
 - [ElementInCompartmentDescriptor](docs/ElementInCompartmentDescriptor.md)
 - [ElementInCompartmentWithLink](docs/ElementInCompartmentWithLink.md)
 - [ElementStoreEntry](docs/ElementStoreEntry.md)
 - [ElementWithOSMCLink](docs/ElementWithOSMCLink.md)
 - [Error](docs/Error.md)
 - [ErrorDetails](docs/ErrorDetails.md)
 - [ExecuteQueryOnCompartmentRequest](docs/ExecuteQueryOnCompartmentRequest.md)
 - [ExecuteQueryRequest](docs/ExecuteQueryRequest.md)
 - [FeatureDescriptorProxy](docs/FeatureDescriptorProxy.md)
 - [GenericValidationMatchingElement](docs/GenericValidationMatchingElement.md)
 - [GenericValidationResults](docs/GenericValidationResults.md)
 - [GenericValidationRule](docs/GenericValidationRule.md)
 - [ImpactAnalysisQueryResponse](docs/ImpactAnalysisQueryResponse.md)
 - [ImpactAnalysisResourceStatistics](docs/ImpactAnalysisResourceStatistics.md)
 - [ImpactAnalysisResult](docs/ImpactAnalysisResult.md)
 - [Index](docs/Index.md)
 - [IndexCompartment](docs/IndexCompartment.md)
 - [IndexMessage](docs/IndexMessage.md)
 - [IndexModelCompartmentDeltaRequest](docs/IndexModelCompartmentDeltaRequest.md)
 - [IndexRevisionDeltaRequest](docs/IndexRevisionDeltaRequest.md)
 - [IndexTypes](docs/IndexTypes.md)
 - [IndexUpdateData](docs/IndexUpdateData.md)
 - [JamaProjectDescriptor](docs/JamaProjectDescriptor.md)
 - [JamaRepositoryStructure](docs/JamaRepositoryStructure.md)
 - [JamaSnapshotDetails](docs/JamaSnapshotDetails.md)
 - [JiraProjectDescriptor](docs/JiraProjectDescriptor.md)
 - [JiraRepositoryStructure](docs/JiraRepositoryStructure.md)
 - [KPI](docs/KPI.md)
 - [LinkedDataAcquisitionRequestMetadata](docs/LinkedDataAcquisitionRequestMetadata.md)
 - [LinkedDataAcquisitionRequestMultipart](docs/LinkedDataAcquisitionRequestMultipart.md)
 - [LinkedDataDocumentMetadata](docs/LinkedDataDocumentMetadata.md)
 - [LinkedDataFormat](docs/LinkedDataFormat.md)
 - [ListCompartmentsResponse](docs/ListCompartmentsResponse.md)
 - [ListCompartmentsWithDependentElementsResponse](docs/ListCompartmentsWithDependentElementsResponse.md)
 - [ListDependenciesResponse](docs/ListDependenciesResponse.md)
 - [ListDependentElementsResponse](docs/ListDependentElementsResponse.md)
 - [ListDependentModelCompartments](docs/ListDependentModelCompartments.md)
 - [ListDependentRevisionsResponse](docs/ListDependentRevisionsResponse.md)
 - [ListInmemoryModelCompartmentsResponse](docs/ListInmemoryModelCompartmentsResponse.md)
 - [ListInmemoryRevisionsResponse](docs/ListInmemoryRevisionsResponse.md)
 - [ListPersistedModelCompartmentsResponse](docs/ListPersistedModelCompartmentsResponse.md)
 - [ListPersistedRevisionsResponse](docs/ListPersistedRevisionsResponse.md)
 - [ListRevisionsWithDependenciesResponse](docs/ListRevisionsWithDependenciesResponse.md)
 - [MDObjectIDList](docs/MDObjectIDList.md)
 - [MMSCommit](docs/MMSCommit.md)
 - [MMSCommitDescriptor](docs/MMSCommitDescriptor.md)
 - [MMSCommitDetails](docs/MMSCommitDetails.md)
 - [MMSOrganization](docs/MMSOrganization.md)
 - [MMSProject](docs/MMSProject.md)
 - [MMSRef](docs/MMSRef.md)
 - [MMSRepositoryInfoResponse](docs/MMSRepositoryInfoResponse.md)
 - [MMSRepositoryStructure](docs/MMSRepositoryStructure.md)
 - [Match](docs/Match.md)
 - [MissingAnalysisQueryDefinition](docs/MissingAnalysisQueryDefinition.md)
 - [ModelCompartment](docs/ModelCompartment.md)
 - [ModelCompartmentDetails](docs/ModelCompartmentDetails.md)
 - [ModelCompartmentWithDependentElements](docs/ModelCompartmentWithDependentElements.md)
 - [ModelCompartmentWithDetails](docs/ModelCompartmentWithDetails.md)
 - [ModelCompartmentWithModelFormat](docs/ModelCompartmentWithModelFormat.md)
 - [ModelRepresentationFormat](docs/ModelRepresentationFormat.md)
 - [ModelonImpactRepositoryStructure](docs/ModelonImpactRepositoryStructure.md)
 - [ModelonImpactWorkspaceDescriptor](docs/ModelonImpactWorkspaceDescriptor.md)
 - [NotLoaded](docs/NotLoaded.md)
 - [ParsingDiagnostic](docs/ParsingDiagnostic.md)
 - [ParsingDiagnostics](docs/ParsingDiagnostics.md)
 - [PersistIndexData](docs/PersistIndexData.md)
 - [PersistedModelCompartmentDetailsResponse](docs/PersistedModelCompartmentDetailsResponse.md)
 - [PersistedRevisionDetailsResponse](docs/PersistedRevisionDetailsResponse.md)
 - [PersistentIndexInfoResponse](docs/PersistentIndexInfoResponse.md)
 - [QueryDefinitionRequest](docs/QueryDefinitionRequest.md)
 - [QueryExecutionResponse](docs/QueryExecutionResponse.md)
 - [QueryFQNList](docs/QueryFQNList.md)
 - [QueryFQNListWithModelCompartment](docs/QueryFQNListWithModelCompartment.md)
 - [QueryFQNListWithRevisionDescriptor](docs/QueryFQNListWithRevisionDescriptor.md)
 - [QueryLanguage](docs/QueryLanguage.md)
 - [QueryListResponse](docs/QueryListResponse.md)
 - [QueryParameter](docs/QueryParameter.md)
 - [QuerySpecificationAnnotation](docs/QuerySpecificationAnnotation.md)
 - [QuerySpecificationResponse](docs/QuerySpecificationResponse.md)
 - [ReferenceSlot](docs/ReferenceSlot.md)
 - [ReferenceStoreEntry](docs/ReferenceStoreEntry.md)
 - [RepositoryStructureResponse](docs/RepositoryStructureResponse.md)
 - [RepositoryUpdate](docs/RepositoryUpdate.md)
 - [RepositoryUpdateResponse](docs/RepositoryUpdateResponse.md)
 - [Resource](docs/Resource.md)
 - [ResourceWithDependentElements](docs/ResourceWithDependentElements.md)
 - [Revision](docs/Revision.md)
 - [RevisionDescriptor](docs/RevisionDescriptor.md)
 - [RevisionDescriptorWithURI](docs/RevisionDescriptorWithURI.md)
 - [RevisionDetails](docs/RevisionDetails.md)
 - [RevisionStatistics](docs/RevisionStatistics.md)
 - [RevisionWithModelFormat](docs/RevisionWithModelFormat.md)
 - [ServerInfoResponse](docs/ServerInfoResponse.md)
 - [ServerStatusMessage](docs/ServerStatusMessage.md)
 - [ServerStatusResponse](docs/ServerStatusResponse.md)
 - [ServerTask](docs/ServerTask.md)
 - [ServerTasksResponse](docs/ServerTasksResponse.md)
 - [SimpleMessage](docs/SimpleMessage.md)
 - [StandingQueryResultOnModelCompartmentRequest](docs/StandingQueryResultOnModelCompartmentRequest.md)
 - [StandingQueryResultRequest](docs/StandingQueryResultRequest.md)
 - [StartAcquisitionResponse](docs/StartAcquisitionResponse.md)
 - [TWCRepositoryInfoResponse](docs/TWCRepositoryInfoResponse.md)
 - [TWCRepositoryStructure](docs/TWCRepositoryStructure.md)
 - [TypedElementDescriptor](docs/TypedElementDescriptor.md)
 - [TypedElementInCompartmentDescriptor](docs/TypedElementInCompartmentDescriptor.md)
 - [UndefinedObject](docs/UndefinedObject.md)
 - [UploadChunkRequest](docs/UploadChunkRequest.md)
 - [ValidationDiagnostics](docs/ValidationDiagnostics.md)
 - [ValidationMatchingElement](docs/ValidationMatchingElement.md)
 - [ValidationResults](docs/ValidationResults.md)
 - [ValidationRule](docs/ValidationRule.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceWithDependentElements](docs/WorkspaceWithDependentElements.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author




