
<a href="https://github.com/macisamuele/language-formatters-pre-commit-hooks/actions" alt="Github Actions CI">
    <img src="https://github.com/macisamuele/language-formatters-pre-commit-hooks/workflows/Build/badge.svg"/>
</a>
<a href="https://codecov.io/gh/macisamuele/language-formatters-pre-commit-hooks" alt="Coverage">
    <img src="https://img.shields.io/codecov/c/github/macisamuele/language-formatters-pre-commit-hooks/master.svg"/>
</a>

<a href="https://pypi.python.org/pypi/language-formatters-pre-commit-hooks/" alt="PyPi version">
    <img src="https://img.shields.io/pypi/v/language-formatters-pre-commit-hooks.svg"/>
</a>

<a href="https://pypi.python.org/pypi/language-formatters-pre-commit-hooks/" alt="Supported Python versions">
    <img src="https://img.shields.io/pypi/pyversions/language-formatters-pre-commit-hooks.svg"/>
</a>

Language Formatters Pre Commit Hooks
====================================

About
-----

This package provides utilities for ensuring that your code is nicely formatted by using [`pre-commit`](https://pre-commit.com/) hooks

List of pretty-format hooks
---------------------------

* `pretty-format-golang`
* `pretty-format-ini`
* `pretty-format-java`
* `pretty-format-kotlin`
* `pretty-format-rust`
* `pretty-format-toml`
* `pretty-format-yaml`

⚠: the list above could be out-of-sync respect the exposed pre-commit hooks.<br/>
Please refer to [`.pre-commit-hooks.yaml`](.pre-commit-hooks.yaml) for a more updated list.

Example Usage
-------------

Add a similar snippet into your `.pre-commit-config.yaml` file

```yaml

- repo: https://github.com/macisamuele/language-formatters-pre-commit-hooks
  rev: ${LATEST_SHA_OR_VERSION}
  hooks:
  - id: pretty-format-java
    args: [--autofix]
  - id: pretty-format-kotlin
    args: [--autofix]
  - id: pretty-format-yaml
    args: [--autofix, --indent, '2']
```

Development
===========

This tool uses tox as main tool to build virtual environments.<br/>
To get started will be enough to run `make development`.

If you have [`aactivator`](https://github.com/Yelp/aactivator) installed this step will happen automatically.

Contributing
------------

Contributions are _always_ welcome.
1. Fork the project ( http://github.com/macisamuele/language-formatters-pre-commit-hooks/fork )
2. Create your feature branch (`git checkout -b my-new-feature`)
3. Add your modifications
4. Push to the branch (`git push origin my-new-feature`)
5. Create new Pull Request

License
-------

`language-formatters-pre-commit-hooks` is licensed with [`Apache License version 2.0`](http://www.apache.org/licenses/LICENSE-2.0.html).
