/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { Project, ProjectOptions } from "projen";
/**
 * Options for the smithy model project
 */
export interface SmithyModelOptions extends ProjectOptions {
    /**
     * The namespace of the service, eg com.mycompany
     */
    readonly serviceNamespace: string;
    /**
     * The name of the service, eg MyService
     */
    readonly serviceName: string;
}
/**
 * A project which contains a hello-world Smithy model
 */
export declare class SmithyModelProject extends Project {
    constructor(options: SmithyModelOptions);
}
