"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayPythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_python_project_1 = require("./open-api-gateway-python-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-py
 */
class SmithyApiGatewayPythonProject extends open_api_gateway_python_project_1.OpenApiGatewayPythonProject {
    constructor(options) {
        super(options);
        /**
         * The directory in which the smithy model files reside
         */
        this.modelDir = "model";
    }
    preConstruct(options) {
        const { modelDir, generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, options);
        // @ts-ignore this method is called by the constructor
        this.modelDir = modelDir;
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayPythonProject = SmithyApiGatewayPythonProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayPythonProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject", version: "0.11.5" };
//# sourceMappingURL=data:application/json;base64,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