/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pdfextract.Common;

public class SentenceJoin {
    private Common common = new Common();
    private String _sScriptPath = "";
    private InputStream _inStream = null;
    private OutputStream _outStream = null;
    private InputStream _errorStream = null;
    private PrintWriter _pWriter = null;
    private InputStreamReader _reader = null;
    private InputStreamReader _readerError = null;
    private BufferedReader _buffError = null;
    private Scanner _scan = null;
    private Process _proc = null;
    private WorkerStatus _workerStatus;
    private String _language = "";
    private String _modelPath = "";
    private ExecutorService _executor;
    private Object _objectWorker = new Object();

    public SentenceJoin(String lang, String scriptPath, String modelPath) {
        this._language = lang;
        this._sScriptPath = scriptPath;
        this._modelPath = modelPath;
        this._executor = Executors.newSingleThreadExecutor();
    }

    public WorkerStatus status() {
        return this._workerStatus;
    }

    public void start() throws Exception {
        if (this._workerStatus == WorkerStatus.RUNNING || this._workerStatus == WorkerStatus.LOADING) {
            return;
        }
        if (!this.common.IsExist(this._sScriptPath)) {
            return;
        }
        if (this.common.IsEmpty(this._modelPath)) {
            return;
        }
        this._workerStatus = WorkerStatus.LOADING;
        String[] commands = new String[]{this._sScriptPath, "--apply", "--model", this._modelPath};
        ProcessBuilder proc = new ProcessBuilder(commands);
        this._proc = proc.start();
        this._inStream = this._proc.getInputStream();
        this._outStream = this._proc.getOutputStream();
        this._errorStream = this._proc.getErrorStream();
        this._reader = new InputStreamReader(this._inStream, "UTF-8");
        this._readerError = new InputStreamReader(this._errorStream, "UTF-8");
        this._buffError = new BufferedReader(this._readerError);
        this._scan = new Scanner(this._reader);
        this._pWriter = new PrintWriter(this._outStream);
        try {
            this._pWriter.println("test\ttest");
            this._pWriter.flush();
            this._scan.nextLine();
            this._workerStatus = WorkerStatus.RUNNING;
        }
        catch (Exception e) {
            this._workerStatus = WorkerStatus.ERROR;
            throw new Exception("Start sentence join [" + this._language + "] failed");
        }
        this._executor.shutdown();
    }

    public void stop() throws Exception {
        try {
            try {
                if (this._outStream != null) {
                    this._outStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._inStream != null) {
                this._inStream.close();
            }
            if (this._pWriter != null) {
                this._pWriter.close();
            }
            if (this._buffError != null) {
                this._buffError.close();
            }
            if (this._reader != null) {
                this._reader.close();
            }
            if (this._readerError != null) {
                this._readerError.close();
            }
            if (this._errorStream != null) {
                this._errorStream.close();
            }
            if (this._scan != null) {
                this._scan.close();
            }
            if (this._proc != null) {
                this._proc.destroy();
            }
            this._proc = null;
        }
        catch (Exception e) {
            this.common.print("stop sentence join [" + this._language + "] failed. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String text1, String text2) throws Exception {
        Object object = this._objectWorker;
        synchronized (object) {
            try {
                this._pWriter.println(text1 + "\t" + text2);
                this._pWriter.flush();
                String sOutput = this._scan.nextLine();
                return this.common.getBool(sOutput);
            }
            catch (Exception e) {
                this.common.print("execute sentence join [" + this._language + "] failed. " + text1 + "\t" + text2 + " ," + e.getMessage());
            }
        }
        return false;
    }

    public static enum WorkerStatus {
        STOPPED,
        LOADING,
        RUNNING,
        ERROR;

    }
}

