"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSchema = void 0;
const schemasafe_1 = require("@exodus/schemasafe");
/**
 * Helper function used to validate the schema of the custom configuration provided when
 * creating an EMR on EKS Managed Endpoint
 * @param overrideConfigSchema The validation schema
 * @param overrideConfigData The JSON configuration to validate
 */
function validateSchema(overrideConfigSchema, overrideConfigData) {
    if (overrideConfigData !== undefined) {
        const schemaObject = JSON.parse(overrideConfigSchema);
        const data = JSON.parse(JSON.stringify(overrideConfigData));
        const validate = schemasafe_1.validator(schemaObject);
        if (validate(data)) {
            return true;
        }
        else {
            throw new Error(`The configuration override is not valid JSON : ${overrideConfigData}`);
        }
    }
    else {
        return false;
    }
}
exports.validateSchema = validateSchema;
//# sourceMappingURL=data:application/json;base64,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