"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    GistsPostBodyType,
    GistsPostBodyPropFilesType,
    GistsGistIdPatchBodyAnyof0Type,
    GistsGistIdPatchBodyAnyof1Type,
    GistsGistIdCommentsPostBodyType,
    GistsGistIdPatchBodyPropFilesType,
    GistsGistIdCommentsCommentIdPatchBodyType,
)
from .models import (
    BaseGist,
    BasicError,
    GistCommit,
    GistSimple,
    GistComment,
    GistsPostBody,
    ValidationError,
    GistsGistIdGetResponse403,
    GistsGistIdPatchBodyAnyof0,
    GistsGistIdPatchBodyAnyof1,
    GistsGistIdCommentsPostBody,
    GistsGistIdStarGetResponse404,
    GistsGistIdCommentsCommentIdPatchBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class GistsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = "/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = "/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(self, *, data: GistsPostBodyType) -> "Response[GistSimple]":
        ...

    @overload
    def create(
        self,
        *,
        data: Unset = UNSET,
        description: Union[Unset, str] = UNSET,
        files: GistsPostBodyPropFilesType,
        public: Union[Unset, Union[bool, Literal["true", "false"]]] = UNSET,
    ) -> "Response[GistSimple]":
        ...

    def create(
        self, *, data: Union[Unset, GistsPostBodyType] = UNSET, **kwargs
    ) -> "Response[GistSimple]":
        url = "/gists"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(GistsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(self, *, data: GistsPostBodyType) -> "Response[GistSimple]":
        ...

    @overload
    async def async_create(
        self,
        *,
        data: Unset = UNSET,
        description: Union[Unset, str] = UNSET,
        files: GistsPostBodyPropFilesType,
        public: Union[Unset, Union[bool, Literal["true", "false"]]] = UNSET,
    ) -> "Response[GistSimple]":
        ...

    async def async_create(
        self, *, data: Union[Unset, GistsPostBodyType] = UNSET, **kwargs
    ) -> "Response[GistSimple]":
        url = "/gists"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(GistsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_public(
        self,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = "/gists/public"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_list_public(
        self,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = "/gists/public"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_starred(
        self,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = "/gists/starred"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_starred(
        self,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = "/gists/starred"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "401": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        gist_id: str,
    ) -> "Response[GistSimple]":
        url = f"/gists/{gist_id}"

        return self._github.request(
            "GET",
            url,
            response_model=GistSimple,
            error_models={
                "403": GistsGistIdGetResponse403,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        gist_id: str,
    ) -> "Response[GistSimple]":
        url = f"/gists/{gist_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=GistSimple,
            error_models={
                "403": GistsGistIdGetResponse403,
                "404": BasicError,
            },
        )

    def delete(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        gist_id: str,
        *,
        data: Union[
            GistsGistIdPatchBodyAnyof0Type, None, GistsGistIdPatchBodyAnyof1Type, None
        ],
    ) -> "Response[GistSimple]":
        ...

    @overload
    def update(
        self,
        gist_id: str,
        *,
        data: Unset = UNSET,
        description: str,
        files: Union[Unset, GistsGistIdPatchBodyPropFilesType] = UNSET,
    ) -> "Response[GistSimple]":
        ...

    @overload
    def update(
        self,
        gist_id: str,
        *,
        data: Unset = UNSET,
        description: Union[Unset, str] = UNSET,
        files: GistsGistIdPatchBodyPropFilesType,
    ) -> "Response[GistSimple]":
        ...

    def update(
        self,
        gist_id: str,
        *,
        data: Union[
            Unset,
            Union[
                GistsGistIdPatchBodyAnyof0Type,
                None,
                GistsGistIdPatchBodyAnyof1Type,
                None,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[GistSimple]":
        url = f"/gists/{gist_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[GistsGistIdPatchBodyAnyof0, None, GistsGistIdPatchBodyAnyof1, None],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        data: Union[
            GistsGistIdPatchBodyAnyof0Type, None, GistsGistIdPatchBodyAnyof1Type, None
        ],
    ) -> "Response[GistSimple]":
        ...

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        data: Unset = UNSET,
        description: str,
        files: Union[Unset, GistsGistIdPatchBodyPropFilesType] = UNSET,
    ) -> "Response[GistSimple]":
        ...

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        data: Unset = UNSET,
        description: Union[Unset, str] = UNSET,
        files: GistsGistIdPatchBodyPropFilesType,
    ) -> "Response[GistSimple]":
        ...

    async def async_update(
        self,
        gist_id: str,
        *,
        data: Union[
            Unset,
            Union[
                GistsGistIdPatchBodyAnyof0Type,
                None,
                GistsGistIdPatchBodyAnyof1Type,
                None,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[GistSimple]":
        url = f"/gists/{gist_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[GistsGistIdPatchBodyAnyof0, None, GistsGistIdPatchBodyAnyof1, None],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_comments(
        self,
        gist_id: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GistComment]]":
        url = f"/gists/{gist_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GistComment],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_comments(
        self,
        gist_id: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GistComment]]":
        url = f"/gists/{gist_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GistComment],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_comment(
        self, gist_id: str, *, data: GistsGistIdCommentsPostBodyType
    ) -> "Response[GistComment]":
        ...

    @overload
    def create_comment(
        self,
        gist_id: str,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[GistComment]":
        ...

    def create_comment(
        self,
        gist_id: str,
        *,
        data: Union[Unset, GistsGistIdCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[GistComment]":
        url = f"/gists/{gist_id}/comments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(GistsGistIdCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_comment(
        self, gist_id: str, *, data: GistsGistIdCommentsPostBodyType
    ) -> "Response[GistComment]":
        ...

    @overload
    async def async_create_comment(
        self,
        gist_id: str,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[GistComment]":
        ...

    async def async_create_comment(
        self,
        gist_id: str,
        *,
        data: Union[Unset, GistsGistIdCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[GistComment]":
        url = f"/gists/{gist_id}/comments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(GistsGistIdCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_comment(
        self,
        gist_id: str,
        comment_id: int,
    ) -> "Response[GistComment]":
        url = f"/gists/{gist_id}/comments/{comment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": GistsGistIdGetResponse403,
            },
        )

    async def async_get_comment(
        self,
        gist_id: str,
        comment_id: int,
    ) -> "Response[GistComment]":
        url = f"/gists/{gist_id}/comments/{comment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": GistsGistIdGetResponse403,
            },
        )

    def delete_comment(
        self,
        gist_id: str,
        comment_id: int,
    ) -> "Response":
        url = f"/gists/{gist_id}/comments/{comment_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete_comment(
        self,
        gist_id: str,
        comment_id: int,
    ) -> "Response":
        url = f"/gists/{gist_id}/comments/{comment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: GistsGistIdCommentsCommentIdPatchBodyType,
    ) -> "Response[GistComment]":
        ...

    @overload
    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[GistComment]":
        ...

    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: Union[Unset, GistsGistIdCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[GistComment]":
        url = f"/gists/{gist_id}/comments/{comment_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(GistsGistIdCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GistComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: GistsGistIdCommentsCommentIdPatchBodyType,
    ) -> "Response[GistComment]":
        ...

    @overload
    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[GistComment]":
        ...

    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: Union[Unset, GistsGistIdCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[GistComment]":
        url = f"/gists/{gist_id}/comments/{comment_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(GistsGistIdCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GistComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        gist_id: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GistCommit]]":
        url = f"/gists/{gist_id}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GistCommit],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_commits(
        self,
        gist_id: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GistCommit]]":
        url = f"/gists/{gist_id}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GistCommit],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_forks(
        self,
        gist_id: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GistSimple]]":
        url = f"/gists/{gist_id}/forks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GistSimple],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_forks(
        self,
        gist_id: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GistSimple]]":
        url = f"/gists/{gist_id}/forks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GistSimple],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def fork(
        self,
        gist_id: str,
    ) -> "Response[BaseGist]":
        url = f"/gists/{gist_id}/forks"

        return self._github.request(
            "POST",
            url,
            response_model=BaseGist,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_fork(
        self,
        gist_id: str,
    ) -> "Response[BaseGist]":
        url = f"/gists/{gist_id}/forks"

        return await self._github.arequest(
            "POST",
            url,
            response_model=BaseGist,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def check_is_starred(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}/star"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": GistsGistIdStarGetResponse404,
                "403": BasicError,
            },
        )

    async def async_check_is_starred(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}/star"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": GistsGistIdStarGetResponse404,
                "403": BasicError,
            },
        )

    def star(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}/star"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_star(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}/star"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def unstar(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}/star"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_unstar(
        self,
        gist_id: str,
    ) -> "Response":
        url = f"/gists/{gist_id}/star"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_revision(
        self,
        gist_id: str,
        sha: str,
    ) -> "Response[GistSimple]":
        url = f"/gists/{gist_id}/{sha}"

        return self._github.request(
            "GET",
            url,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_revision(
        self,
        gist_id: str,
        sha: str,
    ) -> "Response[GistSimple]":
        url = f"/gists/{gist_id}/{sha}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = f"/users/{username}/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[BaseGist]]":
        url = f"/users/{username}/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
            },
        )
