function _aws_cdk_aws_lambda_go_GoFunctionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.bundling))
            _aws_cdk_aws_lambda_go_BundlingOptions(p.bundling);
        if ("architectures" in p)
            print("@aws-cdk/aws-lambda.FunctionOptions#architectures", "use `architecture`");
        if (!visitedObjects.has(p.architectures))
            require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_Architecture(p.architectures);
        if (!visitedObjects.has(p.events))
            require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_IEventSource(p.events);
        if (!visitedObjects.has(p.initialPolicy))
            require("@aws-cdk/aws-iam/.warnings.jsii.js")._aws_cdk_aws_iam_PolicyStatement(p.initialPolicy);
        if (!visitedObjects.has(p.layers))
            require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_ILayerVersion(p.layers);
        if ("securityGroup" in p)
            print("@aws-cdk/aws-lambda.FunctionOptions#securityGroup", "- This property is deprecated, use securityGroups instead");
        if (!visitedObjects.has(p.securityGroups))
            require("@aws-cdk/aws-ec2/.warnings.jsii.js")._aws_cdk_aws_ec2_ISecurityGroup(p.securityGroups);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_go_GoFunction(p) {
}
function _aws_cdk_aws_lambda_go_BundlingOptions(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.commandHooks))
            _aws_cdk_aws_lambda_go_ICommandHooks(p.commandHooks);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_lambda_go_ICommandHooks(p) {
}
function print(name, deprecationMessage) {
    const deprecated = process.env.JSII_DEPRECATED;
    const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
    const message = `${name} is deprecated.\n  ${deprecationMessage.trim()}\n  This API will be removed in the next major release.`;
    switch (deprecationMode) {
        case "fail":
            throw new DeprecationError(message);
        case "warn":
            console.warn("[WARNING]", message);
            break;
    }
}
function getPropertyDescriptor(obj, prop) {
    const descriptor = Object.getOwnPropertyDescriptor(obj, prop);
    if (descriptor) {
        return descriptor;
    }
    const proto = Object.getPrototypeOf(obj);
    const prototypeDescriptor = proto && getPropertyDescriptor(proto, prop);
    if (prototypeDescriptor) {
        return prototypeDescriptor;
    }
    return {};
}
const visitedObjects = new Set();
class DeprecationError extends Error {
    constructor(...args) {
        super(...args);
        Object.defineProperty(this, "name", {
            configurable: false,
            enumerable: true,
            value: "DeprecationError",
            writable: false,
        });
    }
}
module.exports = { print, getPropertyDescriptor, DeprecationError, _aws_cdk_aws_lambda_go_GoFunctionProps, _aws_cdk_aws_lambda_go_GoFunction, _aws_cdk_aws_lambda_go_BundlingOptions, _aws_cdk_aws_lambda_go_ICommandHooks };
