# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2018-04-16 22:44
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Form460Filing",
            fields=[
                (
                    "date_filed",
                    models.DateField(
                        db_index=True,
                        help_text="Date this report was filed, according to the filer (from CVR_CAMPAIGN_DISCLOSURE.RPT_DATE)",
                        verbose_name="date filed",
                    ),
                ),
                (
                    "filer_id",
                    models.IntegerField(
                        db_index=True,
                        help_text="Numeric filer identification number (from FILER_XREF.FILER_ID)",
                        verbose_name="filer id",
                    ),
                ),
                (
                    "filer_lastname",
                    models.CharField(
                        help_text="Last name of filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAML)",
                        max_length=200,
                        verbose_name="filer last name",
                    ),
                ),
                (
                    "filer_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAMF)",
                        max_length=45,
                        verbose_name="filer first name",
                    ),
                ),
                (
                    "election_date",
                    models.DateField(
                        db_index=True,
                        help_text="Date of the election in which the filer is participating (from CVR_CAMPAIGN_DISCLOSURE.ELECT_DATE)",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
                (
                    "statement_type",
                    models.CharField(
                        help_text='Type of statement, e.g., "Quarterly", "Semi-Annual", Pre-Election (from CVR_CAMPAIGN_DISCLOSURE.STMT_TYPE)',
                        max_length=50,
                        verbose_name="statement type",
                    ),
                ),
                (
                    "from_date",
                    models.DateField(
                        db_index=True,
                        help_text="The first date of the filing period covered by the statement (from CVR_CAMPAIGN_DISCLOSURE.FROM_DATE)",
                        verbose_name="from date",
                    ),
                ),
                (
                    "thru_date",
                    models.DateField(
                        db_index=True,
                        help_text="The last date of the filing period covered by the statement (from CVR_CAMPAIGN_DISCLOSURE.THRU_DATE)",
                        verbose_name="thru date",
                    ),
                ),
                (
                    "monetary_contributions",
                    models.IntegerField(
                        help_text="Total monetary contributions (from line 1, column A)",
                        null=True,
                        verbose_name="monetary contributions",
                    ),
                ),
                (
                    "loans_received",
                    models.IntegerField(
                        help_text="Total loans received (from line 2, column A)",
                        null=True,
                        verbose_name="loans received",
                    ),
                ),
                (
                    "subtotal_cash_contributions",
                    models.IntegerField(
                        help_text="Monetary contributions and loans received combined (from line 3, column A)",
                        null=True,
                        verbose_name="subtotal cash contributions",
                    ),
                ),
                (
                    "nonmonetary_contributions",
                    models.IntegerField(
                        help_text="Non-monetary contributions (from line 4, column A)",
                        null=True,
                        verbose_name="nonmonetary contributions",
                    ),
                ),
                (
                    "total_contributions",
                    models.IntegerField(
                        help_text="Total contributions (from line 5, column A)",
                        null=True,
                        verbose_name="total contributions",
                    ),
                ),
                (
                    "payments_made",
                    models.IntegerField(
                        help_text="Payments made (from line 6, column A)",
                        null=True,
                        verbose_name="payments made",
                    ),
                ),
                (
                    "loans_made",
                    models.IntegerField(
                        help_text="Loans made (from line 7, column A)",
                        null=True,
                        verbose_name="loans made",
                    ),
                ),
                (
                    "subtotal_cash_payments",
                    models.IntegerField(
                        help_text="Sub-total of cash payments (from line 8, column A)",
                        null=True,
                        verbose_name="subtotal cash payments",
                    ),
                ),
                (
                    "unpaid_bills",
                    models.IntegerField(
                        help_text="Unpaid bills / accrued expenses (from line 9, column A)",
                        null=True,
                        verbose_name="unpaid bills",
                    ),
                ),
                (
                    "nonmonetary_adjustment",
                    models.IntegerField(
                        help_text="Non-monetary adjustment (from line 10, column A), which is equal to the total of non-monetary contributions",
                        null=True,
                        verbose_name="nonmonetary adjustment",
                    ),
                ),
                (
                    "total_expenditures_made",
                    models.IntegerField(
                        help_text="Total expenditures made (from line 11, column A)",
                        null=True,
                        verbose_name="total expenditures made",
                    ),
                ),
                (
                    "begin_cash_balance",
                    models.IntegerField(
                        help_text="Beginning cash balance (from line 12), which is equal to the Ending Cash Balance (line 16) reported on the summary page of the previous Form 460 filing",
                        null=True,
                        verbose_name="begin cash balance",
                    ),
                ),
                (
                    "cash_receipts",
                    models.IntegerField(
                        help_text="Cash receipts (from line 13)",
                        null=True,
                        verbose_name="cash receipts",
                    ),
                ),
                (
                    "miscellaneous_cash_increases",
                    models.IntegerField(
                        help_text="Miscellaneous cash increases (from line 14)",
                        null=True,
                        verbose_name="miscellaneous cash increases",
                    ),
                ),
                (
                    "cash_payments",
                    models.IntegerField(
                        help_text="Cash payments (from line 15)",
                        null=True,
                        verbose_name="cash payments",
                    ),
                ),
                (
                    "ending_cash_balance",
                    models.IntegerField(
                        help_text="Ending cash balance (from line 16)",
                        null=True,
                        verbose_name="ending cash balance",
                    ),
                ),
                (
                    "loan_guarantees_received",
                    models.IntegerField(
                        help_text="Loan guarantees received (from line 17)",
                        null=True,
                        verbose_name="loan guarantees received",
                    ),
                ),
                (
                    "cash_equivalents",
                    models.IntegerField(
                        help_text="Cash equivalents (from line 18), which includes investments that can't be readily converted to cash, such as outstanding loans the committee has made to others",
                        null=True,
                        verbose_name="cash equivalents",
                    ),
                ),
                (
                    "outstanding_debts",
                    models.IntegerField(
                        help_text="Outstanding debts on loans owed by the committee (from line 19)",
                        null=True,
                        verbose_name="outstanding debts",
                    ),
                ),
                (
                    "filing_id",
                    models.IntegerField(
                        help_text="Unique identification number for the Form 460 filing (from CVR_CAMPAIGN_DISCLOSURE_CD.FILING_ID)",
                        primary_key=True,
                        serialize=False,
                        verbose_name="filing id",
                    ),
                ),
                (
                    "amendment_count",
                    models.IntegerField(
                        db_index=True,
                        help_text="Number of amendments to the Form 460 filing (from maximum value of CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)",
                        verbose_name="Count amendments",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) filing",
            },
        ),
        migrations.CreateModel(
            name="Form460FilingVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_filed",
                    models.DateField(
                        db_index=True,
                        help_text="Date this report was filed, according to the filer (from CVR_CAMPAIGN_DISCLOSURE.RPT_DATE)",
                        verbose_name="date filed",
                    ),
                ),
                (
                    "filer_id",
                    models.IntegerField(
                        db_index=True,
                        help_text="Numeric filer identification number (from FILER_XREF.FILER_ID)",
                        verbose_name="filer id",
                    ),
                ),
                (
                    "filer_lastname",
                    models.CharField(
                        help_text="Last name of filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAML)",
                        max_length=200,
                        verbose_name="filer last name",
                    ),
                ),
                (
                    "filer_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAMF)",
                        max_length=45,
                        verbose_name="filer first name",
                    ),
                ),
                (
                    "election_date",
                    models.DateField(
                        db_index=True,
                        help_text="Date of the election in which the filer is participating (from CVR_CAMPAIGN_DISCLOSURE.ELECT_DATE)",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
                (
                    "statement_type",
                    models.CharField(
                        help_text='Type of statement, e.g., "Quarterly", "Semi-Annual", Pre-Election (from CVR_CAMPAIGN_DISCLOSURE.STMT_TYPE)',
                        max_length=50,
                        verbose_name="statement type",
                    ),
                ),
                (
                    "from_date",
                    models.DateField(
                        db_index=True,
                        help_text="The first date of the filing period covered by the statement (from CVR_CAMPAIGN_DISCLOSURE.FROM_DATE)",
                        verbose_name="from date",
                    ),
                ),
                (
                    "thru_date",
                    models.DateField(
                        db_index=True,
                        help_text="The last date of the filing period covered by the statement (from CVR_CAMPAIGN_DISCLOSURE.THRU_DATE)",
                        verbose_name="thru date",
                    ),
                ),
                (
                    "monetary_contributions",
                    models.IntegerField(
                        help_text="Total monetary contributions (from line 1, column A)",
                        null=True,
                        verbose_name="monetary contributions",
                    ),
                ),
                (
                    "loans_received",
                    models.IntegerField(
                        help_text="Total loans received (from line 2, column A)",
                        null=True,
                        verbose_name="loans received",
                    ),
                ),
                (
                    "subtotal_cash_contributions",
                    models.IntegerField(
                        help_text="Monetary contributions and loans received combined (from line 3, column A)",
                        null=True,
                        verbose_name="subtotal cash contributions",
                    ),
                ),
                (
                    "nonmonetary_contributions",
                    models.IntegerField(
                        help_text="Non-monetary contributions (from line 4, column A)",
                        null=True,
                        verbose_name="nonmonetary contributions",
                    ),
                ),
                (
                    "total_contributions",
                    models.IntegerField(
                        help_text="Total contributions (from line 5, column A)",
                        null=True,
                        verbose_name="total contributions",
                    ),
                ),
                (
                    "payments_made",
                    models.IntegerField(
                        help_text="Payments made (from line 6, column A)",
                        null=True,
                        verbose_name="payments made",
                    ),
                ),
                (
                    "loans_made",
                    models.IntegerField(
                        help_text="Loans made (from line 7, column A)",
                        null=True,
                        verbose_name="loans made",
                    ),
                ),
                (
                    "subtotal_cash_payments",
                    models.IntegerField(
                        help_text="Sub-total of cash payments (from line 8, column A)",
                        null=True,
                        verbose_name="subtotal cash payments",
                    ),
                ),
                (
                    "unpaid_bills",
                    models.IntegerField(
                        help_text="Unpaid bills / accrued expenses (from line 9, column A)",
                        null=True,
                        verbose_name="unpaid bills",
                    ),
                ),
                (
                    "nonmonetary_adjustment",
                    models.IntegerField(
                        help_text="Non-monetary adjustment (from line 10, column A), which is equal to the total of non-monetary contributions",
                        null=True,
                        verbose_name="nonmonetary adjustment",
                    ),
                ),
                (
                    "total_expenditures_made",
                    models.IntegerField(
                        help_text="Total expenditures made (from line 11, column A)",
                        null=True,
                        verbose_name="total expenditures made",
                    ),
                ),
                (
                    "begin_cash_balance",
                    models.IntegerField(
                        help_text="Beginning cash balance (from line 12), which is equal to the Ending Cash Balance (line 16) reported on the summary page of the previous Form 460 filing",
                        null=True,
                        verbose_name="begin cash balance",
                    ),
                ),
                (
                    "cash_receipts",
                    models.IntegerField(
                        help_text="Cash receipts (from line 13)",
                        null=True,
                        verbose_name="cash receipts",
                    ),
                ),
                (
                    "miscellaneous_cash_increases",
                    models.IntegerField(
                        help_text="Miscellaneous cash increases (from line 14)",
                        null=True,
                        verbose_name="miscellaneous cash increases",
                    ),
                ),
                (
                    "cash_payments",
                    models.IntegerField(
                        help_text="Cash payments (from line 15)",
                        null=True,
                        verbose_name="cash payments",
                    ),
                ),
                (
                    "ending_cash_balance",
                    models.IntegerField(
                        help_text="Ending cash balance (from line 16)",
                        null=True,
                        verbose_name="ending cash balance",
                    ),
                ),
                (
                    "loan_guarantees_received",
                    models.IntegerField(
                        help_text="Loan guarantees received (from line 17)",
                        null=True,
                        verbose_name="loan guarantees received",
                    ),
                ),
                (
                    "cash_equivalents",
                    models.IntegerField(
                        help_text="Cash equivalents (from line 18), which includes investments that can't be readily converted to cash, such as outstanding loans the committee has made to others",
                        null=True,
                        verbose_name="cash equivalents",
                    ),
                ),
                (
                    "outstanding_debts",
                    models.IntegerField(
                        help_text="Outstanding debts on loans owed by the committee (from line 19)",
                        null=True,
                        verbose_name="outstanding debts",
                    ),
                ),
                (
                    "amend_id",
                    models.IntegerField(
                        help_text="Identifies the version of the Form 497 filing, with 0 representing the initial filing (from CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)",
                        verbose_name="amendment id",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        db_constraint=False,
                        help_text="Unique identification number for the Form 460 filing (from CVR_CAMPAIGN_DISCLOSURE_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="versions",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) filing version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleAItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        help_text="Date the contribution was received (from RCPT_CD.RCPT_DATE)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("", "Unknown"),
                            ("INC16168", "INC16168"),
                        ],
                        help_text="Type of transaction (from RCPT_CD.TRAN_TYPE)",
                        max_length=255,
                        verbose_name="transaction type",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from RCPT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="contributor committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from RCPT_CD.CTRIB_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from RCPT_CD.CTRIB_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from RCPT_CD.CTRIB_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from RCPT_CD.CTRIB_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from RCPT_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from RCPT_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "intermediary_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)",
                        max_length=9,
                        verbose_name="intermediary committee id",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from RCPT_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from RCPT_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from RCPT_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from RCPT_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "intermediary_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the intermediary (from RCPT_CD.INTR_EMP)",
                        max_length=200,
                        verbose_name="intermediary employer",
                    ),
                ),
                (
                    "intermediary_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the intermediary (from RCPT_CD.INTR_OCC)",
                        max_length=60,
                        verbose_name="intermediary occupation",
                    ),
                ),
                (
                    "intermediary_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="(from S497_CD.INTR_SELF)",
                        verbose_name="intermediary is self employed",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount received from the contributor in the period covered by the filing (from RCPT_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the monetary contribution was reported (from RCPT_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_a_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule A item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleAItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        help_text="Date the contribution was received (from RCPT_CD.RCPT_DATE)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("", "Unknown"),
                            ("INC16168", "INC16168"),
                        ],
                        help_text="Type of transaction (from RCPT_CD.TRAN_TYPE)",
                        max_length=255,
                        verbose_name="transaction type",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from RCPT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="contributor committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from RCPT_CD.CTRIB_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from RCPT_CD.CTRIB_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from RCPT_CD.CTRIB_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from RCPT_CD.CTRIB_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from RCPT_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from RCPT_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "intermediary_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)",
                        max_length=9,
                        verbose_name="intermediary committee id",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from RCPT_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from RCPT_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from RCPT_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from RCPT_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "intermediary_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the intermediary (from RCPT_CD.INTR_EMP)",
                        max_length=200,
                        verbose_name="intermediary employer",
                    ),
                ),
                (
                    "intermediary_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the intermediary (from RCPT_CD.INTR_OCC)",
                        max_length=60,
                        verbose_name="intermediary occupation",
                    ),
                ),
                (
                    "intermediary_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="(from S497_CD.INTR_SELF)",
                        verbose_name="intermediary is self employed",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount received from the contributor in the period covered by the filing (from RCPT_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the received contribution",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_a_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule A item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleASummary",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "itemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - contributions of $100 or more. (Include all Schedule A subtotals.)",
                        null=True,
                        verbose_name="itemized contributions",
                    ),
                ),
                (
                    "unitemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - unitemized contributions of less than $100",
                        null=True,
                        verbose_name="unitemized contributions",
                    ),
                ),
                (
                    "total_contributions",
                    models.FloatField(
                        help_text="Total monetary contributions received this period. (Add Lines 1 and 2. Enter here and on summary Page, Column A, Line 1.)",
                        null=True,
                        verbose_name="total contributions",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the summary was reported",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_a_summaries",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule A summary",
                "verbose_name_plural": "Form 460 (Campaign Disclosure) Schedule A summaries",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleASummaryVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "itemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - contributions of $100 or more. (Include all Schedule A subtotals.)",
                        null=True,
                        verbose_name="itemized contributions",
                    ),
                ),
                (
                    "unitemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - unitemized contributions of less than $100",
                        null=True,
                        verbose_name="unitemized contributions",
                    ),
                ),
                (
                    "total_contributions",
                    models.FloatField(
                        help_text="Total monetary contributions received this period. (Add Lines 1 and 2. Enter here and on summary Page, Column A, Line 1.)",
                        null=True,
                        verbose_name="total contributions",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the summary",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_a_summaries",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule A summary version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleB1Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "lender_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the lender (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="lender code",
                    ),
                ),
                (
                    "lender_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="lender's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="lender committee id",
                    ),
                ),
                (
                    "lender_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="lender title",
                    ),
                ),
                (
                    "lender_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="lender lastname",
                    ),
                ),
                (
                    "lender_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the lender (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="lender firstname",
                    ),
                ),
                (
                    "lender_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="lender name suffix",
                    ),
                ),
                (
                    "lender_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="lender city",
                    ),
                ),
                (
                    "lender_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="lender state",
                    ),
                ),
                (
                    "lender_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="lender zip",
                    ),
                ),
                (
                    "lender_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the lender (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="lender employer",
                    ),
                ),
                (
                    "lender_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the lender (from LOAN_CD.LOAN_OCC)",
                        max_length=60,
                        verbose_name="lender occupation",
                    ),
                ),
                (
                    "lender_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the lender is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="lender is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the lender committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "begin_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the beginning of theperiod covered by the filing (from LOAN_CD.LOAN_AMT4)",
                        max_digits=14,
                        verbose_name="beginning period balance",
                    ),
                ),
                (
                    "amount_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount received during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount received",
                    ),
                ),
                (
                    "amount_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back during the period covered by the filing (from LOAN_CD.LOAN_AMT5)",
                        max_digits=14,
                        verbose_name="amount paid",
                    ),
                ),
                (
                    "amount_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount forgiven by the lender during the period covered by the filing (from LOAN_CD.LOAN_AMT6)",
                        max_digits=14,
                        verbose_name="amount forgiven",
                    ),
                ),
                (
                    "end_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="end period balance",
                    ),
                ),
                (
                    "date_due",
                    models.DateField(
                        help_text="Date that the loan is due (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date due",
                    ),
                ),
                (
                    "interest_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of interest paid on the loan during the period covered by the campaign filing (from LOAN_CD.LOAN_AMT7)",
                        max_digits=14,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "original_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Original amount loaned by the lender to the campaign filer (from LOAN_CD.LOAN_AMT8)",
                        max_digits=14,
                        verbose_name="original amount",
                    ),
                ),
                (
                    "date_incurred",
                    models.DateField(
                        help_text="Date the loan was made or received (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date incurred",
                    ),
                ),
                (
                    "cumulative_ytd_contributions",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative amount of contributions (loans, monetary and nonmonetary contributions) received from the lender during the calendar year covered by this statement (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="cumulative year-to-date contributions",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the loan was reported (from LOAN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_b1_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule B item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleB1ItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "lender_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the lender (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="lender code",
                    ),
                ),
                (
                    "lender_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="lender's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="lender committee id",
                    ),
                ),
                (
                    "lender_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="lender title",
                    ),
                ),
                (
                    "lender_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="lender lastname",
                    ),
                ),
                (
                    "lender_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the lender (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="lender firstname",
                    ),
                ),
                (
                    "lender_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="lender name suffix",
                    ),
                ),
                (
                    "lender_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="lender city",
                    ),
                ),
                (
                    "lender_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="lender state",
                    ),
                ),
                (
                    "lender_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="lender zip",
                    ),
                ),
                (
                    "lender_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the lender (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="lender employer",
                    ),
                ),
                (
                    "lender_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the lender (from LOAN_CD.LOAN_OCC)",
                        max_length=60,
                        verbose_name="lender occupation",
                    ),
                ),
                (
                    "lender_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the lender is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="lender is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the lender committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "begin_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the beginning of theperiod covered by the filing (from LOAN_CD.LOAN_AMT4)",
                        max_digits=14,
                        verbose_name="beginning period balance",
                    ),
                ),
                (
                    "amount_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount received during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount received",
                    ),
                ),
                (
                    "amount_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back during the period covered by the filing (from LOAN_CD.LOAN_AMT5)",
                        max_digits=14,
                        verbose_name="amount paid",
                    ),
                ),
                (
                    "amount_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount forgiven by the lender during the period covered by the filing (from LOAN_CD.LOAN_AMT6)",
                        max_digits=14,
                        verbose_name="amount forgiven",
                    ),
                ),
                (
                    "end_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="end period balance",
                    ),
                ),
                (
                    "date_due",
                    models.DateField(
                        help_text="Date that the loan is due (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date due",
                    ),
                ),
                (
                    "interest_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of interest paid on the loan during the period covered by the campaign filing (from LOAN_CD.LOAN_AMT7)",
                        max_digits=14,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "original_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Original amount loaned by the lender to the campaign filer (from LOAN_CD.LOAN_AMT8)",
                        max_digits=14,
                        verbose_name="original amount",
                    ),
                ),
                (
                    "date_incurred",
                    models.DateField(
                        help_text="Date the loan was made or received (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date incurred",
                    ),
                ),
                (
                    "cumulative_ytd_contributions",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative amount of contributions (loans, monetary and nonmonetary contributions) received from the lender during the calendar year covered by this statement (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="cumulative year-to-date contributions",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the outstanding loan",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_b1_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule B item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleB2Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "guarantor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the guarantor (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="lender code",
                    ),
                ),
                (
                    "guarantor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the guarantor (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="guarantor title",
                    ),
                ),
                (
                    "guarantor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the guarantor or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="guarantor lastname",
                    ),
                ),
                (
                    "guarantor_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the guarantor (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="guarantor firstname",
                    ),
                ),
                (
                    "guarantor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the guarantor (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="guarantor name suffix",
                    ),
                ),
                (
                    "guarantor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the guarantor (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="guarantor city",
                    ),
                ),
                (
                    "guarantor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the guarantor (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="guarantor state",
                    ),
                ),
                (
                    "guarantor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the guarantor (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="guarantor zip",
                    ),
                ),
                (
                    "guarantor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the guarantor (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="guarantor employer",
                    ),
                ),
                (
                    "guarantor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the guarantor (from LOAN_CD.LOAN_OCC)",
                        max_length=60,
                        verbose_name="guarantor occupation",
                    ),
                ),
                (
                    "guarantor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the guarantor is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="guarantor is self employed",
                    ),
                ),
                (
                    "lender_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the lender (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="lender name",
                    ),
                ),
                (
                    "amount_guaranteed_this_period",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount guaranteed for the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount guaranteed this period",
                    ),
                ),
                (
                    "balance_outstanding_to_date",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance for which the guarantor is liable at the close of the reporting period (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="balance outstanding to date",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative amount guaranteed during the calendar year covered by the statement (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="cumulative year-to-date amount",
                    ),
                ),
                (
                    "loan_date",
                    models.DateField(
                        help_text="Date of the loan or date the line of credit was established(from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="loan date",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "reported_on_b1",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates if the item was actually reported on Part 1 of Schedule B. Until 2001, campaign filers were required to report guarantors of loans or lines of credit on Part 1 of Schedule B.",
                        verbose_name="reported on B1",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the loan was reported (from LOAN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_b2_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule B2 item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleB2ItemOld",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "lender_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the lender (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="lender code",
                    ),
                ),
                (
                    "lender_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="lender's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="lender committee id",
                    ),
                ),
                (
                    "lender_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="lender title",
                    ),
                ),
                (
                    "lender_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="lender lastname",
                    ),
                ),
                (
                    "lender_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the lender (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="lender firstname",
                    ),
                ),
                (
                    "lender_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="lender name suffix",
                    ),
                ),
                (
                    "lender_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="lender city",
                    ),
                ),
                (
                    "lender_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="lender state",
                    ),
                ),
                (
                    "lender_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="lender zip",
                    ),
                ),
                (
                    "lender_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the lender (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="lender employer",
                    ),
                ),
                (
                    "lender_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the lender (from LOAN_CD.LOAN_OCC)",
                        max_length=60,
                        verbose_name="lender occupation",
                    ),
                ),
                (
                    "lender_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the lender is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="lender is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the lender committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "date_repaid_or_forgiven",
                    models.DateField(
                        help_text="Date when the loan repayment or forgiveness occurred (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date paid or forgiven",
                    ),
                ),
                (
                    "date_of_original_loan",
                    models.DateField(
                        help_text="Date the loan was orginally made (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date of original loan",
                    ),
                ),
                (
                    "repayment_type",
                    models.CharField(
                        choices=[
                            ("B2F", "Forgiven"),
                            ("B2R", "Repay"),
                            ("B2T", "Third party payment"),
                        ],
                        help_text="Indicates whether the item is a loan repayment by the campaign filer, a repayment by a third-party or a loan forgiveness by the lender (from LOAN_CD.LOAN_TYPE)",
                        max_length=3,
                        verbose_name="repayment type",
                    ),
                ),
                (
                    "amount_repaid_or_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back or forgiven during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount repaid or forgiven",
                    ),
                ),
                (
                    "outstanding_principle",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding principle of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="outstanding principle",
                    ),
                ),
                (
                    "interest_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of interest paid on the loan during the period covered by the campaign filing (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the loan transaction was reported (from LOAN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_b2_items_old",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule B2 old item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleB2ItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "guarantor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the guarantor (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="lender code",
                    ),
                ),
                (
                    "guarantor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the guarantor (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="guarantor title",
                    ),
                ),
                (
                    "guarantor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the guarantor or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="guarantor lastname",
                    ),
                ),
                (
                    "guarantor_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the guarantor (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="guarantor firstname",
                    ),
                ),
                (
                    "guarantor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the guarantor (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="guarantor name suffix",
                    ),
                ),
                (
                    "guarantor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the guarantor (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="guarantor city",
                    ),
                ),
                (
                    "guarantor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the guarantor (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="guarantor state",
                    ),
                ),
                (
                    "guarantor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the guarantor (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="guarantor zip",
                    ),
                ),
                (
                    "guarantor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the guarantor (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="guarantor employer",
                    ),
                ),
                (
                    "guarantor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the guarantor (from LOAN_CD.LOAN_OCC)",
                        max_length=60,
                        verbose_name="guarantor occupation",
                    ),
                ),
                (
                    "guarantor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the guarantor is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="guarantor is self employed",
                    ),
                ),
                (
                    "lender_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the lender (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="lender name",
                    ),
                ),
                (
                    "amount_guaranteed_this_period",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount guaranteed for the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount guaranteed this period",
                    ),
                ),
                (
                    "balance_outstanding_to_date",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance for which the guarantor is liable at the close of the reporting period (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="balance outstanding to date",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative amount guaranteed during the calendar year covered by the statement (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="cumulative year-to-date amount",
                    ),
                ),
                (
                    "loan_date",
                    models.DateField(
                        help_text="Date of the loan or date the line of credit was established(from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="loan date",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "reported_on_b1",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates if the item was actually reported on Part 1 of Schedule B. Until 2001, campaign filers were required to report guarantors of loans or lines of credit on Part 1 of Schedule B.",
                        verbose_name="reported on B1",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the outstanding loan",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_b2_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule B2 item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleB2ItemVersionOld",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "lender_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the lender (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="lender code",
                    ),
                ),
                (
                    "lender_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="lender's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="lender committee id",
                    ),
                ),
                (
                    "lender_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="lender title",
                    ),
                ),
                (
                    "lender_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="lender lastname",
                    ),
                ),
                (
                    "lender_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the lender (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="lender firstname",
                    ),
                ),
                (
                    "lender_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="lender name suffix",
                    ),
                ),
                (
                    "lender_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="lender city",
                    ),
                ),
                (
                    "lender_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="lender state",
                    ),
                ),
                (
                    "lender_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="lender zip",
                    ),
                ),
                (
                    "lender_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the lender (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="lender employer",
                    ),
                ),
                (
                    "lender_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the lender (from LOAN_CD.LOAN_OCC)",
                        max_length=60,
                        verbose_name="lender occupation",
                    ),
                ),
                (
                    "lender_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the lender is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="lender is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the lender committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the lender committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the lender committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the lender committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the lender committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the lender committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the lender committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "date_repaid_or_forgiven",
                    models.DateField(
                        help_text="Date when the loan repayment or forgiveness occurred (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date paid or forgiven",
                    ),
                ),
                (
                    "date_of_original_loan",
                    models.DateField(
                        help_text="Date the loan was orginally made (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date of original loan",
                    ),
                ),
                (
                    "repayment_type",
                    models.CharField(
                        choices=[
                            ("B2F", "Forgiven"),
                            ("B2R", "Repay"),
                            ("B2T", "Third party payment"),
                        ],
                        help_text="Indicates whether the item is a loan repayment by the campaign filer, a repayment by a third-party or a loan forgiveness by the lender (from LOAN_CD.LOAN_TYPE)",
                        max_length=3,
                        verbose_name="repayment type",
                    ),
                ),
                (
                    "amount_repaid_or_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back or forgiven during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount repaid or forgiven",
                    ),
                ),
                (
                    "outstanding_principle",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding principle of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="outstanding principle",
                    ),
                ),
                (
                    "interest_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of interest paid on the loan during the period covered by the campaign filing (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the loan transaction",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_b2_items_old",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule B2 old item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleCItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        help_text="Date the contribution was received (from RCPT_CD.RCPT_DATE)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("", "Unknown"),
                            ("INC16168", "INC16168"),
                        ],
                        help_text="Type of transaction (from RCPT_CD.TRAN_TYPE)",
                        max_length=255,
                        verbose_name="transaction type",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from RCPT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="contributor committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from RCPT_CD.CTRIB_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from RCPT_CD.CTRIB_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from RCPT_CD.CTRIB_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from RCPT_CD.CTRIB_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from RCPT_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from RCPT_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "intermediary_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)",
                        max_length=9,
                        verbose_name="intermediary committee id",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from RCPT_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from RCPT_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from RCPT_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from RCPT_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "intermediary_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the intermediary (from RCPT_CD.INTR_EMP)",
                        max_length=200,
                        verbose_name="intermediary employer",
                    ),
                ),
                (
                    "intermediary_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the intermediary (from RCPT_CD.INTR_OCC)",
                        max_length=60,
                        verbose_name="intermediary occupation",
                    ),
                ),
                (
                    "intermediary_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="(from S497_CD.INTR_SELF)",
                        verbose_name="intermediary is self employed",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "fair_market_value",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount it would cost to purchase the donated goods or services on the open market (from RCPT_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="fair market value",
                    ),
                ),
                (
                    "contribution_description",
                    models.CharField(
                        blank=True,
                        help_text="Description of the contributed goods or services (from RCPT_CD.CTRIB_DSCR)",
                        max_length=90,
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the monetary contribution was reported (from RCPT_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_c_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule C item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleCItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        help_text="Date the contribution was received (from RCPT_CD.RCPT_DATE)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("", "Unknown"),
                            ("INC16168", "INC16168"),
                        ],
                        help_text="Type of transaction (from RCPT_CD.TRAN_TYPE)",
                        max_length=255,
                        verbose_name="transaction type",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from RCPT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="contributor committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from RCPT_CD.CTRIB_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from RCPT_CD.CTRIB_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from RCPT_CD.CTRIB_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from RCPT_CD.CTRIB_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from RCPT_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from RCPT_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "intermediary_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)",
                        max_length=9,
                        verbose_name="intermediary committee id",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from RCPT_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from RCPT_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from RCPT_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from RCPT_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "intermediary_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the intermediary (from RCPT_CD.INTR_EMP)",
                        max_length=200,
                        verbose_name="intermediary employer",
                    ),
                ),
                (
                    "intermediary_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the intermediary (from RCPT_CD.INTR_OCC)",
                        max_length=60,
                        verbose_name="intermediary occupation",
                    ),
                ),
                (
                    "intermediary_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="(from S497_CD.INTR_SELF)",
                        verbose_name="intermediary is self employed",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "fair_market_value",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount it would cost to purchase the donated goods or services on the open market (from RCPT_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="fair market value",
                    ),
                ),
                (
                    "contribution_description",
                    models.CharField(
                        blank=True,
                        help_text="Description of the contributed goods or services (from RCPT_CD.CTRIB_DSCR)",
                        max_length=90,
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the received contribution",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_c_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule C item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleCSummary",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "itemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - itemized nonmonetary contributions. (Include all Schedule C subtotals)",
                        null=True,
                        verbose_name="itemized contributions",
                    ),
                ),
                (
                    "unitemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - unitemized nonmonetary contributions of less than $100",
                        null=True,
                        verbose_name="unitemized contributions",
                    ),
                ),
                (
                    "total_contributions",
                    models.FloatField(
                        help_text="Total nonmonetary contributions received this period. (Add Lines 1 and 2. Enter here and on the Summary Page, Column A, Lines 4 and 10.)",
                        null=True,
                        verbose_name="total contributions",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the summary was reported",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_c_summaries",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule C summary",
                "verbose_name_plural": "Form 460 (Campaign Disclosure) Schedule C summaries",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleCSummaryVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "itemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - itemized nonmonetary contributions. (Include all Schedule C subtotals)",
                        null=True,
                        verbose_name="itemized contributions",
                    ),
                ),
                (
                    "unitemized_contributions",
                    models.FloatField(
                        help_text="Amount received this period - unitemized nonmonetary contributions of less than $100",
                        null=True,
                        verbose_name="unitemized contributions",
                    ),
                ),
                (
                    "total_contributions",
                    models.FloatField(
                        help_text="Total nonmonetary contributions received this period. (Add Lines 1 and 2. Enter here and on the Summary Page, Column A, Lines 4 and 10.)",
                        null=True,
                        verbose_name="total contributions",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the summary",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_c_summaries",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule C summary version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleDItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="If the candidate is subject to contribution limits, the cumulative amount given by the filer during the election cycle as of the Form 460's filing date (from EXPN_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the payment was reported (from EXPN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_d_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule D item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleDItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="If the candidate is subject to contribution limits, the cumulative amount given by the filer during the election cycle as of the Form 460's filing date (from EXPN_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the payment made",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_d_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule D item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleEItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the payment was reported (from EXPN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_e_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule E item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleEItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the payment made",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_e_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule E item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleESubItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "parent_transaction_id",
                    models.CharField(
                        blank=True,
                        help_text="Refers to a parent transaction itemized on the same Form 460 filing (from EXPN_CD.BAKREF_TID)",
                        max_length=20,
                        verbose_name="parent transaction id",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the payment was reported (from EXPN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_e_subitems",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule E subitem",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleESubItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "parent_transaction_id",
                    models.CharField(
                        blank=True,
                        help_text="Refers to a parent transaction itemized on the same Form 460 filing (from EXPN_CD.BAKREF_TID)",
                        max_length=20,
                        verbose_name="parent transaction id",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the payment made",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_e_subitems",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule E subitem version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleESummary",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "itemized_expenditures",
                    models.FloatField(
                        help_text="Payments made this period of $100 or more. (Include all Schedule E subtotals.)",
                        null=True,
                        verbose_name="itemized expenditures",
                    ),
                ),
                (
                    "unitemized_expenditures",
                    models.FloatField(
                        help_text="Unitemized payments made this period of under $100.",
                        null=True,
                        verbose_name="unitemized expenditures",
                    ),
                ),
                (
                    "interest_paid",
                    models.FloatField(
                        help_text="Total interest paid this period on loans. (Enter amount from Schedule B, Part 1, Column (e).)",
                        null=True,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "total_expenditures",
                    models.FloatField(
                        help_text="Total payments made this period. (Add lines 1, 2, and 3. Enter here and on the Summary Page, Column A, Line 6.) ",
                        null=True,
                        verbose_name="total expenditures",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the summary was reported",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_e_summaries",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule E summary",
                "verbose_name_plural": "Form 460 (Campaign Disclosure) Schedule E summaries",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleESummaryVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "itemized_expenditures",
                    models.FloatField(
                        help_text="Payments made this period of $100 or more. (Include all Schedule E subtotals.)",
                        null=True,
                        verbose_name="itemized expenditures",
                    ),
                ),
                (
                    "unitemized_expenditures",
                    models.FloatField(
                        help_text="Unitemized payments made this period of under $100.",
                        null=True,
                        verbose_name="unitemized expenditures",
                    ),
                ),
                (
                    "interest_paid",
                    models.FloatField(
                        help_text="Total interest paid this period on loans. (Enter amount from Schedule B, Part 1, Column (e).)",
                        null=True,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "total_expenditures",
                    models.FloatField(
                        help_text="Total payments made this period. (Add lines 1, 2, and 3. Enter here and on the Summary Page, Column A, Line 6.) ",
                        null=True,
                        verbose_name="total expenditures",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the summary",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_e_summaries",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule E summary version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleFItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the unpaid bill is itemized (from DEBT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from DEBT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from DEBT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from DEBT_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from DEBT_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from DEBT_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from DEBT_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from DEBT_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from DEBT_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from DEBT_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from DEBT_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from DEBT_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from DEBT_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from DEBT_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from DEBT_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from DEBT_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from DEBT_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from DEBT_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "begin_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance at the beginning of period covered by the filing (from DEBT_CD.BEG_BAL)",
                        max_digits=14,
                        verbose_name="begin balance",
                    ),
                ),
                (
                    "amount_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid this period (from DEBT_CD.AMT_PAID)",
                        max_digits=14,
                    ),
                ),
                (
                    "amount_incurred",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount incurred this period (from DEBT_CD.AMT_INCUR)",
                        max_digits=14,
                        verbose_name="amount incurred",
                    ),
                ),
                (
                    "end_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance at the end of period covered by the filing (from DEBT_CD.END_BAL)",
                        max_digits=14,
                        verbose_name="end balance",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from DEBT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "parent_transaction_id",
                    models.CharField(
                        blank=True,
                        help_text="Refers to a parent transaction itemized on the same Form 460 filing (from DEBT_CD.BAKREF_TID)",
                        max_length=20,
                        verbose_name="parent transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from DEBT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "memo_code",
                    models.BooleanField(
                        default=False,
                        help_text="Memo amount flag (from DEBT_CD.MEMO_CODE)",
                        verbose_name="memo_code",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the payment was reported (from DEBT_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_f_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule F item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleFItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the unpaid bill is itemized (from DEBT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from DEBT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from DEBT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from DEBT_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from DEBT_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from DEBT_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from DEBT_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from DEBT_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from DEBT_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from DEBT_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from DEBT_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from DEBT_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from DEBT_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from DEBT_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from DEBT_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from DEBT_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from DEBT_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from DEBT_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "begin_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance at the beginning of period covered by the filing (from DEBT_CD.BEG_BAL)",
                        max_digits=14,
                        verbose_name="begin balance",
                    ),
                ),
                (
                    "amount_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid this period (from DEBT_CD.AMT_PAID)",
                        max_digits=14,
                    ),
                ),
                (
                    "amount_incurred",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount incurred this period (from DEBT_CD.AMT_INCUR)",
                        max_digits=14,
                        verbose_name="amount incurred",
                    ),
                ),
                (
                    "end_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance at the end of period covered by the filing (from DEBT_CD.END_BAL)",
                        max_digits=14,
                        verbose_name="end balance",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from DEBT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "parent_transaction_id",
                    models.CharField(
                        blank=True,
                        help_text="Refers to a parent transaction itemized on the same Form 460 filing (from DEBT_CD.BAKREF_TID)",
                        max_length=20,
                        verbose_name="parent transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from DEBT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "memo_code",
                    models.BooleanField(
                        default=False,
                        help_text="Memo amount flag (from DEBT_CD.MEMO_CODE)",
                        verbose_name="memo_code",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the Schedule F items",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_f_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule F item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleGItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "parent_transaction_id",
                    models.CharField(
                        blank=True,
                        help_text="Refers to a parent transaction itemized on the same Form 460 filing (from EXPN_CD.BAKREF_TID)",
                        max_length=20,
                        verbose_name="parent transaction id",
                    ),
                ),
                (
                    "agent_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the agent (from EXPN_CD.AGENT_NAMT)",
                        max_length=10,
                        verbose_name="agent title",
                    ),
                ),
                (
                    "agent_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the agent or business name (from EXPN_CD.AGENT_NAML)",
                        max_length=200,
                        verbose_name="agent lastname",
                    ),
                ),
                (
                    "agent_firstname",
                    models.CharField(
                        help_text="First name of the agent (from EXPN_CD.AGENT_NAMF)",
                        max_length=45,
                        verbose_name="agent firstname",
                    ),
                ),
                (
                    "agent_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the agent (from EXPN_CD.AGENT_NAMS)",
                        max_length=10,
                        verbose_name="agent name suffix",
                    ),
                ),
                (
                    "parent_schedule",
                    models.CharField(
                        blank=True,
                        help_text="Indicates which schedule (E or F) includes the parent item (from EXPN_CD.G_FROM_E_F)",
                        max_length=1,
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the payment was reported (from RCPT_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_g_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule G item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleGItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the payment is itemized (from EXPN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "payee_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure's name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("MBR", "Member of Associaton"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payee (from EXPN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="payee code",
                    ),
                ),
                (
                    "payee_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Payee's filer identification number, if it is a committee (from EXPN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="payee committee id",
                    ),
                ),
                (
                    "payee_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee (from EXPN_CD.PAYEE_NAMT)",
                        max_length=10,
                        verbose_name="payee title",
                    ),
                ),
                (
                    "payee_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee or business name (from EXPN_CD.PAYEE_NAML)",
                        max_length=200,
                        verbose_name="payee lastname",
                    ),
                ),
                (
                    "payee_firstname",
                    models.CharField(
                        help_text="First name of the payee (from EXPN_CD.PAYEE_NAMF)",
                        max_length=45,
                        verbose_name="payee firstname",
                    ),
                ),
                (
                    "payee_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee (from EXPN_CD.PAYEE_NAMS)",
                        max_length=10,
                        verbose_name="payee name suffix",
                    ),
                ),
                (
                    "payee_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee (from EXPN_CD.PAYEE_CITY)",
                        max_length=30,
                        verbose_name="payee city",
                    ),
                ),
                (
                    "payee_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee (from EXPN_CD.PAYEE_ST)",
                        max_length=2,
                        verbose_name="payee state",
                    ),
                ),
                (
                    "payee_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee (from EXPN_CD.PAYEE_ZIP4)",
                        max_length=10,
                        verbose_name="payee zip",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the payee committee's treasurer (from EXPN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the payee committee's treasurer (from EXPN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the payee committee's treasurer (from EXPN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the payee committee's treasurer (from EXPN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the payee committee's treasurer (from EXPN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the payee committee's treasurer (from EXPN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the payee committee's treasurer (from EXPN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "payment_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CMP", "Campaign paraphernalia/miscellaneous"),
                            ("CNS", "Campaign consultants"),
                            ("CTB", "Contribution (if nonmonetary, explain)*"),
                            ("CVC", "Civic donations"),
                            ("FIL", "Candidate filing/ballot feeds"),
                            ("FND", "Fundraising events"),
                            ("IKD", "In-kind contribution (nonmonetary)"),
                            (
                                "IND",
                                "Independent expenditure supporting/opposing others (explain)*",
                            ),
                            ("LEG", "Legal defense"),
                            ("LIT", "Campaign literature and mailings"),
                            ("LON", "Loan"),
                            ("MBR", "Member communications"),
                            ("MON", "Monetary contribution"),
                            ("MTG", "Meetings and appearances"),
                            ("OFC", "Office expenses"),
                            ("PET", "Petition circulating"),
                            ("PHO", "Phone banks"),
                            ("POL", "Polling and survey research"),
                            ("POS", "Postage, delivery and messenger services"),
                            ("PRO", "Professional services (legal, accounting)"),
                            ("PRT", "Print ads"),
                            ("RAD", "Radio airtime and production costs"),
                            ("RFD", "Returned contributions"),
                            ("SAL", "Campaign workers salaries"),
                            ("TEL", "T.V. or cable airtime and production costs"),
                            ("TRC", "Candidate travel, lodging and meals (explain)"),
                            ("TRS", "Staff/spouse travel, lodging and meals (explain)"),
                            (
                                "TSF",
                                "Transfer between committees of the same candidate/sponsor",
                            ),
                            ("VOT", "Voter registration"),
                            ("WEB", "Information technology costs (internet, e-mail)"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the payment (from EXPN_CD.EXPN_CODE)",
                        max_length=3,
                        verbose_name="payment code",
                    ),
                ),
                (
                    "payment_description",
                    models.CharField(
                        blank=True,
                        help_text="Purpose of payment and/or description/explanation (from EXPN_CD.EXPN_DSCR)",
                        max_length=400,
                        verbose_name="payment description",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid to the payee in the period covered by the filing (from EXPN_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given or spent by the filer in support or opposition of the candidate or ballot measure as of the Form 460's filing date (from EXPN_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "expense_date",
                    models.DateField(
                        help_text="Date or expense (from EXPN_CD.EXPN_DATE)",
                        null=True,
                        verbose_name="expense date",
                    ),
                ),
                (
                    "check_number",
                    models.CharField(
                        blank=True,
                        help_text="Optional check number for the payment made by the campaign filer (from EXPN_CD.EXPN_CHKNO)",
                        max_length=20,
                        verbose_name="expense check number",
                    ),
                ),
                (
                    "support_oppose_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("S", "Support"),
                            ("O", "Oppose"),
                            ("?", "Unknown value"),
                        ],
                        help_text="If applicable, code indicating whether the payment went toward supporting or opposing a candidate/ballot measure (from EXPN_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support oppose code",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, the jurisdiction subject to the ballot measure (from EXPN_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, name of the ballot measure (from EXPN_CD.BAL_NAME  or EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_num",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a ballot measure, ballot number or letter (from EXPN_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="ballot measure number",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name title of the candidate (from EXPN_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, last name of the candidate or business name (from EXPN_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate lastname",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, first name of the candidate (from EXPN_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate firstname",
                    ),
                ),
                (
                    "candidate_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate, name suffix of the candidate (from EXPN_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ASM", "Assembly District"),
                            ("BOE", "Board of Equalization District"),
                            ("CIT", "City"),
                            ("CTY", "County"),
                            ("LOC", "Local"),
                            ("OTH", "Other"),
                            ("SEN", "Senate District"),
                            ("STW", "Statewide"),
                            ("???", "Statewide"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating the jurisdiction of the office (from EXPN_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jurisdiction",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a county, city or local candidate, full description of the office (from EXPN_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiciton description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,for state senate, assembly or local board of education, thedistrict of the office (from EXPN_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "office_sought_held",
                    models.CharField(
                        blank=True,
                        choices=[("S", "SOUGHT"), ("H", "HELD")],
                        help_text="If the payment went toward supporting/opposing a candidate,code indicating if the candidate is seeking or currently holds the office (from EXPN_CD.OFF_S_H_CD)",
                        max_length=1,
                        verbose_name="office sought or held",
                    ),
                ),
                (
                    "office_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("APP", "State Appellate Court Justice"),
                            ("ASM", "State Assembly Person"),
                            ("ASR", "Assessor"),
                            ("ATT", "Attorney General"),
                            ("BED", "Board of Education"),
                            ("BOE", "Board of Equalization Member"),
                            ("BSU", "Board of Supervisors"),
                            ("CAT", "City Attorney"),
                            ("CCB", "Community College Board"),
                            ("CCM", "City Council Member"),
                            ("CON", "State Controller"),
                            ("COU", "County Counsel"),
                            ("CSU", "County Supervisor"),
                            ("CTR", "Local Controller"),
                            ("DAT", "District Attorney"),
                            ("GOV", "Governor"),
                            ("INS", "Insurance Commissioner"),
                            ("LTG", "Lieutenant Governor"),
                            ("MAY", "Mayor"),
                            ("OTH", "Other"),
                            ("PDR", "Public Defender"),
                            ("PER", "Public Employees Retirement System"),
                            ("PLN", "Planning Commissioner"),
                            ("SCJ", "Superior Court Judge"),
                            ("SEN", "State Senator"),
                            ("SHC", "Sheriff-Coroner"),
                            ("SOS", "Secretary of State"),
                            ("SPM", "Supreme Court Justice"),
                            ("SUP", "Superintendent of Public Instruction"),
                            ("TRE", "State Treasurer"),
                            ("TRS", "Local Treasurer"),
                            ("???", "Unknown value"),
                        ],
                        help_text="If the payment went toward supporting/opposing a candidate,code describing the office (from EXPN_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="office code",
                    ),
                ),
                (
                    "office_description",
                    models.CharField(
                        blank=True,
                        help_text="If the payment went toward supporting/opposing a candidate,description of the office (from EXPN_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="office description",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from EXPN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from EXPN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "parent_transaction_id",
                    models.CharField(
                        blank=True,
                        help_text="Refers to a parent transaction itemized on the same Form 460 filing (from EXPN_CD.BAKREF_TID)",
                        max_length=20,
                        verbose_name="parent transaction id",
                    ),
                ),
                (
                    "agent_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the agent (from EXPN_CD.AGENT_NAMT)",
                        max_length=10,
                        verbose_name="agent title",
                    ),
                ),
                (
                    "agent_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the agent or business name (from EXPN_CD.AGENT_NAML)",
                        max_length=200,
                        verbose_name="agent lastname",
                    ),
                ),
                (
                    "agent_firstname",
                    models.CharField(
                        help_text="First name of the agent (from EXPN_CD.AGENT_NAMF)",
                        max_length=45,
                        verbose_name="agent firstname",
                    ),
                ),
                (
                    "agent_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the agent (from EXPN_CD.AGENT_NAMS)",
                        max_length=10,
                        verbose_name="agent name suffix",
                    ),
                ),
                (
                    "parent_schedule",
                    models.CharField(
                        blank=True,
                        help_text="Indicates which schedule (E or F) includes the parent item (from EXPN_CD.G_FROM_E_F)",
                        max_length=1,
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the payment made",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_g_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule G item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleH2ItemOld",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "recipient_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the recipient (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="recipient code",
                    ),
                ),
                (
                    "recipient_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="recipient's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="recipient committee id",
                    ),
                ),
                (
                    "recipient_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="recipient title",
                    ),
                ),
                (
                    "recipient_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="recipient lastname",
                    ),
                ),
                (
                    "recipient_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the recipient (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="recipient firstname",
                    ),
                ),
                (
                    "recipient_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="recipient name suffix",
                    ),
                ),
                (
                    "recipient_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="recipient city",
                    ),
                ),
                (
                    "recipient_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="recipient state",
                    ),
                ),
                (
                    "recipient_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="recipient zip",
                    ),
                ),
                (
                    "recipient_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the recipient (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="recipient employer",
                    ),
                ),
                (
                    "recipient_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the recipient (from LOAN_CD.LOAN_OCC). Note that, in some cases, the value seems to actually be the recipient's committee ID.",
                        max_length=60,
                        verbose_name="recipient occupation",
                    ),
                ),
                (
                    "recipient_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the recipient is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="recipient is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the recipient committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "date_repaid_or_forgiven",
                    models.DateField(
                        help_text="Date when the loan repayment or forgiveness occurred (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date paid or forgiven",
                    ),
                ),
                (
                    "date_of_original_loan",
                    models.DateField(
                        help_text="Date the loan was orginally made (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date of original loan",
                    ),
                ),
                (
                    "repayment_type",
                    models.CharField(
                        choices=[
                            ("H2F", "Forgiven"),
                            ("H2R", "Repay"),
                            ("H2T", "Third party payment"),
                        ],
                        help_text="Indicates whether the item is a loan repayment to the campaign filer, a repayment by a third-party or a loan forgiveness by the campaign filer (from LOAN_CD.LOAN_TYPE)",
                        max_length=3,
                        verbose_name="repayment type",
                    ),
                ),
                (
                    "amount_repaid_or_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back or forgiven during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount repaid or forgiven",
                    ),
                ),
                (
                    "outstanding_principle",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="outstanding principle",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the loan was reported (from LOAN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_h2_items_old",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule H2 old item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleH2ItemVersionOld",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "recipient_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the recipient (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="recipient code",
                    ),
                ),
                (
                    "recipient_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="recipient's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="recipient committee id",
                    ),
                ),
                (
                    "recipient_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="recipient title",
                    ),
                ),
                (
                    "recipient_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="recipient lastname",
                    ),
                ),
                (
                    "recipient_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the recipient (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="recipient firstname",
                    ),
                ),
                (
                    "recipient_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="recipient name suffix",
                    ),
                ),
                (
                    "recipient_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="recipient city",
                    ),
                ),
                (
                    "recipient_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="recipient state",
                    ),
                ),
                (
                    "recipient_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="recipient zip",
                    ),
                ),
                (
                    "recipient_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the recipient (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="recipient employer",
                    ),
                ),
                (
                    "recipient_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the recipient (from LOAN_CD.LOAN_OCC). Note that, in some cases, the value seems to actually be the recipient's committee ID.",
                        max_length=60,
                        verbose_name="recipient occupation",
                    ),
                ),
                (
                    "recipient_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the recipient is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="recipient is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the recipient committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "date_repaid_or_forgiven",
                    models.DateField(
                        help_text="Date when the loan repayment or forgiveness occurred (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date paid or forgiven",
                    ),
                ),
                (
                    "date_of_original_loan",
                    models.DateField(
                        help_text="Date the loan was orginally made (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date of original loan",
                    ),
                ),
                (
                    "repayment_type",
                    models.CharField(
                        choices=[
                            ("H2F", "Forgiven"),
                            ("H2R", "Repay"),
                            ("H2T", "Third party payment"),
                        ],
                        help_text="Indicates whether the item is a loan repayment to the campaign filer, a repayment by a third-party or a loan forgiveness by the campaign filer (from LOAN_CD.LOAN_TYPE)",
                        max_length=3,
                        verbose_name="repayment type",
                    ),
                ),
                (
                    "amount_repaid_or_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back or forgiven during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount repaid or forgiven",
                    ),
                ),
                (
                    "outstanding_principle",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="outstanding principle",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the outstanding loan",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_h2_items_old",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule H2 old item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleHItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "recipient_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the recipient (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="recipient code",
                    ),
                ),
                (
                    "recipient_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="recipient's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="recipient committee id",
                    ),
                ),
                (
                    "recipient_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="recipient title",
                    ),
                ),
                (
                    "recipient_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="recipient lastname",
                    ),
                ),
                (
                    "recipient_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the recipient (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="recipient firstname",
                    ),
                ),
                (
                    "recipient_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="recipient name suffix",
                    ),
                ),
                (
                    "recipient_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="recipient city",
                    ),
                ),
                (
                    "recipient_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="recipient state",
                    ),
                ),
                (
                    "recipient_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="recipient zip",
                    ),
                ),
                (
                    "recipient_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the recipient (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="recipient employer",
                    ),
                ),
                (
                    "recipient_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the recipient (from LOAN_CD.LOAN_OCC). Note that, in some cases, the value seems to actually be the recipient's committee ID.",
                        max_length=60,
                        verbose_name="recipient occupation",
                    ),
                ),
                (
                    "recipient_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the recipient is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="recipient is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the recipient committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "begin_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the beginning of theperiod covered by the filing (from LOAN_CD.LOAN_AMT4)",
                        max_digits=14,
                        verbose_name="beginning period balance",
                    ),
                ),
                (
                    "amount_loaned",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount loaned during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount loaned",
                    ),
                ),
                (
                    "amount_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back during the period covered by the filing (from LOAN_CD.LOAN_AMT5)",
                        max_digits=14,
                        verbose_name="amount paid",
                    ),
                ),
                (
                    "amount_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount forgiven by the campaign filer during the period covered by the filing (from LOAN_CD.LOAN_AMT6)",
                        max_digits=14,
                        verbose_name="amount forgiven",
                    ),
                ),
                (
                    "end_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="end period balance",
                    ),
                ),
                (
                    "date_due",
                    models.DateField(
                        help_text="Date that the loan is due (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date due",
                    ),
                ),
                (
                    "interest_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of interest paid on the loan during the period covered by the campaign filing (from LOAN_CD.LOAN_AMT7)",
                        max_digits=14,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "original_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Original amount loaned by the lender to the campaign filer (from LOAN_CD.LOAN_AMT8)",
                        max_digits=14,
                        verbose_name="original amount",
                    ),
                ),
                (
                    "date_incurred",
                    models.DateField(
                        help_text="Date the loan was made or received (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date incurred",
                    ),
                ),
                (
                    "cumulative_ytd_contributions",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative amount of contributions (loans, monetary and nonmonetary contributions) from the campaign filer to the recipient during the calendar year covered by this statement (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="cumulative year-to-date contributions",
                    ),
                ),
                (
                    "reported_on_h1",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates if the item was actually reported on Part 1 of Schedule H. Until 2001, campaign filers were required to report loans made to others on Part 1 of Schedule H, separate from repayments or forgiveness of those loans (Schedule H, Part 2)",
                        verbose_name="reported on H1",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Foreign key referring to the Form 460 on which the loan was reported (from LOAN_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_h_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule H item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleHItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the loan is itemized (from LOAN_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from LOAN_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from LOAN_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from LOAN_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from LOAN_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from LOAN_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from LOAN_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from LOAN_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "interest_rate",
                    models.CharField(
                        blank=True,
                        help_text="Interest rate of the loan. This is sometimes expressed as a decimal (e.g., 0.10) and other times as a percent (e.g., 10.0% (from LOAN_CD.LOAN_RATE)",
                        max_length=30,
                        verbose_name="interest rate",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from LOAN_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="A value assigned by the filer which refers to the item'sfootnote in the TEXT_MEMO_CD table (from LOAN_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "recipient_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                            ("???", "Unknown value"),
                        ],
                        help_text="Code describing the recipient (from LOAN_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="recipient code",
                    ),
                ),
                (
                    "recipient_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="recipient's filer identification number, if it is a committee (from LOAN_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="recipient committee id",
                    ),
                ),
                (
                    "recipient_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient (from LOAN_CD.LNDR_NAMT)",
                        max_length=10,
                        verbose_name="recipient title",
                    ),
                ),
                (
                    "recipient_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient or business name (from LOAN_CD.LNDR_NAML)",
                        max_length=200,
                        verbose_name="recipient lastname",
                    ),
                ),
                (
                    "recipient_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the recipient (from LOAN_CD.LNDR_NAMF)",
                        max_length=45,
                        verbose_name="recipient firstname",
                    ),
                ),
                (
                    "recipient_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient (from LOAN_CD.LNDR_NAMS)",
                        max_length=10,
                        verbose_name="recipient name suffix",
                    ),
                ),
                (
                    "recipient_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient (from LOAN_CD.LOAN_CITY)",
                        max_length=30,
                        verbose_name="recipient city",
                    ),
                ),
                (
                    "recipient_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient (from LOAN_CD.LOAN_ST)",
                        max_length=2,
                        verbose_name="recipient state",
                    ),
                ),
                (
                    "recipient_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient (from LOAN_CD.LOAN_ZIP4)",
                        max_length=10,
                        verbose_name="recipient zip",
                    ),
                ),
                (
                    "recipient_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the recipient (from LOAN_CD.LOAN_EMP)",
                        max_length=200,
                        verbose_name="recipient employer",
                    ),
                ),
                (
                    "recipient_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the recipient (from LOAN_CD.LOAN_OCC). Note that, in some cases, the value seems to actually be the recipient's committee ID.",
                        max_length=60,
                        verbose_name="recipient occupation",
                    ),
                ),
                (
                    "recipient_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the recipient is self-employed(from LOAN_CD.LOAN_SELF)",
                        verbose_name="recipient is self employed",
                    ),
                ),
                (
                    "treasurer_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient committee's treasurer (from LOAN_CD.TRES_NAMT)",
                        max_length=10,
                        verbose_name="treasurer title",
                    ),
                ),
                (
                    "treasurer_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient committee's treasurer (from LOAN_CD.TRES_NAML)",
                        max_length=200,
                        verbose_name="treasurer lastname",
                    ),
                ),
                (
                    "treasurer_firstname",
                    models.CharField(
                        help_text="First name of the recipient committee's treasurer (from LOAN_CD.TRES_NAMF)",
                        max_length=45,
                        verbose_name="treasurer firstname",
                    ),
                ),
                (
                    "treasurer_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient committee's treasurer (from LOAN_CD.TRES_NAMS)",
                        max_length=10,
                        verbose_name="treasurer name suffix",
                    ),
                ),
                (
                    "treasurer_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient committee's treasurer (from LOAN_CD.TRES_CITY)",
                        max_length=30,
                        verbose_name="treasurer city",
                    ),
                ),
                (
                    "treasurer_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient committee's treasurer (from LOAN_CD.TRES_ST)",
                        max_length=2,
                        verbose_name="treasurer state",
                    ),
                ),
                (
                    "treasurer_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient committee's treasurer (from LOAN_CD.TRES_ZIP4)",
                        max_length=10,
                        verbose_name="treasurer zip",
                    ),
                ),
                (
                    "begin_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the beginning of theperiod covered by the filing (from LOAN_CD.LOAN_AMT4)",
                        max_digits=14,
                        verbose_name="beginning period balance",
                    ),
                ),
                (
                    "amount_loaned",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount loaned during the period covered by the filing (from LOAN_CD.LOAN_AMT1)",
                        max_digits=14,
                        verbose_name="amount loaned",
                    ),
                ),
                (
                    "amount_paid",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount paid back during the period covered by the filing (from LOAN_CD.LOAN_AMT5)",
                        max_digits=14,
                        verbose_name="amount paid",
                    ),
                ),
                (
                    "amount_forgiven",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount forgiven by the campaign filer during the period covered by the filing (from LOAN_CD.LOAN_AMT6)",
                        max_digits=14,
                        verbose_name="amount forgiven",
                    ),
                ),
                (
                    "end_period_balance",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Outstanding balance of the loan at the end of the period covered by the filing (from LOAN_CD.LOAN_AMT2)",
                        max_digits=14,
                        verbose_name="end period balance",
                    ),
                ),
                (
                    "date_due",
                    models.DateField(
                        help_text="Date that the loan is due (from LOAN_CD.LOAN_DATE2)",
                        null=True,
                        verbose_name="date due",
                    ),
                ),
                (
                    "interest_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of interest paid on the loan during the period covered by the campaign filing (from LOAN_CD.LOAN_AMT7)",
                        max_digits=14,
                        verbose_name="interest paid",
                    ),
                ),
                (
                    "original_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Original amount loaned by the lender to the campaign filer (from LOAN_CD.LOAN_AMT8)",
                        max_digits=14,
                        verbose_name="original amount",
                    ),
                ),
                (
                    "date_incurred",
                    models.DateField(
                        help_text="Date the loan was made or received (from LOAN_CD.LOAN_DATE1)",
                        null=True,
                        verbose_name="date incurred",
                    ),
                ),
                (
                    "cumulative_ytd_contributions",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative amount of contributions (loans, monetary and nonmonetary contributions) from the campaign filer to the recipient during the calendar year covered by this statement (from LOAN_CD.LOAN_AMT3)",
                        max_digits=14,
                        verbose_name="cumulative year-to-date contributions",
                    ),
                ),
                (
                    "reported_on_h1",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates if the item was actually reported on Part 1 of Schedule H. Until 2001, campaign filers were required to report loans made to others on Part 1 of Schedule H, separate from repayments or forgiveness of those loans (Schedule H, Part 2)",
                        verbose_name="reported on H1",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the outstanding loan",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_h_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule H item version",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleIItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        help_text="Date the contribution was received (from RCPT_CD.RCPT_DATE)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("", "Unknown"),
                            ("INC16168", "INC16168"),
                        ],
                        help_text="Type of transaction (from RCPT_CD.TRAN_TYPE)",
                        max_length=255,
                        verbose_name="transaction type",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from RCPT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="contributor committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from RCPT_CD.CTRIB_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from RCPT_CD.CTRIB_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from RCPT_CD.CTRIB_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from RCPT_CD.CTRIB_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from RCPT_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from RCPT_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "intermediary_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)",
                        max_length=9,
                        verbose_name="intermediary committee id",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from RCPT_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from RCPT_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from RCPT_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from RCPT_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "intermediary_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the intermediary (from RCPT_CD.INTR_EMP)",
                        max_length=200,
                        verbose_name="intermediary employer",
                    ),
                ),
                (
                    "intermediary_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the intermediary (from RCPT_CD.INTR_OCC)",
                        max_length=60,
                        verbose_name="intermediary occupation",
                    ),
                ),
                (
                    "intermediary_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="(from S497_CD.INTR_SELF)",
                        verbose_name="intermediary is self employed",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of cash increase from the contributor in the period covered by the filing (from RCPT_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "receipt_description",
                    models.CharField(
                        blank=True,
                        help_text="Description of the cash increase (from RCPT_CD.CTRIB_DSCR)",
                        max_length=90,
                        verbose_name="receipt description",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        db_constraint=False,
                        help_text="Foreign key referring to the Form 460 on which the miscellaneous cash increase was report (from RCPT_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_i_items",
                        to="calaccess_processed_filings.Form460Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule I item",
            },
        ),
        migrations.CreateModel(
            name="Form460ScheduleIItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        help_text="Line number of the filing form where the contribution is itemized (from RCPT_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        help_text="Date the contribution was received (from RCPT_CD.RCPT_DATE)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days (from RCPT_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("F", "Forgiven Loan"),
                            ("I", "Intermediary"),
                            ("R", "Returned (Negative Amount?)"),
                            ("T", "Third Party Repayment"),
                            ("X", "Transfer"),
                            ("", "Unknown"),
                            ("INC16168", "INC16168"),
                        ],
                        help_text="Type of transaction (from RCPT_CD.TRAN_TYPE)",
                        max_length=255,
                        verbose_name="transaction type",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Identifies a unique transaction across versions of the a given Form 460 filing (from RCPT_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the contribution (from RCPT_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("COM", "Committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from RCPT_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="contributor committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from RCPT_CD.CTRIB_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor or business name (from RCPT_CD.CTRIB_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from RCPT_CD.CTRIB_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from RCPT_CD.CTRIB_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from RCPT_CD.CTRIB_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from RCPT_CD.CTRIB_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from RCPT_CD.CTRIB_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from RCPT_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from RCPT_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from RCPT_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "intermediary_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Intermediary's filer identification number, if it is a committee (from RCPT_CD.INTR_CMTEID)",
                        max_length=9,
                        verbose_name="intermediary committee id",
                    ),
                ),
                (
                    "intermediary_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the intermediary (from RCPT_CD.INTR_NAMT)",
                        max_length=10,
                        verbose_name="intermediary title",
                    ),
                ),
                (
                    "intermediary_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the intermediary or business name (from RCPT_CD.INTR_NAML)",
                        max_length=200,
                        verbose_name="intermediary lastname",
                    ),
                ),
                (
                    "intermediary_firstname",
                    models.CharField(
                        help_text="First name of the intermediary (from RCPT_CD.INTR_NAMF)",
                        max_length=45,
                        verbose_name="intermediary firstname",
                    ),
                ),
                (
                    "intermediary_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the intermediary (from RCPT_CD.INTR_NAMS)",
                        max_length=10,
                        verbose_name="intermediary name suffix",
                    ),
                ),
                (
                    "intermediary_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the intermediary (from RCPT_CD.INTR_CITY)",
                        max_length=30,
                        verbose_name="intermediary city",
                    ),
                ),
                (
                    "intermediary_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the intermediary (from RCPT_CD.INTR_ST)",
                        max_length=2,
                        verbose_name="intermediary state",
                    ),
                ),
                (
                    "intermediary_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the intermediary (from RCPT_CD.INTR_ZIP4)",
                        max_length=10,
                        verbose_name="intermediary zip",
                    ),
                ),
                (
                    "intermediary_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the intermediary (from RCPT_CD.INTR_EMP)",
                        max_length=200,
                        verbose_name="intermediary employer",
                    ),
                ),
                (
                    "intermediary_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the intermediary (from RCPT_CD.INTR_OCC)",
                        max_length=60,
                        verbose_name="intermediary occupation",
                    ),
                ),
                (
                    "intermediary_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="(from S497_CD.INTR_SELF)",
                        verbose_name="intermediary is self employed",
                    ),
                ),
                (
                    "cumulative_ytd_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Cumulative year-to-date amount given by the contributor as of the given Form 460 filing (from RCPT_CD.CUM_YTD)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "cumulative_election_amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="For filers subject to contribution limits, cumulative amount given by the contributor during the election cycle as of the given Form 460 filing (from RCPT_CD.CUM_OTH)",
                        max_digits=14,
                        null=True,
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Amount of cash increase from the contributor in the period covered by the filing (from RCPT_CD.AMOUNT)",
                        max_digits=14,
                        verbose_name="amount",
                    ),
                ),
                (
                    "receipt_description",
                    models.CharField(
                        blank=True,
                        help_text="Description of the cash increase (from RCPT_CD.CTRIB_DSCR)",
                        max_length=90,
                        verbose_name="receipt description",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Form 460 that includes the miscellaneous cash increase",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="schedule_i_items",
                        to="calaccess_processed_filings.Form460FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 460 (Campaign Disclosure) Schedule I item version",
            },
        ),
        migrations.CreateModel(
            name="Form497Filing",
            fields=[
                (
                    "date_filed",
                    models.DateField(
                        db_index=True,
                        help_text="Date this report was filed, according to the filer (from CVR_CAMPAIGN_DISCLOSURE.RPT_DATE)",
                        verbose_name="date filed",
                    ),
                ),
                (
                    "filer_id",
                    models.IntegerField(
                        db_index=True,
                        help_text="Numeric filer identification number (from FILER_XREF.FILER_ID)",
                        verbose_name="filer id",
                    ),
                ),
                (
                    "filer_lastname",
                    models.CharField(
                        help_text="Last name of filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAML)",
                        max_length=200,
                        verbose_name="filer last name",
                    ),
                ),
                (
                    "filer_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAMF)",
                        max_length=45,
                        verbose_name="filer first name",
                    ),
                ),
                (
                    "election_date",
                    models.DateField(
                        db_index=True,
                        help_text="Date of the election in which the filer is participating (from CVR_CAMPAIGN_DISCLOSURE.ELECT_DATE)",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
                (
                    "filing_id",
                    models.IntegerField(
                        help_text="Unique identification number for the Schedule 497 filing (from CVR_CAMPAIGN_DISCLOSURE_CD.FILING_ID)",
                        primary_key=True,
                        serialize=False,
                        verbose_name="filing id",
                    ),
                ),
                (
                    "amendment_count",
                    models.IntegerField(
                        help_text="Number of amendments to the Schedule 497 filing (from maximum value of CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)",
                        verbose_name="Count amendments",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 497 (Late Contribution) filing",
            },
        ),
        migrations.CreateModel(
            name="Form497FilingVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_filed",
                    models.DateField(
                        db_index=True,
                        help_text="Date this report was filed, according to the filer (from CVR_CAMPAIGN_DISCLOSURE.RPT_DATE)",
                        verbose_name="date filed",
                    ),
                ),
                (
                    "filer_id",
                    models.IntegerField(
                        db_index=True,
                        help_text="Numeric filer identification number (from FILER_XREF.FILER_ID)",
                        verbose_name="filer id",
                    ),
                ),
                (
                    "filer_lastname",
                    models.CharField(
                        help_text="Last name of filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAML)",
                        max_length=200,
                        verbose_name="filer last name",
                    ),
                ),
                (
                    "filer_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAMF)",
                        max_length=45,
                        verbose_name="filer first name",
                    ),
                ),
                (
                    "election_date",
                    models.DateField(
                        db_index=True,
                        help_text="Date of the election in which the filer is participating (from CVR_CAMPAIGN_DISCLOSURE.ELECT_DATE)",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
                (
                    "amend_id",
                    models.IntegerField(
                        help_text="Identifies the version of the Schedule 497 filing, with 0 representing the initial filing (from CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)"
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        db_constraint=False,
                        help_text="Unique identification number for the Schedule 497 filing (from S497_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="versions",
                        to="calaccess_processed_filings.Form497Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 497 (Late Contribution) filing version",
            },
        ),
        migrations.CreateModel(
            name="Form497Part1Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        db_index=True,
                        help_text="Line number of the filing form where the transaction is itemized (from S497_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        db_index=True,
                        help_text="Date the late contribution was received (from S497_CD.CTRIB_DATE, unless NULL then from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days(from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "amount_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Dollar amount received (from S497_CD.AMOUNT)",
                        max_digits=16,
                        verbose_name="amount received",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        db_index=True,
                        help_text="Identifies a unique transaction across versions of the a given Schedule 497 filing (from S497_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the transaction (from S497_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("CTL", "Controlled committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from S497_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from S497_CD.ENTY_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor (from S497_CD.ENTY_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from S497_CD.ENTY_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from S497_CD.ENTY_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from S497_CD.ENTY_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from S497_CD.ENTY_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from S497_CD.ENTY_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from S497_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from S497_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from S497_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        help_text="Unique identification number for the Schedule 497 filing (from S497_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="contributions_received",
                        to="calaccess_processed_filings.Form497Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 497 (Late Contribution) Part 1 item",
            },
        ),
        migrations.CreateModel(
            name="Form497Part1ItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        db_index=True,
                        help_text="Line number of the filing form where the transaction is itemized (from S497_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        db_index=True,
                        help_text="Date the late contribution was received (from S497_CD.CTRIB_DATE, unless NULL then from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days(from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "amount_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Dollar amount received (from S497_CD.AMOUNT)",
                        max_digits=16,
                        verbose_name="amount received",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        db_index=True,
                        help_text="Identifies a unique transaction across versions of the a given Schedule 497 filing (from S497_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the transaction (from S497_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "contributor_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("CTL", "Controlled committee"),
                            ("IND", "Individual"),
                            ("OFF", "Officer"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the contributor (from S497_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="contributor code",
                    ),
                ),
                (
                    "contributor_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Contributor's filer identification number, if it is a committee (from RCPT_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="committee id",
                    ),
                ),
                (
                    "contributor_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the contributor (from S497_CD.ENTY_NAMT)",
                        max_length=10,
                        verbose_name="contributor title",
                    ),
                ),
                (
                    "contributor_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the contributor (from S497_CD.ENTY_NAML)",
                        max_length=200,
                        verbose_name="contributor lastname",
                    ),
                ),
                (
                    "contributor_firstname",
                    models.CharField(
                        help_text="First name of the contributor (from S497_CD.ENTY_NAMF)",
                        max_length=45,
                        verbose_name="contributor firstname",
                    ),
                ),
                (
                    "contributor_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the contributor (from S497_CD.ENTY_NAMS)",
                        max_length=10,
                        verbose_name="contributor name suffix",
                    ),
                ),
                (
                    "contributor_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the contributor (from S497_CD.ENTY_CITY)",
                        max_length=30,
                        verbose_name="contributor city",
                    ),
                ),
                (
                    "contributor_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the contributor (from S497_CD.ENTY_ST)",
                        max_length=2,
                        verbose_name="contributor state",
                    ),
                ),
                (
                    "contributor_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the contributor (from S497_CD.ENTY_ZIP4)",
                        max_length=10,
                        verbose_name="contributor zip",
                    ),
                ),
                (
                    "contributor_employer",
                    models.CharField(
                        blank=True,
                        help_text="Employer of the contributor (from S497_CD.CTRIB_EMP)",
                        max_length=200,
                        verbose_name="contributor employer",
                    ),
                ),
                (
                    "contributor_occupation",
                    models.CharField(
                        blank=True,
                        help_text="Occupation of the contributor (from S497_CD.CTRIB_OCC)",
                        max_length=60,
                        verbose_name="contributor occupation",
                    ),
                ),
                (
                    "contributor_is_self_employed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether or not the contributor is self-employed(from S497_CD.CTRIB_SELF)",
                        verbose_name="contributor is self employed",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Schedule 497 that includes the received contribution",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="contributions_received",
                        to="calaccess_processed_filings.Form497FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 497 (Late Contribution) Part 1 item version",
            },
        ),
        migrations.CreateModel(
            name="Form497Part2Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        db_index=True,
                        help_text="Line number of the filing form where the transaction is itemized (from S497_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        db_index=True,
                        help_text="Date the late contribution was received (from S497_CD.CTRIB_DATE, unless NULL then from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days(from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "amount_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Dollar amount received (from S497_CD.AMOUNT)",
                        max_digits=16,
                        verbose_name="amount received",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        db_index=True,
                        help_text="Identifies a unique transaction across versions of the a given Schedule 497 filing (from S497_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the transaction (from S497_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "recipient_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("CTL", "Controlled committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the recipient (from S497_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="recipient code",
                    ),
                ),
                (
                    "recipient_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Filer identification number identifying the recipient if it is a committee (from S497_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="recipient committee id",
                    ),
                ),
                (
                    "recipient_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient (from S497_CD.ENTY_NAMT)",
                        max_length=10,
                        verbose_name="recipient title",
                    ),
                ),
                (
                    "recipient_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient (from S497_CD.ENTY_NAML)",
                        max_length=200,
                        verbose_name="recipient lastname",
                    ),
                ),
                (
                    "recipient_firstname",
                    models.CharField(
                        help_text="First name of the recipient (from S497_CD.ENTY_NAMF)",
                        max_length=45,
                        verbose_name="recipient firstname",
                    ),
                ),
                (
                    "recipient_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient (from S497_CD.ENTY_NAMS)",
                        max_length=10,
                        verbose_name="recipient name suffix",
                    ),
                ),
                (
                    "recipient_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient (from S497_CD.ENTY_CITY)",
                        max_length=30,
                        verbose_name="recipient city",
                    ),
                ),
                (
                    "recipient_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient (from S497_CD.ENTY_ST)",
                        max_length=2,
                        verbose_name="recipient state",
                    ),
                ),
                (
                    "recipient_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient (from S497_CD.ENTY_ZIP4)",
                        max_length=10,
                        verbose_name="recipient zip",
                    ),
                ),
                (
                    "candidate_id",
                    models.CharField(
                        blank=True,
                        help_text="Identifies the candidate to whom the contribution is connected (from S497_CD.CAND_ID). This can be translated to the filer_id by joining to FILER_XREF_CD.",
                        max_length=9,
                        verbose_name="candidate id",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the candidate to whom the contribution is connected (from S497_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the candidate to whom the contribution is connected (S497_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate last name",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the candidate to whom the contribution is connected (S497_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate first name",
                    ),
                ),
                (
                    "candidate_namesuffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the candidate to whom the contribution is connected (S497_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_office_code",
                    models.CharField(
                        blank=True,
                        help_text="Code describing the office sought sought by the candidate (from S497_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="candidate office code",
                    ),
                ),
                (
                    "candidate_office_description",
                    models.CharField(
                        blank=True,
                        help_text="Full description of the office sought by the candidate (from S497_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="candidate office description",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        help_text="Code describing the jurisdiction of office sought by the candidate (from S497_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jursidiction code",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="Full description of the jurisdiction of the office sought by the candidate (from S497_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiction description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="District of the office sought by the candidate (from S497_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the ballot measure supported or opposed by the recipient (from S497_CD.BAL_NAME)",
                        max_length=200,
                        verbose_name="Ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_number",
                    models.CharField(
                        blank=True,
                        help_text="Ballot measure number (from S497_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="Ballot measure number",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="Jurisdiction of the ballot measure supported or opposed by the recipient (from S497_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "support_opposition_code",
                    models.CharField(
                        blank=True,
                        choices=[("O", "Opposition"), ("S", "Support")],
                        help_text="Code describing whether the contribuitor supports or opposesthe candidate or ballot measure (from S497_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support opposition code",
                    ),
                ),
                (
                    "election_date",
                    models.DateField(
                        help_text="Date of the election (from S497_CD.ELEC_DATE)",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        db_constraint=False,
                        help_text="Unique identification number for the Schedule 497 filing (from S497_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="contributions_made",
                        to="calaccess_processed_filings.Form497Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 497 (Late Contribution) Part 2 item",
            },
        ),
        migrations.CreateModel(
            name="Form497Part2ItemVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "line_item",
                    models.IntegerField(
                        db_index=True,
                        help_text="Line number of the filing form where the transaction is itemized (from S497_CD.LINE_ITEM)",
                        verbose_name="line item",
                    ),
                ),
                (
                    "date_received",
                    models.DateField(
                        db_index=True,
                        help_text="Date the late contribution was received (from S497_CD.CTRIB_DATE, unless NULL then from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received",
                    ),
                ),
                (
                    "date_received_thru",
                    models.DateField(
                        help_text="End date for late contributions received over a range of days(from S497_CD.DATE_THRU)",
                        null=True,
                        verbose_name="date received thru",
                    ),
                ),
                (
                    "amount_received",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Dollar amount received (from S497_CD.AMOUNT)",
                        max_digits=16,
                        verbose_name="amount received",
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        db_index=True,
                        help_text="Identifies a unique transaction across versions of the a given Schedule 497 filing (from S497_CD.TRAN_ID)",
                        max_length=20,
                        verbose_name="transaction id",
                    ),
                ),
                (
                    "memo_reference_number",
                    models.CharField(
                        blank=True,
                        help_text="Reference number for the memo attached to the transaction (from S497_CD.MEMO_REFNO)",
                        max_length=20,
                        verbose_name="memo reference number",
                    ),
                ),
                (
                    "recipient_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("BNM", "Ballot measure name/title"),
                            ("CAO", "Candidate/officeholder"),
                            ("COM", "Committee"),
                            ("CTL", "Controlled committee"),
                            ("IND", "Individual"),
                            ("OTH", "Other"),
                            ("PTY", "Political Party"),
                            ("RCP", "Recipient committee"),
                            ("SCC", "Small Contributor Committee"),
                        ],
                        help_text="Code describing the recipient (from S497_CD.ENTITY_CD)",
                        max_length=3,
                        verbose_name="recipient code",
                    ),
                ),
                (
                    "recipient_committee_id",
                    models.CharField(
                        blank=True,
                        help_text="Filer identification number identifying the recipient if it is a committee (from S497_CD.CMTE_ID)",
                        max_length=9,
                        verbose_name="recipient committee id",
                    ),
                ),
                (
                    "recipient_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the recipient (from S497_CD.ENTY_NAMT)",
                        max_length=10,
                        verbose_name="recipient title",
                    ),
                ),
                (
                    "recipient_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the recipient (from S497_CD.ENTY_NAML)",
                        max_length=200,
                        verbose_name="recipient lastname",
                    ),
                ),
                (
                    "recipient_firstname",
                    models.CharField(
                        help_text="First name of the recipient (from S497_CD.ENTY_NAMF)",
                        max_length=45,
                        verbose_name="recipient firstname",
                    ),
                ),
                (
                    "recipient_name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the recipient (from S497_CD.ENTY_NAMS)",
                        max_length=10,
                        verbose_name="recipient name suffix",
                    ),
                ),
                (
                    "recipient_city",
                    models.CharField(
                        blank=True,
                        help_text="City of the recipient (from S497_CD.ENTY_CITY)",
                        max_length=30,
                        verbose_name="recipient city",
                    ),
                ),
                (
                    "recipient_state",
                    models.CharField(
                        blank=True,
                        help_text="State of the recipient (from S497_CD.ENTY_ST)",
                        max_length=2,
                        verbose_name="recipient state",
                    ),
                ),
                (
                    "recipient_zip",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the recipient (from S497_CD.ENTY_ZIP4)",
                        max_length=10,
                        verbose_name="recipient zip",
                    ),
                ),
                (
                    "candidate_id",
                    models.CharField(
                        blank=True,
                        help_text="Identifies the candidate to whom the contribution is connected (from S497_CD.CAND_ID). This can be translated to the filer_id by joining to FILER_XREF_CD.",
                        max_length=9,
                        verbose_name="candidate id",
                    ),
                ),
                (
                    "candidate_title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the candidate to whom the contribution is connected (from S497_CD.CAND_NAMT)",
                        max_length=10,
                        verbose_name="candidate title",
                    ),
                ),
                (
                    "candidate_lastname",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the candidate to whom the contribution is connected (S497_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate last name",
                    ),
                ),
                (
                    "candidate_firstname",
                    models.CharField(
                        blank=True,
                        help_text="First name of the candidate to whom the contribution is connected (S497_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate first name",
                    ),
                ),
                (
                    "candidate_namesuffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the candidate to whom the contribution is connected (S497_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "candidate_office_code",
                    models.CharField(
                        blank=True,
                        help_text="Code describing the office sought sought by the candidate (from S497_CD.OFFICE_CD)",
                        max_length=3,
                        verbose_name="candidate office code",
                    ),
                ),
                (
                    "candidate_office_description",
                    models.CharField(
                        blank=True,
                        help_text="Full description of the office sought by the candidate (from S497_CD.OFFIC_DSCR)",
                        max_length=40,
                        verbose_name="candidate office description",
                    ),
                ),
                (
                    "candidate_jurisdiction_code",
                    models.CharField(
                        blank=True,
                        help_text="Code describing the jurisdiction of office sought by the candidate (from S497_CD.JURIS_CD)",
                        max_length=3,
                        verbose_name="candidate jursidiction code",
                    ),
                ),
                (
                    "candidate_jurisdiction_description",
                    models.CharField(
                        blank=True,
                        help_text="Full description of the jurisdiction of the office sought by the candidate (from S497_CD.JURIS_DSCR)",
                        max_length=40,
                        verbose_name="candidate jurisdiction description",
                    ),
                ),
                (
                    "candidate_district",
                    models.CharField(
                        blank=True,
                        help_text="District of the office sought by the candidate (from S497_CD.DIST_NO)",
                        max_length=3,
                        verbose_name="candidate district",
                    ),
                ),
                (
                    "ballot_measure_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the ballot measure supported or opposed by the recipient (from S497_CD.BAL_NAME)",
                        max_length=200,
                        verbose_name="Ballot measure name",
                    ),
                ),
                (
                    "ballot_measure_number",
                    models.CharField(
                        blank=True,
                        help_text="Ballot measure number (from S497_CD.BAL_NUM)",
                        max_length=7,
                        verbose_name="Ballot measure number",
                    ),
                ),
                (
                    "ballot_measure_jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text="Jurisdiction of the ballot measure supported or opposed by the recipient (from S497_CD.BAL_JURIS)",
                        max_length=40,
                        verbose_name="ballot measure jurisdiction",
                    ),
                ),
                (
                    "support_opposition_code",
                    models.CharField(
                        blank=True,
                        choices=[("O", "Opposition"), ("S", "Support")],
                        help_text="Code describing whether the contribuitor supports or opposesthe candidate or ballot measure (from S497_CD.SUP_OPP_CD)",
                        max_length=1,
                        verbose_name="support opposition code",
                    ),
                ),
                (
                    "election_date",
                    models.DateField(
                        help_text="Date of the election (from S497_CD.ELEC_DATE)",
                        null=True,
                        verbose_name="election date",
                    ),
                ),
                (
                    "filing_version",
                    models.ForeignKey(
                        help_text="Foreign key referring to the version of the Schedule 497 that includes the given contribution",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="contributions_made",
                        to="calaccess_processed_filings.Form497FilingVersion",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 497 (Late Contribution) Part 2 item version",
            },
        ),
        migrations.CreateModel(
            name="Form501Filing",
            fields=[
                (
                    "date_filed",
                    models.DateField(
                        db_index=True,
                        help_text="Date when the Form 501 filing was filed (from F501_502_CD.RPT_DATE)",
                        null=True,
                        verbose_name="from date",
                    ),
                ),
                (
                    "statement_type",
                    models.CharField(
                        help_text='Describes the type of statement, e.g. "ORIGINAL", "AMENDMENT" (from LOOKUP_CODES.CODE_DESC)',
                        max_length=62,
                        verbose_name="statement type",
                    ),
                ),
                (
                    "filer_id",
                    models.CharField(
                        help_text="Filer's unique identifier (from F501_502_CD.FILER_ID)",
                        max_length=9,
                        verbose_name="filer identifier",
                    ),
                ),
                (
                    "committee_id",
                    models.CharField(
                        help_text="Candidate's committee's unique filer idenitifier (from F501_502_CD.COMMITTEE_ID)",
                        max_length=9,
                        verbose_name="committee identifier",
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the candidate (from F501_502_CD.CAND_NAMT)",
                        max_length=100,
                        verbose_name="candidate name title",
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the candidate (from F501_502_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate last name",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True,
                        help_text="First name of the candidate (from F501_502_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate first name",
                    ),
                ),
                (
                    "middle_name",
                    models.CharField(
                        blank=True,
                        help_text="Middle name of the candidate (from F501_502_CD.CAND_NAMM)",
                        max_length=20,
                        verbose_name="candidate middle name",
                    ),
                ),
                (
                    "name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the candidate (from F501_502_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "name_moniker",
                    models.CharField(
                        blank=True,
                        help_text="Moniker (aka, nickname) of the candidate (from F501_502_CD.MONIKER)",
                        max_length=20,
                        verbose_name="candidate name moniker",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        blank=True,
                        help_text="Phone number of the candidate (from F501_502_CD.CAND_PHON)",
                        max_length=20,
                        verbose_name="candidate phone number",
                    ),
                ),
                (
                    "fax",
                    models.CharField(
                        blank=True,
                        help_text="Phone number of the candidate (from F501_502_CD.CAND_FAX)",
                        max_length=20,
                        verbose_name="fax number",
                    ),
                ),
                (
                    "email",
                    models.CharField(
                        blank=True,
                        help_text="Email address of the candidate (from F501_502_CD.CAND_EMAIL)",
                        max_length=200,
                        verbose_name="email address",
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        blank=True,
                        help_text="City of the candidate (from F501_502_CD.CAND_CITY)",
                        max_length=200,
                        verbose_name="candidate city",
                    ),
                ),
                (
                    "state",
                    models.CharField(
                        blank=True,
                        help_text="State of the candidate (from F501_502_CD.CAND_ST)",
                        max_length=200,
                        verbose_name="candidate state",
                    ),
                ),
                (
                    "zip_code",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the candidate (from F501_502_CD.CAND_ZIP4)",
                        max_length=10,
                        verbose_name="zip code",
                    ),
                ),
                (
                    "office",
                    models.CharField(
                        blank=True,
                        help_text="Position title of the office sought by the candidate (from LOOKUP_CODES_CD.CODE_DESC, unless NULL or 0, then F501_502_CD.OFFICE_DSCR)",
                        max_length=80,
                        verbose_name="office sought",
                    ),
                ),
                (
                    "agency",
                    models.CharField(
                        blank=True,
                        help_text="Name of the agency with the office sought (from F501_502_CD.AGENCY_NAM)",
                        max_length=200,
                        verbose_name="agency name",
                    ),
                ),
                (
                    "district",
                    models.IntegerField(
                        help_text="District of office sought, if applicable (from LOOKUP_CODES_CD.CODE_DESC, unless NULL or 0, then F501_502_CD.DIST_NO)",
                        null=True,
                        verbose_name="district",
                    ),
                ),
                (
                    "party",
                    models.CharField(
                        blank=True,
                        help_text="Political party of the candidate (from LOOKUP_CODES_CD.CODE_DESC, unless NULL or 0, then F501_502_CD.PARTY)",
                        max_length=30,
                        verbose_name="political party",
                    ),
                ),
                (
                    "jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text='Jurisdiction of the office sought, e.g., "LOCAL", "STATE" (from LOOKUP_CODES_CD.CODE_DESC)',
                        max_length=30,
                        verbose_name="jurisdiction",
                    ),
                ),
                (
                    "election_type",
                    models.CharField(
                        help_text='Type of election in which the candidate is declaring intention to run, e.g. "PRIMARY", "GENERAL" (from LOOKUP_CODES_CD.CODE_DESC)',
                        max_length=16,
                        null=True,
                        verbose_name="election type",
                    ),
                ),
                (
                    "election_year",
                    models.IntegerField(
                        help_text="Year in which the election is held (from F501_502_CD.YR_OF_ELEC)",
                        null=True,
                        verbose_name="election year",
                    ),
                ),
                (
                    "accepted_limit",
                    models.NullBooleanField(
                        help_text='Indicates if either the "I accept the voluntary expenditure ceiling" or "I do not accept the voluntary expenditure" box is checked (from F501_502_CD.ACCEPT_LIMIT_YN)'
                    ),
                ),
                (
                    "limit_not_exceeded_election_date",
                    models.DateField(
                        help_text="Date of the primary or special election in which the candidate did not accept the voluntary expenditure ceiling but also did exceed the ceiling. Candidates may amend their Form 501 to accept the limits for the general election or special election runoff and receive all the benefits of accepting the ceiling (from F501_502_CD.DID_EXCEED_DT)",
                        null=True,
                        verbose_name="limit not exceeded election date",
                    ),
                ),
                (
                    "personal_funds_contrib_date",
                    models.DateField(
                        help_text="Date on which the candidate contributed personal funds in excess of the voluntary expenditure ceiling for the (from F501_502_CD.CNTRB_PRSNL_FNDS_DT)",
                        null=True,
                        verbose_name="personal funds contribution date",
                    ),
                ),
                (
                    "executed_on",
                    models.DateField(
                        help_text="Date on which the candidate intention statement was signed (from F501_502_CD.EXECUTE_DT)",
                        null=True,
                        verbose_name="executed on date",
                    ),
                ),
                (
                    "filing_id",
                    models.IntegerField(
                        help_text="Unique identification number for the Form 501 filing (from F501_502_CD.FILING_ID)",
                        primary_key=True,
                        serialize=False,
                        verbose_name="filing id",
                    ),
                ),
                (
                    "amendment_count",
                    models.IntegerField(
                        db_index=True,
                        help_text="Number of amendments to the Form 501 filing (from maximum value of F501_502_CD.AMEND_ID)",
                        verbose_name="Count amendments",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 501 (Candidate Intention) filing",
            },
        ),
        migrations.CreateModel(
            name="Form501FilingVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_filed",
                    models.DateField(
                        db_index=True,
                        help_text="Date when the Form 501 filing was filed (from F501_502_CD.RPT_DATE)",
                        null=True,
                        verbose_name="from date",
                    ),
                ),
                (
                    "statement_type",
                    models.CharField(
                        help_text='Describes the type of statement, e.g. "ORIGINAL", "AMENDMENT" (from LOOKUP_CODES.CODE_DESC)',
                        max_length=62,
                        verbose_name="statement type",
                    ),
                ),
                (
                    "filer_id",
                    models.CharField(
                        help_text="Filer's unique identifier (from F501_502_CD.FILER_ID)",
                        max_length=9,
                        verbose_name="filer identifier",
                    ),
                ),
                (
                    "committee_id",
                    models.CharField(
                        help_text="Candidate's committee's unique filer idenitifier (from F501_502_CD.COMMITTEE_ID)",
                        max_length=9,
                        verbose_name="committee identifier",
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="Name title of the candidate (from F501_502_CD.CAND_NAMT)",
                        max_length=100,
                        verbose_name="candidate name title",
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True,
                        help_text="Last name of the candidate (from F501_502_CD.CAND_NAML)",
                        max_length=200,
                        verbose_name="candidate last name",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True,
                        help_text="First name of the candidate (from F501_502_CD.CAND_NAMF)",
                        max_length=45,
                        verbose_name="candidate first name",
                    ),
                ),
                (
                    "middle_name",
                    models.CharField(
                        blank=True,
                        help_text="Middle name of the candidate (from F501_502_CD.CAND_NAMM)",
                        max_length=20,
                        verbose_name="candidate middle name",
                    ),
                ),
                (
                    "name_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Name suffix of the candidate (from F501_502_CD.CAND_NAMS)",
                        max_length=10,
                        verbose_name="candidate name suffix",
                    ),
                ),
                (
                    "name_moniker",
                    models.CharField(
                        blank=True,
                        help_text="Moniker (aka, nickname) of the candidate (from F501_502_CD.MONIKER)",
                        max_length=20,
                        verbose_name="candidate name moniker",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        blank=True,
                        help_text="Phone number of the candidate (from F501_502_CD.CAND_PHON)",
                        max_length=20,
                        verbose_name="candidate phone number",
                    ),
                ),
                (
                    "fax",
                    models.CharField(
                        blank=True,
                        help_text="Phone number of the candidate (from F501_502_CD.CAND_FAX)",
                        max_length=20,
                        verbose_name="fax number",
                    ),
                ),
                (
                    "email",
                    models.CharField(
                        blank=True,
                        help_text="Email address of the candidate (from F501_502_CD.CAND_EMAIL)",
                        max_length=200,
                        verbose_name="email address",
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        blank=True,
                        help_text="City of the candidate (from F501_502_CD.CAND_CITY)",
                        max_length=200,
                        verbose_name="candidate city",
                    ),
                ),
                (
                    "state",
                    models.CharField(
                        blank=True,
                        help_text="State of the candidate (from F501_502_CD.CAND_ST)",
                        max_length=200,
                        verbose_name="candidate state",
                    ),
                ),
                (
                    "zip_code",
                    models.CharField(
                        blank=True,
                        help_text="Zip code (usually zip5, sometimes zip9) of the candidate (from F501_502_CD.CAND_ZIP4)",
                        max_length=10,
                        verbose_name="zip code",
                    ),
                ),
                (
                    "office",
                    models.CharField(
                        blank=True,
                        help_text="Position title of the office sought by the candidate (from LOOKUP_CODES_CD.CODE_DESC, unless NULL or 0, then F501_502_CD.OFFICE_DSCR)",
                        max_length=80,
                        verbose_name="office sought",
                    ),
                ),
                (
                    "agency",
                    models.CharField(
                        blank=True,
                        help_text="Name of the agency with the office sought (from F501_502_CD.AGENCY_NAM)",
                        max_length=200,
                        verbose_name="agency name",
                    ),
                ),
                (
                    "district",
                    models.IntegerField(
                        help_text="District of office sought, if applicable (from LOOKUP_CODES_CD.CODE_DESC, unless NULL or 0, then F501_502_CD.DIST_NO)",
                        null=True,
                        verbose_name="district",
                    ),
                ),
                (
                    "party",
                    models.CharField(
                        blank=True,
                        help_text="Political party of the candidate (from LOOKUP_CODES_CD.CODE_DESC, unless NULL or 0, then F501_502_CD.PARTY)",
                        max_length=30,
                        verbose_name="political party",
                    ),
                ),
                (
                    "jurisdiction",
                    models.CharField(
                        blank=True,
                        help_text='Jurisdiction of the office sought, e.g., "LOCAL", "STATE" (from LOOKUP_CODES_CD.CODE_DESC)',
                        max_length=30,
                        verbose_name="jurisdiction",
                    ),
                ),
                (
                    "election_type",
                    models.CharField(
                        help_text='Type of election in which the candidate is declaring intention to run, e.g. "PRIMARY", "GENERAL" (from LOOKUP_CODES_CD.CODE_DESC)',
                        max_length=16,
                        null=True,
                        verbose_name="election type",
                    ),
                ),
                (
                    "election_year",
                    models.IntegerField(
                        help_text="Year in which the election is held (from F501_502_CD.YR_OF_ELEC)",
                        null=True,
                        verbose_name="election year",
                    ),
                ),
                (
                    "accepted_limit",
                    models.NullBooleanField(
                        help_text='Indicates if either the "I accept the voluntary expenditure ceiling" or "I do not accept the voluntary expenditure" box is checked (from F501_502_CD.ACCEPT_LIMIT_YN)'
                    ),
                ),
                (
                    "limit_not_exceeded_election_date",
                    models.DateField(
                        help_text="Date of the primary or special election in which the candidate did not accept the voluntary expenditure ceiling but also did exceed the ceiling. Candidates may amend their Form 501 to accept the limits for the general election or special election runoff and receive all the benefits of accepting the ceiling (from F501_502_CD.DID_EXCEED_DT)",
                        null=True,
                        verbose_name="limit not exceeded election date",
                    ),
                ),
                (
                    "personal_funds_contrib_date",
                    models.DateField(
                        help_text="Date on which the candidate contributed personal funds in excess of the voluntary expenditure ceiling for the (from F501_502_CD.CNTRB_PRSNL_FNDS_DT)",
                        null=True,
                        verbose_name="personal funds contribution date",
                    ),
                ),
                (
                    "executed_on",
                    models.DateField(
                        help_text="Date on which the candidate intention statement was signed (from F501_502_CD.EXECUTE_DT)",
                        null=True,
                        verbose_name="executed on date",
                    ),
                ),
                (
                    "amend_id",
                    models.IntegerField(
                        help_text="Identifies the version of the Form 501 filing, with 0 representing the initial filing (from F501_502_CD.FILING_ID)",
                        verbose_name="amendment id",
                    ),
                ),
                (
                    "filing",
                    models.ForeignKey(
                        db_constraint=False,
                        help_text="Unique identification number for the Form 501 filing (from F501_502_CD.FILING_ID)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="versions",
                        to="calaccess_processed_filings.Form501Filing",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form 501 (Candidate Intention) filing version",
            },
        ),
        migrations.AlterIndexTogether(
            name="form501filing",
            index_together=set([("filing_id", "amendment_count")]),
        ),
        migrations.AlterIndexTogether(
            name="form497filing",
            index_together=set([("filing_id", "amendment_count")]),
        ),
        migrations.AlterIndexTogether(
            name="form460filing",
            index_together=set([("filing_id", "amendment_count")]),
        ),
        migrations.AlterUniqueTogether(
            name="form501filingversion",
            unique_together=set([("filing", "amend_id")]),
        ),
        migrations.AlterIndexTogether(
            name="form501filingversion",
            index_together=set([("filing", "amend_id")]),
        ),
        migrations.AlterUniqueTogether(
            name="form497part2itemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form497part2itemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form497part2item",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form497part1itemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form497part1itemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form497part1item",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form497filingversion",
            unique_together=set([("filing", "amend_id")]),
        ),
        migrations.AlterIndexTogether(
            name="form497filingversion",
            index_together=set([("filing", "amend_id")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleiitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleiitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleiitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulehitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460schedulehitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulehitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleh2itemversionold",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleh2itemversionold",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleh2itemold",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulegitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460schedulegitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulegitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulefitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460schedulefitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulefitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleesubitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleesubitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleesubitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleeitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleeitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleeitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleditemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleditemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleditem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulecitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460schedulecitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460schedulecitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleb2itemversionold",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleb2itemversionold",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleb2itemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleb2itemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleb2itemold",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleb2item",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleb1itemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleb1itemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleb1item",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleaitemversion",
            unique_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterIndexTogether(
            name="form460scheduleaitemversion",
            index_together=set([("filing_version", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460scheduleaitem",
            unique_together=set([("filing", "line_item")]),
        ),
        migrations.AlterUniqueTogether(
            name="form460filingversion",
            unique_together=set([("filing", "amend_id")]),
        ),
        migrations.AlterIndexTogether(
            name="form460filingversion",
            index_together=set([("filing", "amend_id")]),
        ),
    ]
