"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyGeneratedOutput = void 0;
const path = require("path");
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class SmithyGeneratedOutput extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    synthesize() {
        super.synthesize();
        const { smithyBuildConfigPath, modelPath, outputPath, gradleProjectPath, gradleWrapperPath, } = this.options;
        // Run smithy generation
        util_1.exec(`./gradlew -p ${gradleProjectPath} generate -Pconfig=${smithyBuildConfigPath} -Pdiscover=${modelPath} -Poutput=${outputPath}`, {
            cwd: gradleWrapperPath ??
                path.resolve(__dirname, "..", "..", "..", "..", "scripts", "smithy"),
        });
    }
}
exports.SmithyGeneratedOutput = SmithyGeneratedOutput;
//# sourceMappingURL=data:application/json;base64,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