"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_java_project_1 = require("./open-api-gateway-java-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Java Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-java
 */
class SmithyApiGatewayJavaProject extends open_api_gateway_java_project_1.OpenApiGatewayJavaProject {
    constructor(options) {
        super(options);
        /**
         * The directory in which the smithy model files reside
         */
        this.modelDir = "model";
    }
    preConstruct(options) {
        const { modelDir, generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        // @ts-ignore this method is called by the constructor
        this.modelDir = modelDir;
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayJavaProject = SmithyApiGatewayJavaProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayJavaProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject", version: "0.12.3" };
//# sourceMappingURL=data:application/json;base64,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