# Do not edit by hand; this file is generated by ./scripts/generate_tags.py
# fmt: off

"""
Functions for creating HTML tags.
"""

from __future__ import annotations

from typing import Optional

from ._core import Tag, TagAttrArg, TagChildArg

__all__ = (
    "p",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "a",
    "br",
    "div",
    "span",
    "pre",
    "code",
    "img",
    "strong",
    "em",
    "hr",
)


def html(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <html> tag.

    The <html> HTML element represents the root (top-level element) of an HTML document, so it is also referred to as the root element. All other elements must be descendants of this element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("html", *args, children=children, **kwargs)


def base(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <base> tag.

    The <base> HTML element specifies the base URL to use for all relative URLs in a document. There can be only one <base> element in a document. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/base

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("base", *args, children=children, **kwargs)


def head(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <head> tag.

    The <head> HTML element contains machine-readable information (metadata) about the document, like its title, scripts, and style sheets. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("head", *args, children=children, **kwargs)


def link(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <link> tag.

    The <link> HTML element specifies relationships between the current document and an external resource.
    This element is most commonly used to link to CSS, but is also used to establish site icons (both "favicon" style icons and icons for the home screen and apps on mobile devices) among other things. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("link", *args, children=children, **kwargs)


def meta(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <meta> tag.

    The <meta> HTML element represents Metadata that cannot be represented by other HTML meta-related elements, like base, link, script, style or title. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("meta", *args, children=children, **kwargs)


def style(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <style> tag.

    The <style> HTML element contains style information for a document, or part of a document. It contains CSS, which is applied to the contents of the document containing the <style> element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/style

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("style", *args, children=children, **kwargs)


def title(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <title> tag.

    The <title> HTML element defines the document's title that is shown in a Browser's title bar or a page's tab. It only contains text; tags within the element are ignored. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("title", *args, children=children, **kwargs)


def body(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <body> tag.

    The <body> HTML element represents the content of an HTML document. There can be only one <body> element in a document. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("body", *args, children=children, **kwargs)


def address(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <address> tag.

    The <address> HTML element indicates that the enclosed HTML provides contact information for a person or people, or for an organization. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/address

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("address", *args, children=children, **kwargs)


def article(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <article> tag.

    The <article> HTML element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). Examples include: a forum post, a magazine or newspaper article, or a blog entry, a product card, a user-submitted comment, an interactive widget or gadget, or any other independent item of content. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("article", *args, children=children, **kwargs)


def aside(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <aside> tag.

    The <aside> HTML element represents a portion of a document whose content is only indirectly related to the document's main content. Asides are frequently presented as sidebars or call-out boxes. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/aside

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("aside", *args, children=children, **kwargs)


def footer(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <footer> tag.

    The <footer> HTML element represents a footer for its nearest sectioning content or sectioning root element. A <footer> typically contains information about the author of the section, copyright data or links to related documents. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/footer

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("footer", *args, children=children, **kwargs)


def header(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <header> tag.

    The <header> HTML element represents introductory content, typically a group of introductory or navigational aids. It may contain some heading elements but also a logo, a search form, an author name, and other elements. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/header

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("header", *args, children=children, **kwargs)


def h1(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <h1> tag.

    The <h1> to <h6> HTML elements represent six levels of section headings. <h1> is the highest section level and <h6> is the lowest. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h1

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("h1", *args, children=children, **kwargs)


def h2(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <h2> tag.

    The <h1> to <h6> HTML elements represent six levels of section headings. <h1> is the highest section level and <h6> is the lowest. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h2

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("h2", *args, children=children, **kwargs)


def h3(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <h3> tag.

    The <h1> to <h6> HTML elements represent six levels of section headings. <h1> is the highest section level and <h6> is the lowest. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h3

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("h3", *args, children=children, **kwargs)


def h4(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <h4> tag.

    The <h1> to <h6> HTML elements represent six levels of section headings. <h1> is the highest section level and <h6> is the lowest. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h4

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("h4", *args, children=children, **kwargs)


def h5(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <h5> tag.

    The <h1> to <h6> HTML elements represent six levels of section headings. <h1> is the highest section level and <h6> is the lowest. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h5

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("h5", *args, children=children, **kwargs)


def h6(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <h6> tag.

    The <h1> to <h6> HTML elements represent six levels of section headings. <h1> is the highest section level and <h6> is the lowest. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h6

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("h6", *args, children=children, **kwargs)


def main(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <main> tag.

    The <main> HTML element represents the dominant content of the body of a document. The main content area consists of content that is directly related to or expands upon the central topic of a document, or the central functionality of an application. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/main

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("main", *args, children=children, **kwargs)


def nav(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <nav> tag.

    The <nav> HTML element represents a section of a page whose purpose is to provide navigation links, either within the current document or to other documents. Common examples of navigation sections are menus, tables of contents, and indexes. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nav

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("nav", *args, children=children, **kwargs)


def section(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <section> tag.

    The <section> HTML element represents a generic standalone section of a document, which doesn't have a more specific semantic element to represent it. Sections should always have a heading, with very few exceptions. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/section

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("section", *args, children=children, **kwargs)


def blockquote(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <blockquote> tag.

    The <blockquote> HTML element indicates that the enclosed text is an extended quotation. Usually, this is rendered visually by indentation (see Notes for how to change it). A URL for the source of the quotation may be given using the cite attribute, while a text representation of the source can be given using the cite element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blockquote

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("blockquote", *args, children=children, **kwargs)


def dd(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <dd> tag.

    The <dd> HTML element provides the description, definition, or value for the preceding term (dt) in a description list (dl). Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dd

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("dd", *args, children=children, **kwargs)


def div(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <div> tag.

    The <div> HTML element is the generic container for flow content. It has no effect on the content or layout until styled in some way using CSS (e.g. styling is directly applied to it, or some kind of layout model like Flexbox is applied to its parent element). Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/div

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("div", *args, children=children, **kwargs)


def dl(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <dl> tag.

    The <dl> HTML element represents a description list. The element encloses a list of groups of terms (specified using the dt element) and descriptions (provided by dd elements). Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs). Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dl

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("dl", *args, children=children, **kwargs)


def dt(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <dt> tag.

    The <dt> HTML element specifies a term in a description or definition list, and as such must be used inside a dl element. It is usually followed by a dd element; however, multiple <dt> elements in a row indicate several terms that are all defined by the immediate next dd element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dt

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("dt", *args, children=children, **kwargs)


def figcaption(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <figcaption> tag.

    The <figcaption> HTML element represents a caption or legend describing the rest of the contents of its parent figure element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figcaption

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("figcaption", *args, children=children, **kwargs)


def figure(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <figure> tag.

    The <figure> HTML element represents self-contained content, potentially with an optional caption, which is specified using the figcaption element. The figure, its caption, and its contents are referenced as a single unit. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figure

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("figure", *args, children=children, **kwargs)


def hr(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <hr> tag.

    The <hr> HTML element represents a thematic break between paragraph-level elements: for example, a change of scene in a story, or a shift of topic within a section. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/hr

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("hr", *args, children=children, **kwargs)


def li(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <li> tag.

    The <li> HTML element is used to represent an item in a list. It must be contained in a parent element: an ordered list (ol), an unordered list (ul), or a menu (menu). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("li", *args, children=children, **kwargs)


def menu(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <menu> tag.

    The <menu> HTML element is a semantic alternative to ul. It represents an unordered list of items (represented by li elements), each of these represent a link or other command that the user can activate. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menu

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("menu", *args, children=children, **kwargs)


def ol(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <ol> tag.

    The <ol> HTML element represents an ordered list of items — typically rendered as a numbered list. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("ol", *args, children=children, **kwargs)


def p(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <p> tag.

    The <p> HTML element represents a paragraph. Paragraphs are usually represented in visual media as blocks of text separated from adjacent blocks by blank lines and/or first-line indentation, but HTML paragraphs can be any structural grouping of related content, such as images or form fields. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/p

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("p", *args, children=children, **kwargs)


def pre(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <pre> tag.

    The <pre> HTML element represents preformatted text which is to be presented exactly as written in the HTML file. The text is typically rendered using a non-proportional, or "monospaced, font. Whitespace inside this element is displayed as written. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/pre

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("pre", *args, children=children, **kwargs)


def ul(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <ul> tag.

    The <ul> HTML element represents an unordered list of items, typically rendered as a bulleted list. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("ul", *args, children=children, **kwargs)


def a(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <a> tag.

    The <a> HTML element (or anchor element), with its href attribute, creates a hyperlink to web pages, files, email addresses, locations in the same page, or anything else a URL can address. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("a", *args, children=children, **kwargs)


def abbr(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <abbr> tag.

    The <abbr> HTML element represents an abbreviation or acronym; the optional title attribute can provide an expansion or description for the abbreviation. If present, title must contain this full description and nothing else. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/abbr

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("abbr", *args, children=children, **kwargs)


def b(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <b> tag.

    The <b> HTML element is used to draw the reader's attention to the element's contents, which are not otherwise granted special importance. This was formerly known as the Boldface element, and most browsers still draw the text in boldface. However, you should not use <b> for styling text; instead, you should use the CSS font-weight property to create boldface text, or the strong element to indicate that text is of special importance. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/b

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("b", *args, children=children, **kwargs)


def bdi(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <bdi> tag.

    The <bdi> HTML element tells the browser's bidirectional algorithm to treat the text it contains in isolation from its surrounding text. It's particularly useful when a website dynamically inserts some text and doesn't know the directionality of the text being inserted. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bdi

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("bdi", *args, children=children, **kwargs)


def bdo(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <bdo> tag.

    The <bdo> HTML element overrides the current directionality of text, so that the text within is rendered in a different direction. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bdo

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("bdo", *args, children=children, **kwargs)


def br(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <br> tag.

    The <br> HTML element produces a line break in text (carriage-return). It is useful for writing a poem or an address, where the division of lines is significant. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/br

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("br", *args, children=children, **kwargs)


def cite(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <cite> tag.

    The <cite> HTML element is used to describe a reference to a cited creative work, and must include the title of that work. The reference may be in an abbreviated form according to context-appropriate conventions related to citation metadata. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/cite

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("cite", *args, children=children, **kwargs)


def code(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <code> tag.

    The <code> HTML element displays its contents styled in a fashion intended to indicate that the text is a short fragment of computer code. By default, the content text is displayed using the user agent default monospace font. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/code

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("code", *args, children=children, **kwargs)


def data(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <data> tag.

    The <data> HTML element links a given piece of content with a machine-readable translation. If the content is time- or date-related, the time element must be used. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/data

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("data", *args, children=children, **kwargs)


def dfn(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <dfn> tag.

    The <dfn> HTML element is used to indicate the term being defined within the context of a definition phrase or sentence. The p element, the dt/dd pairing, or the section element which is the nearest ancestor of the <dfn> is considered to be the definition of the term. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dfn

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("dfn", *args, children=children, **kwargs)


def em(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <em> tag.

    The <em> HTML element marks text that has stress emphasis. The <em> element can be nested, with each level of nesting indicating a greater degree of emphasis. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/em

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("em", *args, children=children, **kwargs)


def i(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <i> tag.

    The <i> HTML element represents a range of text that is set off from the normal text for some reason, such as idiomatic text, technical terms, taxonomical designations, among others. Historically, these have been presented using italicized type, which is the original source of the <i> naming of this element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/i

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("i", *args, children=children, **kwargs)


def kbd(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <kbd> tag.

    The <kbd> HTML element represents a span of inline text denoting textual user input from a keyboard, voice input, or any other text entry device. By convention, the user agent defaults to rendering the contents of a <kbd> element using its default monospace font, although this is not mandated by the HTML standard. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/kbd

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("kbd", *args, children=children, **kwargs)


def mark(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <mark> tag.

    The <mark> HTML element represents text which is marked or highlighted for reference or notation purposes, due to the marked passage's relevance or importance in the enclosing context. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/mark

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("mark", *args, children=children, **kwargs)


def q(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <q> tag.

    The <q> HTML element indicates that the enclosed text is a short inline quotation. Most modern browsers implement this by surrounding the text in quotation marks. This element is intended for short quotations that don't require paragraph breaks; for long quotations use the blockquote element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/q

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("q", *args, children=children, **kwargs)


def rp(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <rp> tag.

    The <rp> HTML element is used to provide fall-back parentheses for browsers that do not support display of ruby annotations using the ruby element. One <rp> element should enclose each of the opening and closing parentheses that wrap the rt element that contains the annotation's text. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rp

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("rp", *args, children=children, **kwargs)


def rt(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <rt> tag.

    The <rt> HTML element specifies the ruby text component of a ruby annotation, which is used to provide pronunciation, translation, or transliteration information for East Asian typography. The <rt> element must always be contained within a ruby element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rt

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("rt", *args, children=children, **kwargs)


def ruby(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <ruby> tag.

    The <ruby> HTML element represents small annotations that are rendered above, below, or next to base text, usually used for showing the pronunciation of East Asian characters. It can also be used for annotating other kinds of text, but this usage is less common. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ruby

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("ruby", *args, children=children, **kwargs)


def s(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <s> tag.

    The <s> HTML element renders text with a strikethrough, or a line through it. Use the <s> element to represent things that are no longer relevant or no longer accurate. However, <s> is not appropriate when indicating document edits; for that, use the del and ins elements, as appropriate. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/s

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("s", *args, children=children, **kwargs)


def samp(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <samp> tag.

    The <samp> HTML element is used to enclose inline text which represents sample (or quoted) output from a computer program. Its contents are typically rendered using the browser's default monospaced font (such as Courier or Lucida Console). Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/samp

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("samp", *args, children=children, **kwargs)


def small(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <small> tag.

    The <small> HTML element represents side-comments and small print, like copyright and legal text, independent of its styled presentation. By default, it renders text within it one font-size smaller, such as from small to x-small. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/small

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("small", *args, children=children, **kwargs)


def span(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <span> tag.

    The <span> HTML element is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang. It should be used only when no other semantic element is appropriate. <span> is very much like a div element, but div is a block-level element whereas a <span> is an inline element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/span

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("span", *args, children=children, **kwargs)


def strong(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <strong> tag.

    The <strong> HTML element indicates that its contents have strong importance, seriousness, or urgency. Browsers typically render the contents in bold type. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/strong

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("strong", *args, children=children, **kwargs)


def sub(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <sub> tag.

    The <sub> HTML element specifies inline text which should be displayed as subscript for solely typographical reasons. Subscripts are typically rendered with a lowered baseline using smaller text. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/sub

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("sub", *args, children=children, **kwargs)


def sup(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <sup> tag.

    The <sup> HTML element specifies inline text which is to be displayed as superscript for solely typographical reasons. Superscripts are usually rendered with a raised baseline using smaller text. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/sup

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("sup", *args, children=children, **kwargs)


def time(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <time> tag.

    The <time> HTML element represents a specific period in time. It may include the datetime attribute to translate dates into machine-readable format, allowing for better search engine results or custom features such as reminders. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/time

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("time", *args, children=children, **kwargs)


def u(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <u> tag.

    The <u> HTML element represents a span of inline text which should be rendered in a way that indicates that it has a non-textual annotation. This is rendered by default as a simple solid underline, but may be altered using CSS. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/u

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("u", *args, children=children, **kwargs)


def var(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <var> tag.

    The <var> HTML element represents the name of a variable in a mathematical expression or a programming context. It's typically presented using an italicized version of the current typeface, although that behavior is browser-dependent. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/var

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("var", *args, children=children, **kwargs)


def wbr(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <wbr> tag.

    The <wbr> HTML element represents a word break opportunity—a position within text where the browser may optionally break a line, though its line-breaking rules would not otherwise create a break at that location. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/wbr

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("wbr", *args, children=children, **kwargs)


def area(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <area> tag.

    The <area> HTML element defines an area inside an image map that has predefined clickable areas. An image map allows geometric areas on an image to be associated with Hyperlink. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/area

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("area", *args, children=children, **kwargs)


def audio(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <audio> tag.

    The <audio> HTML element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the source element: the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("audio", *args, children=children, **kwargs)


def img(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <img> tag.

    The <img> HTML element embeds an image into the document. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("img", *args, children=children, **kwargs)


def map(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <map> tag.

    The <map> HTML element is used with area elements to define an image map (a clickable link area). Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/map

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("map", *args, children=children, **kwargs)


def track(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <track> tag.

    The <track> HTML element is used as a child of the media elements, audio and video. It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in WebVTT format (.vtt files) — Web Video Text Tracks. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/track

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("track", *args, children=children, **kwargs)


def video(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <video> tag.

    The <video> HTML element embeds a media player which supports video playback into the document. You can use <video> for audio content as well, but the audio element may provide a more appropriate user experience. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("video", *args, children=children, **kwargs)


def embed(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <embed> tag.

    The <embed> HTML element embeds external content at the specified point in the document. This content is provided by an external application or other source of interactive content such as a browser plug-in. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/embed

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("embed", *args, children=children, **kwargs)


def iframe(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <iframe> tag.

    The <iframe> HTML element represents a nested browsing context, embedding another HTML page into the current one. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("iframe", *args, children=children, **kwargs)


def object(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <object> tag.

    The <object> HTML element represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/object

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("object", *args, children=children, **kwargs)


def param(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <param> tag.

    The <param> HTML element defines parameters for an object element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/param

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("param", *args, children=children, **kwargs)


def picture(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <picture> tag.

    The <picture> HTML element contains zero or more source elements and one img element to offer alternative versions of an image for different display/device scenarios. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("picture", *args, children=children, **kwargs)


def portal(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <portal> tag.

    The <portal> HTML element enables the embedding of another HTML page into the current one for the purposes of allowing smoother navigation into new pages. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/portal

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("portal", *args, children=children, **kwargs)


def source(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <source> tag.

    The <source> HTML element specifies multiple media resources for the picture, the audio element, or the video element. It is an empty element, meaning that it has no content and does not have a closing tag. It is commonly used to offer the same media content in multiple file formats in order to provide compatibility with a broad range of browsers given their differing support for image file formats and media file formats. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("source", *args, children=children, **kwargs)


def svg(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <svg> tag.

    The svg element is a container that defines a new
    coordinate system and
    viewport. It is used
    as the outermost element of SVG documents, but it can also be used to
    embed an SVG fragment inside an SVG or HTML document. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/svg

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("svg", *args, children=children, **kwargs)


def math(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <math> tag.

    The top-level element in MathML is <math>. Every valid
    MathML instance must be wrapped in <math> tags. In
    addition you must not nest a second <math> element in
    another, but you can have an arbitrary number of other child elements in
    it. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/math

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("math", *args, children=children, **kwargs)


def canvas(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <canvas> tag.

    Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("canvas", *args, children=children, **kwargs)


def noscript(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <noscript> tag.

    The <noscript> HTML element defines a section of HTML to be inserted if a script type on the page is unsupported or if scripting is currently turned off in the browser. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noscript

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("noscript", *args, children=children, **kwargs)


def script(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <script> tag.

    The <script> HTML element is used to embed executable code or data; this is typically used to embed or refer to JavaScript code. The <script> element can also be used with other languages, such as WebGL's GLSL shader programming language and JSON. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("script", *args, children=children, **kwargs)


def ins(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <ins> tag.

    The <ins> HTML element represents a range of text that has been added to a document. You can use the del element to similarly represent a range of text that has been deleted from the document. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ins

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("ins", *args, children=children, **kwargs)


def caption(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <caption> tag.

    The <caption> HTML element specifies the caption (or title) of a table. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/caption

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("caption", *args, children=children, **kwargs)


def col(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <col> tag.

    The <col> HTML element defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a colgroup element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("col", *args, children=children, **kwargs)


def colgroup(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <colgroup> tag.

    The <colgroup> HTML element defines a group of columns within a table. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("colgroup", *args, children=children, **kwargs)


def table(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <table> tag.

    The <table> HTML element represents tabular data — that is, information presented in a two-dimensional table comprised of rows and columns of cells containing data. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("table", *args, children=children, **kwargs)


def tbody(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <tbody> tag.

    The <tbody> HTML element encapsulates a set of table rows (tr elements), indicating that they comprise the body of the table (table). Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("tbody", *args, children=children, **kwargs)


def td(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <td> tag.

    The <td> HTML element defines a cell of a table that contains data. It participates in the table model. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("td", *args, children=children, **kwargs)


def tfoot(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <tfoot> tag.

    The <tfoot> HTML element defines a set of rows summarizing the columns of the table. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("tfoot", *args, children=children, **kwargs)


def th(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <th> tag.

    The <th> HTML element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("th", *args, children=children, **kwargs)


def thead(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <thead> tag.

    The <thead> HTML element defines a set of rows defining the head of the columns of the table. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("thead", *args, children=children, **kwargs)


def tr(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <tr> tag.

    The <tr> HTML element defines a row of cells in a table. The row's cells can then be established using a mix of td (data cell) and th (header cell) elements. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("tr", *args, children=children, **kwargs)


def button(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <button> tag.

    The <button> HTML element represents a clickable button, used to submit forms or anywhere in a document for accessible, standard button functionality. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("button", *args, children=children, **kwargs)


def datalist(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <datalist> tag.

    The <datalist> HTML element contains a set of option elements that represent the permissible or recommended options available to choose from within other controls. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("datalist", *args, children=children, **kwargs)


def fieldset(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <fieldset> tag.

    The <fieldset> HTML element is used to group several controls as well as labels (label) within a web form. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/fieldset

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("fieldset", *args, children=children, **kwargs)


def form(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <form> tag.

    The <form> HTML element represents a document section containing interactive controls for submitting information. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("form", *args, children=children, **kwargs)


def input(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <input> tag.

    The <input> HTML element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent. The <input> element is one of the most powerful and complex in all of HTML due to the sheer number of combinations of input types and attributes. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("input", *args, children=children, **kwargs)


def label(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <label> tag.

    The <label> HTML element represents a caption for an item in a user interface. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("label", *args, children=children, **kwargs)


def legend(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <legend> tag.

    The <legend> HTML element represents a caption for the content of its parent fieldset. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/legend

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("legend", *args, children=children, **kwargs)


def meter(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <meter> tag.

    The <meter> HTML element represents either a scalar value within a known range or a fractional value. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meter

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("meter", *args, children=children, **kwargs)


def optgroup(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <optgroup> tag.

    The <optgroup> HTML element creates a grouping of options within a select element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/optgroup

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("optgroup", *args, children=children, **kwargs)


def option(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <option> tag.

    The <option> HTML element is used to define an item contained in a select, an optgroup, or a datalist element. As such, <option> can represent menu items in popups and other lists of items in an HTML document. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/option

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("option", *args, children=children, **kwargs)


def output(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <output> tag.

    The <output> HTML element is a container element into which a site or app can inject the results of a calculation or the outcome of a user action. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/output

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("output", *args, children=children, **kwargs)


def progress(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <progress> tag.

    The <progress> HTML element displays an indicator showing the completion progress of a task, typically displayed as a progress bar. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/progress

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("progress", *args, children=children, **kwargs)


def select(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <select> tag.

    The <select> HTML element represents a control that provides a menu of options: Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("select", *args, children=children, **kwargs)


def textarea(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <textarea> tag.

    The <textarea> HTML element represents a multi-line plain-text editing control, useful when you want to allow users to enter a sizeable amount of free-form text, for example a comment on a review or feedback form. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/textarea

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("textarea", *args, children=children, **kwargs)


def details(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <details> tag.

    The <details> HTML element creates a disclosure widget in which information is visible only when the widget is toggled into an "open" state. A summary or label must be provided using the summary element. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/details

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("details", *args, children=children, **kwargs)


def dialog(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <dialog> tag.

    The <dialog> HTML element represents a dialog box or other interactive component, such as a dismissible alert, inspector, or subwindow. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dialog

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("dialog", *args, children=children, **kwargs)


def summary(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <summary> tag.

    The <summary> HTML element specifies a summary, caption, or legend for a details element's disclosure box. Clicking the <summary> element toggles the state of the parent <details> element open and closed. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/summary

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("summary", *args, children=children, **kwargs)


def slot(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <slot> tag.

    The <slot> HTML element—part of the Web Components technology suite—is a placeholder inside a web component that you can fill with your own markup, which lets you create separate DOM trees and present them together. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/slot

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("slot", *args, children=children, **kwargs)


def template(*args: TagChildArg, children: Optional[list[TagChildArg]] = None, **kwargs: TagAttrArg) -> Tag:
    """
    Create a <template> tag.

    The <template> HTML element is a mechanism for holding HTML that is not to be rendered immediately when a page is loaded but may be instantiated subsequently during runtime using JavaScript. Learn more at https://developer.mozilla.org/en-US/docs/Web/HTML/Element/template

    Parameters
    ----------
    *args
        Child elements to this tag.
    children
        Child elements to this tag.
    **kwargs
        Attributes to this tag.

    Returns
    -------
    Tag
    """

    return Tag("template", *args, children=children, **kwargs)
