# coding: utf-8

"""
    Sematext Cloud API

    API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from stcloud.api_client import ApiClient


class SubscriptionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_for_app_using_post(self, body, app_id, **kwargs):  # noqa: E501
        """Create App subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_for_app_using_post(body, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDto body: subscription (required)
        :param int app_id: appId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_for_app_using_post_with_http_info(body, app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_for_app_using_post_with_http_info(body, app_id, **kwargs)  # noqa: E501
            return data

    def create_for_app_using_post_with_http_info(self, body, app_id, **kwargs):  # noqa: E501
        """Create App subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_for_app_using_post_with_http_info(body, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDto body: subscription (required)
        :param int app_id: appId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_for_app_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_for_app_using_post`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if ('app_id' not in params or
                params['app_id'] is None):
            raise ValueError("Missing the required parameter `app_id` when calling `create_for_app_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_id' in params:
            path_params['appId'] = params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{appId}/subscription', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_for_dash_using_post1(self, body, dash_id, **kwargs):  # noqa: E501
        """Create dashboard subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_for_dash_using_post1(body, dash_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDashboardDto body: subscription (required)
        :param int dash_id: dashId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_for_dash_using_post1_with_http_info(body, dash_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_for_dash_using_post1_with_http_info(body, dash_id, **kwargs)  # noqa: E501
            return data

    def create_for_dash_using_post1_with_http_info(self, body, dash_id, **kwargs):  # noqa: E501
        """Create dashboard subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_for_dash_using_post1_with_http_info(body, dash_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDashboardDto body: subscription (required)
        :param int dash_id: dashId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dash_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_for_dash_using_post1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_for_dash_using_post1`")  # noqa: E501
        # verify the required parameter 'dash_id' is set
        if ('dash_id' not in params or
                params['dash_id'] is None):
            raise ValueError("Missing the required parameter `dash_id` when calling `create_for_dash_using_post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dash_id' in params:
            path_params['dashId'] = params['dash_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/dashboards/{dashId}/subscription', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_using_delete2(self, updateable_subscription_id, **kwargs):  # noqa: E501
        """Delete subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_using_delete2(updateable_subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_subscription_id: updateableSubscriptionId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_using_delete2_with_http_info(updateable_subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_using_delete2_with_http_info(updateable_subscription_id, **kwargs)  # noqa: E501
            return data

    def delete_using_delete2_with_http_info(self, updateable_subscription_id, **kwargs):  # noqa: E501
        """Delete subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_using_delete2_with_http_info(updateable_subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_subscription_id: updateableSubscriptionId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updateable_subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_using_delete2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'updateable_subscription_id' is set
        if ('updateable_subscription_id' not in params or
                params['updateable_subscription_id'] is None):
            raise ValueError("Missing the required parameter `updateable_subscription_id` when calling `delete_using_delete2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'updateable_subscription_id' in params:
            path_params['updateableSubscriptionId'] = params['updateable_subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/subscriptions/{updateableSubscriptionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericMapBasedApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_using_get3(self, app_id, **kwargs):  # noqa: E501
        """Get subscriptions for an App  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_using_get3(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int app_id: appId (required)
        :return: SubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_using_get3_with_http_info(app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_using_get3_with_http_info(app_id, **kwargs)  # noqa: E501
            return data

    def list_using_get3_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get subscriptions for an App  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_using_get3_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int app_id: appId (required)
        :return: SubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_using_get3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_id' is set
        if ('app_id' not in params or
                params['app_id'] is None):
            raise ValueError("Missing the required parameter `app_id` when calling `list_using_get3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_id' in params:
            path_params['appId'] = params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{appId}/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_using_get5(self, **kwargs):  # noqa: E501
        """Get current account's subscriptions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_using_get5(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_using_get5_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_using_get5_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_using_get5_with_http_info(self, **kwargs):  # noqa: E501
        """Get current account's subscriptions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_using_get5_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_using_get5" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_app_report_using_post(self, body, app_id, **kwargs):  # noqa: E501
        """Email an App report  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_app_report_using_post(body, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportInfo body: emailDto (required)
        :param int app_id: appId (required)
        :return: MailReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_app_report_using_post_with_http_info(body, app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_app_report_using_post_with_http_info(body, app_id, **kwargs)  # noqa: E501
            return data

    def send_app_report_using_post_with_http_info(self, body, app_id, **kwargs):  # noqa: E501
        """Email an App report  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_app_report_using_post_with_http_info(body, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportInfo body: emailDto (required)
        :param int app_id: appId (required)
        :return: MailReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_app_report_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `send_app_report_using_post`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if ('app_id' not in params or
                params['app_id'] is None):
            raise ValueError("Missing the required parameter `app_id` when calling `send_app_report_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_id' in params:
            path_params['appId'] = params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{appId}/report/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MailReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_dash_report_using_post(self, body, dash_id, **kwargs):  # noqa: E501
        """Email a dashboard report  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_dash_report_using_post(body, dash_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportInfo body: emailDto (required)
        :param int dash_id: dashId (required)
        :return: MailReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_dash_report_using_post_with_http_info(body, dash_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_dash_report_using_post_with_http_info(body, dash_id, **kwargs)  # noqa: E501
            return data

    def send_dash_report_using_post_with_http_info(self, body, dash_id, **kwargs):  # noqa: E501
        """Email a dashboard report  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_dash_report_using_post_with_http_info(body, dash_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportInfo body: emailDto (required)
        :param int dash_id: dashId (required)
        :return: MailReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dash_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_dash_report_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `send_dash_report_using_post`")  # noqa: E501
        # verify the required parameter 'dash_id' is set
        if ('dash_id' not in params or
                params['dash_id'] is None):
            raise ValueError("Missing the required parameter `dash_id` when calling `send_dash_report_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dash_id' in params:
            path_params['dashId'] = params['dash_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/dashboards/{dashId}/report/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MailReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def toggle_enabled_using_put1(self, body, updateable_subscription_id, **kwargs):  # noqa: E501
        """Toggle subscription status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.toggle_enabled_using_put1(body, updateable_subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateSubscriptionDto body: dto (required)
        :param int updateable_subscription_id: updateableSubscriptionId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.toggle_enabled_using_put1_with_http_info(body, updateable_subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.toggle_enabled_using_put1_with_http_info(body, updateable_subscription_id, **kwargs)  # noqa: E501
            return data

    def toggle_enabled_using_put1_with_http_info(self, body, updateable_subscription_id, **kwargs):  # noqa: E501
        """Toggle subscription status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.toggle_enabled_using_put1_with_http_info(body, updateable_subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateSubscriptionDto body: dto (required)
        :param int updateable_subscription_id: updateableSubscriptionId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'updateable_subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method toggle_enabled_using_put1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `toggle_enabled_using_put1`")  # noqa: E501
        # verify the required parameter 'updateable_subscription_id' is set
        if ('updateable_subscription_id' not in params or
                params['updateable_subscription_id'] is None):
            raise ValueError("Missing the required parameter `updateable_subscription_id` when calling `toggle_enabled_using_put1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'updateable_subscription_id' in params:
            path_params['updateableSubscriptionId'] = params['updateable_subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/subscriptions/{updateableSubscriptionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_for_app_using_put(self, body, app_id, **kwargs):  # noqa: E501
        """Update App subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_for_app_using_put(body, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDto body: subscription (required)
        :param int app_id: appId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_for_app_using_put_with_http_info(body, app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_for_app_using_put_with_http_info(body, app_id, **kwargs)  # noqa: E501
            return data

    def update_for_app_using_put_with_http_info(self, body, app_id, **kwargs):  # noqa: E501
        """Update App subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_for_app_using_put_with_http_info(body, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDto body: subscription (required)
        :param int app_id: appId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_for_app_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_for_app_using_put`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if ('app_id' not in params or
                params['app_id'] is None):
            raise ValueError("Missing the required parameter `app_id` when calling `update_for_app_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_id' in params:
            path_params['appId'] = params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{appId}/subscription', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_for_dash_using_put1(self, body, dash_id, **kwargs):  # noqa: E501
        """Update dashboard subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_for_dash_using_put1(body, dash_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDashboardDto body: subscription (required)
        :param int dash_id: dashId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_for_dash_using_put1_with_http_info(body, dash_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_for_dash_using_put1_with_http_info(body, dash_id, **kwargs)  # noqa: E501
            return data

    def update_for_dash_using_put1_with_http_info(self, body, dash_id, **kwargs):  # noqa: E501
        """Update dashboard subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_for_dash_using_put1_with_http_info(body, dash_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionDashboardDto body: subscription (required)
        :param int dash_id: dashId (required)
        :return: SubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dash_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_for_dash_using_put1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_for_dash_using_put1`")  # noqa: E501
        # verify the required parameter 'dash_id' is set
        if ('dash_id' not in params or
                params['dash_id'] is None):
            raise ValueError("Missing the required parameter `dash_id` when calling `update_for_dash_using_put1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dash_id' in params:
            path_params['dashId'] = params['dash_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/dashboards/{dashId}/subscription', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
