# coding: utf-8

"""
    Sematext Cloud API

    API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from stcloud.api_client import ApiClient


class AlertsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_alert_using_post(self, body, **kwargs):  # noqa: E501
        """Create alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alert_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertRule body: dto (required)
        :return: AlertRuleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_alert_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_alert_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_alert_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_alert_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertRule body: dto (required)
        :return: AlertRuleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_alert_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_alert_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/alerts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlertRuleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_alert_rule_using_delete1(self, updateable_alert_id, **kwargs):  # noqa: E501
        """Delete alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_rule_using_delete1(updateable_alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_alert_id: updateableAlertId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_alert_rule_using_delete1_with_http_info(updateable_alert_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_alert_rule_using_delete1_with_http_info(updateable_alert_id, **kwargs)  # noqa: E501
            return data

    def delete_alert_rule_using_delete1_with_http_info(self, updateable_alert_id, **kwargs):  # noqa: E501
        """Delete alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_rule_using_delete1_with_http_info(updateable_alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_alert_id: updateableAlertId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updateable_alert_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alert_rule_using_delete1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'updateable_alert_id' is set
        if ('updateable_alert_id' not in params or
                params['updateable_alert_id'] is None):
            raise ValueError("Missing the required parameter `updateable_alert_id` when calling `delete_alert_rule_using_delete1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'updateable_alert_id' in params:
            path_params['updateableAlertId'] = params['updateable_alert_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/alerts/{updateableAlertId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericMapBasedApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def disable_alert_rule_using_put(self, updateable_alert_id, **kwargs):  # noqa: E501
        """Disable alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_alert_rule_using_put(updateable_alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_alert_id: updateableAlertId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.disable_alert_rule_using_put_with_http_info(updateable_alert_id, **kwargs)  # noqa: E501
        else:
            (data) = self.disable_alert_rule_using_put_with_http_info(updateable_alert_id, **kwargs)  # noqa: E501
            return data

    def disable_alert_rule_using_put_with_http_info(self, updateable_alert_id, **kwargs):  # noqa: E501
        """Disable alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_alert_rule_using_put_with_http_info(updateable_alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_alert_id: updateableAlertId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updateable_alert_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_alert_rule_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'updateable_alert_id' is set
        if ('updateable_alert_id' not in params or
                params['updateable_alert_id'] is None):
            raise ValueError("Missing the required parameter `updateable_alert_id` when calling `disable_alert_rule_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'updateable_alert_id' in params:
            path_params['updateableAlertId'] = params['updateable_alert_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/alerts/{updateableAlertId}/disable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericMapBasedApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def enable_alert_rule_using_put(self, updateable_alert_id, **kwargs):  # noqa: E501
        """Enable alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_alert_rule_using_put(updateable_alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_alert_id: updateableAlertId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.enable_alert_rule_using_put_with_http_info(updateable_alert_id, **kwargs)  # noqa: E501
        else:
            (data) = self.enable_alert_rule_using_put_with_http_info(updateable_alert_id, **kwargs)  # noqa: E501
            return data

    def enable_alert_rule_using_put_with_http_info(self, updateable_alert_id, **kwargs):  # noqa: E501
        """Enable alert rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_alert_rule_using_put_with_http_info(updateable_alert_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updateable_alert_id: updateableAlertId (required)
        :return: GenericMapBasedApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updateable_alert_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_alert_rule_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'updateable_alert_id' is set
        if ('updateable_alert_id' not in params or
                params['updateable_alert_id'] is None):
            raise ValueError("Missing the required parameter `updateable_alert_id` when calling `enable_alert_rule_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'updateable_alert_id' in params:
            path_params['updateableAlertId'] = params['updateable_alert_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/alerts/{updateableAlertId}/enable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericMapBasedApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_rules_for_app_using_get1(self, app_id, **kwargs):  # noqa: E501
        """Get alert rules for an app  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_rules_for_app_using_get1(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int app_id: appId (required)
        :return: AlertRulesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_rules_for_app_using_get1_with_http_info(app_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_rules_for_app_using_get1_with_http_info(app_id, **kwargs)  # noqa: E501
            return data

    def get_alert_rules_for_app_using_get1_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get alert rules for an app  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_rules_for_app_using_get1_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int app_id: appId (required)
        :return: AlertRulesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['app_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_rules_for_app_using_get1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'app_id' is set
        if ('app_id' not in params or
                params['app_id'] is None):
            raise ValueError("Missing the required parameter `app_id` when calling `get_alert_rules_for_app_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'app_id' in params:
            path_params['appId'] = params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/users-web/api/v3/apps/{appId}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlertRulesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
