function _aws_cdk_aws_lambda_python_PythonLayerVersionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if (!visitedObjects.has(p.compatibleArchitectures))
        require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_Architecture(p.compatibleArchitectures);
    if (!visitedObjects.has(p.compatibleRuntimes))
        require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_Runtime(p.compatibleRuntimes);
    visitedObjects.delete(p);
}
function _aws_cdk_aws_lambda_python_PythonLayerVersion(p) {
}
function _aws_cdk_aws_lambda_python_PythonFunction(p) {
}
function _aws_cdk_aws_lambda_python_PythonFunctionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if ("architectures" in p)
        print("@aws-cdk/aws-lambda.FunctionOptions#architectures", "use `architecture`");
    if (!visitedObjects.has(p.architectures))
        require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_Architecture(p.architectures);
    if (!visitedObjects.has(p.events))
        require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_IEventSource(p.events);
    if (!visitedObjects.has(p.initialPolicy))
        require("@aws-cdk/aws-iam/.warnings.jsii.js")._aws_cdk_aws_iam_PolicyStatement(p.initialPolicy);
    if (!visitedObjects.has(p.layers))
        require("@aws-cdk/aws-lambda/.warnings.jsii.js")._aws_cdk_aws_lambda_ILayerVersion(p.layers);
    if ("securityGroup" in p)
        print("@aws-cdk/aws-lambda.FunctionOptions#securityGroup", "- This property is deprecated, use securityGroups instead");
    if (!visitedObjects.has(p.securityGroups))
        require("@aws-cdk/aws-ec2/.warnings.jsii.js")._aws_cdk_aws_ec2_ISecurityGroup(p.securityGroups);
    visitedObjects.delete(p);
}
function print(name, deprecationMessage) {
    const deprecated = process.env.JSII_DEPRECATED;
    const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
    const message = `${name} is deprecated.\n  ${deprecationMessage}\n  This API will be removed in the next major release.`;
    switch (deprecationMode) {
        case "fail":
            throw new DeprecationError(message);
        case "warn":
            console.warn("[WARNING]", message);
            break;
    }
}
const visitedObjects = new Set();
class DeprecationError extends Error {
}
module.exports = { print, _aws_cdk_aws_lambda_python_PythonLayerVersionProps, _aws_cdk_aws_lambda_python_PythonLayerVersion, _aws_cdk_aws_lambda_python_PythonFunction, _aws_cdk_aws_lambda_python_PythonFunctionProps };
module.exports.DeprecationError = DeprecationError;
