# Copyright (C) 2022 Istituto Italiano di Tecnologia (IIT). All rights reserved.
# This software may be modified and distributed under the terms of the
# Released under the terms of the BSD 3-Clause License

from PyQt5.QtWidgets import QFrame

from robot_log_visualizer.ui.autogenerated.plot_tab import Ui_PlotTab
from robot_log_visualizer.plotter.matplotlib_viewer_canvas import MatplotlibViewerCanvas


class PlotItem(QFrame):
    def __init__(self, signal_provider, period):
        super().__init__(None)
        self.ui = Ui_PlotTab()
        self.ui.setupUi(self)

        self.canvas = MatplotlibViewerCanvas(
            parent=self, period=period, signal_provider=signal_provider
        )
        self.ui.plotLayout.addWidget(self.canvas)
