"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonClientProject = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const python_1 = require("projen/lib/python");
const generated_python_client_source_code_1 = require("./components/generated-python-client-source-code");
const open_api_generator_ignore_file_1 = require("./components/open-api-generator-ignore-file");
/**
 * Python project containing a python client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
class GeneratedPythonClientProject extends python_1.PythonProject {
    constructor(options) {
        super({
            sample: false,
            pytest: false,
            ...options,
        });
        /**
         * The directory in which the built layer is output
         */
        this.layerDistDir = "dist/layer";
        // Store whether we've synthesized the project
        this.synthed = false;
        new generated_python_client_source_code_1.GeneratedPythonClientSourceCode(this, {
            specPath: options.specPath,
            invokeGenerator: options.generateClient,
        });
        new open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile(this);
        // With pip and venv (default), it's useful to install our package into the shared venv to make
        // it easier for other packages in the monorepo to take dependencies on this package.
        if ((options.venv ?? true) && (options.pip ?? true)) {
            this.depsManager.installTask.exec("pip install --editable .");
        }
        // Package into a directory that can be used as a lambda layer. This is done as part of install since the end user
        // must control build order in the monorepo via explicit dependencies, and adding here means we can run as part of
        // initial project synthesis which ensures this is created regardless of whether the user has remembered to
        // configure build order.
        if (options.generateLayer) {
            const relativeLayerDir = path.join(".", this.layerDistDir, "python");
            this.depsManager.installTask.exec(`rm -rf ${relativeLayerDir}`);
            this.depsManager.installTask.exec(`pip install . --target ${relativeLayerDir}`);
        }
    }
    /**
     * @inheritDoc
     */
    synth() {
        // Save some time by only synthesizing once. We synthesize this project early so that it's available for the parent
        // project's install phase (pre-synth). Projen will call this method again at the usual time to synthesize this,
        // project, at which point we're already done so can skip.
        if (this.synthed) {
            return;
        }
        super.synth();
        this.synthed = true;
    }
}
exports.GeneratedPythonClientProject = GeneratedPythonClientProject;
//# sourceMappingURL=data:application/json;base64,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