"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
const path = require("path");
const fs = require("fs-extra");
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the typescript client
        utils_1.invokeOpenApiGenerator({
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            generatorDirectory: languages_1.ClientLanguage.TYPESCRIPT,
            additionalProperties: {
                npmName: this.project.package.packageName,
                typescriptThreePlus: "true",
                useSingleParameter: "true",
                supportsES6: "true",
            },
        });
        // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
        // and other generated code used by the construct.
        fs.writeFileSync(path.join(this.project.outdir, "src", "index.ts"), [
            "/* tslint:disable */",
            "/* eslint-disable */",
            "export * from './runtime';",
            "export * from './apis';",
            "export * from './models';",
            "export * from './apis/DefaultApi/OperationConfig';",
        ].join("\n"));
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2VuZXJhdGVkLXR5cGVzY3JpcHQtY2xpZW50LXNvdXJjZS1jb2RlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL3Byb2plY3QvY29kZWdlbi9jb21wb25lbnRzL2dlbmVyYXRlZC10eXBlc2NyaXB0LWNsaWVudC1zb3VyY2UtY29kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7Ozs7O3dIQWN3SDs7O0FBRXhILDZCQUE2QjtBQUM3QiwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBRW5DLCtDQUFpRDtBQUNqRCxtQ0FBaUQ7QUFZakQ7O0dBRUc7QUFDSCxNQUFhLG1DQUFvQyxTQUFRLGtCQUFTO0lBR2hFLFlBQ0UsT0FBMEIsRUFDMUIsT0FBbUQ7UUFFbkQsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ2YsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUM7SUFDekIsQ0FBQztJQUVEOztPQUVHO0lBQ0gsVUFBVTtRQUNSLEtBQUssQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUVuQixpQ0FBaUM7UUFDakMsOEJBQXNCLENBQUM7WUFDckIsU0FBUyxFQUFFLGtCQUFrQjtZQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRO1lBQy9CLFVBQVUsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU07WUFDL0Isa0JBQWtCLEVBQUUsMEJBQWMsQ0FBQyxVQUFVO1lBQzdDLG9CQUFvQixFQUFFO2dCQUNwQixPQUFPLEVBQUcsSUFBSSxDQUFDLE9BQTZCLENBQUMsT0FBTyxDQUFDLFdBQVc7Z0JBQ2hFLG1CQUFtQixFQUFFLE1BQU07Z0JBQzNCLGtCQUFrQixFQUFFLE1BQU07Z0JBQzFCLFdBQVcsRUFBRSxNQUFNO2FBQ3BCO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsb0hBQW9IO1FBQ3BILGtEQUFrRDtRQUNsRCxFQUFFLENBQUMsYUFBYSxDQUNkLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxFQUNqRDtZQUNFLHNCQUFzQjtZQUN0QixzQkFBc0I7WUFDdEIsNEJBQTRCO1lBQzVCLHlCQUF5QjtZQUN6QiwyQkFBMkI7WUFDM0Isb0RBQW9EO1NBQ3JELENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUNiLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUE3Q0Qsa0ZBNkNDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuXG4gTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS5cbiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGggdGhlIExpY2Vuc2UuXG4gWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG5cbiBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcblxuIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiBkaXN0cmlidXRlZCB1bmRlciB0aGUgTGljZW5zZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsXG4gV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqICovXG5cbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCAqIGFzIGZzIGZyb20gXCJmcy1leHRyYVwiO1xuaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSBcInByb2plblwiO1xuaW1wb3J0IHsgVHlwZVNjcmlwdFByb2plY3QgfSBmcm9tIFwicHJvamVuL2xpYi90eXBlc2NyaXB0XCI7XG5pbXBvcnQgeyBDbGllbnRMYW5ndWFnZSB9IGZyb20gXCIuLi8uLi9sYW5ndWFnZXNcIjtcbmltcG9ydCB7IGludm9rZU9wZW5BcGlHZW5lcmF0b3IgfSBmcm9tIFwiLi91dGlsc1wiO1xuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gZm9yIHRoZSBHZW5lcmF0ZWRUeXBlc2NyaXB0Q2xpZW50IGNvbXBvbmVudFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEdlbmVyYXRlZFR5cGVzY3JpcHRDbGllbnRTb3VyY2VDb2RlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBBYnNvbHV0ZSBwYXRoIHRvIHRoZSBPcGVuQVBJIHNwZWNpZmljYXRpb24gKHNwZWMueWFtbClcbiAgICovXG4gIHJlYWRvbmx5IHNwZWNQYXRoOiBzdHJpbmc7XG59XG5cbi8qKlxuICogR2VuZXJhdGVzIHRoZSB0eXBlc2NyaXB0IGNsaWVudCB1c2luZyBPcGVuQVBJIEdlbmVyYXRvclxuICovXG5leHBvcnQgY2xhc3MgR2VuZXJhdGVkVHlwZXNjcmlwdENsaWVudFNvdXJjZUNvZGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwcml2YXRlIG9wdGlvbnM6IEdlbmVyYXRlZFR5cGVzY3JpcHRDbGllbnRTb3VyY2VDb2RlT3B0aW9ucztcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcm9qZWN0OiBUeXBlU2NyaXB0UHJvamVjdCxcbiAgICBvcHRpb25zOiBHZW5lcmF0ZWRUeXBlc2NyaXB0Q2xpZW50U291cmNlQ29kZU9wdGlvbnNcbiAgKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucztcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW5oZXJpdERvY1xuICAgKi9cbiAgc3ludGhlc2l6ZSgpIHtcbiAgICBzdXBlci5zeW50aGVzaXplKCk7XG5cbiAgICAvLyBHZW5lcmF0ZSB0aGUgdHlwZXNjcmlwdCBjbGllbnRcbiAgICBpbnZva2VPcGVuQXBpR2VuZXJhdG9yKHtcbiAgICAgIGdlbmVyYXRvcjogXCJ0eXBlc2NyaXB0LWZldGNoXCIsXG4gICAgICBzcGVjUGF0aDogdGhpcy5vcHRpb25zLnNwZWNQYXRoLFxuICAgICAgb3V0cHV0UGF0aDogdGhpcy5wcm9qZWN0Lm91dGRpcixcbiAgICAgIGdlbmVyYXRvckRpcmVjdG9yeTogQ2xpZW50TGFuZ3VhZ2UuVFlQRVNDUklQVCxcbiAgICAgIGFkZGl0aW9uYWxQcm9wZXJ0aWVzOiB7XG4gICAgICAgIG5wbU5hbWU6ICh0aGlzLnByb2plY3QgYXMgVHlwZVNjcmlwdFByb2plY3QpLnBhY2thZ2UucGFja2FnZU5hbWUsXG4gICAgICAgIHR5cGVzY3JpcHRUaHJlZVBsdXM6IFwidHJ1ZVwiLFxuICAgICAgICB1c2VTaW5nbGVQYXJhbWV0ZXI6IFwidHJ1ZVwiLFxuICAgICAgICBzdXBwb3J0c0VTNjogXCJ0cnVlXCIsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgLy8gV3JpdGUgYW4gaW5kZXgudHMgd2hpY2ggZXhwb3NlcyB0aGUgYWRkaXRpb25hbCBnZW5lcmF0ZWQgZmlsZSBPcGVyYXRpb25Db25maWcudHMsIHdoaWNoIGNvbnRhaW5zIGhhbmRsZXIgd3JhcHBlcnNcbiAgICAvLyBhbmQgb3RoZXIgZ2VuZXJhdGVkIGNvZGUgdXNlZCBieSB0aGUgY29uc3RydWN0LlxuICAgIGZzLndyaXRlRmlsZVN5bmMoXG4gICAgICBwYXRoLmpvaW4odGhpcy5wcm9qZWN0Lm91dGRpciwgXCJzcmNcIiwgXCJpbmRleC50c1wiKSxcbiAgICAgIFtcbiAgICAgICAgXCIvKiB0c2xpbnQ6ZGlzYWJsZSAqL1wiLFxuICAgICAgICBcIi8qIGVzbGludC1kaXNhYmxlICovXCIsXG4gICAgICAgIFwiZXhwb3J0ICogZnJvbSAnLi9ydW50aW1lJztcIixcbiAgICAgICAgXCJleHBvcnQgKiBmcm9tICcuL2FwaXMnO1wiLFxuICAgICAgICBcImV4cG9ydCAqIGZyb20gJy4vbW9kZWxzJztcIixcbiAgICAgICAgXCJleHBvcnQgKiBmcm9tICcuL2FwaXMvRGVmYXVsdEFwaS9PcGVyYXRpb25Db25maWcnO1wiLFxuICAgICAgXS5qb2luKFwiXFxuXCIpXG4gICAgKTtcbiAgfVxufVxuIl19