"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGeneratorIgnoreFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Represents an .openapi-generator-ignore file
 * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/customization.md#ignore-file-format
 */
class OpenApiGeneratorIgnoreFile extends projen_1.IgnoreFile {
    constructor(project) {
        super(project, ".openapi-generator-ignore");
        // We should always use the projen .gitignore since projen manages the build, and therefore the ignored build
        // artifacts
        this.addPatterns(".gitignore");
    }
}
exports.OpenApiGeneratorIgnoreFile = OpenApiGeneratorIgnoreFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Blbi1hcGktZ2VuZXJhdG9yLWlnbm9yZS1maWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL3Byb2plY3QvY29kZWdlbi9jb21wb25lbnRzL29wZW4tYXBpLWdlbmVyYXRvci1pZ25vcmUtZmlsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEMsbUNBQTZDO0FBRTdDOzs7R0FHRztBQUNILE1BQWEsMEJBQTJCLFNBQVEsbUJBQVU7SUFDeEQsWUFBWSxPQUFnQjtRQUMxQixLQUFLLENBQUMsT0FBTyxFQUFFLDJCQUEyQixDQUFDLENBQUM7UUFFNUMsNkdBQTZHO1FBQzdHLFlBQVk7UUFDWixJQUFJLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Q0FDRjtBQVJELGdFQVFDIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG5pbXBvcnQgeyBJZ25vcmVGaWxlLCBQcm9qZWN0IH0gZnJvbSBcInByb2plblwiO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gLm9wZW5hcGktZ2VuZXJhdG9yLWlnbm9yZSBmaWxlXG4gKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9PcGVuQVBJVG9vbHMvb3BlbmFwaS1nZW5lcmF0b3IvYmxvYi9tYXN0ZXIvZG9jcy9jdXN0b21pemF0aW9uLm1kI2lnbm9yZS1maWxlLWZvcm1hdFxuICovXG5leHBvcnQgY2xhc3MgT3BlbkFwaUdlbmVyYXRvcklnbm9yZUZpbGUgZXh0ZW5kcyBJZ25vcmVGaWxlIHtcbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCkge1xuICAgIHN1cGVyKHByb2plY3QsIFwiLm9wZW5hcGktZ2VuZXJhdG9yLWlnbm9yZVwiKTtcblxuICAgIC8vIFdlIHNob3VsZCBhbHdheXMgdXNlIHRoZSBwcm9qZW4gLmdpdGlnbm9yZSBzaW5jZSBwcm9qZW4gbWFuYWdlcyB0aGUgYnVpbGQsIGFuZCB0aGVyZWZvcmUgdGhlIGlnbm9yZWQgYnVpbGRcbiAgICAvLyBhcnRpZmFjdHNcbiAgICB0aGlzLmFkZFBhdHRlcm5zKFwiLmdpdGlnbm9yZVwiKTtcbiAgfVxufVxuIl19