"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
export class Hello {
  public sayHello() {
    return 'hello, world!';
  }
}
*/
const path = require("path");
//import { AssetCode, LayerVersion, Runtime, LayerVersionProps } from 'aws-cdk-lib/aws-lambda';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
class ToolsLayer extends constructs_1.Construct {
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope, id, props) {
        super(scope, id);
        this.layerVersion = new aws_lambda_1.LayerVersion(this, `${props?.layerVersionName}-ToolsLayer`, {
            compatibleRuntimes: [aws_lambda_1.Runtime.NODEJS_16_X],
            code: aws_lambda_1.AssetCode.fromAsset(path.join(__dirname, './powertools')),
            description: `${props?.layerVersionName} Tools Shared Layer`,
            layerVersionName: `${props?.layerVersionName}-tools`,
        });
    }
}
exports.ToolsLayer = ToolsLayer;
_a = JSII_RTTI_SYMBOL_1;
ToolsLayer[_a] = { fqn: "vaughntech-nodejs-powertools-lambdalayer.ToolsLayer", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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