"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBStreamsToLambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_dynamodbstreams_lambda_1 = require("@aws-solutions-constructs/aws-dynamodbstreams-lambda");
const aws_lambda_elasticsearch_kibana_1 = require("@aws-solutions-constructs/aws-lambda-elasticsearch-kibana");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class DynamoDBStreamsToLambdaToElasticSearchAndKibana extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {DynamoDBStreamsToLambdaToElasticSearchAndKibanaProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        const _props1 = {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoEventSourceProps: props.dynamoEventSourceProps,
            dynamoTableProps: props.dynamoTableProps,
            existingTableInterface: props.existingTableInterface,
            deploySqsDlqQueue: props.deploySqsDlqQueue,
            sqsDlqQueueProps: props.sqsDlqQueueProps
        };
        this.DynamoDBStreamsToLambda = new aws_dynamodbstreams_lambda_1.DynamoDBStreamsToLambda(this, 'DynamoDBStreamsToLambda', _props1);
        this.lambdaFunction = this.DynamoDBStreamsToLambda.lambdaFunction;
        const _props2 = {
            existingLambdaObj: this.lambdaFunction,
            domainName: props.domainName,
            esDomainProps: props.esDomainProps,
            cognitoDomainName: props.cognitoDomainName,
            createCloudWatchAlarms: props.createCloudWatchAlarms
        };
        this.lambdaToElasticSearchAndKibana = new aws_lambda_elasticsearch_kibana_1.LambdaToElasticSearchAndKibana(this, 'LambdaToElasticSearch', _props2);
        this.dynamoTable = this.DynamoDBStreamsToLambda.dynamoTable;
        this.dynamoTableInterface = this.DynamoDBStreamsToLambda.dynamoTableInterface;
        this.userPool = this.lambdaToElasticSearchAndKibana.userPool;
        this.userPoolClient = this.lambdaToElasticSearchAndKibana.userPoolClient;
        this.identityPool = this.lambdaToElasticSearchAndKibana.identityPool;
        this.elasticsearchDomain = this.lambdaToElasticSearchAndKibana.elasticsearchDomain;
        this.elasticsearchRole = this.lambdaToElasticSearchAndKibana.elasticsearchRole;
        this.cloudwatchAlarms = this.lambdaToElasticSearchAndKibana.cloudwatchAlarms;
    }
}
exports.DynamoDBStreamsToLambdaToElasticSearchAndKibana = DynamoDBStreamsToLambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBStreamsToLambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-dynamodbstreams-lambda-elasticsearch-kibana.DynamoDBStreamsToLambdaToElasticSearchAndKibana", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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