/*
 * Library compressed_data_handle type test program
 *
 * Copyright (C) 2010-2021, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <memory.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "fsntfs_test_libcerror.h"
#include "fsntfs_test_libfdata.h"
#include "fsntfs_test_libfsntfs.h"
#include "fsntfs_test_macros.h"
#include "fsntfs_test_memory.h"
#include "fsntfs_test_unused.h"

#include "../libfsntfs/libfsntfs_cluster_block_stream.h"
#include "../libfsntfs/libfsntfs_compressed_data_handle.h"
#include "../libfsntfs/libfsntfs_definitions.h"

/* Define to make fsntfs_test_file generate verbose output
#define FSNTFS_TEST_COMPRESSED_DATA_HANDLE_VERBOSE
 */
#define FSNTFS_TEST_COMPRESSED_DATA_HANDLE_VERBOSE

uint8_t fsntfs_test_compressed_data_handle_lzxpress_huffman_compressed_data1[ 3414 ] = {
	0x00, 0x00, 0x00, 0x00, 0xa0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x08, 0x00, 0xb0, 0x89, 0x00, 0xb7, 0x98, 0xa9, 0x9a, 0xba, 0xba, 0xb0, 0x0a, 0x0b, 0x0b,
	0x80, 0x8b, 0x8a, 0x89, 0x9b, 0x0b, 0x97, 0xba, 0x09, 0x8a, 0xa9, 0xaa, 0xa0, 0x00, 0x00, 0x00,
	0x50, 0x57, 0x46, 0x76, 0x56, 0x8a, 0x66, 0x55, 0xb6, 0x55, 0x65, 0x77, 0x69, 0x0b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0,
	0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x98, 0x0a, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0xb9, 0xa9, 0xaa, 0x0b, 0x00, 0x00, 0xbb,
	0x77, 0x89, 0x88, 0xa9, 0x9a, 0xbb, 0x0b, 0x90, 0x76, 0x87, 0xa9, 0xaa, 0xaa, 0x9a, 0xa0, 0x9a,
	0x76, 0x77, 0x98, 0x9a, 0xa9, 0xb9, 0xbb, 0x9a, 0x75, 0x78, 0xa8, 0xa9, 0xa9, 0xba, 0xab, 0x80,
	0x66, 0x77, 0x98, 0x09, 0x0a, 0xba, 0x00, 0xa0, 0x76, 0x78, 0x98, 0xa9, 0x0a, 0xa0, 0xab, 0xa0,
	0x80, 0x9a, 0xba, 0xbb, 0x00, 0x00, 0x00, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3b, 0xef, 0x00, 0xc0, 0xf0, 0xce, 0x50, 0xfc, 0x9b, 0xa3, 0x9f, 0x9f, 0xe2, 0x9b, 0x76, 0x06,
	0x87, 0x6f, 0xe2, 0x9b, 0xd1, 0x65, 0x2f, 0x0e, 0xf8, 0x8b, 0xf0, 0xe8, 0x03, 0xf3, 0x99, 0xf5,
	0x1e, 0xbe, 0x6b, 0x7e, 0x8b, 0x55, 0xbe, 0xfa, 0xa5, 0x30, 0x02, 0x41, 0x46, 0x83, 0xc3, 0x3b,
	0x40, 0xc0, 0xef, 0x96, 0x1f, 0x88, 0x13, 0xdc, 0x77, 0x07, 0x0e, 0x69, 0xdf, 0xcc, 0xa0, 0x11,
	0x44, 0xd4, 0x24, 0x58, 0xdd, 0xb3, 0x6f, 0x7c, 0x32, 0x0e, 0xd5, 0x44, 0x12, 0x3d, 0x43, 0x2e,
	0x0e, 0x12, 0xa9, 0xc2, 0x21, 0x27, 0x44, 0x8b, 0x6c, 0xea, 0xad, 0xc3, 0x01, 0x72, 0x39, 0xf0,
	0x83, 0xb5, 0xba, 0xe0, 0xc1, 0xf7, 0xef, 0x29, 0xee, 0xa4, 0xcc, 0x9e, 0x26, 0xf1, 0xff, 0x19,
	0x34, 0x05, 0xb5, 0x22, 0x31, 0xa6, 0xba, 0x40, 0x50, 0x7c, 0x29, 0x58, 0xcb, 0x0b, 0xb6, 0x16,
	0x40, 0xc0, 0xbb, 0xb6, 0x43, 0x99, 0x0d, 0x49, 0x4b, 0x42, 0xa9, 0x0a, 0xb1, 0xa5, 0xcc, 0x07,
	0x5d, 0x1a, 0xf9, 0x53, 0x61, 0x87, 0x40, 0x6e, 0x01, 0xd3, 0xd6, 0x28, 0xc6, 0x42, 0x9d, 0xa0,
	0x0d, 0xbe, 0xb0, 0x5d, 0x27, 0xad, 0x00, 0x2b, 0x00, 0x3d, 0xa4, 0x1e, 0x33, 0x19, 0x98, 0x58,
	0x61, 0x42, 0xa7, 0x8f, 0xc0, 0x8a, 0x3c, 0xde, 0xa2, 0x51, 0x53, 0x0e, 0xc0, 0x96, 0x36, 0xa8,
	0xeb, 0x47, 0xa3, 0x96, 0x83, 0xdd, 0x58, 0x15, 0x28, 0x52, 0x28, 0xc2, 0x19, 0x49, 0x71, 0x0e,
	0x1e, 0x34, 0x2c, 0x31, 0x9e, 0x89, 0x42, 0xcb, 0x8b, 0xc7, 0x90, 0x13, 0x2a, 0x12, 0x02, 0xc6,
	0x45, 0x6e, 0x09, 0x2e, 0x88, 0xea, 0x36, 0xac, 0xb4, 0x3b, 0xa8, 0x5d, 0x66, 0x94, 0x73, 0xcf,
	0x15, 0x3a, 0xa8, 0x5e, 0xe7, 0xd2, 0x5d, 0xb8, 0x4d, 0xe1, 0x4c, 0xfa, 0x38, 0xb5, 0x2a, 0xad,
	0xa8, 0x54, 0x00, 0x40, 0x30, 0xd9, 0xf0, 0x1f, 0x79, 0x51, 0xfa, 0x5c, 0x47, 0x8d, 0x40, 0x9d,
	0xe9, 0x4b, 0x18, 0x6a, 0x83, 0xa5, 0xb2, 0xf4, 0x40, 0x3a, 0x82, 0x18, 0x45, 0xc7, 0xe5, 0x03,
	0x24, 0x94, 0x81, 0x7e, 0x19, 0xfc, 0x82, 0x70, 0x21, 0x32, 0xc7, 0x86, 0xec, 0x7b, 0xf3, 0x41,
	0x2d, 0xab, 0x0a, 0xd1, 0x41, 0x98, 0x48, 0x03, 0xf4, 0xe1, 0x22, 0xa7, 0x96, 0x00, 0x39, 0x70,
	0x91, 0xa0, 0x52, 0xcb, 0x91, 0xc2, 0xa2, 0xc0, 0x8d, 0x03, 0xba, 0xc6, 0xfa, 0x0d, 0x94, 0x41,
	0x76, 0x2d, 0x6f, 0xb3, 0xd5, 0x22, 0x2d, 0xce, 0x72, 0x1e, 0xe2, 0x1c, 0x0e, 0x29, 0x6d, 0x05,
	0xe3, 0xc8, 0x9b, 0x48, 0xd4, 0x44, 0x44, 0x92, 0xcd, 0xc5, 0x92, 0x20, 0xc6, 0x77, 0x38, 0x72,
	0x50, 0x75, 0x00, 0x9d, 0x8f, 0xa6, 0x9f, 0x2a, 0x4d, 0xa4, 0xc5, 0x26, 0x16, 0x13, 0xcd, 0xdc,
	0x90, 0x06, 0xf2, 0xb8, 0x74, 0x48, 0xc6, 0x43, 0x32, 0x60, 0x51, 0xe4, 0x49, 0x31, 0x24, 0x6c,
	0x90, 0x10, 0x16, 0x23, 0xd2, 0x0f, 0x96, 0x36, 0x7b, 0x7c, 0x91, 0x03, 0xd8, 0x40, 0x55, 0xc8,
	0x4a, 0xd5, 0x38, 0xcb, 0x7e, 0x64, 0x64, 0xfc, 0x1b, 0x5e, 0xf1, 0x90, 0x5d, 0x05, 0x2d, 0x29,
	0x2c, 0xd2, 0x26, 0x1f, 0xdc, 0x80, 0xb7, 0x51, 0x5e, 0xab, 0x1e, 0x93, 0xf7, 0x4f, 0x51, 0x08,
	0x12, 0x08, 0x86, 0x8a, 0x5b, 0x6c, 0x95, 0x6a, 0xea, 0xdb, 0xd2, 0x3a, 0xa2, 0xaf, 0xba, 0xea,
	0xbb, 0x62, 0x21, 0xef, 0x28, 0x6d, 0x66, 0xaa, 0x29, 0x2c, 0xdc, 0x12, 0x0f, 0xd3, 0xba, 0xd1,
	0x56, 0x91, 0xbc, 0xd7, 0xae, 0xa6, 0x31, 0xe1, 0x46, 0x70, 0xe9, 0x05, 0xe2, 0x15, 0x60, 0x2b,
	0x20, 0xa1, 0x98, 0x47, 0xf4, 0xdb, 0xff, 0xdb, 0x2c, 0x2a, 0xd8, 0x3a, 0x84, 0xb0, 0x7a, 0xdc,
	0x43, 0xdf, 0xd3, 0x62, 0x70, 0x10, 0xd6, 0xa8, 0x38, 0x07, 0x53, 0x74, 0x41, 0x87, 0x00, 0xf1,
	0x3d, 0x64, 0x58, 0x23, 0x66, 0x4b, 0xa8, 0x03, 0x74, 0xf4, 0x5b, 0xdb, 0x77, 0xb7, 0x84, 0xcb,
	0x5d, 0x2d, 0xc9, 0xe4, 0x86, 0x78, 0x59, 0xd0, 0xc7, 0x99, 0xd3, 0xa1, 0xae, 0x55, 0xd8, 0xdd,
	0x32, 0x5e, 0x0f, 0x32, 0xb8, 0x21, 0xe1, 0x12, 0x31, 0x16, 0xb3, 0x88, 0x17, 0xa8, 0x90, 0xc7,
	0xc3, 0xf5, 0x62, 0xe9, 0x46, 0x5c, 0x83, 0xdd, 0x9c, 0xd2, 0x30, 0xb0, 0xff, 0x2a, 0x44, 0x6e,
	0xc9, 0x1b, 0xf9, 0x33, 0x10, 0x4f, 0x2e, 0x00, 0x29, 0x3c, 0x52, 0xc1, 0xf4, 0x07, 0x8b, 0x14,
	0x79, 0x15, 0x63, 0x07, 0x24, 0xa6, 0x8d, 0x45, 0xc6, 0x7c, 0xaa, 0x44, 0x6e, 0x19, 0xf1, 0x7d,
	0x11, 0x6c, 0x94, 0x25, 0xc4, 0xa8, 0x22, 0xcd, 0x10, 0x82, 0x34, 0xe8, 0xf9, 0x25, 0x85, 0x80,
	0x1c, 0x68, 0x73, 0xf8, 0x3c, 0x01, 0xec, 0x90, 0xba, 0x8a, 0x7f, 0x2d, 0x72, 0x1a, 0xed, 0x67,
	0x02, 0xa0, 0x1d, 0xc7, 0x03, 0xd0, 0x2b, 0x6b, 0xb6, 0x71, 0x8e, 0xb9, 0x02, 0x31, 0x70, 0x24,
	0x7b, 0x89, 0x65, 0x44, 0x20, 0xd1, 0x7e, 0x7d, 0x5d, 0xaf, 0xb1, 0x69, 0xa1, 0x92, 0x6e, 0xdc,
	0x52, 0x80, 0xb5, 0xd9, 0x66, 0x6e, 0xaa, 0x38, 0x4b, 0xa1, 0xf2, 0x2e, 0xe2, 0x4a, 0x42, 0x44,
	0x00, 0x5f, 0x8b, 0xbb, 0x08, 0xd9, 0xa8, 0xd2, 0xa3, 0x13, 0xa5, 0xfd, 0x1b, 0x51, 0x72, 0x24,
	0xf4, 0xd7, 0x15, 0xe9, 0x09, 0x74, 0x84, 0x7a, 0x26, 0x32, 0x41, 0xdf, 0x38, 0x29, 0x58, 0xbc,
	0x14, 0x0f, 0x2a, 0x91, 0x50, 0xed, 0xf8, 0xbd, 0xc8, 0xdf, 0xeb, 0x6f, 0xf6, 0x63, 0x3d, 0xc5,
	0xe8, 0x25, 0x17, 0x47, 0x12, 0xdc, 0x8b, 0x6c, 0x44, 0x23, 0x64, 0x8d, 0x33, 0x2b, 0x5c, 0xc6,
	0xa6, 0x57, 0xd2, 0x94, 0xd4, 0x47, 0x11, 0x07, 0x36, 0x6e, 0xc9, 0x56, 0x37, 0xd2, 0x76, 0xcd,
	0xfd, 0xd1, 0x40, 0xd6, 0x28, 0x71, 0x34, 0x7c, 0xe0, 0x5f, 0x5f, 0x36, 0xf4, 0xb1, 0x74, 0xdf,
	0x9f, 0xad, 0x96, 0x12, 0xec, 0x2f, 0x25, 0xd5, 0x3b, 0x8b, 0x27, 0x2c, 0xd6, 0x55, 0xd7, 0xe0,
	0x94, 0x7b, 0xbc, 0x19, 0x8c, 0x72, 0xda, 0x16, 0x41, 0x26, 0xe3, 0xf3, 0x79, 0xcb, 0xc1, 0x2f,
	0xa7, 0xf3, 0x6d, 0xb6, 0x5b, 0xf2, 0x22, 0xe4, 0x40, 0x19, 0xa4, 0x38, 0x3d, 0x05, 0x89, 0x41,
	0xa2, 0x96, 0x47, 0xcc, 0xea, 0x46, 0x13, 0xaa, 0x10, 0xa0, 0x4b, 0x9e, 0x56, 0xb0, 0x2a, 0x98,
	0x0e, 0x0e, 0x7f, 0x04, 0xd3, 0xbf, 0xca, 0x20, 0xa6, 0xec, 0x55, 0xcd, 0xdd, 0x32, 0x2b, 0x44,
	0x42, 0x0a, 0x0a, 0x66, 0x4d, 0xe9, 0x5e, 0x93, 0x72, 0xc7, 0x5a, 0xb1, 0x22, 0xfb, 0x6f, 0x1e,
	0xf6, 0x3d, 0x94, 0x54, 0x34, 0x96, 0x9f, 0xd2, 0x0d, 0x11, 0xc3, 0x99, 0xf8, 0x74, 0x68, 0x95,
	0x0d, 0xe7, 0x8a, 0xc0, 0xfe, 0xc9, 0xeb, 0x46, 0x82, 0x1b, 0x3f, 0x2d, 0x5c, 0x07, 0x2d, 0x22,
	0x55, 0x81, 0x6d, 0xb9, 0x24, 0x25, 0xe5, 0x1f, 0x52, 0x90, 0x8b, 0x60, 0x71, 0x74, 0x08, 0xa7,
	0xb3, 0x5b, 0xed, 0x29, 0xc4, 0x42, 0x21, 0x07, 0x6e, 0x39, 0xc9, 0x0e, 0xdc, 0xe2, 0x56, 0x98,
	0x69, 0xc9, 0x1a, 0x0e, 0xc8, 0xca, 0x44, 0x59, 0x50, 0x99, 0xa7, 0x9e, 0x4b, 0xbb, 0x8b, 0x74,
	0x75, 0x9a, 0xa1, 0xd8, 0x31, 0x07, 0xf2, 0x5d, 0x36, 0x3e, 0x53, 0x85, 0x84, 0x34, 0x38, 0x4d,
	0x13, 0x5f, 0x20, 0xac, 0xa6, 0x22, 0xaa, 0x42, 0x27, 0xba, 0x7b, 0x0b, 0x7d, 0xde, 0xa6, 0x0c,
	0x2a, 0x11, 0x8c, 0x21, 0x9a, 0xfc, 0x8a, 0x1c, 0xb6, 0x3e, 0x75, 0x42, 0xfd, 0x60, 0x1a, 0x5d,
	0xa5, 0xd4, 0x6a, 0x01, 0x54, 0x0a, 0x1f, 0x64, 0x9b, 0xc1, 0x02, 0xe8, 0xeb, 0x64, 0xad, 0xcd,
	0xe8, 0xda, 0x31, 0x51, 0xea, 0x44, 0x1d, 0x1a, 0xca, 0xa6, 0x04, 0xbb, 0xa3, 0x5e, 0x03, 0x1a,
	0xad, 0x26, 0x21, 0x34, 0xdb, 0xb8, 0x4e, 0xc9, 0xe3, 0x02, 0x8b, 0x12, 0x9e, 0x8f, 0x41, 0x22,
	0xf0, 0x5a, 0x36, 0xce, 0xdf, 0x2c, 0x8b, 0xb8, 0xd2, 0x78, 0x06, 0x35, 0x1f, 0x38, 0x06, 0xd4,
	0x10, 0x71, 0x0b, 0x2a, 0x15, 0xd9, 0x2d, 0x43, 0x81, 0x0d, 0xb0, 0xa8, 0xf7, 0x07, 0xb5, 0x4a,
	0xa6, 0x4b, 0xa5, 0x40, 0xe7, 0x99, 0x10, 0x81, 0x48, 0x0a, 0x55, 0xb1, 0xb7, 0xfe, 0x63, 0x95,
	0xfc, 0x02, 0xb0, 0xe3, 0xac, 0x02, 0xf5, 0x8a, 0x48, 0xef, 0x44, 0x40, 0xde, 0xae, 0x97, 0xd1,
	0x35, 0x39, 0x30, 0x85, 0x59, 0x22, 0x22, 0x2d, 0x0d, 0xf9, 0xba, 0x28, 0xa5, 0xfc, 0x8f, 0xd1,
	0xc8, 0x4d, 0xa0, 0x5e, 0x4d, 0x08, 0xf4, 0xaf, 0x7d, 0xb2, 0xf8, 0x4f, 0x0e, 0xc7, 0x16, 0x77,
	0x0c, 0x8d, 0x09, 0x2d, 0x17, 0xf1, 0x93, 0xbd, 0x1b, 0x79, 0xd6, 0x6c, 0x3f, 0xfa, 0x6f, 0xd8,
	0x96, 0x43, 0xfb, 0x5d, 0x40, 0x87, 0x3a, 0x4c, 0x27, 0xdd, 0x1f, 0xa7, 0xba, 0xa8, 0x59, 0x7c,
	0x7e, 0xcd, 0x1b, 0xc2, 0x94, 0x83, 0x9a, 0x1f, 0x93, 0x97, 0x53, 0x30, 0x89, 0x98, 0x8e, 0x5a,
	0xca, 0x19, 0xd0, 0x88, 0x86, 0xa5, 0x3b, 0x46, 0x91, 0x38, 0x49, 0xd9, 0xc3, 0xab, 0xc7, 0xb1,
	0x85, 0xa3, 0x0f, 0xf2, 0x24, 0xc8, 0x38, 0xbd, 0x19, 0xe1, 0xbe, 0xe1, 0xe3, 0xca, 0x20, 0x3a,
	0x5e, 0x8a, 0x68, 0x4f, 0x71, 0x6e, 0x7c, 0x09, 0x4d, 0x23, 0x99, 0xfd, 0x60, 0x9f, 0xc7, 0x18,
	0x80, 0xd5, 0x99, 0x59, 0xa7, 0x58, 0xe6, 0x55, 0x0e, 0x88, 0xb0, 0xe9, 0x76, 0xe5, 0x92, 0x35,
	0x42, 0x9a, 0x26, 0xf2, 0xdf, 0xe1, 0xa6, 0xfa, 0x84, 0xbc, 0xf0, 0x43, 0xd5, 0x75, 0xbd, 0x0c,
	0xb0, 0x6e, 0x8a, 0x16, 0xe3, 0x88, 0x7b, 0x42, 0x71, 0x28, 0x98, 0x9e, 0x44, 0xc4, 0x52, 0x88,
	0x75, 0x05, 0x2f, 0x06, 0x46, 0xc4, 0x5d, 0x60, 0xca, 0xcb, 0x8f, 0x79, 0x7f, 0x9e, 0x23, 0x86,
	0xf4, 0x5f, 0xee, 0xfb, 0x67, 0xa8, 0x3a, 0x8d, 0xc6, 0xe8, 0xcf, 0xb9, 0xf1, 0x0b, 0x2d, 0xb4,
	0x42, 0xb7, 0x8f, 0x24, 0x79, 0x8d, 0x40, 0x15, 0xbd, 0x1b, 0x9d, 0x67, 0xc2, 0x7b, 0xc3, 0x55,
	0xf2, 0x2b, 0x2b, 0xf1, 0x27, 0xe5, 0x25, 0x61, 0xc8, 0x4e, 0x8a, 0x52, 0x84, 0x94, 0x32, 0xd6,
	0x0a, 0x12, 0xd7, 0x96, 0x37, 0x7a, 0x4a, 0x65, 0x44, 0x34, 0x78, 0xc7, 0xb4, 0xd3, 0x78, 0xbf,
	0x7a, 0xcf, 0xd8, 0xc6, 0x5f, 0x2c, 0xeb, 0x81, 0x16, 0xc5, 0xcb, 0xb7, 0x7a, 0x65, 0x5c, 0xb5,
	0xa2, 0x1a, 0xd2, 0x90, 0xea, 0x5d, 0x3c, 0xe8, 0xa6, 0x27, 0x59, 0xb7, 0xaf, 0x5f, 0x17, 0x2b,
	0x49, 0x41, 0xf7, 0x12, 0x21, 0x5b, 0x10, 0x47, 0xc8, 0xf3, 0x63, 0xaa, 0xeb, 0xd3, 0x73, 0xd2,
	0x50, 0x8d, 0x4e, 0x6f, 0x31, 0x9f, 0x3e, 0xef, 0x85, 0x4e, 0x0c, 0xc8, 0x4d, 0x15, 0x82, 0x5a,
	0xbb, 0x42, 0xdc, 0x8d, 0xbd, 0x72, 0x0f, 0x75, 0xe4, 0x44, 0x5b, 0x43, 0x65, 0xa4, 0x5d, 0x1e,
	0x78, 0x46, 0x44, 0xcb, 0x83, 0xdb, 0x0d, 0xa8, 0xa6, 0xba, 0x38, 0xcd, 0x5c, 0xa1, 0x84, 0xa0,
	0x5d, 0x6b, 0x24, 0x27, 0x47, 0xc1, 0x3b, 0x94, 0xef, 0x3c, 0xe1, 0x39, 0x8c, 0x63, 0x05, 0x92,
	0xf1, 0xd6, 0x50, 0x51, 0x8c, 0x53, 0xaf, 0x44, 0xd0, 0xb1, 0x3f, 0xd8, 0x1d, 0x03, 0x65, 0x99,
	0x1f, 0x2a, 0x87, 0x80, 0x47, 0xc6, 0x70, 0xfd, 0x93, 0x96, 0xd8, 0x13, 0xb6, 0x47, 0x6a, 0xb2,
	0x65, 0x7a, 0x2e, 0x48, 0x3a, 0x51, 0xf3, 0x86, 0xb4, 0xd1, 0x17, 0x16, 0xcb, 0xe3, 0x6b, 0xcb,
	0x99, 0xbf, 0x7e, 0x81, 0x7d, 0x94, 0x0f, 0x9b, 0x09, 0x1d, 0xbe, 0xd0, 0xf2, 0xaa, 0xc0, 0x3f,
	0xe9, 0xe7, 0xb0, 0x4c, 0xb9, 0x9d, 0xb6, 0x1a, 0x00, 0x87, 0x48, 0xb7, 0x02, 0x0d, 0xba, 0x9a,
	0x2c, 0x1e, 0x13, 0xa6, 0x48, 0x23, 0x33, 0x84, 0x73, 0x1c, 0x27, 0x3e, 0x9a, 0x2f, 0xa8, 0x6e,
	0x45, 0x45, 0x2e, 0x48, 0xe0, 0xa0, 0xe2, 0x58, 0x05, 0x86, 0x3e, 0x7d, 0xe5, 0x81, 0x8b, 0x0b,
	0xae, 0x4d, 0xac, 0x21, 0x7d, 0x8e, 0x52, 0xb9, 0xb9, 0x75, 0x50, 0x07, 0xca, 0x4d, 0xc8, 0xe7,
	0x22, 0xa3, 0xcb, 0x56, 0x5b, 0x00, 0xc8, 0x48, 0x1e, 0x8f, 0x3d, 0x91, 0x1c, 0x33, 0x26, 0x45,
	0x81, 0x66, 0x07, 0xc6, 0x1a, 0x9b, 0xd3, 0x50, 0x3a, 0xd1, 0xa8, 0x60, 0xd0, 0x64, 0xed, 0xe6,
	0xc6, 0x78, 0x04, 0xe6, 0x8f, 0xa4, 0x5f, 0x4e, 0x40, 0x1b, 0xf3, 0x5c, 0x22, 0x94, 0x1e, 0xb1,
	0xb3, 0xd0, 0xe6, 0xe4, 0x2c, 0x0f, 0x6e, 0x1d, 0x61, 0x55, 0xfb, 0x49, 0xe0, 0xc0, 0x3a, 0x7b,
	0x33, 0x65, 0x84, 0xf6, 0x7a, 0xda, 0x24, 0x74, 0x17, 0x3d, 0x55, 0x03, 0xd6, 0xbc, 0x18, 0xda,
	0x72, 0x01, 0x25, 0xe0, 0x67, 0x54, 0x3f, 0x5b, 0x78, 0x00, 0xb4, 0xb1, 0xca, 0x6c, 0xe2, 0x81,
	0xad, 0x44, 0x5a, 0x84, 0x4e, 0x4d, 0x89, 0x7e, 0x92, 0x7e, 0x6e, 0xa0, 0x71, 0x1b, 0x26, 0x58,
	0x38, 0xee, 0x1c, 0x96, 0xfa, 0x67, 0x99, 0x53, 0x76, 0xe8, 0xa3, 0x28, 0x27, 0xfc, 0x2f, 0xdc,
	0x4d, 0x34, 0xac, 0x7e, 0xd0, 0x47, 0x7a, 0x7a, 0xac, 0xe7, 0x6a, 0x9b, 0x2c, 0x33, 0xa0, 0x9e,
	0x32, 0xaa, 0x33, 0xcc, 0x32, 0xb4, 0xac, 0x30, 0x28, 0xe3, 0x9e, 0xa7, 0x36, 0x5c, 0xde, 0x64,
	0xc9, 0x39, 0x6f, 0xfd, 0x15, 0x16, 0x58, 0x5e, 0xea, 0xcc, 0x40, 0xec, 0x88, 0xca, 0x3b, 0x0c,
	0xfb, 0x91, 0xb0, 0xb9, 0xb4, 0x78, 0xdf, 0x75, 0xd7, 0x0d, 0xf7, 0x96, 0xc5, 0x3b, 0x23, 0xfc,
	0x21, 0x79, 0x20, 0xe1, 0x39, 0x3e, 0xfc, 0x6b, 0xb7, 0x86, 0x9f, 0x81, 0x93, 0x81, 0x34, 0xba,
	0xc3, 0x02, 0x43, 0x3c, 0xdf, 0x1c, 0xa1, 0x53, 0xeb, 0xf8, 0x06, 0x8a, 0xc5, 0xe7, 0x5f, 0x36,
	0x8d, 0x4a, 0x0c, 0x5d, 0xc1, 0x3e, 0xaf, 0x56, 0xf3, 0xad, 0xfb, 0x15, 0x29, 0x83, 0x40, 0x68,
	0xb6, 0xe5, 0xea, 0xab, 0xe1, 0x06, 0x37, 0x62, 0x0e, 0x43, 0x31, 0xcb, 0xa3, 0x31, 0xf1, 0xff,
	0xd2, 0x0f, 0xfc, 0x42, 0x25, 0x92, 0x65, 0x33, 0x6b, 0x70, 0x45, 0xb0, 0xee, 0xdf, 0x9f, 0xdc,
	0xdb, 0x83, 0xb0, 0x09, 0xeb, 0x3d, 0xac, 0xb9, 0x7e, 0x9d, 0x17, 0x8c, 0xe4, 0x75, 0xa3, 0x50,
	0x26, 0x93, 0x81, 0x8b, 0xc4, 0x3e, 0xc6, 0x59, 0x80, 0xcd, 0x0d, 0xad, 0xe2, 0x43, 0xf2, 0xb3,
	0xfd, 0x50, 0x6f, 0xa3, 0x52, 0xec, 0x20, 0xea, 0xe2, 0x86, 0x8d, 0x3e, 0x8f, 0xcc, 0x87, 0x27,
	0x75, 0x73, 0x0e, 0xed, 0x2c, 0x25, 0xc3, 0x03, 0x19, 0xdf, 0xcf, 0xa1, 0xc2, 0x88, 0xed, 0x51,
	0x5d, 0x21, 0x9f, 0x25, 0xcf, 0xa0, 0xfa, 0xe3, 0x12, 0x13, 0x44, 0xb5, 0x99, 0x51, 0x63, 0xe0,
	0xc1, 0x86, 0x6d, 0xd9, 0x61, 0xaf, 0x3c, 0x25, 0x7b, 0xea, 0x09, 0x46, 0x0c, 0x2f, 0xbe, 0x9b,
	0xb6, 0x8f, 0x98, 0xf3, 0x70, 0x5b, 0x3e, 0xa3, 0xa0, 0x57, 0x77, 0xdd, 0x91, 0x48, 0xee, 0xb3,
	0x78, 0x01, 0x31, 0x99, 0xed, 0xd2, 0xa9, 0xc5, 0x4c, 0xb2, 0xbd, 0x7c, 0x7b, 0xe9, 0x4a, 0x65,
	0x0e, 0xb0, 0x3f, 0x7b, 0x95, 0x0d, 0x77, 0xb3, 0x55, 0x11, 0xff, 0xfb, 0xd6, 0x82, 0x09, 0xee,
	0x8f, 0x50, 0x76, 0x5f, 0x06, 0x57, 0xa2, 0xb6, 0xa1, 0x2f, 0x16, 0x2e, 0x0f, 0xef, 0x3c, 0x93,
	0x89, 0x24, 0x8d, 0x60, 0x91, 0x67, 0x98, 0x86, 0x43, 0x61, 0x7f, 0x60, 0x31, 0x7c, 0xa2, 0x4e,
	0x8e, 0xa0, 0xa2, 0x92, 0x47, 0x6f, 0x24, 0x5b, 0x14, 0x09, 0x15, 0xfb, 0xe5, 0x12, 0x37, 0x81,
	0x8d, 0xf7, 0x53, 0x5a, 0x15, 0xc1, 0x4f, 0xc5, 0x0a, 0x23, 0x3d, 0x44, 0x25, 0x8b, 0xa5, 0x7d,
	0xf7, 0xd2, 0xb7, 0x95, 0xc7, 0xf3, 0x4d, 0x2b, 0x18, 0xf0, 0x6f, 0x5e, 0x0a, 0xff, 0x9f, 0xb0,
	0xf5, 0x45, 0x35, 0x04, 0xc6, 0xc2, 0xab, 0x76, 0xbb, 0x35, 0xd3, 0x1a, 0xe6, 0x2b, 0x9f, 0xee,
	0xa8, 0x74, 0x09, 0x7e, 0x7b, 0x5b, 0x4e, 0xc6, 0x65, 0x90, 0x1f, 0x67, 0x70, 0x42, 0xae, 0x37,
	0xe3, 0x27, 0xc0, 0x0e, 0xeb, 0x4a, 0xe4, 0x58, 0x17, 0x87, 0x09, 0xba, 0xc3, 0xa1, 0x96, 0x3a,
	0x9e, 0x47, 0xfa, 0xc2, 0xcf, 0x70, 0x6f, 0x79, 0x4c, 0xe6, 0xcd, 0x73, 0x8c, 0x07, 0x9c, 0xe9,
	0x91, 0x08, 0x55, 0x08, 0x2f, 0x44, 0x08, 0x36, 0x9d, 0x91, 0x4d, 0x35, 0xaf, 0x2b, 0x99, 0x5d,
	0x2a, 0xdd, 0xf3, 0x47, 0xcf, 0xc2, 0x7b, 0x03, 0xea, 0x24, 0x6c, 0x86, 0x73, 0x64, 0xd7, 0x95,
	0xf9, 0x31, 0x6c, 0x86, 0x7e, 0xd8, 0x4d, 0x21, 0xdb, 0x9b, 0xcb, 0x22, 0x1c, 0xa4, 0x97, 0xbb,
	0x1b, 0x80, 0x75, 0x9f, 0xda, 0x2e, 0xad, 0xed, 0x87, 0x6a, 0x21, 0xfa, 0x38, 0x7f, 0x28, 0x71,
	0x44, 0xa9, 0x56, 0x4c, 0x36, 0x3c, 0x8c, 0xb4, 0xd0, 0x01, 0xe6, 0xf1, 0x07, 0x36, 0x14, 0xba,
	0xd5, 0xf7, 0xfc, 0x1e, 0x36, 0x44, 0x1f, 0x45, 0xa3, 0x0b, 0x84, 0xde, 0x8a, 0xb7, 0xa4, 0x93,
	0x4f, 0x64, 0x28, 0xa5, 0xce, 0x62, 0x5e, 0xef, 0x6c, 0xe6, 0xfd, 0x25, 0x99, 0x96, 0x8f, 0x7d,
	0x53, 0x8d, 0x25, 0x4e, 0x13, 0xfb, 0xe7, 0xef, 0xbc, 0x46, 0x74, 0x20, 0x43, 0x9f, 0xc3, 0x7d,
	0x5d, 0xdc, 0xd3, 0x96, 0x63, 0xe1, 0x10, 0xa1, 0xcc, 0x2c, 0x77, 0xd3, 0xf0, 0xed, 0x59, 0x28,
	0xd6, 0x2f, 0x07, 0x8d, 0x07, 0x54, 0xe1, 0x89, 0xb4, 0x73, 0x6e, 0x2d, 0x9e, 0xec, 0xb5, 0x9f,
	0x38, 0xaa, 0x29, 0xce, 0x49, 0x0a, 0x62, 0x5e, 0x0b, 0x3e, 0xac, 0x6f, 0xc0, 0xe2, 0x15, 0x53,
	0x41, 0x99, 0x75, 0xbb, 0xf5, 0x21, 0x77, 0xc7, 0x31, 0xb4, 0xcb, 0xca, 0xfd, 0x1a, 0xeb, 0x84,
	0x1f, 0xed, 0x17, 0xb0, 0x5f, 0x60, 0x69, 0x36, 0xc7, 0x30, 0x84, 0xf2, 0x92, 0x3b, 0x1a, 0x46,
	0xc6, 0xa3, 0x12, 0x9d, 0xb7, 0x0c, 0xfa, 0xd1, 0x33, 0x65, 0x0a, 0x72, 0x07, 0x46, 0x71, 0xbd,
	0x3f, 0x91, 0xf3, 0x26, 0xda, 0x87, 0x9a, 0xfd, 0x30, 0x86, 0x04, 0xbe, 0x5b, 0x25, 0x53, 0x37,
	0xef, 0xed, 0x22, 0x3a, 0xcf, 0xc6, 0xc5, 0x65, 0xe6, 0x58, 0x11, 0xaa, 0x0f, 0xe8, 0x84, 0x22,
	0x05, 0xe3, 0x7f, 0x6b, 0x13, 0xc8, 0x4c, 0x46, 0x81, 0xe2, 0x62, 0x37, 0x63, 0x13, 0xcb, 0x22,
	0x8d, 0x91, 0x68, 0xcf, 0xe9, 0xf5, 0x1f, 0x5a, 0x51, 0x8a, 0x29, 0x14, 0xdd, 0x51, 0xe3, 0xd4,
	0x3d, 0xfd, 0x09, 0xd6, 0x98, 0x4c, 0xee, 0xb6, 0x34, 0xc2, 0x46, 0xc5, 0xc2, 0xe2, 0xb2, 0xd4,
	0xa1, 0xc6, 0x71, 0xbf, 0xca, 0x97, 0x6c, 0x4c, 0xe8, 0x86, 0x31, 0x9f, 0x28, 0x31, 0x16, 0x6b,
	0xb7, 0x3e, 0x74, 0x14, 0xfd, 0x0a, 0x93, 0x45, 0x0c, 0xdb, 0xca, 0x5b, 0x6a, 0x4c, 0xb3, 0xb1,
	0x5c, 0x0a, 0x86, 0x14, 0xa7, 0x6b, 0x2a, 0x0a, 0xb7, 0x75, 0xb6, 0x93, 0x53, 0x51, 0x7a, 0xec,
	0xa2, 0x0e, 0xb2, 0xe7, 0x21, 0x54, 0x91, 0x3b, 0xdf, 0xcb, 0x63, 0x51, 0x29, 0x62, 0x28, 0x4e,
	0x76, 0xa1, 0xa7, 0xdd, 0x37, 0x94, 0xde, 0x6f, 0x75, 0x4a, 0xb5, 0x22, 0x88, 0x11, 0xd5, 0x7c,
	0x44, 0xa6, 0x43, 0x6e, 0x7f, 0x18, 0xed, 0x8d, 0x4f, 0x2a, 0x74, 0x99, 0x11, 0x13, 0xe6, 0x0d,
	0xa6, 0xfa, 0x77, 0x1d, 0xa5, 0x5a, 0x49, 0x01, 0x16, 0x2d, 0x2a, 0x57, 0xfc, 0x13, 0xe2, 0xc3,
	0xe0, 0x17, 0xa3, 0x57, 0xea, 0xb2, 0x5b, 0x1b, 0x9c, 0xce, 0x7b, 0xd2, 0x12, 0xf3, 0x54, 0xdf,
	0x38, 0x1a, 0x54, 0x7c, 0xbc, 0x07, 0x7e, 0xe6, 0xc8, 0xf6, 0x6e, 0x15, 0x17, 0x93, 0x4e, 0xf9,
	0xcb, 0xee, 0xa1, 0xb1, 0x89, 0xa4, 0xa4, 0xf5, 0xb3, 0x07, 0xdc, 0x16, 0xf1, 0x08, 0x4c, 0xd8,
	0xff, 0xbf, 0xe8, 0xaa, 0xf1, 0xe2, 0x07, 0xe8, 0xca, 0x0c, 0xd8, 0x7e, 0x4e, 0x74, 0xf1, 0x91,
	0x05, 0xa5, 0x3f, 0x21, 0x77, 0x33, 0x97, 0x10, 0x6d, 0xc3, 0xf6, 0xab, 0x2d, 0xcc, 0xf0, 0x3d,
	0x83, 0x32, 0x1a, 0xc4, 0xbc, 0x86, 0xdb, 0x78, 0xf7, 0x02, 0x2e, 0x43, 0x5d, 0x3e, 0x55, 0x44,
	0x8a, 0x88, 0x09, 0xe7, 0x3f, 0xc5, 0x03, 0xfe, 0xe9, 0xff, 0xf0, 0xae, 0xf6, 0x93, 0xd8, 0xc7,
	0x3e, 0x3f, 0x04, 0x82, 0xa6, 0x4f, 0x1a, 0x4e, 0x19, 0x75, 0x82, 0x8e, 0x27, 0xfd, 0x46, 0x03,
	0x09, 0x50, 0x8d, 0x24, 0xdb, 0xd7, 0xd4, 0xdf, 0x3c, 0x35, 0xd7, 0xec, 0x3c, 0xba, 0x83, 0x0a,
	0x66, 0x60, 0xca, 0x93, 0x37, 0x66, 0x19, 0xca, 0x9f, 0x41, 0xac, 0x0c, 0x73, 0x1d, 0xd5, 0x9a,
	0x30, 0x38, 0x3b, 0x59, 0x4c, 0xc3, 0xcc, 0x67, 0x13, 0xf1, 0x02, 0x30, 0x0c, 0xa8, 0x6f, 0x93,
	0x5b, 0x06, 0x82, 0x2e, 0x24, 0x10, 0x27, 0x54, 0xa6, 0x5f, 0x0c, 0x03, 0x1a, 0xa3, 0x9b, 0xc6,
	0x8e, 0x33, 0x92, 0x32, 0x33, 0xcb, 0xb2, 0x62, 0xe9, 0x19, 0xf2, 0x9b, 0xdd, 0x36, 0xaa, 0x67,
	0x19, 0xd3, 0x39, 0x47, 0x9c, 0x6c, 0x22, 0x46, 0x08, 0x7e, 0x94, 0x83, 0x7b, 0x52, 0xbc, 0xfe,
	0x46, 0xd2, 0x9e, 0x17, 0x24, 0x04, 0xa6, 0xca, 0x83, 0x6a, 0xb6, 0x88, 0x65, 0x36, 0x48, 0x2e,
	0x4c, 0xc8, 0x6d, 0xa7, 0xf9, 0xc9, 0x3c, 0xc2, 0xd2, 0x2f, 0xe0, 0x14, 0xed, 0x38, 0x51, 0xdd,
	0xea, 0x36, 0x56, 0xbe, 0x79, 0x03, 0x51, 0x22, 0x03, 0xae, 0x65, 0x60, 0xb7, 0x82, 0x86, 0x46,
	0x27, 0xf1, 0x7b, 0x91, 0xea, 0xc6, 0x59, 0x29, 0x43, 0x23, 0x1b, 0xa6, 0x7a, 0x14, 0x35, 0x8a,
	0x44, 0xd6, 0xde, 0xc8, 0x17, 0x43, 0x5f, 0x0f, 0xc4, 0x71, 0x11, 0xe5, 0xec, 0x21, 0x7f, 0x41,
	0xa2, 0xc6, 0x03, 0x28, 0x98, 0x7e, 0x45, 0xac, 0x30, 0x91, 0xee, 0x65, 0x8d, 0x04, 0xef, 0x18,
	0x8e, 0xbc, 0x3a, 0x21, 0x6e, 0xfb, 0xeb, 0x89, 0x2b, 0xc1, 0x35, 0x34, 0x90, 0x6d, 0x87, 0xa0,
	0xa2, 0x99, 0xed, 0x41, 0x66, 0x02, 0xd4, 0x04, 0x6c, 0xa2, 0x75, 0xb3, 0x11, 0x00, 0xd9, 0xaa,
	0x7a, 0x30, 0x82, 0x3a, 0x1a, 0x64, 0x4f, 0x5e, 0x1b, 0xbe, 0x82, 0xa0, 0xc7, 0x2c, 0xda, 0x8e,
	0x74, 0x06, 0x81, 0x7b, 0x77, 0xde, 0x12, 0xaf, 0x69, 0x21, 0x43, 0x3d, 0xd1, 0x96, 0xc9, 0x1c,
	0xb5, 0x8e, 0x42, 0x5c, 0x43, 0x8a, 0x7e, 0xbe, 0xba, 0xb0, 0x1e, 0x76, 0x8f, 0xe9, 0x34, 0xdb,
	0x43, 0x37, 0x05, 0x32, 0x2f, 0xea, 0xca, 0x2d, 0x11, 0x65, 0x1d, 0xa9, 0xd6, 0xe1, 0x9c, 0x6b,
	0x40, 0x16, 0x3a, 0x48, 0xa6, 0x38, 0xa5, 0x96, 0x18, 0x71, 0xc0, 0xcd, 0xb1, 0xf3, 0xa0, 0x3c,
	0x14, 0x18, 0x80, 0x78, 0x38, 0xa4, 0x3b, 0x37, 0x6c, 0x08, 0xaa, 0x5a, 0xdc, 0xe8, 0x72, 0x8e,
	0xc3, 0x15, 0x61, 0x28, 0x6e, 0xcf, 0x8f, 0xae, 0xb6, 0xdf, 0x00, 0xe7, 0xfc, 0x06, 0xcf, 0x5c,
	0xb0, 0x3d, 0x8b, 0x1d, 0x0a, 0x10, 0xa2, 0xb7, 0x71, 0x94, 0x9d, 0xe2, 0x5a, 0x28, 0x50, 0x9a,
	0xd8, 0x52, 0x7c, 0x48, 0x80, 0x4f, 0x21, 0xcb, 0x30, 0x4a, 0x87, 0x2c, 0xf0, 0x96, 0xe3, 0xd7,
	0xc8, 0xd4, 0xa6, 0x0c, 0x14, 0xa0, 0x43, 0xbe, 0x68, 0xfd, 0x0a, 0x67, 0x42, 0xdd, 0xfa, 0x4d,
	0x78, 0x09, 0xb8, 0x65, 0x31, 0xcc, 0x8d, 0x07, 0xfa, 0xec, 0x08, 0x75, 0x82, 0x50, 0x22, 0xdd,
	0xa0, 0xc2, 0x46, 0xa5, 0xc1, 0x41, 0x24, 0xc4, 0xe8, 0x16, 0x44, 0xb5, 0x92, 0xd4, 0xc5, 0x44,
	0xd3, 0x94, 0xa4, 0x5f, 0x00, 0x00 };

#if defined( __GNUC__ ) && !defined( LIBFSNTFS_DLL_IMPORT )

/* Tests the libfsntfs_compressed_data_handle_initialize function
 * Returns 1 if successful or 0 if not
 */
int fsntfs_test_compressed_data_handle_initialize(
     void )
{
	libcerror_error_t *error                                   = NULL;
	libfdata_stream_t *compressed_data_stream                  = NULL;
	libfsntfs_compressed_data_handle_t *compressed_data_handle = NULL;
	int result                                                 = 0;

#if defined( HAVE_FSNTFS_TEST_MEMORY )
	int number_of_malloc_fail_tests                            = 3;
	int number_of_memset_fail_tests                            = 1;
	int test_number                                            = 0;
#endif

	/* Initialize test
	 */
	result = libfsntfs_cluster_block_stream_initialize_from_data(
	          &compressed_data_stream,
	          fsntfs_test_compressed_data_handle_lzxpress_huffman_compressed_data1,
	          3414,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_stream",
	 compressed_data_stream );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          compressed_data_stream,
	          2,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	compressed_data_stream = NULL;

	result = libfsntfs_compressed_data_handle_free(
	          &compressed_data_handle,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Initialize test
	 */
	result = libfsntfs_cluster_block_stream_initialize_from_data(
	          &compressed_data_stream,
	          fsntfs_test_compressed_data_handle_lzxpress_huffman_compressed_data1,
	          3414,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_stream",
	 compressed_data_stream );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libfsntfs_compressed_data_handle_initialize(
	          NULL,
	          compressed_data_stream,
	          2,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	compressed_data_handle = (libfsntfs_compressed_data_handle_t *) 0x12345678UL;

	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          compressed_data_stream,
	          2,
	          7638,
	          &error );

	compressed_data_handle = NULL;

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          NULL,
	          2,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          compressed_data_stream,
	          (uint32_t) -1,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

#if defined( HAVE_FSNTFS_TEST_MEMORY )

	for( test_number = 0;
	     test_number < number_of_malloc_fail_tests;
	     test_number++ )
	{
		/* Test libfsntfs_compressed_data_handle_initialize with malloc failing
		 */
		fsntfs_test_malloc_attempts_before_fail = test_number;

		result = libfsntfs_compressed_data_handle_initialize(
		          &compressed_data_handle,
		          compressed_data_stream,
		          2,
		          7638,
		          &error );

		if( fsntfs_test_malloc_attempts_before_fail != -1 )
		{
			fsntfs_test_malloc_attempts_before_fail = -1;

			if( compressed_data_handle != NULL )
			{
				compressed_data_handle->compressed_data_stream = NULL;

				libfsntfs_compressed_data_handle_free(
				 &compressed_data_handle,
				 NULL );
			}
		}
		else
		{
			FSNTFS_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			FSNTFS_TEST_ASSERT_IS_NULL(
			 "compressed_data_handle",
			 compressed_data_handle );

			FSNTFS_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
	for( test_number = 0;
	     test_number < number_of_memset_fail_tests;
	     test_number++ )
	{
		/* Test libfsntfs_compressed_data_handle_initialize with memset failing
		 */
		fsntfs_test_memset_attempts_before_fail = test_number;

		result = libfsntfs_compressed_data_handle_initialize(
		          &compressed_data_handle,
		          compressed_data_stream,
		          2,
		          7638,
		          &error );

		if( fsntfs_test_memset_attempts_before_fail != -1 )
		{
			fsntfs_test_memset_attempts_before_fail = -1;

			if( compressed_data_handle != NULL )
			{
				compressed_data_handle->compressed_data_stream = NULL;

				libfsntfs_compressed_data_handle_free(
				 &compressed_data_handle,
				 NULL );
			}
		}
		else
		{
			FSNTFS_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			FSNTFS_TEST_ASSERT_IS_NULL(
			 "compressed_data_handle",
			 compressed_data_handle );

			FSNTFS_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
#endif /* defined( HAVE_FSNTFS_TEST_MEMORY ) */

	/* Clean up
	 */
	result = libfsntfs_compressed_data_handle_free(
	          &compressed_data_handle,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfdata_stream_free(
	          &compressed_data_stream,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "compressed_data_stream",
	 compressed_data_stream );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( compressed_data_handle != NULL )
	{
		libfsntfs_compressed_data_handle_free(
		 &compressed_data_handle,
		 NULL );
	}
	if( compressed_data_stream != NULL )
	{
		libfdata_stream_free(
		 &compressed_data_stream,
		 NULL );
	}
	return( 0 );
}

/* Tests the libfsntfs_compressed_data_handle_free function
 * Returns 1 if successful or 0 if not
 */
int fsntfs_test_compressed_data_handle_free(
     void )
{
	libcerror_error_t *error = NULL;
	int result               = 0;

	/* Test error cases
	 */
	result = libfsntfs_compressed_data_handle_free(
	          NULL,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libfsntfs_compressed_data_handle_get_compressed_block_offsets function
 * Returns 1 if successful or 0 if not
 */
int fsntfs_test_compressed_data_handle_get_compressed_block_offsets(
     void )
{
	libcerror_error_t *error                                   = NULL;
	libfdata_stream_t *compressed_data_stream                  = NULL;
	libfsntfs_compressed_data_handle_t *compressed_data_handle = NULL;
	int result                                                 = 0;

	/* Initialize test
	 */
	result = libfsntfs_cluster_block_stream_initialize_from_data(
	          &compressed_data_stream,
	          fsntfs_test_compressed_data_handle_lzxpress_huffman_compressed_data1,
	          3414,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_stream",
	 compressed_data_stream );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          compressed_data_stream,
	          2,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	compressed_data_stream = NULL;

	/* Test regular cases
	 */
	result = libfsntfs_compressed_data_handle_get_compressed_block_offsets(
	          compressed_data_handle,
	          NULL,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libfsntfs_compressed_data_handle_get_compressed_block_offsets(
	          NULL,
	          NULL,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libfsntfs_compressed_data_handle_free(
	          &compressed_data_handle,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( compressed_data_handle != NULL )
	{
		libfsntfs_compressed_data_handle_free(
		 &compressed_data_handle,
		 NULL );
	}
	if( compressed_data_stream != NULL )
	{
		libfdata_stream_free(
		 &compressed_data_stream,
		 NULL );
	}
	return( 0 );
}

/* Tests the libfsntfs_compressed_data_handle_read_segment_data function
 * Returns 1 if successful or 0 if not
 */
int fsntfs_test_compressed_data_handle_read_segment_data(
     void )
{
	uint8_t segment_data[ 16 ];

	uint8_t expected_segment_data1[ 12 ] = {
		0x09, 0x09, 0x20, 0x20, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x45, 0x53 };

	libcerror_error_t *error                                   = NULL;
	libfdata_stream_t *compressed_data_stream                  = NULL;
	libfsntfs_compressed_data_handle_t *compressed_data_handle = NULL;
	ssize_t read_count                                         = 0;
	int result                                                 = 0;

	/* Initialize test
	 */
	result = libfsntfs_cluster_block_stream_initialize_from_data(
	          &compressed_data_stream,
	          fsntfs_test_compressed_data_handle_lzxpress_huffman_compressed_data1,
	          3414,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_stream",
	 compressed_data_stream );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          compressed_data_stream,
	          2,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	compressed_data_stream = NULL;

	/* Test regular cases
	 */
	read_count = libfsntfs_compressed_data_handle_read_segment_data(
	              compressed_data_handle,
	              NULL,
	              0,
	              0,
	              segment_data,
	              12,
	              0,
	              0,
	              &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT64(
	 "read_count",
	 read_count,
	 (ssize_t) 12 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = memory_compare(
	          segment_data,
	          expected_segment_data1,
	          12 );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 0 );

	/* Test error cases
	 */
	read_count = libfsntfs_compressed_data_handle_read_segment_data(
	              NULL,
	              NULL,
	              0,
	              0,
	              segment_data,
	              16,
	              0,
	              0,
	              &error );

	FSNTFS_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	read_count = libfsntfs_compressed_data_handle_read_segment_data(
	              compressed_data_handle,
	              NULL,
	              -1,
	              0,
	              segment_data,
	              16,
	              0,
	              0,
	              &error );

	FSNTFS_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	read_count = libfsntfs_compressed_data_handle_read_segment_data(
	              compressed_data_handle,
	              NULL,
	              0,
	              0,
	              NULL,
	              16,
	              0,
	              0,
	              &error );

	FSNTFS_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	read_count = libfsntfs_compressed_data_handle_read_segment_data(
	              compressed_data_handle,
	              NULL,
	              0,
	              0,
	              segment_data,
	              (size_t) SSIZE_MAX + 1,
	              0,
	              0,
	              &error );

	FSNTFS_TEST_ASSERT_EQUAL_SSIZE(
	 "read_count",
	 read_count,
	 (ssize_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libfsntfs_compressed_data_handle_free(
	          &compressed_data_handle,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( compressed_data_handle != NULL )
	{
		libfsntfs_compressed_data_handle_free(
		 &compressed_data_handle,
		 NULL );
	}
	if( compressed_data_stream != NULL )
	{
		libfdata_stream_free(
		 &compressed_data_stream,
		 NULL );
	}
	return( 0 );
}

/* Tests the libfsntfs_compressed_data_handle_seek_segment_offset function
 * Returns 1 if successful or 0 if not
 */
int fsntfs_test_compressed_data_handle_seek_segment_offset(
     void )
{
	libcerror_error_t *error                                   = NULL;
	libfdata_stream_t *compressed_data_stream                  = NULL;
	libfsntfs_compressed_data_handle_t *compressed_data_handle = NULL;
	off64_t offset                                             = 0;
	int result                                                 = 0;

	/* Initialize test
	 */
	result = libfsntfs_cluster_block_stream_initialize_from_data(
	          &compressed_data_stream,
	          fsntfs_test_compressed_data_handle_lzxpress_huffman_compressed_data1,
	          3414,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_stream",
	 compressed_data_stream );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfsntfs_compressed_data_handle_initialize(
	          &compressed_data_handle,
	          compressed_data_stream,
	          2,
	          7638,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	compressed_data_stream = NULL;

	/* Test regular cases
	 */
	offset = libfsntfs_compressed_data_handle_seek_segment_offset(
	          compressed_data_handle,
	          NULL,
	          0,
	          0,
	          0,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT64(
	 "offset",
	 offset,
	 (int64_t) 0 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	offset = libfsntfs_compressed_data_handle_seek_segment_offset(
	          NULL,
	          NULL,
	          0,
	          0,
	          0,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT64(
	 "offset",
	 offset,
	 (int64_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	offset = libfsntfs_compressed_data_handle_seek_segment_offset(
	          compressed_data_handle,
	          NULL,
	          -1,
	          0,
	          0,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT64(
	 "offset",
	 offset,
	 (int64_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	offset = libfsntfs_compressed_data_handle_seek_segment_offset(
	          compressed_data_handle,
	          NULL,
	          0,
	          0,
	          -1,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT64(
	 "offset",
	 offset,
	 (int64_t) -1 );

	FSNTFS_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libfsntfs_compressed_data_handle_free(
	          &compressed_data_handle,
	          &error );

	FSNTFS_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "compressed_data_handle",
	 compressed_data_handle );

	FSNTFS_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( compressed_data_handle != NULL )
	{
		libfsntfs_compressed_data_handle_free(
		 &compressed_data_handle,
		 NULL );
	}
	if( compressed_data_stream != NULL )
	{
		libfdata_stream_free(
		 &compressed_data_stream,
		 NULL );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBFSNTFS_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc FSNTFS_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] FSNTFS_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc FSNTFS_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] FSNTFS_TEST_ATTRIBUTE_UNUSED )
#endif
{
	FSNTFS_TEST_UNREFERENCED_PARAMETER( argc )
	FSNTFS_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( HAVE_DEBUG_OUTPUT ) && defined( FSNTFS_TEST_COMPRESSED_DATA_HANDLE_VERBOSE )
	libfsntfs_notify_set_verbose(
	 1 );
	libfsntfs_notify_set_stream(
	 stderr,
	 NULL );
#endif

#if defined( __GNUC__ ) && !defined( LIBFSNTFS_DLL_IMPORT )

	FSNTFS_TEST_RUN(
	 "libfsntfs_compressed_data_handle_initialize",
	 fsntfs_test_compressed_data_handle_initialize );

	FSNTFS_TEST_RUN(
	 "libfsntfs_compressed_data_handle_free",
	 fsntfs_test_compressed_data_handle_free );

	FSNTFS_TEST_RUN(
	 "libfsntfs_compressed_data_handle_get_compressed_block_offsets",
	 fsntfs_test_compressed_data_handle_get_compressed_block_offsets );

	FSNTFS_TEST_RUN(
	 "libfsntfs_compressed_data_handle_read_segment_data",
	 fsntfs_test_compressed_data_handle_read_segment_data );

	FSNTFS_TEST_RUN(
	 "libfsntfs_compressed_data_handle_seek_segment_offset",
	 fsntfs_test_compressed_data_handle_seek_segment_offset );

#endif /* defined( __GNUC__ ) && !defined( LIBFSNTFS_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

on_error:
	return( EXIT_FAILURE );
}

