/**
 * BuildSpec for CodeBuild projects.
 *
 * @stability stable
 */
export declare abstract class BuildSpec {
    /**
     * @stability stable
     */
    static fromObject(value: {
        [key: string]: any;
    }): BuildSpec;
    /**
     * Create a buildspec from an object that will be rendered as YAML in the resulting CloudFormation template.
     *
     * @param value the object containing the buildspec that will be rendered as YAML.
     * @stability stable
     */
    static fromObjectToYaml(value: {
        [key: string]: any;
    }): BuildSpec;
    /**
     * Use a file from the source as buildspec.
     *
     * Use this if you want to use a file different from 'buildspec.yml'`
     *
     * @stability stable
     */
    static fromSourceFilename(filename: string): BuildSpec;
    /**
     * Whether the buildspec is directly available or deferred until build-time.
     *
     * @stability stable
     */
    abstract readonly isImmediate: boolean;
    /**
     * @stability stable
     */
    protected constructor();
    /**
     * Render the represented BuildSpec.
     *
     * @stability stable
     */
    abstract toBuildSpec(): string;
}
/**
 * Merge two buildspecs into a new BuildSpec by doing a deep merge
 *
 * We decided to disallow merging of artifact specs, which is
 * actually impossible since we can't merge two buildspecs with a
 * single primary output into a buildspec with multiple outputs.
 * In case of multiple outputs they must have identifiers but we won't have that information.
 *
 * In case of test reports we replace the whole object with the RHS (instead of recursively merging)
*/
export declare function mergeBuildSpecs(lhs: BuildSpec, rhs: BuildSpec): BuildSpec;
