# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 0.5.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ExtensionMetadataContainer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'num_results': 'int',
        'filter_params': 'ExtensionFilterParams',
        'extensions': 'list[ExtensionMetadata]'
    }

    attribute_map = {
        'num_results': 'numResults',
        'filter_params': 'filterParams',
        'extensions': 'extensions'
    }

    def __init__(self, num_results=None, filter_params=None, extensions=None):
        """
        ExtensionMetadataContainer - a model defined in Swagger
        """

        self._num_results = None
        self._filter_params = None
        self._extensions = None

        if num_results is not None:
          self.num_results = num_results
        if filter_params is not None:
          self.filter_params = filter_params
        if extensions is not None:
          self.extensions = extensions

    @property
    def num_results(self):
        """
        Gets the num_results of this ExtensionMetadataContainer.
        The number of extensions in the response

        :return: The num_results of this ExtensionMetadataContainer.
        :rtype: int
        """
        return self._num_results

    @num_results.setter
    def num_results(self, num_results):
        """
        Sets the num_results of this ExtensionMetadataContainer.
        The number of extensions in the response

        :param num_results: The num_results of this ExtensionMetadataContainer.
        :type: int
        """

        self._num_results = num_results

    @property
    def filter_params(self):
        """
        Gets the filter_params of this ExtensionMetadataContainer.
        The filter parameters submitted for the request

        :return: The filter_params of this ExtensionMetadataContainer.
        :rtype: ExtensionFilterParams
        """
        return self._filter_params

    @filter_params.setter
    def filter_params(self, filter_params):
        """
        Sets the filter_params of this ExtensionMetadataContainer.
        The filter parameters submitted for the request

        :param filter_params: The filter_params of this ExtensionMetadataContainer.
        :type: ExtensionFilterParams
        """

        self._filter_params = filter_params

    @property
    def extensions(self):
        """
        Gets the extensions of this ExtensionMetadataContainer.
        The metadata for the extensions

        :return: The extensions of this ExtensionMetadataContainer.
        :rtype: list[ExtensionMetadata]
        """
        return self._extensions

    @extensions.setter
    def extensions(self, extensions):
        """
        Sets the extensions of this ExtensionMetadataContainer.
        The metadata for the extensions

        :param extensions: The extensions of this ExtensionMetadataContainer.
        :type: list[ExtensionMetadata]
        """

        self._extensions = extensions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ExtensionMetadataContainer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
