# coding: utf-8

"""
    Apache NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OpenAPI spec version: 0.5.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class BundlesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_bundle_version_extension_additional_details_docs(self, bundle_id, version, name, **kwargs):
        """
        Get bundle version extension docs details
        Gets the additional details documentation for the given extension in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundle_version_extension_additional_details_docs(bundle_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bundle_version_extension_additional_details_docs_with_http_info(bundle_id, version, name, **kwargs)
        else:
            (data) = self.get_bundle_version_extension_additional_details_docs_with_http_info(bundle_id, version, name, **kwargs)
            return data

    def get_bundle_version_extension_additional_details_docs_with_http_info(self, bundle_id, version, name, **kwargs):
        """
        Get bundle version extension docs details
        Gets the additional details documentation for the given extension in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundle_version_extension_additional_details_docs_with_http_info(bundle_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_version_extension_additional_details_docs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `get_bundle_version_extension_additional_details_docs`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_bundle_version_extension_additional_details_docs`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_bundle_version_extension_additional_details_docs`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/html'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}/extensions/{name}/docs/additional-details', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bundle_version_extension_docs(self, bundle_id, version, name, **kwargs):
        """
        Get bundle version extension docs
        Gets the documentation for the given extension in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundle_version_extension_docs(bundle_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bundle_version_extension_docs_with_http_info(bundle_id, version, name, **kwargs)
        else:
            (data) = self.get_bundle_version_extension_docs_with_http_info(bundle_id, version, name, **kwargs)
            return data

    def get_bundle_version_extension_docs_with_http_info(self, bundle_id, version, name, **kwargs):
        """
        Get bundle version extension docs
        Gets the documentation for the given extension in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundle_version_extension_docs_with_http_info(bundle_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :param str name: The fully qualified name of the extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_version_extension_docs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `get_bundle_version_extension_docs`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_bundle_version_extension_docs`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_bundle_version_extension_docs`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/html'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}/extensions/{name}/docs', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bundle_versions(self, **kwargs):
        """
        Get all bundle versions
        Gets the metadata about extension bundle versions across all authorized buckets with optional filters applied. If the user is not authorized to any buckets, an empty list will be returned.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundle_versions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: Optional groupId to filter results. The value may be an exact match, or a wildcard, such as 'com.%' to select all bundle versions where the groupId starts with 'com.'.
        :param str artifact_id: Optional artifactId to filter results. The value may be an exact match, or a wildcard, such as 'nifi-%' to select all bundle versions where the artifactId starts with 'nifi-'.
        :param str version: Optional version to filter results. The value maye be an exact match, or a wildcard, such as '1.0.%' to select all bundle versions where the version starts with '1.0.'.
        :return: list[BundleVersionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bundle_versions_with_http_info(**kwargs)
        else:
            (data) = self.get_bundle_versions_with_http_info(**kwargs)
            return data

    def get_bundle_versions_with_http_info(self, **kwargs):
        """
        Get all bundle versions
        Gets the metadata about extension bundle versions across all authorized buckets with optional filters applied. If the user is not authorized to any buckets, an empty list will be returned.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundle_versions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: Optional groupId to filter results. The value may be an exact match, or a wildcard, such as 'com.%' to select all bundle versions where the groupId starts with 'com.'.
        :param str artifact_id: Optional artifactId to filter results. The value may be an exact match, or a wildcard, such as 'nifi-%' to select all bundle versions where the artifactId starts with 'nifi-'.
        :param str version: Optional version to filter results. The value maye be an exact match, or a wildcard, such as '1.0.%' to select all bundle versions where the version starts with '1.0.'.
        :return: list[BundleVersionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'artifact_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_versions" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_id' in params:
            query_params.append(('groupId', params['group_id']))
        if 'artifact_id' in params:
            query_params.append(('artifactId', params['artifact_id']))
        if 'version' in params:
            query_params.append(('version', params['version']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/versions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[BundleVersionMetadata]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bundles(self, **kwargs):
        """
        Get all bundles
        Gets the metadata for all bundles across all authorized buckets with optional filters applied. The returned results will include only items from buckets for which the user is authorized. If the user is not authorized to any buckets, an empty list will be returned.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: Optional bucket name to filter results. The value may be an exact match, or a wildcard, such as 'My Bucket%' to select all bundles where the bucket name starts with 'My Bucket'.
        :param str group_id: Optional groupId to filter results. The value may be an exact match, or a wildcard, such as 'com.%' to select all bundles where the groupId starts with 'com.'.
        :param str artifact_id: Optional artifactId to filter results. The value may be an exact match, or a wildcard, such as 'nifi-%' to select all bundles where the artifactId starts with 'nifi-'.
        :return: list[ExtensionBundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bundles_with_http_info(**kwargs)
        else:
            (data) = self.get_bundles_with_http_info(**kwargs)
            return data

    def get_bundles_with_http_info(self, **kwargs):
        """
        Get all bundles
        Gets the metadata for all bundles across all authorized buckets with optional filters applied. The returned results will include only items from buckets for which the user is authorized. If the user is not authorized to any buckets, an empty list will be returned.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bundles_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bucket_name: Optional bucket name to filter results. The value may be an exact match, or a wildcard, such as 'My Bucket%' to select all bundles where the bucket name starts with 'My Bucket'.
        :param str group_id: Optional groupId to filter results. The value may be an exact match, or a wildcard, such as 'com.%' to select all bundles where the groupId starts with 'com.'.
        :param str artifact_id: Optional artifactId to filter results. The value may be an exact match, or a wildcard, such as 'nifi-%' to select all bundles where the artifactId starts with 'nifi-'.
        :return: list[ExtensionBundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket_name', 'group_id', 'artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundles" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'bucket_name' in params:
            query_params.append(('bucketName', params['bucket_name']))
        if 'group_id' in params:
            query_params.append(('groupId', params['group_id']))
        if 'artifact_id' in params:
            query_params.append(('artifactId', params['artifact_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionBundle]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_delete_bundle_version(self, bundle_id, version, **kwargs):
        """
        Delete bundle version
        Deletes the given extension bundle version and it's associated binary content.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_delete_bundle_version(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: BundleVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_delete_bundle_version_with_http_info(bundle_id, version, **kwargs)
        else:
            (data) = self.global_delete_bundle_version_with_http_info(bundle_id, version, **kwargs)
            return data

    def global_delete_bundle_version_with_http_info(self, bundle_id, version, **kwargs):
        """
        Delete bundle version
        Deletes the given extension bundle version and it's associated binary content.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_delete_bundle_version_with_http_info(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: BundleVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_delete_bundle_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_delete_bundle_version`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `global_delete_bundle_version`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BundleVersion',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_delete_extension_bundle(self, bundle_id, **kwargs):
        """
        Delete bundle
        Deletes the given extension bundle and all of it's versions.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_delete_extension_bundle(bundle_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :return: ExtensionBundle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_delete_extension_bundle_with_http_info(bundle_id, **kwargs)
        else:
            (data) = self.global_delete_extension_bundle_with_http_info(bundle_id, **kwargs)
            return data

    def global_delete_extension_bundle_with_http_info(self, bundle_id, **kwargs):
        """
        Delete bundle
        Deletes the given extension bundle and all of it's versions.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_delete_extension_bundle_with_http_info(bundle_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :return: ExtensionBundle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_delete_extension_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_delete_extension_bundle`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionBundle',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_get_bundle_version(self, bundle_id, version, **kwargs):
        """
        Get bundle version
        Gets the descriptor for the given version of the given extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: BundleVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_get_bundle_version_with_http_info(bundle_id, version, **kwargs)
        else:
            (data) = self.global_get_bundle_version_with_http_info(bundle_id, version, **kwargs)
            return data

    def global_get_bundle_version_with_http_info(self, bundle_id, version, **kwargs):
        """
        Get bundle version
        Gets the descriptor for the given version of the given extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_with_http_info(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: BundleVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_get_bundle_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_get_bundle_version`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `global_get_bundle_version`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BundleVersion',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_get_bundle_version_content(self, bundle_id, version, **kwargs):
        """
        Get bundle version content
        Gets the binary content for the given version of the given extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_content(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_get_bundle_version_content_with_http_info(bundle_id, version, **kwargs)
        else:
            (data) = self.global_get_bundle_version_content_with_http_info(bundle_id, version, **kwargs)
            return data

    def global_get_bundle_version_content_with_http_info(self, bundle_id, version, **kwargs):
        """
        Get bundle version content
        Gets the binary content for the given version of the given extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_content_with_http_info(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_get_bundle_version_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_get_bundle_version_content`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `global_get_bundle_version_content`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}/content', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[str]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_get_bundle_version_extension(self, bundle_id, version, name, **kwargs):
        """
        Get bundle version extension
        Gets the metadata about the extension with the given name in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_extension(bundle_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :param str name: The fully qualified name of the extension (required)
        :return: list[Extension]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_get_bundle_version_extension_with_http_info(bundle_id, version, name, **kwargs)
        else:
            (data) = self.global_get_bundle_version_extension_with_http_info(bundle_id, version, name, **kwargs)
            return data

    def global_get_bundle_version_extension_with_http_info(self, bundle_id, version, name, **kwargs):
        """
        Get bundle version extension
        Gets the metadata about the extension with the given name in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_extension_with_http_info(bundle_id, version, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :param str name: The fully qualified name of the extension (required)
        :return: list[Extension]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_get_bundle_version_extension" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_get_bundle_version_extension`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `global_get_bundle_version_extension`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `global_get_bundle_version_extension`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}/extensions/{name}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Extension]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_get_bundle_version_extensions(self, bundle_id, version, **kwargs):
        """
        Get bundle version extensions
        Gets the metadata about the extensions in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_extensions(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: list[ExtensionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_get_bundle_version_extensions_with_http_info(bundle_id, version, **kwargs)
        else:
            (data) = self.global_get_bundle_version_extensions_with_http_info(bundle_id, version, **kwargs)
            return data

    def global_get_bundle_version_extensions_with_http_info(self, bundle_id, version, **kwargs):
        """
        Get bundle version extensions
        Gets the metadata about the extensions in the given extension bundle version.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_version_extensions_with_http_info(bundle_id, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :param str version: The version of the bundle (required)
        :return: list[ExtensionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_get_bundle_version_extensions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_get_bundle_version_extensions`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `global_get_bundle_version_extensions`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions/{version}/extensions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ExtensionMetadata]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_get_bundle_versions(self, bundle_id, **kwargs):
        """
        Get bundle versions
        Gets the metadata for the versions of the given extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_versions(bundle_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :return: list[BundleVersionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_get_bundle_versions_with_http_info(bundle_id, **kwargs)
        else:
            (data) = self.global_get_bundle_versions_with_http_info(bundle_id, **kwargs)
            return data

    def global_get_bundle_versions_with_http_info(self, bundle_id, **kwargs):
        """
        Get bundle versions
        Gets the metadata for the versions of the given extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_bundle_versions_with_http_info(bundle_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :return: list[BundleVersionMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_get_bundle_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_get_bundle_versions`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}/versions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[BundleVersionMetadata]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def global_get_extension_bundle(self, bundle_id, **kwargs):
        """
        Get bundle
        Gets the metadata about an extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_extension_bundle(bundle_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :return: ExtensionBundle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.global_get_extension_bundle_with_http_info(bundle_id, **kwargs)
        else:
            (data) = self.global_get_extension_bundle_with_http_info(bundle_id, **kwargs)
            return data

    def global_get_extension_bundle_with_http_info(self, bundle_id, **kwargs):
        """
        Get bundle
        Gets the metadata about an extension bundle.   NOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.global_get_extension_bundle_with_http_info(bundle_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bundle_id: The extension bundle identifier (required)
        :return: ExtensionBundle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_get_extension_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params) or (params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `global_get_extension_bundle`")


        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['tokenAuth', 'Authorization']

        return self.api_client.call_api('/bundles/{bundleId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionBundle',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
