# Generated by Django 2.2.28 on 2023-07-24 11:40

from django.db import migrations, models
import django.db.models.deletion
import imagekit.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='FirstMenu',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=10, verbose_name='名称')),
                ('icon', models.CharField(max_length=30, verbose_name='图标')),
                ('sort_order', models.IntegerField(default=99, help_text='自定义排序', verbose_name='排序')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
            ],
            options={
                'verbose_name': '一级菜单',
                'verbose_name_plural': '一级菜单',
                'ordering': ['sort_order'],
            },
        ),
        migrations.CreateModel(
            name='SecondMenu',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=10, verbose_name='名称')),
                ('icon', models.CharField(max_length=30, verbose_name='图标')),
                ('sort_order', models.IntegerField(default=99, help_text='自定义排序', verbose_name='排序')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('father', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='second_menus', to='webstack.FirstMenu', verbose_name='父菜单')),
            ],
            options={
                'verbose_name': '二级菜单',
                'verbose_name_plural': '二级菜单',
                'ordering': ['sort_order'],
            },
        ),
        migrations.CreateModel(
            name='NavigationSite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30, verbose_name='名称')),
                ('description', models.CharField(max_length=100, verbose_name='描述')),
                ('link', models.URLField(max_length=150, verbose_name='网站地址')),
                ('sort_order', models.IntegerField(default=99, help_text='自定义排序', verbose_name='排序')),
                ('create_date', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('logo', imagekit.models.fields.ProcessedImageField(default='web/default/default.png', help_text='上传图片大小建议使用1:1的宽高比，为了清晰度原始图片宽度应该超过50px', upload_to='web/upload/%Y/%m/%d/', verbose_name='Logo')),
                ('menu', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='navigation_sites', to='webstack.SecondMenu', verbose_name='所属二级菜单')),
            ],
            options={
                'verbose_name': '导航网站',
                'verbose_name_plural': '导航网站',
                'ordering': ['-create_date'],
            },
        ),
    ]
