# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sqlc_runtime']

package_data = \
{'': ['*']}

install_requires = \
['pydantic>=1.4,<2.0']

extras_require = \
{'asyncpg': ['asyncpg>=0.22.0,<0.23.0'],
 'psycopg2': ['psycopg2-binary>=2.8.6,<3.0.0']}

setup_kwargs = {
    'name': 'sqlc-python-runtime',
    'version': '1.0.1',
    'description': 'Runtime components for code generated by sqlc',
    'long_description': '# sqlc-python-runtime\n\nA small runtime library for python code generated by [sqlc](https://github.com/kyleconroy/sqlc)\n\n## Installation\n\nAdd the `sqlc-python-runtime` package to your project\'s dependencies.\n\n## Usage\n\nAll query functions generated by sqlc take a database connection object as their first argument.\nThis connection object must conform to the `Connection`/`AsyncConnection` interface defined in this package.\nThis package also provides wrappers for `psycopg2` and `asyncpg` that conform to this interface.\n\n`psycopg2` example:\n```python\nimport psycopg2\nfrom sqlc_runtime.psycopg2 import build_psycopg2_connection\n\n\nconn = build_psycopg2_connection(psycopg2.connect("postgresql://localhost:5432/mydatabase"))\n```\n\nAlso note that the generated query functions can use either a `Connection` or an `AsyncConnection`.\nIf an `AsyncConnection` is passed the result must be awaited. The function type hints communicate this so any type\ncheckers (like mypy) will raise errors if any are missed or incorrectly used.\n',
    'author': 'Robert Holt',
    'author_email': 'rholt@datto.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/robholt/sqlc-python-runtime',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
