# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openremote_cli']

package_data = \
{'': ['*']}

install_requires = \
['emojis>=0.6.0,<0.7.0',
 'oronium>=0.89.0,<0.90.0',
 'python-keycloak>=0.24.0,<0.25.0',
 'requests>=2.25.1,<3.0.0',
 'wget>=3.2,<4.0']

entry_points = \
{'console_scripts': ['openremote-cli = openremote_cli.cli:main',
                     'or = openremote_cli.cli:main',
                     'or-email = openremote_cli.email:main',
                     'or-gen-aws-smtp = '
                     'openremote_cli.gen_aws_smtp_credentials:main',
                     'or-gen-aws-smtp-credentials = '
                     'openremote_cli.gen_aws_smtp_credentials:main',
                     'or-test-http-rest = '
                     'openremote_cli.scripts:manager_test_http_rest']}

setup_kwargs = {
    'name': 'openremote-cli',
    'version': '0.6.32',
    'description': 'OpenRemote Command-line interface',
    'long_description': "![CI/CD](https://github.com/openremote/openremote-cli/workflows/CI/CD/badge.svg)\n![docker](https://github.com/openremote/openremote-cli/workflows/docker/badge.svg)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![Open Source? Yes!](https://badgen.net/badge/Open%20Source%20%3F/Yes%21/blue?icon=github)](https://github.com/Naereen/badges/)\n[![Donate](https://img.shields.io/badge/donations-appreciated-green.svg)](https://www.paypal.com/webapps/shoppingcart?flowlogging_id=4b5432e8ad1a8&mfid=1616517920020_4b5432e8ad1a8#/checkout/openButton)\n\n# OpenRemote CLI\n\n## Intro\n\nThis is Command Line Interface to OpenRemote IoT platform. It's purpose is to reduce friction of using OpenRemote by Do It Yourself users.\n\nIt is published as a Python package on [PyPi.org](https://pypi.org/project/openremote-cli/)\n\n## About OR\n\nOpenRemote is a great real OpenSource IoT platform.\n\n## Usage\n\nTo install/upgrade the CLI:\n```bash\npip install --upgrade openremote-cli\nor --version\n```\n\n### Deploy local OpenRemote stack\n\n```bash\nor deploy\n```\n\nWhen it finishes you should be able to open https://localhost and login with admin:secret to the manager. Depending on your machine it can take few minutes to\nstart or services (usually less than 10 minutes). If it does not work yet, check it with ```docker ps``` to see if all services are in healthy or starting stage.\n\n### Remove local OpenRemote stack\n\n```bash\nor deploy --action remove\n```\n\n### Deploy OpenRemote stack on AWS with DNS entry\n\n```bash\nor deploy --platform aws --dnsname myiot.mydomain.com\n```\n### Check health of the openremote stack\n```bash\nor deploy -a health --dnsname myiot.mydomain.com -v\n```\n\n### Install shell completion extension\n\n#### zsh\n\n```bash\nTODO\n```\n\n#### bash\n\n```\nTODO\n```\n\n## Configure existing OpenRemote instance\n\n### Add users\n\n### Add assets\n\n### Add customization\n\n## Develop openremote-cli\n\nFollowing tools are used:\n- python (pip, poetry, black, PyPI.org)\n- git (pre-commit, actions)\n- docker (docker-compose, swarm)\n- AWS (CloudFormation)\n- make\n\n### Adding feature\n\nIn this project we use Behavior-driven development (or BDD). BDD is an agile\nsoftware development technique that encourages collaboration between developers,\nQA and non-technical or business participants in a software project.\n\nThis project uses Gherkin to define what features which should be covered. Features\nfiles can be generated by people on manager level or even higher. An example\nof file defining a feature:\n\n```gherkin\nFeature: deploy\n\n  Scenario: deploy to localhost\n    Given we have docker and docker-compose installed\n    When we call openremote-cli --dry-run deploy --action create\n    Then show what will be done\n```\n\nWhen the feature is implemented it can be checked with behave:\n\n```bash\n> behave\nFeature: deploy # features/deploy.feature:1\n\n  Scenario: deploy to localhost                                  # features/deploy.feature:3\n    Given we have docker and docker-compose installed            # features/steps/deploy_steps.py:8 0.453s\n    When we call openremote-cli --dry-run deploy --action create # features/steps/deploy_steps.py:16 0.591s\n    Then show what will be done                                  # features/steps/deploy_steps.py:24 0.000s\n\n1 feature passed, 0 failed, 0 skipped\n1 scenario passed, 0 failed, 0 skipped\n3 steps passed, 0 failed, 0 skipped, 0 undefined\nTook 0m1.044s\n```\n",
    'author': 'Michal Rutka',
    'author_email': 'michal@openremote.io',
    'maintainer': 'OpenRemote',
    'maintainer_email': 'developers@openremote.io',
    'url': 'https://www.openremote.io',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
