"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const ecs = require("@aws-cdk/aws-ecs");
const defaults = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename), {
    env: { account: core_1.Aws.ACCOUNT_ID, region: 'us-east-1' },
});
stack.templateOptions.description = 'Integration Test with new VPC, Service and Table';
const existingVpc = core_2.getTestVpc(stack);
const [existingTable] = defaults.buildDynamoDBTable(stack, {});
const image = ecs.ContainerImage.fromRegistry('nginx');
const [testService, testContainer] = core_2.CreateFargateService(stack, 'test', existingVpc, undefined, undefined, undefined, undefined, { image });
const constructProps = {
    publicApi: true,
    existingVpc,
    existingTableInterface: existingTable,
    existingContainerDefinitionObject: testContainer,
    existingFargateServiceObject: testService,
    tableArnEnvironmentVariableName: 'CUSTOM_ARN',
    tableEnvironmentVariableName: 'CUSTOM_NAME'
};
new lib_1.FargateToDynamoDB(stack, 'test-construct', constructProps);
defaults.suppressAutoDeleteHandlerWarnings(stack);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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