/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.BoundedIntWidget;
import com.twosigma.beakerx.widget.ProgressStyle;
import java.util.HashMap;

public class IntProgress
extends BoundedIntWidget {
    public static final String VIEW_NAME_VALUE = "ProgressView";
    public static final String MODEL_NAME_VALUE = "IntProgressModel";
    protected static final String ORIENTATION = "orientation";
    public static final String BAR_STYLE = "bar_style";
    private String orientation = "horizontal";
    private BarStyle barStyle = BarStyle.EMPTY;

    public IntProgress(Integer min, Integer max, Integer step) {
        super(min, max, step);
        this.style = new ProgressStyle();
        this.openComm();
    }

    public IntProgress() {
        this.style = new ProgressStyle();
        this.openComm();
    }

    @Override
    protected HashMap<String, Object> content(HashMap<String, Object> content) {
        super.content(content);
        content.put(ORIENTATION, this.orientation);
        content.put(BAR_STYLE, this.barStyle.getValue());
        return content;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
        this.sendUpdate(ORIENTATION, orientation);
    }

    public void setBarStyle(BarStyle style) {
        this.barStyle = style;
        this.sendUpdate(BAR_STYLE, this.barStyle.getValue());
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public static enum BarStyle {
        SUCCESS("success"),
        INFO("info"),
        WARNING("warning"),
        DANGER("danger"),
        EMPTY("");

        private String value;

        private BarStyle(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

