/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.magic.command.BxMavenManager;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class MvnLogsWidget {
    static final int PERIOD = 1000;
    private Output output;
    private Timer timer;
    private List<String> logs = Collections.synchronizedList(new ArrayList());
    private int start = 0;

    public MvnLogsWidget(Message parentMessage) {
        this.output = new Output(parentMessage);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MvnLogsWidget.this.sendLogs();
            }
        }, 0L, 1000L);
    }

    private synchronized void sendLogs() {
        if (BxMavenManager.isLogsOn()) {
            int end = this.logs.size();
            ArrayList<String> logs = new ArrayList<String>();
            logs.addAll(this.logs.subList(this.start, end));
            if (!logs.isEmpty()) {
                String join = String.join((CharSequence)"\n", logs);
                this.output.appendStdout(join);
                this.start = end;
            }
        }
    }

    public synchronized void sendLog(String line) {
        this.logs.add(line);
    }

    public synchronized void stop() {
        this.timer.cancel();
        this.sendLogs();
    }

    public synchronized void close() {
        this.output.close();
    }

    public synchronized void display() {
        this.output.display();
    }
}

