/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.PomStyleDependencies;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class PomFactory {
    public String createPom(Params params, List<MavenJarResolver.Dependency> dependencies) {
        String pomAsString = this.createPom(params);
        pomAsString = this.configureDependencies(dependencies, pomAsString);
        return pomAsString;
    }

    public String createPom(Params params, PomStyleDependencies dependencies) {
        String pomAsString = this.createPom(params);
        pomAsString = this.configureDependencies(dependencies, pomAsString);
        return pomAsString;
    }

    private String createPom(Params params) {
        InputStream pom = this.getClass().getClassLoader().getResourceAsStream("PomTemplateMagicCommand.xml");
        String pomAsString = this.getPomAsString(pom);
        pomAsString = this.configureOutputDir(params.pathToMavenRepo, pomAsString);
        pomAsString = this.configureRepos(params.repos, pomAsString);
        pomAsString = this.configureGoal(params.goal, pomAsString);
        pomAsString = this.configureBuildClasspathPlugin(params.pathToMavenRepo, params.mavenBuiltClasspathFileName, pomAsString);
        return pomAsString;
    }

    private String getPomAsString(InputStream pom) {
        String pomAsString;
        try {
            pomAsString = IOUtils.toString((InputStream)pom, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pomAsString;
    }

    private String configureBuildClasspathPlugin(String pathToMavenRepo, String mavenBuiltClasspathFileName, String pomAsString) {
        String absolutePath = new File(pathToMavenRepo, mavenBuiltClasspathFileName).getAbsolutePath();
        return pomAsString.replace("<outputFile>mavenBuiltClasspathFile</outputFile>", "<outputFile>" + absolutePath + "</outputFile>");
    }

    private String configureGoal(String goal, String pomAsString) {
        return pomAsString.replaceAll("<phase>goal</phase>", "<phase>" + goal + "</phase>");
    }

    private String configureDependencies(PomStyleDependencies dependencies, String pomAsString) {
        return pomAsString.replace("<dependencies></dependencies>", dependencies.asString());
    }

    private String configureDependencies(List<MavenJarResolver.Dependency> dependencies, String pomAsString) {
        for (MavenJarResolver.Dependency dependency : dependencies) {
            pomAsString = this.configureDependency(dependency, pomAsString);
        }
        return pomAsString;
    }

    private String configureDependency(MavenJarResolver.Dependency dependency, String pomAsString) {
        return pomAsString.replace("</dependencies>", "  <dependency>\n    <groupId>" + dependency.getGroupId() + "</groupId>\n    <artifactId>" + dependency.getArtifactId() + "</artifactId>\n    <version>" + dependency.getVersion() + "</version>\n    <type>" + dependency.getType() + "</type>\n" + this.classifier(dependency.getClassifier()) + "  </dependency>\n</dependencies>");
    }

    private String classifier(Optional<String> classifier) {
        return classifier.map(s -> "<classifier>" + s + "</classifier>\n").orElse("");
    }

    private String configureOutputDir(String pathToMavenRepo, String pomAsString) {
        String absolutePath = new File(pathToMavenRepo).getAbsolutePath();
        return pomAsString.replace("<outputDirectory>pathToNotebookJars</outputDirectory>", "<outputDirectory>" + absolutePath + "</outputDirectory>");
    }

    private String configureRepos(Map<String, String> repos, String pomAsString) {
        for (Map.Entry<String, String> entry : repos.entrySet()) {
            pomAsString = this.configureRepos(pomAsString, entry.getKey(), entry.getValue());
        }
        return pomAsString;
    }

    private String configureRepos(String pomAsString, String name, String url) {
        String repoPattern = "<repository>\n    <id>%s</id>\n    <url>%s</url>\n</repository>\n";
        return pomAsString.replace("</repositories>", String.format(repoPattern, name, url) + "</repositories>");
    }

    static class Params {
        String pathToMavenRepo;
        Map<String, String> repos;
        String goal;
        private String mavenBuiltClasspathFileName;

        public Params(String pathToMavenRepo, Map<String, String> repos, String goal, String mavenBuiltClasspathFileName) {
            this.pathToMavenRepo = pathToMavenRepo;
            this.repos = repos;
            this.goal = goal;
            this.mavenBuiltClasspathFileName = mavenBuiltClasspathFileName;
        }
    }
}

