/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.CodeCell;
import com.twosigma.beakerx.jvm.serialization.BeakerCodeCellList;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import java.io.IOException;
import java.util.ArrayList;

public class BeakerCodeCellListDeserializer
extends JsonDeserializer<BeakerCodeCellList> {
    private final BeakerObjectConverter objectSerializerProvider;

    public BeakerCodeCellListDeserializer(BeakerObjectConverter osp) {
        this.objectSerializerProvider = osp;
    }

    public BeakerCodeCellList deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        ArrayList<CodeCell> l = new ArrayList<CodeCell>();
        if (node.isArray()) {
            for (JsonNode o : node) {
                Object obj = this.objectSerializerProvider.deserialize(o, mapper);
                if (!(obj instanceof CodeCell)) continue;
                l.add((CodeCell)obj);
            }
        }
        BeakerCodeCellList r = new BeakerCodeCellList();
        r.theList = l;
        return r;
    }
}

