/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.object;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import java.io.IOException;
import java.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatableEvaluationResult
extends Observable {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdatableEvaluationResult.class.getName());
    private Object value;

    public UpdatableEvaluationResult(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        this.value = o;
        this.setChanged();
        this.notifyObservers();
    }

    public static class DeSerializer
    implements ObjectDeserializer {
        private final BeakerObjectConverter parent;

        public DeSerializer(BeakerObjectConverter p) {
            this.parent = p;
            this.parent.addKnownBeakerType("UpdatableEvaluationResult");
        }

        public Object deserialize(JsonNode n, ObjectMapper mapper) {
            UpdatableEvaluationResult o = null;
            try {
                Object payload = null;
                if (n.has("payload")) {
                    payload = this.parent.deserialize(n.get("payload"), mapper);
                }
                o = new UpdatableEvaluationResult(payload);
            }
            catch (Exception e) {
                logger.error("exception deserializing UpdatableEvaluationResult ", (Throwable)e);
            }
            return o;
        }

        public boolean canBeUsed(JsonNode n) {
            return n.has("type") && n.get("type").asText().equals("UpdatableEvaluationResult");
        }
    }

    public static class Serializer
    extends JsonSerializer<UpdatableEvaluationResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(UpdatableEvaluationResult v, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
            UpdatableEvaluationResult updatableEvaluationResult = v;
            synchronized (updatableEvaluationResult) {
                jgen.writeStartObject();
                jgen.writeStringField("type", "UpdatableEvaluationResult");
                jgen.writeFieldName("payload");
                Object obj = v.getValue();
                jgen.writeObject(obj != null ? obj : "null");
                jgen.writeEndObject();
            }
        }
    }
}

