/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.xychart.NanoPlot;
import com.twosigma.beakerx.chart.xychart.plotitem.Text;
import com.twosigma.beakerx.util.SerializerUtil;
import java.io.IOException;

public class TextSerializer
extends JsonSerializer<Text> {
    public static final String TYPE = "type";

    public void serialize(Text text, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        boolean isNanoPlot = NanoPlot.isNanoPlotClass(text.getPlotType());
        jgen.writeStartObject();
        jgen.writeObjectField(TYPE, (Object)SerializerUtil.getTypeName(text));
        jgen.writeObjectField("x", isNanoPlot ? this.processLargeNumber(text.getX()) : text.getX());
        jgen.writeObjectField("y", (Object)text.getY());
        jgen.writeObjectField("show_pointer", (Object)text.getShowPointer());
        jgen.writeObjectField("text", (Object)text.getText());
        jgen.writeObjectField("pointer_angle", (Object)text.getPointerAngle());
        jgen.writeObjectField("color", (Object)text.getColor());
        jgen.writeObjectField("size", (Object)text.getSize());
        jgen.writeEndObject();
    }

    private String processLargeNumber(Number largeNumber) {
        return largeNumber != null ? largeNumber.toString() : "";
    }
}

