/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.heatmap.HeatMap;
import com.twosigma.beakerx.chart.serializer.AbstractChartSerializer;
import com.twosigma.beakerx.chart.serializer.HeatMapReducer;
import java.io.IOException;

public class HeatMapSerializer
extends AbstractChartSerializer<HeatMap> {
    public static final String GRAPHICS_LIST = "graphics_list";
    public static final String COLOR = "color";
    public static final String ITEMS = " items";
    private HeatMapReducer heatMapReducer = new HeatMapReducer(100, 100);

    public void serialize(HeatMap heatmap, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        this.serialize(heatmap, jgen);
        if (heatmap.getData() == null) {
            jgen.writeObjectField(GRAPHICS_LIST, (Object)heatmap.getData());
            jgen.writeObjectField("totalNumberOfPoints", (Object)0);
            jgen.writeBooleanField("tooManyRows", false);
        } else {
            this.serializeData(heatmap.getData(), jgen);
        }
        jgen.writeObjectField(COLOR, (Object)heatmap.getColor());
        jgen.writeEndObject();
    }

    private void serializeData(Number[][] data, JsonGenerator jgen) throws IOException {
        boolean tooManyPoints;
        int totalPoints = HeatMapReducer.totalPoints(data);
        boolean bl = tooManyPoints = totalPoints > 10000;
        if (tooManyPoints) {
            Number[][] limitedHeatMapData = this.heatMapReducer.limitHeatmap(data);
            jgen.writeObjectField(GRAPHICS_LIST, (Object)limitedHeatMapData);
            jgen.writeObjectField("rowsLimitItems", (Object)10000);
            jgen.writeObjectField("numberOfPointsToDisplay", (Object)(HeatMapReducer.totalPoints(limitedHeatMapData) + ITEMS));
        } else {
            jgen.writeObjectField(GRAPHICS_LIST, (Object)data);
        }
        jgen.writeObjectField("totalNumberOfPoints", (Object)totalPoints);
        jgen.writeBooleanField("tooManyRows", tooManyPoints);
    }
}

