/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.comm.Buffer;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.Data;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.util.Preconditions;
import com.twosigma.beakerx.widget.ChangeItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BxComm
implements Comm {
    private String commId;
    private String targetName;
    private Data data;
    private HashMap<?, ?> metadata;
    private String targetModule;
    protected KernelFunctionality kernel;
    private List<Handler<Message>> msgCallbackList = new ArrayList<Handler<Message>>();
    private List<Handler<Message>> closeCallbackList = new ArrayList<Handler<Message>>();
    private GetParentMessageStrategy getParentMessageStrategy = InternalVariable::getParentHeader;

    public BxComm(String commId, String targetName, Message parentMessage) {
        this(commId, targetName, KernelManager.get());
        this.getParentMessageStrategy = () -> parentMessage;
    }

    public BxComm(String commId, String targetName, KernelFunctionality kernel) {
        this.kernel = kernel;
        this.commId = commId;
        this.targetName = targetName;
        this.data = new Data(new HashMap());
        this.metadata = new HashMap();
    }

    public BxComm(String commId, String targetName) {
        this(commId, targetName, KernelManager.get());
    }

    public BxComm(String commId, TargetNamesEnum targetName) {
        this(commId, targetName.getTargetName(), KernelManager.get());
    }

    public BxComm(TargetNamesEnum targetName) {
        this(Utils.commUUID(), targetName.getTargetName(), KernelManager.get());
    }

    public BxComm(String targetName) {
        this(Utils.commUUID(), targetName, KernelManager.get());
    }

    @Override
    public String getCommId() {
        return this.commId;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public Data getData() {
        return new Data(new HashMap(this.data.getData()));
    }

    @Override
    public Comm createNewComm() {
        return BxComm.createComm();
    }

    public static Comm createComm() {
        return new BxComm(TargetNamesEnum.JUPYTER_WIDGET);
    }

    @Override
    public void setData(HashMap<?, ?> data) {
        this.data = new Data(data);
    }

    public void setMetaData(HashMap<?, ?> metadata) {
        this.metadata = metadata;
    }

    @Override
    public String getTargetModule() {
        return this.targetModule;
    }

    @Override
    public void setTargetModule(String targetModule) {
        this.targetModule = targetModule;
    }

    @Override
    public void addMsgCallbackList(Handler<Message> ... handlers) {
        this.msgCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearMsgCallbackList() {
        this.msgCallbackList = new ArrayList<Handler<Message>>();
    }

    public List<Handler<Message>> getCloseCallbackList() {
        return this.closeCallbackList;
    }

    public void addCloseCallbackList(Handler<Message> ... handlers) {
        this.closeCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearCloseCallbackList() {
        this.closeCallbackList = new ArrayList<Handler<Message>>();
    }

    @Override
    public void open() {
        this.doOpen(this.getParentMessage(), Buffer.EMPTY);
    }

    @Override
    public void open(Buffer buffer) {
        this.doOpen(this.getParentMessage(), buffer);
    }

    @Override
    public void open(Message parentMessage) {
        this.getParentMessageStrategy = () -> parentMessage;
        this.doOpen(parentMessage, Buffer.EMPTY);
    }

    private void doOpen(Message parentMessage, Buffer buffer) {
        Preconditions.checkNotNull(parentMessage, "parent message can not be null");
        Message message = new Message(new Header(JupyterMessages.COMM_OPEN, parentMessage.getHeader().getSession()));
        message.setParentHeader(parentMessage.getHeader());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("comm_id", (Serializable)((Object)this.getCommId()));
        map.put("target_name", (Serializable)((Object)this.getTargetName()));
        HashMap<String, Serializable> state = new HashMap<String, Serializable>();
        state.put("state", this.data.getData());
        state.put("method", (Serializable)this.data.getData().get("method"));
        if (!buffer.isEmpty()) {
            state.put("buffer_paths", buffer.getBufferPaths());
            message.setBuffers(buffer.getBuffers());
        }
        map.put("data", state);
        map.put("metadata", this.metadata);
        map.put("target_module", (Serializable)((Object)this.getTargetModule()));
        message.setContent(map);
        message.setMetadata(BxComm.buildMetadata());
        this.kernel.publish(Collections.singletonList(message));
        this.kernel.addComm(this.getCommId(), this);
    }

    @Override
    public void close() {
        Message parentMessage = this.getParentMessage();
        if (this.getCloseCallbackList() != null && !this.getCloseCallbackList().isEmpty()) {
            for (Handler<Message> handler : this.getCloseCallbackList()) {
                handler.handle(parentMessage);
            }
        }
        Message message = new Message(new Header(JupyterMessages.COMM_CLOSE, parentMessage.getHeader().getSession()));
        if (parentMessage != null) {
            message.setParentHeader(parentMessage.getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("comm_id", (Serializable)((Object)this.getCommId()));
        map.put("data", new HashMap());
        map.put("metadata", new HashMap());
        message.setContent(map);
        message.setMetadata(BxComm.buildMetadata());
        this.kernel.removeComm(this.getCommId());
        this.kernel.publish(Collections.singletonList(message));
    }

    @Override
    public void send(Buffer buffer, Data data) {
        this.send(JupyterMessages.COMM_MSG, buffer, data);
    }

    @Override
    public void send(JupyterMessages type, Data data) {
        this.send(type, Buffer.EMPTY, data);
    }

    @Override
    public void send(JupyterMessages type, Buffer buffer, Data data) {
        Message message = this.createMessage(type, buffer, data);
        this.kernel.publish(Collections.singletonList(message));
    }

    @Override
    public Message createMessage(JupyterMessages type, Buffer buffer, Data data, Message parent) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        if (type != JupyterMessages.DISPLAY_DATA) {
            map.put("comm_id", (Serializable)((Object)this.getCommId()));
        }
        map.put("data", data.getData());
        map.put("metadata", this.metadata);
        return this.create(type, buffer, map, parent);
    }

    @Override
    public Message createMessage(JupyterMessages type, Buffer buffer, Data data) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        if (type != JupyterMessages.DISPLAY_DATA) {
            map.put("comm_id", (Serializable)((Object)this.getCommId()));
        }
        map.put("data", data.getData());
        map.put("metadata", this.metadata);
        return this.create(type, buffer, map);
    }

    private Message create(JupyterMessages type, Buffer buffer, Map<String, Serializable> content, Message parent) {
        return BxComm.messageMessage(type, buffer, content, parent);
    }

    private Message create(JupyterMessages type, Buffer buffer, Map<String, Serializable> content) {
        return BxComm.messageMessage(type, buffer, content, this.getParentMessage());
    }

    public static Message messageMessage(JupyterMessages type, Buffer buffer, Map<String, Serializable> content, Message parentMessage) {
        Message message = new Message(new Header(type, parentMessage.getHeader().getSession()));
        Preconditions.checkNotNull(parentMessage);
        message.setParentHeader(parentMessage.getHeader());
        message.setContent(content);
        message.setMetadata(BxComm.buildMetadata());
        if (!buffer.isEmpty()) {
            message.setBuffers(buffer.getBuffers());
        }
        return message;
    }

    @Override
    public void publish(List<Message> list) {
        this.kernel.publish(list);
    }

    @Override
    public void sendUpdate(Buffer buffer) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("method", "update");
        HashMap state = new HashMap();
        content.put("state", state);
        content.put("buffer_paths", buffer.getBufferPaths());
        this.send(buffer, new Data(content));
    }

    @Override
    public Message createOutputContent(Map<String, Serializable> content) {
        return this.create(JupyterMessages.STREAM, Buffer.EMPTY, content);
    }

    @Override
    public void sendData(String field, HashMap<String, String> payload) {
        Message message = this.createMessageWithData(field, payload);
        this.kernel.publish(Collections.singletonList(message));
    }

    @Override
    public void sendUpdate(List<ChangeItem> changes) {
        Message message = this.createUpdateMessage(changes, new HashMap<String, Object>());
        this.kernel.publish(Collections.singletonList(message));
    }

    @Override
    public void sendUpdate(List<ChangeItem> changes, Message parent) {
        Message message = this.createUpdateMessage(changes, parent);
        this.kernel.publish(Collections.singletonList(message));
    }

    public Message createMessageWithData(String field, HashMap<String, String> payload) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("method", "update");
        content.put(field, payload);
        content.put("buffer_paths", new HashMap());
        return this.createMessage(JupyterMessages.COMM_MSG, Buffer.EMPTY, new Data(content));
    }

    @Override
    public Message createUpdateMessage(List<ChangeItem> changes, Message parent) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("method", "update");
        HashMap state = new HashMap();
        changes.forEach(x -> state.put(x.getPropertyName(), x.getValue()));
        content.put("state", state);
        content.put("buffer_paths", new HashMap());
        return this.createMessage(JupyterMessages.COMM_MSG, Buffer.EMPTY, new Data(content), parent);
    }

    @Override
    public Message createUpdateMessage(List<ChangeItem> changes, HashMap<String, Object> state) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("method", "update");
        changes.forEach(x -> state.put(x.getPropertyName(), x.getValue()));
        content.put("state", state);
        content.put("buffer_paths", new HashMap());
        return this.createMessage(JupyterMessages.COMM_MSG, Buffer.EMPTY, new Data(content));
    }

    @Override
    public void handleMsg(Message parentMessage) {
        for (Handler<Message> handler : this.msgCallbackList) {
            handler.handle(parentMessage);
        }
    }

    private static HashMap<String, Serializable> buildMetadata() {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        metadata.put("version", (Serializable)((Object)"2"));
        return metadata;
    }

    public String toString() {
        return this.commId + "/" + this.targetName + "/" + (this.targetModule != null && !this.targetModule.isEmpty() ? this.targetModule : "");
    }

    @Override
    public Message getParentMessage() {
        return this.getParentMessageStrategy.getParentMessage();
    }

    static interface GetParentMessageStrategy {
        public Message getParentMessage();
    }
}

