/*
 * Decompiled with CFR 0.152.
 */
package io.javalin;

import io.javalin.ApiBuilder;
import io.javalin.ErrorHandler;
import io.javalin.ExceptionHandler;
import io.javalin.Handler;
import io.javalin.LogLevel;
import io.javalin.core.ErrorMapper;
import io.javalin.core.ExceptionMapper;
import io.javalin.core.HandlerEntry;
import io.javalin.core.HandlerType;
import io.javalin.core.JavalinServlet;
import io.javalin.core.PathMatcher;
import io.javalin.core.util.CorsUtil;
import io.javalin.core.util.RouteOverviewEntry;
import io.javalin.core.util.RouteOverviewUtil;
import io.javalin.core.util.Util;
import io.javalin.embeddedserver.EmbeddedServer;
import io.javalin.embeddedserver.EmbeddedServerFactory;
import io.javalin.embeddedserver.Location;
import io.javalin.embeddedserver.StaticFileConfig;
import io.javalin.embeddedserver.jetty.EmbeddedJettyFactory;
import io.javalin.embeddedserver.jetty.websocket.WebSocketConfig;
import io.javalin.embeddedserver.jetty.websocket.WebSocketHandler;
import io.javalin.event.EventListener;
import io.javalin.event.EventManager;
import io.javalin.event.EventType;
import io.javalin.security.AccessManager;
import io.javalin.security.Role;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Javalin {
    private static Logger log = LoggerFactory.getLogger(Javalin.class);
    private List<RouteOverviewEntry> routeOverviewEntries = new ArrayList<RouteOverviewEntry>();
    private int port = 7000;
    private String contextPath = "/";
    private boolean dynamicGzipEnabled = false;
    private EmbeddedServer embeddedServer;
    private EmbeddedServerFactory embeddedServerFactory = new EmbeddedJettyFactory();
    private List<StaticFileConfig> staticFileConfig = new ArrayList<StaticFileConfig>();
    private PathMatcher pathMatcher = new PathMatcher();
    private ExceptionMapper exceptionMapper = new ExceptionMapper();
    private ErrorMapper errorMapper = new ErrorMapper();
    private LogLevel logLevel = LogLevel.OFF;
    private String defaultContentType = "text/plain";
    private String defaultCharacterEncoding = StandardCharsets.UTF_8.name();
    private long maxRequestCacheBodySize = Long.MAX_VALUE;
    private boolean hideBanner = false;
    private EventManager eventManager = new EventManager();
    private AccessManager accessManager = (handler, ctx, permittedRoles) -> {
        throw new IllegalStateException("No access manager configured. Add an access manager using 'accessManager()'");
    };
    private boolean started = false;
    private List<WebSocketHandler> javalinWsHandlers = new ArrayList<WebSocketHandler>();
    private Map<String, Object> jettyWsHandlers = new HashMap<String, Object>();

    protected Javalin() {
    }

    public static Javalin create() {
        Util.INSTANCE.printHelpfulMessageIfNoServerHasBeenStartedAfterOneSecond();
        return new Javalin();
    }

    public static Javalin start(int port) {
        return new Javalin().port(port).start();
    }

    public Javalin start() {
        if (!this.started) {
            if (!this.hideBanner) {
                log.info(Util.INSTANCE.javalinBanner());
            }
            Util.INSTANCE.printHelpfulMessageIfLoggerIsMissing();
            Util.INSTANCE.setNoServerHasBeenStarted(false);
            this.eventManager.fireEvent(EventType.SERVER_STARTING, this);
            try {
                this.embeddedServer = this.embeddedServerFactory.create(new JavalinServlet(this.contextPath, this.pathMatcher, this.exceptionMapper, this.errorMapper, this.jettyWsHandlers, this.javalinWsHandlers, this.logLevel, this.dynamicGzipEnabled, this.defaultContentType, this.defaultCharacterEncoding, this.maxRequestCacheBodySize), this.staticFileConfig);
                log.info("Starting Javalin ...");
                this.port = this.embeddedServer.start(this.port);
                log.info("Javalin has started \\o/");
                this.started = true;
                this.eventManager.fireEvent(EventType.SERVER_STARTED, this);
            }
            catch (Exception e) {
                log.error("Failed to start Javalin", (Throwable)e);
                if (e instanceof BindException && e.getMessage() != null) {
                    if (e.getMessage().toLowerCase().contains("in use")) {
                        log.error("Port already in use. Make sure no other process is using port " + this.port + " and try again.");
                    } else if (e.getMessage().toLowerCase().contains("permission denied")) {
                        log.error("Port 1-1023 require elevated privileges (process must be started by admin).");
                    }
                }
                this.eventManager.fireEvent(EventType.SERVER_START_FAILED, this);
            }
        }
        return this;
    }

    public Javalin stop() {
        this.eventManager.fireEvent(EventType.SERVER_STOPPING, this);
        log.info("Stopping Javalin ...");
        try {
            this.embeddedServer.stop();
        }
        catch (Exception e) {
            log.error("Javalin failed to stop gracefully", (Throwable)e);
        }
        log.info("Javalin has stopped");
        this.eventManager.fireEvent(EventType.SERVER_STOPPED, this);
        return this;
    }

    public Javalin disableStartupBanner() {
        this.ensureActionIsPerformedBeforeServerStart("Telling Javalin to not show banner in logs");
        this.hideBanner = true;
        return this;
    }

    public Javalin dontIgnoreTrailingSlashes() {
        this.ensureActionIsPerformedBeforeServerStart("Telling Javalin to not ignore slashes");
        this.pathMatcher.setIgnoreTrailingSlashes(false);
        return this;
    }

    public Javalin embeddedServer(@NotNull EmbeddedServerFactory embeddedServerFactory) {
        this.ensureActionIsPerformedBeforeServerStart("Setting a custom server");
        this.embeddedServerFactory = embeddedServerFactory;
        return this;
    }

    public Javalin enableStaticFiles(@NotNull String classpathPath) {
        return this.enableStaticFiles(classpathPath, Location.CLASSPATH);
    }

    public Javalin enableStaticFiles(@NotNull String path, @NotNull Location location) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling static files");
        this.staticFileConfig.add(new StaticFileConfig(path, location));
        return this;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Javalin contextPath(@NotNull String contextPath) {
        this.ensureActionIsPerformedBeforeServerStart("Setting the context path");
        this.contextPath = Util.INSTANCE.normalizeContextPath(contextPath);
        return this;
    }

    public int port() {
        return this.port;
    }

    public Javalin port(int port) {
        this.ensureActionIsPerformedBeforeServerStart("Setting the port");
        this.port = port;
        return this;
    }

    public Javalin enableStandardRequestLogging() {
        return this.requestLogLevel(LogLevel.STANDARD);
    }

    public Javalin requestLogLevel(@NotNull LogLevel logLevel) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling request-logging");
        this.logLevel = logLevel;
        return this;
    }

    public Javalin enableCorsForOrigin(String ... origin) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling CORS");
        return CorsUtil.INSTANCE.enableCors(this, origin);
    }

    public Javalin enableCorsForAllOrigins() {
        return this.enableCorsForOrigin("*");
    }

    public Javalin enableDynamicGzip() {
        this.ensureActionIsPerformedBeforeServerStart("Enabling dynamic GZIP");
        this.dynamicGzipEnabled = true;
        return this;
    }

    public Javalin enableRouteOverview(@NotNull String path) {
        this.ensureActionIsPerformedBeforeServerStart("Enabling route overview");
        RouteOverviewUtil.enableRouteOverview(path, this);
        return this;
    }

    public Javalin defaultContentType(@NotNull String contentType) {
        this.ensureActionIsPerformedBeforeServerStart("Changing default content type");
        this.defaultContentType = contentType;
        return this;
    }

    public Javalin defaultCharacterEncoding(@NotNull String characterEncoding) {
        this.ensureActionIsPerformedBeforeServerStart("Changing default character encoding");
        this.defaultCharacterEncoding = characterEncoding;
        return this;
    }

    public Javalin maxBodySizeForRequestCache(long bodySizeInBytes) {
        this.ensureActionIsPerformedBeforeServerStart("Changing request cache body size");
        this.maxRequestCacheBodySize = bodySizeInBytes;
        return this;
    }

    public Javalin disableRequestCache() {
        return this.maxBodySizeForRequestCache(0L);
    }

    private void ensureActionIsPerformedBeforeServerStart(@NotNull String action) {
        if (this.started) {
            throw new IllegalStateException(action + " must be done before starting the server");
        }
    }

    public Javalin accessManager(@NotNull AccessManager accessManager) {
        this.accessManager = accessManager;
        return this;
    }

    public <T extends Exception> Javalin exception(@NotNull Class<T> exceptionClass, @NotNull ExceptionHandler<? super T> exceptionHandler) {
        this.exceptionMapper.getExceptionMap().put(exceptionClass, exceptionHandler);
        return this;
    }

    public Javalin event(@NotNull EventType eventType, @NotNull EventListener eventListener) {
        this.ensureActionIsPerformedBeforeServerStart("Event-mapping");
        this.eventManager.getListenerMap().get((Object)eventType).add(eventListener);
        return this;
    }

    public Javalin error(int statusCode, @NotNull ErrorHandler errorHandler) {
        this.errorMapper.getErrorHandlerMap().put(statusCode, errorHandler);
        return this;
    }

    public Javalin routes(@NotNull ApiBuilder.EndpointGroup endpointGroup) {
        ApiBuilder.setStaticJavalin(this);
        endpointGroup.addEndpoints();
        ApiBuilder.clearStaticJavalin();
        return this;
    }

    private Javalin addHandler(@NotNull HandlerType httpMethod, @NotNull String path, @NotNull Handler handler, List<Role> roles) {
        String prefixedPath = Util.INSTANCE.prefixContextPath(path, this.contextPath);
        Handler handlerWrap = roles == null ? handler : ctx -> this.accessManager.manage(handler, ctx, roles);
        this.pathMatcher.getHandlerEntries().get((Object)httpMethod).add(new HandlerEntry(httpMethod, prefixedPath, handlerWrap));
        this.routeOverviewEntries.add(new RouteOverviewEntry(httpMethod, prefixedPath, handler, roles));
        return this;
    }

    private Javalin addHandler(@NotNull HandlerType httpMethod, @NotNull String path, @NotNull Handler handler) {
        return this.addHandler(httpMethod, path, handler, null);
    }

    public Javalin get(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.GET, path, handler);
    }

    public Javalin post(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.POST, path, handler);
    }

    public Javalin put(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.PUT, path, handler);
    }

    public Javalin patch(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.PATCH, path, handler);
    }

    public Javalin delete(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.DELETE, path, handler);
    }

    public Javalin head(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.HEAD, path, handler);
    }

    public Javalin trace(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.TRACE, path, handler);
    }

    public Javalin connect(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.CONNECT, path, handler);
    }

    public Javalin options(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.OPTIONS, path, handler);
    }

    public Javalin get(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.GET, path, handler, permittedRoles);
    }

    public Javalin post(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.POST, path, handler, permittedRoles);
    }

    public Javalin put(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.PUT, path, handler, permittedRoles);
    }

    public Javalin patch(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.PATCH, path, handler, permittedRoles);
    }

    public Javalin delete(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.DELETE, path, handler, permittedRoles);
    }

    public Javalin head(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.HEAD, path, handler, permittedRoles);
    }

    public Javalin trace(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.TRACE, path, handler, permittedRoles);
    }

    public Javalin connect(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.CONNECT, path, handler, permittedRoles);
    }

    public Javalin options(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        return this.addHandler(HandlerType.OPTIONS, path, handler, permittedRoles);
    }

    public Javalin before(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.BEFORE, path, handler);
    }

    public Javalin before(@NotNull Handler handler) {
        return this.before("*", handler);
    }

    public Javalin after(@NotNull String path, @NotNull Handler handler) {
        return this.addHandler(HandlerType.AFTER, path, handler);
    }

    public Javalin after(@NotNull Handler handler) {
        return this.after("*", handler);
    }

    public String pathFinder(@NotNull Handler handler) {
        return this.pathMatcher.findHandlerPath((Function1<? super HandlerEntry, Boolean>)((Function1)he -> he.getHandler().equals(handler)));
    }

    public String pathFinder(@NotNull Handler handler, @NotNull HandlerType handlerType) {
        return this.pathMatcher.findHandlerPath((Function1<? super HandlerEntry, Boolean>)((Function1)he -> he.getHandler().equals(handler) && he.getType() == handlerType));
    }

    public Javalin ws(@NotNull String path, @NotNull WebSocketConfig ws) {
        WebSocketHandler configuredHandler = new WebSocketHandler(this.contextPath, path);
        ws.configure(configuredHandler);
        this.javalinWsHandlers.add(configuredHandler);
        this.routeOverviewEntries.add(new RouteOverviewEntry(HandlerType.WEBSOCKET, Util.INSTANCE.prefixContextPath(path, this.contextPath), ws, null));
        return this;
    }

    public Javalin ws(@NotNull String path, @NotNull Class webSocketClass) {
        this.routeOverviewEntries.add(new RouteOverviewEntry(HandlerType.WEBSOCKET, Util.INSTANCE.prefixContextPath(path, this.contextPath), webSocketClass, null));
        return this.addWebSocketHandler(path, webSocketClass);
    }

    public Javalin ws(@NotNull String path, @NotNull Object webSocketObject) {
        this.routeOverviewEntries.add(new RouteOverviewEntry(HandlerType.WEBSOCKET, Util.INSTANCE.prefixContextPath(path, this.contextPath), webSocketObject, null));
        return this.addWebSocketHandler(path, webSocketObject);
    }

    private Javalin addWebSocketHandler(@NotNull String path, @NotNull Object webSocketObject) {
        this.ensureActionIsPerformedBeforeServerStart("Configuring WebSockets");
        this.jettyWsHandlers.put(path, webSocketObject);
        return this;
    }

    public List<RouteOverviewEntry> getRouteOverviewEntries() {
        return this.routeOverviewEntries;
    }

    EmbeddedServer embeddedServer() {
        return this.embeddedServer;
    }

    void clearMatcherAndMappers() {
        this.pathMatcher.getHandlerEntries().forEach((__, values) -> values.clear());
        this.errorMapper.getErrorHandlerMap().clear();
        this.exceptionMapper.getExceptionMap().clear();
    }
}

