/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.comm.Buffer;
import com.twosigma.beakerx.kernel.comm.BxComm;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.Data;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.table.handlers.StateRequestMsgCallbackHandler;
import com.twosigma.beakerx.widget.ChangeItem;
import com.twosigma.beakerx.widget.CommActions;
import com.twosigma.beakerx.widget.CommFunctionality;
import com.twosigma.beakerx.widget.CompiledCodeRunner;
import com.twosigma.beakerx.widget.DisplayableWidget;
import com.twosigma.beakerx.widget.WidgetInfo;
import com.twosigma.beakerx.widget.WidgetItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class Widget
implements CommFunctionality,
DisplayableWidget,
WidgetItem,
WidgetInfo {
    private Comm comm;

    public Widget(Comm comm) {
        this.comm = comm;
        this.getComm().addMsgCallbackList(new Handler[]{new StateRequestMsgCallbackHandler(this::stateRequestHandler)});
    }

    public Widget() {
        this(BxComm.createComm());
    }

    public void stateRequestHandler() {
    }

    protected void openComm() {
        this.openComm(Buffer.EMPTY);
    }

    private void openComm(Buffer buffer) {
        this.comm.setData(this.createState());
        this.addValueChangeMsgCallback();
        this.comm.open(buffer);
    }

    protected void openComm(Message parentMessage) {
        this.comm.setData(this.createState());
        this.addValueChangeMsgCallback();
        this.comm.open(parentMessage);
    }

    public void close() {
        if (this.comm != null) {
            this.comm.close();
        }
    }

    public void display() {
        this.beforeDisplay();
        this.sendDisplay();
    }

    protected void beforeDisplay() {
    }

    protected void sendDisplay() {
        HashMap<String, Object> content = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("version_major", 2);
        data.put("version_minor", 0);
        data.put("model_id", this.getComm().getCommId());
        content.put("method", "display_data");
        content.put("application/vnd.jupyter.widget-view+json", data);
        this.getComm().send(JupyterMessages.DISPLAY_DATA, new Data(content));
    }

    protected HashMap<String, Object> createState() {
        String vnv;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("_model_module", this.getModelModuleValue());
        result.put("_view_module", this.getViewModuleValue());
        result.put("_view_module_version", this.getViewModuleVersion());
        result.put("_model_module_version", this.getModelModuleVersion());
        String mn = this.getModelNameValue();
        if (mn != null && !mn.isEmpty()) {
            result.put("_model_name", mn);
        }
        if ((vnv = this.getViewNameValue()) != null && !vnv.isEmpty()) {
            result.put("_view_name", vnv);
        }
        result = this.content(result);
        return result;
    }

    public abstract String getModelNameValue();

    public abstract String getViewNameValue();

    public String getModelModuleValue() {
        return "@jupyter-widgets/controls";
    }

    public String getViewModuleValue() {
        return "@jupyter-widgets/controls";
    }

    public String getModelModuleVersion() {
        return "*";
    }

    public String getViewModuleVersion() {
        return "*";
    }

    protected abstract void addValueChangeMsgCallback();

    protected abstract HashMap<String, Object> content(HashMap<String, Object> var1);

    public Comm getComm() {
        return this.comm;
    }

    public void sendUpdate(String propertyName, Object value) {
        this.sendUpdate(Arrays.asList(new ChangeItem(propertyName, value)));
    }

    public void sendUpdate(String propertyName, Object value, Message parent) {
        this.sendUpdate(Arrays.asList(new ChangeItem(propertyName, value)), parent);
    }

    public void sendUpdate(ChangeItem change) {
        this.sendUpdate(Arrays.asList(change));
    }

    public void sendUpdate(List<ChangeItem> changes) {
        this.comm.sendUpdate(changes);
    }

    public void sendUpdate(List<ChangeItem> changes, Message parent) {
        this.comm.sendUpdate(changes, parent);
    }

    public void sendUpdate(Buffer buffer) {
        this.comm.sendUpdate(buffer);
    }

    public void handleCommEventSync(Message message, CommActions action, ActionPerformed handlerAction) {
        KernelHandlerWrapper.wrapBusyIdle((KernelFunctionality)KernelManager.get(), (Message)message, () -> CompiledCodeRunner.runCommEvent(message, action, handlerAction));
    }

    public void activateWidgetInContainer() {
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    public static interface WidgetDisplayMethodStrategy {
        public void display(Widget var1);
    }

    public static interface ActionPerformed {
        public void executeAction(HashMap var1, Message var2);
    }
}

