/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.restserver.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.BeakerXClient;
import java.io.IOException;

public class GetUrlArgHandler {
    private ObjectMapper objectMapper;
    private BeakerXClient beakerXClient;

    public GetUrlArgHandler(BeakerXClient beakerXClient) {
        this.beakerXClient = beakerXClient;
        this.objectMapper = new ObjectMapper();
    }

    public void handle(String data) {
        try {
            String value = this.getBeakerArgValue(data);
            this.beakerXClient.getMessageQueue("urlarg").put(value == null ? "" : value);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String getBeakerArgValue(String json) {
        try {
            UrlArgBody value = (UrlArgBody)this.objectMapper.readValue(json, UrlArgBody.class);
            return value.argValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class UrlArgBody {
        public String argName;
        public String argValue;
        public String url;
        public String type;
    }
}

