/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagic;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ErrorData;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;

public class ClasspathAddJarMagicCommand
extends ClasspathMagicCommand
implements ClasspathAddJarMagic {
    public ClasspathAddJarMagicCommand(KernelFunctionality kernel, MessageCreatorService messageCreatorService) {
        super(kernel, messageCreatorService);
    }

    public String getMagicCommandName() {
        return "%classpath add jar";
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length > 2 && commandParts[0].equals("%classpath") && commandParts[1].equals("add") && commandParts[2].equals("jar");
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath((String)command);
        if (split.length != 4) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath add jar", this.messageCreatorService);
        }
        String path = split[3];
        return this.addJar(path);
    }

    @Override
    public MagicCommandOutcomeItem addJar(String path) {
        ErrorData errorData = this.isValidPath(path);
        if (errorData.hasError()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, errorData.getMessage(), this.messageCreatorService);
        }
        return this.handleAddedJars(path);
    }
}

